var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { arrow, autoUpdate, computePosition, flip, offset, shift, } from "@floating-ui/dom";
import { h, Host, } from "@stencil/core";
import { OnListener } from "../utils/listener";
import { tooltipController } from "./tooltip-controller";
const numberToPixel = (value) => (value != null ? `${value}px` : '');
/**
 * @slot title-icon - Icon of tooltip title
 * @slot title-content - Content of tooltip title
 *
 * @since 1.4.0
 */
export class Tooltip {
    constructor() {
        this.for = undefined;
        this.titleContent = undefined;
        this.interactive = false;
        this.placement = 'top';
        this.showDelay = 0;
        this.hideDelay = 50;
        this.animationFrame = false;
        this.visible = false;
    }
    get arrowElement() {
        return this.hostElement.shadowRoot.querySelector('.arrow');
    }
    destroyAutoUpdate() {
        if (this.disposeAutoUpdate !== undefined) {
            this.disposeAutoUpdate();
        }
    }
    /** @internal */
    async showTooltip(anchorElement) {
        clearTimeout(this.hideTooltipTimeout);
        await this.applyTooltipPosition(anchorElement);
        this.showTooltipTimeout = setTimeout(() => {
            tooltipController.present(this);
            // Need to compute and apply tooltip position after initial render,
            // because arrow has no valid bounding rect before that
            this.applyTooltipPosition(anchorElement);
        }, this.showDelay);
    }
    /** @internal */
    async hideTooltip() {
        clearTimeout(this.showTooltipTimeout);
        let hideDelay = 50;
        if (this.interactive && this.hideDelay === hideDelay) {
            hideDelay = 150;
        }
        this.hideTooltipTimeout = setTimeout(() => {
            tooltipController.dismiss(this);
        }, hideDelay);
        this.destroyAutoUpdate();
    }
    computeArrowPosition({ placement, middlewareData, }) {
        let { x, y } = middlewareData.arrow;
        if (placement.startsWith('top')) {
            return {
                left: numberToPixel(x),
                top: numberToPixel(y),
            };
        }
        if (placement.startsWith('right')) {
            return {
                left: numberToPixel(-6),
                top: numberToPixel(y),
            };
        }
        if (placement.startsWith('bottom')) {
            return {
                left: numberToPixel(x),
                top: numberToPixel(-6),
            };
        }
        if (placement.startsWith('left')) {
            return {
                right: numberToPixel(-6),
                top: numberToPixel(y),
            };
        }
    }
    async computeTooltipPosition(target) {
        return computePosition(target, this.hostElement, {
            strategy: 'fixed',
            placement: this.placement,
            middleware: [
                shift(),
                offset(12),
                arrow({
                    element: this.arrowElement,
                }),
                flip({
                    fallbackStrategy: 'initialPlacement',
                    padding: 10,
                }),
            ],
        });
    }
    applyTooltipArrowPosition(computeResponse) {
        const arrowPosition = this.computeArrowPosition(computeResponse);
        Object.assign(this.arrowElement.style, arrowPosition);
    }
    async applyTooltipPosition(target) {
        if (!target) {
            return;
        }
        return new Promise((resolve) => {
            this.destroyAutoUpdate();
            this.disposeAutoUpdate = autoUpdate(target, this.hostElement, async () => {
                setTimeout(async () => {
                    const computeResponse = await this.computeTooltipPosition(target);
                    if (computeResponse.middlewareData.arrow) {
                        this.applyTooltipArrowPosition(computeResponse);
                    }
                    const { x, y } = computeResponse;
                    Object.assign(this.hostElement.style, {
                        left: x !== null ? `${x}px` : '',
                        top: y !== null ? `${y}px` : '',
                    });
                    resolve(computeResponse);
                });
            }, {
                ancestorResize: true,
                ancestorScroll: true,
                elementResize: true,
                animationFrame: this.animationFrame,
            });
        });
    }
    clearHideTimeout() {
        if (this.interactive) {
            clearTimeout(this.hideTooltipTimeout);
        }
    }
    async queryAnchorElements() {
        if (typeof this.for === 'string') {
            return Promise.resolve(Array.from(document.querySelectorAll(this.for)));
        }
        if (this.for instanceof HTMLElement) {
            return Promise.resolve([this.for]);
        }
        if (this.for instanceof Promise) {
            const element = await this.for;
            return [element];
        }
    }
    async registerTriggerListener() {
        const triggerElementList = await this.queryAnchorElements();
        if (this.disposeListener) {
            this.disposeListener();
        }
        if (!triggerElementList) {
            return;
        }
        triggerElementList.forEach((element) => {
            const onMouseEnter = () => {
                this.showTooltip(element);
            };
            const onMouseLeave = () => {
                this.hideTooltip();
            };
            const onFocusIn = () => {
                if (this.showTooltipTimeout !== undefined) {
                    clearTimeout(this.showTooltipTimeout);
                }
                onMouseEnter();
            };
            const onFocusOut = () => {
                this.hideTooltip();
            };
            element.addEventListener('mouseenter', onMouseEnter);
            element.addEventListener('mouseleave', onMouseLeave);
            element.addEventListener('focusin', onFocusIn);
            element.addEventListener('focusout', onFocusOut);
            this.disposeListener = () => {
                element.removeEventListener('mouseenter', onMouseEnter);
                element.removeEventListener('mouseleave', onMouseLeave);
                element.removeEventListener('focusin', onFocusIn);
                element.removeEventListener('focusout', onFocusOut);
            };
        });
    }
    registerTooltipListener() {
        const { hostElement } = this;
        hostElement.addEventListener('mouseenter', () => this.clearHideTimeout());
        hostElement.addEventListener('focusin', () => this.clearHideTimeout());
        hostElement.addEventListener('mouseleave', () => this.hideTooltip());
        hostElement.addEventListener('focusout', () => this.hideTooltip());
    }
    async onKeydown(event) {
        if (event.code === 'Escape') {
            this.hideTooltip();
        }
    }
    componentWillLoad() {
        this.registerTriggerListener();
    }
    componentDidLoad() {
        this.observer = new MutationObserver(() => {
            this.registerTriggerListener();
        });
        this.observer.observe(document.body, {
            attributes: true,
            attributeFilter: ['data-ix-tooltip'],
            childList: true,
            subtree: true,
        });
        this.registerTooltipListener();
    }
    connectedCallback() {
        tooltipController.connected(this);
    }
    disconnectedCallback() {
        var _a;
        (_a = this.observer) === null || _a === void 0 ? void 0 : _a.disconnect();
        this.destroyAutoUpdate();
        tooltipController.disconnected(this);
    }
    isPresent() {
        return this.visible;
    }
    present() {
        this.visible = true;
    }
    dismiss() {
        this.visible = false;
    }
    render() {
        return (h(Host, { key: '5d57bd50e4b54e59eef7e0ec463cf9cadba6ddc4', class: {
                visible: this.visible,
            }, role: "tooltip" }, h("div", { key: '004a422b325b2c26639e479f3bc6a832277c38db', class: 'tooltip-title' }, h("slot", { key: 'dfb6ebe4022d3835b11d7237438358e8dd27191d', name: "title-icon" }), h("ix-typography", { key: 'e4230c3e9c28f53d217e8653fd972749af995dde', variant: "default-title" }, this.titleContent, h("slot", { key: 'bfd75a3ae808f03a552271a9f10c896de28072e2', name: "title-content" }))), h("div", { key: 'b8c20ae1bb16343dca997ecb2ef744d8b18b6ede', class: 'tooltip-content' }, h("slot", { key: 'cb15413ddd0b35a6ceb5dd95beebc855131fb998' })), h("div", { key: '91e9df64725d3ce40f280640374f0e95f89cf67b', class: "arrow" })));
    }
    static get is() { return "ix-tooltip"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["tooltip.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["tooltip.css"]
        };
    }
    static get properties() {
        return {
            "for": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string | HTMLElement | Promise<HTMLElement>",
                    "resolved": "HTMLElement | Promise<HTMLElement> | string",
                    "references": {
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        },
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "CSS selector for hover trigger element e.g. `for=\"[data-my-custom-select]\"`"
                },
                "attribute": "for",
                "reflect": false
            },
            "titleContent": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Title of the tooltip"
                },
                "attribute": "title-content",
                "reflect": false
            },
            "interactive": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Define if the user can access the tooltip via mouse."
                },
                "attribute": "interactive",
                "reflect": false,
                "defaultValue": "false"
            },
            "placement": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'top' | 'right' | 'bottom' | 'left'",
                    "resolved": "\"bottom\" | \"left\" | \"right\" | \"top\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Initial placement of the tooltip. If the placement don\"t have enough space,\nthe tooltip will placed on another location."
                },
                "attribute": "placement",
                "reflect": false,
                "defaultValue": "'top'"
            },
            "showDelay": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "show-delay",
                "reflect": false,
                "defaultValue": "0"
            },
            "hideDelay": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "hide-delay",
                "reflect": false,
                "defaultValue": "50"
            },
            "animationFrame": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "animation-frame",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "visible": {}
        };
    }
    static get methods() {
        return {
            "showTooltip": {
                "complexType": {
                    "signature": "(anchorElement: Element) => Promise<void>",
                    "parameters": [{
                            "name": "anchorElement",
                            "type": "Element",
                            "docs": ""
                        }],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "Element": {
                            "location": "import",
                            "path": "@stencil/core",
                            "id": ""
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "hideTooltip": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
__decorate([
    OnListener('keydown', (self) => self.visible)
], Tooltip.prototype, "onKeydown", null);
//# sourceMappingURL=tooltip.js.map
