/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Fragment, h, Host, } from "@stencil/core";
export class WorkflowStep {
    constructor() {
        this.vertical = false;
        this.disabled = false;
        this.status = 'open';
        this.clickable = false;
        this.selected = false;
        this.position = 'undefined';
        this.iconName = 'circle';
        this.iconColor = 'workflow-step-icon-default--color';
    }
    selectedHandler() {
        const selectedStyle = this.selected ? '--selected' : '';
        if (this.status === 'open') {
            this.iconName = this.selected ? 'circle-dot' : 'circle';
            this.iconColor = `workflow-step-icon-default--color${selectedStyle}`;
        }
        if (this.status === 'done' && !this.disabled) {
            this.iconColor = `workflow-step-icon-done--color${selectedStyle}`;
        }
    }
    watchPropHandler() {
        switch (this.status) {
            case 'open':
                this.iconName = 'circle';
                this.iconColor = 'workflow-step-icon-default--color';
                break;
            case 'success':
                this.iconName = 'success';
                this.iconColor = 'color-success';
                break;
            case 'done':
                this.iconName = 'success';
                this.iconColor = 'workflow-step-icon-done--color';
                break;
            case 'warning':
                this.iconName = 'warning';
                this.iconColor = 'color-warning';
                break;
            case 'error':
                this.iconName = 'error';
                this.iconColor = 'color-alarm';
                break;
            default:
                this.iconName = 'circle';
                break;
        }
        if (this.disabled) {
            this.iconColor = 'workflow-step-icon-success--color--disabled';
        }
    }
    componentWillLoad() {
        this.watchPropHandler();
        this.selectedHandler();
        this.customIconSlot = !!this.hostElement.querySelector('[slot="custom-icon"]');
    }
    onStepClick() {
        if (!this.disabled && this.clickable) {
            this.selectedChanged.emit(this.hostElement);
        }
    }
    render() {
        const icons = !this.customIconSlot ? (h(Fragment, null, h("ix-icon", { color: "color-1", name: this.iconName === 'warning' ? 'triangle-filled' : 'circle-filled', class: "absolute", size: "24" }), h("ix-icon", { color: this.iconColor, name: this.iconName, class: "absolute", size: "24" }))) : null;
        return (h(Host, { key: '399801862cd971d7a8ed9762cb95b391cce9af01', class: { 'host-vertical': this.vertical }, onClick: () => this.onStepClick() }, h("div", { key: '537f3ef137c71f2f4c24ac79e3ec1dcf577aa0dc', tabIndex: 0, class: {
                step: true,
                selected: this.selected,
                vertical: this.vertical,
                disabled: this.disabled,
                clickable: this.clickable && !this.disabled,
            } }, h("div", { key: '2b6c5f19e60bd856a1245e86ddd82b5cf9cbc1b7', class: "wrapper" }, h("div", { key: '40014bcae469af2dfb898b9542389436985f5df7', class: {
                line: true,
                selected: this.selected,
                [this.status]: true,
                [this.position]: true,
            } }), h("div", { key: '878858a64710d9046d1707030f71c008c82f4b46', class: "iconWrapper" }, icons, h("slot", { key: '6a409ec904e6ab261ab76a5054d34bc7f52ca6d4', name: "custom-icon" }))), h("div", { key: '592e6f274fca0c93513451c1a8c534a4657ba7bb', class: "text" }, h("slot", { key: 'f5a005065392ade2f520ba18fdf29e0d43ac2036' })))));
    }
    static get is() { return "ix-workflow-step"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["workflow-step.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["workflow-step.css"]
        };
    }
    static get properties() {
        return {
            "vertical": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Select orientation"
                },
                "attribute": "vertical",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Set disabled"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "status": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'open' | 'success' | 'done' | 'warning' | 'error'",
                    "resolved": "\"done\" | \"error\" | \"open\" | \"success\" | \"warning\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Set status"
                },
                "attribute": "status",
                "reflect": false,
                "defaultValue": "'open'"
            },
            "clickable": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Activate navigation click"
                },
                "attribute": "clickable",
                "reflect": false,
                "defaultValue": "false"
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Set selected"
                },
                "attribute": "selected",
                "reflect": false,
                "defaultValue": "false"
            },
            "position": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'first' | 'last' | 'single' | 'undefined'",
                    "resolved": "\"first\" | \"last\" | \"single\" | \"undefined\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": "Activate navigation click"
                },
                "attribute": "position",
                "reflect": false,
                "defaultValue": "'undefined'"
            }
        };
    }
    static get states() {
        return {
            "iconName": {},
            "iconColor": {}
        };
    }
    static get events() {
        return [{
                "method": "selectedChanged",
                "name": "selectedChanged",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "HTMLIxWorkflowStepElement",
                    "resolved": "HTMLIxWorkflowStepElement",
                    "references": {
                        "HTMLIxWorkflowStepElement": {
                            "location": "global",
                            "id": "global::HTMLIxWorkflowStepElement"
                        }
                    }
                }
            }];
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "selected",
                "methodName": "selectedHandler"
            }, {
                "propName": "disabled",
                "methodName": "watchPropHandler"
            }, {
                "propName": "status",
                "methodName": "watchPropHandler"
            }];
    }
}
//# sourceMappingURL=workflow-step.js.map
