import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-5429f20b.js';
import { c as createMutationObserver } from './mutation-observer-db8757e6.js';
import { h as hasSlottedElements } from './shadow-dom-60e9243d.js';

const groupCss = ":host{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;flex-direction:column;position:relative;max-width:19.75rem;border-color:var(--theme-group-item--border-color)}:host .group-header{height:4rem;min-height:4rem;max-height:4rem;border-radius:var(--theme-group--border-radius) var(--theme-group--border-radius) 0 0;display:flex;background-color:var(--theme-group-item--background);color:var(--theme-group-header--color);cursor:pointer}:host .group-header:not(.disabled):not(:disabled){cursor:pointer}:host .group-header:not(.disabled):not(:disabled):hover{background-color:var(--theme-group-item--background--hover)}:host .group-header:not(.disabled):not(:disabled):hover.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header:not(.disabled):not(:disabled){cursor:pointer}:host .group-header:not(.disabled):not(:disabled):active,:host .group-header:not(.disabled):not(:disabled).active{background-color:var(--theme-group-item--background--active)}:host .group-header:not(.disabled):not(:disabled):active.selected,:host .group-header:not(.disabled):not(:disabled).active.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header:not(.disabled):not(:disabled):focus-visible{border:1px solid var(--theme-color-focus-bdr);border-radius:var(--theme-default-border-radius) var(--theme-default-border-radius) 0px 0px;outline:none}:host .group-header.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header.selected .group-header-selection-indicator{background-color:var(--theme-group-item-indicator--background--selected)}:host .group-header .group-header-selection-indicator{background-color:var(--theme-color-input--focus)}:host .group-header .group-header-selection-indicator.group-header-selection-indicator-item-selected{background-color:var(--theme-group-item-indicator--background--selected)}:host .group-header-clickable{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;width:100%;min-width:0}:host .group-header-selection-indicator{width:0.25rem;border-top-left-radius:var(--theme-group--border-radius)}:host .group-header-content{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;flex-direction:row;justify-content:space-between;min-width:0;flex-grow:1;flex-basis:0;padding:0.5rem;padding-left:0}:host .group-header-content .group-header-props-container{width:100%}:host .group-header-content .group-header-title{display:flex;align-items:center;font-size:1rem;font-weight:700;height:1.5rem}:host .group-header-content .group-header-title>*{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;min-width:0;padding-right:0}:host .group-header-content .group-subheader{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;height:1.25rem;font-size:0.875rem;color:var(--theme-group-subheader--color)}:host .expand-icon{padding:0.125rem 0.437rem;color:var(--theme-color-std-text)}:host .btn-expand-header{margin:0.5rem;margin-inline-end:0.25rem;min-width:1.5rem}:host .group-content{display:flex;flex-direction:column;gap:1px;margin-top:1px}:host .footer{visibility:collapse;height:auto;min-height:0}:host .footer-visible{visibility:visible}:host .hidden{display:none}";
const IxGroupStyle0 = groupCss;

const Group = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.selectGroup = createEvent(this, "selectGroup", 7);
        this.selectItem = createEvent(this, "selectItem", 7);
        this.collapsedChanged = createEvent(this, "collapsedChanged", 7);
        this.observer = null;
        this.suppressHeaderSelection = false;
        this.header = undefined;
        this.subHeader = undefined;
        this.collapsed = true;
        this.selected = false;
        this.index = undefined;
        this.expandOnHeaderClick = false;
        this.itemSelected = false;
        this.slotSize = this.groupItems.length;
        this.footerVisible = false;
        this.showExpandCollapsedIcon = false;
    }
    get dropdownItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-group-dropdown-item'));
    }
    get groupItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-group-item:not(.footer)'));
    }
    get groupContent() {
        var _a;
        return (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('.group-content');
    }
    onExpandClick(event) {
        this.collapsed = !this.collapsed;
        this.collapsedChanged.emit(this.collapsed);
        event.stopPropagation();
    }
    onHeaderClick(event) {
        this.setGroupSelection(!this.selected);
        if (this.suppressHeaderSelection) {
            this.onExpandClick(event);
        }
    }
    onItemClick(index) {
        const newIndex = index === this.index ? undefined : index;
        this.selectItem.emit(newIndex);
        this.index = newIndex;
        if (this.index !== undefined && this.index >= 0) {
            this.itemSelected = true;
        }
        else
            this.itemSelected = false;
        this.setGroupSelection(false);
    }
    setGroupSelection(selection) {
        if (!this.suppressHeaderSelection) {
            this.selected = selection;
            this.selectGroup.emit(this.selected);
        }
    }
    onSlotChange() {
        var _a;
        const slot = (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('slot[name="footer"]');
        if (slot) {
            this.footerVisible = hasSlottedElements(slot);
        }
    }
    componentWillRender() {
        this.groupItems.forEach((item, index) => {
            if (this.selected === true) {
                item.selected = false;
                this.index = undefined;
                this.itemSelected = false;
                return;
            }
            item.selected = index === this.index;
            item.index = index;
        });
    }
    componentDidLoad() {
        var _a;
        this.observer = createMutationObserver(() => {
            this.slotSize = this.groupItems.length;
        });
        if (!this.groupContent) {
            return;
        }
        this.observer.observe(this.groupContent, {
            childList: true,
        });
        (_a = this.groupContent) === null || _a === void 0 ? void 0 : _a.addEventListener('selectedChanged', (evt) => {
            if (evt.detail.suppressSelection) {
                evt.stopPropagation();
                return;
            }
            this.onItemClick(evt.detail.index);
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    render() {
        return (h(Host, { key: '8153fe3f0c5fd78f733287dacb9fb5cfd23e624c' }, h("div", { key: '109139ea65795878ffd08e539ef5a59ade8c05ba', class: {
                'group-header': true,
                expand: !this.collapsed,
                selected: this.selected,
            }, tabindex: "0" }, h("div", { key: '262c00872bbfb8958de008e6a5d9f847a6121777', class: "group-header-clickable", onClick: (e) => this.onHeaderClick(e) }, h("div", { key: 'c64dc6333e5b8cd876d5dac4ed294885fa9d97db', class: {
                'group-header-selection-indicator': true,
                'group-header-selection-indicator-item-selected': this.itemSelected,
            } }), h("div", { key: 'b295acc0552867f1d97803cf7ffa2fcdafe30931', class: "btn-expand-header" }, h("ix-icon", { key: 'd0b798aa02a970d77d1636ff38677f2b5777dc0b', "data-testid": "expand-collapsed-icon", class: {
                hidden: !this.showExpandCollapsedIcon,
            }, name: this.collapsed ? 'chevron-right-small' : 'chevron-down-small', onClick: (e) => this.onExpandClick(e) })), h("div", { key: 'fa7a41f9e379ec4972d1c3db364f0ab82e57a0b5', class: "group-header-content" }, this.header ? (h("div", { class: "group-header-props-container" }, h("div", { class: "group-header-title" }, h("span", { title: this.header }, this.header)), h("div", { class: "group-subheader", title: this.subHeader }, this.subHeader))) : null, h("slot", { key: '4caba82a4558a06a999723d52dd05ed1c19c772b', name: "header" }))), h("ix-group-context-menu", { key: 'ca29c2ff305e9a0ba11299771cdb27c509cf887c' }, h("slot", { key: 'dfd21416520cac904b790be7fceb0f02f8ef630d', name: "dropdown" }))), h("div", { key: '07470786706f46bd197ea7ff9ce6b0b97d8b114a', class: {
                'group-content': true,
            } }, h("div", { key: 'f9ec75f57035ff5583dd728d34907139f7d787f5', style: {
                display: this.collapsed ? 'none' : 'contents',
            } }, h("slot", { key: 'bc86c0d2b2cc896e350c61aeb98896979ffb3647', onSlotchange: () => {
                var _a;
                const slot = (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('slot:not([name])');
                this.showExpandCollapsedIcon = hasSlottedElements(slot);
            } }), h("ix-group-item", { key: 'ad82143a05418d19517e06205452ed1db0367258', suppressSelection: true, focusable: false, class: {
                footer: true,
                'footer-visible': this.footerVisible,
            } }, h("slot", { key: 'e4aec4e664f7f4479e9be7d90bec9ea19c1b8677', name: "footer", onSlotchange: () => this.onSlotChange() }))))));
    }
    get hostElement() { return getElement(this); }
};
Group.style = IxGroupStyle0;

export { Group as ix_group };

//# sourceMappingURL=ix-group.entry.js.map