import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { a as anime } from './anime.es.js';
import { u as useContextProvider, A as ApplicationLayoutContext } from './context.js';
import { d as defineCustomElement$8 } from './application-header.js';
import { d as defineCustomElement$7 } from './dropdown.js';
import { d as defineCustomElement$6 } from './icon-button.js';
import { d as defineCustomElement$5 } from './map-navigation-overlay.js';
import { d as defineCustomElement$4 } from './menu-expand-icon.js';
import { d as defineCustomElement$3 } from './spinner.js';
import { d as defineCustomElement$2 } from './typography.js';

const mapNavigationCss = ":host{display:flex;position:relative;width:100%;height:100%}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .map-nav{display:flex;margin-left:3.25rem;position:relative;height:100%;flex-grow:1;overflow:hidden}:host .map-nav-sidebar{display:flex;flex-direction:column;align-items:center;width:29.75rem;max-width:29.75rem;min-width:29.75rem;height:100%;left:4rem;background-color:var(--theme-map-navigation--background);border-inline-end:0.125rem solid var(--theme-map-navigation-separator--background);z-index:99}:host .map-nav-sidebar-content{align-items:center;position:relative;overflow:auto;height:100%;width:100%}:host .map-nav-sidebar-content .map-nav-sidebar-static-content{-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:1.375rem;font-weight:700;line-height:1.455em;color:var(--theme-color-std-text);display:flex;justify-content:space-between;margin-top:0.437rem;margin-bottom:0.812rem;margin-left:1rem;margin-right:1rem}:host .map-nav-header{display:flex;position:relative;align-items:center;height:3.5rem;min-height:3.5rem;width:100%}:host .map-nav-header .map-nav-header-brand{background-color:var(--theme-map-navigation-background);padding-left:1rem;padding-right:1rem;padding-bottom:0.625rem;height:100%;width:100%;--theme-app-header--color:var(--theme-map-navigation-header--color);--theme-app-header-logo--color:var(--theme-map-navigation-logo--color)}:host .map-nav-header .map-nav-header-brand button{margin-left:1rem}:host .map-nav-header-content{display:flex;height:3.5rem;align-items:center;overflow:hidden;padding:0 1rem}:host .map-nav-header-content.empty{height:0}:host .map-nav-title{-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:1.375rem;font-weight:700;line-height:1.455em;color:var(--theme-color-std-text);display:flex;align-items:center;flex-grow:1}:host .content{display:block;flex-grow:1;position:relative;height:100%;overflow:hidden;z-index:calc(var(--theme-z-index-sticky) - 1)}:host ::slotted(ix-menu){position:absolute}";
const IxMapNavigationStyle0 = mapNavigationCss;

const MapNavigation = /*@__PURE__*/ proxyCustomElement(class MapNavigation extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.navigationToggled = createEvent(this, "navigationToggled", 7);
        this.contextMenuClick = createEvent(this, "contextMenuClick", 7);
        this.applicationName = undefined;
        this.navigationTitle = undefined;
        this.hideContextMenu = true;
        this.isSidebarOpen = true;
        this.hasContentHeader = false;
    }
    get menu() {
        return this.hostElement.querySelector('ix-menu');
    }
    get menuOverlay() {
        return this.hostElement.querySelector('ix-menu-overlay');
    }
    get mapNavMenu() {
        return this.hostElement.shadowRoot.querySelector('.map-nav-menu');
    }
    get sidebar() {
        return this.hostElement.shadowRoot.querySelector('.map-nav-sidebar');
    }
    get overlay() {
        return this.hostElement.shadowRoot.querySelector('#overlay');
    }
    componentDidRender() {
        this.appendMenu();
        this.closeOverlay();
    }
    componentWillLoad() {
        useContextProvider(this.hostElement, ApplicationLayoutContext, {
            hideHeader: false,
            host: 'map-navigation',
        });
    }
    appendMenu() {
        this.menu.addEventListener('mapExpandChange', (event) => {
            const state = !event.detail;
            this.toggleSidebar(state);
        });
        this.menu.enableMapExpand = true;
    }
    /**
     * Change the visibility of the sidebar
     *
     * @param show new visibility state
     * @since 1.6.0
     */
    async toggleSidebar(show) {
        if (show !== undefined) {
            this.isSidebarOpen = show;
        }
        else {
            this.isSidebarOpen = !this.isSidebarOpen;
        }
        if (this.isSidebarOpen) {
            this.openSidebar();
        }
        else {
            this.closeSidebar();
        }
        this.navigationToggled.emit(this.isSidebarOpen);
        this.menu.toggleMapExpand(this.isSidebarOpen);
    }
    closeSidebar() {
        anime({
            targets: this.sidebar,
            duration: MapNavigation.defaultTime,
            marginLeft: [0, '-29.75rem'],
            opacity: [1, 0],
            easing: 'easeInSine',
            complete: () => {
                this.sidebar.classList.add('d-none');
            },
        });
    }
    openSidebar() {
        anime({
            targets: this.sidebar,
            duration: MapNavigation.defaultTime,
            marginLeft: ['-29.75rem', 0],
            opacity: [0, 1],
            easing: 'easeOutSine',
            begin: () => {
                this.sidebar.classList.remove('d-none');
            },
        });
    }
    /**
     * Open a overlay inside content area
     * @deprecated Will be removed in 2.0.0. Use slot based approach
     *
     * @param name
     * @param component
     * @param icon
     * @param color
     */
    async openOverlay(name, component, icon, color) {
        anime({
            targets: this.overlay,
            duration: MapNavigation.slowTime,
            backdropFilter: [0, 'blur(1rem)'],
            translateX: ['-4rem', 0],
            opacity: [0, 1],
            easing: 'easeOutSine',
            begin: () => {
                this.overlay.classList.remove('d-none');
            },
        });
        const overlayInstance = document.createElement('ix-map-navigation-overlay');
        overlayInstance.setAttribute('color', color);
        overlayInstance.setAttribute('name', name);
        overlayInstance.setAttribute('icon', icon);
        overlayInstance.setAttribute('slot', 'overlay');
        overlayInstance.addEventListener('closeClick', () => this.closeOverlay());
        overlayInstance.appendChild(component);
        this.hostElement.appendChild(overlayInstance);
    }
    /**
     * Close current shown overlay
     * @deprecated Will be removed in 2.0.0. Use slot based approach
     */
    async closeOverlay() {
        anime({
            targets: this.overlay,
            duration: MapNavigation.slowTime,
            backdropFilter: ['blur(1rem)', 0],
            translateX: [0, '-4rem'],
            opacity: [1, 0],
            easing: 'easeInSine',
            complete: () => {
                var _a;
                if (!this.overlay) {
                    return;
                }
                (_a = this.overlay.firstChild) === null || _a === void 0 ? void 0 : _a.remove();
                this.overlay.classList.add('d-none');
            },
        });
    }
    checkHasContentHeader(e) {
        const nodes = e.currentTarget.assignedNodes({
            flatten: true,
        });
        this.hasContentHeader = (nodes === null || nodes === void 0 ? void 0 : nodes.length) !== 0;
    }
    render() {
        return (h(Host, { key: 'cb5c6f39555fbd806f1eca16919c277843a23351' }, h("slot", { key: '9da04acd9ef3e5b8f322669406f9ad4b812c9c79', name: "menu" }), h("div", { key: 'dced8e859776aa7d9923156a91fb149e9409af31', class: "map-nav" }, h("div", { key: '97fb4b6ff84005e96873680cfe32c7a2b33b7c0e', class: "map-nav-sidebar" }, h("div", { key: '1f069b0b89c0993df6ad24fba1335a5cb2cd2083', class: "map-nav-header" }, h("ix-application-header", { key: 'bbb0e01ae9194aed17711514b70124704831f7ac', name: this.applicationName, class: "map-nav-header-brand" }, h("slot", { key: '78b9d282b03368708a5a4a6197fccfcd586ae16f', slot: "logo", name: "logo" }))), h("div", { key: '061ae2f057117ac51f9baa296940cddc66c89d23', class: "map-nav-sidebar-content" }, h("div", { key: 'f5d5adb2daf4ba5212e7bf66ddc860431e453f1b', class: "map-nav-sidebar-static-content" }, h("div", { key: '07f6bebd3988744a4e03b61a5f30ecce310bba85', class: "map-nav-title" }, this.navigationTitle), this.hideContextMenu ? ('') : (h("ix-icon-button", { icon: 'context-menu', ghost: true, size: "24", variant: "secondary", onClick: (_) => this.contextMenuClick.emit() }))), h("div", { key: '2ac8e086d83fc82409f5bfd1ecea2ba66eb06606', class: "map-nav-sidebar-user-content" }, h("slot", { key: 'f447fb6a5995ddb0ea0c08e3101c2d7ab29805f4', name: "sidebar-content" })))), h("div", { key: 'be19906feccbba5e0fd4736df63afa4584b2ab1f', class: "content" }, h("div", { key: 'bf1127e632cc4b7ee9f5afb8cc51aabc8abe5600', class: {
                'map-nav-header-content': true,
                'bg-2': true,
                empty: !this.hasContentHeader,
            } }, h("slot", { key: '803807a9158ad13f04e6e66c5472c527dde93a4a', name: "content-header", onSlotchange: (e) => this.checkHasContentHeader(e) })), h("main", { key: 'ae117dd7c985f85cede7303f459c9a00b1981ba0' }, h("slot", { key: 'b3d43c7ab67a52d5bfe07c63da2197fa0db1b9f4' }), h("slot", { key: 'eac80e880d505ca915b96c01aedddd2685c41ad7', name: "overlay" }))))));
    }
    get hostElement() { return this; }
    static get style() { return IxMapNavigationStyle0; }
}, [1, "ix-map-navigation", {
        "applicationName": [1, "application-name"],
        "navigationTitle": [1, "navigation-title"],
        "hideContextMenu": [4, "hide-context-menu"],
        "isSidebarOpen": [32],
        "hasContentHeader": [32],
        "toggleSidebar": [64],
        "openOverlay": [64],
        "closeOverlay": [64]
    }]);
MapNavigation.defaultTime = 150;
MapNavigation.slowTime = 500;
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-map-navigation", "ix-application-header", "ix-dropdown", "ix-icon-button", "ix-map-navigation-overlay", "ix-menu-expand-icon", "ix-spinner", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-map-navigation":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, MapNavigation);
            }
            break;
        case "ix-application-header":
            if (!customElements.get(tagName)) {
                defineCustomElement$8();
            }
            break;
        case "ix-dropdown":
            if (!customElements.get(tagName)) {
                defineCustomElement$7();
            }
            break;
        case "ix-icon-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ix-map-navigation-overlay":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-menu-expand-icon":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-spinner":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxMapNavigation = MapNavigation;
const defineCustomElement = defineCustomElement$1;

export { IxMapNavigation, defineCustomElement };

//# sourceMappingURL=ix-map-navigation.js.map