import { h, Host } from "@stencil/core";
/**
 * @since 1.6.0
 */
export class Card {
    constructor() {
        this.variant = 'insight';
        this.selected = undefined;
    }
    render() {
        return (h(Host, { key: '4d096be9c3db2847204633f22624296d892e2fb9', class: {
                selected: this.selected,
                [`card-${this.variant}`]: true,
            } }, h("div", { key: 'e80707eb333158ac4f90fa0feaaede7309fa3567', class: "card-content" }, h("slot", { key: '50b6d4885936ff438c4fcab7c7b1b9d5e54137f3' })), h("div", { key: 'c964e703c4c7783fd30a889838583d8e0426994b', class: "card-footer" }, h("slot", { key: 'df4b7c7e9f8fbdea42c2e9b657dc6e4488ea4562', name: "card-accordion" }))));
    }
    static get is() { return "ix-card"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["card.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["card.css"]
        };
    }
    static get properties() {
        return {
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "CardVariant",
                    "resolved": "\"alarm\" | \"critical\" | \"filled\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"outline\" | \"primary\" | \"success\" | \"warning\"",
                    "references": {
                        "CardVariant": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/card/card.tsx",
                            "id": "src/components/card/card.tsx::CardVariant"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "variant insight and notification will be removed in 3.0. Use 'outline' or 'filled' instead."
                        }],
                    "text": "Card variant"
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "'insight'"
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.1.0"
                        }],
                    "text": ""
                },
                "attribute": "selected",
                "reflect": false
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=card.js.map
