/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 1.6.0
 */
export class EmptyState {
    constructor() {
        this.layout = 'large';
        this.icon = undefined;
        this.header = undefined;
        this.subHeader = undefined;
        this.action = undefined;
    }
    render() {
        return (h(Host, { key: '6a35699c05f5c71ac06952275054124e827f11d1', class: `emptyState emptyState--${this.layout}` }, this.icon && (h("div", { key: 'd5461a77a1e97b201bc93735b9984071f5bbb8eb', class: "emptyState__icon" }, h("ix-icon", { key: '540eb6f4f0413685dc4b5dec247e79b1ab7c984f', name: this.icon, size: this.layout === 'large' ? '32' : '32', color: "color-soft-text" }))), h("div", { key: '30d14aa2ca5f1b6597ee1e7aefa930f6592f1b7b', class: "emptyState__content" }, h("div", { key: 'c3f75186476392f25251701003bba78d23f7a2bb', class: "content__label" }, h("ix-typography", { key: '357899084359203cc8b06f508658462ed04f9241', variant: this.layout === 'large' ? 'display-large' : 'default' }, this.header), this.subHeader && (h("div", { key: 'a0ce178dc2ab263ec5e1a6627aeb740fce0539fd', class: "label__subHeader" }, this.subHeader))), this.action && (h("div", { key: 'ce163e65fb307b5c5b32fd63e1750caa7456ff41', class: "content__action" }, h("ix-button", { key: '3e32f02186912b49a2b7e9e314531e2a26b79a3b', onClick: () => this.actionClick.emit() }, this.action))))));
    }
    static get is() { return "ix-empty-state"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["empty-state.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["empty-state.css"]
        };
    }
    static get properties() {
        return {
            "layout": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "EmptyStateLayout",
                    "resolved": "\"compact\" | \"compactBreak\" | \"large\"",
                    "references": {
                        "EmptyStateLayout": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/empty-state/empty-state.tsx",
                            "id": "src/components/empty-state/empty-state.tsx::EmptyStateLayout"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state layout - one of 'large', 'compact' or 'compactBreak'"
                },
                "attribute": "layout",
                "reflect": false,
                "defaultValue": "'large'"
            },
            "icon": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state icon"
                },
                "attribute": "icon",
                "reflect": false
            },
            "header": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Empty state header"
                },
                "attribute": "header",
                "reflect": false
            },
            "subHeader": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state sub header"
                },
                "attribute": "sub-header",
                "reflect": false
            },
            "action": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state action"
                },
                "attribute": "action",
                "reflect": false
            }
        };
    }
    static get events() {
        return [{
                "method": "actionClick",
                "name": "actionClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Empty state action click event"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=empty-state.js.map
