/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { getSlottedElements } from "../utils/shadow-dom";
export class GroupContextMenu {
    constructor() {
        this.showContextMenu = false;
    }
    getTrigger() {
        return this.hostElement;
    }
    configureDropdown(dropdownElement, triggerElement) {
        dropdownElement.positioningStrategy = 'fixed';
        dropdownElement.trigger = triggerElement;
    }
    onSlotChange() {
        const slot = this.hostElement.shadowRoot.querySelector('slot');
        if (!slot) {
            return;
        }
        const elements = getSlottedElements(slot);
        this.showContextMenu = elements.length !== 0;
        const dropdownElement = elements.find((elm) => elm.tagName === 'IX-DROPDOWN');
        const triggerElement = this.getTrigger();
        if (!triggerElement) {
            return;
        }
        if (!dropdownElement) {
            return;
        }
        this.configureDropdown(dropdownElement, triggerElement);
    }
    render() {
        return (h(Host, { key: '21c0c5e986892c5e94644b6988b93f04cc2d52e4' }, h("ix-icon-button", { key: 'da9e1ea025d3b0f4afaa9bcb9769a4771f04e98e', class: { hide: !this.showContextMenu }, size: "24", ghost: true, icon: 'context-menu' }), h("slot", { key: '29312b85ab7e60ce075cbe95d40e1e7e7e492640', onSlotchange: () => this.onSlotChange() })));
    }
    static get is() { return "ix-group-context-menu"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["./group-context-menu.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["group-context-menu.css"]
        };
    }
    static get states() {
        return {
            "showContextMenu": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=group-context-menu.js.map
