/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @slot custom-value - Optional custom value at key value instead of text value
 *
 * @since 1.6.0
 */
export class KeyValue {
    constructor() {
        this.icon = undefined;
        this.label = undefined;
        this.labelPosition = 'top';
        this.value = undefined;
    }
    render() {
        return (h(Host, { key: '8431e1a89798f462874f9357d36bd0535c19da6c', class: `keyValue keyValue--${this.labelPosition === 'top' ? 'column' : 'row'}` }, this.icon && (h("ix-icon", { key: '193efc04890c932b8f5c0d075539dec5f49dc37c', name: this.icon, size: "24", class: "keyValue__icon" })), h("div", { key: '8fe5d19dd71dab858d1b70689649e9c50ba610a2', class: "keyValue__content" }, h("div", { key: 'd8b2eee83899e12fe88afb3e453ca1a00560a200', class: "content__label" }, this.label), h("div", { key: 'b0aef82462c4dbdd4cc0f0b878b5684f7154cb8f', class: {
                content__value: true,
                'has-customValue': this.value === undefined,
            } }, this.value !== undefined ? (this.value) : (h("slot", { name: "custom-value" }))))));
    }
    static get is() { return "ix-key-value"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["key-value.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["key-value.css"]
        };
    }
    static get properties() {
        return {
            "icon": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value icon"
                },
                "attribute": "icon",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Key value label"
                },
                "attribute": "label",
                "reflect": false
            },
            "labelPosition": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "KeyValueLabelPosition",
                    "resolved": "\"left\" | \"top\"",
                    "references": {
                        "KeyValueLabelPosition": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/key-value/key-value.tsx",
                            "id": "src/components/key-value/key-value.tsx::KeyValueLabelPosition"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value label position - 'top' or 'left'"
                },
                "attribute": "label-position",
                "reflect": false,
                "defaultValue": "'top'"
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value text value"
                },
                "attribute": "value",
                "reflect": false
            }
        };
    }
}
//# sourceMappingURL=key-value.js.map
