/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
export class MenuAboutNews {
    constructor() {
        this.show = false;
        this.label = undefined;
        this.i18nShowMore = 'Show more';
        this.aboutItemLabel = undefined;
        this.offsetBottom = 0;
        this.expanded = false;
    }
    render() {
        return (h(Host, { key: '49f78c17e45ad71cb4339d7d53fb98c5e359a468', class: {
                expanded: this.expanded,
                show: !this.show,
            } }, h("div", { key: 'a04326d6e192dfdd8c80388dd9af3efe6f915435', class: "banner-container" }, h("ix-icon", { key: '1311e733e409348f8f7a365652c99afad3391f17', color: "color-inv-contrast-text", name: 'shout', size: "32" }), h("svg", { key: 'b7874d274c41bbeb46b241bfe8d2759dbd88ca8f', viewBox: "0 0 48 56", xmlns: "http://www.w3.org/2000/svg" }, h("polygon", { key: '6d4f6e0f92a8e07156993693a9d4b67c12e4a2bc', points: "0 0 48 0 48 56 24 48 0 56" }))), h("div", { key: '39755e039fb3139fb95db1829f15785b4c18846c', class: "cui-popover-news-header" }, h("ix-typography", { key: '7c9f46a117ad88543678de3e22acdacf21c85089', variant: "default-title-single" }, this.label)), h("ix-icon-button", { key: '96f109929cc5d515d83db16b14ad42b37eb7d23f', size: "24", icon: 'close', ghost: true, onClick: () => {
                this.show = false;
                this.closePopover.emit();
            } }), h("div", { key: '375dcdb8c5913e917597ca6d6ab74595370c2c0f', class: "slot-container" }, h("slot", { key: 'd9319ca884b957d2629f24937c958901aa53ebcf' })), this.aboutItemLabel ? (h("div", { class: "cui-popover-news-footer" }, h("ix-button", { variant: "primary", onClick: (e) => {
                this.show = false;
                this.showMore.emit(e);
            } }, this.i18nShowMore))) : null, h("div", { key: 'bb3c91c6282f18deed4de7c393b5d48427a4ed27', id: "arrow" })));
    }
    static get is() { return "ix-menu-about-news"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["menu-about-news.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["menu-about-news.css"]
        };
    }
    static get properties() {
        return {
            "show": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show about news"
                },
                "attribute": "show",
                "reflect": true,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Title of the about news"
                },
                "attribute": "label",
                "reflect": false
            },
            "i18nShowMore": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": ""
                },
                "attribute": "i-1-8n-show-more",
                "reflect": false,
                "defaultValue": "'Show more'"
            },
            "aboutItemLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Subtitle of the about news"
                },
                "attribute": "about-item-label",
                "reflect": false
            },
            "offsetBottom": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Bottom offset"
                },
                "attribute": "offset-bottom",
                "reflect": false,
                "defaultValue": "0"
            },
            "expanded": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Internal"
                },
                "attribute": "expanded",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get events() {
        return [{
                "method": "showMore",
                "name": "showMore",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Show More button is pressed"
                },
                "complexType": {
                    "original": "MouseEvent",
                    "resolved": "MouseEvent",
                    "references": {
                        "MouseEvent": {
                            "location": "global",
                            "id": "global::MouseEvent"
                        }
                    }
                }
            }, {
                "method": "closePopover",
                "name": "closePopover",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Popover closed"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=menu-about-news.js.map
