/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
export function createEnterLeaveDebounce(enterCallback, leaveCallback, { debounceTimeEnter, debounceTimeLeave, } = {
    debounceTimeEnter: 0,
    debounceTimeLeave: 500,
}) {
    let enterTimeout;
    let leaveTimeout;
    return {
        onEnter: () => {
            clearTimeout(leaveTimeout);
            enterTimeout = setTimeout(() => {
                enterCallback();
            }, debounceTimeEnter);
        },
        onLeave: () => {
            clearTimeout(enterTimeout);
            leaveTimeout = setTimeout(() => {
                leaveCallback();
            }, debounceTimeLeave);
        },
    };
}
//# sourceMappingURL=enter-leave.js.map
