/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { createMutationObserver } from "../utils/mutation-observer";
import { makeRef } from "../utils/make-ref";
import { menuController } from "../utils/menu-service/menu-service";
/**
 * @slot menu-item-label Custom label
 */
export class MenuItem {
    constructor() {
        this.buttonRef = makeRef();
        this.isHostedInsideCategory = false;
        this.observer = createMutationObserver(() => {
            this.setTooltip();
        });
        this.label = undefined;
        this.home = false;
        this.bottom = false;
        this.tabIcon = undefined;
        this.icon = undefined;
        this.notifications = undefined;
        this.active = false;
        this.disabled = false;
        this.isCategory = false;
        this.tooltip = undefined;
        this.menuExpanded = false;
    }
    componentWillLoad() {
        this.isHostedInsideCategory =
            !!this.hostElement.closest('ix-menu-category');
        this.onIconChange();
        this.onTabIconChange();
        this.menuExpanded = menuController.nativeElement.expand;
        this.menuExpandedDisposer = menuController.expandChange.on((expand) => (this.menuExpanded = expand));
    }
    componentWillRender() {
        this.setTooltip();
    }
    setTooltip() {
        var _a;
        this.tooltip = (_a = this.label) !== null && _a !== void 0 ? _a : this.hostElement.textContent;
    }
    connectedCallback() {
        this.observer.observe(this.hostElement, {
            subtree: true,
            childList: true,
            characterData: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
        if (this.menuExpandedDisposer) {
            this.menuExpandedDisposer.dispose();
        }
    }
    onIconChange() {
        if (!this.isHostedInsideCategory &&
            !this.hostElement.icon &&
            !this.hostElement.tabIcon) {
            this.icon = 'document';
        }
    }
    onTabIconChange() {
        if (!this.isHostedInsideCategory &&
            !this.hostElement.icon &&
            !this.hostElement.tabIcon) {
            this.tabIcon = 'document';
        }
    }
    render() {
        var _a;
        let extendedAttributes = {};
        if (this.home) {
            extendedAttributes = {
                slot: 'home',
            };
        }
        if (this.bottom) {
            extendedAttributes = {
                slot: 'bottom',
            };
        }
        return (h(Host, Object.assign({ key: '44759af10c986ca08135dae3ab3b2258c933d8ef', class: {
                disabled: this.disabled,
                'home-tab': this.home,
                'bottom-tab': this.bottom,
                active: this.active,
                'tab-nested': this.isHostedInsideCategory,
            } }, extendedAttributes), h("button", { key: 'e30dbc8b43973f06f0d1f387ca886f11c088c0b9', class: "tab", tabIndex: this.disabled ? -1 : 0, role: "listitem", ref: this.buttonRef }, (this.icon || this.tabIcon) && (h("ix-icon", { key: '11163d983423f020b14de4bcae24dbf55068e645', class: 'tab-icon', name: (_a = this.icon) !== null && _a !== void 0 ? _a : this.tabIcon })), this.notifications ? (h("div", { class: "notification" }, h("div", { class: "pill" }, this.notifications))) : null, h("span", { key: '3a62db4c5e965a9fec6d5e4648a9587b7ff6271d', class: "tab-text text-default" }, this.label, h("slot", { key: '1c9c5c22c13da93176d68f93c516e4005506d43e' }))), !this.isCategory &&
            !this.isHostedInsideCategory &&
            !this.menuExpanded && (h("ix-tooltip", { key: 'ec5fd96cbe7c0937202a70ebfba24abc66afd203', for: this.buttonRef.waitForCurrent(), placement: 'right', showDelay: 1000 }, this.tooltip))));
    }
    static get is() { return "ix-menu-item"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["menu-item.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["menu-item.css"]
        };
    }
    static get properties() {
        return {
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.2.0"
                        }],
                    "text": "Label of the menu item. Will also be used as tooltip text"
                },
                "attribute": "label",
                "reflect": false
            },
            "home": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Move the Tab to a top position."
                },
                "attribute": "home",
                "reflect": false,
                "defaultValue": "false"
            },
            "bottom": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Caution: this is no longer working. Please use slot=\"bottom\" instead.\n\nPlace tab on bottom"
                },
                "attribute": "bottom",
                "reflect": false,
                "defaultValue": "false"
            },
            "tabIcon": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/icon-library/icons"
                        }, {
                            "name": "deprecated",
                            "text": "since 2.0.0 use `icon` property. Will be removed in 3.0.0"
                        }],
                    "text": "Name of the icon you want to display. Icon names can be resolved from the documentation"
                },
                "attribute": "tab-icon",
                "reflect": false
            },
            "icon": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/icon-library/icons"
                        }],
                    "text": "Name of the icon you want to display. Icon names can be resolved from the documentation"
                },
                "attribute": "icon",
                "reflect": false
            },
            "notifications": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show notification count on tab"
                },
                "attribute": "notifications",
                "reflect": false
            },
            "active": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "State to display active"
                },
                "attribute": "active",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disable tab and remove event handlers"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "isCategory": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "is-category",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "tooltip": {},
            "menuExpanded": {}
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "icon",
                "methodName": "onIconChange"
            }, {
                "propName": "tabIcon",
                "methodName": "onTabIconChange"
            }];
    }
}
//# sourceMappingURL=menu-item.js.map
