/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
export class TreeItem {
    constructor() {
        this.text = undefined;
        this.hasChildren = false;
        this.context = undefined;
    }
    render() {
        var _a, _b, _c;
        return (h(Host, { key: '29f49c27b0e62c71cb8776a2147de561aa5ed0f2', class: {
                selected: !!((_a = this.context) === null || _a === void 0 ? void 0 : _a.isSelected),
            } }, h("div", { key: '4fd6fab088cea8c06e5671c0389f84563e6a33ef', class: "icon-toggle-container", onClick: (e) => {
                e.preventDefault();
                this.toggle.emit();
            } }, this.hasChildren ? (h("ix-icon", { name: 'chevron-right', size: "16", class: {
                ['icon-toggle-down']: !!((_b = this.context) === null || _b === void 0 ? void 0 : _b.isExpanded),
            }, color: `color-${((_c = this.context) === null || _c === void 0 ? void 0 : _c.isExpanded) ? 'primary' : 'std-text'}` })) : null), h("div", { key: '4cb3c4699ee016895e68c21466e42aa3a10e3ed4', class: "tree-node-container", onClick: () => {
                this.itemClick.emit();
            } }, h("div", { key: '48ae93475e742e15f6f6acd065fe47c8dd97559b', class: "tree-node-text" }, this.text), h("slot", { key: '2e27a586182c5ca31e924190801bbff825d7f25d' }))));
    }
    static get is() { return "ix-tree-item"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["tree-item.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["tree-item.css"]
        };
    }
    static get properties() {
        return {
            "text": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Text"
                },
                "attribute": "text",
                "reflect": false
            },
            "hasChildren": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Has tree item children"
                },
                "attribute": "has-children",
                "reflect": false,
                "defaultValue": "false"
            },
            "context": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "TreeItemContext",
                    "resolved": "TreeItemContext",
                    "references": {
                        "TreeItemContext": {
                            "location": "import",
                            "path": "../tree/tree-model",
                            "id": "src/components/tree/tree-model.ts::TreeItemContext"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Context"
                }
            }
        };
    }
    static get events() {
        return [{
                "method": "toggle",
                "name": "toggle",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Expand/Collapsed toggled"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "itemClick",
                "name": "itemClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Click on item not on the expand/collapse icon"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=tree-item.js.map
