export class OverlayController {
    constructor() {
        this.overlays = new Set();
    }
    connected(instance) {
        this.overlays.add(instance);
    }
    disconnected(instance) {
        this.overlays.delete(instance);
    }
    present(instance) {
        if (instance.willPresent && !instance.willPresent()) {
            return;
        }
        this.dismissOthers(instance);
        instance.present();
    }
    dismiss(instance) {
        if (instance.willDismiss && !instance.willDismiss()) {
            return;
        }
        instance.dismiss();
    }
    dismissOthers(instance) {
        this.overlays.forEach((overlay) => {
            if (overlay !== instance) {
                this.dismiss(overlay);
            }
        });
    }
}
//# sourceMappingURL=overlay.js.map
