import { IxOverlayComponent } from '../utils/overlay';
/**
 * @slot title-icon - Icon of tooltip title
 * @slot title-content - Content of tooltip title
 *
 * @since 1.4.0
 */
export declare class Tooltip implements IxOverlayComponent {
    /**
     * CSS selector for hover trigger element e.g. `for="[data-my-custom-select]"`
     */
    for?: string | HTMLElement | Promise<HTMLElement>;
    /**
     * Title of the tooltip
     */
    titleContent?: string;
    /**
     * Define if the user can access the tooltip via mouse.
     */
    interactive: boolean;
    /**
     * Initial placement of the tooltip.
     * If the selected placement doesn't have enough space, the tooltip will be repositioned to another location.
     * @since 1.5.0
     */
    placement: 'top' | 'right' | 'bottom' | 'left';
    /** @internal */
    showDelay: number;
    /** @internal */
    hideDelay: number;
    /** @internal */
    animationFrame: boolean;
    visible: boolean;
    hostElement: HTMLIxTooltipElement;
    private observer?;
    private hideTooltipTimeout?;
    private showTooltipTimeout?;
    private disposeAutoUpdate?;
    private disposeListener?;
    private get arrowElement();
    private destroyAutoUpdate;
    /** @internal */
    showTooltip(anchorElement: Element): Promise<void>;
    /** @internal */
    hideTooltip(): Promise<void>;
    private computeArrowPosition;
    private computeTooltipPosition;
    private applyTooltipArrowPosition;
    private applyTooltipPosition;
    private clearHideTimeout;
    private queryAnchorElements;
    private registerTriggerListener;
    private registerTooltipListener;
    onKeydown(event: KeyboardEvent): Promise<void>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    isPresent(): boolean;
    present(): void;
    dismiss(): void;
    render(): any;
}
