'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function hydrateFactory($stencilWindow, $stencilHydrateOpts, $stencilHydrateResults, $stencilAfterHydrate, $stencilHydrateResolve) {
  var globalThis = $stencilWindow;
  var self = $stencilWindow;
  var top = $stencilWindow;
  var parent = $stencilWindow;

  var addEventListener = $stencilWindow.addEventListener.bind($stencilWindow);
  var alert = $stencilWindow.alert.bind($stencilWindow);
  var blur = $stencilWindow.blur.bind($stencilWindow);
  var cancelAnimationFrame = $stencilWindow.cancelAnimationFrame.bind($stencilWindow);
  var cancelIdleCallback = $stencilWindow.cancelIdleCallback.bind($stencilWindow);
  var clearInterval = $stencilWindow.clearInterval.bind($stencilWindow);
  var clearTimeout = $stencilWindow.clearTimeout.bind($stencilWindow);
  var close = () => {};
  var confirm = $stencilWindow.confirm.bind($stencilWindow);
  var dispatchEvent = $stencilWindow.dispatchEvent.bind($stencilWindow);
  var focus = $stencilWindow.focus.bind($stencilWindow);
  var getComputedStyle = $stencilWindow.getComputedStyle.bind($stencilWindow);
  var matchMedia = $stencilWindow.matchMedia.bind($stencilWindow);
  var open = $stencilWindow.open.bind($stencilWindow);
  var prompt = $stencilWindow.prompt.bind($stencilWindow);
  var removeEventListener = $stencilWindow.removeEventListener.bind($stencilWindow);
  var requestAnimationFrame = $stencilWindow.requestAnimationFrame.bind($stencilWindow);
  var requestIdleCallback = $stencilWindow.requestIdleCallback.bind($stencilWindow);
  var setInterval = $stencilWindow.setInterval.bind($stencilWindow);
  var setTimeout = $stencilWindow.setTimeout.bind($stencilWindow);

  var CharacterData = $stencilWindow.CharacterData;
  var CSS = $stencilWindow.CSS;
  var CustomEvent = $stencilWindow.CustomEvent;
  var Document = $stencilWindow.Document;
  var DocumentFragment = $stencilWindow.DocumentFragment;
  var DocumentType = $stencilWindow.DocumentType;
  var DOMTokenList = $stencilWindow.DOMTokenList;
  var Element = $stencilWindow.Element;
  var Event = $stencilWindow.Event;
  var HTMLAnchorElement = $stencilWindow.HTMLAnchorElement;
  var HTMLBaseElement = $stencilWindow.HTMLBaseElement;
  var HTMLButtonElement = $stencilWindow.HTMLButtonElement;
  var HTMLCanvasElement = $stencilWindow.HTMLCanvasElement;
  var HTMLElement = $stencilWindow.HTMLElement;
  var HTMLFormElement = $stencilWindow.HTMLFormElement;
  var HTMLImageElement = $stencilWindow.HTMLImageElement;
  var HTMLInputElement = $stencilWindow.HTMLInputElement;
  var HTMLLinkElement = $stencilWindow.HTMLLinkElement;
  var HTMLMetaElement = $stencilWindow.HTMLMetaElement;
  var HTMLScriptElement = $stencilWindow.HTMLScriptElement;
  var HTMLStyleElement = $stencilWindow.HTMLStyleElement;
  var HTMLTemplateElement = $stencilWindow.HTMLTemplateElement;
  var HTMLTitleElement = $stencilWindow.HTMLTitleElement;
  var IntersectionObserver = $stencilWindow.IntersectionObserver;
  var KeyboardEvent = $stencilWindow.KeyboardEvent;
  var MouseEvent = $stencilWindow.MouseEvent;
  var Node = $stencilWindow.Node;
  var NodeList = $stencilWindow.NodeList;
  var URL = $stencilWindow.URL;

  var console = $stencilWindow.console;
  var customElements = $stencilWindow.customElements;
  var history = $stencilWindow.history;
  var localStorage = $stencilWindow.localStorage;
  var location = $stencilWindow.location;
  var navigator = $stencilWindow.navigator;
  var performance = $stencilWindow.performance;
  var sessionStorage = $stencilWindow.sessionStorage;

  var devicePixelRatio = $stencilWindow.devicePixelRatio;
  var innerHeight = $stencilWindow.innerHeight;
  var innerWidth = $stencilWindow.innerWidth;
  var origin = $stencilWindow.origin;
  var pageXOffset = $stencilWindow.pageXOffset;
  var pageYOffset = $stencilWindow.pageYOffset;
  var screen = $stencilWindow.screen;
  var screenLeft = $stencilWindow.screenLeft;
  var screenTop = $stencilWindow.screenTop;
  var screenX = $stencilWindow.screenX;
  var screenY = $stencilWindow.screenY;
  var scrollX = $stencilWindow.scrollX;
  var scrollY = $stencilWindow.scrollY;
  var exports = {};

  var fetch, FetchError, Headers, Request, Response;

  if (typeof $stencilWindow.fetch === 'function') {
    fetch = $stencilWindow.fetch;
  } else {
    fetch = $stencilWindow.fetch = function() { throw new Error('fetch() is not implemented'); };
  }

  if (typeof $stencilWindow.FetchError === 'function') {
    FetchError = $stencilWindow.FetchError;
  } else {
    FetchError = $stencilWindow.FetchError = class FetchError { constructor() { throw new Error('FetchError is not implemented'); } };
  }

  if (typeof $stencilWindow.Headers === 'function') {
    Headers = $stencilWindow.Headers;
  } else {
    Headers = $stencilWindow.Headers = class Headers { constructor() { throw new Error('Headers is not implemented'); } };
  }

  if (typeof $stencilWindow.Request === 'function') {
    Request = $stencilWindow.Request;
  } else {
    Request = $stencilWindow.Request = class Request { constructor() { throw new Error('Request is not implemented'); } };
  }

  if (typeof $stencilWindow.Response === 'function') {
    Response = $stencilWindow.Response;
  } else {
    Response = $stencilWindow.Response = class Response { constructor() { throw new Error('Response is not implemented'); } };
  }

  function hydrateAppClosure($stencilWindow) {
    const window = $stencilWindow;
    const document = $stencilWindow.document;
    /*hydrateAppClosure start*/


const NAMESPACE = 'siemens-ix';
const BUILD = /* siemens-ix */ { allRenderFn: true, appendChildSlotFix: false, asyncLoading: true, attachStyles: true, cloneNodeFix: false, cmpDidLoad: true, cmpDidRender: true, cmpDidUnload: false, cmpDidUpdate: false, cmpShouldUpdate: false, cmpWillLoad: true, cmpWillRender: true, cmpWillUpdate: false, connectedCallback: true, constructableCSS: false, cssAnnotations: true, devTools: false, disconnectedCallback: true, element: false, event: true, experimentalScopedSlotChanges: false, experimentalSlotFixes: false, formAssociated: false, hasRenderFn: true, hostListener: true, hostListenerTarget: true, hostListenerTargetBody: false, hostListenerTargetDocument: false, hostListenerTargetParent: false, hostListenerTargetWindow: true, hotModuleReplacement: false, hydrateClientSide: true, hydrateServerSide: true, hydratedAttribute: false, hydratedClass: true, isDebug: false, isDev: false, isTesting: false, lazyLoad: true, lifecycle: true, lifecycleDOMEvents: false, member: true, method: true, mode: false, observeAttribute: true, profile: false, prop: true, propBoolean: true, propMutable: true, propNumber: true, propString: true, reflect: true, scoped: true, scriptDataOpts: false, shadowDelegatesFocus: false, shadowDom: true, shadowDomShim: true, slot: true, slotChildNodesFix: false, slotRelocation: true, state: true, style: true, svg: true, taskQueue: true, updatable: true, vdomAttribute: true, vdomClass: true, vdomFunctional: true, vdomKey: true, vdomListener: true, vdomPropOrAttr: true, vdomRef: true, vdomRender: true, vdomStyle: true, vdomText: true, vdomXlink: true, watchCallback: true };

/*
 Stencil Hydrate Platform v4.17.2 | MIT Licensed | https://stenciljs.com
 */
var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// src/utils/constants.ts
var EMPTY_OBJ = {};
var SVG_NS = "http://www.w3.org/2000/svg";
var HTML_NS = "http://www.w3.org/1999/xhtml";

// src/utils/helpers.ts
var isDef = (v) => v != null;
var isComplexType = (o) => {
  o = typeof o;
  return o === "object" || o === "function";
};
var isPromise = (v) => !!v && (typeof v === "object" || typeof v === "function") && typeof v.then === "function";

// src/utils/query-nonce-meta-tag-content.ts
function queryNonceMetaTagContent(doc2) {
  var _a, _b, _c;
  return (_c = (_b = (_a = doc2.head) == null ? void 0 : _a.querySelector('meta[name="csp-nonce"]')) == null ? void 0 : _b.getAttribute("content")) != null ? _c : void 0;
}

// src/utils/result.ts
var result_exports = {};
__export(result_exports, {
  err: () => err,
  map: () => map,
  ok: () => ok,
  unwrap: () => unwrap,
  unwrapErr: () => unwrapErr
});
var ok = (value) => ({
  isOk: true,
  isErr: false,
  value
});
var err = (value) => ({
  isOk: false,
  isErr: true,
  value
});
function map(result, fn) {
  if (result.isOk) {
    const val = fn(result.value);
    if (val instanceof Promise) {
      return val.then((newVal) => ok(newVal));
    } else {
      return ok(val);
    }
  }
  if (result.isErr) {
    const value = result.value;
    return err(value);
  }
  throw "should never get here";
}
var unwrap = (result) => {
  if (result.isOk) {
    return result.value;
  } else {
    throw result.value;
  }
};
var unwrapErr = (result) => {
  if (result.isErr) {
    return result.value;
  } else {
    throw result.value;
  }
};
var createTime = (fnName, tagName = "") => {
  {
    return () => {
      return;
    };
  }
};
var uniqueTime = (key, measureText) => {
  {
    return () => {
      return;
    };
  }
};

// src/runtime/runtime-constants.ts
var CONTENT_REF_ID = "r";
var ORG_LOCATION_ID = "o";
var SLOT_NODE_ID = "s";
var TEXT_NODE_ID = "t";
var HYDRATE_ID = "s-id";
var HYDRATED_STYLE_ID = "sty-id";
var HYDRATE_CHILD_ID = "c-id";
var SLOT_FB_CSS = "slot-fb{display:contents}slot-fb[hidden]{display:none}";
var XLINK_NS = "http://www.w3.org/1999/xlink";
var h = (nodeName, vnodeData, ...children) => {
  let child = null;
  let key = null;
  let slotName = null;
  let simple = false;
  let lastSimple = false;
  const vNodeChildren = [];
  const walk = (c) => {
    for (let i2 = 0; i2 < c.length; i2++) {
      child = c[i2];
      if (Array.isArray(child)) {
        walk(child);
      } else if (child != null && typeof child !== "boolean") {
        if (simple = typeof nodeName !== "function" && !isComplexType(child)) {
          child = String(child);
        }
        if (simple && lastSimple) {
          vNodeChildren[vNodeChildren.length - 1].$text$ += child;
        } else {
          vNodeChildren.push(simple ? newVNode(null, child) : child);
        }
        lastSimple = simple;
      }
    }
  };
  walk(children);
  if (vnodeData) {
    if (vnodeData.key) {
      key = vnodeData.key;
    }
    if (vnodeData.name) {
      slotName = vnodeData.name;
    }
    {
      const classData = vnodeData.className || vnodeData.class;
      if (classData) {
        vnodeData.class = typeof classData !== "object" ? classData : Object.keys(classData).filter((k) => classData[k]).join(" ");
      }
    }
  }
  if (typeof nodeName === "function") {
    return nodeName(
      vnodeData === null ? {} : vnodeData,
      vNodeChildren,
      vdomFnUtils
    );
  }
  const vnode = newVNode(nodeName, null);
  vnode.$attrs$ = vnodeData;
  if (vNodeChildren.length > 0) {
    vnode.$children$ = vNodeChildren;
  }
  {
    vnode.$key$ = key;
  }
  {
    vnode.$name$ = slotName;
  }
  return vnode;
};
var newVNode = (tag, text) => {
  const vnode = {
    $flags$: 0,
    $tag$: tag,
    $text$: text,
    $elm$: null,
    $children$: null
  };
  {
    vnode.$attrs$ = null;
  }
  {
    vnode.$key$ = null;
  }
  {
    vnode.$name$ = null;
  }
  return vnode;
};
var Host = {};
var isHost = (node) => node && node.$tag$ === Host;
var vdomFnUtils = {
  forEach: (children, cb) => children.map(convertToPublic).forEach(cb),
  map: (children, cb) => children.map(convertToPublic).map(cb).map(convertToPrivate)
};
var convertToPublic = (node) => ({
  vattrs: node.$attrs$,
  vchildren: node.$children$,
  vkey: node.$key$,
  vname: node.$name$,
  vtag: node.$tag$,
  vtext: node.$text$
});
var convertToPrivate = (node) => {
  if (typeof node.vtag === "function") {
    const vnodeData = { ...node.vattrs };
    if (node.vkey) {
      vnodeData.key = node.vkey;
    }
    if (node.vname) {
      vnodeData.name = node.vname;
    }
    return h(node.vtag, vnodeData, ...node.vchildren || []);
  }
  const vnode = newVNode(node.vtag, node.vtext);
  vnode.$attrs$ = node.vattrs;
  vnode.$children$ = node.vchildren;
  vnode.$key$ = node.vkey;
  vnode.$name$ = node.vname;
  return vnode;
};

// src/runtime/client-hydrate.ts
var initializeClientHydrate = (hostElm, tagName, hostId, hostRef) => {
  const endHydrate = createTime("hydrateClient", tagName);
  const shadowRoot = hostElm.shadowRoot;
  const childRenderNodes = [];
  const slotNodes = [];
  const shadowRootNodes = shadowRoot ? [] : null;
  const vnode = hostRef.$vnode$ = newVNode(tagName, null);
  if (!plt.$orgLocNodes$) {
    initializeDocumentHydrate(doc.body, plt.$orgLocNodes$ = /* @__PURE__ */ new Map());
  }
  hostElm[HYDRATE_ID] = hostId;
  hostElm.removeAttribute(HYDRATE_ID);
  clientHydrate(vnode, childRenderNodes, slotNodes, shadowRootNodes, hostElm, hostElm, hostId);
  childRenderNodes.map((c) => {
    const orgLocationId = c.$hostId$ + "." + c.$nodeId$;
    const orgLocationNode = plt.$orgLocNodes$.get(orgLocationId);
    const node = c.$elm$;
    if (orgLocationNode && supportsShadow && orgLocationNode["s-en"] === "") {
      orgLocationNode.parentNode.insertBefore(node, orgLocationNode.nextSibling);
    }
    if (!shadowRoot) {
      node["s-hn"] = tagName;
      if (orgLocationNode) {
        node["s-ol"] = orgLocationNode;
        node["s-ol"]["s-nr"] = node;
      }
    }
    plt.$orgLocNodes$.delete(orgLocationId);
  });
  if (shadowRoot) {
    shadowRootNodes.map((shadowRootNode) => {
      if (shadowRootNode) {
        shadowRoot.appendChild(shadowRootNode);
      }
    });
  }
  endHydrate();
};
var clientHydrate = (parentVNode, childRenderNodes, slotNodes, shadowRootNodes, hostElm, node, hostId) => {
  let childNodeType;
  let childIdSplt;
  let childVNode;
  let i2;
  if (node.nodeType === 1 /* ElementNode */) {
    childNodeType = node.getAttribute(HYDRATE_CHILD_ID);
    if (childNodeType) {
      childIdSplt = childNodeType.split(".");
      if (childIdSplt[0] === hostId || childIdSplt[0] === "0") {
        childVNode = {
          $flags$: 0,
          $hostId$: childIdSplt[0],
          $nodeId$: childIdSplt[1],
          $depth$: childIdSplt[2],
          $index$: childIdSplt[3],
          $tag$: node.tagName.toLowerCase(),
          $elm$: node,
          $attrs$: null,
          $children$: null,
          $key$: null,
          $name$: null,
          $text$: null
        };
        childRenderNodes.push(childVNode);
        node.removeAttribute(HYDRATE_CHILD_ID);
        if (!parentVNode.$children$) {
          parentVNode.$children$ = [];
        }
        parentVNode.$children$[childVNode.$index$] = childVNode;
        parentVNode = childVNode;
        if (shadowRootNodes && childVNode.$depth$ === "0") {
          shadowRootNodes[childVNode.$index$] = childVNode.$elm$;
        }
      }
    }
    for (i2 = node.childNodes.length - 1; i2 >= 0; i2--) {
      clientHydrate(
        parentVNode,
        childRenderNodes,
        slotNodes,
        shadowRootNodes,
        hostElm,
        node.childNodes[i2],
        hostId
      );
    }
    if (node.shadowRoot) {
      for (i2 = node.shadowRoot.childNodes.length - 1; i2 >= 0; i2--) {
        clientHydrate(
          parentVNode,
          childRenderNodes,
          slotNodes,
          shadowRootNodes,
          hostElm,
          node.shadowRoot.childNodes[i2],
          hostId
        );
      }
    }
  } else if (node.nodeType === 8 /* CommentNode */) {
    childIdSplt = node.nodeValue.split(".");
    if (childIdSplt[1] === hostId || childIdSplt[1] === "0") {
      childNodeType = childIdSplt[0];
      childVNode = {
        $flags$: 0,
        $hostId$: childIdSplt[1],
        $nodeId$: childIdSplt[2],
        $depth$: childIdSplt[3],
        $index$: childIdSplt[4],
        $elm$: node,
        $attrs$: null,
        $children$: null,
        $key$: null,
        $name$: null,
        $tag$: null,
        $text$: null
      };
      if (childNodeType === TEXT_NODE_ID) {
        childVNode.$elm$ = node.nextSibling;
        if (childVNode.$elm$ && childVNode.$elm$.nodeType === 3 /* TextNode */) {
          childVNode.$text$ = childVNode.$elm$.textContent;
          childRenderNodes.push(childVNode);
          node.remove();
          if (!parentVNode.$children$) {
            parentVNode.$children$ = [];
          }
          parentVNode.$children$[childVNode.$index$] = childVNode;
          if (shadowRootNodes && childVNode.$depth$ === "0") {
            shadowRootNodes[childVNode.$index$] = childVNode.$elm$;
          }
        }
      } else if (childVNode.$hostId$ === hostId) {
        if (childNodeType === SLOT_NODE_ID) {
          childVNode.$tag$ = "slot";
          if (childIdSplt[5]) {
            node["s-sn"] = childVNode.$name$ = childIdSplt[5];
          } else {
            node["s-sn"] = "";
          }
          node["s-sr"] = true;
          if (shadowRootNodes) {
            childVNode.$elm$ = doc.createElement(childVNode.$tag$);
            if (childVNode.$name$) {
              childVNode.$elm$.setAttribute("name", childVNode.$name$);
            }
            node.parentNode.insertBefore(childVNode.$elm$, node);
            node.remove();
            if (childVNode.$depth$ === "0") {
              shadowRootNodes[childVNode.$index$] = childVNode.$elm$;
            }
          }
          slotNodes.push(childVNode);
          if (!parentVNode.$children$) {
            parentVNode.$children$ = [];
          }
          parentVNode.$children$[childVNode.$index$] = childVNode;
        } else if (childNodeType === CONTENT_REF_ID) {
          if (shadowRootNodes) {
            node.remove();
          } else {
            hostElm["s-cr"] = node;
            node["s-cn"] = true;
          }
        }
      }
    }
  } else if (parentVNode && parentVNode.$tag$ === "style") {
    const vnode = newVNode(null, node.textContent);
    vnode.$elm$ = node;
    vnode.$index$ = "0";
    parentVNode.$children$ = [vnode];
  }
};
var initializeDocumentHydrate = (node, orgLocNodes) => {
  if (node.nodeType === 1 /* ElementNode */) {
    let i2 = 0;
    for (; i2 < node.childNodes.length; i2++) {
      initializeDocumentHydrate(node.childNodes[i2], orgLocNodes);
    }
    if (node.shadowRoot) {
      for (i2 = 0; i2 < node.shadowRoot.childNodes.length; i2++) {
        initializeDocumentHydrate(node.shadowRoot.childNodes[i2], orgLocNodes);
      }
    }
  } else if (node.nodeType === 8 /* CommentNode */) {
    const childIdSplt = node.nodeValue.split(".");
    if (childIdSplt[0] === ORG_LOCATION_ID) {
      orgLocNodes.set(childIdSplt[1] + "." + childIdSplt[2], node);
      node.nodeValue = "";
      node["s-en"] = childIdSplt[3];
    }
  }
};
var parsePropertyValue = (propValue, propType) => {
  if (propValue != null && !isComplexType(propValue)) {
    if (propType & 4 /* Boolean */) {
      return propValue === "false" ? false : propValue === "" || !!propValue;
    }
    if (propType & 2 /* Number */) {
      return parseFloat(propValue);
    }
    if (propType & 1 /* String */) {
      return String(propValue);
    }
    return propValue;
  }
  return propValue;
};
var getElement = (ref) => getHostRef(ref).$hostElement$ ;

// src/runtime/event-emitter.ts
var createEvent = (ref, name, flags) => {
  const elm = getElement(ref);
  return {
    emit: (detail) => {
      return emitEvent(elm, name, {
        bubbles: !!(flags & 4 /* Bubbles */),
        composed: !!(flags & 2 /* Composed */),
        cancelable: !!(flags & 1 /* Cancellable */),
        detail
      });
    }
  };
};
var emitEvent = (elm, name, opts) => {
  const ev = plt.ce(name, opts);
  elm.dispatchEvent(ev);
  return ev;
};
var rootAppliedStyles = /* @__PURE__ */ new WeakMap();
var registerStyle = (scopeId2, cssText, allowCS) => {
  let style = styles.get(scopeId2);
  {
    style = cssText;
  }
  styles.set(scopeId2, style);
};
var addStyle = (styleContainerNode, cmpMeta, mode) => {
  var _a;
  const scopeId2 = getScopeId(cmpMeta);
  const style = styles.get(scopeId2);
  styleContainerNode = styleContainerNode.nodeType === 11 /* DocumentFragment */ ? styleContainerNode : doc;
  if (style) {
    if (typeof style === "string") {
      styleContainerNode = styleContainerNode.head || styleContainerNode;
      let appliedStyles = rootAppliedStyles.get(styleContainerNode);
      let styleElm;
      if (!appliedStyles) {
        rootAppliedStyles.set(styleContainerNode, appliedStyles = /* @__PURE__ */ new Set());
      }
      if (!appliedStyles.has(scopeId2)) {
        if (styleContainerNode.host && (styleElm = styleContainerNode.querySelector(`[${HYDRATED_STYLE_ID}="${scopeId2}"]`))) {
          styleElm.innerHTML = style;
        } else {
          styleElm = doc.createElement("style");
          styleElm.innerHTML = style;
          const nonce = (_a = plt.$nonce$) != null ? _a : queryNonceMetaTagContent(doc);
          if (nonce != null) {
            styleElm.setAttribute("nonce", nonce);
          }
          {
            styleElm.setAttribute(HYDRATED_STYLE_ID, scopeId2);
          }
          styleContainerNode.insertBefore(styleElm, styleContainerNode.querySelector("link"));
        }
        if (cmpMeta.$flags$ & 4 /* hasSlotRelocation */) {
          styleElm.innerHTML += SLOT_FB_CSS;
        }
        if (appliedStyles) {
          appliedStyles.add(scopeId2);
        }
      }
    }
  }
  return scopeId2;
};
var attachStyles = (hostRef) => {
  const cmpMeta = hostRef.$cmpMeta$;
  const elm = hostRef.$hostElement$;
  const flags = cmpMeta.$flags$;
  const endAttachStyles = createTime("attachStyles", cmpMeta.$tagName$);
  const scopeId2 = addStyle(
    elm.getRootNode(),
    cmpMeta);
  if (flags & 10 /* needsScopedEncapsulation */) {
    elm["s-sc"] = scopeId2;
    elm.classList.add(scopeId2 + "-h");
    if (flags & 2 /* scopedCssEncapsulation */) {
      elm.classList.add(scopeId2 + "-s");
    }
  }
  endAttachStyles();
};
var getScopeId = (cmp, mode) => "sc-" + (cmp.$tagName$);
var setAccessor = (elm, memberName, oldValue, newValue, isSvg, flags) => {
  if (oldValue !== newValue) {
    let isProp = isMemberInElement(elm, memberName);
    let ln = memberName.toLowerCase();
    if (memberName === "class") {
      const classList = elm.classList;
      const oldClasses = parseClassList(oldValue);
      const newClasses = parseClassList(newValue);
      classList.remove(...oldClasses.filter((c) => c && !newClasses.includes(c)));
      classList.add(...newClasses.filter((c) => c && !oldClasses.includes(c)));
    } else if (memberName === "style") {
      {
        for (const prop in oldValue) {
          if (!newValue || newValue[prop] == null) {
            {
              elm.style[prop] = "";
            }
          }
        }
      }
      for (const prop in newValue) {
        if (!oldValue || newValue[prop] !== oldValue[prop]) {
          {
            elm.style[prop] = newValue[prop];
          }
        }
      }
    } else if (memberName === "key") ; else if (memberName === "ref") {
      if (newValue) {
        newValue(elm);
      }
    } else if ((!isProp ) && memberName[0] === "o" && memberName[1] === "n") {
      if (memberName[2] === "-") {
        memberName = memberName.slice(3);
      } else if (isMemberInElement(win, ln)) {
        memberName = ln.slice(2);
      } else {
        memberName = ln[2] + memberName.slice(3);
      }
      if (oldValue || newValue) {
        const capture = memberName.endsWith(CAPTURE_EVENT_SUFFIX);
        memberName = memberName.replace(CAPTURE_EVENT_REGEX, "");
        if (oldValue) {
          plt.rel(elm, memberName, oldValue, capture);
        }
        if (newValue) {
          plt.ael(elm, memberName, newValue, capture);
        }
      }
    } else {
      const isComplex = isComplexType(newValue);
      if ((isProp || isComplex && newValue !== null) && !isSvg) {
        try {
          if (!elm.tagName.includes("-")) {
            const n = newValue == null ? "" : newValue;
            if (memberName === "list") {
              isProp = false;
            } else if (oldValue == null || elm[memberName] != n) {
              elm[memberName] = n;
            }
          } else {
            elm[memberName] = newValue;
          }
        } catch (e) {
        }
      }
      let xlink = false;
      {
        if (ln !== (ln = ln.replace(/^xlink\:?/, ""))) {
          memberName = ln;
          xlink = true;
        }
      }
      if (newValue == null || newValue === false) {
        if (newValue !== false || elm.getAttribute(memberName) === "") {
          if (xlink) {
            elm.removeAttributeNS(XLINK_NS, memberName);
          } else {
            elm.removeAttribute(memberName);
          }
        }
      } else if ((!isProp || flags & 4 /* isHost */ || isSvg) && !isComplex) {
        newValue = newValue === true ? "" : newValue;
        if (xlink) {
          elm.setAttributeNS(XLINK_NS, memberName, newValue);
        } else {
          elm.setAttribute(memberName, newValue);
        }
      }
    }
  }
};
var parseClassListRegex = /\s/;
var parseClassList = (value) => !value ? [] : value.split(parseClassListRegex);
var CAPTURE_EVENT_SUFFIX = "Capture";
var CAPTURE_EVENT_REGEX = new RegExp(CAPTURE_EVENT_SUFFIX + "$");

// src/runtime/vdom/update-element.ts
var updateElement = (oldVnode, newVnode, isSvgMode2) => {
  const elm = newVnode.$elm$.nodeType === 11 /* DocumentFragment */ && newVnode.$elm$.host ? newVnode.$elm$.host : newVnode.$elm$;
  const oldVnodeAttrs = oldVnode && oldVnode.$attrs$ || EMPTY_OBJ;
  const newVnodeAttrs = newVnode.$attrs$ || EMPTY_OBJ;
  {
    for (const memberName of sortedAttrNames(Object.keys(oldVnodeAttrs))) {
      if (!(memberName in newVnodeAttrs)) {
        setAccessor(elm, memberName, oldVnodeAttrs[memberName], void 0, isSvgMode2, newVnode.$flags$);
      }
    }
  }
  for (const memberName of sortedAttrNames(Object.keys(newVnodeAttrs))) {
    setAccessor(elm, memberName, oldVnodeAttrs[memberName], newVnodeAttrs[memberName], isSvgMode2, newVnode.$flags$);
  }
};
function sortedAttrNames(attrNames) {
  return attrNames.includes("ref") ? (
    // we need to sort these to ensure that `'ref'` is the last attr
    [...attrNames.filter((attr) => attr !== "ref"), "ref"]
  ) : (
    // no need to sort, return the original array
    attrNames
  );
}

// src/runtime/vdom/vdom-render.ts
var scopeId;
var contentRef;
var hostTagName;
var useNativeShadowDom = false;
var checkSlotFallbackVisibility = false;
var checkSlotRelocate = false;
var isSvgMode = false;
var createElm = (oldParentVNode, newParentVNode, childIndex, parentElm) => {
  var _a;
  const newVNode2 = newParentVNode.$children$[childIndex];
  let i2 = 0;
  let elm;
  let childNode;
  let oldVNode;
  if (!useNativeShadowDom) {
    checkSlotRelocate = true;
    if (newVNode2.$tag$ === "slot") {
      if (scopeId) {
        parentElm.classList.add(scopeId + "-s");
      }
      newVNode2.$flags$ |= newVNode2.$children$ ? (
        // slot element has fallback content
        // still create an element that "mocks" the slot element
        2 /* isSlotFallback */
      ) : (
        // slot element does not have fallback content
        // create an html comment we'll use to always reference
        // where actual slot content should sit next to
        1 /* isSlotReference */
      );
    }
  }
  if (newVNode2.$text$ !== null) {
    elm = newVNode2.$elm$ = doc.createTextNode(newVNode2.$text$);
  } else if (newVNode2.$flags$ & 1 /* isSlotReference */) {
    elm = newVNode2.$elm$ = slotReferenceDebugNode(newVNode2) ;
  } else {
    if (!isSvgMode) {
      isSvgMode = newVNode2.$tag$ === "svg";
    }
    elm = newVNode2.$elm$ = doc.createElementNS(
      isSvgMode ? SVG_NS : HTML_NS,
      newVNode2.$flags$ & 2 /* isSlotFallback */ ? "slot-fb" : newVNode2.$tag$
    ) ;
    if (isSvgMode && newVNode2.$tag$ === "foreignObject") {
      isSvgMode = false;
    }
    {
      updateElement(null, newVNode2, isSvgMode);
    }
    if (isDef(scopeId) && elm["s-si"] !== scopeId) {
      elm.classList.add(elm["s-si"] = scopeId);
    }
    if (newVNode2.$children$) {
      for (i2 = 0; i2 < newVNode2.$children$.length; ++i2) {
        childNode = createElm(oldParentVNode, newVNode2, i2, elm);
        if (childNode) {
          elm.appendChild(childNode);
        }
      }
    }
    {
      if (newVNode2.$tag$ === "svg") {
        isSvgMode = false;
      } else if (elm.tagName === "foreignObject") {
        isSvgMode = true;
      }
    }
  }
  elm["s-hn"] = hostTagName;
  {
    if (newVNode2.$flags$ & (2 /* isSlotFallback */ | 1 /* isSlotReference */)) {
      elm["s-sr"] = true;
      elm["s-cr"] = contentRef;
      elm["s-sn"] = newVNode2.$name$ || "";
      elm["s-rf"] = (_a = newVNode2.$attrs$) == null ? void 0 : _a.ref;
      oldVNode = oldParentVNode && oldParentVNode.$children$ && oldParentVNode.$children$[childIndex];
      if (oldVNode && oldVNode.$tag$ === newVNode2.$tag$ && oldParentVNode.$elm$) {
        {
          putBackInOriginalLocation(oldParentVNode.$elm$, false);
        }
      }
    }
  }
  return elm;
};
var putBackInOriginalLocation = (parentElm, recursive) => {
  plt.$flags$ |= 1 /* isTmpDisconnected */;
  const oldSlotChildNodes = Array.from(parentElm.childNodes);
  if (parentElm["s-sr"] && BUILD.experimentalSlotFixes) {
    let node = parentElm;
    while (node = node.nextSibling) {
      if (node && node["s-sn"] === parentElm["s-sn"] && node["s-sh"] === hostTagName) {
        oldSlotChildNodes.push(node);
      }
    }
  }
  for (let i2 = oldSlotChildNodes.length - 1; i2 >= 0; i2--) {
    const childNode = oldSlotChildNodes[i2];
    if (childNode["s-hn"] !== hostTagName && childNode["s-ol"]) {
      parentReferenceNode(childNode).insertBefore(childNode, referenceNode(childNode));
      childNode["s-ol"].remove();
      childNode["s-ol"] = void 0;
      childNode["s-sh"] = void 0;
      checkSlotRelocate = true;
    }
    if (recursive) {
      putBackInOriginalLocation(childNode, recursive);
    }
  }
  plt.$flags$ &= ~1 /* isTmpDisconnected */;
};
var addVnodes = (parentElm, before, parentVNode, vnodes, startIdx, endIdx) => {
  let containerElm = parentElm["s-cr"] && parentElm["s-cr"].parentNode || parentElm;
  let childNode;
  if (containerElm.shadowRoot && containerElm.tagName === hostTagName) {
    containerElm = containerElm.shadowRoot;
  }
  for (; startIdx <= endIdx; ++startIdx) {
    if (vnodes[startIdx]) {
      childNode = createElm(null, parentVNode, startIdx, parentElm);
      if (childNode) {
        vnodes[startIdx].$elm$ = childNode;
        containerElm.insertBefore(childNode, referenceNode(before) );
      }
    }
  }
};
var removeVnodes = (vnodes, startIdx, endIdx) => {
  for (let index = startIdx; index <= endIdx; ++index) {
    const vnode = vnodes[index];
    if (vnode) {
      const elm = vnode.$elm$;
      nullifyVNodeRefs(vnode);
      if (elm) {
        {
          checkSlotFallbackVisibility = true;
          if (elm["s-ol"]) {
            elm["s-ol"].remove();
          } else {
            putBackInOriginalLocation(elm, true);
          }
        }
        elm.remove();
      }
    }
  }
};
var updateChildren = (parentElm, oldCh, newVNode2, newCh, isInitialRender = false) => {
  let oldStartIdx = 0;
  let newStartIdx = 0;
  let idxInOld = 0;
  let i2 = 0;
  let oldEndIdx = oldCh.length - 1;
  let oldStartVnode = oldCh[0];
  let oldEndVnode = oldCh[oldEndIdx];
  let newEndIdx = newCh.length - 1;
  let newStartVnode = newCh[0];
  let newEndVnode = newCh[newEndIdx];
  let node;
  let elmToMove;
  while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
    if (oldStartVnode == null) {
      oldStartVnode = oldCh[++oldStartIdx];
    } else if (oldEndVnode == null) {
      oldEndVnode = oldCh[--oldEndIdx];
    } else if (newStartVnode == null) {
      newStartVnode = newCh[++newStartIdx];
    } else if (newEndVnode == null) {
      newEndVnode = newCh[--newEndIdx];
    } else if (isSameVnode(oldStartVnode, newStartVnode, isInitialRender)) {
      patch(oldStartVnode, newStartVnode, isInitialRender);
      oldStartVnode = oldCh[++oldStartIdx];
      newStartVnode = newCh[++newStartIdx];
    } else if (isSameVnode(oldEndVnode, newEndVnode, isInitialRender)) {
      patch(oldEndVnode, newEndVnode, isInitialRender);
      oldEndVnode = oldCh[--oldEndIdx];
      newEndVnode = newCh[--newEndIdx];
    } else if (isSameVnode(oldStartVnode, newEndVnode, isInitialRender)) {
      if ((oldStartVnode.$tag$ === "slot" || newEndVnode.$tag$ === "slot")) {
        putBackInOriginalLocation(oldStartVnode.$elm$.parentNode, false);
      }
      patch(oldStartVnode, newEndVnode, isInitialRender);
      parentElm.insertBefore(oldStartVnode.$elm$, oldEndVnode.$elm$.nextSibling);
      oldStartVnode = oldCh[++oldStartIdx];
      newEndVnode = newCh[--newEndIdx];
    } else if (isSameVnode(oldEndVnode, newStartVnode, isInitialRender)) {
      if ((oldStartVnode.$tag$ === "slot" || newEndVnode.$tag$ === "slot")) {
        putBackInOriginalLocation(oldEndVnode.$elm$.parentNode, false);
      }
      patch(oldEndVnode, newStartVnode, isInitialRender);
      parentElm.insertBefore(oldEndVnode.$elm$, oldStartVnode.$elm$);
      oldEndVnode = oldCh[--oldEndIdx];
      newStartVnode = newCh[++newStartIdx];
    } else {
      idxInOld = -1;
      {
        for (i2 = oldStartIdx; i2 <= oldEndIdx; ++i2) {
          if (oldCh[i2] && oldCh[i2].$key$ !== null && oldCh[i2].$key$ === newStartVnode.$key$) {
            idxInOld = i2;
            break;
          }
        }
      }
      if (idxInOld >= 0) {
        elmToMove = oldCh[idxInOld];
        if (elmToMove.$tag$ !== newStartVnode.$tag$) {
          node = createElm(oldCh && oldCh[newStartIdx], newVNode2, idxInOld, parentElm);
        } else {
          patch(elmToMove, newStartVnode, isInitialRender);
          oldCh[idxInOld] = void 0;
          node = elmToMove.$elm$;
        }
        newStartVnode = newCh[++newStartIdx];
      } else {
        node = createElm(oldCh && oldCh[newStartIdx], newVNode2, newStartIdx, parentElm);
        newStartVnode = newCh[++newStartIdx];
      }
      if (node) {
        {
          parentReferenceNode(oldStartVnode.$elm$).insertBefore(node, referenceNode(oldStartVnode.$elm$));
        }
      }
    }
  }
  if (oldStartIdx > oldEndIdx) {
    addVnodes(
      parentElm,
      newCh[newEndIdx + 1] == null ? null : newCh[newEndIdx + 1].$elm$,
      newVNode2,
      newCh,
      newStartIdx,
      newEndIdx
    );
  } else if (newStartIdx > newEndIdx) {
    removeVnodes(oldCh, oldStartIdx, oldEndIdx);
  }
};
var isSameVnode = (leftVNode, rightVNode, isInitialRender = false) => {
  if (leftVNode.$tag$ === rightVNode.$tag$) {
    if (leftVNode.$tag$ === "slot") {
      return leftVNode.$name$ === rightVNode.$name$;
    }
    if (!isInitialRender) {
      return leftVNode.$key$ === rightVNode.$key$;
    }
    return true;
  }
  return false;
};
var referenceNode = (node) => {
  return node && node["s-ol"] || node;
};
var parentReferenceNode = (node) => (node["s-ol"] ? node["s-ol"] : node).parentNode;
var patch = (oldVNode, newVNode2, isInitialRender = false) => {
  const elm = newVNode2.$elm$ = oldVNode.$elm$;
  const oldChildren = oldVNode.$children$;
  const newChildren = newVNode2.$children$;
  const tag = newVNode2.$tag$;
  const text = newVNode2.$text$;
  let defaultHolder;
  if (text === null) {
    {
      isSvgMode = tag === "svg" ? true : tag === "foreignObject" ? false : isSvgMode;
    }
    {
      if (tag === "slot" && !useNativeShadowDom) ; else {
        updateElement(oldVNode, newVNode2, isSvgMode);
      }
    }
    if (oldChildren !== null && newChildren !== null) {
      updateChildren(elm, oldChildren, newVNode2, newChildren, isInitialRender);
    } else if (newChildren !== null) {
      if (oldVNode.$text$ !== null) {
        elm.textContent = "";
      }
      addVnodes(elm, null, newVNode2, newChildren, 0, newChildren.length - 1);
    } else if (oldChildren !== null) {
      removeVnodes(oldChildren, 0, oldChildren.length - 1);
    }
    if (isSvgMode && tag === "svg") {
      isSvgMode = false;
    }
  } else if ((defaultHolder = elm["s-cr"])) {
    defaultHolder.parentNode.textContent = text;
  } else if (oldVNode.$text$ !== text) {
    elm.data = text;
  }
};
var updateFallbackSlotVisibility = (elm) => {
  const childNodes = elm.childNodes;
  for (const childNode of childNodes) {
    if (childNode.nodeType === 1 /* ElementNode */) {
      if (childNode["s-sr"]) {
        const slotName = childNode["s-sn"];
        childNode.hidden = false;
        for (const siblingNode of childNodes) {
          if (siblingNode !== childNode) {
            if (siblingNode["s-hn"] !== childNode["s-hn"] || slotName !== "") {
              if (siblingNode.nodeType === 1 /* ElementNode */ && (slotName === siblingNode.getAttribute("slot") || slotName === siblingNode["s-sn"]) || siblingNode.nodeType === 3 /* TextNode */ && slotName === siblingNode["s-sn"]) {
                childNode.hidden = true;
                break;
              }
            } else {
              if (siblingNode.nodeType === 1 /* ElementNode */ || siblingNode.nodeType === 3 /* TextNode */ && siblingNode.textContent.trim() !== "") {
                childNode.hidden = true;
                break;
              }
            }
          }
        }
      }
      updateFallbackSlotVisibility(childNode);
    }
  }
};
var relocateNodes = [];
var markSlotContentForRelocation = (elm) => {
  let node;
  let hostContentNodes;
  let j;
  for (const childNode of elm.childNodes) {
    if (childNode["s-sr"] && (node = childNode["s-cr"]) && node.parentNode) {
      hostContentNodes = node.parentNode.childNodes;
      const slotName = childNode["s-sn"];
      for (j = hostContentNodes.length - 1; j >= 0; j--) {
        node = hostContentNodes[j];
        if (!node["s-cn"] && !node["s-nr"] && node["s-hn"] !== childNode["s-hn"] && (!BUILD.experimentalSlotFixes  )) {
          if (isNodeLocatedInSlot(node, slotName)) {
            let relocateNodeData = relocateNodes.find((r) => r.$nodeToRelocate$ === node);
            checkSlotFallbackVisibility = true;
            node["s-sn"] = node["s-sn"] || slotName;
            if (relocateNodeData) {
              relocateNodeData.$nodeToRelocate$["s-sh"] = childNode["s-hn"];
              relocateNodeData.$slotRefNode$ = childNode;
            } else {
              node["s-sh"] = childNode["s-hn"];
              relocateNodes.push({
                $slotRefNode$: childNode,
                $nodeToRelocate$: node
              });
            }
            if (node["s-sr"]) {
              relocateNodes.map((relocateNode) => {
                if (isNodeLocatedInSlot(relocateNode.$nodeToRelocate$, node["s-sn"])) {
                  relocateNodeData = relocateNodes.find((r) => r.$nodeToRelocate$ === node);
                  if (relocateNodeData && !relocateNode.$slotRefNode$) {
                    relocateNode.$slotRefNode$ = relocateNodeData.$slotRefNode$;
                  }
                }
              });
            }
          } else if (!relocateNodes.some((r) => r.$nodeToRelocate$ === node)) {
            relocateNodes.push({
              $nodeToRelocate$: node
            });
          }
        }
      }
    }
    if (childNode.nodeType === 1 /* ElementNode */) {
      markSlotContentForRelocation(childNode);
    }
  }
};
var isNodeLocatedInSlot = (nodeToRelocate, slotName) => {
  if (nodeToRelocate.nodeType === 1 /* ElementNode */) {
    if (nodeToRelocate.getAttribute("slot") === null && slotName === "") {
      return true;
    }
    if (nodeToRelocate.getAttribute("slot") === slotName) {
      return true;
    }
    return false;
  }
  if (nodeToRelocate["s-sn"] === slotName) {
    return true;
  }
  return slotName === "";
};
var nullifyVNodeRefs = (vNode) => {
  {
    vNode.$attrs$ && vNode.$attrs$.ref && vNode.$attrs$.ref(null);
    vNode.$children$ && vNode.$children$.map(nullifyVNodeRefs);
  }
};
var renderVdom = (hostRef, renderFnResults, isInitialLoad = false) => {
  var _a, _b, _c, _d;
  const hostElm = hostRef.$hostElement$;
  const cmpMeta = hostRef.$cmpMeta$;
  const oldVNode = hostRef.$vnode$ || newVNode(null, null);
  const rootVnode = isHost(renderFnResults) ? renderFnResults : h(null, null, renderFnResults);
  hostTagName = hostElm.tagName;
  if (cmpMeta.$attrsToReflect$) {
    rootVnode.$attrs$ = rootVnode.$attrs$ || {};
    cmpMeta.$attrsToReflect$.map(
      ([propName, attribute]) => rootVnode.$attrs$[attribute] = hostElm[propName]
    );
  }
  if (isInitialLoad && rootVnode.$attrs$) {
    for (const key of Object.keys(rootVnode.$attrs$)) {
      if (hostElm.hasAttribute(key) && !["key", "ref", "style", "class"].includes(key)) {
        rootVnode.$attrs$[key] = hostElm[key];
      }
    }
  }
  rootVnode.$tag$ = null;
  rootVnode.$flags$ |= 4 /* isHost */;
  hostRef.$vnode$ = rootVnode;
  rootVnode.$elm$ = oldVNode.$elm$ = hostElm.shadowRoot || hostElm ;
  {
    scopeId = hostElm["s-sc"];
  }
  useNativeShadowDom = supportsShadow ;
  {
    contentRef = hostElm["s-cr"];
    checkSlotFallbackVisibility = false;
  }
  patch(oldVNode, rootVnode, isInitialLoad);
  {
    plt.$flags$ |= 1 /* isTmpDisconnected */;
    if (checkSlotRelocate) {
      markSlotContentForRelocation(rootVnode.$elm$);
      for (const relocateData of relocateNodes) {
        const nodeToRelocate = relocateData.$nodeToRelocate$;
        if (!nodeToRelocate["s-ol"]) {
          const orgLocationNode = originalLocationDebugNode(nodeToRelocate) ;
          orgLocationNode["s-nr"] = nodeToRelocate;
          nodeToRelocate.parentNode.insertBefore(nodeToRelocate["s-ol"] = orgLocationNode, nodeToRelocate);
        }
      }
      for (const relocateData of relocateNodes) {
        const nodeToRelocate = relocateData.$nodeToRelocate$;
        const slotRefNode = relocateData.$slotRefNode$;
        if (slotRefNode) {
          const parentNodeRef = slotRefNode.parentNode;
          let insertBeforeNode = slotRefNode.nextSibling;
          {
            let orgLocationNode = (_a = nodeToRelocate["s-ol"]) == null ? void 0 : _a.previousSibling;
            while (orgLocationNode) {
              let refNode = (_b = orgLocationNode["s-nr"]) != null ? _b : null;
              if (refNode && refNode["s-sn"] === nodeToRelocate["s-sn"] && parentNodeRef === refNode.parentNode) {
                refNode = refNode.nextSibling;
                while (refNode === nodeToRelocate || (refNode == null ? void 0 : refNode["s-sr"])) {
                  refNode = refNode == null ? void 0 : refNode.nextSibling;
                }
                if (!refNode || !refNode["s-nr"]) {
                  insertBeforeNode = refNode;
                  break;
                }
              }
              orgLocationNode = orgLocationNode.previousSibling;
            }
          }
          if (!insertBeforeNode && parentNodeRef !== nodeToRelocate.parentNode || nodeToRelocate.nextSibling !== insertBeforeNode) {
            if (nodeToRelocate !== insertBeforeNode) {
              if (!nodeToRelocate["s-hn"] && nodeToRelocate["s-ol"]) {
                nodeToRelocate["s-hn"] = nodeToRelocate["s-ol"].parentNode.nodeName;
              }
              parentNodeRef.insertBefore(nodeToRelocate, insertBeforeNode);
              if (nodeToRelocate.nodeType === 1 /* ElementNode */) {
                nodeToRelocate.hidden = (_c = nodeToRelocate["s-ih"]) != null ? _c : false;
              }
            }
          }
          nodeToRelocate && typeof slotRefNode["s-rf"] === "function" && slotRefNode["s-rf"](nodeToRelocate);
        } else {
          if (nodeToRelocate.nodeType === 1 /* ElementNode */) {
            if (isInitialLoad) {
              nodeToRelocate["s-ih"] = (_d = nodeToRelocate.hidden) != null ? _d : false;
            }
            nodeToRelocate.hidden = true;
          }
        }
      }
    }
    if (checkSlotFallbackVisibility) {
      updateFallbackSlotVisibility(rootVnode.$elm$);
    }
    plt.$flags$ &= ~1 /* isTmpDisconnected */;
    relocateNodes.length = 0;
  }
  contentRef = void 0;
};
var slotReferenceDebugNode = (slotVNode) => doc.createComment(
  `<slot${slotVNode.$name$ ? ' name="' + slotVNode.$name$ + '"' : ""}> (host=${hostTagName.toLowerCase()})`
);
var originalLocationDebugNode = (nodeToRelocate) => doc.createComment(
  `org-location for ` + (nodeToRelocate.localName ? `<${nodeToRelocate.localName}> (host=${nodeToRelocate["s-hn"]})` : `[${nodeToRelocate.textContent}]`)
);

// src/runtime/update-component.ts
var attachToAncestor = (hostRef, ancestorComponent) => {
  if (ancestorComponent && !hostRef.$onRenderResolve$ && ancestorComponent["s-p"]) {
    ancestorComponent["s-p"].push(new Promise((r) => hostRef.$onRenderResolve$ = r));
  }
};
var scheduleUpdate = (hostRef, isInitialLoad) => {
  {
    hostRef.$flags$ |= 16 /* isQueuedForUpdate */;
  }
  if (hostRef.$flags$ & 4 /* isWaitingForChildren */) {
    hostRef.$flags$ |= 512 /* needsRerender */;
    return;
  }
  attachToAncestor(hostRef, hostRef.$ancestorComponent$);
  const dispatch = () => dispatchHooks(hostRef, isInitialLoad);
  return writeTask(dispatch) ;
};
var dispatchHooks = (hostRef, isInitialLoad) => {
  const endSchedule = createTime("scheduleUpdate", hostRef.$cmpMeta$.$tagName$);
  const instance = hostRef.$lazyInstance$ ;
  let maybePromise;
  if (isInitialLoad) {
    {
      hostRef.$flags$ |= 256 /* isListenReady */;
      if (hostRef.$queuedListeners$) {
        hostRef.$queuedListeners$.map(([methodName, event]) => safeCall(instance, methodName, event));
        hostRef.$queuedListeners$ = void 0;
      }
    }
    {
      maybePromise = safeCall(instance, "componentWillLoad");
    }
  }
  {
    maybePromise = enqueue(maybePromise, () => safeCall(instance, "componentWillRender"));
  }
  endSchedule();
  return enqueue(maybePromise, () => updateComponent(hostRef, instance, isInitialLoad));
};
var enqueue = (maybePromise, fn) => isPromisey(maybePromise) ? maybePromise.then(fn) : fn();
var isPromisey = (maybePromise) => maybePromise instanceof Promise || maybePromise && maybePromise.then && typeof maybePromise.then === "function";
var updateComponent = async (hostRef, instance, isInitialLoad) => {
  var _a;
  const elm = hostRef.$hostElement$;
  const endUpdate = createTime("update", hostRef.$cmpMeta$.$tagName$);
  const rc = elm["s-rc"];
  if (isInitialLoad) {
    attachStyles(hostRef);
  }
  const endRender = createTime("render", hostRef.$cmpMeta$.$tagName$);
  {
    await callRender(hostRef, instance, elm, isInitialLoad);
  }
  {
    try {
      serverSideConnected(elm);
      if (isInitialLoad) {
        if (hostRef.$cmpMeta$.$flags$ & 1 /* shadowDomEncapsulation */) {
          elm["s-en"] = "";
        } else if (hostRef.$cmpMeta$.$flags$ & 2 /* scopedCssEncapsulation */) {
          elm["s-en"] = "c";
        }
      }
    } catch (e) {
      consoleError(e, elm);
    }
  }
  if (rc) {
    rc.map((cb) => cb());
    elm["s-rc"] = void 0;
  }
  endRender();
  endUpdate();
  {
    const childrenPromises = (_a = elm["s-p"]) != null ? _a : [];
    const postUpdate = () => postUpdateComponent(hostRef);
    if (childrenPromises.length === 0) {
      postUpdate();
    } else {
      Promise.all(childrenPromises).then(postUpdate);
      hostRef.$flags$ |= 4 /* isWaitingForChildren */;
      childrenPromises.length = 0;
    }
  }
};
var callRender = (hostRef, instance, elm, isInitialLoad) => {
  try {
    instance = instance.render() ;
    {
      hostRef.$flags$ &= ~16 /* isQueuedForUpdate */;
    }
    {
      hostRef.$flags$ |= 2 /* hasRendered */;
    }
    {
      {
        {
          return Promise.resolve(instance).then((value) => renderVdom(hostRef, value, isInitialLoad));
        }
      }
    }
  } catch (e) {
    consoleError(e, hostRef.$hostElement$);
  }
  return null;
};
var postUpdateComponent = (hostRef) => {
  const tagName = hostRef.$cmpMeta$.$tagName$;
  const elm = hostRef.$hostElement$;
  const endPostUpdate = createTime("postUpdate", tagName);
  const instance = hostRef.$lazyInstance$ ;
  const ancestorComponent = hostRef.$ancestorComponent$;
  {
    safeCall(instance, "componentDidRender");
  }
  if (!(hostRef.$flags$ & 64 /* hasLoadedComponent */)) {
    hostRef.$flags$ |= 64 /* hasLoadedComponent */;
    {
      addHydratedFlag(elm);
    }
    {
      safeCall(instance, "componentDidLoad");
    }
    endPostUpdate();
    {
      hostRef.$onReadyResolve$(elm);
      if (!ancestorComponent) {
        appDidLoad();
      }
    }
  } else {
    endPostUpdate();
  }
  {
    hostRef.$onInstanceResolve$(elm);
  }
  {
    if (hostRef.$onRenderResolve$) {
      hostRef.$onRenderResolve$();
      hostRef.$onRenderResolve$ = void 0;
    }
    if (hostRef.$flags$ & 512 /* needsRerender */) {
      nextTick(() => scheduleUpdate(hostRef, false));
    }
    hostRef.$flags$ &= ~(4 /* isWaitingForChildren */ | 512 /* needsRerender */);
  }
};
var forceUpdate = (ref) => {
  return false;
};
var appDidLoad = (who) => {
  {
    addHydratedFlag(doc.documentElement);
  }
  nextTick(() => emitEvent(win, "appload", { detail: { namespace: NAMESPACE } }));
};
var safeCall = (instance, method, arg) => {
  if (instance && instance[method]) {
    try {
      return instance[method](arg);
    } catch (e) {
      consoleError(e);
    }
  }
  return void 0;
};
var addHydratedFlag = (elm) => elm.classList.add("hydrated") ;
var serverSideConnected = (elm) => {
  const children = elm.children;
  if (children != null) {
    for (let i2 = 0, ii = children.length; i2 < ii; i2++) {
      const childElm = children[i2];
      if (typeof childElm.connectedCallback === "function") {
        childElm.connectedCallback();
      }
      serverSideConnected(childElm);
    }
  }
};

// src/runtime/set-value.ts
var getValue = (ref, propName) => getHostRef(ref).$instanceValues$.get(propName);
var setValue = (ref, propName, newVal, cmpMeta) => {
  const hostRef = getHostRef(ref);
  const elm = hostRef.$hostElement$ ;
  const oldVal = hostRef.$instanceValues$.get(propName);
  const flags = hostRef.$flags$;
  const instance = hostRef.$lazyInstance$ ;
  newVal = parsePropertyValue(newVal, cmpMeta.$members$[propName][0]);
  const areBothNaN = Number.isNaN(oldVal) && Number.isNaN(newVal);
  const didValueChange = newVal !== oldVal && !areBothNaN;
  if ((!(flags & 8 /* isConstructingInstance */) || oldVal === void 0) && didValueChange) {
    hostRef.$instanceValues$.set(propName, newVal);
    if (instance) {
      if (cmpMeta.$watchers$ && flags & 128 /* isWatchReady */) {
        const watchMethods = cmpMeta.$watchers$[propName];
        if (watchMethods) {
          watchMethods.map((watchMethodName) => {
            try {
              instance[watchMethodName](newVal, oldVal, propName);
            } catch (e) {
              consoleError(e, elm);
            }
          });
        }
      }
      if ((flags & (2 /* hasRendered */ | 16 /* isQueuedForUpdate */)) === 2 /* hasRendered */) {
        scheduleUpdate(hostRef, false);
      }
    }
  }
};

// src/runtime/proxy-component.ts
var proxyComponent = (Cstr, cmpMeta, flags) => {
  var _a;
  const prototype = Cstr.prototype;
  if (cmpMeta.$members$) {
    if (Cstr.watchers) {
      cmpMeta.$watchers$ = Cstr.watchers;
    }
    const members = Object.entries(cmpMeta.$members$);
    members.map(([memberName, [memberFlags]]) => {
      if ((memberFlags & 31 /* Prop */ || (flags & 2 /* proxyState */) && memberFlags & 32 /* State */)) {
        Object.defineProperty(prototype, memberName, {
          get() {
            return getValue(this, memberName);
          },
          set(newValue) {
            setValue(this, memberName, newValue, cmpMeta);
          },
          configurable: true,
          enumerable: true
        });
      } else if (flags & 1 /* isElementConstructor */ && memberFlags & 64 /* Method */) {
        Object.defineProperty(prototype, memberName, {
          value(...args) {
            var _a2;
            const ref = getHostRef(this);
            return (_a2 = ref == null ? void 0 : ref.$onInstancePromise$) == null ? void 0 : _a2.then(() => {
              var _a3;
              return (_a3 = ref.$lazyInstance$) == null ? void 0 : _a3[memberName](...args);
            });
          }
        });
      }
    });
    if ((flags & 1 /* isElementConstructor */)) {
      const attrNameToPropName = /* @__PURE__ */ new Map();
      prototype.attributeChangedCallback = function(attrName, oldValue, newValue) {
        plt.jmp(() => {
          var _a2;
          const propName = attrNameToPropName.get(attrName);
          if (this.hasOwnProperty(propName)) {
            newValue = this[propName];
            delete this[propName];
          } else if (prototype.hasOwnProperty(propName) && typeof this[propName] === "number" && this[propName] == newValue) {
            return;
          } else if (propName == null) {
            const hostRef = getHostRef(this);
            const flags2 = hostRef == null ? void 0 : hostRef.$flags$;
            if (flags2 && !(flags2 & 8 /* isConstructingInstance */) && flags2 & 128 /* isWatchReady */ && newValue !== oldValue) {
              const instance = hostRef.$lazyInstance$ ;
              const entry = (_a2 = cmpMeta.$watchers$) == null ? void 0 : _a2[attrName];
              entry == null ? void 0 : entry.forEach((callbackName) => {
                if (instance[callbackName] != null) {
                  instance[callbackName].call(instance, newValue, oldValue, attrName);
                }
              });
            }
            return;
          }
          this[propName] = newValue === null && typeof this[propName] === "boolean" ? false : newValue;
        });
      };
      Cstr.observedAttributes = Array.from(
        /* @__PURE__ */ new Set([
          ...Object.keys((_a = cmpMeta.$watchers$) != null ? _a : {}),
          ...members.filter(([_, m]) => m[0] & 15 /* HasAttribute */).map(([propName, m]) => {
            var _a2;
            const attrName = m[1] || propName;
            attrNameToPropName.set(attrName, propName);
            if (m[0] & 512 /* ReflectAttr */) {
              (_a2 = cmpMeta.$attrsToReflect$) == null ? void 0 : _a2.push([propName, attrName]);
            }
            return attrName;
          })
        ])
      );
    }
  }
  return Cstr;
};

// src/runtime/initialize-component.ts
var initializeComponent = async (elm, hostRef, cmpMeta, hmrVersionId) => {
  let Cstr;
  if ((hostRef.$flags$ & 32 /* hasInitializedComponent */) === 0) {
    hostRef.$flags$ |= 32 /* hasInitializedComponent */;
    const bundleId = cmpMeta.$lazyBundleId$;
    if (bundleId) {
      Cstr = loadModule(cmpMeta);
      if (Cstr.then) {
        const endLoad = uniqueTime();
        Cstr = await Cstr;
        endLoad();
      }
      if (!Cstr.isProxied) {
        {
          cmpMeta.$watchers$ = Cstr.watchers;
        }
        proxyComponent(Cstr, cmpMeta, 2 /* proxyState */);
        Cstr.isProxied = true;
      }
      const endNewInstance = createTime("createInstance", cmpMeta.$tagName$);
      {
        hostRef.$flags$ |= 8 /* isConstructingInstance */;
      }
      try {
        new Cstr(hostRef);
      } catch (e) {
        consoleError(e);
      }
      {
        hostRef.$flags$ &= ~8 /* isConstructingInstance */;
      }
      {
        hostRef.$flags$ |= 128 /* isWatchReady */;
      }
      endNewInstance();
      fireConnectedCallback(hostRef.$lazyInstance$);
    } else {
      Cstr = elm.constructor;
      customElements.whenDefined(cmpMeta.$tagName$).then(() => hostRef.$flags$ |= 128 /* isWatchReady */);
    }
    if (Cstr.style) {
      let style = Cstr.style;
      const scopeId2 = getScopeId(cmpMeta);
      if (!styles.has(scopeId2)) {
        const endRegisterStyles = createTime("registerStyles", cmpMeta.$tagName$);
        registerStyle(scopeId2, style);
        endRegisterStyles();
      }
    }
  }
  const ancestorComponent = hostRef.$ancestorComponent$;
  const schedule = () => scheduleUpdate(hostRef, true);
  if (ancestorComponent && ancestorComponent["s-rc"]) {
    ancestorComponent["s-rc"].push(schedule);
  } else {
    schedule();
  }
};
var fireConnectedCallback = (instance) => {
  {
    safeCall(instance, "connectedCallback");
  }
};

// src/runtime/connected-callback.ts
var connectedCallback = (elm) => {
  if ((plt.$flags$ & 1 /* isTmpDisconnected */) === 0) {
    const hostRef = getHostRef(elm);
    const cmpMeta = hostRef.$cmpMeta$;
    const endConnected = createTime("connectedCallback", cmpMeta.$tagName$);
    if (!(hostRef.$flags$ & 1 /* hasConnected */)) {
      hostRef.$flags$ |= 1 /* hasConnected */;
      let hostId;
      {
        hostId = elm.getAttribute(HYDRATE_ID);
        if (hostId) {
          initializeClientHydrate(elm, cmpMeta.$tagName$, hostId, hostRef);
        }
      }
      if (!hostId) {
        {
          setContentReference(elm);
        }
      }
      {
        let ancestorComponent = elm;
        while (ancestorComponent = ancestorComponent.parentNode || ancestorComponent.host) {
          if (ancestorComponent.nodeType === 1 /* ElementNode */ && ancestorComponent.hasAttribute("s-id") && ancestorComponent["s-p"] || ancestorComponent["s-p"]) {
            attachToAncestor(hostRef, hostRef.$ancestorComponent$ = ancestorComponent);
            break;
          }
        }
      }
      {
        initializeComponent(elm, hostRef, cmpMeta);
      }
    } else {
      addHostEventListeners(elm, hostRef, cmpMeta.$listeners$);
      if (hostRef == null ? void 0 : hostRef.$lazyInstance$) {
        fireConnectedCallback(hostRef.$lazyInstance$);
      } else if (hostRef == null ? void 0 : hostRef.$onReadyPromise$) {
        hostRef.$onReadyPromise$.then(() => fireConnectedCallback(hostRef.$lazyInstance$));
      }
    }
    endConnected();
  }
};
var setContentReference = (elm) => {
  const contentRefElm = elm["s-cr"] = doc.createComment(
    ""
  );
  contentRefElm["s-cn"] = true;
  elm.insertBefore(contentRefElm, elm.firstChild);
};

// src/runtime/fragment.ts
var Fragment = (_, children) => children;
var addHostEventListeners = (elm, hostRef, listeners, attachParentListeners) => {
  if (listeners) {
    listeners.map(([flags, name, method]) => {
      const target = getHostListenerTarget(elm, flags) ;
      const handler = hostListenerProxy(hostRef, method);
      const opts = hostListenerOpts(flags);
      plt.ael(target, name, handler, opts);
      (hostRef.$rmListeners$ = hostRef.$rmListeners$ || []).push(() => plt.rel(target, name, handler, opts));
    });
  }
};
var hostListenerProxy = (hostRef, methodName) => (ev) => {
  try {
    {
      if (hostRef.$flags$ & 256 /* isListenReady */) {
        hostRef.$lazyInstance$[methodName](ev);
      } else {
        (hostRef.$queuedListeners$ = hostRef.$queuedListeners$ || []).push([methodName, ev]);
      }
    }
  } catch (e) {
    consoleError(e);
  }
};
var getHostListenerTarget = (elm, flags) => {
  if (flags & 8 /* TargetWindow */)
    return win;
  return elm;
};
var hostListenerOpts = (flags) => (flags & 2 /* Capture */) !== 0;

// src/runtime/vdom/vdom-annotations.ts
var insertVdomAnnotations = (doc2, staticComponents) => {
  if (doc2 != null) {
    const docData = {
      hostIds: 0,
      rootLevelIds: 0,
      staticComponents: new Set(staticComponents)
    };
    const orgLocationNodes = [];
    parseVNodeAnnotations(doc2, doc2.body, docData, orgLocationNodes);
    orgLocationNodes.forEach((orgLocationNode) => {
      var _a, _b;
      if (orgLocationNode != null && orgLocationNode["s-nr"]) {
        const nodeRef = orgLocationNode["s-nr"];
        let hostId = nodeRef["s-host-id"];
        let nodeId = nodeRef["s-node-id"];
        let childId = `${hostId}.${nodeId}`;
        if (hostId == null) {
          hostId = 0;
          docData.rootLevelIds++;
          nodeId = docData.rootLevelIds;
          childId = `${hostId}.${nodeId}`;
          if (nodeRef.nodeType === 1 /* ElementNode */) {
            nodeRef.setAttribute(HYDRATE_CHILD_ID, childId);
          } else if (nodeRef.nodeType === 3 /* TextNode */) {
            if (hostId === 0) {
              const textContent = (_a = nodeRef.nodeValue) == null ? void 0 : _a.trim();
              if (textContent === "") {
                orgLocationNode.remove();
                return;
              }
            }
            const commentBeforeTextNode = doc2.createComment(childId);
            commentBeforeTextNode.nodeValue = `${TEXT_NODE_ID}.${childId}`;
            (_b = nodeRef.parentNode) == null ? void 0 : _b.insertBefore(commentBeforeTextNode, nodeRef);
          }
        }
        let orgLocationNodeId = `${ORG_LOCATION_ID}.${childId}`;
        const orgLocationParentNode = orgLocationNode.parentElement;
        if (orgLocationParentNode) {
          if (orgLocationParentNode["s-en"] === "") {
            orgLocationNodeId += `.`;
          } else if (orgLocationParentNode["s-en"] === "c") {
            orgLocationNodeId += `.c`;
          }
        }
        orgLocationNode.nodeValue = orgLocationNodeId;
      }
    });
  }
};
var parseVNodeAnnotations = (doc2, node, docData, orgLocationNodes) => {
  if (node == null) {
    return;
  }
  if (node["s-nr"] != null) {
    orgLocationNodes.push(node);
  }
  if (node.nodeType === 1 /* ElementNode */) {
    node.childNodes.forEach((childNode) => {
      const hostRef = getHostRef(childNode);
      if (hostRef != null && !docData.staticComponents.has(childNode.nodeName.toLowerCase())) {
        const cmpData = {
          nodeIds: 0
        };
        insertVNodeAnnotations(doc2, childNode, hostRef.$vnode$, docData, cmpData);
      }
      parseVNodeAnnotations(doc2, childNode, docData, orgLocationNodes);
    });
  }
};
var insertVNodeAnnotations = (doc2, hostElm, vnode, docData, cmpData) => {
  if (vnode != null) {
    const hostId = ++docData.hostIds;
    hostElm.setAttribute(HYDRATE_ID, hostId);
    if (hostElm["s-cr"] != null) {
      hostElm["s-cr"].nodeValue = `${CONTENT_REF_ID}.${hostId}`;
    }
    if (vnode.$children$ != null) {
      const depth = 0;
      vnode.$children$.forEach((vnodeChild, index) => {
        insertChildVNodeAnnotations(doc2, vnodeChild, cmpData, hostId, depth, index);
      });
    }
    if (hostElm && vnode && vnode.$elm$ && !hostElm.hasAttribute(HYDRATE_CHILD_ID)) {
      const parent = hostElm.parentElement;
      if (parent && parent.childNodes) {
        const parentChildNodes = Array.from(parent.childNodes);
        const comment = parentChildNodes.find(
          (node) => node.nodeType === 8 /* CommentNode */ && node["s-sr"]
        );
        if (comment) {
          const index = parentChildNodes.indexOf(hostElm) - 1;
          vnode.$elm$.setAttribute(
            HYDRATE_CHILD_ID,
            `${comment["s-host-id"]}.${comment["s-node-id"]}.0.${index}`
          );
        }
      }
    }
  }
};
var insertChildVNodeAnnotations = (doc2, vnodeChild, cmpData, hostId, depth, index) => {
  const childElm = vnodeChild.$elm$;
  if (childElm == null) {
    return;
  }
  const nodeId = cmpData.nodeIds++;
  const childId = `${hostId}.${nodeId}.${depth}.${index}`;
  childElm["s-host-id"] = hostId;
  childElm["s-node-id"] = nodeId;
  if (childElm.nodeType === 1 /* ElementNode */) {
    childElm.setAttribute(HYDRATE_CHILD_ID, childId);
  } else if (childElm.nodeType === 3 /* TextNode */) {
    const parentNode = childElm.parentNode;
    const nodeName = parentNode == null ? void 0 : parentNode.nodeName;
    if (nodeName !== "STYLE" && nodeName !== "SCRIPT") {
      const textNodeId = `${TEXT_NODE_ID}.${childId}`;
      const commentBeforeTextNode = doc2.createComment(textNodeId);
      parentNode == null ? void 0 : parentNode.insertBefore(commentBeforeTextNode, childElm);
    }
  } else if (childElm.nodeType === 8 /* CommentNode */) {
    if (childElm["s-sr"]) {
      const slotName = childElm["s-sn"] || "";
      const slotNodeId = `${SLOT_NODE_ID}.${childId}.${slotName}`;
      childElm.nodeValue = slotNodeId;
    }
  }
  if (vnodeChild.$children$ != null) {
    const childDepth = depth + 1;
    vnodeChild.$children$.forEach((vnode, index2) => {
      insertChildVNodeAnnotations(doc2, vnode, cmpData, hostId, childDepth, index2);
    });
  }
};

// src/hydrate/platform/h-async.ts
var hAsync = (nodeName, vnodeData, ...children) => {
  if (Array.isArray(children) && children.length > 0) {
    const flatChildren = children.flat(Infinity);
    if (flatChildren.some(isPromise)) {
      return Promise.all(flatChildren).then((resolvedChildren) => {
        return h(nodeName, vnodeData, ...resolvedChildren);
      }).catch((err2) => {
        return h(nodeName, vnodeData);
      });
    }
    return h(nodeName, vnodeData, ...children);
  }
  return h(nodeName, vnodeData);
};

// src/hydrate/platform/proxy-host-element.ts
function proxyHostElement(elm, cmpMeta) {
  if (typeof elm.componentOnReady !== "function") {
    elm.componentOnReady = componentOnReady;
  }
  if (typeof elm.forceUpdate !== "function") {
    elm.forceUpdate = forceUpdate2;
  }
  if (cmpMeta.$flags$ & 1 /* shadowDomEncapsulation */) {
    elm.shadowRoot = elm;
  }
  if (cmpMeta.$members$ != null) {
    const hostRef = getHostRef(elm);
    const members = Object.entries(cmpMeta.$members$);
    members.forEach(([memberName, m]) => {
      const memberFlags = m[0];
      if (memberFlags & 31 /* Prop */) {
        const attributeName = m[1] || memberName;
        const attrValue = elm.getAttribute(attributeName);
        if (attrValue != null) {
          const parsedAttrValue = parsePropertyValue(attrValue, memberFlags);
          hostRef.$instanceValues$.set(memberName, parsedAttrValue);
        }
        const ownValue = elm[memberName];
        if (ownValue !== void 0) {
          hostRef.$instanceValues$.set(memberName, ownValue);
          delete elm[memberName];
        }
        Object.defineProperty(elm, memberName, {
          get() {
            return getValue(this, memberName);
          },
          set(newValue) {
            setValue(this, memberName, newValue, cmpMeta);
          },
          configurable: true,
          enumerable: true
        });
      } else if (memberFlags & 64 /* Method */) {
        Object.defineProperty(elm, memberName, {
          value(...args) {
            const ref = getHostRef(this);
            return ref.$onInstancePromise$.then(() => ref.$lazyInstance$[memberName](...args)).catch(consoleError);
          }
        });
      }
    });
  }
}
function componentOnReady() {
  return getHostRef(this).$onReadyPromise$;
}
function forceUpdate2() {
}

// src/hydrate/platform/hydrate-app.ts
function hydrateApp(win2, opts, results, afterHydrate, resolve) {
  const connectedElements = /* @__PURE__ */ new Set();
  const createdElements = /* @__PURE__ */ new Set();
  const waitingElements = /* @__PURE__ */ new Set();
  const orgDocumentCreateElement = win2.document.createElement;
  const orgDocumentCreateElementNS = win2.document.createElementNS;
  const resolved2 = Promise.resolve();
  let tmrId;
  let ranCompleted = false;
  function hydratedComplete() {
    global.clearTimeout(tmrId);
    createdElements.clear();
    connectedElements.clear();
    if (!ranCompleted) {
      ranCompleted = true;
      try {
        if (opts.clientHydrateAnnotations) {
          insertVdomAnnotations(win2.document, opts.staticComponents);
        }
        win2.dispatchEvent(new win2.Event("DOMContentLoaded"));
        win2.document.createElement = orgDocumentCreateElement;
        win2.document.createElementNS = orgDocumentCreateElementNS;
      } catch (e) {
        renderCatchError(opts, results, e);
      }
    }
    afterHydrate(win2, opts, results, resolve);
  }
  function hydratedError(err2) {
    renderCatchError(opts, results, err2);
    hydratedComplete();
  }
  function timeoutExceeded() {
    hydratedError(`Hydrate exceeded timeout${waitingOnElementsMsg(waitingElements)}`);
  }
  try {
    let patchedConnectedCallback2 = function() {
      return connectElement2(this);
    }, patchElement2 = function(elm) {
      if (isValidComponent(elm, opts)) {
        const hostRef = getHostRef(elm);
        if (!hostRef) {
          const Cstr = loadModule(
            {
              $tagName$: elm.nodeName.toLowerCase(),
              $flags$: null
            });
          if (Cstr != null && Cstr.cmpMeta != null) {
            createdElements.add(elm);
            elm.connectedCallback = patchedConnectedCallback2;
            registerHost(elm, Cstr.cmpMeta);
            proxyHostElement(elm, Cstr.cmpMeta);
          }
        }
      }
    }, patchChild2 = function(elm) {
      if (elm != null && elm.nodeType === 1) {
        patchElement2(elm);
        const children = elm.children;
        for (let i2 = 0, ii = children.length; i2 < ii; i2++) {
          patchChild2(children[i2]);
        }
      }
    }, connectElement2 = function(elm) {
      createdElements.delete(elm);
      if (isValidComponent(elm, opts) && results.hydratedCount < opts.maxHydrateCount) {
        if (!connectedElements.has(elm) && shouldHydrate(elm)) {
          connectedElements.add(elm);
          return hydrateComponent(win2, results, elm.nodeName, elm, waitingElements);
        }
      }
      return resolved2;
    }, waitLoop2 = function() {
      const toConnect = Array.from(createdElements).filter((elm) => elm.parentElement);
      if (toConnect.length > 0) {
        return Promise.all(toConnect.map(connectElement2)).then(waitLoop2);
      }
      return resolved2;
    };
    win2.document.createElement = function patchedCreateElement(tagName) {
      const elm = orgDocumentCreateElement.call(win2.document, tagName);
      patchElement2(elm);
      return elm;
    };
    win2.document.createElementNS = function patchedCreateElement(namespaceURI, tagName) {
      const elm = orgDocumentCreateElementNS.call(win2.document, namespaceURI, tagName);
      patchElement2(elm);
      return elm;
    };
    tmrId = global.setTimeout(timeoutExceeded, opts.timeout);
    plt.$resourcesUrl$ = new URL(opts.resourcesUrl || "./", doc.baseURI).href;
    patchChild2(win2.document.body);
    waitLoop2().then(hydratedComplete).catch(hydratedError);
  } catch (e) {
    hydratedError(e);
  }
}
async function hydrateComponent(win2, results, tagName, elm, waitingElements) {
  tagName = tagName.toLowerCase();
  const Cstr = loadModule(
    {
      $tagName$: tagName,
      $flags$: null
    });
  if (Cstr != null) {
    const cmpMeta = Cstr.cmpMeta;
    if (cmpMeta != null) {
      waitingElements.add(elm);
      try {
        connectedCallback(elm);
        await elm.componentOnReady();
        results.hydratedCount++;
        const ref = getHostRef(elm);
        const modeName = !ref.$modeName$ ? "$" : ref.$modeName$;
        if (!results.components.some((c) => c.tag === tagName && c.mode === modeName)) {
          results.components.push({
            tag: tagName,
            mode: modeName,
            count: 0,
            depth: -1
          });
        }
      } catch (e) {
        win2.console.error(e);
      }
      waitingElements.delete(elm);
    }
  }
}
function isValidComponent(elm, opts) {
  if (elm != null && elm.nodeType === 1) {
    const tagName = elm.nodeName;
    if (typeof tagName === "string" && tagName.includes("-")) {
      if (opts.excludeComponents.includes(tagName.toLowerCase())) {
        return false;
      }
      return true;
    }
  }
  return false;
}
function shouldHydrate(elm) {
  if (elm.nodeType === 9) {
    return true;
  }
  if (NO_HYDRATE_TAGS.has(elm.nodeName)) {
    return false;
  }
  if (elm.hasAttribute("no-prerender")) {
    return false;
  }
  const parentNode = elm.parentNode;
  if (parentNode == null) {
    return true;
  }
  return shouldHydrate(parentNode);
}
var NO_HYDRATE_TAGS = /* @__PURE__ */ new Set([
  "CODE",
  "HEAD",
  "IFRAME",
  "INPUT",
  "OBJECT",
  "OUTPUT",
  "NOSCRIPT",
  "PRE",
  "SCRIPT",
  "SELECT",
  "STYLE",
  "TEMPLATE",
  "TEXTAREA"
]);
function renderCatchError(opts, results, err2) {
  const diagnostic = {
    level: "error",
    type: "build",
    header: "Hydrate Error",
    messageText: "",
    relFilePath: void 0,
    absFilePath: void 0,
    lines: []
  };
  if (opts.url) {
    try {
      const u = new URL(opts.url);
      if (u.pathname !== "/") {
        diagnostic.header += ": " + u.pathname;
      }
    } catch (e) {
    }
  }
  if (err2 != null) {
    if (err2.stack != null) {
      diagnostic.messageText = err2.stack.toString();
    } else if (err2.message != null) {
      diagnostic.messageText = err2.message.toString();
    } else {
      diagnostic.messageText = err2.toString();
    }
  }
  results.diagnostics.push(diagnostic);
}
function printTag(elm) {
  let tag = `<${elm.nodeName.toLowerCase()}`;
  if (Array.isArray(elm.attributes)) {
    for (let i2 = 0; i2 < elm.attributes.length; i2++) {
      const attr = elm.attributes[i2];
      tag += ` ${attr.name}`;
      if (attr.value !== "") {
        tag += `="${attr.value}"`;
      }
    }
  }
  tag += `>`;
  return tag;
}
function waitingOnElementMsg(waitingElement) {
  let msg = "";
  if (waitingElement) {
    const lines = [];
    msg = " - waiting on:";
    let elm = waitingElement;
    while (elm && elm.nodeType !== 9 && elm.nodeName !== "BODY") {
      lines.unshift(printTag(elm));
      elm = elm.parentElement;
    }
    let indent = "";
    for (const ln of lines) {
      indent += "  ";
      msg += `
${indent}${ln}`;
    }
  }
  return msg;
}
function waitingOnElementsMsg(waitingElements) {
  return Array.from(waitingElements).map(waitingOnElementMsg);
}
var cmpModules = /* @__PURE__ */ new Map();
var getModule = (tagName) => {
  if (typeof tagName === "string") {
    tagName = tagName.toLowerCase();
    const cmpModule = cmpModules.get(tagName);
    if (cmpModule != null) {
      return cmpModule[tagName];
    }
  }
  return null;
};
var loadModule = (cmpMeta, _hostRef, _hmrVersionId) => {
  return getModule(cmpMeta.$tagName$);
};
var isMemberInElement = (elm, memberName) => {
  if (elm != null) {
    if (memberName in elm) {
      return true;
    }
    const cstr = getModule(elm.nodeName);
    if (cstr != null) {
      const hostRef = cstr;
      if (hostRef != null && hostRef.cmpMeta != null && hostRef.cmpMeta.$members$ != null) {
        return memberName in hostRef.cmpMeta.$members$;
      }
    }
  }
  return false;
};
var registerComponents = (Cstrs) => {
  for (const Cstr of Cstrs) {
    const exportName = Cstr.cmpMeta.$tagName$;
    cmpModules.set(exportName, {
      [exportName]: Cstr
    });
  }
};
var win = window;
var doc = win.document;
var readTask = (cb) => {
  process.nextTick(() => {
    try {
      cb();
    } catch (e) {
      consoleError(e);
    }
  });
};
var writeTask = (cb) => {
  process.nextTick(() => {
    try {
      cb();
    } catch (e) {
      consoleError(e);
    }
  });
};
var resolved = /* @__PURE__ */ Promise.resolve();
var nextTick = (cb) => resolved.then(cb);
var defaultConsoleError = (e) => {
  if (e != null) {
    console.error(e.stack || e.message || e);
  }
};
var consoleError = (e, el) => (defaultConsoleError)(e, el);
var plt = {
  $flags$: 0,
  $resourcesUrl$: "",
  jmp: (h2) => h2(),
  raf: (h2) => requestAnimationFrame(h2),
  ael: (el, eventName, listener, opts) => el.addEventListener(eventName, listener, opts),
  rel: (el, eventName, listener, opts) => el.removeEventListener(eventName, listener, opts),
  ce: (eventName, opts) => new win.CustomEvent(eventName, opts)
};
var supportsShadow = false;
var hostRefs = /* @__PURE__ */ new WeakMap();
var getHostRef = (ref) => hostRefs.get(ref);
var registerInstance = (lazyInstance, hostRef) => hostRefs.set(hostRef.$lazyInstance$ = lazyInstance, hostRef);
var registerHost = (elm, cmpMeta) => {
  const hostRef = {
    $flags$: 0,
    $cmpMeta$: cmpMeta,
    $hostElement$: elm,
    $instanceValues$: /* @__PURE__ */ new Map(),
    $renderCount$: 0
  };
  hostRef.$onInstancePromise$ = new Promise((r) => hostRef.$onInstanceResolve$ = r);
  hostRef.$onReadyPromise$ = new Promise((r) => hostRef.$onReadyResolve$ = r);
  elm["s-p"] = [];
  elm["s-rc"] = [];
  addHostEventListeners(elm, hostRef, cmpMeta.$listeners$);
  return hostRefs.set(elm, hostRef);
};
var styles = /* @__PURE__ */ new Map();

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class TypedEvent {
    constructor() {
        this.listeners = [];
        this.listenersOncer = [];
        this.on = (listener) => {
            this.listeners.push(listener);
            return {
                dispose: () => this.off(listener),
            };
        };
        this.once = (listener) => {
            this.listenersOncer.push(listener);
        };
        this.off = (listener) => {
            const callbackIndex = this.listeners.indexOf(listener);
            if (callbackIndex > -1) {
                this.listeners.splice(callbackIndex, 1);
            }
        };
        this.emit = (event) => {
            /** Update any general listeners */
            this.listeners.forEach((listener) => listener(event));
            /** Clear the `once` queue */
            if (this.listenersOncer.length > 0) {
                const toCall = this.listenersOncer;
                this.listenersOncer = [];
                toCall.forEach((listener) => listener(event));
            }
        };
        this.pipe = (te) => {
            return this.on((e) => te.emit(e));
        };
    }
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * A function which creates a Context value object
 */
function createContext(name, initialValue) {
    return {
        name,
        initialValue,
    };
}
/**
 * An event fired by a context requester to signal it desires a named context.
 *
 * A provider should inspect the `context` property of the event to determine if it has a value that can
 * satisfy the request, calling the `callback` with the requested value if so.
 *
 * If the requested context event contains a truthy `subscribe` value, then a provider can call the callback
 * multiple times if the value is changed, if this is the case the provider should pass an `unsubscribe`
 * function to the callback which requesters can invoke to indicate they no longer wish to receive these updates.
 */
class ContextEvent extends Event {
    constructor(context, callback, subscribe) {
        super('context-request', { bubbles: true, composed: true });
        this.context = context;
        this.callback = callback;
        this.subscribe = subscribe;
    }
}
function useContextConsumer(hostElement, context, onContextReceived, subscribe) {
    let _unsubscribe;
    hostElement.dispatchEvent(new ContextEvent(context, (ctx, unSub) => {
        onContextReceived(ctx, unSub);
        _unsubscribe = unSub;
    }, subscribe));
    return {
        unsubscribe: () => {
            _unsubscribe();
        },
    };
}
function useContextProvider(hostElement, context, contextPayload) {
    const requestContext = new TypedEvent();
    const updateContext = new TypedEvent();
    const requests = new Set();
    hostElement.addEventListener('context-request', (requestContextEvent) => {
        if ((requestContextEvent === null || requestContextEvent === void 0 ? void 0 : requestContextEvent.context.name) !== context.name) {
            return;
        }
        requestContextEvent.stopPropagation();
        if (requestContextEvent.subscribe) {
            requests.add(requestContextEvent);
        }
        requestContext.emit(requestContextEvent);
        if (contextPayload) {
            requestContextEvent.callback(contextPayload, () => {
                requests.delete(requestContextEvent);
            });
        }
    });
    updateContext.on((context) => {
        requests.forEach((r) => r.callback(context, () => {
            requests.delete(r);
        }));
    });
    return {
        emit: (context) => {
            updateContext.emit(context);
        },
    };
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const closestIxMenu = (element) => {
    const menuElement = element.closest('ix-menu');
    return menuElement;
};
const ApplicationLayoutContext = createContext('application-layout-context', {
    hideHeader: false,
    host: null,
    sidebar: false,
});

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
// Implementation of scss breakpoints mixins/_break-points.scss
const mediaQueries = {
    sm: '(max-width: 48em)',
    md: '(min-width: 48.0625em) and (max-width: 80em)',
    lg: '(min-width: 80.0625em)',
};
const matchBreakpoint = (breakpoint) => {
    if (typeof window !== 'undefined' && window.matchMedia) {
        const mediaQuery = mediaQueries[breakpoint];
        return window.matchMedia(mediaQuery).matches;
    }
    return false;
};

function debounce(func, delay) {
    let timeoutId;
    return function debounced(...args) {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(() => {
            func(...args);
        }, delay);
    };
}

var __classPrivateFieldGet$1 = (undefined && undefined.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet$1 = (undefined && undefined.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _ApplicationLayoutService_supportedBreakpoints, _ApplicationLayoutService_breakpointChangeListener, _ApplicationLayoutService_breakpoint, _ApplicationLayoutService_isDetectionEnabled;
class ApplicationLayoutService {
    constructor() {
        // Keep order of breakpoints
        _ApplicationLayoutService_supportedBreakpoints.set(this, ['sm', 'md', 'lg']);
        _ApplicationLayoutService_breakpointChangeListener.set(this, new TypedEvent());
        _ApplicationLayoutService_breakpoint.set(this, 'lg');
        _ApplicationLayoutService_isDetectionEnabled.set(this, true);
        this.debouncedOnResize = debounce(this.onResize.bind(this), 50);
        if (typeof window !== 'undefined') {
            window.addEventListener('resize', this.debouncedOnResize.bind(this));
            this.debouncedOnResize();
        }
    }
    get breakpoint() {
        return __classPrivateFieldGet$1(this, _ApplicationLayoutService_breakpoint, "f");
    }
    get onChange() {
        return __classPrivateFieldGet$1(this, _ApplicationLayoutService_breakpointChangeListener, "f");
    }
    get isDetectionEnabled() {
        return __classPrivateFieldGet$1(this, _ApplicationLayoutService_isDetectionEnabled, "f");
    }
    onResize() {
        if (!__classPrivateFieldGet$1(this, _ApplicationLayoutService_isDetectionEnabled, "f")) {
            return;
        }
        if (!__classPrivateFieldGet$1(this, _ApplicationLayoutService_supportedBreakpoints, "f")) {
            return;
        }
        const matchBreakpoints = [];
        const breakpoints = __classPrivateFieldGet$1(this, _ApplicationLayoutService_supportedBreakpoints, "f");
        breakpoints.forEach((breakpoint) => {
            const match = matchBreakpoint(breakpoint);
            matchBreakpoints.push([breakpoint, match]);
        });
        if (matchBreakpoints.every(([_, match]) => match === false)) {
            let breakPointIndex = 0;
            if (!__classPrivateFieldGet$1(this, _ApplicationLayoutService_supportedBreakpoints, "f").includes('lg')) {
                breakPointIndex = matchBreakpoints.length - 1;
            }
            const [breakpoint, _] = matchBreakpoints[breakPointIndex];
            requestAnimationFrame(() => __classPrivateFieldGet$1(this, _ApplicationLayoutService_breakpointChangeListener, "f").emit(breakpoint));
            __classPrivateFieldSet$1(this, _ApplicationLayoutService_breakpoint, breakpoint, "f");
            return;
        }
        for (const [breakpoint, match] of matchBreakpoints.reverse()) {
            if (match) {
                requestAnimationFrame(() => __classPrivateFieldGet$1(this, _ApplicationLayoutService_breakpointChangeListener, "f").emit(breakpoint));
                __classPrivateFieldSet$1(this, _ApplicationLayoutService_breakpoint, breakpoint, "f");
                break;
            }
        }
    }
    disableBreakpointDetection() {
        __classPrivateFieldSet$1(this, _ApplicationLayoutService_isDetectionEnabled, false, "f");
    }
    enableBreakpointDetection() {
        __classPrivateFieldSet$1(this, _ApplicationLayoutService_isDetectionEnabled, true, "f");
    }
    setBreakpoint(breakpoint) {
        __classPrivateFieldSet$1(this, _ApplicationLayoutService_breakpoint, breakpoint, "f");
        __classPrivateFieldGet$1(this, _ApplicationLayoutService_breakpointChangeListener, "f").emit(breakpoint);
    }
    setBreakpoints(breakpoints) {
        __classPrivateFieldSet$1(this, _ApplicationLayoutService_supportedBreakpoints, breakpoints, "f");
        this.onResize();
    }
}
_ApplicationLayoutService_supportedBreakpoints = new WeakMap(), _ApplicationLayoutService_breakpointChangeListener = new WeakMap(), _ApplicationLayoutService_breakpoint = new WeakMap(), _ApplicationLayoutService_isDetectionEnabled = new WeakMap();
const applicationLayoutService = new ApplicationLayoutService();

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __classPrivateFieldGet = (undefined && undefined.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (undefined && undefined.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _MenuService_menuElement, _MenuService_menuExpandChange, _MenuService_isPinned;
class MenuService {
    constructor() {
        _MenuService_menuElement.set(this, null);
        _MenuService_menuExpandChange.set(this, new TypedEvent());
        _MenuService_isPinned.set(this, false);
    }
    register(menuElement) {
        if (__classPrivateFieldGet(this, _MenuService_menuElement, "f")) {
            console.warn('Menu already defined');
            return;
        }
        __classPrivateFieldSet(this, _MenuService_menuElement, menuElement, "f");
        __classPrivateFieldGet(this, _MenuService_menuElement, "f").addEventListener('expandChange', (event) => {
            __classPrivateFieldGet(this, _MenuService_menuExpandChange, "f").emit(event.detail);
        });
    }
    setIsPinned(pinned) {
        __classPrivateFieldSet(this, _MenuService_isPinned, pinned, "f");
    }
    async open() {
        if (__classPrivateFieldGet(this, _MenuService_menuElement, "f")) {
            __classPrivateFieldGet(this, _MenuService_menuElement, "f").toggleMenu(true);
            return true;
        }
        return false;
    }
    async close() {
        if (__classPrivateFieldGet(this, _MenuService_menuElement, "f")) {
            __classPrivateFieldGet(this, _MenuService_menuElement, "f").toggleMenu(false);
            return true;
        }
        return false;
    }
    async toggle() {
        if (__classPrivateFieldGet(this, _MenuService_menuElement, "f")) {
            __classPrivateFieldGet(this, _MenuService_menuElement, "f").toggleMenu();
            return true;
        }
        return false;
    }
    get nativeElement() {
        return __classPrivateFieldGet(this, _MenuService_menuElement, "f");
    }
    get expandChange() {
        return __classPrivateFieldGet(this, _MenuService_menuExpandChange, "f");
    }
    get isPinned() {
        return __classPrivateFieldGet(this, _MenuService_isPinned, "f");
    }
}
_MenuService_menuElement = new WeakMap(), _MenuService_menuExpandChange = new WeakMap(), _MenuService_isPinned = new WeakMap();
const menuController = new MenuService();

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function closestElement(selector, el) {
    if (!el) {
        return null;
    }
    return (el.closest(selector) ||
        closestElement(selector, el.getRootNode().host));
}
function getSlottedElements(slot) {
    return slot.assignedElements({ flatten: true });
}
function hasSlottedElements(slot) {
    if (!slot) {
        return false;
    }
    return slot.assignedElements({ flatten: true }).length !== 0;
}
function closestPassShadow(node, selector) {
    if (!node) {
        return null;
    }
    if (node instanceof ShadowRoot) {
        return closestPassShadow(node.host, selector);
    }
    if (node instanceof HTMLElement) {
        if (node.matches(selector)) {
            return node;
        }
        else {
            return closestPassShadow(node.parentNode, selector);
        }
    }
    return closestPassShadow(node.parentNode, selector);
}

class ThemeSwitcher {
    get themeChanged() {
        return this._themeChanged;
    }
    hasVariantSuffix(className) {
        return (className.endsWith(this.suffixDark) ||
            className.endsWith(this.suffixLight));
    }
    isThemeClass(className) {
        return (className.startsWith(this.prefixTheme) && this.hasVariantSuffix(className));
    }
    setTheme(themeName, systemAppearance = false) {
        if (!this.isThemeClass(themeName) && systemAppearance === false) {
            throw Error(`Provided theme name ${themeName} does not match our naming conventions. (theme-<name>-(dark,light))`);
        }
        if (systemAppearance) {
            const currentSystemAppearance = getCurrentSystemAppearance();
            this.replaceBodyThemeClass(themeName);
            this.setVariant(currentSystemAppearance);
            return;
        }
        this.replaceBodyThemeClass(themeName);
    }
    replaceBodyThemeClass(themeName) {
        const oldThemes = [];
        document.body.classList.forEach((className) => {
            if (this.isThemeClass(className)) {
                oldThemes.push(className);
            }
        });
        document.body.classList.remove(...oldThemes);
        document.body.classList.add(themeName);
    }
    toggleMode() {
        const oldThemes = [];
        document.body.classList.forEach((className) => {
            if (this.isThemeClass(className)) {
                oldThemes.push(className);
            }
        });
        if (oldThemes.length === 0) {
            document.body.classList.add(this.getOppositeMode(this.defaultTheme));
            return;
        }
        oldThemes.forEach((themeName) => {
            document.body.classList.replace(themeName, this.getOppositeMode(themeName));
        });
    }
    getCurrentTheme() {
        var _a;
        return ((_a = Array.from(document.body.classList).find((className) => this.isThemeClass(className))) !== null && _a !== void 0 ? _a : `theme-${window
            .getComputedStyle(document.body)
            .getPropertyValue('--ix-theme-name')}`);
    }
    setVariant(variant = getCurrentSystemAppearance()) {
        const currentTheme = this.getCurrentTheme();
        document.body.classList.remove(currentTheme);
        if (currentTheme.endsWith(this.suffixDark)) {
            document.body.classList.add(currentTheme.replace(/-dark$/g, `-${variant}`));
        }
        if (currentTheme.endsWith(this.suffixLight)) {
            document.body.classList.add(currentTheme.replace(/-light$/g, `-${variant}`));
        }
    }
    getOppositeMode(themeName) {
        if (themeName.endsWith(this.suffixDark)) {
            return themeName.replace(/-dark$/g, this.suffixLight);
        }
        if (themeName.endsWith(this.suffixLight)) {
            return themeName.replace(/-light$/g, this.suffixDark);
        }
    }
    handleMutations(mutations) {
        return mutations.forEach((mutation) => {
            const { target } = mutation;
            target.classList.forEach((className) => {
                var _a;
                if (this.isThemeClass(className) &&
                    !((_a = mutation.oldValue) === null || _a === void 0 ? void 0 : _a.includes(className))) {
                    this._themeChanged.emit(className);
                }
            });
        });
    }
    registerMutationObserver() {
        if (typeof window === 'undefined') {
            return;
        }
        if (!('MutationObserver' in window)) {
            console.warn('ThemeSwitcher not supported by your browser. Missing MutationObserver API');
            return;
        }
        this.mutationObserver = new MutationObserver((mutations) => {
            this.handleMutations(mutations);
        });
        this.mutationObserver.observe(document.body, {
            attributeFilter: ['class'],
            attributeOldValue: true,
        });
    }
    constructor() {
        this.prefixTheme = 'theme-';
        this.suffixLight = '-light';
        this.suffixDark = '-dark';
        this.defaultTheme = 'theme-classic-dark';
        this._themeChanged = new TypedEvent();
        this.registerMutationObserver();
    }
}
const getCurrentSystemAppearance = () => {
    const matchMedia = window.matchMedia('(prefers-color-scheme: dark)');
    if (matchMedia.matches) {
        return 'dark';
    }
    return 'light';
};
const themeSwitcher = new ThemeSwitcher();

const applicationCss = "/*!@:host*/.sc-ix-application-h{display:flex;position:relative;width:100%;height:100%;flex-direction:column}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-application-h *.sc-ix-application,.sc-ix-application-h *.sc-ix-application::after,.sc-ix-application-h *.sc-ix-application::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-application-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-application-h .sc-ix-application::-webkit-scrollbar-corner{display:none}/*!@:host ix-application-header*/.sc-ix-application-h ix-application-header.sc-ix-application{z-index:calc(var(--theme-z-index-sticky) + 1)}/*!@:host .logo-wrapper*/.sc-ix-application-h .logo-wrapper.sc-ix-application{display:contents}/*!@:host .application*/.sc-ix-application-h .application.sc-ix-application{display:flex;position:relative;flex-direction:row;height:100%;width:100%;overflow:hidden}/*!@:host .content-area*/.sc-ix-application-h .content-area.sc-ix-application{display:flex;position:relative;flex-direction:column;flex-wrap:nowrap;height:calc(100% - var(--ix-safe-area-inset-bottom, 0px));width:100%;margin-left:var(--ix-application-menu-margin-left)}/*!@:host main*/.sc-ix-application-h main.sc-ix-application{display:block;position:relative;flex-grow:1;width:100%;padding-bottom:var(--ix-safe-area-inset-bottom);overflow:auto}/*!@:host footer*/.sc-ix-application-h footer.sc-ix-application{display:block;position:relative;width:100%}/*!@:host(.breakpoint-md)*/.breakpoint-md.sc-ix-application-h{--ix-application-menu-margin-left:calc(\n    3.25rem + var(--ix-application-menu-safe-area-left, 0rem)\n  )}/*!@:host(.breakpoint-md) aside.slotted*/.breakpoint-md.sc-ix-application-h aside.slotted.sc-ix-application{margin-left:var(--ix-application-menu-margin-left)}/*!@:host(.breakpoint-md) aside.slotted + .content-area*/.breakpoint-md.sc-ix-application-h aside.slotted.sc-ix-application+.content-area.sc-ix-application{margin-left:0}/*!@:host(.breakpoint-md) aside:not(.slotted) + .content-area*/.breakpoint-md.sc-ix-application-h aside.sc-ix-application:not(.slotted)+.content-area.sc-ix-application{margin-left:var(--ix-application-menu-margin-left)}/*!@:host(.breakpoint-lg)*/.breakpoint-lg.sc-ix-application-h{--ix-application-menu-margin-left:0}/*!@:host(.breakpoint-sm)*/.breakpoint-sm.sc-ix-application-h{--ix-application-menu-margin-left:var(\n    --ix-application-menu-safe-area-left,\n    0rem\n  )}";
var IxApplicationStyle0 = applicationCss;

/**
 * @since 2.1.0
 */
class Application {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.theme = undefined;
        this.themeSystemAppearance = false;
        this.forceBreakpoint = undefined;
        this.breakpoints = ['sm', 'md', 'lg'];
        this.appSwitchConfig = undefined;
        this.breakpoint = 'lg';
        this.applicationSidebarSlotted = false;
    }
    forceLayoutChange(newMode) {
        if (!newMode) {
            applicationLayoutService.enableBreakpointDetection();
            return;
        }
        applicationLayoutService.disableBreakpointDetection();
        applicationLayoutService.setBreakpoint(newMode);
    }
    onBreakpointsChange(breakpoints) {
        applicationLayoutService.setBreakpoints(breakpoints);
    }
    get menu() {
        return this.hostElement.querySelector('ix-menu');
    }
    get applicationSidebarSlot() {
        return this.hostElement.shadowRoot.querySelector('.application-sidebar slot');
    }
    onContentClick() {
        var _a;
        if (menuController.isPinned) {
            return;
        }
        (_a = this.menu) === null || _a === void 0 ? void 0 : _a.toggleMenu(false);
    }
    componentWillLoad() {
        applicationLayoutService.setBreakpoints(this.breakpoints);
        this.contextProvider = useContextProvider(this.hostElement, ApplicationLayoutContext, {
            hideHeader: false,
            host: 'basic-navigation',
            sidebar: this.applicationSidebarSlotted,
            appSwitchConfig: this.appSwitchConfig,
        });
        this.modeDisposable = applicationLayoutService.onChange.on((mode) => {
            this.breakpoint = mode;
        });
        this.breakpoint = applicationLayoutService.breakpoint;
        if (this.forceBreakpoint) {
            this.forceLayoutChange(this.forceBreakpoint);
        }
        this.changeTheme();
    }
    disconnectedCallback() {
        var _a;
        (_a = this.modeDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
    }
    changeTheme() {
        if (!this.theme) {
            if (this.themeSystemAppearance) {
                themeSwitcher.setVariant();
            }
            return;
        }
        if (themeSwitcher.hasVariantSuffix(this.theme)) {
            themeSwitcher.setTheme(`theme-${this.theme}`);
            return;
        }
        themeSwitcher.setTheme(`theme-${this.theme}-dark`, this.themeSystemAppearance);
    }
    onApplicationSidebarChange() {
        this.contextProvider.emit({
            hideHeader: false,
            host: 'basic-navigation',
            sidebar: this.applicationSidebarSlotted,
            appSwitchConfig: this.appSwitchConfig,
        });
    }
    render() {
        return (hAsync(Host, { key: '4e8314dec7968a3b9b2e00a7852dc53c924d0c53', "data-role": "", class: {
                [`breakpoint-${this.breakpoint}`]: true,
            } }, hAsync("slot", { key: '2f4a52a13679af639648164eff165d5dd37ec951', name: "application-header" }), hAsync("div", { key: 'b316ff04f23e4606d54ddcc5531ed884b988e360', class: "application" }, hAsync("slot", { key: '40f4800917fa9f24cdc50c72543e2c7181878775', name: "menu" }), hAsync("aside", { key: '62e0120b64ad942e7dd991b6fe9912b60e36e04f', class: {
                'application-sidebar': true,
                slotted: this.applicationSidebarSlotted,
            }, onClick: () => this.onContentClick() }, hAsync("slot", { key: '211f35df78de174484e914fa646227ba290fb9ae', name: "application-sidebar", onSlotchange: () => (this.applicationSidebarSlotted = hasSlottedElements(this.applicationSidebarSlot)) })), hAsync("div", { key: '5913187261ced8e7ff12ee3d352d33b0c5e9f49b', class: "content-area" }, hAsync("main", { key: 'ae580e752d753b0dbbdc4743f538d0a0bf8320eb', class: "content", onClick: () => this.onContentClick() }, hAsync("slot", { key: '7954efb9b316bfd53191569e1b5bb32b8fafae2e' })), hAsync("footer", { key: '3c41b12023cfb59373efe0fa88db93236f6f0f01', class: "footer" }, hAsync("slot", { key: '9307b5f999ffcd96b7cd6f7b217f10b94c1a901f', name: "bottom" }))))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "breakpoints": ["onBreakpointsChange"],
        "theme": ["changeTheme"],
        "themeSystemAppearance": ["changeTheme"],
        "appSwitchConfig": ["onApplicationSidebarChange"],
        "applicationSidebarSlotted": ["onApplicationSidebarChange"]
    }; }
    static get style() { return IxApplicationStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-application",
        "$members$": {
            "theme": [1],
            "themeSystemAppearance": [4, "theme-system-appearance"],
            "forceBreakpoint": [1, "force-breakpoint"],
            "breakpoints": [16],
            "appSwitchConfig": [16],
            "breakpoint": [32],
            "applicationSidebarSlotted": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class Animation {
}
Animation.shortTime = 0;
Animation.defaultTime = 150;
Animation.mediumTime = 300;
Animation.slowTime = 500;
Animation.xSlowTime = 1000;

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class DefaultFrameworkDelegate {
    async attachView(view, config) {
        var _a;
        const attachToElement = (_a = config === null || config === void 0 ? void 0 : config.parentElement) !== null && _a !== void 0 ? _a : document.body;
        attachToElement.appendChild(view);
        return view;
    }
    async removeView(view) {
        view.remove();
    }
}
const coreDelegate = new DefaultFrameworkDelegate();
let currentDelegate = coreDelegate;
const resolveDelegate = () => {
    return currentDelegate;
};
const getCoreDelegate = () => coreDelegate;

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function setA11yAttributes(element, config) {
    const ariaDescribedby = config.ariaDescribedby;
    const ariaLabelledby = config.ariaLabelledby;
    delete config['ariaDescribedby'];
    delete config['ariaLabelledby'];
    if (ariaDescribedby) {
        element.setAttribute('aria-describedby', ariaDescribedby);
    }
    if (ariaLabelledby) {
        element.setAttribute('aria-labelledby', ariaLabelledby);
    }
}
function getIxModal(element) {
    return element.closest('ix-modal');
}
function closeModal(element, closeResult) {
    const dialog = getIxModal(element);
    if (dialog) {
        dialog.closeModal(closeResult);
        return;
    }
}
function dismissModal(element, dismissResult) {
    const dialog = getIxModal(element);
    if (dialog) {
        dialog.dismissModal(dismissResult);
        return;
    }
}
async function showModal(config) {
    const delegate = resolveDelegate();
    let dialogRef;
    const onClose = new TypedEvent();
    const onDismiss = new TypedEvent();
    if (typeof config.content === 'string') {
        const dialog = document.createElement('ix-modal');
        dialog.innerText = config.content;
        dialogRef = await getCoreDelegate().attachView(dialog);
    }
    if (config.content instanceof HTMLElement &&
        config.content.tagName !== 'IX-MODAL') {
        const dialog = document.createElement('ix-modal');
        dialog.appendChild(config.content);
        dialogRef = await getCoreDelegate().attachView(dialog);
    }
    if (!dialogRef) {
        dialogRef = await delegate.attachView(config.content);
    }
    setA11yAttributes(dialogRef, config);
    Object.assign(dialogRef, config);
    await dialogRef.showModal();
    dialogRef.addEventListener('dialogClose', async ({ detail }) => {
        onClose.emit(detail);
        await delegate.removeView(dialogRef);
    });
    dialogRef.addEventListener('dialogDismiss', async ({ detail }) => {
        onDismiss.emit(detail);
        await delegate.removeView(dialogRef);
    });
    return {
        htmlElement: dialogRef,
        onClose,
        onDismiss,
    };
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
async function showAppSwitch(config) {
    const modal = document.createElement('ix-application-switch-modal');
    modal.config = config;
    const result = await showModal({
        content: modal,
        size: '840',
        closeOnBackdropClick: true,
    });
    const appSwitchElement = result.htmlElement.querySelector('ix-application-switch-modal');
    return (updateAppSwitchConfig) => {
        appSwitchElement.config = updateAppSwitchConfig;
    };
}

const applicationHeaderCss = "/*!@:host*/.sc-ix-application-header-h{display:flex;align-items:flex-end;flex-wrap:nowrap;position:relative;width:100%;height:calc(2.75rem + var(--ix-safe-area-inset-top, 0rem));min-height:calc(2.75rem + var(--ix-safe-area-inset-top, 0rem));padding-top:0;padding-right:calc(1rem + var(--ix-safe-area-inset-right, 0rem));padding-bottom:0.3rem;padding-left:calc(0.625rem + var(--ix-safe-area-inset-left, 0rem));color:var(--theme-app-header--color);background-color:var(--theme-app-header--background);border-bottom:var(--theme-app-header--border-width) solid var(--theme-app-header--border-color);z-index:var(--theme-z-index-fixed)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-application-header-h *.sc-ix-application-header,.sc-ix-application-header-h *.sc-ix-application-header::after,.sc-ix-application-header-h *.sc-ix-application-header::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-application-header-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-application-header-h .sc-ix-application-header::-webkit-scrollbar-corner{display:none}/*!@:host .app-switch*/.sc-ix-application-header-h .app-switch.sc-ix-application-header{margin-right:1rem}/*!@:host .name*/.sc-ix-application-header-h .name.sc-ix-application-header{overflow:hidden;overflow-wrap:anywhere;text-overflow:ellipsis;text-wrap:nowrap;max-width:50%;margin-left:1.5rem;margin-right:2.5rem;margin-bottom:0.25rem;color:var(--theme-app-header--color)}/*!@:host .logo*/.sc-ix-application-header-h .logo.sc-ix-application-header{display:inline-flex;align-items:center;position:relative;height:32px;overflow:hidden;line-height:0rem;color:var(--theme-app-header-logo--color);margin-left:0.375rem}/*!@:host .content*/.sc-ix-application-header-h .content.sc-ix-application-header{display:flex;position:relative;flex-direction:row;margin-left:auto;margin-right:0px}/*!@:host .dropdown*/.sc-ix-application-header-h .dropdown.sc-ix-application-header{overflow:visible}/*!@:host .dropdown-content*/.sc-ix-application-header-h .dropdown-content.sc-ix-application-header{padding:1rem}/*!@:host .context-menu*/.sc-ix-application-header-h .context-menu.sc-ix-application-header{display:none}/*!@:host .context-menu.context-menu-visible*/.sc-ix-application-header-h .context-menu.context-menu-visible.sc-ix-application-header{display:block}@media only screen and (max-width: 48em){/*!@:host .logo*/.sc-ix-application-header-h .logo.sc-ix-application-header{display:none}}/*!@:host ::slotted(ix-avatar)*/.sc-ix-application-header-h .sc-ix-application-header-s>ix-avatar{margin-left:1rem}/*!@:host(.breakpoint-sm) .logo*/.breakpoint-sm.sc-ix-application-header-h .logo.sc-ix-application-header{margin-left:0.5rem}";
var IxApplicationHeaderStyle0 = applicationHeaderCss;

/**
 * @slot logo - Location of the logo
 */
class ApplicationHeader {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.menuToggle = createEvent(this, "menuToggle", 7);
        this.name = undefined;
        this.showMenu = false;
        this.breakpoint = 'lg';
        this.menuExpanded = false;
        this.suppressResponsive = false;
        this.hasSlottedElements = false;
        this.applicationLayoutContext = undefined;
    }
    get contentBackground() {
        return this.hostElement.shadowRoot.querySelector('.dropdown-content');
    }
    componentWillLoad() {
        useContextConsumer(this.hostElement, ApplicationLayoutContext, (ctx) => {
            if ((ctx === null || ctx === void 0 ? void 0 : ctx.host) === 'map-navigation') {
                this.suppressResponsive = true;
                this.breakpoint = 'md';
                return;
            }
            this.breakpoint = applicationLayoutService.breakpoint;
            this.applicationLayoutContext = ctx;
            this.tryUpdateAppSwitch();
        }, true);
        this.menuDisposable = menuController.expandChange.on((show) => {
            this.menuExpanded = show;
        });
        this.modeDisposable = applicationLayoutService.onChange.on((mode) => {
            if (this.suppressResponsive) {
                return;
            }
            this.breakpoint = mode;
        });
        this.updateIsSlottedContent();
    }
    componentDidLoad() {
        this.attachSiemensLogoIfLoaded();
    }
    disconnectedCallback() {
        var _a, _b;
        (_a = this.menuDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
        (_b = this.modeDisposable) === null || _b === void 0 ? void 0 : _b.dispose();
    }
    watchApplicationLayoutContext() {
        if (this.applicationLayoutContext) {
            this.showMenu = false;
        }
    }
    watchSuppressResponsive() {
        this.breakpoint = 'md';
    }
    isLogoSlotted() {
        const slotElement = this.hostElement.shadowRoot.querySelector('slot[name="logo"]');
        const nodes = slotElement.assignedNodes({
            flatten: true,
        });
        return nodes.length !== 0;
    }
    async attachSiemensLogoIfLoaded() {
        await window.customElements.whenDefined('ix-siemens-logo');
        const logoElement = document.createElement('ix-siemens-logo');
        if (!this.isLogoSlotted()) {
            this.hostElement.shadowRoot
                .querySelector('.logo')
                .appendChild(logoElement);
        }
    }
    async onMenuClick() {
        if (this.applicationLayoutContext) {
            menuController.toggle();
        }
        else {
            this.menuExpanded = !this.menuExpanded;
        }
        this.menuToggle.emit(this.menuExpanded);
    }
    resolveContextMenuButton() {
        return new Promise((resolve) => readTask(() => resolve(this.hostElement.shadowRoot.querySelector('[data-context-menu]'))));
    }
    tryUpdateAppSwitch() {
        var _a;
        if (!this.callbackUpdateAppSwitchModal) {
            return;
        }
        this.callbackUpdateAppSwitchModal((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig);
    }
    async showAppSwitch() {
        var _a;
        this.callbackUpdateAppSwitchModal = await showAppSwitch((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig);
    }
    updateIsSlottedContent() {
        const slotElement = this.hostElement.shadowRoot.querySelector('.content slot');
        this.hasSlottedElements = hasSlottedElements(slotElement);
    }
    onContentBgClick(e) {
        if (e.target === this.contentBackground) {
            e.preventDefault();
        }
    }
    render() {
        var _a;
        const hasApplicationContextAvailable = !!this.applicationLayoutContext;
        const showMenuByApplicationFrame = this.breakpoint === 'sm' &&
            this.suppressResponsive === false &&
            hasApplicationContextAvailable;
        const showApplicationSwitch = ((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig) &&
            this.breakpoint !== 'sm' &&
            this.suppressResponsive === false;
        return (hAsync(Host, { key: 'd81892c63d0b963455f7b86741241528dd4e65a5', class: {
                [`breakpoint-${this.breakpoint}`]: true,
            }, slot: "application-header" }, (this.showMenu || showMenuByApplicationFrame) && (hAsync("ix-menu-expand-icon", { key: 'db19b6cc240df8f3299e671d0ee8a56bdf7f6977', onClick: () => this.onMenuClick(), expanded: this.menuExpanded })), showApplicationSwitch && (hAsync("ix-icon-button", { key: '5a31ea7e0007c3ab3b78c96b649f917745bc7435', onClick: () => this.showAppSwitch(), icon: "apps", ghost: true, class: "app-switch" })), hAsync("div", { key: '4b083dd5ce9023d17371364b541ef0f29ec6d76f', class: { logo: true } }, hAsync("slot", { key: '7039706bbb7355302e069e22621b41cd756345d9', name: "logo" })), hAsync("ix-typography", { key: '3f365f3947b52f3788f6d4ec4180c23ec12d2509', format: "body-lg", class: "name" }, this.name), hAsync("div", { key: '20427a902bacbe4db73bbaf43fc8a5477d7a13a2', class: "content" }, this.breakpoint === 'sm' ? (hAsync(Fragment, null, hAsync("ix-icon-button", { class: {
                ['context-menu']: true,
                ['context-menu-visible']: this.hasSlottedElements,
            }, "data-context-menu": true, icon: "more-menu", ghost: true }), hAsync("ix-dropdown", { "data-overflow-dropdown": true, class: "dropdown", discoverAllSubmenus: true, trigger: this.resolveContextMenuButton() }, hAsync("div", { class: "dropdown-content", onClick: (e) => this.onContentBgClick(e) }, hAsync("slot", { onSlotchange: () => this.updateIsSlottedContent() }))))) : (hAsync("slot", { onSlotchange: () => this.updateIsSlottedContent() })), hAsync("slot", { key: 'baea46e8a2cec2e4fbdb99752bf6697cf314855e', name: "ix-application-header-avatar" }))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "applicationLayoutContext": ["watchApplicationLayoutContext"],
        "suppressResponsive": ["watchSuppressResponsive"]
    }; }
    static get style() { return IxApplicationHeaderStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-application-header",
        "$members$": {
            "name": [1],
            "showMenu": [1028, "show-menu"],
            "breakpoint": [32],
            "menuExpanded": [32],
            "suppressResponsive": [32],
            "hasSlottedElements": [32],
            "applicationLayoutContext": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * anime.js v3.2.1
 * (c) 2020 Julian Garnier
 * Released under the MIT license
 * animejs.com
 */

// Defaults

var defaultInstanceSettings = {
  update: null,
  begin: null,
  loopBegin: null,
  changeBegin: null,
  change: null,
  changeComplete: null,
  loopComplete: null,
  complete: null,
  loop: 1,
  direction: 'normal',
  autoplay: true,
  timelineOffset: 0
};

var defaultTweenSettings = {
  duration: 1000,
  delay: 0,
  endDelay: 0,
  easing: 'easeOutElastic(1, .5)',
  round: 0
};

var validTransforms = ['translateX', 'translateY', 'translateZ', 'rotate', 'rotateX', 'rotateY', 'rotateZ', 'scale', 'scaleX', 'scaleY', 'scaleZ', 'skew', 'skewX', 'skewY', 'perspective', 'matrix', 'matrix3d'];

// Caching

var cache = {
  CSS: {},
  springs: {}
};

// Utils

function minMax(val, min, max) {
  return Math.min(Math.max(val, min), max);
}

function stringContains(str, text) {
  return str.indexOf(text) > -1;
}

function applyArguments(func, args) {
  return func.apply(null, args);
}

var is = {
  arr: function (a) { return Array.isArray(a); },
  obj: function (a) { return stringContains(Object.prototype.toString.call(a), 'Object'); },
  pth: function (a) { return is.obj(a) && a.hasOwnProperty('totalLength'); },
  svg: function (a) { return a instanceof SVGElement; },
  inp: function (a) { return a instanceof HTMLInputElement; },
  dom: function (a) { return a.nodeType || is.svg(a); },
  str: function (a) { return typeof a === 'string'; },
  fnc: function (a) { return typeof a === 'function'; },
  und: function (a) { return typeof a === 'undefined'; },
  nil: function (a) { return is.und(a) || a === null; },
  hex: function (a) { return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(a); },
  rgb: function (a) { return /^rgb/.test(a); },
  hsl: function (a) { return /^hsl/.test(a); },
  col: function (a) { return (is.hex(a) || is.rgb(a) || is.hsl(a)); },
  key: function (a) { return !defaultInstanceSettings.hasOwnProperty(a) && !defaultTweenSettings.hasOwnProperty(a) && a !== 'targets' && a !== 'keyframes'; },
};

// Easings

function parseEasingParameters(string) {
  var match = /\(([^)]+)\)/.exec(string);
  return match ? match[1].split(',').map(function (p) { return parseFloat(p); }) : [];
}

// Spring solver inspired by Webkit Copyright © 2016 Apple Inc. All rights reserved. https://webkit.org/demos/spring/spring.js

function spring(string, duration) {

  var params = parseEasingParameters(string);
  var mass = minMax(is.und(params[0]) ? 1 : params[0], .1, 100);
  var stiffness = minMax(is.und(params[1]) ? 100 : params[1], .1, 100);
  var damping = minMax(is.und(params[2]) ? 10 : params[2], .1, 100);
  var velocity =  minMax(is.und(params[3]) ? 0 : params[3], .1, 100);
  var w0 = Math.sqrt(stiffness / mass);
  var zeta = damping / (2 * Math.sqrt(stiffness * mass));
  var wd = zeta < 1 ? w0 * Math.sqrt(1 - zeta * zeta) : 0;
  var a = 1;
  var b = zeta < 1 ? (zeta * w0 + -velocity) / wd : -velocity + w0;

  function solver(t) {
    var progress = duration ? (duration * t) / 1000 : t;
    if (zeta < 1) {
      progress = Math.exp(-progress * zeta * w0) * (a * Math.cos(wd * progress) + b * Math.sin(wd * progress));
    } else {
      progress = (a + b * progress) * Math.exp(-progress * w0);
    }
    if (t === 0 || t === 1) { return t; }
    return 1 - progress;
  }

  function getDuration() {
    var cached = cache.springs[string];
    if (cached) { return cached; }
    var frame = 1/6;
    var elapsed = 0;
    var rest = 0;
    while(true) {
      elapsed += frame;
      if (solver(elapsed) === 1) {
        rest++;
        if (rest >= 16) { break; }
      } else {
        rest = 0;
      }
    }
    var duration = elapsed * frame * 1000;
    cache.springs[string] = duration;
    return duration;
  }

  return duration ? solver : getDuration;

}

// Basic steps easing implementation https://developer.mozilla.org/fr/docs/Web/CSS/transition-timing-function

function steps(steps) {
  if ( steps === void 0 ) steps = 10;

  return function (t) { return Math.ceil((minMax(t, 0.000001, 1)) * steps) * (1 / steps); };
}

// BezierEasing https://github.com/gre/bezier-easing

var bezier = (function () {

  var kSplineTableSize = 11;
  var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);

  function A(aA1, aA2) { return 1.0 - 3.0 * aA2 + 3.0 * aA1 }
  function B(aA1, aA2) { return 3.0 * aA2 - 6.0 * aA1 }
  function C(aA1)      { return 3.0 * aA1 }

  function calcBezier(aT, aA1, aA2) { return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT }
  function getSlope(aT, aA1, aA2) { return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1) }

  function binarySubdivide(aX, aA, aB, mX1, mX2) {
    var currentX, currentT, i = 0;
    do {
      currentT = aA + (aB - aA) / 2.0;
      currentX = calcBezier(currentT, mX1, mX2) - aX;
      if (currentX > 0.0) { aB = currentT; } else { aA = currentT; }
    } while (Math.abs(currentX) > 0.0000001 && ++i < 10);
    return currentT;
  }

  function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
    for (var i = 0; i < 4; ++i) {
      var currentSlope = getSlope(aGuessT, mX1, mX2);
      if (currentSlope === 0.0) { return aGuessT; }
      var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
      aGuessT -= currentX / currentSlope;
    }
    return aGuessT;
  }

  function bezier(mX1, mY1, mX2, mY2) {

    if (!(0 <= mX1 && mX1 <= 1 && 0 <= mX2 && mX2 <= 1)) { return; }
    var sampleValues = new Float32Array(kSplineTableSize);

    if (mX1 !== mY1 || mX2 !== mY2) {
      for (var i = 0; i < kSplineTableSize; ++i) {
        sampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
      }
    }

    function getTForX(aX) {

      var intervalStart = 0;
      var currentSample = 1;
      var lastSample = kSplineTableSize - 1;

      for (; currentSample !== lastSample && sampleValues[currentSample] <= aX; ++currentSample) {
        intervalStart += kSampleStepSize;
      }

      --currentSample;

      var dist = (aX - sampleValues[currentSample]) / (sampleValues[currentSample + 1] - sampleValues[currentSample]);
      var guessForT = intervalStart + dist * kSampleStepSize;
      var initialSlope = getSlope(guessForT, mX1, mX2);

      if (initialSlope >= 0.001) {
        return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
      } else if (initialSlope === 0.0) {
        return guessForT;
      } else {
        return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
      }

    }

    return function (x) {
      if (mX1 === mY1 && mX2 === mY2) { return x; }
      if (x === 0 || x === 1) { return x; }
      return calcBezier(getTForX(x), mY1, mY2);
    }

  }

  return bezier;

})();

var penner = (function () {

  // Based on jQuery UI's implemenation of easing equations from Robert Penner (http://www.robertpenner.com/easing)

  var eases = { linear: function () { return function (t) { return t; }; } };

  var functionEasings = {
    Sine: function () { return function (t) { return 1 - Math.cos(t * Math.PI / 2); }; },
    Circ: function () { return function (t) { return 1 - Math.sqrt(1 - t * t); }; },
    Back: function () { return function (t) { return t * t * (3 * t - 2); }; },
    Bounce: function () { return function (t) {
      var pow2, b = 4;
      while (t < (( pow2 = Math.pow(2, --b)) - 1) / 11) {}
      return 1 / Math.pow(4, 3 - b) - 7.5625 * Math.pow(( pow2 * 3 - 2 ) / 22 - t, 2)
    }; },
    Elastic: function (amplitude, period) {
      if ( amplitude === void 0 ) amplitude = 1;
      if ( period === void 0 ) period = .5;

      var a = minMax(amplitude, 1, 10);
      var p = minMax(period, .1, 2);
      return function (t) {
        return (t === 0 || t === 1) ? t : 
          -a * Math.pow(2, 10 * (t - 1)) * Math.sin((((t - 1) - (p / (Math.PI * 2) * Math.asin(1 / a))) * (Math.PI * 2)) / p);
      }
    }
  };

  var baseEasings = ['Quad', 'Cubic', 'Quart', 'Quint', 'Expo'];

  baseEasings.forEach(function (name, i) {
    functionEasings[name] = function () { return function (t) { return Math.pow(t, i + 2); }; };
  });

  Object.keys(functionEasings).forEach(function (name) {
    var easeIn = functionEasings[name];
    eases['easeIn' + name] = easeIn;
    eases['easeOut' + name] = function (a, b) { return function (t) { return 1 - easeIn(a, b)(1 - t); }; };
    eases['easeInOut' + name] = function (a, b) { return function (t) { return t < 0.5 ? easeIn(a, b)(t * 2) / 2 : 
      1 - easeIn(a, b)(t * -2 + 2) / 2; }; };
    eases['easeOutIn' + name] = function (a, b) { return function (t) { return t < 0.5 ? (1 - easeIn(a, b)(1 - t * 2)) / 2 : 
      (easeIn(a, b)(t * 2 - 1) + 1) / 2; }; };
  });

  return eases;

})();

function parseEasings(easing, duration) {
  if (is.fnc(easing)) { return easing; }
  var name = easing.split('(')[0];
  var ease = penner[name];
  var args = parseEasingParameters(easing);
  switch (name) {
    case 'spring' : return spring(easing, duration);
    case 'cubicBezier' : return applyArguments(bezier, args);
    case 'steps' : return applyArguments(steps, args);
    default : return applyArguments(ease, args);
  }
}

// Strings

function selectString(str) {
  try {
    var nodes = document.querySelectorAll(str);
    return nodes;
  } catch(e) {
    return;
  }
}

// Arrays

function filterArray(arr, callback) {
  var len = arr.length;
  var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
  var result = [];
  for (var i = 0; i < len; i++) {
    if (i in arr) {
      var val = arr[i];
      if (callback.call(thisArg, val, i, arr)) {
        result.push(val);
      }
    }
  }
  return result;
}

function flattenArray(arr) {
  return arr.reduce(function (a, b) { return a.concat(is.arr(b) ? flattenArray(b) : b); }, []);
}

function toArray(o) {
  if (is.arr(o)) { return o; }
  if (is.str(o)) { o = selectString(o) || o; }
  if (o instanceof NodeList || o instanceof HTMLCollection) { return [].slice.call(o); }
  return [o];
}

function arrayContains(arr, val) {
  return arr.some(function (a) { return a === val; });
}

// Objects

function cloneObject(o) {
  var clone = {};
  for (var p in o) { clone[p] = o[p]; }
  return clone;
}

function replaceObjectProps(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o1) { o[p] = o2.hasOwnProperty(p) ? o2[p] : o1[p]; }
  return o;
}

function mergeObjects(o1, o2) {
  var o = cloneObject(o1);
  for (var p in o2) { o[p] = is.und(o1[p]) ? o2[p] : o1[p]; }
  return o;
}

// Colors

function rgbToRgba(rgbValue) {
  var rgb = /rgb\((\d+,\s*[\d]+,\s*[\d]+)\)/g.exec(rgbValue);
  return rgb ? ("rgba(" + (rgb[1]) + ",1)") : rgbValue;
}

function hexToRgba(hexValue) {
  var rgx = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  var hex = hexValue.replace(rgx, function (m, r, g, b) { return r + r + g + g + b + b; } );
  var rgb = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  var r = parseInt(rgb[1], 16);
  var g = parseInt(rgb[2], 16);
  var b = parseInt(rgb[3], 16);
  return ("rgba(" + r + "," + g + "," + b + ",1)");
}

function hslToRgba(hslValue) {
  var hsl = /hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(hslValue) || /hsla\((\d+),\s*([\d.]+)%,\s*([\d.]+)%,\s*([\d.]+)\)/g.exec(hslValue);
  var h = parseInt(hsl[1], 10) / 360;
  var s = parseInt(hsl[2], 10) / 100;
  var l = parseInt(hsl[3], 10) / 100;
  var a = hsl[4] || 1;
  function hue2rgb(p, q, t) {
    if (t < 0) { t += 1; }
    if (t > 1) { t -= 1; }
    if (t < 1/6) { return p + (q - p) * 6 * t; }
    if (t < 1/2) { return q; }
    if (t < 2/3) { return p + (q - p) * (2/3 - t) * 6; }
    return p;
  }
  var r, g, b;
  if (s == 0) {
    r = g = b = l;
  } else {
    var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
    var p = 2 * l - q;
    r = hue2rgb(p, q, h + 1/3);
    g = hue2rgb(p, q, h);
    b = hue2rgb(p, q, h - 1/3);
  }
  return ("rgba(" + (r * 255) + "," + (g * 255) + "," + (b * 255) + "," + a + ")");
}

function colorToRgb(val) {
  if (is.rgb(val)) { return rgbToRgba(val); }
  if (is.hex(val)) { return hexToRgba(val); }
  if (is.hsl(val)) { return hslToRgba(val); }
}

// Units

function getUnit(val) {
  var split = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(val);
  if (split) { return split[1]; }
}

function getTransformUnit(propName) {
  if (stringContains(propName, 'translate') || propName === 'perspective') { return 'px'; }
  if (stringContains(propName, 'rotate') || stringContains(propName, 'skew')) { return 'deg'; }
}

// Values

function getFunctionValue(val, animatable) {
  if (!is.fnc(val)) { return val; }
  return val(animatable.target, animatable.id, animatable.total);
}

function getAttribute(el, prop) {
  return el.getAttribute(prop);
}

function convertPxToUnit(el, value, unit) {
  var valueUnit = getUnit(value);
  if (arrayContains([unit, 'deg', 'rad', 'turn'], valueUnit)) { return value; }
  var cached = cache.CSS[value + unit];
  if (!is.und(cached)) { return cached; }
  var baseline = 100;
  var tempEl = document.createElement(el.tagName);
  var parentEl = (el.parentNode && (el.parentNode !== document)) ? el.parentNode : document.body;
  parentEl.appendChild(tempEl);
  tempEl.style.position = 'absolute';
  tempEl.style.width = baseline + unit;
  var factor = baseline / tempEl.offsetWidth;
  parentEl.removeChild(tempEl);
  var convertedUnit = factor * parseFloat(value);
  cache.CSS[value + unit] = convertedUnit;
  return convertedUnit;
}

function getCSSValue(el, prop, unit) {
  if (prop in el.style) {
    var uppercasePropName = prop.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
    var value = el.style[prop] || getComputedStyle(el).getPropertyValue(uppercasePropName) || '0';
    return unit ? convertPxToUnit(el, value, unit) : value;
  }
}

function getAnimationType(el, prop) {
  if (is.dom(el) && !is.inp(el) && (!is.nil(getAttribute(el, prop)) || (is.svg(el) && el[prop]))) { return 'attribute'; }
  if (is.dom(el) && arrayContains(validTransforms, prop)) { return 'transform'; }
  if (is.dom(el) && (prop !== 'transform' && getCSSValue(el, prop))) { return 'css'; }
  if (el[prop] != null) { return 'object'; }
}

function getElementTransforms(el) {
  if (!is.dom(el)) { return; }
  var str = el.style.transform || '';
  var reg  = /(\w+)\(([^)]*)\)/g;
  var transforms = new Map();
  var m; while (m = reg.exec(str)) { transforms.set(m[1], m[2]); }
  return transforms;
}

function getTransformValue(el, propName, animatable, unit) {
  var defaultVal = stringContains(propName, 'scale') ? 1 : 0 + getTransformUnit(propName);
  var value = getElementTransforms(el).get(propName) || defaultVal;
  if (animatable) {
    animatable.transforms.list.set(propName, value);
    animatable.transforms['last'] = propName;
  }
  return unit ? convertPxToUnit(el, value, unit) : value;
}

function getOriginalTargetValue(target, propName, unit, animatable) {
  switch (getAnimationType(target, propName)) {
    case 'transform': return getTransformValue(target, propName, animatable, unit);
    case 'css': return getCSSValue(target, propName, unit);
    case 'attribute': return getAttribute(target, propName);
    default: return target[propName] || 0;
  }
}

function getRelativeValue(to, from) {
  var operator = /^(\*=|\+=|-=)/.exec(to);
  if (!operator) { return to; }
  var u = getUnit(to) || 0;
  var x = parseFloat(from);
  var y = parseFloat(to.replace(operator[0], ''));
  switch (operator[0][0]) {
    case '+': return x + y + u;
    case '-': return x - y + u;
    case '*': return x * y + u;
  }
}

function validateValue(val, unit) {
  if (is.col(val)) { return colorToRgb(val); }
  if (/\s/g.test(val)) { return val; }
  var originalUnit = getUnit(val);
  var unitLess = originalUnit ? val.substr(0, val.length - originalUnit.length) : val;
  if (unit) { return unitLess + unit; }
  return unitLess;
}

// getTotalLength() equivalent for circle, rect, polyline, polygon and line shapes
// adapted from https://gist.github.com/SebLambla/3e0550c496c236709744

function getDistance(p1, p2) {
  return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
}

function getCircleLength(el) {
  return Math.PI * 2 * getAttribute(el, 'r');
}

function getRectLength(el) {
  return (getAttribute(el, 'width') * 2) + (getAttribute(el, 'height') * 2);
}

function getLineLength(el) {
  return getDistance(
    {x: getAttribute(el, 'x1'), y: getAttribute(el, 'y1')}, 
    {x: getAttribute(el, 'x2'), y: getAttribute(el, 'y2')}
  );
}

function getPolylineLength(el) {
  var points = el.points;
  var totalLength = 0;
  var previousPos;
  for (var i = 0 ; i < points.numberOfItems; i++) {
    var currentPos = points.getItem(i);
    if (i > 0) { totalLength += getDistance(previousPos, currentPos); }
    previousPos = currentPos;
  }
  return totalLength;
}

function getPolygonLength(el) {
  var points = el.points;
  return getPolylineLength(el) + getDistance(points.getItem(points.numberOfItems - 1), points.getItem(0));
}

// Path animation

function getTotalLength(el) {
  if (el.getTotalLength) { return el.getTotalLength(); }
  switch(el.tagName.toLowerCase()) {
    case 'circle': return getCircleLength(el);
    case 'rect': return getRectLength(el);
    case 'line': return getLineLength(el);
    case 'polyline': return getPolylineLength(el);
    case 'polygon': return getPolygonLength(el);
  }
}

function setDashoffset(el) {
  var pathLength = getTotalLength(el);
  el.setAttribute('stroke-dasharray', pathLength);
  return pathLength;
}

// Motion path

function getParentSvgEl(el) {
  var parentEl = el.parentNode;
  while (is.svg(parentEl)) {
    if (!is.svg(parentEl.parentNode)) { break; }
    parentEl = parentEl.parentNode;
  }
  return parentEl;
}

function getParentSvg(pathEl, svgData) {
  var svg = svgData || {};
  var parentSvgEl = svg.el || getParentSvgEl(pathEl);
  var rect = parentSvgEl.getBoundingClientRect();
  var viewBoxAttr = getAttribute(parentSvgEl, 'viewBox');
  var width = rect.width;
  var height = rect.height;
  var viewBox = svg.viewBox || (viewBoxAttr ? viewBoxAttr.split(' ') : [0, 0, width, height]);
  return {
    el: parentSvgEl,
    viewBox: viewBox,
    x: viewBox[0] / 1,
    y: viewBox[1] / 1,
    w: width,
    h: height,
    vW: viewBox[2],
    vH: viewBox[3]
  }
}

function getPath(path, percent) {
  var pathEl = is.str(path) ? selectString(path)[0] : path;
  var p = percent || 100;
  return function(property) {
    return {
      property: property,
      el: pathEl,
      svg: getParentSvg(pathEl),
      totalLength: getTotalLength(pathEl) * (p / 100)
    }
  }
}

function getPathProgress(path, progress, isPathTargetInsideSVG) {
  function point(offset) {
    if ( offset === void 0 ) offset = 0;

    var l = progress + offset >= 1 ? progress + offset : 0;
    return path.el.getPointAtLength(l);
  }
  var svg = getParentSvg(path.el, path.svg);
  var p = point();
  var p0 = point(-1);
  var p1 = point(+1);
  var scaleX = isPathTargetInsideSVG ? 1 : svg.w / svg.vW;
  var scaleY = isPathTargetInsideSVG ? 1 : svg.h / svg.vH;
  switch (path.property) {
    case 'x': return (p.x - svg.x) * scaleX;
    case 'y': return (p.y - svg.y) * scaleY;
    case 'angle': return Math.atan2(p1.y - p0.y, p1.x - p0.x) * 180 / Math.PI;
  }
}

// Decompose value

function decomposeValue(val, unit) {
  // const rgx = /-?\d*\.?\d+/g; // handles basic numbers
  // const rgx = /[+-]?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var rgx = /[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?/g; // handles exponents notation
  var value = validateValue((is.pth(val) ? val.totalLength : val), unit) + '';
  return {
    original: value,
    numbers: value.match(rgx) ? value.match(rgx).map(Number) : [0],
    strings: (is.str(val) || unit) ? value.split(rgx) : []
  }
}

// Animatables

function parseTargets(targets) {
  var targetsArray = targets ? (flattenArray(is.arr(targets) ? targets.map(toArray) : toArray(targets))) : [];
  return filterArray(targetsArray, function (item, pos, self) { return self.indexOf(item) === pos; });
}

function getAnimatables(targets) {
  var parsed = parseTargets(targets);
  return parsed.map(function (t, i) {
    return {target: t, id: i, total: parsed.length, transforms: { list: getElementTransforms(t) } };
  });
}

// Properties

function normalizePropertyTweens(prop, tweenSettings) {
  var settings = cloneObject(tweenSettings);
  // Override duration if easing is a spring
  if (/^spring/.test(settings.easing)) { settings.duration = spring(settings.easing); }
  if (is.arr(prop)) {
    var l = prop.length;
    var isFromTo = (l === 2 && !is.obj(prop[0]));
    if (!isFromTo) {
      // Duration divided by the number of tweens
      if (!is.fnc(tweenSettings.duration)) { settings.duration = tweenSettings.duration / l; }
    } else {
      // Transform [from, to] values shorthand to a valid tween value
      prop = {value: prop};
    }
  }
  var propArray = is.arr(prop) ? prop : [prop];
  return propArray.map(function (v, i) {
    var obj = (is.obj(v) && !is.pth(v)) ? v : {value: v};
    // Default delay value should only be applied to the first tween
    if (is.und(obj.delay)) { obj.delay = !i ? tweenSettings.delay : 0; }
    // Default endDelay value should only be applied to the last tween
    if (is.und(obj.endDelay)) { obj.endDelay = i === propArray.length - 1 ? tweenSettings.endDelay : 0; }
    return obj;
  }).map(function (k) { return mergeObjects(k, settings); });
}


function flattenKeyframes(keyframes) {
  var propertyNames = filterArray(flattenArray(keyframes.map(function (key) { return Object.keys(key); })), function (p) { return is.key(p); })
  .reduce(function (a,b) { if (a.indexOf(b) < 0) { a.push(b); } return a; }, []);
  var properties = {};
  var loop = function ( i ) {
    var propName = propertyNames[i];
    properties[propName] = keyframes.map(function (key) {
      var newKey = {};
      for (var p in key) {
        if (is.key(p)) {
          if (p == propName) { newKey.value = key[p]; }
        } else {
          newKey[p] = key[p];
        }
      }
      return newKey;
    });
  };

  for (var i = 0; i < propertyNames.length; i++) loop( i );
  return properties;
}

function getProperties(tweenSettings, params) {
  var properties = [];
  var keyframes = params.keyframes;
  if (keyframes) { params = mergeObjects(flattenKeyframes(keyframes), params); }
  for (var p in params) {
    if (is.key(p)) {
      properties.push({
        name: p,
        tweens: normalizePropertyTweens(params[p], tweenSettings)
      });
    }
  }
  return properties;
}

// Tweens

function normalizeTweenValues(tween, animatable) {
  var t = {};
  for (var p in tween) {
    var value = getFunctionValue(tween[p], animatable);
    if (is.arr(value)) {
      value = value.map(function (v) { return getFunctionValue(v, animatable); });
      if (value.length === 1) { value = value[0]; }
    }
    t[p] = value;
  }
  t.duration = parseFloat(t.duration);
  t.delay = parseFloat(t.delay);
  return t;
}

function normalizeTweens(prop, animatable) {
  var previousTween;
  return prop.tweens.map(function (t) {
    var tween = normalizeTweenValues(t, animatable);
    var tweenValue = tween.value;
    var to = is.arr(tweenValue) ? tweenValue[1] : tweenValue;
    var toUnit = getUnit(to);
    var originalValue = getOriginalTargetValue(animatable.target, prop.name, toUnit, animatable);
    var previousValue = previousTween ? previousTween.to.original : originalValue;
    var from = is.arr(tweenValue) ? tweenValue[0] : previousValue;
    var fromUnit = getUnit(from) || getUnit(originalValue);
    var unit = toUnit || fromUnit;
    if (is.und(to)) { to = previousValue; }
    tween.from = decomposeValue(from, unit);
    tween.to = decomposeValue(getRelativeValue(to, from), unit);
    tween.start = previousTween ? previousTween.end : 0;
    tween.end = tween.start + tween.delay + tween.duration + tween.endDelay;
    tween.easing = parseEasings(tween.easing, tween.duration);
    tween.isPath = is.pth(tweenValue);
    tween.isPathTargetInsideSVG = tween.isPath && is.svg(animatable.target);
    tween.isColor = is.col(tween.from.original);
    if (tween.isColor) { tween.round = 1; }
    previousTween = tween;
    return tween;
  });
}

// Tween progress

var setProgressValue = {
  css: function (t, p, v) { return t.style[p] = v; },
  attribute: function (t, p, v) { return t.setAttribute(p, v); },
  object: function (t, p, v) { return t[p] = v; },
  transform: function (t, p, v, transforms, manual) {
    transforms.list.set(p, v);
    if (p === transforms.last || manual) {
      var str = '';
      transforms.list.forEach(function (value, prop) { str += prop + "(" + value + ") "; });
      t.style.transform = str;
    }
  }
};

// Set Value helper

function setTargetsValue(targets, properties) {
  var animatables = getAnimatables(targets);
  animatables.forEach(function (animatable) {
    for (var property in properties) {
      var value = getFunctionValue(properties[property], animatable);
      var target = animatable.target;
      var valueUnit = getUnit(value);
      var originalValue = getOriginalTargetValue(target, property, valueUnit, animatable);
      var unit = valueUnit || getUnit(originalValue);
      var to = getRelativeValue(validateValue(value, unit), originalValue);
      var animType = getAnimationType(target, property);
      setProgressValue[animType](target, property, to, animatable.transforms, true);
    }
  });
}

// Animations

function createAnimation(animatable, prop) {
  var animType = getAnimationType(animatable.target, prop.name);
  if (animType) {
    var tweens = normalizeTweens(prop, animatable);
    var lastTween = tweens[tweens.length - 1];
    return {
      type: animType,
      property: prop.name,
      animatable: animatable,
      tweens: tweens,
      duration: lastTween.end,
      delay: tweens[0].delay,
      endDelay: lastTween.endDelay
    }
  }
}

function getAnimations(animatables, properties) {
  return filterArray(flattenArray(animatables.map(function (animatable) {
    return properties.map(function (prop) {
      return createAnimation(animatable, prop);
    });
  })), function (a) { return !is.und(a); });
}

// Create Instance

function getInstanceTimings(animations, tweenSettings) {
  var animLength = animations.length;
  var getTlOffset = function (anim) { return anim.timelineOffset ? anim.timelineOffset : 0; };
  var timings = {};
  timings.duration = animLength ? Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration; })) : tweenSettings.duration;
  timings.delay = animLength ? Math.min.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.delay; })) : tweenSettings.delay;
  timings.endDelay = animLength ? timings.duration - Math.max.apply(Math, animations.map(function (anim) { return getTlOffset(anim) + anim.duration - anim.endDelay; })) : tweenSettings.endDelay;
  return timings;
}

var instanceID = 0;

function createNewInstance(params) {
  var instanceSettings = replaceObjectProps(defaultInstanceSettings, params);
  var tweenSettings = replaceObjectProps(defaultTweenSettings, params);
  var properties = getProperties(tweenSettings, params);
  var animatables = getAnimatables(params.targets);
  var animations = getAnimations(animatables, properties);
  var timings = getInstanceTimings(animations, tweenSettings);
  var id = instanceID;
  instanceID++;
  return mergeObjects(instanceSettings, {
    id: id,
    children: [],
    animatables: animatables,
    animations: animations,
    duration: timings.duration,
    delay: timings.delay,
    endDelay: timings.endDelay
  });
}

// Core

var activeInstances = [];

var engine = (function () {
  var raf;

  function play() {
    if (!raf && (!isDocumentHidden() || !anime.suspendWhenDocumentHidden) && activeInstances.length > 0) {
      raf = requestAnimationFrame(step);
    }
  }
  function step(t) {
    // memo on algorithm issue:
    // dangerous iteration over mutable `activeInstances`
    // (that collection may be updated from within callbacks of `tick`-ed animation instances)
    var activeInstancesLength = activeInstances.length;
    var i = 0;
    while (i < activeInstancesLength) {
      var activeInstance = activeInstances[i];
      if (!activeInstance.paused) {
        activeInstance.tick(t);
        i++;
      } else {
        activeInstances.splice(i, 1);
        activeInstancesLength--;
      }
    }
    raf = i > 0 ? requestAnimationFrame(step) : undefined;
  }

  function handleVisibilityChange() {
    if (!anime.suspendWhenDocumentHidden) { return; }

    if (isDocumentHidden()) {
      // suspend ticks
      raf = cancelAnimationFrame(raf);
    } else { // is back to active tab
      // first adjust animations to consider the time that ticks were suspended
      activeInstances.forEach(
        function (instance) { return instance ._onDocumentVisibility(); }
      );
      engine();
    }
  }
  if (typeof document !== 'undefined') {
    document.addEventListener('visibilitychange', handleVisibilityChange);
  }

  return play;
})();

function isDocumentHidden() {
  return !!document && document.hidden;
}

// Public Instance

function anime(params) {
  if ( params === void 0 ) params = {};


  var startTime = 0, lastTime = 0, now = 0;
  var children, childrenLength = 0;
  var resolve = null;

  function makePromise(instance) {
    var promise = window.Promise && new Promise(function (_resolve) { return resolve = _resolve; });
    instance.finished = promise;
    return promise;
  }

  var instance = createNewInstance(params);
  makePromise(instance);

  function toggleInstanceDirection() {
    var direction = instance.direction;
    if (direction !== 'alternate') {
      instance.direction = direction !== 'normal' ? 'normal' : 'reverse';
    }
    instance.reversed = !instance.reversed;
    children.forEach(function (child) { return child.reversed = instance.reversed; });
  }

  function adjustTime(time) {
    return instance.reversed ? instance.duration - time : time;
  }

  function resetTime() {
    startTime = 0;
    lastTime = adjustTime(instance.currentTime) * (1 / anime.speed);
  }

  function seekChild(time, child) {
    if (child) { child.seek(time - child.timelineOffset); }
  }

  function syncInstanceChildren(time) {
    if (!instance.reversePlayback) {
      for (var i = 0; i < childrenLength; i++) { seekChild(time, children[i]); }
    } else {
      for (var i$1 = childrenLength; i$1--;) { seekChild(time, children[i$1]); }
    }
  }

  function setAnimationsProgress(insTime) {
    var i = 0;
    var animations = instance.animations;
    var animationsLength = animations.length;
    while (i < animationsLength) {
      var anim = animations[i];
      var animatable = anim.animatable;
      var tweens = anim.tweens;
      var tweenLength = tweens.length - 1;
      var tween = tweens[tweenLength];
      // Only check for keyframes if there is more than one tween
      if (tweenLength) { tween = filterArray(tweens, function (t) { return (insTime < t.end); })[0] || tween; }
      var elapsed = minMax(insTime - tween.start - tween.delay, 0, tween.duration) / tween.duration;
      var eased = isNaN(elapsed) ? 1 : tween.easing(elapsed);
      var strings = tween.to.strings;
      var round = tween.round;
      var numbers = [];
      var toNumbersLength = tween.to.numbers.length;
      var progress = (void 0);
      for (var n = 0; n < toNumbersLength; n++) {
        var value = (void 0);
        var toNumber = tween.to.numbers[n];
        var fromNumber = tween.from.numbers[n] || 0;
        if (!tween.isPath) {
          value = fromNumber + (eased * (toNumber - fromNumber));
        } else {
          value = getPathProgress(tween.value, eased * toNumber, tween.isPathTargetInsideSVG);
        }
        if (round) {
          if (!(tween.isColor && n > 2)) {
            value = Math.round(value * round) / round;
          }
        }
        numbers.push(value);
      }
      // Manual Array.reduce for better performances
      var stringsLength = strings.length;
      if (!stringsLength) {
        progress = numbers[0];
      } else {
        progress = strings[0];
        for (var s = 0; s < stringsLength; s++) {
          var b = strings[s + 1];
          var n$1 = numbers[s];
          if (!isNaN(n$1)) {
            if (!b) {
              progress += n$1 + ' ';
            } else {
              progress += n$1 + b;
            }
          }
        }
      }
      setProgressValue[anim.type](animatable.target, anim.property, progress, animatable.transforms);
      anim.currentValue = progress;
      i++;
    }
  }

  function setCallback(cb) {
    if (instance[cb] && !instance.passThrough) { instance[cb](instance); }
  }

  function countIteration() {
    if (instance.remaining && instance.remaining !== true) {
      instance.remaining--;
    }
  }

  function setInstanceProgress(engineTime) {
    var insDuration = instance.duration;
    var insDelay = instance.delay;
    var insEndDelay = insDuration - instance.endDelay;
    var insTime = adjustTime(engineTime);
    instance.progress = minMax((insTime / insDuration) * 100, 0, 100);
    instance.reversePlayback = insTime < instance.currentTime;
    if (children) { syncInstanceChildren(insTime); }
    if (!instance.began && instance.currentTime > 0) {
      instance.began = true;
      setCallback('begin');
    }
    if (!instance.loopBegan && instance.currentTime > 0) {
      instance.loopBegan = true;
      setCallback('loopBegin');
    }
    if (insTime <= insDelay && instance.currentTime !== 0) {
      setAnimationsProgress(0);
    }
    if ((insTime >= insEndDelay && instance.currentTime !== insDuration) || !insDuration) {
      setAnimationsProgress(insDuration);
    }
    if (insTime > insDelay && insTime < insEndDelay) {
      if (!instance.changeBegan) {
        instance.changeBegan = true;
        instance.changeCompleted = false;
        setCallback('changeBegin');
      }
      setCallback('change');
      setAnimationsProgress(insTime);
    } else {
      if (instance.changeBegan) {
        instance.changeCompleted = true;
        instance.changeBegan = false;
        setCallback('changeComplete');
      }
    }
    instance.currentTime = minMax(insTime, 0, insDuration);
    if (instance.began) { setCallback('update'); }
    if (engineTime >= insDuration) {
      lastTime = 0;
      countIteration();
      if (!instance.remaining) {
        instance.paused = true;
        if (!instance.completed) {
          instance.completed = true;
          setCallback('loopComplete');
          setCallback('complete');
          if (!instance.passThrough && 'Promise' in window) {
            resolve();
            makePromise(instance);
          }
        }
      } else {
        startTime = now;
        setCallback('loopComplete');
        instance.loopBegan = false;
        if (instance.direction === 'alternate') {
          toggleInstanceDirection();
        }
      }
    }
  }

  instance.reset = function() {
    var direction = instance.direction;
    instance.passThrough = false;
    instance.currentTime = 0;
    instance.progress = 0;
    instance.paused = true;
    instance.began = false;
    instance.loopBegan = false;
    instance.changeBegan = false;
    instance.completed = false;
    instance.changeCompleted = false;
    instance.reversePlayback = false;
    instance.reversed = direction === 'reverse';
    instance.remaining = instance.loop;
    children = instance.children;
    childrenLength = children.length;
    for (var i = childrenLength; i--;) { instance.children[i].reset(); }
    if (instance.reversed && instance.loop !== true || (direction === 'alternate' && instance.loop === 1)) { instance.remaining++; }
    setAnimationsProgress(instance.reversed ? instance.duration : 0);
  };

  // internal method (for engine) to adjust animation timings before restoring engine ticks (rAF)
  instance._onDocumentVisibility = resetTime;

  // Set Value helper

  instance.set = function(targets, properties) {
    setTargetsValue(targets, properties);
    return instance;
  };

  instance.tick = function(t) {
    now = t;
    if (!startTime) { startTime = now; }
    setInstanceProgress((now + (lastTime - startTime)) * anime.speed);
  };

  instance.seek = function(time) {
    setInstanceProgress(adjustTime(time));
  };

  instance.pause = function() {
    instance.paused = true;
    resetTime();
  };

  instance.play = function() {
    if (!instance.paused) { return; }
    if (instance.completed) { instance.reset(); }
    instance.paused = false;
    activeInstances.push(instance);
    resetTime();
    engine();
  };

  instance.reverse = function() {
    toggleInstanceDirection();
    instance.completed = instance.reversed ? false : true;
    resetTime();
  };

  instance.restart = function() {
    instance.reset();
    instance.play();
  };

  instance.remove = function(targets) {
    var targetsArray = parseTargets(targets);
    removeTargetsFromInstance(targetsArray, instance);
  };

  instance.reset();

  if (instance.autoplay) { instance.play(); }

  return instance;

}

// Remove targets from animation

function removeTargetsFromAnimations(targetsArray, animations) {
  for (var a = animations.length; a--;) {
    if (arrayContains(targetsArray, animations[a].animatable.target)) {
      animations.splice(a, 1);
    }
  }
}

function removeTargetsFromInstance(targetsArray, instance) {
  var animations = instance.animations;
  var children = instance.children;
  removeTargetsFromAnimations(targetsArray, animations);
  for (var c = children.length; c--;) {
    var child = children[c];
    var childAnimations = child.animations;
    removeTargetsFromAnimations(targetsArray, childAnimations);
    if (!childAnimations.length && !child.children.length) { children.splice(c, 1); }
  }
  if (!animations.length && !children.length) { instance.pause(); }
}

function removeTargetsFromActiveInstances(targets) {
  var targetsArray = parseTargets(targets);
  for (var i = activeInstances.length; i--;) {
    var instance = activeInstances[i];
    removeTargetsFromInstance(targetsArray, instance);
  }
}

// Stagger helpers

function stagger(val, params) {
  if ( params === void 0 ) params = {};

  var direction = params.direction || 'normal';
  var easing = params.easing ? parseEasings(params.easing) : null;
  var grid = params.grid;
  var axis = params.axis;
  var fromIndex = params.from || 0;
  var fromFirst = fromIndex === 'first';
  var fromCenter = fromIndex === 'center';
  var fromLast = fromIndex === 'last';
  var isRange = is.arr(val);
  var val1 = isRange ? parseFloat(val[0]) : parseFloat(val);
  var val2 = isRange ? parseFloat(val[1]) : 0;
  var unit = getUnit(isRange ? val[1] : val) || 0;
  var start = params.start || 0 + (isRange ? val1 : 0);
  var values = [];
  var maxValue = 0;
  return function (el, i, t) {
    if (fromFirst) { fromIndex = 0; }
    if (fromCenter) { fromIndex = (t - 1) / 2; }
    if (fromLast) { fromIndex = t - 1; }
    if (!values.length) {
      for (var index = 0; index < t; index++) {
        if (!grid) {
          values.push(Math.abs(fromIndex - index));
        } else {
          var fromX = !fromCenter ? fromIndex%grid[0] : (grid[0]-1)/2;
          var fromY = !fromCenter ? Math.floor(fromIndex/grid[0]) : (grid[1]-1)/2;
          var toX = index%grid[0];
          var toY = Math.floor(index/grid[0]);
          var distanceX = fromX - toX;
          var distanceY = fromY - toY;
          var value = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
          if (axis === 'x') { value = -distanceX; }
          if (axis === 'y') { value = -distanceY; }
          values.push(value);
        }
        maxValue = Math.max.apply(Math, values);
      }
      if (easing) { values = values.map(function (val) { return easing(val / maxValue) * maxValue; }); }
      if (direction === 'reverse') { values = values.map(function (val) { return axis ? (val < 0) ? val * -1 : -val : Math.abs(maxValue - val); }); }
    }
    var spacing = isRange ? (val2 - val1) / maxValue : val1;
    return start + (spacing * (Math.round(values[i] * 100) / 100)) + unit;
  }
}

// Timeline

function timeline(params) {
  if ( params === void 0 ) params = {};

  var tl = anime(params);
  tl.duration = 0;
  tl.add = function(instanceParams, timelineOffset) {
    var tlIndex = activeInstances.indexOf(tl);
    var children = tl.children;
    if (tlIndex > -1) { activeInstances.splice(tlIndex, 1); }
    function passThrough(ins) { ins.passThrough = true; }
    for (var i = 0; i < children.length; i++) { passThrough(children[i]); }
    var insParams = mergeObjects(instanceParams, replaceObjectProps(defaultTweenSettings, params));
    insParams.targets = insParams.targets || params.targets;
    var tlDuration = tl.duration;
    insParams.autoplay = false;
    insParams.direction = tl.direction;
    insParams.timelineOffset = is.und(timelineOffset) ? tlDuration : getRelativeValue(timelineOffset, tlDuration);
    passThrough(tl);
    tl.seek(insParams.timelineOffset);
    var ins = anime(insParams);
    passThrough(ins);
    children.push(ins);
    var timings = getInstanceTimings(children, params);
    tl.delay = timings.delay;
    tl.endDelay = timings.endDelay;
    tl.duration = timings.duration;
    tl.seek(0);
    tl.reset();
    if (tl.autoplay) { tl.play(); }
    return tl;
  };
  return tl;
}

anime.version = '3.2.1';
anime.speed = 1;
// TODO:#review: naming, documentation
anime.suspendWhenDocumentHidden = true;
anime.running = activeInstances;
anime.remove = removeTargetsFromActiveInstances;
anime.get = getOriginalTargetValue;
anime.set = setTargetsValue;
anime.convertPx = convertPxToUnit;
anime.path = getPath;
anime.setDashoffset = setDashoffset;
anime.stagger = stagger;
anime.timeline = timeline;
anime.easing = parseEasings;
anime.penner = penner;
anime.random = function (min, max) { return Math.floor(Math.random() * (max - min + 1)) + min; };

const applicationSidebarCss = "/*!@:host*/.sc-ix-application-sidebar-h{display:block;position:relative;width:22rem;height:100%;padding:0}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-application-sidebar-h *.sc-ix-application-sidebar,.sc-ix-application-sidebar-h *.sc-ix-application-sidebar::after,.sc-ix-application-sidebar-h *.sc-ix-application-sidebar::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-application-sidebar-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-application-sidebar-h .sc-ix-application-sidebar::-webkit-scrollbar-corner{display:none}/*!@:host(.visible)*/.visible.sc-ix-application-sidebar-h{border-right:2px solid var(--theme-color-soft-bdr);padding:1.5rem 0.5rem 0}";
var IxApplicationSidebarStyle0 = applicationSidebarCss;

/** @internal */
class ApplicationSidebar {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.visible = true;
    }
    listenToggleEvent() {
        const visibility = !this.visible;
        const animation = {
            targets: this.hostElement,
            width: visibility ? ['0', '22rem'] : ['22rem', '0'],
            opacity: visibility ? [0, 1] : [1, 0],
            easing: 'easeInSine',
            duration: Animation.defaultTime,
        };
        const changeVisibility = () => {
            this.visible = visibility;
        };
        if (visibility) {
            animation.begin = changeVisibility.bind(this);
        }
        else {
            animation.complete = changeVisibility.bind(this);
        }
        anime(animation);
    }
    render() {
        return (hAsync(Host, { key: '58452e01549d1141ba862068da508cf9cb57ce39', slot: "application-sidebar", class: {
                visible: this.visible,
            } }, this.visible ? hAsync("slot", null) : null));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxApplicationSidebarStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-application-sidebar",
        "$members$": {
            "visible": [32]
        },
        "$listeners$": [[8, "application-sidebar-toggle", "listenToggleEvent"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const applicationSwitchModalCss = "/*!@:host*/.sc-ix-application-switch-modal-h{display:block}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-application-switch-modal-h *.sc-ix-application-switch-modal,.sc-ix-application-switch-modal-h *.sc-ix-application-switch-modal::after,.sc-ix-application-switch-modal-h *.sc-ix-application-switch-modal::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-application-switch-modal-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-application-switch-modal-h .sc-ix-application-switch-modal::-webkit-scrollbar-corner{display:none}/*!@:host .content*/.sc-ix-application-switch-modal-h .content.sc-ix-application-switch-modal{padding:2rem;padding-right:0}/*!@:host .content-apps*/.sc-ix-application-switch-modal-h .content-apps.sc-ix-application-switch-modal{display:flex;position:relative;flex-wrap:wrap;justify-content:space-evenly;max-height:50vh;margin-right:0.25rem;gap:1.5rem}/*!@:host .loading*/.sc-ix-application-switch-modal-h .loading.sc-ix-application-switch-modal{display:flex;flex-direction:row;align-items:center}/*!@:host .loading ix-spinner*/.sc-ix-application-switch-modal-h .loading.sc-ix-application-switch-modal ix-spinner.sc-ix-application-switch-modal{margin-right:1rem}/*!@:host .AppEntry*/.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal{all:unset;display:flex;flex-direction:row;align-items:center;gap:1rem;padding:0.5rem;flex:1 1 45%;cursor:pointer;border:0.0625rem solid transparent}/*!@:host .AppEntry.Selected*/.sc-ix-application-switch-modal-h .AppEntry.Selected.sc-ix-application-switch-modal{background-color:var(--theme-color-ghost--selected);border:var(--theme-dynamic-bdr-1)}/*!@:host .AppEntry:not(.disabled):not(:disabled).hover, :host .AppEntry:not(.disabled):not(:disabled):hover*/.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal:not(.disabled):not(:disabled).hover,.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal:not(.disabled):not(:disabled):hover{background-color:var(--theme-ghost--background--hover)}/*!@:host .AppEntry:not(.disabled):not(:disabled).active, :host .AppEntry:not(.disabled):not(:disabled):active*/.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal:not(.disabled):not(:disabled).active,.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal:not(.disabled):not(:disabled):active{background-color:var(--theme-ghost--background--active)}/*!@:host .AppEntry:focus-visible*/.sc-ix-application-switch-modal-h .AppEntry.sc-ix-application-switch-modal:focus-visible{border:1px solid var(--theme-color-focus-bdr)}/*!@:host .AppName*/.sc-ix-application-switch-modal-h .AppName.sc-ix-application-switch-modal{display:flex;flex-direction:column}/*!@:host .AppName ix-icon*/.sc-ix-application-switch-modal-h .AppName.sc-ix-application-switch-modal ix-icon.sc-ix-application-switch-modal{margin-left:1rem}/*!@:host .AppIcon*/.sc-ix-application-switch-modal-h .AppIcon.sc-ix-application-switch-modal{width:3rem;height:3rem;border-radius:0.25rem}";
var IxApplicationSwitchModalStyle0 = applicationSwitchModalCss;

function ApplicationItem(props) {
    function isExternal(target) {
        if (target !== '_blank' &&
            target !== '_parent' &&
            target !== '_self' &&
            target !== '_top') {
            // Check if its one of the target keywords
            // https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a?retiredLocale=de#target
            return true;
        }
        if (target === '_blank') {
            return true;
        }
        return false;
    }
    return (hAsync("button", { class: {
            AppEntry: true,
            Selected: props.selected,
        }, onClick: () => {
            dismissModal(props.host);
            window.open(props.url, props.target);
        } }, hAsync("div", null, hAsync("img", { class: "AppIcon", src: props.iconSrc })), hAsync("div", { class: "AppName" }, hAsync("ix-typography", { format: "h4" }, props.name, isExternal(props.target) && (hAsync("ix-icon", { size: "12", name: "open-external", color: "color-soft-text" }))), hAsync("ix-typography", { format: "label-sm", color: "soft" }, props.description))));
}
/** @internal */
class ApplicationSwitchModal {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.config = undefined;
    }
    componentWillLoad() {
        if (!this.config) {
            throw Error('ApplicationConfig not provided');
        }
    }
    render() {
        var _a, _b, _c, _d;
        return (hAsync(Host, { key: '13df4ab7564da79469932dcc5bf35eed6970d3c4' }, hAsync("ix-modal-header", { key: '299cbb27124b8f93e24ab45de1a884604a84763b', icon: "apps" }, ((_a = this.config) === null || _a === void 0 ? void 0 : _a.i18nAppSwitch) || 'Switch to application'), hAsync("ix-modal-content", { key: 'd3ef35dc36431cc1bb0dd203518d01f6cf768aa7', class: "content" }, hAsync("div", { key: 'de19382fb99fe6b871451e62413f43e382a42eb8', class: "content-apps" }, (!this.config || ((_b = this.config) === null || _b === void 0 ? void 0 : _b.apps.length) === 0) && (hAsync("div", { key: '66e1e8ba812abb5ce81798607fb3d93715c4a756', class: "loading" }, hAsync("ix-spinner", { key: '54839567ae56eb47457d73cc4b0f2033f659c88b', size: "medium", variant: "primary" }), hAsync("span", { key: '39c47a980c5d230e8365c70c6957d38385eb80d1' }, ((_c = this.config) === null || _c === void 0 ? void 0 : _c.i18nLoadingApps) ||
            'Loading available applications...'))), (_d = this.config) === null || _d === void 0 ? void 0 :
            _d.apps.map((appEntry) => {
                var _a;
                return (hAsync(ApplicationItem, { host: this.hostElement, name: appEntry.name, description: appEntry.description, iconSrc: appEntry.iconSrc, target: appEntry.target, url: appEntry.url, selected: appEntry.id === ((_a = this.config) === null || _a === void 0 ? void 0 : _a.currentAppId) }));
            })))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxApplicationSwitchModalStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-application-switch-modal",
        "$members$": {
            "config": [16]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const isDanger = (variant) => {
    return variant.toUpperCase() === 'Danger'.toUpperCase();
};
const isPrimary = (variant) => {
    return variant.toUpperCase() === 'Primary'.toUpperCase();
};
const isSecondary = (variant) => {
    return variant.toUpperCase() === 'Secondary'.toUpperCase();
};
const getButtonClasses = (variant, outline, ghost, iconOnly = false, iconOval = false, selected, disabled) => {
    return {
        btn: true,
        'btn-danger': isDanger(variant) && !outline && !ghost,
        'btn-outline-danger': isDanger(variant) && outline && !ghost,
        'btn-invisible-danger': isDanger(variant) && !outline && ghost,
        'btn-primary': isPrimary(variant) && !outline && !ghost,
        'btn-outline-primary': isPrimary(variant) && outline && !ghost,
        'btn-invisible-primary': isPrimary(variant) && !outline && ghost,
        'btn-secondary': isSecondary(variant) && !outline && !ghost,
        'btn-outline-secondary': isSecondary(variant) && outline && !ghost,
        'btn-invisible-secondary': isSecondary(variant) && !outline && ghost,
        'btn-icon': iconOnly,
        'btn-oval': iconOval,
        selected: selected,
        disabled: disabled,
    };
};
const getSpinnerSize = (btnProps) => {
    if (!btnProps.icon) {
        return 'small';
    }
    switch (btnProps.iconSize) {
        case '12':
            return 'xx-small';
        case '16':
            return 'x-small';
        default:
            return 'small';
    }
};
function BaseButton(props, children) {
    var _a, _b, _c;
    const extraClasses = (_a = props.extraClasses) !== null && _a !== void 0 ? _a : {};
    const ariaAttributes = (_b = props.ariaAttributes) !== null && _b !== void 0 ? _b : {};
    if (!ariaAttributes['aria-disabled'] && props.disabled) {
        ariaAttributes['aria-disabled'] = 'true';
    }
    return (hAsync("button", Object.assign({}, ariaAttributes, { onClick: (e) => (props.onClick ? props.onClick(e) : undefined), tabindex: props.disabled ? -1 : (_c = props.tabIndex) !== null && _c !== void 0 ? _c : 0, type: props.type, class: Object.assign(Object.assign({}, getButtonClasses(props.variant, props.outline, props.ghost, props.iconOnly, props.iconOval, props.selected, props.disabled || props.loading)), extraClasses) }),
        props.loading ? (hAsync("ix-spinner", { size: getSpinnerSize(props), hideTrack: true })) : null,
        props.icon && !props.loading ? (hAsync("ix-icon", { class: "icon", name: props.icon, size: props.iconSize, color: props.iconColor })) : null,
        hAsync("div", { class: {
                content: true,
                [`content-${props.alignment}`]: !!props.alignment,
            } }, children),
        props.afterContent ? props.afterContent : null));
}

const avatarCss = "/*!@:host*/.sc-ix-avatar-h{display:flex;position:relative;width:-moz-fit-content;width:fit-content}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-avatar-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-avatar-h .sc-ix-avatar::-webkit-scrollbar-corner{display:none}/*!@:host .avatar*/.sc-ix-avatar-h .avatar.sc-ix-avatar{display:flex;align-items:center}/*!@:host .avatar > .avatar-image*/.sc-ix-avatar-h .avatar.sc-ix-avatar>.avatar-image.sc-ix-avatar{height:2rem;width:2rem;min-height:2rem;min-width:2rem;border-radius:100px}/*!@:host .avatar > .avatar-initials*/.sc-ix-avatar-h .avatar.sc-ix-avatar>.avatar-initials.sc-ix-avatar{display:flex;align-items:center;justify-content:center;height:2rem;width:2rem;min-height:2rem;min-width:2rem;border-radius:100px;background-color:var(--theme-avatar--background);color:var(--theme-avatar--color)}/*!@:host .avatar #avatar-path-background*/.sc-ix-avatar-h .avatar.sc-ix-avatar #avatar-path-background.sc-ix-avatar{fill:var(--theme-avatar--background)}/*!@:host .avatar #avatar-path-person*/.sc-ix-avatar-h .avatar.sc-ix-avatar #avatar-path-person.sc-ix-avatar{fill:var(--theme-avatar--color)}/*!@:host .user-info*/.sc-ix-avatar-h .user-info.sc-ix-avatar{display:flex;flex-direction:row;position:relative;height:2.5rem;padding:1rem;width:12.75rem;min-width:12.75rem;max-width:12.75rem;gap:1rem}/*!@:host .user-info .avatar*/.sc-ix-avatar-h .user-info.sc-ix-avatar .avatar.sc-ix-avatar{width:2rem;pointer-events:none}/*!@:host .user-info .user*/.sc-ix-avatar-h .user-info.sc-ix-avatar .user.sc-ix-avatar{display:flex;position:relative;flex-direction:column;justify-content:center;max-width:10rem;width:100%;overflow:hidden}/*!@:host .user-info .username*/.sc-ix-avatar-h .user-info.sc-ix-avatar .username.sc-ix-avatar{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}/*!@:host .user-info .extra*/.sc-ix-avatar-h .user-info.sc-ix-avatar .extra.sc-ix-avatar{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}/*!@:host(.avatar-button) button*/.avatar-button.sc-ix-avatar-h button.sc-ix-avatar{all:unset;box-sizing:border-box;display:inline-flex;flex-direction:row;flex-wrap:nowrap;overflow:hidden;align-items:center;justify-content:center;width:100%;height:100%;padding:0 0.5rem;padding:0px;border-radius:100px !important}/*!@:host(.avatar-button) .btn-invisible-primary*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar{border-radius:var(--theme-btn--border-radius)}/*!@:host(.avatar-button) .btn-invisible-primary, :host(.avatar-button) .btn-invisible-primary.focus, :host(.avatar-button) .btn-invisible-primary:focus-visible*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar,.avatar-button.sc-ix-avatar-h .btn-invisible-primary.focus.sc-ix-avatar,.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:focus-visible{background-color:var(--theme-btn-invisible-primary--background);color:var(--theme-btn-invisible-primary--color);--ix-button-color:var(--theme-btn-invisible-primary--color);border-color:transparent}/*!@:host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled):focus-visible*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host(.avatar-button) .btn-invisible-primary.selected*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover, :host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled):active, :host(.avatar-button) .btn-invisible-primary.selected:not(.disabled):not(:disabled).active*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar:not(.disabled):not(:disabled):active,.avatar-button.sc-ix-avatar-h .btn-invisible-primary.selected.sc-ix-avatar:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled)*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled):hover, :host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled):hover*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-primary--background--hover);color:var(--theme-btn-invisible-primary--color--hover)}/*!@:host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled)*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled):active, :host(.avatar-button) .btn-invisible-primary:not(.disabled):not(:disabled).active*/.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled):active,.avatar-button.sc-ix-avatar-h .btn-invisible-primary.sc-ix-avatar:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-primary--background--active);color:var(--theme-btn-invisible-primary--color--active)}/*!@:host(.avatar-button) li*/.avatar-button.sc-ix-avatar-h li.sc-ix-avatar{transform:scale(0.8)}";
var IxAvatarStyle0 = avatarCss;

function DefaultAvatar(props) {
    const { initials } = props;
    if (initials) {
        return hAsync("div", { class: 'avatar-initials' }, initials);
    }
    return (hAsync("svg", { class: 'avatar-image', xmlns: "http://www.w3.org/2000/svg", width: "32", height: "32", viewBox: "0 0 32 32" }, hAsync("g", { fill: "none", "fill-rule": "evenodd" }, hAsync("path", { id: "avatar-path-background", d: "M16 0C7.163 0 0 7.163 0 16s7.163 16 16 16 16-7.163\n          16-16c0-4.243-1.686-8.313-4.686-11.314C24.314 1.686 20.244 0 16 0z" }), hAsync("path", { id: "avatar-path-person", d: "M17.897 17.91c3.8-.018 7.358 1.875 9.485 5.046-2.417 3.999-6.734 6.434-11.382\n        6.42-4.648.014-8.965-2.421-11.382-6.42 2.127-3.171 5.685-5.064\n        9.485-5.045h3.794zM15.821 2.129c3.682 0 6.667 2.984 6.667 6.666 0 3.682-2.985\n        6.667-6.667 6.667s-6.667-2.985-6.667-6.667 2.985-6.666 6.667-6.666z" }))));
}
function AvatarImage(props) {
    return (hAsync("li", { class: "avatar" }, props.image ? (hAsync("img", { src: props.image, class: "avatar-image" })) : (hAsync(DefaultAvatar, { initials: props.initials }))));
}
function UserInfo(props) {
    return (hAsync(Fragment, null, hAsync("div", { class: "user-info", onClick: (event) => event.preventDefault() }, hAsync(AvatarImage, { image: props.image, initials: props.initials }), hAsync("div", { class: "user" }, hAsync("div", { class: "username" }, props.userName), props.extra && (hAsync("ix-typography", { class: "extra", color: 'soft' }, props.extra))))));
}
/**
 * @since 2.0.0
 */
class Avatar {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.image = undefined;
        this.initials = undefined;
        this.username = undefined;
        this.extra = undefined;
        this.isClosestApplicationHeader = false;
        this.hasSlottedElements = false;
    }
    componentWillLoad() {
        const closest = closestElement('ix-application-header', this.hostElement);
        this.isClosestApplicationHeader = closest !== null;
    }
    slottedChanged() {
        this.hasSlottedElements = hasSlottedElements(this.slotElement);
    }
    resolveAvatarTrigger() {
        return new Promise((resolve) => {
            readTask(() => resolve(this.hostElement.shadowRoot.querySelector('button')));
        });
    }
    onDropdownClick(event) {
        if (event.target === this.dropdownElement) {
            event.preventDefault();
        }
    }
    render() {
        if (this.isClosestApplicationHeader) {
            return (hAsync(Host, { slot: "ix-application-header-avatar", class: 'avatar-button' }, hAsync(BaseButton, { disabled: false, ghost: true, iconOval: false, icon: undefined, iconOnly: false, loading: false, outline: false, selected: false, type: "button", variant: "primary" }, hAsync(AvatarImage, { image: this.image, initials: this.initials })), hAsync("ix-dropdown", { ref: (ref) => (this.dropdownElement = ref), trigger: this.resolveAvatarTrigger(), class: "avatar-dropdown", onClick: (e) => this.onDropdownClick(e) }, this.username && (hAsync(Fragment, null, hAsync(UserInfo, { extra: this.extra, image: this.image, initials: this.initials, userName: this.username }), this.hasSlottedElements && (hAsync("ix-divider", { onClick: (e) => e.preventDefault() })))), hAsync("slot", { onSlotchange: () => this.slottedChanged(), ref: (ref) => (this.slotElement = ref) }))));
        }
        return (hAsync(Host, null, hAsync(AvatarImage, { image: this.image, initials: this.initials })));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxAvatarStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-avatar",
        "$members$": {
            "image": [1],
            "initials": [1],
            "username": [1],
            "extra": [1],
            "isClosestApplicationHeader": [32],
            "hasSlottedElements": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const basicNavigationCss = "/*!@:host*/.sc-ix-basic-navigation-h{display:flex;position:relative;width:100%;height:100%;flex-direction:column}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-basic-navigation-h *.sc-ix-basic-navigation,.sc-ix-basic-navigation-h *.sc-ix-basic-navigation::after,.sc-ix-basic-navigation-h *.sc-ix-basic-navigation::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-basic-navigation-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-basic-navigation-h .sc-ix-basic-navigation::-webkit-scrollbar-corner{display:none}/*!@:host ix-application-header*/.sc-ix-basic-navigation-h ix-application-header.sc-ix-basic-navigation{z-index:calc(var(--theme-z-index-sticky) + 1)}/*!@:host .logo-wrapper*/.sc-ix-basic-navigation-h .logo-wrapper.sc-ix-basic-navigation{display:contents}/*!@:host .content*/.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{display:flex;height:100%;width:100%;position:relative;margin-left:3.25rem;overflow:auto}/*!@:host .navigation-content*/.sc-ix-basic-navigation-h .navigation-content.sc-ix-basic-navigation{display:flex;position:relative;flex-direction:row;height:calc(100% - 2.75rem);width:100%}/*!@:host(.hide-header) .navigation-content,\n:host(.hide-header) .content*/.hide-header.sc-ix-basic-navigation-h .navigation-content.sc-ix-basic-navigation,.hide-header.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{height:100%}/*!@:host(.breakpoint-lg) .content*/.breakpoint-lg.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{margin-left:0rem}/*!@:host(.breakpoint-sm) .content*/.breakpoint-sm.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{margin-left:0px;width:100%}";
var IxBasicNavigationStyle0 = basicNavigationCss;

class BasicNavigation {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.applicationName = undefined;
        this.hideHeader = false;
        this.forceBreakpoint = undefined;
        this.breakpoints = ['sm', 'md', 'lg'];
        this.breakpoint = 'lg';
    }
    onHideHeaderChange() {
        var _a;
        (_a = this.contextProvider) === null || _a === void 0 ? void 0 : _a.emit({
            hideHeader: this.hideHeader,
            host: 'basic-navigation',
        });
        this.breakpoint = applicationLayoutService.breakpoint;
    }
    forceLayoutChange(newMode) {
        if (!newMode) {
            applicationLayoutService.enableBreakpointDetection();
            return;
        }
        applicationLayoutService.disableBreakpointDetection();
        applicationLayoutService.setBreakpoint(newMode);
    }
    onBreakpointsChange(breakpoints) {
        applicationLayoutService.setBreakpoints(breakpoints);
    }
    get menu() {
        return this.hostElement.querySelector('ix-menu');
    }
    onContentClick() {
        var _a;
        if (menuController.isPinned) {
            return;
        }
        (_a = this.menu) === null || _a === void 0 ? void 0 : _a.toggleMenu(false);
    }
    componentWillLoad() {
        applicationLayoutService.setBreakpoints(this.breakpoints);
        this.contextProvider = useContextProvider(this.hostElement, ApplicationLayoutContext, {
            hideHeader: this.hideHeader,
            host: 'basic-navigation',
        });
        this.modeDisposable = applicationLayoutService.onChange.on((mode) => {
            this.breakpoint = mode;
        });
        this.breakpoint = applicationLayoutService.breakpoint;
        if (this.forceBreakpoint) {
            this.forceLayoutChange(this.forceBreakpoint);
        }
    }
    componentDidRender() {
        if (this.menu) {
            this.menu.applicationName = this.applicationName;
        }
    }
    disconnectedCallback() {
        var _a;
        (_a = this.modeDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
    }
    render() {
        return (hAsync(Host, { key: 'b666966827ad02aaf1efeb3c8e80e476279a2416', "data-role": "", class: {
                'hide-header': this.hideHeader,
                [`breakpoint-${this.breakpoint}`]: true,
            } }, !this.hideHeader ? (hAsync("ix-application-header", { name: this.applicationName }, hAsync("slot", { name: "logo", slot: "logo" }))) : null, hAsync("div", { key: '1d470073c3840334f2776e1651672ce896c38609', class: "navigation-content" }, hAsync("slot", { key: '1288c6fb5d71c87ffa78e9407de01e26bd0da896', name: "menu" }), hAsync("div", { key: 'ceb81e26897c1e229746ad65c8ca33cc0412dadc', class: "content", onClick: () => this.onContentClick() }, hAsync("slot", { key: '67fa579c656f227d7fa555ceafdf20e07cc2bf0c' })))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "hideHeader": ["onHideHeaderChange"],
        "breakpoints": ["onBreakpointsChange"]
    }; }
    static get style() { return IxBasicNavigationStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-basic-navigation",
        "$members$": {
            "applicationName": [1, "application-name"],
            "hideHeader": [4, "hide-header"],
            "forceBreakpoint": [1, "force-breakpoint"],
            "breakpoints": [16],
            "breakpoint": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const isHttpUrl = (link) => {
    if (!link) {
        return false;
    }
    let url;
    try {
        url = new URL(link);
    }
    catch (e) {
        return false;
    }
    return url.protocol === 'http:' || url.protocol === 'https:';
};
const isSvgDataUrl = (url) => {
    if (!url) {
        return false;
    }
    if (typeof url !== 'string') {
        return false;
    }
    return url.startsWith('data:image/svg+xml');
};

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const a11yBoolean = (value) => (value ? 'true' : 'false');
const kebabCaseToUpperCaseSentence = (kebabCase) => {
    const withoutFilledSuffix = kebabCase.replace('-filled', '');
    const words = withoutFilledSuffix.split('-');
    const sentence = words
        .map((word) => {
        const trimWord = word.trim();
        const digitLessWord = trimWord.replace(/\d+/g, '');
        if (digitLessWord.length === 0) {
            return trimWord;
        }
        return digitLessWord;
    })
        .map((word) => word.charAt(0).toUpperCase() + word.slice(1))
        .join(' ');
    return sentence;
};
const getFallbackLabelFromIconName = (iconName) => {
    if (!iconName) {
        return 'Unknown';
    }
    if (isHttpUrl(iconName)) {
        return 'Unknown';
    }
    if (isSvgDataUrl(iconName)) {
        return 'Unknown';
    }
    const label = kebabCaseToUpperCaseSentence(iconName);
    if (label.length === 0) {
        return 'Unknown';
    }
    return label;
};
const a11yHostAttributes = (hostElement, ignoreAttributes = []) => {
    const attributeObject = {};
    a11yAttributes.forEach((attr) => {
        if (hostElement.hasAttribute(attr)) {
            const value = hostElement.getAttribute(attr);
            if (value !== null && !ignoreAttributes.includes(attr)) {
                attributeObject[attr] = hostElement.getAttribute(attr);
                hostElement.removeAttribute(attr);
            }
        }
    });
    return attributeObject;
};
const a11yAttributes = [
    'role',
    'aria-activedescendant',
    'aria-atomic',
    'aria-autocomplete',
    'aria-braillelabel',
    'aria-brailleroledescription',
    'aria-busy',
    'aria-checked',
    'aria-colcount',
    'aria-colindex',
    'aria-colindextext',
    'aria-colspan',
    'aria-controls',
    'aria-current',
    'aria-describedby',
    'aria-description',
    'aria-details',
    'aria-disabled',
    'aria-errormessage',
    'aria-expanded',
    'aria-flowto',
    'aria-haspopup',
    'aria-hidden',
    'aria-invalid',
    'aria-keyshortcuts',
    'aria-label',
    'aria-labelledby',
    'aria-level',
    'aria-live',
    'aria-multiline',
    'aria-multiselectable',
    'aria-orientation',
    'aria-owns',
    'aria-placeholder',
    'aria-posinset',
    'aria-pressed',
    'aria-readonly',
    'aria-relevant',
    'aria-required',
    'aria-roledescription',
    'aria-rowcount',
    'aria-rowindex',
    'aria-rowindextext',
    'aria-rowspan',
    'aria-selected',
    'aria-setsize',
    'aria-sort',
    'aria-valuemax',
    'aria-valuemin',
    'aria-valuenow',
    'aria-valuetext',
];

const blindCss = "/*!@:host*/.sc-ix-blind-h{display:flex;flex-direction:column;border-radius:var(--theme-blind--border-radius);overflow:hidden}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-blind-h *.sc-ix-blind,.sc-ix-blind-h *.sc-ix-blind::after,.sc-ix-blind-h *.sc-ix-blind::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-blind-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-blind-h .sc-ix-blind::-webkit-scrollbar-corner{display:none}/*!@:host .blind-header-wrapper*/.sc-ix-blind-h .blind-header-wrapper.sc-ix-blind{position:relative;min-height:3rem;height:3rem;overflow:hidden}/*!@:host .blind-header-content*/.sc-ix-blind-h .blind-header-content.sc-ix-blind{display:flex;position:relative;align-items:center;justify-content:flex-start;width:100%;height:100%;pointer-events:none;padding-left:0.5rem}/*!@:host .blind-header-title*/.sc-ix-blind-h .blind-header-title.sc-ix-blind{display:flex;position:relative;align-items:center;flex-grow:1;margin-right:0.5rem}/*!@:host .blind-header*/.sc-ix-blind-h .blind-header.sc-ix-blind{all:unset;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:block;position:absolute;top:0px;left:0px;pointer-events:all;padding-left:2.5rem;min-height:3rem;height:3rem;width:calc(100% - 2 * var(--theme-blind--border-thickness));border:solid var(--theme-blind--border-thickness) transparent;border-radius:var(--theme-blind--border-radius) var(--theme-blind--border-radius) 0 0;cursor:pointer}/*!@:host .blind-header:not(.disabled):not(:disabled):focus-visible*/.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):focus-visible{border-color:var(--theme-color-focus-bdr);outline:none}/*!@:host .blind-header-title-icon,\n:host .collapse-icon*/.sc-ix-blind-h .blind-header-title-icon.sc-ix-blind,.sc-ix-blind-h .collapse-icon.sc-ix-blind{margin-right:0.5rem}/*!@:host .blind-header-title-row*/.sc-ix-blind-h .blind-header-title-row.sc-ix-blind{display:flex;flex-grow:1;overflow:hidden}/*!@:host .blind-header-title-col*/.sc-ix-blind-h .blind-header-title-col.sc-ix-blind{display:inline-flex;align-items:center;width:calc(100% - 1rem);overflow:hidden}/*!@:host .blind-header-title-col:not(:first-of-type)*/.sc-ix-blind-h .blind-header-title-col.sc-ix-blind:not(:first-of-type){justify-content:flex-end}/*!@:host ix-typography*/.sc-ix-blind-h ix-typography.sc-ix-blind{flex-grow:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}/*!@:host .blind-header-title-label*/.sc-ix-blind-h .blind-header-title-label.sc-ix-blind{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;padding-inline-end:0.5rem}/*!@:host .blind-header-title-sublabel*/.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;padding-inline:0.5rem}/*!@:host .blind-header-title*/.sc-ix-blind-h .blind-header-title.sc-ix-blind{display:flex;align-items:center;flex-grow:1;height:100%;min-width:0}/*!@:host .blind-header-labels*/.sc-ix-blind-h .blind-header-labels.sc-ix-blind{display:inline-flex;flex-grow:1;min-width:0}/*!@:host .blind-content*/.sc-ix-blind-h .blind-content.sc-ix-blind{display:block;padding:1rem;transition-property:padding;transition-duration:var(--theme-default-time);transition-timing-function:ease-in}/*!@:host .blind-content.hide*/.sc-ix-blind-h .blind-content.hide.sc-ix-blind{max-height:0;padding-top:0px;padding-bottom:0px}/*!@:host .header-actions*/.sc-ix-blind-h .header-actions.sc-ix-blind{pointer-events:all;margin-left:auto}/*!@:host(.blind-alarm)*/.blind-alarm.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-alarm) .blind-header*/.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-alarm)}/*!@:host(.blind-alarm) .blind-header:not(.disabled):not(:disabled)*/.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-alarm) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-alarm) .blind-header:not(.disabled):not(:disabled):hover*/.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-alarm--hover)}/*!@:host(.blind-alarm) .blind-header:not(.disabled):not(:disabled)*/.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-alarm) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-alarm) .blind-header:not(.disabled):not(:disabled).active*/.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-alarm.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-alarm--active)}/*!@:host(.blind-alarm) .blind-header-title-label,\n:host(.blind-alarm) .blind-header-title-sublabel*/.blind-alarm.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-alarm.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-alarm--contrast)}/*!@:host(.blind-critical)*/.blind-critical.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-critical) .blind-header*/.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-critical)}/*!@:host(.blind-critical) .blind-header:not(.disabled):not(:disabled)*/.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-critical) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-critical) .blind-header:not(.disabled):not(:disabled):hover*/.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-critical--hover)}/*!@:host(.blind-critical) .blind-header:not(.disabled):not(:disabled)*/.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-critical) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-critical) .blind-header:not(.disabled):not(:disabled).active*/.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-critical.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-critical--active)}/*!@:host(.blind-critical) .blind-header-title-label,\n:host(.blind-critical) .blind-header-title-sublabel*/.blind-critical.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-critical.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-critical--contrast)}/*!@:host(.blind-info)*/.blind-info.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-info) .blind-header*/.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-info)}/*!@:host(.blind-info) .blind-header:not(.disabled):not(:disabled)*/.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-info) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-info) .blind-header:not(.disabled):not(:disabled):hover*/.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-info--hover)}/*!@:host(.blind-info) .blind-header:not(.disabled):not(:disabled)*/.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-info) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-info) .blind-header:not(.disabled):not(:disabled).active*/.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-info.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-info--active)}/*!@:host(.blind-info) .blind-header-title-label,\n:host(.blind-info) .blind-header-title-sublabel*/.blind-info.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-info.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-info--contrast)}/*!@:host(.blind-insight)*/.blind-insight.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-insight) .blind-header*/.blind-insight.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-insight)}/*!@:host(.blind-insight) .blind-header:not(.disabled):not(:disabled).hover, :host(.blind-insight) .blind-header:not(.disabled):not(:disabled):hover*/.blind-insight.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).hover,.blind-insight.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-ghost--background--hover)}/*!@:host(.blind-insight) .blind-header:not(.disabled):not(:disabled).active, :host(.blind-insight) .blind-header:not(.disabled):not(:disabled):active*/.blind-insight.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active,.blind-insight.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active{background-color:var(--theme-ghost--background--active)}/*!@:host(.blind-insight) .blind-header-title-label*/.blind-insight.sc-ix-blind-h .blind-header-title-label.sc-ix-blind{color:var(--theme-color-std-text)}/*!@:host(.blind-insight) .blind-header-title-sublabel*/.blind-insight.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-soft-text)}/*!@:host(.blind-neutral)*/.blind-neutral.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-neutral) .blind-header*/.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-neutral)}/*!@:host(.blind-neutral) .blind-header:not(.disabled):not(:disabled)*/.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-neutral) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-neutral) .blind-header:not(.disabled):not(:disabled):hover*/.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-neutral--hover)}/*!@:host(.blind-neutral) .blind-header:not(.disabled):not(:disabled)*/.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-neutral) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-neutral) .blind-header:not(.disabled):not(:disabled).active*/.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-neutral.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-neutral--active)}/*!@:host(.blind-neutral) .blind-header-title-label,\n:host(.blind-neutral) .blind-header-title-sublabel*/.blind-neutral.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-neutral.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-neutral--contrast)}/*!@:host(.blind-notification)*/.blind-notification.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-notification) .blind-header*/.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-notification)}/*!@:host(.blind-notification) .blind-header:not(.disabled):not(:disabled)*/.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-notification) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-notification) .blind-header:not(.disabled):not(:disabled):hover*/.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-notification--hover)}/*!@:host(.blind-notification) .blind-header:not(.disabled):not(:disabled)*/.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-notification) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-notification) .blind-header:not(.disabled):not(:disabled).active*/.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-notification.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-notification--active)}/*!@:host(.blind-notification) .blind-header-title-label,\n:host(.blind-notification) .blind-header-title-sublabel*/.blind-notification.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-notification.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-notification--contrast)}/*!@:host(.blind-success)*/.blind-success.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-success) .blind-header*/.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-success)}/*!@:host(.blind-success) .blind-header:not(.disabled):not(:disabled)*/.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-success) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-success) .blind-header:not(.disabled):not(:disabled):hover*/.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-success--hover)}/*!@:host(.blind-success) .blind-header:not(.disabled):not(:disabled)*/.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-success) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-success) .blind-header:not(.disabled):not(:disabled).active*/.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-success.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-success--active)}/*!@:host(.blind-success) .blind-header-title-label,\n:host(.blind-success) .blind-header-title-sublabel*/.blind-success.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-success.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-success--contrast)}/*!@:host(.blind-warning)*/.blind-warning.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-warning) .blind-header*/.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-warning)}/*!@:host(.blind-warning) .blind-header:not(.disabled):not(:disabled)*/.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-warning) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-warning) .blind-header:not(.disabled):not(:disabled):hover*/.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-warning--hover)}/*!@:host(.blind-warning) .blind-header:not(.disabled):not(:disabled)*/.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-warning) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-warning) .blind-header:not(.disabled):not(:disabled).active*/.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-warning.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-warning--active)}/*!@:host(.blind-warning) .blind-header-title-label,\n:host(.blind-warning) .blind-header-title-sublabel*/.blind-warning.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-warning.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-warning--contrast)}/*!@:host(.blind-primary)*/.blind-primary.sc-ix-blind-h{background-color:var(--theme-blind-base--background)}/*!@:host(.blind-primary) .blind-header*/.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-primary)}/*!@:host(.blind-primary) .blind-header:not(.disabled):not(:disabled)*/.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-primary) .blind-header:not(.disabled):not(:disabled):hover, :host(.blind-primary) .blind-header:not(.disabled):not(:disabled):hover*/.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-primary--hover)}/*!@:host(.blind-primary) .blind-header:not(.disabled):not(:disabled)*/.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled){cursor:pointer}/*!@:host(.blind-primary) .blind-header:not(.disabled):not(:disabled):active, :host(.blind-primary) .blind-header:not(.disabled):not(:disabled).active*/.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active,.blind-primary.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active{background-color:var(--theme-color-primary--active)}/*!@:host(.blind-primary) .blind-header-title-label,\n:host(.blind-primary) .blind-header-title-sublabel*/.blind-primary.sc-ix-blind-h .blind-header-title-label.sc-ix-blind,.blind-primary.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-primary--contrast)}/*!@:host(.blind-outline)*/.blind-outline.sc-ix-blind-h{border:solid var(--theme-blind--border-thickness) var(--theme-blind-base--border-color);border-color:var(--theme-color-soft-bdr)}/*!@:host(.blind-outline) .blind-header*/.blind-outline.sc-ix-blind-h .blind-header.sc-ix-blind{background-color:var(--theme-color-ghost)}/*!@:host(.blind-outline) .blind-header:not(.disabled):not(:disabled).hover, :host(.blind-outline) .blind-header:not(.disabled):not(:disabled):hover*/.blind-outline.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).hover,.blind-outline.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):hover{background-color:var(--theme-ghost--background--hover)}/*!@:host(.blind-outline) .blind-header:not(.disabled):not(:disabled).active, :host(.blind-outline) .blind-header:not(.disabled):not(:disabled):active*/.blind-outline.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled).active,.blind-outline.sc-ix-blind-h .blind-header.sc-ix-blind:not(.disabled):not(:disabled):active{background-color:var(--theme-ghost--background--active)}/*!@:host(.blind-outline) .blind-header-title-label*/.blind-outline.sc-ix-blind-h .blind-header-title-label.sc-ix-blind{color:var(--theme-color-std-text)}/*!@:host(.blind-outline) .blind-header-title-sublabel*/.blind-outline.sc-ix-blind-h .blind-header-title-sublabel.sc-ix-blind{color:var(--theme-color-soft-text)}";
var IxBlindStyle0 = blindCss;

let sequentialInstanceId = 0;
class Blind {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.collapsedChange = createEvent(this, "collapsedChange", 7);
        this.blindId = ++sequentialInstanceId;
        this.collapsed = false;
        this.label = undefined;
        this.sublabel = undefined;
        this.icon = undefined;
        this.variant = 'insight';
    }
    onHeaderClick() {
        this.collapsed = !this.collapsed;
        this.collapsedChange.emit(this.collapsed);
    }
    componentDidLoad() {
        this.animateCollapse(this.collapsed);
    }
    get content() {
        return this.hostElement.shadowRoot.querySelector('.blind-content');
    }
    animation(isCollapsed) {
        this.animateCollapse(isCollapsed);
    }
    animateCollapse(isCollapsed) {
        if (isCollapsed) {
            this.rotateChevronRight();
        }
        else {
            this.rotateChevronDown();
        }
    }
    rotateChevronDown() {
        anime({
            targets: this.chevronRef,
            duration: 150,
            easing: 'easeInOutSine',
            rotateZ: 90,
        });
        anime({
            targets: this.content,
            duration: 150,
            easing: 'easeInOutSine',
            opacity: 1,
        });
    }
    rotateChevronRight() {
        anime({
            targets: this.chevronRef,
            duration: 150,
            easing: 'easeInOutSine',
            rotateZ: 0,
        });
        anime({
            targets: this.content,
            duration: 150,
            easing: 'easeInOutSine',
            opacity: 0,
        });
    }
    render() {
        return (hAsync(Host, { key: '5ec247be84e5612134ffec1e53730f61a214cd0b', class: {
                [`blind-${this.variant}`]: true,
            } }, hAsync("div", { key: 'abe3273f7a820cd6481d7f75a174e3c6c332b438', class: 'blind-header-wrapper' }, hAsync("button", { key: '12a572e7145c435451a8a9cc89f66c50d58d3cca', class: {
                'blind-header': true,
                [`blind-${this.variant}`]: true,
                closed: this.collapsed,
            }, type: "button", "aria-labelledby": `ix-blind-header-title-${this.blindId}`, "aria-controls": `ix-blind-content-section-${this.blindId}`, "aria-expanded": a11yBoolean(!this.collapsed), onClick: () => this.onHeaderClick() }, hAsync("slot", { key: '11a9cc78537fac060310eeba7f57a147907e2a14', name: "custom-header" })), hAsync("div", { key: '08abe64452f9841fc50951708ffdbb13f594e80b', class: 'blind-header-content' }, hAsync("ix-icon", { key: '67a41dada571459470153b03247bc7f175c206de', class: "collapse-icon", name: 'chevron-right-small', color: this.variant === 'insight' || this.variant === 'outline'
                ? 'color-primary'
                : `color-${this.variant}--contrast`, ref: (ref) => (this.chevronRef = ref) }), hAsync("div", { key: '6a898defd05378868577745464956fd8ecc67472', class: "blind-header-title", id: `ix-blind-header-title-${this.blindId}` }, this.label !== undefined ? (hAsync(Fragment, null, this.icon && (hAsync("ix-icon", { class: "blind-header-title-icon", name: this.icon, color: this.variant === 'insight' || this.variant === 'outline'
                ? 'color-std-text'
                : `color-${this.variant}--contrast` })), hAsync("div", { class: 'blind-header-title-row' }, hAsync("div", { class: "blind-header-title-col" }, hAsync("ix-typography", { title: this.label, format: "label-lg", bold: true }, hAsync("div", { class: "blind-header-title-label", title: this.label }, this.label))), this.sublabel && (hAsync("div", { class: "blind-header-title-col" }, hAsync("ix-typography", { title: this.sublabel }, hAsync("div", { class: "blind-header-title-sublabel" }, this.sublabel))))), hAsync("div", { class: "header-actions" }, hAsync("slot", { name: "header-actions" })))) : null))), hAsync("section", { key: '909fdaeec7732c55c81833e6f0212cea5b2174b0', id: `ix-blind-content-section-${this.blindId}`, "aria-labelledby": `ix-blind-header-title-${this.blindId}` }, hAsync("div", { key: 'ace2f5a2269acc3d0c2c79a0cf31df6283038bec', class: {
                'blind-content': true,
                hide: this.collapsed,
            } }, !this.collapsed ? hAsync("slot", null) : null))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "collapsed": ["animation"]
    }; }
    static get style() { return IxBlindStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-blind",
        "$members$": {
            "collapsed": [1540],
            "label": [1],
            "sublabel": [1],
            "icon": [1],
            "variant": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["collapsed", "collapsed"]]
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const createMutationObserver = (callback) => new MutationObserver(callback);

const breadcrumbCss = "/*!@:host*/.sc-ix-breadcrumb-h{display:flex;justify-content:flex-start;height:2.5rem;align-items:center;background-color:transparent;overflow:hidden}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-breadcrumb-h *.sc-ix-breadcrumb,.sc-ix-breadcrumb-h *.sc-ix-breadcrumb::after,.sc-ix-breadcrumb-h *.sc-ix-breadcrumb::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-breadcrumb-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-breadcrumb-h .sc-ix-breadcrumb::-webkit-scrollbar-corner{display:none}/*!@:host .previous-button*/.sc-ix-breadcrumb-h .previous-button.sc-ix-breadcrumb{width:3rem;min-width:0px}/*!@:host .crumb-dropdown*/.sc-ix-breadcrumb-h .crumb-dropdown.sc-ix-breadcrumb{overflow:visible}/*!@:host .remove-anchor::after*/.sc-ix-breadcrumb-h .remove-anchor.sc-ix-breadcrumb::after{display:none}/*!@:host .more-text*/.sc-ix-breadcrumb-h .more-text.sc-ix-breadcrumb{display:flex}/*!@:host .more-text .more-text-ellipsis*/.sc-ix-breadcrumb-h .more-text.sc-ix-breadcrumb .more-text-ellipsis.sc-ix-breadcrumb{width:1rem;display:inline-block;font-weight:700}/*!@:host .more-text ix-icon*/.sc-ix-breadcrumb-h .more-text.sc-ix-breadcrumb ix-icon.sc-ix-breadcrumb{padding-top:2px}/*!@:host nav,\n:host ol,\n:host .crumb-items*/.sc-ix-breadcrumb-h nav.sc-ix-breadcrumb,.sc-ix-breadcrumb-h ol.sc-ix-breadcrumb,.sc-ix-breadcrumb-h .crumb-items.sc-ix-breadcrumb{display:contents}";
var IxBreadcrumbStyle0 = breadcrumbCss;

let sequenceId$1 = 0;
const createId = (prefix = 'breadcrumb-') => {
    return `${prefix}-${sequenceId$1++}`;
};
class Breadcrumb {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.itemClick = createEvent(this, "itemClick", 7);
        this.nextClick = createEvent(this, "nextClick", 7);
        this.previousButtonId = createId();
        this.previousDropdownId = createId();
        this.visibleItemCount = 9;
        this.nextItems = [];
        this.ghost = true;
        this.ariaLabelPreviousButton = 'previous';
        this.previousButtonRef = undefined;
        this.nextButtonRef = undefined;
        this.items = [];
        this.isPreviousDropdownExpanded = false;
    }
    onNextItemsChange() {
        this.onChildMutation();
    }
    onItemClick(item) {
        this.itemClick.emit(item);
    }
    componentDidLoad() {
        this.mutationObserver = createMutationObserver(() => this.onChildMutation());
        this.mutationObserver.observe(this.hostElement, {
            subtree: true,
            childList: true,
        });
    }
    componentWillLoad() {
        this.onChildMutation();
    }
    disconnectedCallback() {
        var _a;
        (_a = this.mutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    async onChildMutation() {
        const updatedItems = this.getItems();
        updatedItems.forEach((bc, index) => {
            const shouldShowDropdown = this.nextItems.length !== 0 && updatedItems.length - 1 === index;
            bc.ghost = this.ghost;
            bc.showChevron = updatedItems.length - 1 !== index || shouldShowDropdown;
            bc.isDropdownTrigger = shouldShowDropdown;
            if (shouldShowDropdown) {
                this.nextButtonRef = bc;
            }
            if (updatedItems.length < this.visibleItemCount) {
                return;
            }
            bc.visible = index >= updatedItems.length - this.visibleItemCount;
        });
        this.items = updatedItems;
    }
    getItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-breadcrumb-item'));
    }
    render() {
        var _a, _b, _c, _d;
        const a11y = a11yHostAttributes(this.hostElement);
        return (hAsync(Host, { key: '01b7b3c2b8e5b4eccea75ea1ffb85d91516888ab' }, hAsync("ix-dropdown", { key: 'acd5584e3cfcb2b698a36e65a9f706f955f525e7', id: this.previousDropdownId, "aria-label": this.ariaLabelPreviousButton, trigger: ((_a = this.items) === null || _a === void 0 ? void 0 : _a.length) > this.visibleItemCount
                ? this.previousButtonRef
                : null, onShowChanged: ({ detail }) => {
                this.isPreviousDropdownExpanded = detail;
                const previousButton = this.hostElement.shadowRoot.getElementById(this.previousButtonId);
                // Need to force update previous button to change `aria-expanded`
                if (previousButton) {
                    forceUpdate(this.hostElement.shadowRoot.getElementById(this.previousButtonId));
                }
            } }, this.items
            .slice(0, this.items.length - this.visibleItemCount)
            .map((item) => {
            var _a;
            const label = (_a = item.label) !== null && _a !== void 0 ? _a : item.innerText;
            return (hAsync("ix-dropdown-item", { label: label, onClick: () => {
                    this.onItemClick(label);
                }, onItemClick: (event) => event.stopPropagation() }));
        })), ((_b = this.items) === null || _b === void 0 ? void 0 : _b.length) > this.visibleItemCount ? (hAsync("ix-breadcrumb-item", { id: this.previousButtonId, ref: (ref) => (this.previousButtonRef = ref), label: "...", tabIndex: 1, onItemClick: (event) => event.stopPropagation(), "aria-describedby": this.previousDropdownId, "aria-controls": this.previousDropdownId, "aria-expanded": a11yBoolean(this.isPreviousDropdownExpanded), class: 'previous-button' })) : null, hAsync("nav", { key: '5528a34e56c4dbcf8130652b517ca717c3158294', class: "crumb-items", "aria-label": (_c = a11y['aria-label']) !== null && _c !== void 0 ? _c : 'breadcrumbs' }, hAsync("ol", { key: '5e74629e99a27aad5140a0bf519db8513adfc5ff' }, hAsync("slot", { key: '4cf1e9f67ca27bd9f8f6e06e6e6a946048306f78' }))), hAsync("ix-dropdown", { key: 'f16070f4edffdef90c32e8f426e492d8b856f5ef', trigger: this.nextButtonRef }, (_d = this.nextItems) === null || _d === void 0 ? void 0 : _d.map((item) => (hAsync("ix-dropdown-item", { label: item, onClick: (e) => {
                this.nextClick.emit({
                    event: e,
                    item,
                });
            }, onItemClick: (event) => event.stopPropagation() }))))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "nextItems": ["onNextItemsChange"]
    }; }
    static get style() { return IxBreadcrumbStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-breadcrumb",
        "$members$": {
            "visibleItemCount": [2, "visible-item-count"],
            "nextItems": [16],
            "ghost": [4],
            "ariaLabelPreviousButton": [1, "aria-label-previous-button"],
            "previousButtonRef": [32],
            "nextButtonRef": [32],
            "items": [32],
            "isPreviousDropdownExpanded": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const breadcrumbItemCss = "/*!@:host*/.sc-ix-breadcrumb-item-h{display:inline-block;height:2rem;vertical-align:middle;cursor:pointer;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:700;line-height:1.429em;color:var(--theme-color-std-text)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::after,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-breadcrumb-item-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-corner{display:none}/*!@:host button*/.sc-ix-breadcrumb-item-h button.sc-ix-breadcrumb-item{all:unset;box-sizing:border-box;display:inline-flex;flex-direction:row;flex-wrap:nowrap;overflow:hidden;align-items:center;justify-content:center;width:100%;height:100%;padding:0 0.5rem}/*!@:host ix-spinner*/.sc-ix-breadcrumb-item-h ix-spinner.sc-ix-breadcrumb-item{margin-right:0.25rem}/*!@:host ix-icon*/.sc-ix-breadcrumb-item-h ix-icon.sc-ix-breadcrumb-item{margin-right:0.25rem}/*!@:host .content*/.sc-ix-breadcrumb-item-h .content.sc-ix-breadcrumb-item{display:inline-block;position:relative;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}/*!@:host .content-start*/.sc-ix-breadcrumb-item-h .content-start.sc-ix-breadcrumb-item{width:100%}/*!@:host .icon*/.sc-ix-breadcrumb-item-h .icon.sc-ix-breadcrumb-item{pointer-events:none}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{cursor:default}/*!@:host .btn-danger*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-danger, :host .btn-danger.focus, :host .btn-danger:focus-visible*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-danger.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-danger--background);color:var(--theme-btn-danger--color);--ix-button-color:var(--theme-btn-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-danger--border-color);border-style:solid}/*!@:host .btn-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-danger.selected*/.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):active, :host .btn-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):hover, :host .btn-danger:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-danger--border-color--hover);background-color:var(--theme-btn-danger--background--hover);color:var(--theme-btn-danger--color--hover)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):active, :host .btn-danger:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-danger--border-color--active);background-color:var(--theme-btn-danger--background--active);color:var(--theme-btn-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-danger.disabled, :host(.disabled) .btn-danger:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-danger.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-danger.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-danger--border-color--disabled);background-color:var(--theme-btn-danger--background--disabled);color:var(--theme-btn-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-danger--color--disabled)}/*!@:host .btn-outline-danger*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-danger, :host .btn-outline-danger.focus, :host .btn-outline-danger:focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-danger.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-outline-danger--background);color:var(--theme-btn-outline-danger--color);--ix-button-color:var(--theme-btn-outline-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-danger--border-color);border-style:solid}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-danger.selected*/.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):active, :host .btn-outline-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):hover, :host .btn-outline-danger:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-danger--border-color--hover);background-color:var(--theme-btn-outline-danger--background--hover);color:var(--theme-btn-outline-danger--color--hover)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):active, :host .btn-outline-danger:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-danger--border-color--active);background-color:var(--theme-btn-outline-danger--background--active);color:var(--theme-btn-outline-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-danger.disabled, :host(.disabled) .btn-outline-danger:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-outline-danger.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-outline-danger.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-outline-danger--border-color--disabled);background-color:var(--theme-btn-outline-danger--background--disabled);color:var(--theme-btn-outline-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-danger--color--disabled)}/*!@:host .btn-invisible-danger*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-danger, :host .btn-invisible-danger.focus, :host .btn-invisible-danger:focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-danger.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-invisible-danger--background);color:var(--theme-btn-invisible-danger--color);--ix-button-color:var(--theme-btn-invisible-danger--color);border-color:transparent}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-danger.selected*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-danger.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-danger--background--hover);color:var(--theme-btn-invisible-danger--color--hover)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):active, :host .btn-invisible-danger:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-danger--background--active);color:var(--theme-btn-invisible-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-danger.disabled, :host(.disabled) .btn-invisible-danger:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-invisible-danger.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-invisible-danger.sc-ix-breadcrumb-item:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-danger--background--disabled);color:var(--theme-btn-invisible-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-danger--color--disabled)}/*!@:host .btn-primary*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-primary, :host .btn-primary.focus, :host .btn-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-primary--background);color:var(--theme-btn-primary--color);--ix-button-color:var(--theme-btn-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-primary--border-color);border-style:solid}/*!@:host .btn-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-primary.selected*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):active, :host .btn-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):hover, :host .btn-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-primary--border-color--hover);background-color:var(--theme-btn-primary--background--hover);color:var(--theme-btn-primary--color--hover)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):active, :host .btn-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-primary--border-color--active);background-color:var(--theme-btn-primary--background--active);color:var(--theme-btn-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-primary.disabled, :host(.disabled) .btn-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-primary--border-color--disabled);background-color:var(--theme-btn-primary--background--disabled);color:var(--theme-btn-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-primary--color--disabled)}/*!@:host .btn-outline-primary*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-primary, :host .btn-outline-primary.focus, :host .btn-outline-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-outline-primary--background);color:var(--theme-btn-outline-primary--color);--ix-button-color:var(--theme-btn-outline-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-primary--border-color);border-style:solid}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-primary.selected*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):hover, :host .btn-outline-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-primary--border-color--hover);background-color:var(--theme-btn-outline-primary--background--hover);color:var(--theme-btn-outline-primary--color--hover)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):active, :host .btn-outline-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-primary--border-color--active);background-color:var(--theme-btn-outline-primary--background--active);color:var(--theme-btn-outline-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-primary.disabled, :host(.disabled) .btn-outline-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-outline-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-outline-primary--border-color--disabled);background-color:var(--theme-btn-outline-primary--background--disabled);color:var(--theme-btn-outline-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-primary--color--disabled)}/*!@:host .btn-invisible-primary*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-primary, :host .btn-invisible-primary.focus, :host .btn-invisible-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-invisible-primary--background);color:var(--theme-btn-invisible-primary--color);--ix-button-color:var(--theme-btn-invisible-primary--color);border-color:transparent}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-primary.selected*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-primary--background--hover);color:var(--theme-btn-invisible-primary--color--hover)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):active, :host .btn-invisible-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-primary--background--active);color:var(--theme-btn-invisible-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-primary.disabled, :host(.disabled) .btn-invisible-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-invisible-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-primary--background--disabled);color:var(--theme-btn-invisible-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-primary--color--disabled)}/*!@:host .btn-secondary*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-secondary, :host .btn-secondary.focus, :host .btn-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-secondary--background);color:var(--theme-btn-secondary--color);--ix-button-color:var(--theme-btn-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-secondary--border-color);border-style:solid}/*!@:host .btn-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):hover, :host .btn-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-secondary--border-color--hover);background-color:var(--theme-btn-secondary--background--hover);color:var(--theme-btn-secondary--color--hover)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):active, :host .btn-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-secondary--border-color--active);background-color:var(--theme-btn-secondary--background--active);color:var(--theme-btn-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-secondary.disabled, :host(.disabled) .btn-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-secondary--border-color--disabled);background-color:var(--theme-btn-secondary--background--disabled);color:var(--theme-btn-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-secondary--color--disabled)}/*!@:host .btn-outline-secondary*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-secondary, :host .btn-outline-secondary.focus, :host .btn-outline-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-outline-secondary--background);color:var(--theme-btn-outline-secondary--color);--ix-button-color:var(--theme-btn-outline-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-secondary--border-color);border-style:solid}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-secondary--border-color--hover);background-color:var(--theme-btn-outline-secondary--background--hover);color:var(--theme-btn-outline-secondary--color--hover)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):active, :host .btn-outline-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-secondary--border-color--active);background-color:var(--theme-btn-outline-secondary--background--active);color:var(--theme-btn-outline-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-secondary.disabled, :host(.disabled) .btn-outline-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-outline-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-outline-secondary--border-color--disabled);background-color:var(--theme-btn-outline-secondary--background--disabled);color:var(--theme-btn-outline-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-secondary--color--disabled)}/*!@:host .btn-invisible-secondary*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-secondary, :host .btn-invisible-secondary.focus, :host .btn-invisible-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-invisible-secondary--background);color:var(--theme-btn-invisible-secondary--color);--ix-button-color:var(--theme-btn-invisible-secondary--color);border-color:transparent}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-secondary--background--hover);color:var(--theme-btn-invisible-secondary--color--hover)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-secondary--background--active);color:var(--theme-btn-invisible-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-secondary.disabled, :host(.disabled) .btn-invisible-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-invisible-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-secondary--background--disabled);color:var(--theme-btn-invisible-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-secondary--color--disabled)}/*!@:host*/.sc-ix-breadcrumb-item-h{min-width:5rem}/*!@:host*/.sc-ix-breadcrumb-item-h{display:inline-block;height:2rem;vertical-align:middle;cursor:pointer;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:700;line-height:1.429em;color:var(--theme-color-std-text)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::after,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-breadcrumb-item-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-corner{display:none}/*!@:host button*/.sc-ix-breadcrumb-item-h button.sc-ix-breadcrumb-item{all:unset;box-sizing:border-box;display:inline-flex;flex-direction:row;flex-wrap:nowrap;overflow:hidden;align-items:center;justify-content:center;width:100%;height:100%;padding:0 0.5rem}/*!@:host ix-spinner*/.sc-ix-breadcrumb-item-h ix-spinner.sc-ix-breadcrumb-item{margin-right:0.25rem}/*!@:host ix-icon*/.sc-ix-breadcrumb-item-h ix-icon.sc-ix-breadcrumb-item{margin-right:0.25rem}/*!@:host .content*/.sc-ix-breadcrumb-item-h .content.sc-ix-breadcrumb-item{display:inline-block;position:relative;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}/*!@:host .content-start*/.sc-ix-breadcrumb-item-h .content-start.sc-ix-breadcrumb-item{width:100%}/*!@:host .icon*/.sc-ix-breadcrumb-item-h .icon.sc-ix-breadcrumb-item{pointer-events:none}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{cursor:default}/*!@:host .btn-primary*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-primary, :host .btn-primary.focus, :host .btn-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-primary--background);color:var(--theme-btn-primary--color);--ix-button-color:var(--theme-btn-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-primary--border-color);border-style:solid}/*!@:host .btn-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-primary.selected*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):active, :host .btn-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):hover, :host .btn-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-primary--border-color--hover);background-color:var(--theme-btn-primary--background--hover);color:var(--theme-btn-primary--color--hover)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):active, :host .btn-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-primary--border-color--active);background-color:var(--theme-btn-primary--background--active);color:var(--theme-btn-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-primary.disabled, :host(.disabled) .btn-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-primary--border-color--disabled);background-color:var(--theme-btn-primary--background--disabled);color:var(--theme-btn-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-primary--color--disabled)}/*!@:host .btn-outline-primary*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-primary, :host .btn-outline-primary.focus, :host .btn-outline-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-outline-primary--background);color:var(--theme-btn-outline-primary--color);--ix-button-color:var(--theme-btn-outline-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-primary--border-color);border-style:solid}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-primary.selected*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):hover, :host .btn-outline-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-primary--border-color--hover);background-color:var(--theme-btn-outline-primary--background--hover);color:var(--theme-btn-outline-primary--color--hover)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):active, :host .btn-outline-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-primary--border-color--active);background-color:var(--theme-btn-outline-primary--background--active);color:var(--theme-btn-outline-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-primary.disabled, :host(.disabled) .btn-outline-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-outline-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-outline-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-outline-primary--border-color--disabled);background-color:var(--theme-btn-outline-primary--background--disabled);color:var(--theme-btn-outline-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-primary--color--disabled)}/*!@:host .btn-invisible-primary*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-primary, :host .btn-invisible-primary.focus, :host .btn-invisible-primary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-primary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-invisible-primary--background);color:var(--theme-btn-invisible-primary--color);--ix-button-color:var(--theme-btn-invisible-primary--color);border-color:transparent}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-primary.selected*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-primary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-primary--background--hover);color:var(--theme-btn-invisible-primary--color--hover)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):active, :host .btn-invisible-primary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-primary--background--active);color:var(--theme-btn-invisible-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-primary.disabled, :host(.disabled) .btn-invisible-primary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-invisible-primary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-invisible-primary.sc-ix-breadcrumb-item:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-primary--background--disabled);color:var(--theme-btn-invisible-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-primary--color--disabled)}/*!@:host .btn-secondary*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-secondary, :host .btn-secondary.focus, :host .btn-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-secondary--background);color:var(--theme-btn-secondary--color);--ix-button-color:var(--theme-btn-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-secondary--border-color);border-style:solid}/*!@:host .btn-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):hover, :host .btn-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-secondary--border-color--hover);background-color:var(--theme-btn-secondary--background--hover);color:var(--theme-btn-secondary--color--hover)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):active, :host .btn-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-secondary--border-color--active);background-color:var(--theme-btn-secondary--background--active);color:var(--theme-btn-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-secondary.disabled, :host(.disabled) .btn-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-secondary--border-color--disabled);background-color:var(--theme-btn-secondary--background--disabled);color:var(--theme-btn-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-secondary--color--disabled)}/*!@:host .btn-outline-secondary*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-secondary, :host .btn-outline-secondary.focus, :host .btn-outline-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-outline-secondary--background);color:var(--theme-btn-outline-secondary--color);--ix-button-color:var(--theme-btn-outline-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-secondary--border-color);border-style:solid}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-secondary--border-color--hover);background-color:var(--theme-btn-outline-secondary--background--hover);color:var(--theme-btn-outline-secondary--color--hover)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):active, :host .btn-outline-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-secondary--border-color--active);background-color:var(--theme-btn-outline-secondary--background--active);color:var(--theme-btn-outline-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-secondary.disabled, :host(.disabled) .btn-outline-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-outline-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-outline-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;border-color:var(--theme-btn-outline-secondary--border-color--disabled);background-color:var(--theme-btn-outline-secondary--background--disabled);color:var(--theme-btn-outline-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-secondary--color--disabled)}/*!@:host .btn-invisible-secondary*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-secondary, :host .btn-invisible-secondary.focus, :host .btn-invisible-secondary:focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.focus.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:focus-visible{background-color:var(--theme-btn-invisible-secondary--background);color:var(--theme-btn-invisible-secondary--color);--ix-button-color:var(--theme-btn-invisible-secondary--color);border-color:transparent}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-secondary.selected*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.selected.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-secondary--background--hover);color:var(--theme-btn-invisible-secondary--color--hover)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary:not(.disabled):not(:disabled).active*/.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled):active,.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-secondary--background--active);color:var(--theme-btn-invisible-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-breadcrumb-item-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-secondary.disabled, :host(.disabled) .btn-invisible-secondary:disabled*/.disabled.sc-ix-breadcrumb-item-h .btn-invisible-secondary.disabled.sc-ix-breadcrumb-item,.disabled.sc-ix-breadcrumb-item-h .btn-invisible-secondary.sc-ix-breadcrumb-item:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-secondary--background--disabled);color:var(--theme-btn-invisible-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-secondary--color--disabled)}/*!@:host*/.sc-ix-breadcrumb-item-h{display:flex;position:relative;flex-direction:row;flex-wrap:nowrap;align-items:center;margin-right:0.25rem;max-width:15rem;min-width:0}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::after,.sc-ix-breadcrumb-item-h *.sc-ix-breadcrumb-item::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-breadcrumb-item-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item::-webkit-scrollbar-corner{display:none}/*!@:host li*/.sc-ix-breadcrumb-item-h li.sc-ix-breadcrumb-item{display:contents}/*!@:host .btn*/.sc-ix-breadcrumb-item-h .btn.sc-ix-breadcrumb-item{pointer-events:all;width:-moz-fit-content;width:fit-content;padding-right:0;padding-left:0.25rem}/*!@:host .chevron*/.sc-ix-breadcrumb-item-h .chevron.sc-ix-breadcrumb-item{pointer-events:none;margin-left:0.5rem;margin-right:0rem;color:var(--theme-color-soft-text)}/*!@:host ::slotted(a[href])*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item-s>a[href]{text-decoration:none !important}/*!@:host ::slotted(a[href]:active)*/.sc-ix-breadcrumb-item-h .sc-ix-breadcrumb-item-s>a[href]:active{text-decoration:none !important}/*!@:host(:last-child) .btn:not(.dropdown-trigger)*/.sc-ix-breadcrumb-item-h:last-child .btn.sc-ix-breadcrumb-item:not(.dropdown-trigger){color:var(--theme-color-soft-text)}/*!@:host(.hide-chevron)*/.hide-chevron.sc-ix-breadcrumb-item-h{cursor:default}/*!@:host(.hide-chevron) .btn*/.hide-chevron.sc-ix-breadcrumb-item-h .btn.sc-ix-breadcrumb-item{padding-right:0.5rem;pointer-events:none}/*!@:host(.invisible)*/.invisible.sc-ix-breadcrumb-item-h{display:none}/*!@:host(:focus-visible)*/.sc-ix-breadcrumb-item-h:focus-visible{outline:none}";
var IxBreadcrumbItemStyle0 = breadcrumbItemCss;

class BreadcrumbItem {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.itemClick = createEvent(this, "itemClick", 7);
        this.label = undefined;
        this.icon = undefined;
        this.ghost = true;
        this.visible = true;
        this.showChevron = true;
        this.isDropdownTrigger = false;
        this.a11y = undefined;
    }
    componentDidLoad() {
        this.animationFadeIn();
    }
    componentWillLoad() {
        this.a11y = a11yHostAttributes(this.hostElement, [
            'aria-describedby',
            'aria-controls',
            'aria-expanded',
        ]);
    }
    animationFadeIn() {
        anime({
            targets: this.hostElement,
            duration: 150,
            opacity: [0, 1],
            translateX: ['-100%', '0%'],
            easing: 'linear',
        });
    }
    render() {
        const props = {
            variant: this.ghost ? 'primary' : 'secondary',
            outline: false,
            ghost: this.ghost,
            iconOnly: false,
            iconOval: false,
            disabled: false,
            icon: this.icon,
            iconSize: '16',
            loading: false,
            selected: false,
            type: 'button',
            tabIndex: this.hostElement.tabIndex !== -1 ? this.hostElement.tabIndex : 0,
            extraClasses: {
                'dropdown-trigger': this.isDropdownTrigger,
            },
            ariaAttributes: this.a11y,
        };
        if (!this.visible) {
            return hAsync(Host, { class: 'invisible' });
        }
        return (hAsync(Host, { class: {
                'hide-chevron': !this.showChevron,
            }, onClick: () => this.itemClick.emit(this.label) }, hAsync("li", null, hAsync(BaseButton, Object.assign({}, props, { afterContent: hAsync(Fragment, null, this.showChevron ? (hAsync("ix-icon", { name: 'chevron-right-small', size: "16", class: 'chevron' })) : null) }), this.label, hAsync("slot", null)))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxBreadcrumbItemStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-breadcrumb-item",
        "$members$": {
            "label": [1],
            "icon": [1],
            "ghost": [4],
            "visible": [4],
            "showChevron": [4, "show-chevron"],
            "isDropdownTrigger": [4, "is-dropdown-trigger"],
            "a11y": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const buttonCss = "/*!@:host*/.sc-ix-button-h{display:inline-block;height:2rem;vertical-align:middle;cursor:pointer;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:700;line-height:1.429em;color:var(--theme-color-std-text)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-button-h *.sc-ix-button,.sc-ix-button-h *.sc-ix-button::after,.sc-ix-button-h *.sc-ix-button::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-button-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-button-h .sc-ix-button::-webkit-scrollbar-corner{display:none}/*!@:host button*/.sc-ix-button-h button.sc-ix-button{all:unset;box-sizing:border-box;display:inline-flex;flex-direction:row;flex-wrap:nowrap;overflow:hidden;align-items:center;justify-content:center;width:100%;height:100%;padding:0 0.5rem}/*!@:host ix-spinner*/.sc-ix-button-h ix-spinner.sc-ix-button{margin-right:0.25rem}/*!@:host ix-icon*/.sc-ix-button-h ix-icon.sc-ix-button{margin-right:0.25rem}/*!@:host .content*/.sc-ix-button-h .content.sc-ix-button{display:inline-block;position:relative;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}/*!@:host .content-start*/.sc-ix-button-h .content-start.sc-ix-button{width:100%}/*!@:host .icon*/.sc-ix-button-h .icon.sc-ix-button{pointer-events:none}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{cursor:default}/*!@:host .btn-danger*/.sc-ix-button-h .btn-danger.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-danger, :host .btn-danger.focus, :host .btn-danger:focus-visible*/.sc-ix-button-h .btn-danger.sc-ix-button,.sc-ix-button-h .btn-danger.focus.sc-ix-button,.sc-ix-button-h .btn-danger.sc-ix-button:focus-visible{background-color:var(--theme-btn-danger--background);color:var(--theme-btn-danger--color);--ix-button-color:var(--theme-btn-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-danger--border-color);border-style:solid}/*!@:host .btn-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-danger.selected*/.sc-ix-button-h .btn-danger.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-danger.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):active, :host .btn-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-danger.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-danger.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):hover, :host .btn-danger:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-danger--border-color--hover);background-color:var(--theme-btn-danger--background--hover);color:var(--theme-btn-danger--color--hover)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):active, :host .btn-danger:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-danger.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-danger--border-color--active);background-color:var(--theme-btn-danger--background--active);color:var(--theme-btn-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-danger.disabled, :host(.disabled) .btn-danger:disabled*/.disabled.sc-ix-button-h .btn-danger.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-danger.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-danger--border-color--disabled);background-color:var(--theme-btn-danger--background--disabled);color:var(--theme-btn-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-danger--color--disabled)}/*!@:host .btn-outline-danger*/.sc-ix-button-h .btn-outline-danger.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-danger, :host .btn-outline-danger.focus, :host .btn-outline-danger:focus-visible*/.sc-ix-button-h .btn-outline-danger.sc-ix-button,.sc-ix-button-h .btn-outline-danger.focus.sc-ix-button,.sc-ix-button-h .btn-outline-danger.sc-ix-button:focus-visible{background-color:var(--theme-btn-outline-danger--background);color:var(--theme-btn-outline-danger--color);--ix-button-color:var(--theme-btn-outline-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-danger--border-color);border-style:solid}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-danger.selected*/.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):active, :host .btn-outline-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-danger.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):hover, :host .btn-outline-danger:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-danger--border-color--hover);background-color:var(--theme-btn-outline-danger--background--hover);color:var(--theme-btn-outline-danger--color--hover)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):active, :host .btn-outline-danger:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-danger.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-danger--border-color--active);background-color:var(--theme-btn-outline-danger--background--active);color:var(--theme-btn-outline-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-danger.disabled, :host(.disabled) .btn-outline-danger:disabled*/.disabled.sc-ix-button-h .btn-outline-danger.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-outline-danger.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-outline-danger--border-color--disabled);background-color:var(--theme-btn-outline-danger--background--disabled);color:var(--theme-btn-outline-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-danger--color--disabled)}/*!@:host .btn-invisible-danger*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-danger, :host .btn-invisible-danger.focus, :host .btn-invisible-danger:focus-visible*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button,.sc-ix-button-h .btn-invisible-danger.focus.sc-ix-button,.sc-ix-button-h .btn-invisible-danger.sc-ix-button:focus-visible{background-color:var(--theme-btn-invisible-danger--background);color:var(--theme-btn-invisible-danger--color);--ix-button-color:var(--theme-btn-invisible-danger--color);border-color:transparent}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-danger.selected*/.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-danger.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-danger--background--hover);color:var(--theme-btn-invisible-danger--color--hover)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):active, :host .btn-invisible-danger:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-danger.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-danger--background--active);color:var(--theme-btn-invisible-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-danger.disabled, :host(.disabled) .btn-invisible-danger:disabled*/.disabled.sc-ix-button-h .btn-invisible-danger.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-invisible-danger.sc-ix-button:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-danger--background--disabled);color:var(--theme-btn-invisible-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-danger--color--disabled)}/*!@:host .btn-primary*/.sc-ix-button-h .btn-primary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-primary, :host .btn-primary.focus, :host .btn-primary:focus-visible*/.sc-ix-button-h .btn-primary.sc-ix-button,.sc-ix-button-h .btn-primary.focus.sc-ix-button,.sc-ix-button-h .btn-primary.sc-ix-button:focus-visible{background-color:var(--theme-btn-primary--background);color:var(--theme-btn-primary--color);--ix-button-color:var(--theme-btn-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-primary--border-color);border-style:solid}/*!@:host .btn-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-primary.selected*/.sc-ix-button-h .btn-primary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-primary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):active, :host .btn-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-primary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-primary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):hover, :host .btn-primary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-primary--border-color--hover);background-color:var(--theme-btn-primary--background--hover);color:var(--theme-btn-primary--color--hover)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):active, :host .btn-primary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-primary.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-primary--border-color--active);background-color:var(--theme-btn-primary--background--active);color:var(--theme-btn-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-primary.disabled, :host(.disabled) .btn-primary:disabled*/.disabled.sc-ix-button-h .btn-primary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-primary.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-primary--border-color--disabled);background-color:var(--theme-btn-primary--background--disabled);color:var(--theme-btn-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-primary--color--disabled)}/*!@:host .btn-outline-primary*/.sc-ix-button-h .btn-outline-primary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-primary, :host .btn-outline-primary.focus, :host .btn-outline-primary:focus-visible*/.sc-ix-button-h .btn-outline-primary.sc-ix-button,.sc-ix-button-h .btn-outline-primary.focus.sc-ix-button,.sc-ix-button-h .btn-outline-primary.sc-ix-button:focus-visible{background-color:var(--theme-btn-outline-primary--background);color:var(--theme-btn-outline-primary--color);--ix-button-color:var(--theme-btn-outline-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-primary--border-color);border-style:solid}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-primary.selected*/.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-primary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):hover, :host .btn-outline-primary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-primary--border-color--hover);background-color:var(--theme-btn-outline-primary--background--hover);color:var(--theme-btn-outline-primary--color--hover)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):active, :host .btn-outline-primary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-primary.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-primary--border-color--active);background-color:var(--theme-btn-outline-primary--background--active);color:var(--theme-btn-outline-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-primary.disabled, :host(.disabled) .btn-outline-primary:disabled*/.disabled.sc-ix-button-h .btn-outline-primary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-outline-primary.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-outline-primary--border-color--disabled);background-color:var(--theme-btn-outline-primary--background--disabled);color:var(--theme-btn-outline-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-primary--color--disabled)}/*!@:host .btn-invisible-primary*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-primary, :host .btn-invisible-primary.focus, :host .btn-invisible-primary:focus-visible*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button,.sc-ix-button-h .btn-invisible-primary.focus.sc-ix-button,.sc-ix-button-h .btn-invisible-primary.sc-ix-button:focus-visible{background-color:var(--theme-btn-invisible-primary--background);color:var(--theme-btn-invisible-primary--color);--ix-button-color:var(--theme-btn-invisible-primary--color);border-color:transparent}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-primary.selected*/.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-primary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-primary--background--hover);color:var(--theme-btn-invisible-primary--color--hover)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):active, :host .btn-invisible-primary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-primary.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-primary--background--active);color:var(--theme-btn-invisible-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-primary.disabled, :host(.disabled) .btn-invisible-primary:disabled*/.disabled.sc-ix-button-h .btn-invisible-primary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-invisible-primary.sc-ix-button:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-primary--background--disabled);color:var(--theme-btn-invisible-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-primary--color--disabled)}/*!@:host .btn-secondary*/.sc-ix-button-h .btn-secondary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-secondary, :host .btn-secondary.focus, :host .btn-secondary:focus-visible*/.sc-ix-button-h .btn-secondary.sc-ix-button,.sc-ix-button-h .btn-secondary.focus.sc-ix-button,.sc-ix-button-h .btn-secondary.sc-ix-button:focus-visible{background-color:var(--theme-btn-secondary--background);color:var(--theme-btn-secondary--color);--ix-button-color:var(--theme-btn-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-secondary--border-color);border-style:solid}/*!@:host .btn-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-secondary.selected*/.sc-ix-button-h .btn-secondary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-secondary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):hover, :host .btn-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-secondary--border-color--hover);background-color:var(--theme-btn-secondary--background--hover);color:var(--theme-btn-secondary--color--hover)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):active, :host .btn-secondary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-secondary.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-secondary--border-color--active);background-color:var(--theme-btn-secondary--background--active);color:var(--theme-btn-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-secondary.disabled, :host(.disabled) .btn-secondary:disabled*/.disabled.sc-ix-button-h .btn-secondary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-secondary.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-secondary--border-color--disabled);background-color:var(--theme-btn-secondary--background--disabled);color:var(--theme-btn-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-secondary--color--disabled)}/*!@:host .btn-outline-secondary*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-secondary, :host .btn-outline-secondary.focus, :host .btn-outline-secondary:focus-visible*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button,.sc-ix-button-h .btn-outline-secondary.focus.sc-ix-button,.sc-ix-button-h .btn-outline-secondary.sc-ix-button:focus-visible{background-color:var(--theme-btn-outline-secondary--background);color:var(--theme-btn-outline-secondary--color);--ix-button-color:var(--theme-btn-outline-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-secondary--border-color);border-style:solid}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-secondary.selected*/.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-secondary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-secondary--border-color--hover);background-color:var(--theme-btn-outline-secondary--background--hover);color:var(--theme-btn-outline-secondary--color--hover)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):active, :host .btn-outline-secondary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-outline-secondary.sc-ix-button:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-secondary--border-color--active);background-color:var(--theme-btn-outline-secondary--background--active);color:var(--theme-btn-outline-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-secondary.disabled, :host(.disabled) .btn-outline-secondary:disabled*/.disabled.sc-ix-button-h .btn-outline-secondary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-outline-secondary.sc-ix-button:disabled{pointer-events:none;border-color:var(--theme-btn-outline-secondary--border-color--disabled);background-color:var(--theme-btn-outline-secondary--background--disabled);color:var(--theme-btn-outline-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-secondary--color--disabled)}/*!@:host .btn-invisible-secondary*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-secondary, :host .btn-invisible-secondary.focus, :host .btn-invisible-secondary:focus-visible*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button,.sc-ix-button-h .btn-invisible-secondary.focus.sc-ix-button,.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:focus-visible{background-color:var(--theme-btn-invisible-secondary--background);color:var(--theme-btn-invisible-secondary--color);--ix-button-color:var(--theme-btn-invisible-secondary--color);border-color:transparent}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-secondary.selected*/.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-secondary.selected.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-secondary--background--hover);color:var(--theme-btn-invisible-secondary--color--hover)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary:not(.disabled):not(:disabled).active*/.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled):active,.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-secondary--background--active);color:var(--theme-btn-invisible-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-button-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-secondary.disabled, :host(.disabled) .btn-invisible-secondary:disabled*/.disabled.sc-ix-button-h .btn-invisible-secondary.disabled.sc-ix-button,.disabled.sc-ix-button-h .btn-invisible-secondary.sc-ix-button:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-secondary--background--disabled);color:var(--theme-btn-invisible-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-secondary--color--disabled)}/*!@:host*/.sc-ix-button-h{min-width:5rem}";
var IxButtonStyle0 = buttonCss;

class Button {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.variant = 'primary';
        this.outline = false;
        this.ghost = false;
        this.disabled = false;
        this.type = 'button';
        this.loading = false;
        this.icon = undefined;
        this.alignment = 'center';
        this.iconSize = '24';
    }
    componentDidLoad() {
        if (this.type === 'submit') {
            const submitButton = document.createElement('button');
            submitButton.style.display = 'none';
            submitButton.type = 'submit';
            submitButton.tabIndex = -1;
            this.hostElement.appendChild(submitButton);
            this.submitButtonElement = submitButton;
        }
    }
    dispatchFormEvents() {
        if (this.type === 'submit' && this.submitButtonElement) {
            this.submitButtonElement.click();
        }
    }
    render() {
        const baseButtonProps = {
            variant: this.variant,
            outline: this.outline,
            ghost: this.ghost,
            iconOnly: false,
            iconOval: false,
            selected: false,
            disabled: this.disabled || this.loading,
            icon: this.icon,
            iconSize: this.iconSize,
            loading: this.loading,
            onClick: () => this.dispatchFormEvents(),
            type: this.type,
            alignment: this.alignment,
        };
        return (hAsync(Host, { key: '53b79830d21440398dc1bf7962ae64fc88267171', class: {
                disabled: this.disabled || this.loading,
            } }, hAsync(BaseButton, Object.assign({ key: '8eba954b9c315252ced06a308d6676322b031b90' }, baseButtonProps), hAsync("slot", { key: 'c98df3af0d34f6e2ce4ecce03916b39d4b69d4a7' }))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxButtonStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-button",
        "$members$": {
            "variant": [1],
            "outline": [4],
            "ghost": [4],
            "disabled": [516],
            "type": [1],
            "loading": [4],
            "icon": [1],
            "alignment": [1],
            "iconSize": [1, "icon-size"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["disabled", "disabled"]]
    }; }
}

const cardCss = "/*!@:host*/.sc-ix-card-h{display:flex;position:relative;flex-direction:column;align-items:flex-start;align-self:flex-start;overflow:hidden;width:20rem;border:1px solid var(--ix-card-border-color, var(--theme-color-soft-bdr));border-radius:var(--theme-default-border-radius)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-card-h *.sc-ix-card,.sc-ix-card-h *.sc-ix-card::after,.sc-ix-card-h *.sc-ix-card::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-card-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-card-h .sc-ix-card::-webkit-scrollbar-corner{display:none}/*!@:host .card-content*/.sc-ix-card-h .card-content.sc-ix-card{display:block;position:relative;flex-shrink:0;flex-grow:1;width:100%;height:calc(100% - 2rem);background-color:var(--ix-card-background, transparent);border-top-left-radius:var(--theme-default-border-radius);border-top-right-radius:var(--theme-default-border-radius)}/*!@:host .card-footer*/.sc-ix-card-h .card-footer.sc-ix-card{display:flex;position:relative;width:100%}/*!@:host(.card-insight), :host(.card-outline)*/.card-insight.sc-ix-card-h,.card-outline.sc-ix-card-h{--ix-card-background:transparent;--ix-card-border-color:var(--theme-color-soft-bdr)}/*!@:host(.card-notification), :host(.card-filled)*/.card-notification.sc-ix-card-h,.card-filled.sc-ix-card-h{--ix-card-background:var(--theme-color-component-1)}/*!@:host(.card-alarm)*/.card-alarm.sc-ix-card-h{--ix-card-background:var(--theme-color-alarm);color:var(--theme-color-alarm--contrast)}/*!@:host(.card-critical)*/.card-critical.sc-ix-card-h{--ix-card-background:var(--theme-color-critical);color:var(--theme-color-critical--contrast)}/*!@:host(.card-warning)*/.card-warning.sc-ix-card-h{--ix-card-background:var(--theme-color-warning);color:var(--theme-color-warning--contrast)}/*!@:host(.card-success)*/.card-success.sc-ix-card-h{--ix-card-background:var(--theme-color-success);color:var(--theme-color-success--contrast)}/*!@:host(.card-info)*/.card-info.sc-ix-card-h{--ix-card-background:var(--theme-color-info);color:var(--theme-color-info--contrast)}/*!@:host(.card-neutral)*/.card-neutral.sc-ix-card-h{--ix-card-background:var(--theme-color-neutral);color:var(--theme-color-neutral--contrast)}/*!@:host(.card-primary)*/.card-primary.sc-ix-card-h{--ix-card-background:var(--theme-color-primary);color:var(--theme-color-neutral--contrast)}/*!@:host(:not(.card-insight))*/.sc-ix-card-h:not(.card-insight){--ix-card-border-color:transparent}/*!@:host(.card-insight:hover)*/.card-insight.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-ghost--hover)}/*!@:host(.card-notification:hover)*/.card-notification.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-component-1--hover)}/*!@:host(.card-alarm:hover)*/.card-alarm.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-alarm--hover)}/*!@:host(.card-critical:hover)*/.card-critical.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-critical--hover)}/*!@:host(.card-warning:hover)*/.card-warning.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-warning--hover)}/*!@:host(.card-success:hover)*/.card-success.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-success--hover)}/*!@:host(.card-info:hover)*/.card-info.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-info--hover)}/*!@:host(.card-neutral:hover)*/.card-neutral.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-neutral--hover)}/*!@:host(.card-primary:hover)*/.card-primary.sc-ix-card-h:hover{--ix-card-background:var(--theme-color-primary--hover)}/*!@:host(.card-insight:active)*/.card-insight.sc-ix-card-h:active{--ix-card-background:var(--theme-color-ghost--active)}/*!@:host(.card-notification:active)*/.card-notification.sc-ix-card-h:active{--ix-card-background:var(--theme-color-component-1--active)}/*!@:host(.card-alarm:active)*/.card-alarm.sc-ix-card-h:active{--ix-card-background:var(--theme-color-alarm--active)}/*!@:host(.card-critical:active)*/.card-critical.sc-ix-card-h:active{--ix-card-background:var(--theme-color-critical--active)}/*!@:host(.card-warning:active)*/.card-warning.sc-ix-card-h:active{--ix-card-background:var(--theme-color-warning--active)}/*!@:host(.card-success:active)*/.card-success.sc-ix-card-h:active{--ix-card-background:var(--theme-color-success--active)}/*!@:host(.card-info:active)*/.card-info.sc-ix-card-h:active{--ix-card-background:var(--theme-color-info--active)}/*!@:host(.card-neutral:active)*/.card-neutral.sc-ix-card-h:active{--ix-card-background:var(--theme-color-neutral--active)}/*!@:host(.card-primary:active)*/.card-primary.sc-ix-card-h:active{--ix-card-background:var(--theme-color-primary--active)}/*!@:host(.selected)*/.selected.sc-ix-card-h{--ix-card-border-color:var(--theme-color-dynamic)}/*!@:host(.selected.card-insight)*/.selected.card-insight.sc-ix-card-h{--ix-card-background:var(--theme-color-ghost--selected)}/*!@:host(.selected.card-notification)*/.selected.card-notification.sc-ix-card-h{--ix-card-background:var(--theme-color-ghost--selected)}/*!@:host(.selected.card-alarm)*/.selected.card-alarm.sc-ix-card-h{--ix-card-background:var(--theme-color-alarm--active)}/*!@:host(.selected.card-critical)*/.selected.card-critical.sc-ix-card-h{--ix-card-background:var(--theme-color-critical--active)}/*!@:host(.selected.card-warning)*/.selected.card-warning.sc-ix-card-h{--ix-card-background:var(--theme-color-warning--active)}/*!@:host(.selected.card-success)*/.selected.card-success.sc-ix-card-h{--ix-card-background:var(--theme-color-success--active)}/*!@:host(.selected.card-info)*/.selected.card-info.sc-ix-card-h{--ix-card-background:var(--theme-color-info--active)}/*!@:host(.selected.card-neutral)*/.selected.card-neutral.sc-ix-card-h{--ix-card-background:var(--theme-color-neutral--active)}/*!@:host(.selected.card-primary)*/.selected.card-primary.sc-ix-card-h{--ix-card-background:var(--theme-color-primary--active)}";
var IxCardStyle0 = cardCss;

/**
 * @since 1.6.0
 */
class Card {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.variant = 'insight';
        this.selected = undefined;
    }
    render() {
        return (hAsync(Host, { key: '4d096be9c3db2847204633f22624296d892e2fb9', class: {
                selected: this.selected,
                [`card-${this.variant}`]: true,
            } }, hAsync("div", { key: 'e80707eb333158ac4f90fa0feaaede7309fa3567', class: "card-content" }, hAsync("slot", { key: '50b6d4885936ff438c4fcab7c7b1b9d5e54137f3' })), hAsync("div", { key: 'c964e703c4c7783fd30a889838583d8e0426994b', class: "card-footer" }, hAsync("slot", { key: 'df4b7c7e9f8fbdea42c2e9b657dc6e4488ea4562', name: "card-accordion" }))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxCardStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-card",
        "$members$": {
            "variant": [1],
            "selected": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const cardAccordionCss = "/*!@:host*/.sc-ix-card-accordion-h{display:flex;position:relative;flex-direction:column;width:100%;transition:var(--theme-default-time) ease-in-out}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-card-accordion-h *.sc-ix-card-accordion,.sc-ix-card-accordion-h *.sc-ix-card-accordion::after,.sc-ix-card-accordion-h *.sc-ix-card-accordion::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-card-accordion-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-card-accordion-h .sc-ix-card-accordion::-webkit-scrollbar-corner{display:none}/*!@:host .expand-action*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion{all:unset;display:flex;position:relative;-webkit-appearance:button;-moz-appearance:button;appearance:button;height:2.5rem;width:100%;background-color:var(--theme-color-component-1);align-items:center;justify-content:flex-start}/*!@:host .expand-action:hover*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion:hover{background:var(--theme-color-component-1--hover)}/*!@:host .expand-action:active*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion:active{background:var(--theme-color-component-1--active)}/*!@:host .expand-action:not(.disabled):not(:disabled):focus-visible*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .expand-action::before*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion::before{content:\"\";position:absolute;width:100%;height:100%;background-color:var(--ix-card-background);z-index:-1}/*!@:host .expand-action:not(.show),\n:host .expand-action:not(.show)::before*/.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion:not(.show),.sc-ix-card-accordion-h .expand-action.sc-ix-card-accordion:not(.show)::before{border-bottom-left-radius:var(--theme-default-border-radius);border-bottom-right-radius:var(--theme-default-border-radius)}/*!@:host .expand-icon*/.sc-ix-card-accordion-h .expand-icon.sc-ix-card-accordion{margin-left:0.5rem;transition:var(--theme-default-time) transform ease-in-out}/*!@:host .expand-icon.show*/.sc-ix-card-accordion-h .expand-icon.show.sc-ix-card-accordion{transform:rotate(90deg)}/*!@:host .expand-content*/.sc-ix-card-accordion-h .expand-content.sc-ix-card-accordion{display:grid;position:relative;grid-template-rows:0fr;transition:var(--theme-default-time) ease-in-out;width:100%;max-height:14.75rem;opacity:0;background-color:var(--theme-color-component-1)}/*!@:host .expand-content.show*/.sc-ix-card-accordion-h .expand-content.show.sc-ix-card-accordion{grid-template-rows:14.75rem;opacity:1}/*!@:host .expand-content-inner*/.sc-ix-card-accordion-h .expand-content-inner.sc-ix-card-accordion{position:relative;height:100%;overflow:hidden}/*!@:host .expand-content.show .expand-content-body*/.sc-ix-card-accordion-h .expand-content.show.sc-ix-card-accordion .expand-content-body.sc-ix-card-accordion{display:none;overflow:hidden;color:var(--theme-color-std-text)}/*!@:host .expand-content.show .expand-content-body*/.sc-ix-card-accordion-h .expand-content.show.sc-ix-card-accordion .expand-content-body.sc-ix-card-accordion{display:block;overflow:auto;height:calc(100% - 1rem)}/*!@:host .expand-content-footer*/.sc-ix-card-accordion-h .expand-content-footer.sc-ix-card-accordion{display:block;position:relative;width:100%;height:1rem;margin-top:auto;margin-bottom:0px;background-color:var(--theme-color-component-1);border-bottom-left-radius:var(--theme-default-border-radius);border-bottom-right-radius:var(--theme-default-border-radius)}";
var IxCardAccordionStyle0 = cardAccordionCss;

let accordionControlId = 0;
const getAriaControlsId = (prefix = 'expand-content') => {
    return [prefix, accordionControlId++].join('-');
};
/**
 * @since 1.6.0
 */
class CardAccordion {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.accordionExpand = createEvent(this, "accordionExpand", 7);
        this.collapse = false;
        this.expandContent = false;
    }
    onInitialExpandChange() {
        this.expandContent = !this.collapse;
    }
    get expandedContent() {
        return this.hostElement.shadowRoot.querySelector('.expand-content');
    }
    onExpandActionClick(event) {
        event.preventDefault();
        event.stopPropagation();
        this.expandContent = !this.expandContent;
        this.accordionExpand.emit({
            expand: this.expandContent,
            nativeEvent: event,
        });
        if (this.expandContent) {
            this.scrollExpandedContentIntoView();
        }
    }
    scrollExpandedContentIntoView() {
        setTimeout(() => {
            const rect = this.expandedContent.getBoundingClientRect();
            if (rect.bottom > window.innerHeight) {
                this.hostElement.shadowRoot
                    .querySelector('.expand-content')
                    .scrollIntoView(false);
            }
        }, 150);
    }
    componentWillLoad() {
        this.onInitialExpandChange();
    }
    render() {
        return (hAsync(Host, { key: 'bc39054c9b50f4a1de3ebb720553d667f30e7420', slot: "card-accordion" }, hAsync("button", { key: '39a8f4b977ca5d4f797a12f4d06a09e7a2909e80', tabIndex: 0, class: { 'expand-action': true, show: this.expandContent }, onClick: (event) => this.onExpandActionClick(event), role: "button", type: "button", "aria-expanded": this.expandContent, "aria-controls": getAriaControlsId() }, hAsync("ix-icon", { key: '2d75d5fc08d4d79e1d70fef36440dba4ee5b62c9', name: 'chevron-right-small', class: {
                'expand-icon': true,
                show: this.expandContent,
            } })), hAsync("div", { key: 'd2b662f006a69d90e2353922e377a1e83830de70', class: {
                'expand-content': true,
                show: this.expandContent,
            } }, hAsync("div", { key: '7cedf82588afb804a626b1ba1c1cb9147c76306a', class: "expand-content-inner" }, hAsync("div", { key: '04b85a19f6354fd725b634748e7ff7a5c58dd7cb', class: "expand-content-body" }, hAsync("slot", { key: '732c33dbaa591432e14f74eb305b7e7c526d4e49' })), hAsync("div", { key: '83291f55a13f8a8bebddb4d24c81cfc1a090f1f4', class: "expand-content-footer" })))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "collapse": ["onInitialExpandChange"]
    }; }
    static get style() { return IxCardAccordionStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-card-accordion",
        "$members$": {
            "collapse": [4],
            "expandContent": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const cardContentCss = "/*!@:host*/.sc-ix-card-content-h{display:flex;position:relative;flex-direction:column;align-items:flex-start;gap:0.5rem;padding:1rem;height:100%}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-card-content-h *.sc-ix-card-content,.sc-ix-card-content-h *.sc-ix-card-content::after,.sc-ix-card-content-h *.sc-ix-card-content::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-card-content-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-card-content-h .sc-ix-card-content::-webkit-scrollbar-corner{display:none}";
var IxCardContentStyle0 = cardContentCss;

/**
 * @since 1.6.0
 */
class CardContent {
    constructor(hostRef) {
        registerInstance(this, hostRef);
    }
    render() {
        return (hAsync(Host, { key: '816fee4fedc0535d0a8991bf6a58a97fecd27069' }, hAsync("slot", { key: '136f2bfa5fd08ff95aa0d3f7a2bed5297aaf57e5' })));
    }
    static get style() { return IxCardContentStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-card-content",
        "$members$": undefined,
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const cardTitleCss = "/*!@:host*/.sc-ix-card-title-h{display:flex;position:relative;flex-direction:row;align-items:center;margin-top:0.25rem;margin-bottom:0.5rem;gap:1rem;width:100%}/*!@:host .title-actions*/.sc-ix-card-title-h .title-actions.sc-ix-card-title{display:flex;position:relative;flex-direction:row;gap:0.25rem;margin-left:auto;margin-right:0px}";
var IxCardTitleStyle0 = cardTitleCss;

/**
 * @slot title-actions - Place additional actions inside title
 *
 * @since 1.6.0
 */
class CardHeader {
    constructor(hostRef) {
        registerInstance(this, hostRef);
    }
    render() {
        return (hAsync(Host, { key: '6e01cd85f5ad2c48dcdf9d2667fd3dd0e8b1cba8' }, hAsync("slot", { key: '79c247b6f82caaf11fdb99168a007f29ba5b4042' }), hAsync("div", { key: '02fe6d5df2e6431ea830fc3398883ec709ba3e59', class: "title-actions" }, hAsync("slot", { key: '86289b8e1e3eee04d9331788cce835c8796197a3', name: "title-actions" }))));
    }
    static get style() { return IxCardTitleStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-card-title",
        "$members$": undefined,
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const cardListCss = "/*!@:host*/.sc-ix-card-list-h{display:flex;position:relative;flex-direction:column;align-items:flex-start;margin:0.5rem}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-card-list-h *.sc-ix-card-list,.sc-ix-card-list-h *.sc-ix-card-list::after,.sc-ix-card-list-h *.sc-ix-card-list::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-card-list-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-card-list-h .sc-ix-card-list::-webkit-scrollbar-corner{display:none}/*!@:host .CardList_Title*/.sc-ix-card-list-h .CardList_Title.sc-ix-card-list{display:flex;position:relative;height:1.5rem;align-items:center;width:100%;margin-bottom:0.5rem}/*!@:host .CardList_Title__Label*/.sc-ix-card-list-h .CardList_Title__Label.sc-ix-card-list{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}/*!@:host .CardList__Title__Button*/.sc-ix-card-list-h .CardList__Title__Button.sc-ix-card-list{margin-right:1rem;transition:var(--theme-default-time) transform ease-in-out}/*!@:host .CardList__Title__Button__Collapsed*/.sc-ix-card-list-h .CardList__Title__Button__Collapsed.sc-ix-card-list{transform:rotate(-90deg)}/*!@:host .CardList__Title__Show__All*/.sc-ix-card-list-h .CardList__Title__Show__All.sc-ix-card-list{align-self:center;margin-left:auto;margin-right:0px;flex-shrink:0}/*!@:host .CardList__Content*/.sc-ix-card-list-h .CardList__Content.sc-ix-card-list{display:flex;position:relative;height:calc(100% - 1.5rem);width:100%;gap:1.5rem;transition:var(--theme-default-time) ease-in-out;overflow:auto}/*!@:host .CardList__Content__Collapsed*/.sc-ix-card-list-h .CardList__Content__Collapsed.sc-ix-card-list{min-height:0px;max-height:0px;overflow:hidden;opacity:0}/*!@:host .CardList__Style__Flexbox__Scroll*/.sc-ix-card-list-h .CardList__Style__Flexbox__Scroll.sc-ix-card-list{flex-wrap:wrap}/*!@:host .CardList__Style__Infinite__Scroll*/.sc-ix-card-list-h .CardList__Style__Infinite__Scroll.sc-ix-card-list{flex-wrap:nowrap;-ms-overflow-style:none;scrollbar-width:none}/*!@:host .CardList__Style__Infinite__Scroll::-webkit-scrollbar*/.sc-ix-card-list-h .CardList__Style__Infinite__Scroll.sc-ix-card-list::-webkit-scrollbar{display:none}/*!@:host .CardList__Overflow*/.sc-ix-card-list-h .CardList__Overflow.sc-ix-card-list{display:block;position:relative;height:100%;width:100%;pointer-events:all;-webkit-mask-image:var(--ix-card-list-overflow, none);mask-image:var(--ix-card-list-overflow, none)}/*!@:host .Show__All__Card*/.sc-ix-card-list-h .Show__All__Card.sc-ix-card-list{display:flex;position:relative;align-self:flex-start;justify-self:center;max-width:11.25rem;min-width:11.25rem;width:11.25rem;min-height:11.25rem;max-height:11.25rem;height:11.25rem;--ix-card-border-color:var(--theme-color-primary);color:var(--theme-color-primary)}/*!@:host .CardList__Style__Infinite__Scroll .Show__All__Card*/.sc-ix-card-list-h .CardList__Style__Infinite__Scroll.sc-ix-card-list .Show__All__Card.sc-ix-card-list{margin-top:2.375rem}/*!@:host .CardList__Style__Flexbox__Scroll .Show__All__Card*/.sc-ix-card-list-h .CardList__Style__Flexbox__Scroll.sc-ix-card-list .Show__All__Card.sc-ix-card-list{margin-bottom:2.375rem}/*!@:host .Show__All__Card:hover*/.sc-ix-card-list-h .Show__All__Card.sc-ix-card-list:hover{background-color:var(--theme-color-ghost--hover)}/*!@:host .Show__All__Card:active*/.sc-ix-card-list-h .Show__All__Card.sc-ix-card-list:active{background-color:var(--theme-color-ghost--active)}/*!@:host .Show__All__Card__Content*/.sc-ix-card-list-h .Show__All__Card__Content.sc-ix-card-list{display:flex;justify-content:center;align-items:center}/*!@:host .Show__All__Card__Icon*/.sc-ix-card-list-h .Show__All__Card__Icon.sc-ix-card-list{display:flex;position:absolute;height:4rem;width:4rem;justify-content:center;align-items:center}/*!@:host .Show__All__Card__Text*/.sc-ix-card-list-h .Show__All__Card__Text.sc-ix-card-list{margin-bottom:0px;margin-top:auto}";
var IxCardListStyle0 = cardListCss;

function CardListTitle(props) {
    if (props.label === '') {
        return null;
    }
    return (hAsync("div", { class: "CardList_Title" }, hAsync("ix-icon-button", { ghost: true, icon: 'chevron-down', onClick: props.onClick, color: "color-primary", class: {
            CardList__Title__Button: true,
            CardList__Title__Button__Collapsed: props.isCollapsed,
        } }), hAsync("ix-typography", { class: "CardList_Title__Label", variant: "large-single" }, props.label), !props.hideShowAll && (hAsync("ix-button", { class: "CardList__Title__Show__All", ghost: true, onClick: props.onShowAllClick }, hAsync("span", null, props.showAllLabel), hAsync("span", null, !isNaN(props.showAllCounter) ? ` (${props.showAllCounter})` : null)))));
}
/**
 * @since 1.6.0
 */
class CardList {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.collapseChanged = createEvent(this, "collapseChanged", 7);
        this.showAllClick = createEvent(this, "showAllClick", 7);
        this.showMoreCardClick = createEvent(this, "showMoreCardClick", 7);
        this.label = undefined;
        this.collapse = false;
        this.listStyle = 'stack';
        this.maxVisibleCards = 12;
        this.showAllCount = undefined;
        this.suppressOverflowHandling = false;
        this.hideShowAll = false;
        this.i18nShowAll = 'Show all';
        this.i18nMoreCards = 'There are more cards available';
        this.hasOverflowingElements = false;
        this.numberOfOverflowingElements = 0;
        this.numberOfAllChildElements = 0;
        this.leftScrollDistance = 0;
        this.rightScrollDistance = 0;
    }
    onCardListVisibilityToggle() {
        this.collapse = !this.collapse;
        this.collapseChanged.emit(this.collapse);
    }
    onShowAllClick(event) {
        this.showAllClick.emit({
            nativeEvent: event,
        });
    }
    getListChildren() {
        const slot = this.hostElement.shadowRoot.querySelector('.CardList__Content > slot');
        return slot.assignedElements({ flatten: true });
    }
    changeVisibilityOfSlotChildren() {
        const childElements = this.getListChildren();
        childElements.forEach((element, index) => {
            if (element instanceof HTMLElement) {
                if (index > this.maxVisibleCards - 1) {
                    element.classList.add('d-none');
                    return;
                }
                element.classList.remove('d-none');
            }
        });
        this.hasOverflowingElements = childElements.length > this.maxVisibleCards;
        this.numberOfOverflowingElements =
            childElements.length - this.maxVisibleCards;
        this.numberOfAllChildElements = childElements.length;
        this.detectOverflow();
    }
    registerOverflowHandler() {
        this.observer = createMutationObserver(() => {
            this.changeVisibilityOfSlotChildren();
        });
        this.observer.observe(this.hostElement.shadowRoot.querySelector('.CardList__Content'), {
            childList: true,
            subtree: true,
        });
        requestAnimationFrame(() => {
            this.changeVisibilityOfSlotChildren();
        });
    }
    shouldHandleOverflow() {
        if (this.suppressOverflowHandling) {
            return false;
        }
        if (this.listStyle === 'stack' || this.listStyle === 'scroll') {
            return true;
        }
    }
    get listElement() {
        return this.hostElement.shadowRoot.querySelector('.CardList__Content');
    }
    onCardListScroll() {
        this.detectOverflow();
    }
    isShowMoreCardVisible() {
        return (this.suppressOverflowHandling === false && this.hasOverflowingElements);
    }
    getOpacityFromScrollDistance(distance) {
        if (!this.listElement) {
            return 0;
        }
        if (distance === 0) {
            return 0;
        }
        if (distance > 100) {
            return 1;
        }
        return distance / 100;
    }
    computeMaskLayer() {
        const maxOverflowWidth = 80;
        const maskLayer = `linear-gradient(
      90deg,
      transparent 0px,
      black ${maxOverflowWidth *
            (this.getOpacityFromScrollDistance(this.leftScrollDistance) > 0 ? 1 : 0)}px,
      black calc(100% - ${maxOverflowWidth *
            (this.getOpacityFromScrollDistance(this.rightScrollDistance) > 0
                ? 1
                : 0)}px),
      transparent 100%
    )`;
        return {
            '--ix-card-list-overflow': maskLayer,
        };
    }
    detectOverflow() {
        const { clientWidth, scrollWidth, scrollLeft } = this.listElement;
        this.leftScrollDistance = scrollLeft;
        this.rightScrollDistance = scrollWidth - scrollLeft - clientWidth;
    }
    componentDidLoad() {
        if (this.shouldHandleOverflow()) {
            this.registerOverflowHandler();
        }
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    render() {
        return (hAsync(Host, { key: '8164956edee5c3fa0d3f68af175c04a653aa7043' }, hAsync(CardListTitle, { key: '4001ba1a1fbc3dd244297380698907902f37932a', isCollapsed: this.collapse, label: this.label, showAllLabel: this.i18nShowAll, showAllCounter: this.showAllCount === undefined
                ? this.numberOfAllChildElements
                : this.showAllCount, onClick: () => this.onCardListVisibilityToggle(), onShowAllClick: (e) => this.onShowAllClick(e), hideShowAll: this.hideShowAll }), hAsync("div", { key: '0a72db4811cd78f9ba067d592218eafd9e69fc8e', class: {
                CardList__Overflow: true,
            }, style: this.computeMaskLayer() }, hAsync("div", { key: '4bf8fe61b17c5ab7b4ad4d0cf0bfaf3cd9c83008', class: {
                CardList__Content: true,
                CardList__Content__Collapsed: this.collapse,
                CardList__Style__Flexbox__Scroll: this.listStyle === 'stack',
                CardList__Style__Infinite__Scroll: this.listStyle === 'scroll',
            }, onScroll: () => this.onCardListScroll() }, hAsync("slot", { key: '2ed30ff94867a85b37678cc3fdef28770837d790', onSlotchange: () => this.changeVisibilityOfSlotChildren() }), this.isShowMoreCardVisible() ? (hAsync("ix-card", { class: {
                Show__All__Card: true,
            }, onClick: (event) => this.showMoreCardClick.emit({
                nativeEvent: event,
            }) }, hAsync("ix-card-content", { class: "Show__All__Card__Content" }, hAsync("ix-icon", { name: 'more-menu', size: '32', class: 'Show__All__Card__Icon' }), hAsync("span", { class: "Show__All__Card__Text" }, this.i18nMoreCards, " (", this.numberOfOverflowingElements, ")")))) : null))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxCardListStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-card-list",
        "$members$": {
            "label": [1],
            "collapse": [1028],
            "listStyle": [1, "list-style"],
            "maxVisibleCards": [2, "max-visible-cards"],
            "showAllCount": [2, "show-all-count"],
            "suppressOverflowHandling": [4, "suppress-overflow-handling"],
            "hideShowAll": [4, "hide-show-all"],
            "i18nShowAll": [1, "i-1-8n-show-all"],
            "i18nMoreCards": [1, "i-1-8n-more-cards"],
            "hasOverflowingElements": [32],
            "numberOfOverflowingElements": [32],
            "numberOfAllChildElements": [32],
            "leftScrollDistance": [32],
            "rightScrollDistance": [32]
        },
        "$listeners$": [[9, "resize", "detectOverflow"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class InputState {
    hasCategory() {
        return this.category !== undefined;
    }
    constructor(token, category) {
        this.token = token;
        this.category = category;
    }
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
// eslint-disable-next-line @stencil-community/ban-exported-const-enums
var LogicalFilterOperator;
(function (LogicalFilterOperator) {
    LogicalFilterOperator["EQUAL"] = "Equal";
    LogicalFilterOperator["NOT_EQUAL"] = "Not equal";
})(LogicalFilterOperator || (LogicalFilterOperator = {}));

const categoryFilterCss = "/*!@:host*/.sc-ix-category-filter-h{display:inline-block;height:2rem;vertical-align:middle;cursor:pointer;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:700;line-height:1.429em;color:var(--theme-color-std-text)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-category-filter-h *.sc-ix-category-filter,.sc-ix-category-filter-h *.sc-ix-category-filter::after,.sc-ix-category-filter-h *.sc-ix-category-filter::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-category-filter-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-corner{display:none}/*!@:host button*/.sc-ix-category-filter-h button.sc-ix-category-filter{all:unset;box-sizing:border-box;display:inline-flex;flex-direction:row;flex-wrap:nowrap;overflow:hidden;align-items:center;justify-content:center;width:100%;height:100%;padding:0 0.5rem}/*!@:host ix-spinner*/.sc-ix-category-filter-h ix-spinner.sc-ix-category-filter{margin-right:0.25rem}/*!@:host ix-icon*/.sc-ix-category-filter-h ix-icon.sc-ix-category-filter{margin-right:0.25rem}/*!@:host .content*/.sc-ix-category-filter-h .content.sc-ix-category-filter{display:inline-block;position:relative;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}/*!@:host .content-start*/.sc-ix-category-filter-h .content-start.sc-ix-category-filter{width:100%}/*!@:host .icon*/.sc-ix-category-filter-h .icon.sc-ix-category-filter{pointer-events:none}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{cursor:default}/*!@:host .btn-danger*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-danger, :host .btn-danger.focus, :host .btn-danger:focus-visible*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter,.sc-ix-category-filter-h .btn-danger.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-danger--background);color:var(--theme-btn-danger--color);--ix-button-color:var(--theme-btn-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-danger--border-color);border-style:solid}/*!@:host .btn-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-danger.selected*/.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger.selected:not(.disabled):not(:disabled):active, :host .btn-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):hover, :host .btn-danger:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-danger--border-color--hover);background-color:var(--theme-btn-danger--background--hover);color:var(--theme-btn-danger--color--hover)}/*!@:host .btn-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-danger:not(.disabled):not(:disabled):active, :host .btn-danger:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-danger--border-color--active);background-color:var(--theme-btn-danger--background--active);color:var(--theme-btn-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-danger.disabled, :host(.disabled) .btn-danger:disabled*/.disabled.sc-ix-category-filter-h .btn-danger.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-danger.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-danger--border-color--disabled);background-color:var(--theme-btn-danger--background--disabled);color:var(--theme-btn-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-danger--color--disabled)}/*!@:host .btn-outline-danger*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-danger, :host .btn-outline-danger.focus, :host .btn-outline-danger:focus-visible*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-danger.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-outline-danger--background);color:var(--theme-btn-outline-danger--color);--ix-button-color:var(--theme-btn-outline-danger--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-danger--border-color);border-style:solid}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-danger.selected*/.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger.selected:not(.disabled):not(:disabled):active, :host .btn-outline-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):hover, :host .btn-outline-danger:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-danger--border-color--hover);background-color:var(--theme-btn-outline-danger--background--hover);color:var(--theme-btn-outline-danger--color--hover)}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-danger:not(.disabled):not(:disabled):active, :host .btn-outline-danger:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-danger--border-color--active);background-color:var(--theme-btn-outline-danger--background--active);color:var(--theme-btn-outline-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-danger.disabled, :host(.disabled) .btn-outline-danger:disabled*/.disabled.sc-ix-category-filter-h .btn-outline-danger.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-outline-danger.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-outline-danger--border-color--disabled);background-color:var(--theme-btn-outline-danger--background--disabled);color:var(--theme-btn-outline-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-danger--color--disabled)}/*!@:host .btn-invisible-danger*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-danger, :host .btn-invisible-danger.focus, :host .btn-invisible-danger:focus-visible*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-danger.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-invisible-danger--background);color:var(--theme-btn-invisible-danger--color);--ix-button-color:var(--theme-btn-invisible-danger--color);border-color:transparent}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-danger.selected*/.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-danger.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-danger.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):hover, :host .btn-invisible-danger:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-danger--background--hover);color:var(--theme-btn-invisible-danger--color--hover)}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-danger:not(.disabled):not(:disabled):active, :host .btn-invisible-danger:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-danger--background--active);color:var(--theme-btn-invisible-danger--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-danger.disabled, :host(.disabled) .btn-invisible-danger:disabled*/.disabled.sc-ix-category-filter-h .btn-invisible-danger.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-invisible-danger.sc-ix-category-filter:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-danger--background--disabled);color:var(--theme-btn-invisible-danger--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-danger--color--disabled)}/*!@:host .btn-primary*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-primary, :host .btn-primary.focus, :host .btn-primary:focus-visible*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-primary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-primary--background);color:var(--theme-btn-primary--color);--ix-button-color:var(--theme-btn-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-primary--border-color);border-style:solid}/*!@:host .btn-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-primary.selected*/.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary.selected:not(.disabled):not(:disabled):active, :host .btn-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):hover, :host .btn-primary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-primary--border-color--hover);background-color:var(--theme-btn-primary--background--hover);color:var(--theme-btn-primary--color--hover)}/*!@:host .btn-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-primary:not(.disabled):not(:disabled):active, :host .btn-primary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-primary--border-color--active);background-color:var(--theme-btn-primary--background--active);color:var(--theme-btn-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-primary.disabled, :host(.disabled) .btn-primary:disabled*/.disabled.sc-ix-category-filter-h .btn-primary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-primary.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-primary--border-color--disabled);background-color:var(--theme-btn-primary--background--disabled);color:var(--theme-btn-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-primary--color--disabled)}/*!@:host .btn-outline-primary*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-primary, :host .btn-outline-primary.focus, :host .btn-outline-primary:focus-visible*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-primary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-outline-primary--background);color:var(--theme-btn-outline-primary--color);--ix-button-color:var(--theme-btn-outline-primary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-primary--border-color);border-style:solid}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-primary.selected*/.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):hover, :host .btn-outline-primary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-primary--border-color--hover);background-color:var(--theme-btn-outline-primary--background--hover);color:var(--theme-btn-outline-primary--color--hover)}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-primary:not(.disabled):not(:disabled):active, :host .btn-outline-primary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-primary--border-color--active);background-color:var(--theme-btn-outline-primary--background--active);color:var(--theme-btn-outline-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-primary.disabled, :host(.disabled) .btn-outline-primary:disabled*/.disabled.sc-ix-category-filter-h .btn-outline-primary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-outline-primary.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-outline-primary--border-color--disabled);background-color:var(--theme-btn-outline-primary--background--disabled);color:var(--theme-btn-outline-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-primary--color--disabled)}/*!@:host .btn-invisible-primary*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-primary, :host .btn-invisible-primary.focus, :host .btn-invisible-primary:focus-visible*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-primary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-invisible-primary--background);color:var(--theme-btn-invisible-primary--color);--ix-button-color:var(--theme-btn-invisible-primary--color);border-color:transparent}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-primary.selected*/.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-primary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-primary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):hover, :host .btn-invisible-primary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-primary--background--hover);color:var(--theme-btn-invisible-primary--color--hover)}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-primary:not(.disabled):not(:disabled):active, :host .btn-invisible-primary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-primary--background--active);color:var(--theme-btn-invisible-primary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-primary.disabled, :host(.disabled) .btn-invisible-primary:disabled*/.disabled.sc-ix-category-filter-h .btn-invisible-primary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-invisible-primary.sc-ix-category-filter:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-primary--background--disabled);color:var(--theme-btn-invisible-primary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-primary--color--disabled)}/*!@:host .btn-secondary*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-secondary, :host .btn-secondary.focus, :host .btn-secondary:focus-visible*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-secondary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-secondary--background);color:var(--theme-btn-secondary--color);--ix-button-color:var(--theme-btn-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-secondary--border-color);border-style:solid}/*!@:host .btn-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-secondary.selected*/.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):hover, :host .btn-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-secondary--border-color--hover);background-color:var(--theme-btn-secondary--background--hover);color:var(--theme-btn-secondary--color--hover)}/*!@:host .btn-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-secondary:not(.disabled):not(:disabled):active, :host .btn-secondary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-secondary--border-color--active);background-color:var(--theme-btn-secondary--background--active);color:var(--theme-btn-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-secondary.disabled, :host(.disabled) .btn-secondary:disabled*/.disabled.sc-ix-category-filter-h .btn-secondary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-secondary.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-secondary--border-color--disabled);background-color:var(--theme-btn-secondary--background--disabled);color:var(--theme-btn-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-secondary--color--disabled)}/*!@:host .btn-outline-secondary*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-outline-secondary, :host .btn-outline-secondary.focus, :host .btn-outline-secondary:focus-visible*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-secondary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-outline-secondary--background);color:var(--theme-btn-outline-secondary--color);--ix-button-color:var(--theme-btn-outline-secondary--color);border-width:var(--theme-btn--border-thickness);border-color:var(--theme-btn-outline-secondary--border-color);border-style:solid}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-outline-secondary.selected*/.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-outline-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):hover, :host .btn-outline-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{border-color:var(--theme-btn-outline-secondary--border-color--hover);background-color:var(--theme-btn-outline-secondary--background--hover);color:var(--theme-btn-outline-secondary--color--hover)}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-outline-secondary:not(.disabled):not(:disabled):active, :host .btn-outline-secondary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:not(.disabled):not(:disabled).active{border-color:var(--theme-btn-outline-secondary--border-color--active);background-color:var(--theme-btn-outline-secondary--background--active);color:var(--theme-btn-outline-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-outline-secondary.disabled, :host(.disabled) .btn-outline-secondary:disabled*/.disabled.sc-ix-category-filter-h .btn-outline-secondary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-outline-secondary.sc-ix-category-filter:disabled{pointer-events:none;border-color:var(--theme-btn-outline-secondary--border-color--disabled);background-color:var(--theme-btn-outline-secondary--background--disabled);color:var(--theme-btn-outline-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-outline-secondary--color--disabled)}/*!@:host .btn-invisible-secondary*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter{border-radius:var(--theme-btn--border-radius)}/*!@:host .btn-invisible-secondary, :host .btn-invisible-secondary.focus, :host .btn-invisible-secondary:focus-visible*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-secondary.focus.sc-ix-category-filter,.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:focus-visible{background-color:var(--theme-btn-invisible-secondary--background);color:var(--theme-btn-invisible-secondary--color);--ix-button-color:var(--theme-btn-invisible-secondary--color);border-color:transparent}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .btn-invisible-secondary.selected*/.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter{background-color:var(--theme-color-ghost--selected);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-color-ghost--selected-hover);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary.selected:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary.selected:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-secondary.selected.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-color-ghost--selected-active);color:var(--theme-color-dynamic)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):hover, :host .btn-invisible-secondary:not(.disabled):not(:disabled):hover*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):hover{background-color:var(--theme-btn-invisible-secondary--background--hover);color:var(--theme-btn-invisible-secondary--color--hover)}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled)*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .btn-invisible-secondary:not(.disabled):not(:disabled):active, :host .btn-invisible-secondary:not(.disabled):not(:disabled).active*/.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled):active,.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:not(.disabled):not(:disabled).active{background-color:var(--theme-btn-invisible-secondary--background--active);color:var(--theme-btn-invisible-secondary--color--active)}/*!@:host(.disabled)*/.disabled.sc-ix-category-filter-h{pointer-events:none}/*!@:host(.disabled) .btn-invisible-secondary.disabled, :host(.disabled) .btn-invisible-secondary:disabled*/.disabled.sc-ix-category-filter-h .btn-invisible-secondary.disabled.sc-ix-category-filter,.disabled.sc-ix-category-filter-h .btn-invisible-secondary.sc-ix-category-filter:disabled{pointer-events:none;background-color:var(--theme-btn-invisible-secondary--background--disabled);color:var(--theme-btn-invisible-secondary--color--disabled);opacity:1;--ix-button-color:var(--theme-btn-invisible-secondary--color--disabled)}/*!@:host*/.sc-ix-category-filter-h{min-width:5rem}/*!@.dropdown-group*/.dropdown-group.sc-ix-category-filter{margin:0.687rem;display:block;position:relative;width:21.562rem;border-radius:0.25rem;background-color:#f8f9fa;border:solid 0.062rem rgba(0, 0, 0, 0.25)}/*!@.dropdown-group .dropdown-group-title*/.dropdown-group.sc-ix-category-filter .dropdown-group-title.sc-ix-category-filter{display:block;position:relative;font-size:0.875rem;text-align:left;margin:0.937rem 0 1.25rem 0.937rem}/*!@.dropdown-group .dropdown-group-content*/.dropdown-group.sc-ix-category-filter .dropdown-group-content.sc-ix-category-filter{position:relative;display:flex;flex-direction:column;overflow-y:auto;overflow-x:hidden;height:11.562rem;margin:0.937rem 0 0.937rem 0.937rem}/*!@.dropdown-group .dropdown-group-content > **/.dropdown-group.sc-ix-category-filter .dropdown-group-content.sc-ix-category-filter>*.sc-ix-category-filter{margin-bottom:1rem}/*!@.dropdown-group-submit*/.dropdown-group-submit.sc-ix-category-filter{display:flex;justify-content:space-between;margin:0 0.687rem 0 0.687rem}/*!@.dropdown-menu*/.dropdown-menu.sc-ix-category-filter{position:absolute;background-color:var(--theme-menu--background);-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:400;line-height:1.143em;color:var(--theme-color-std-text);border:var(--theme-menu--border-thickness) solid var(--theme-menu--border--color);border-radius:var(--theme-menu--border-radius);max-width:100vw;padding:0.25rem 0;transition:background-color var(--theme-default-time);box-shadow:var(--theme-menu--box-shadow)}/*!@.dropdown-menu.xl > .dropdown-item*/.dropdown-menu.xl.sc-ix-category-filter>.dropdown-item.sc-ix-category-filter{height:2.5rem;line-height:2.187rem}/*!@.dropdown-header*/.dropdown-header.sc-ix-category-filter{display:flex;align-items:center;height:2.5rem;color:var(--theme-menu-header--color);padding:0 1rem}/*!@.dropdown-buttons*/.dropdown-buttons.sc-ix-category-filter{display:flex;padding:0.25rem 0.5rem}/*!@.dropdown-buttons ix-icon-button + ix-icon-button*/.dropdown-buttons.sc-ix-category-filter ix-icon-button.sc-ix-category-filter+ix-icon-button.sc-ix-category-filter{margin-inline-start:0.5rem}/*!@.dropdown-item*/.dropdown-item.sc-ix-category-filter{display:flex;height:2.5rem;position:relative;align-items:center;cursor:pointer;padding:0 2rem;border:1px solid transparent;color:var(--theme-menu-item--color);background-color:transparent}/*!@.dropdown-item:focus-visible*/.dropdown-item.sc-ix-category-filter:focus-visible{background-color:var(--theme-menu-item--background);color:var(--theme-menu-item--color)}/*!@.dropdown-item:focus-visible*/.dropdown-item.sc-ix-category-filter:focus-visible{outline:none;background-color:var(--theme-menu-item--background);border-color:#119fff;color:var(--theme-menu-item--color--focus)}/*!@.dropdown-item:not(.disabled):not(:disabled)*/.dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@.dropdown-item:not(.disabled):not(:disabled):hover, .dropdown-item:not(.disabled):not(:disabled):hover*/.dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled):hover{color:var(--theme-menu-item--color--hover);background-color:var(--theme-menu-item--background--hover)}/*!@.dropdown-item:not(.disabled):not(:disabled)*/.dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled){cursor:pointer}/*!@.dropdown-item:not(.disabled):not(:disabled):active, .dropdown-item:not(.disabled):not(:disabled).active*/.dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled):active,.dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled).active{color:var(--theme-menu-item--color--active);background-color:var(--theme-menu-item--background--active)}/*!@.dropdown-item.disabled, .dropdown-item:disabled*/.dropdown-item.disabled.sc-ix-category-filter,.dropdown-item.sc-ix-category-filter:disabled{color:var(--theme-menu-item--color--disabled);background-color:var(--theme-menu-item--background--disabled)}/*!@.dropdown-item > a,\n.dropdown-item a:hover,\n.dropdown-item a:active*/.dropdown-item.sc-ix-category-filter>a.sc-ix-category-filter,.dropdown-item.sc-ix-category-filter a.sc-ix-category-filter:hover,.dropdown-item.sc-ix-category-filter a.sc-ix-category-filter:active{color:var(--theme-color-std-text)}/*!@.dropdown-item > .glyph*/.dropdown-item.sc-ix-category-filter>.glyph.sc-ix-category-filter{color:var(--theme-menu-item-icon--color);margin-inline-end:0.5rem}/*!@.dropdown-item > .glyph.disabled*/.dropdown-item.sc-ix-category-filter>.glyph.disabled.sc-ix-category-filter{color:var(--color-weak-text)}/*!@.dropdown-item > .glyph.glyph-single-check*/.dropdown-item.sc-ix-category-filter>.glyph.glyph-single-check.sc-ix-category-filter{color:var(--theme-menu-item-icon-check--color)}/*!@.dropdown-item > input[type=checkbox] + label*/.dropdown-item.sc-ix-category-filter>input[type=checkbox].sc-ix-category-filter+label.sc-ix-category-filter{margin-bottom:0px}/*!@.dropdown-item > input[type=checkbox] + label::before*/.dropdown-item.sc-ix-category-filter>input[type=checkbox].sc-ix-category-filter+label.sc-ix-category-filter::before{margin-right:1rem}/*!@.dropdown-divider*/.dropdown-divider.sc-ix-category-filter{border-top:1px solid var(--theme-menu-separator--background);margin:0.25rem 0}/*!@button.dropdown-toggle*/button.dropdown-toggle.sc-ix-category-filter{position:relative;padding-right:1.5rem}/*!@button.dropdown-toggle::after*/button.dropdown-toggle.sc-ix-category-filter::after{position:absolute;top:45%;right:0.5rem}/*!@.form-control,\n.form-control-plaintext*/.form-control.sc-ix-category-filter,.form-control-plaintext.sc-ix-category-filter{-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:400;line-height:1.429em;color:var(--theme-color-std-text);color:var(--theme-input--color);overflow:hidden;text-overflow:ellipsis;white-space:nowrap;border-radius:var(--theme-input--border-radius);height:2rem;min-height:2rem;min-width:2rem;background-color:var(--theme-input--background);border:solid 1px var(--theme-input--border-color);box-shadow:var(--theme-input--box-shadow);padding-inline-start:0.5rem;padding-inline-end:0.5rem}/*!@.form-control::-moz-placeholder, .form-control-plaintext::-moz-placeholder*/.form-control.sc-ix-category-filter::-moz-placeholder,.form-control-plaintext.sc-ix-category-filter::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@.form-control::placeholder,\n.form-control-plaintext::placeholder*/.form-control.sc-ix-category-filter::placeholder,.form-control-plaintext.sc-ix-category-filter::placeholder{color:var(--theme-input-hint--color)}/*!@.form-control:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled), .form-control-plaintext:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled)*/.form-control.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled),.form-control-plaintext.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled){cursor:pointer}/*!@.form-control:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled),\n.form-control-plaintext:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled)*/.form-control.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled),.form-control-plaintext.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled){cursor:pointer}/*!@.form-control:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover, .form-control:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover, .form-control-plaintext:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover, .form-control-plaintext:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover*/.form-control.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover,.form-control-plaintext.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover{background-color:var(--theme-input--background--hover);border-color:var(--theme-input--border-color--hover);cursor:auto}/*!@.form-control:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover, .form-control:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover,\n.form-control-plaintext:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover,\n.form-control-plaintext:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover*/.form-control.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover,.form-control-plaintext.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):hover{background-color:var(--theme-input--background--hover);border-color:var(--theme-input--border-color--hover);cursor:auto}/*!@.form-control:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible, .form-control-plaintext:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible*/.form-control.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible,.form-control-plaintext.sc-ix-category-filter:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible{background-color:var(--theme-input--background--focus);border-color:var(--theme-input--border-color--focus);outline-offset:var(--theme-input--focus--outline-offset);box-shadow:var(--theme-input--box-shadow);outline:1px solid var(--theme-color-focus-bdr)}/*!@.form-control:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible,\n.form-control-plaintext:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible*/.form-control.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible,.form-control-plaintext.sc-ix-category-filter:not(:read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled):focus-visible{background-color:var(--theme-input--background--focus);border-color:var(--theme-input--border-color--focus);outline-offset:var(--theme-input--focus--outline-offset);box-shadow:var(--theme-input--box-shadow);outline:1px solid var(--theme-color-focus-bdr)}/*!@.form-control:focus-visible*/.form-control.sc-ix-category-filter:focus-visible{color:var(--theme-input--color)}/*!@.form-control[type=number]*/.form-control[type=number].sc-ix-category-filter{text-align:right}/*!@.form-control[type=number]::-webkit-inner-spin-button*/.form-control[type=number].sc-ix-category-filter::-webkit-inner-spin-button{margin-right:-2px;margin-left:2px;display:none}/*!@.form-control.readonly,\n.form-control[readonly]*/.form-control.readonly.sc-ix-category-filter,.form-control[readonly].sc-ix-category-filter{background:transparent !important;border-block-start:none !important;border-inline-start:none !important;border-inline-end:none !important;border-radius:0rem}/*!@.form-control:-moz-read-only*/.form-control.sc-ix-category-filter:-moz-read-only{box-shadow:none !important;outline:none !important;border-color:var(--theme-input--border-color);cursor:default !important}/*!@.form-control:read-only,\n.form-control[readonly],\n.form-control[readOnly],\n.form-control.readonly*/.form-control.sc-ix-category-filter:read-only,.form-control[readonly].sc-ix-category-filter,.form-control[readOnly].sc-ix-category-filter,.form-control.readonly.sc-ix-category-filter{box-shadow:none !important;outline:none !important;border-color:var(--theme-input--border-color);cursor:default !important}/*!@.form-control:read-only::-moz-placeholder, .form-control[readonly]::-moz-placeholder, .form-control[readOnly]::-moz-placeholder, .form-control.readonly::-moz-placeholder*/.form-control.sc-ix-category-filter:read-only::-moz-placeholder,.form-control[readonly].sc-ix-category-filter::-moz-placeholder,.form-control[readOnly].sc-ix-category-filter::-moz-placeholder,.form-control.readonly.sc-ix-category-filter::-moz-placeholder{color:transparent}/*!@.form-control:-moz-read-only::placeholder*/.form-control.sc-ix-category-filter:-moz-read-only::placeholder{color:transparent}/*!@.form-control:read-only::placeholder,\n.form-control[readonly]::placeholder,\n.form-control[readOnly]::placeholder,\n.form-control.readonly::placeholder*/.form-control.sc-ix-category-filter:read-only::placeholder,.form-control[readonly].sc-ix-category-filter::placeholder,.form-control[readOnly].sc-ix-category-filter::placeholder,.form-control.readonly.sc-ix-category-filter::placeholder{color:transparent}/*!@.form-control:disabled,\n.form-control.disabled*/.form-control.sc-ix-category-filter:disabled,.form-control.disabled.sc-ix-category-filter{background:transparent !important;border-block-start:none !important;border-inline-start:none !important;border-inline-end:none !important;border-radius:0rem;color:var(--theme-color-weak-text);border-color:var(--theme-input--border-color-bottom--disabled)}/*!@.form-control:disabled::-moz-placeholder, .form-control.disabled::-moz-placeholder*/.form-control.sc-ix-category-filter:disabled::-moz-placeholder,.form-control.disabled.sc-ix-category-filter::-moz-placeholder{color:transparent}/*!@.form-control:disabled::placeholder,\n.form-control.disabled::placeholder*/.form-control.sc-ix-category-filter:disabled::placeholder,.form-control.disabled.sc-ix-category-filter::placeholder{color:transparent}/*!@.form-control-plaintext*/.form-control-plaintext.sc-ix-category-filter{outline:0}/*!@.form-group*/.form-group.sc-ix-category-filter{position:relative}/*!@.input-wrapper*/.input-wrapper.sc-ix-category-filter{display:flex;position:relative;align-items:center;flex-wrap:nowrap}/*!@.input-wrapper > .glyph*/.input-wrapper.sc-ix-category-filter>.glyph.sc-ix-category-filter{display:block;position:absolute;margin-inline-start:0.312rem;color:var(--theme-color-std-text)}/*!@.input-wrapper > input*/.input-wrapper.sc-ix-category-filter>input.sc-ix-category-filter{padding-inline-start:2.2rem}/*!@select.form-control*/select.form-control.sc-ix-category-filter{padding:0 0.312rem}/*!@textarea.form-control*/textarea.form-control.sc-ix-category-filter{padding:0.375rem 0.5rem}/*!@input.disabled, input:disabled*/input.disabled.sc-ix-category-filter,input.sc-ix-category-filter:disabled{color:var(--theme-input--color--disabled)}/*!@input:-moz-read-only*/input.sc-ix-category-filter:-moz-read-only{cursor:default}/*!@input:read-only, input.readonly*/input.sc-ix-category-filter:read-only,input.readonly.sc-ix-category-filter{cursor:default}/*!@label*/label.sc-ix-category-filter{color:var(--theme-color-soft-text);padding:2px 0px}/*!@label.label-alignment-left*/label.label-alignment-left.sc-ix-category-filter{padding:6px 0px}/*!@input*/input.sc-ix-category-filter{font-feature-settings:\"clig\" off, \"liga\" off;font-family:Siemens Sans, Siemens Sans, Arial, Helvetica, sans-serif;font-style:normal;font-size:var(--theme-ms-0);line-height:var(--theme-line-height-md);font-weight:var(--theme-font-weight-normal);letter-spacing:var(--theme-letter-spacing-xl);text-decoration:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;min-height:2rem;width:100%;padding:0.25rem 0.5rem;background-color:var(--theme-input--background);color:var(--theme-input--color);-moz-appearance:textfield;text-overflow:ellipsis;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color);border-radius:var(--theme-input--border-radius);box-shadow:var(--theme-input--box-shadow)}/*!@input:-webkit-autofill*/input.sc-ix-category-filter:-webkit-autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@input:-webkit-autofill, input:autofill*/input.sc-ix-category-filter:-webkit-autofill,input.sc-ix-category-filter:autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@input::-moz-placeholder*/input.sc-ix-category-filter::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@input::placeholder*/input.sc-ix-category-filter::placeholder{color:var(--theme-input-hint--color)}/*!@input.hover, input:hover*/input.hover.sc-ix-category-filter,input.sc-ix-category-filter:hover{border-color:var(--theme-input--border-color--hover) !important;background-color:var(--theme-input--background--hover)}/*!@input.focus, input:focus*/input.focus.sc-ix-category-filter,input.sc-ix-category-filter:focus{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-input--focus--outline-offset);border-color:var(--theme-input--border-color--focus) !important}/*!@input:-moz-read-only*/input.sc-ix-category-filter:-moz-read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@input.read-only, input:read-only*/input.read-only.sc-ix-category-filter,input.sc-ix-category-filter:read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@input.read-only::-moz-placeholder, input:read-only::-moz-placeholder*/input.read-only.sc-ix-category-filter::-moz-placeholder,input.sc-ix-category-filter:read-only::-moz-placeholder{color:transparent}/*!@input:-moz-read-only::placeholder*/input.sc-ix-category-filter:-moz-read-only::placeholder{color:transparent}/*!@input.read-only::placeholder, input:read-only::placeholder*/input.read-only.sc-ix-category-filter::placeholder,input.sc-ix-category-filter:read-only::placeholder{color:transparent}/*!@input:disabled*/input.sc-ix-category-filter:disabled{box-shadow:none;background-color:transparent;outline:none;border:none;color:var(--theme-input--color--disabled);border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--disabled)}/*!@input:disabled::-moz-placeholder*/input.sc-ix-category-filter:disabled::-moz-placeholder{color:transparent}/*!@input:disabled::placeholder*/input.sc-ix-category-filter:disabled::placeholder{color:transparent}/*!@input[type=number]*/input[type=number].sc-ix-category-filter{text-align:right}/*!@input[type=number]::-webkit-inner-spin-button*/input[type=number].sc-ix-category-filter::-webkit-inner-spin-button{margin-right:-2px;margin-left:2px;display:none}/*!@textarea*/textarea.sc-ix-category-filter{height:3.25rem;padding:0.375rem 1.25rem 0.375rem 0.5rem}/*!@textarea*/textarea.sc-ix-category-filter{font-feature-settings:\"clig\" off, \"liga\" off;font-family:Siemens Sans, Siemens Sans, Arial, Helvetica, sans-serif;font-style:normal;font-size:var(--theme-ms-0);line-height:var(--theme-line-height-md);font-weight:var(--theme-font-weight-normal);letter-spacing:var(--theme-letter-spacing-xl);text-decoration:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;min-height:2rem;width:100%;padding:0.25rem 0.5rem;background-color:var(--theme-input--background);color:var(--theme-input--color);-moz-appearance:textfield;text-overflow:ellipsis;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color);border-radius:var(--theme-input--border-radius);box-shadow:var(--theme-input--box-shadow)}/*!@textarea:-webkit-autofill*/textarea.sc-ix-category-filter:-webkit-autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@textarea:-webkit-autofill, textarea:autofill*/textarea.sc-ix-category-filter:-webkit-autofill,textarea.sc-ix-category-filter:autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@textarea::-moz-placeholder*/textarea.sc-ix-category-filter::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@textarea::placeholder*/textarea.sc-ix-category-filter::placeholder{color:var(--theme-input-hint--color)}/*!@textarea.hover, textarea:hover*/textarea.hover.sc-ix-category-filter,textarea.sc-ix-category-filter:hover{border-color:var(--theme-input--border-color--hover) !important;background-color:var(--theme-input--background--hover)}/*!@textarea.focus, textarea:focus*/textarea.focus.sc-ix-category-filter,textarea.sc-ix-category-filter:focus{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-input--focus--outline-offset);border-color:var(--theme-input--border-color--focus) !important}/*!@textarea:-moz-read-only*/textarea.sc-ix-category-filter:-moz-read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@textarea.read-only, textarea:read-only*/textarea.read-only.sc-ix-category-filter,textarea.sc-ix-category-filter:read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@textarea.read-only::-moz-placeholder, textarea:read-only::-moz-placeholder*/textarea.read-only.sc-ix-category-filter::-moz-placeholder,textarea.sc-ix-category-filter:read-only::-moz-placeholder{color:transparent}/*!@textarea:-moz-read-only::placeholder*/textarea.sc-ix-category-filter:-moz-read-only::placeholder{color:transparent}/*!@textarea.read-only::placeholder, textarea:read-only::placeholder*/textarea.read-only.sc-ix-category-filter::placeholder,textarea.sc-ix-category-filter:read-only::placeholder{color:transparent}/*!@textarea:disabled*/textarea.sc-ix-category-filter:disabled{box-shadow:none;background-color:transparent;outline:none;border:none;color:var(--theme-input--color--disabled);border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--disabled)}/*!@textarea:disabled::-moz-placeholder*/textarea.sc-ix-category-filter:disabled::-moz-placeholder{color:transparent}/*!@textarea:disabled::placeholder*/textarea.sc-ix-category-filter:disabled::placeholder{color:transparent}/*!@textarea ~ .valid-feedback,\ntextarea ~ .invalid-feedback,\ninput ~ .valid-feedback,\ninput ~ .invalid-feedback*/textarea.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter,textarea.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter,input.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter,input.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter{display:none;font-feature-settings:\"clig\" off, \"liga\" off;font-family:Siemens Sans, Siemens Sans, Arial, Helvetica, sans-serif;font-style:normal;font-size:var(--theme-ms-0);line-height:var(--theme-line-height-md);font-weight:var(--theme-font-weight-normal);letter-spacing:var(--theme-letter-spacing-xl);text-decoration:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale}/*!@form textarea ~ .valid-feedback,\nform input ~ .valid-feedback*/form.sc-ix-category-filter textarea.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter,form.sc-ix-category-filter input.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter{color:var(--theme-color-success)}/*!@form textarea ~ .invalid-feedback,\nform input ~ .invalid-feedback*/form.sc-ix-category-filter textarea.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter,form.sc-ix-category-filter input.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter{color:var(--theme-color-alarm-text)}/*!@form:not([novalidate]) :invalid,\nform:not([novalidate]) .is-invalid,\nform.was-validated :invalid,\nform.was-validated .is-invalid*/form.sc-ix-category-filter:not([novalidate]) .sc-ix-category-filter:invalid,form.sc-ix-category-filter:not([novalidate]) .is-invalid.sc-ix-category-filter,form.was-validated.sc-ix-category-filter .sc-ix-category-filter:invalid,form.was-validated.sc-ix-category-filter .is-invalid.sc-ix-category-filter{background-color:var(--theme-input-error--background);border-color:var(--theme-input-error--border-color);background-image:url(\"data:image/svg+xml,%3C%3Fxml version='1.0' encoding='UTF-8'%3F%3E%3Csvg width='512px' height='512px' viewBox='0 0 512 512' version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'%3E%3C!-- Generator: sketchtool 62 (101010) - https://sketch.com --%3E%3Ctitle%3Eerror%3C/title%3E%3Cdesc%3ECreated with sketchtool.%3C/desc%3E%3Cg id='Page-1' stroke='none' stroke-width='1' fill='none' fill-rule='evenodd' fill-opacity='0.75'%3E%3Cg id='error' fill='%23ff2640'%3E%3Cg id='error/error'%3E%3Cpath d='M256,42.6666667 C373.626371,42.6666667 469.333333,138.373627 469.333333,256 C469.333333,373.626371 373.626371,469.333333 256,469.333333 C138.373627,469.333333 42.6666667,373.626371 42.6666667,256 C42.6666667,138.373627 138.373627,42.6666667 256,42.6666667 Z M256,85.3333333 C161.559631,85.3333333 85.3333333,161.559631 85.3333333,256 C85.3333333,350.44037 161.559631,426.666667 256,426.666667 C350.44037,426.666667 426.666667,350.44037 426.666667,256 C426.666667,161.559631 350.44037,85.3333333 256,85.3333333 Z M326.248389,155.581722 L356.418278,185.751611 L286.168667,255.999667 L356.418278,326.248389 L326.248389,356.418278 L255.999667,286.168667 L185.751611,356.418278 L155.581722,326.248389 L225.829667,255.999667 L155.581722,185.751611 L185.751611,155.581722 L255.999667,225.829667 L326.248389,155.581722 Z' id='Combined-Shape'%3E%3C/path%3E%3C/g%3E%3C/g%3E%3C/g%3E%3C/svg%3E\") !important;background-position:left calc(0.375em + 0.1875rem) center;padding-right:0.75rem;padding-left:calc(1.5em + 0.75rem);background-size:18px;background-repeat:no-repeat}/*!@form:not([novalidate]) :invalid ~ .invalid-feedback,\nform:not([novalidate]) .is-invalid ~ .invalid-feedback,\nform.was-validated :invalid ~ .invalid-feedback,\nform.was-validated .is-invalid ~ .invalid-feedback*/form.sc-ix-category-filter:not([novalidate]) .sc-ix-category-filter:invalid~.invalid-feedback.sc-ix-category-filter,form.sc-ix-category-filter:not([novalidate]) .is-invalid.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter,form.was-validated.sc-ix-category-filter .sc-ix-category-filter:invalid~.invalid-feedback.sc-ix-category-filter,form.was-validated.sc-ix-category-filter .is-invalid.sc-ix-category-filter~.invalid-feedback.sc-ix-category-filter{display:block}/*!@form:not([novalidate]) :valid ~ .valid-feedback,\nform:not([novalidate]) .is-valid ~ .valid-feedback,\nform.was-validated :valid ~ .valid-feedback,\nform.was-validated .is-valid ~ .valid-feedback*/form.sc-ix-category-filter:not([novalidate]) .sc-ix-category-filter:valid~.valid-feedback.sc-ix-category-filter,form.sc-ix-category-filter:not([novalidate]) .is-valid.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter,form.was-validated.sc-ix-category-filter .sc-ix-category-filter:valid~.valid-feedback.sc-ix-category-filter,form.was-validated.sc-ix-category-filter .is-valid.sc-ix-category-filter~.valid-feedback.sc-ix-category-filter{display:block}/*!@form:not(.was-validated) .invalid-feedback,\nform:not(.was-validated) .valid-feedback*/form.sc-ix-category-filter:not(.was-validated) .invalid-feedback.sc-ix-category-filter,form.sc-ix-category-filter:not(.was-validated) .valid-feedback.sc-ix-category-filter{display:none !important}/*!@:host*/.sc-ix-category-filter-h{display:block;position:relative;height:auto}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-category-filter-h *.sc-ix-category-filter,.sc-ix-category-filter-h *.sc-ix-category-filter::after,.sc-ix-category-filter-h *.sc-ix-category-filter::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-category-filter-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-category-filter-h .sc-ix-category-filter::-webkit-scrollbar-corner{display:none}/*!@:host :host(:focus-visible:not(.disabled):not(:disabled))*/.sc-ix-category-filter-h(.sc-ix-category-filter:focus-visible:not(.disabled):not(:disabled)){border-color:var(--theme-color-primary);box-shadow:0 0 0.25rem 0 var(--theme-color-primary) !important}/*!@:host .reset-button*/.sc-ix-category-filter-h .reset-button.sc-ix-category-filter{position:absolute;top:0.25rem;right:0.25rem}/*!@:host .reset-button.hide-reset-button*/.sc-ix-category-filter-h .reset-button.hide-reset-button.sc-ix-category-filter{display:none}/*!@:host .input-container*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter{display:flex;height:auto;max-height:3.75rem;padding:1px 1.5rem 1px 1.75rem !important}/*!@:host .input-container:not(.readonly):not(.disabled)*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled){font-feature-settings:\"clig\" off, \"liga\" off;font-family:Siemens Sans, Siemens Sans, Arial, Helvetica, sans-serif;font-style:normal;font-size:var(--theme-ms-0);line-height:var(--theme-line-height-md);font-weight:var(--theme-font-weight-normal);letter-spacing:var(--theme-letter-spacing-xl);text-decoration:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;min-height:2rem;width:100%;padding:0.25rem 0.5rem;background-color:var(--theme-input--background);color:var(--theme-input--color);-moz-appearance:textfield;text-overflow:ellipsis;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color);border-radius:var(--theme-input--border-radius);box-shadow:var(--theme-input--box-shadow)}/*!@:host .input-container:not(.readonly):not(.disabled):-webkit-autofill*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):-webkit-autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@:host .input-container:not(.readonly):not(.disabled):-webkit-autofill, :host .input-container:not(.readonly):not(.disabled):autofill*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):-webkit-autofill,.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@:host .input-container:not(.readonly):not(.disabled)::-moz-placeholder*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled)::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@:host .input-container:not(.readonly):not(.disabled)::placeholder*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled)::placeholder{color:var(--theme-input-hint--color)}/*!@:host .input-container:not(.readonly):not(.disabled).hover, :host .input-container:not(.readonly):not(.disabled):hover*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled).hover,.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):hover{border-color:var(--theme-input--border-color--hover) !important;background-color:var(--theme-input--background--hover)}/*!@:host .input-container:not(.readonly):not(.disabled).focus, :host .input-container:not(.readonly):not(.disabled):focus*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled).focus,.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):focus{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-input--focus--outline-offset);border-color:var(--theme-input--border-color--focus) !important}/*!@:host .input-container:not(.readonly):not(.disabled):disabled*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):disabled{box-shadow:none;background-color:transparent;outline:none;border:none;color:var(--theme-input--color--disabled);border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--disabled)}/*!@:host .input-container:not(.readonly):not(.disabled):disabled::-moz-placeholder*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):disabled::-moz-placeholder{color:transparent}/*!@:host .input-container:not(.readonly):not(.disabled):disabled::placeholder*/.sc-ix-category-filter-h .input-container.sc-ix-category-filter:not(.readonly):not(.disabled):disabled::placeholder{color:transparent}/*!@:host .input-container.disabled*/.sc-ix-category-filter-h .input-container.disabled.sc-ix-category-filter{color:var(--theme-input--color--disabled);border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--disabled)}/*!@:host .input-container.readonly*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter{font-feature-settings:\"clig\" off, \"liga\" off;font-family:Siemens Sans, Siemens Sans, Arial, Helvetica, sans-serif;font-style:normal;font-size:var(--theme-ms-0);line-height:var(--theme-line-height-md);font-weight:var(--theme-font-weight-normal);letter-spacing:var(--theme-letter-spacing-xl);text-decoration:none;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;min-height:2rem;width:100%;padding:0.25rem 0.5rem;background-color:var(--theme-input--background);color:var(--theme-input--color);-moz-appearance:textfield;text-overflow:ellipsis;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color);border-radius:var(--theme-input--border-radius);box-shadow:var(--theme-input--box-shadow)}/*!@:host .input-container.readonly:-webkit-autofill*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:-webkit-autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@:host .input-container.readonly:-webkit-autofill, :host .input-container.readonly:autofill*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:-webkit-autofill,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:autofill{-webkit-box-shadow:0 0 0 1000px var(--theme-color-component-info) inset !important;-webkit-text-fill-color:var(--theme-input--color--autofill) !important;background-color:var(--theme-input--background--autofill) !important;border:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color--autofill) !important;color:var(--theme-input--color--autofill) !important}/*!@:host .input-container.readonly::-moz-placeholder*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@:host .input-container.readonly::placeholder*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter::placeholder{color:var(--theme-input-hint--color)}/*!@:host .input-container.readonly.hover, :host .input-container.readonly:hover*/.sc-ix-category-filter-h .input-container.readonly.hover.sc-ix-category-filter,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:hover{border-color:var(--theme-input--border-color--hover) !important;background-color:var(--theme-input--background--hover)}/*!@:host .input-container.readonly.focus, :host .input-container.readonly:focus*/.sc-ix-category-filter-h .input-container.readonly.focus.sc-ix-category-filter,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:focus{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-input--focus--outline-offset);border-color:var(--theme-input--border-color--focus) !important}/*!@:host .input-container.readonly:-moz-read-only*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:-moz-read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@:host .input-container.readonly.read-only, :host .input-container.readonly:read-only*/.sc-ix-category-filter-h .input-container.readonly.read-only.sc-ix-category-filter,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:read-only{box-shadow:none;background-color:transparent;outline:none;border:none;border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--readonly)}/*!@:host .input-container.readonly.read-only::-moz-placeholder, :host .input-container.readonly:read-only::-moz-placeholder*/.sc-ix-category-filter-h .input-container.readonly.read-only.sc-ix-category-filter::-moz-placeholder,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:read-only::-moz-placeholder{color:transparent}/*!@:host .input-container.readonly:-moz-read-only::placeholder*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:-moz-read-only::placeholder{color:transparent}/*!@:host .input-container.readonly.read-only::placeholder, :host .input-container.readonly:read-only::placeholder*/.sc-ix-category-filter-h .input-container.readonly.read-only.sc-ix-category-filter::placeholder,.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:read-only::placeholder{color:transparent}/*!@:host .input-container.readonly:disabled*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:disabled{box-shadow:none;background-color:transparent;outline:none;border:none;color:var(--theme-input--color--disabled);border-bottom:var(--theme-input--border-thickness, 1px) solid var(--theme-input--border-color-bottom--disabled)}/*!@:host .input-container.readonly:disabled::-moz-placeholder*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:disabled::-moz-placeholder{color:transparent}/*!@:host .input-container.readonly:disabled::placeholder*/.sc-ix-category-filter-h .input-container.readonly.sc-ix-category-filter:disabled::placeholder{color:transparent}/*!@:host .input-container.no-icon*/.sc-ix-category-filter-h .input-container.no-icon.sc-ix-category-filter{padding-left:0.25rem}/*!@:host .token-container*/.sc-ix-category-filter-h .token-container.sc-ix-category-filter{flex-grow:1;overflow:hidden}/*!@:host .text-input*/.sc-ix-category-filter-h .text-input.sc-ix-category-filter{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:400;line-height:1.429em;color:var(--theme-color-std-text);width:auto;height:1.75rem;min-height:1.5rem;background:transparent;flex-grow:1;box-shadow:none}/*!@:host .text-input, :host .text-input:hover, :host .text-input:focus-visible*/.sc-ix-category-filter-h .text-input.sc-ix-category-filter,.sc-ix-category-filter-h .text-input.sc-ix-category-filter:hover,.sc-ix-category-filter-h .text-input.sc-ix-category-filter:focus-visible{border:none;outline:none}/*!@:host .text-input.hide-placeholder::-moz-placeholder*/.sc-ix-category-filter-h .text-input.hide-placeholder.sc-ix-category-filter::-moz-placeholder{opacity:0}/*!@:host .text-input.hide-placeholder::placeholder*/.sc-ix-category-filter-h .text-input.hide-placeholder.sc-ix-category-filter::placeholder{opacity:0}/*!@:host .list-unstyled*/.sc-ix-category-filter-h .list-unstyled.sc-ix-category-filter{display:flex;flex-wrap:wrap;list-style:none;padding:0;margin:0;overflow-y:auto}/*!@:host ix-icon*/.sc-ix-category-filter-h ix-icon.sc-ix-category-filter{position:absolute;top:0.5rem;left:0.5rem}/*!@:host ix-filter-chip*/.sc-ix-category-filter-h ix-filter-chip.sc-ix-category-filter{margin-right:0.25rem}/*!@:host .category-preview*/.sc-ix-category-filter-h .category-preview.sc-ix-category-filter{display:flex;align-items:center;height:1.5rem;background-color:var(--theme-bg-3);border-top-left-radius:1rem;border-bottom-left-radius:1rem;padding:0.5rem;margin:2px 0}/*!@:host ul*/.sc-ix-category-filter-h ul.sc-ix-category-filter{height:100%}/*!@:host ul > li,\n:host input*/.sc-ix-category-filter-h ul.sc-ix-category-filter>li.sc-ix-category-filter,.sc-ix-category-filter-h input.sc-ix-category-filter{padding-inline-start:0;padding-top:2px;padding-bottom:2px}/*!@:host ix-dropdown*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter{min-width:10rem !important}/*!@:host ix-dropdown .dropdown-item-container*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .dropdown-item-container.sc-ix-category-filter{display:flex;flex-direction:column}/*!@:host ix-dropdown .dropdown-item-container .dropdown-item*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .dropdown-item-container.sc-ix-category-filter .dropdown-item.sc-ix-category-filter{-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:400;line-height:1.143em;color:var(--theme-color-std-text);overflow:hidden;text-overflow:ellipsis;white-space:nowrap;height:2.5rem;margin:0.25rem 0.5rem;padding-inline:0.5rem;border:1px solid transparent;border-radius:100rem;width:auto;justify-content:flex-start;flex-grow:1}/*!@:host ix-dropdown .dropdown-item-container .dropdown-item:not(.disabled):not(:disabled):focus-visible*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .dropdown-item-container.sc-ix-category-filter .dropdown-item.sc-ix-category-filter:not(.disabled):not(:disabled):focus-visible{border-color:var(--theme-color-focus-bdr)}/*!@:host ix-dropdown .dropdown-item-container .category-item*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .dropdown-item-container.sc-ix-category-filter .category-item.sc-ix-category-filter{border-end-end-radius:0;border-start-end-radius:0}/*!@:host ix-dropdown .dropdown-item-container .category-item-value*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .dropdown-item-container.sc-ix-category-filter .category-item-value.sc-ix-category-filter{border-start-start-radius:0;border-end-start-radius:0}/*!@:host ix-dropdown .btn-toggle-operator*/.sc-ix-category-filter-h ix-dropdown.sc-ix-category-filter .btn-toggle-operator.sc-ix-category-filter{width:2rem;height:2rem;margin-inline:0.5rem}/*!@:host .d-none*/.sc-ix-category-filter-h .d-none.sc-ix-category-filter{display:none}";
var IxCategoryFilterStyle0 = categoryFilterCss;

class CategoryFilter {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.categoryChanged = createEvent(this, "categoryChanged", 7);
        this.inputChanged = createEvent(this, "inputChanged", 7);
        this.filterChanged = createEvent(this, "filterChanged", 7);
        this.ID_CUSTOM_FILTER_VALUE = 'CW_CUSTOM_FILTER_VALUE';
        this.showDropdown = undefined;
        this.textInput = undefined;
        this.hasFocus = undefined;
        this.categoryLogicalOperator = LogicalFilterOperator.EQUAL;
        this.inputValue = undefined;
        this.category = undefined;
        this.filterTokens = [];
        this.disabled = false;
        this.readonly = false;
        this.filterState = undefined;
        this.placeholder = undefined;
        this.categories = undefined;
        this.nonSelectableCategories = {};
        this.suggestions = undefined;
        this.icon = 'search';
        this.hideIcon = false;
        this.staticOperator = undefined;
        this.repeatCategories = true;
        this.tmpDisableScrollIntoView = true;
        this.labelCategories = 'Categories';
        this.i18nPlainText = 'Filter by text';
    }
    get dropdown() {
        return this.hostElement.shadowRoot.querySelector('ix-dropdown');
    }
    watchFilterState(newValue) {
        this.setFilterState(newValue);
    }
    componentDidLoad() {
        var _a, _b;
        if (this.filterState !== undefined) {
            setTimeout(() => this.setFilterState(this.filterState));
        }
        (_a = this.hostElement) === null || _a === void 0 ? void 0 : _a.addEventListener('keydown', this.handleFormElementKeyDown.bind(this));
        (_b = this.formElement) === null || _b === void 0 ? void 0 : _b.addEventListener('submit', (e) => e.preventDefault());
        if (this.textInput == null) {
            console.warn('ix-category-filter - unable to add event listeners to native input element');
            return;
        }
        this.textInput.addEventListener('focusin', () => {
            this.hasFocus = true;
        });
        this.textInput.addEventListener('focusout', () => (this.hasFocus = false));
        this.textInput.addEventListener('input', () => {
            this.inputValue = this.textInput.value;
            const inputState = new InputState(this.inputValue, this.category);
            this.inputChanged.emit(inputState);
            if (!this.dropdown.show) {
                this.openDropdown();
            }
        });
        this.textInput.addEventListener('keydown', this.handleInputElementKeyDown.bind(this));
    }
    setFilterState(state) {
        this.filterTokens = [];
        for (const token of state.tokens) {
            this.addToken(token, this.ID_CUSTOM_FILTER_VALUE, this.categoryLogicalOperator, false);
        }
        for (const category of state.categories) {
            this.addToken(category.value, category.id, category.operator, false);
        }
        this.emitFilterEvent();
    }
    closeDropdown() {
        if (this.disabled || this.readonly) {
            return;
        }
        this.dropdown.show = false;
    }
    openDropdown() {
        if (this.disabled || this.readonly) {
            return;
        }
        this.dropdown.show = true;
    }
    handleFormElementKeyDown(e) {
        switch (e.code) {
            case 'Enter':
            case 'NumpadEnter':
                if (!document.activeElement.classList.contains('dropdown-item')) {
                    return;
                }
                const token = document.activeElement.getAttribute('data-id');
                if (this.hasCategorySelection()) {
                    if (this.category !== undefined) {
                        this.addToken(token, this.category);
                    }
                    else if (document.activeElement.classList.contains('category-item-id')) {
                        this.selectCategory(token);
                    }
                }
                else {
                    this.addToken(token);
                }
                e.preventDefault();
                break;
            case 'ArrowUp':
                this.focusPreviousItem();
                e.preventDefault();
                break;
            case 'ArrowDown':
                this.showDropdown = true;
                this.focusNextItem();
                e.preventDefault();
                break;
            case 'Escape':
                this.closeDropdown();
                break;
        }
    }
    focusPreviousItem() {
        const sibling = document.activeElement.previousSibling;
        if (sibling instanceof HTMLElement) {
            sibling.focus();
        }
    }
    focusNextItem() {
        const sibling = document.activeElement.nextSibling;
        if (sibling instanceof HTMLElement) {
            sibling.focus();
        }
    }
    handleInputElementKeyDown(e) {
        var _a;
        switch (e.code) {
            case 'ArrowDown':
                const selector = `.category-item-${this.category !== undefined ? 'value' : 'id'}`;
                let item = this.hostElement.shadowRoot.querySelector(selector);
                if (item instanceof HTMLElement) {
                    item.focus();
                    e.stopPropagation();
                }
                else if ((_a = this.suggestions) === null || _a === void 0 ? void 0 : _a.length) {
                    item = this.hostElement.shadowRoot.querySelector('.category-item');
                    if (item instanceof HTMLElement) {
                        item.focus();
                        e.stopPropagation();
                    }
                }
                break;
            case 'Backspace':
                if (this.textInput.value !== '') {
                    return;
                }
                if (this.category !== undefined) {
                    this.category = undefined;
                    return;
                }
                const tokenCount = this.filterTokens.length;
                if (tokenCount > 0) {
                    this.removeToken(tokenCount - 1);
                }
                break;
            case 'Enter':
            case 'NumpadEnter':
                this.addToken(this.inputValue, this.category);
                e.preventDefault();
                break;
        }
    }
    emitFilterEvent() {
        const tokens = this.filterTokens
            .filter((item) => item.id === this.ID_CUSTOM_FILTER_VALUE)
            .map((item) => item.value);
        const categories = this.filterTokens.filter((item) => item.id !== this.ID_CUSTOM_FILTER_VALUE);
        const filterState = {
            tokens,
            categories,
        };
        this.filterChanged.emit(filterState);
    }
    addToken(token, category = this.ID_CUSTOM_FILTER_VALUE, operator = this.categoryLogicalOperator, emitEvent = true) {
        if (token === undefined || token === null) {
            return;
        }
        const newToken = token.trim();
        if (newToken === '') {
            return;
        }
        if (this.hasToken(newToken)) {
            return;
        }
        const pair = { id: category, value: newToken, operator };
        this.filterTokens = [...this.filterTokens, pair];
        this.textInput.value = '';
        this.inputValue = '';
        this.categoryLogicalOperator = LogicalFilterOperator.EQUAL;
        if (this.category !== undefined) {
            this.category = undefined;
        }
        this.isScrollStateDirty = true;
        this.textInput.focus();
        if (emitEvent) {
            this.emitFilterEvent();
        }
    }
    removeToken(index) {
        this.filterTokens = this.filterTokens.filter((_, i) => i !== index);
        this.emitFilterEvent();
    }
    getCategoryIds() {
        const ids = [];
        for (const id in this.categories) {
            if (Object.prototype.hasOwnProperty.call(this.categories, id)) {
                ids.push(id);
            }
        }
        return ids;
    }
    selectCategory(category) {
        this.category = category;
        this.textInput.value = '';
        this.inputValue = '';
        this.textInput.focus();
        this.categoryChanged.emit(category);
    }
    resetFilter(e) {
        e.stopPropagation();
        this.closeDropdown();
        this.filterTokens = [];
        if (this.category) {
            this.category = undefined;
            this.categoryChanged.emit(this.category);
        }
        this.emitFilterEvent();
    }
    filterMultiples(value) {
        if (this.repeatCategories) {
            return true;
        }
        const isCategoryAlreadySet = this.filterTokens.find((token) => token.id === value);
        return !isCategoryAlreadySet;
    }
    hasToken(token) {
        return this.filterTokens.some((filterToken) => {
            const hasSameValue = filterToken.value === token;
            if (!hasSameValue) {
                return false;
            }
            if (this.category !== undefined) {
                return this.category === filterToken.id;
            }
            if (filterToken.id) {
                return filterToken.id === this.ID_CUSTOM_FILTER_VALUE;
            }
            return hasSameValue;
        });
    }
    filterDuplicateTokens(value) {
        return !this.hasToken(value);
    }
    filterByInput(value) {
        if (this.inputValue === undefined || this.inputValue === '') {
            return true;
        }
        return value.toLowerCase().indexOf(this.inputValue.toLowerCase()) !== -1;
    }
    toggleCategoryOperator() {
        switch (this.categoryLogicalOperator) {
            case LogicalFilterOperator.EQUAL:
                this.categoryLogicalOperator = LogicalFilterOperator.NOT_EQUAL;
                break;
            case LogicalFilterOperator.NOT_EQUAL:
                this.categoryLogicalOperator = LogicalFilterOperator.EQUAL;
                break;
        }
    }
    getFilterChipLabel(value) {
        var _a, _b, _c;
        if (value.id === this.ID_CUSTOM_FILTER_VALUE) {
            return value.value;
        }
        const operatorString = value.operator === LogicalFilterOperator.EQUAL ? '=' : '!=';
        const label = (_c = (_b = (_a = this.categories[value.id]) === null || _a === void 0 ? void 0 : _a.label) !== null && _b !== void 0 ? _b : this.nonSelectableCategories[value.id]) !== null && _c !== void 0 ? _c : value.id;
        return `${label} ${operatorString} ${value.value}`;
    }
    getFilteredSuggestions() {
        var _a, _b;
        if (!((_a = this.suggestions) === null || _a === void 0 ? void 0 : _a.length)) {
            return [];
        }
        return (_b = this.suggestions) === null || _b === void 0 ? void 0 : _b.filter((value) => this.filterByInput(value)).filter((value) => this.filterDuplicateTokens(value));
    }
    hasCategorySelection() {
        return this.categories !== undefined;
    }
    renderPlainSuggestions() {
        return (hAsync("div", { class: "dropdown-item-container" }, this.getFilteredSuggestions().map((suggestion) => (hAsync("button", { class: "dropdown-item", "data-id": suggestion, onClick: () => this.addToken(suggestion), key: suggestion, title: suggestion }, suggestion)))));
    }
    renderOperatorButton() {
        if (this.staticOperator) {
            return '';
        }
        const params = {
            type: 'button',
            variant: 'secondary',
            outline: false,
            ghost: true,
            iconOnly: true,
            iconOval: false,
            selected: false,
            disabled: this.disabled || this.staticOperator !== undefined,
            loading: false,
            icon: '',
            onClick: (e) => {
                e.stopPropagation();
                this.toggleCategoryOperator();
            },
            extraClasses: {
                'btn-icon-32': true,
                'btn-toggle-operator': true,
            },
        };
        return (hAsync(BaseButton, Object.assign({}, params), this.categoryLogicalOperator === LogicalFilterOperator.NOT_EQUAL
            ? '='
            : '!='));
    }
    getFilterOperatorString() {
        let operator;
        if (this.staticOperator !== undefined) {
            operator = this.staticOperator;
        }
        else {
            operator = this.categoryLogicalOperator;
        }
        return `${operator === LogicalFilterOperator.EQUAL ? '=' : '!='} `;
    }
    renderCategoryValues() {
        var _a, _b;
        return (hAsync("div", { class: "dropdown-item-container" }, this.renderOperatorButton(), hAsync("div", { class: "dropdown-header" }, (_a = this.categories[this.category]) === null || _a === void 0 ? void 0 : _a.label), (_b = this.categories[this.category]) === null || _b === void 0 ? void 0 :
            _b.options.filter((value) => this.filterByInput(value)).filter((value) => this.filterDuplicateTokens(value)).map((id) => (hAsync("button", { class: "dropdown-item category-item-value", "data-id": id, title: id, key: id, onClick: (e) => {
                    e.preventDefault();
                    this.addToken(id, this.category);
                } }, `${this.getFilterOperatorString()} ${id}`)))));
    }
    renderDropdownContent() {
        if (this.hasCategorySelection()) {
            if (this.category !== undefined) {
                return this.renderCategoryValues();
            }
            else {
                return this.renderCategorySelection();
            }
        }
        else
            return this.renderPlainSuggestions();
    }
    renderCategorySelection() {
        var _a;
        return (hAsync("div", { class: "dropdown-item-container" }, (_a = this.getCategoryIds()) === null || _a === void 0 ? void 0 : _a.filter((id) => this.filterByInput(this.categories[id].label)).filter((id) => this.filterMultiples(id)).map((id) => {
            var _a;
            return (hAsync("button", { class: "dropdown-item category-item category-item-id", "data-id": id, title: this.categories[id].label, key: id, onClick: (e) => {
                    e.preventDefault();
                    this.selectCategory(id);
                }, tabindex: "0" }, (_a = this.categories[id]) === null || _a === void 0 ? void 0 : _a.label));
        })));
    }
    getDropdownHeader() {
        if (this.categories !== undefined) {
            if (this.category !== undefined) {
                return null;
            }
            else {
                return this.labelCategories;
            }
        }
        return this.i18nPlainText;
    }
    componentDidRender() {
        if (this.isScrollStateDirty) {
            if (!this.tmpDisableScrollIntoView) {
                this.textInput.scrollIntoView();
            }
            this.isScrollStateDirty = false;
        }
    }
    getResetButton() {
        return (hAsync("ix-icon-button", { onClick: (e) => this.resetFilter(e), class: {
                'reset-button': true,
                'hide-reset-button': !this.filterTokens.length && this.category === undefined,
            }, ghost: true, oval: true, icon: 'clear', size: "16" }));
    }
    getIconColor() {
        if (this.disabled) {
            return 'color-componentn-1';
        }
        if (this.readonly) {
            return 'color-std-txt';
        }
        return 'color-primary';
    }
    render() {
        var _a;
        return (hAsync(Host, { key: 'b67d46f80076d8f5b9054e55e203d887337ec473' }, hAsync("form", { key: 'bb191e83cd3f763e7e499b0755e2b1f64bf28bfc', ref: (el) => (this.formElement = el) }, hAsync("div", { key: '8505dcfd3334b0f4f1ca6ab295c9ca92c16cdf6b', "read-only": this.readonly, class: {
                'input-container': true,
                disabled: this.disabled,
                focus: this.hasFocus,
                readonly: this.readonly,
                'no-icon': this.hideIcon,
            } }, hAsync("ix-icon", { key: '74a4adbe6ed8ad59dd4931f89a755e87f09b98a1', color: this.getIconColor(), class: { 'd-none': this.hideIcon }, name: this.icon, size: "16" }), hAsync("div", { key: 'a9f3429de8aec546ccf5ac10bd4047ee38a9df51', class: "token-container" }, hAsync("ul", { key: '2ac4037d9f2c8a5c7f1e224999ff6643443dd46c', class: "list-unstyled" }, this.filterTokens.map((value, index) => (hAsync("li", { key: value.toString(), class: {
                animate__animated: true,
                animate__fadein: true,
            } }, hAsync("ix-filter-chip", { disabled: this.disabled, readonly: this.readonly, onClick: (e) => e.stopPropagation(), onCloseClick: () => this.removeToken(index) }, this.getFilterChipLabel(value))))), this.categories === undefined ? ('') : (hAsync("li", { class: {
                'category-preview': true,
                'd-none': this.category === undefined,
            } }, (_a = this.categories[this.category]) === null || _a === void 0 ? void 0 : _a.label)), hAsync("input", { key: '82f12ea3f63509e6275e1ebbea29240a734aeba6', class: {
                'text-input': true,
                'hide-placeholder': this.readonly ||
                    this.disabled ||
                    this.category !== undefined,
            }, autocomplete: "off", name: "category-filter-input", disabled: this.disabled, readonly: this.readonly, ref: (el) => (this.textInput = el), type: "text", placeholder: this.placeholder }))), !this.readonly && !this.disabled && this.getResetButton())), this.disabled || this.readonly ? ('') : (hAsync("ix-dropdown", { show: this.showDropdown, closeBehavior: "outside", offset: { mainAxis: 2 }, anchor: this.textInput, trigger: this.hostElement, header: this.getDropdownHeader() }, this.renderDropdownContent()))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "filterState": ["watchFilterState"]
    }; }
    static get style() { return IxCategoryFilterStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-category-filter",
        "$members$": {
            "disabled": [4],
            "readonly": [4],
            "filterState": [16],
            "placeholder": [1],
            "categories": [16],
            "nonSelectableCategories": [16],
            "suggestions": [16],
            "icon": [1],
            "hideIcon": [4, "hide-icon"],
            "staticOperator": [1, "static-operator"],
            "repeatCategories": [4, "repeat-categories"],
            "tmpDisableScrollIntoView": [4, "tmp-disable-scroll-into-view"],
            "labelCategories": [1, "label-categories"],
            "i18nPlainText": [1, "i-1-8n-plain-text"],
            "showDropdown": [32],
            "textInput": [32],
            "hasFocus": [32],
            "categoryLogicalOperator": [32],
            "inputValue": [32],
            "category": [32],
            "filterTokens": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const chipCss = "/*!@:host*/.sc-ix-chip-h{display:inline-block;position:relative;height:2rem;max-height:2rem;margin-left:0.25rem}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-chip-h *.sc-ix-chip,.sc-ix-chip-h *.sc-ix-chip::after,.sc-ix-chip-h *.sc-ix-chip::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-chip-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-chip-h .sc-ix-chip::-webkit-scrollbar-corner{display:none}/*!@:host(.inactive)*/.inactive.sc-ix-chip-h{pointer-events:none}/*!@.container*/.container.sc-ix-chip{display:inline-flex;width:inherit;box-sizing:border-box;position:relative;align-items:center;border-radius:100px;padding:0.5rem;height:2rem;max-height:2rem;cursor:pointer}/*!@.container .with-icon*/.container.sc-ix-chip .with-icon.sc-ix-chip{margin-right:0.25rem}/*!@.container .hidden*/.container.sc-ix-chip .hidden.sc-ix-chip{display:none;width:0;margin-right:0}/*!@.container .close-button-container*/.container.sc-ix-chip .close-button-container.sc-ix-chip{display:inline-flex;margin-left:auto;padding-left:0.5rem}/*!@.container .slot-container*/.container.sc-ix-chip .slot-container.sc-ix-chip{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}/*!@.container.outline.icon*/.container.outline.icon.sc-ix-chip{padding-left:calc(0.75rem - 1px)}/*!@.container.outline:not(.icon)*/.container.outline.sc-ix-chip:not(.icon){padding-left:calc(0.5rem - 1px)}/*!@.container.outline.closable:not(.inactive)*/.container.outline.closable.sc-ix-chip:not(.inactive){padding-right:calc(0.25rem - 1px)}/*!@.container.outline.closable.inactive, .container.outline:not(.closable)*/.container.outline.closable.inactive.sc-ix-chip,.container.outline.sc-ix-chip:not(.closable){padding-right:calc(0.5rem - 1px)}/*!@.container.outline.icon:not(.closable)*/.container.outline.icon.sc-ix-chip:not(.closable){padding-right:calc(0.75rem - 1px)}/*!@.container:not(.outline).icon*/.container.sc-ix-chip:not(.outline).icon{padding-left:0.75rem}/*!@.container:not(.outline):not(.icon)*/.container.sc-ix-chip:not(.outline):not(.icon){padding-left:0.5rem}/*!@.container:not(.outline).closable:not(.inactive)*/.container.sc-ix-chip:not(.outline).closable:not(.inactive){padding-right:0.25rem}/*!@.container:not(.outline).closable.inactive*/.container.sc-ix-chip:not(.outline).closable.inactive{padding-right:0.5rem}/*!@.container:not(.outline):not(.closable).icon*/.container.sc-ix-chip:not(.outline):not(.closable).icon{padding-right:0.75rem}/*!@.container:not(.outline):not(.closable):not(.icon)*/.container.sc-ix-chip:not(.outline):not(.closable):not(.icon){padding-right:0.5rem}/*!@.container.primary*/.container.primary.sc-ix-chip{background-color:var(--theme-color-primary);color:var(--theme-chip-primary--color)}/*!@.container.primary .close-button*/.container.primary.sc-ix-chip .close-button.sc-ix-chip{color:var(--theme-chip-primary--color);--ix-icon-button-color:var(--theme-chip-primary--color);pointer-events:auto}/*!@.container.primary:hover*/.container.primary.sc-ix-chip:hover{background-color:var(--theme-chip-primary--background--hover)}/*!@.container.primary:active*/.container.primary.sc-ix-chip:active{background-color:var(--theme-chip-primary--background--active)}/*!@.container.primary:focus-visible*/.container.primary.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.primary.outline*/.container.primary.outline.sc-ix-chip{color:var(--theme-chip-primary-outline--color);background-color:transparent;border:solid 1px var(--theme-chip-primary-outline--border-color)}/*!@.container.primary.outline .close-button*/.container.primary.outline.sc-ix-chip .close-button.sc-ix-chip{color:var(--theme-chip-primary-outline--color);--ix-icon-button-color:var(--theme-chip-primary-outline--color)}/*!@.container.primary.outline:hover*/.container.primary.outline.sc-ix-chip:hover{background-color:var(--theme-chip-primary-outline--background--hover)}/*!@.container.primary.outline:active*/.container.primary.outline.sc-ix-chip:active{background-color:var(--theme-chip-primary-outline--background--active)}/*!@.container.outline*/.container.outline.sc-ix-chip{border-width:1px;border-style:solid}/*!@.container.alarm*/.container.alarm.sc-ix-chip{color:var(--theme-color-alarm--contrast)}/*!@.container.alarm:hover::after*/.container.alarm.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.alarm.active::after, .container.alarm:active::after*/.container.alarm.active.sc-ix-chip::after,.container.alarm.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.alarm:not(.outline)*/.container.alarm.sc-ix-chip:not(.outline){background-color:var(--theme-color-alarm)}/*!@.container.alarm:not(.outline) .close-button*/.container.alarm.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-alarm--contrast);--ix-icon-button-color:var(--theme-color-alarm--contrast)}/*!@.container.alarm:not(.outline):hover::after*/.container.alarm.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.alarm:not(.outline).active::after, .container.alarm:not(.outline):active::after*/.container.alarm.sc-ix-chip:not(.outline).active::after,.container.alarm.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.alarm.outline*/.container.alarm.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-alarm)}/*!@.container.alarm.outline:hover::after*/.container.alarm.outline.sc-ix-chip:hover::after{display:none}/*!@.container.alarm.outline:hover*/.container.alarm.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.alarm.outline.active::after, .container.alarm.outline:active::after*/.container.alarm.outline.active.sc-ix-chip::after,.container.alarm.outline.sc-ix-chip:active::after{display:none}/*!@.container.alarm.outline.active, .container.alarm.outline:active*/.container.alarm.outline.active.sc-ix-chip,.container.alarm.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.alarm:focus-visible*/.container.alarm.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.critical*/.container.critical.sc-ix-chip{color:var(--theme-color-critical--contrast)}/*!@.container.critical:hover::after*/.container.critical.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.critical.active::after, .container.critical:active::after*/.container.critical.active.sc-ix-chip::after,.container.critical.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.critical:not(.outline)*/.container.critical.sc-ix-chip:not(.outline){background-color:var(--theme-color-critical)}/*!@.container.critical:not(.outline) .close-button*/.container.critical.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-critical--contrast);--ix-icon-button-color:var(--theme-color-critical--contrast)}/*!@.container.critical:not(.outline):hover::after*/.container.critical.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.critical:not(.outline).active::after, .container.critical:not(.outline):active::after*/.container.critical.sc-ix-chip:not(.outline).active::after,.container.critical.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.critical.outline*/.container.critical.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-critical)}/*!@.container.critical.outline:hover::after*/.container.critical.outline.sc-ix-chip:hover::after{display:none}/*!@.container.critical.outline:hover*/.container.critical.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.critical.outline.active::after, .container.critical.outline:active::after*/.container.critical.outline.active.sc-ix-chip::after,.container.critical.outline.sc-ix-chip:active::after{display:none}/*!@.container.critical.outline.active, .container.critical.outline:active*/.container.critical.outline.active.sc-ix-chip,.container.critical.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.critical:focus-visible*/.container.critical.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.warning*/.container.warning.sc-ix-chip{color:var(--theme-color-warning--contrast)}/*!@.container.warning:hover::after*/.container.warning.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.warning.active::after, .container.warning:active::after*/.container.warning.active.sc-ix-chip::after,.container.warning.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.warning:not(.outline)*/.container.warning.sc-ix-chip:not(.outline){background-color:var(--theme-color-warning)}/*!@.container.warning:not(.outline) .close-button*/.container.warning.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-warning--contrast);--ix-icon-button-color:var(--theme-color-warning--contrast)}/*!@.container.warning:not(.outline):hover::after*/.container.warning.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.warning:not(.outline).active::after, .container.warning:not(.outline):active::after*/.container.warning.sc-ix-chip:not(.outline).active::after,.container.warning.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.warning.outline*/.container.warning.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-warning)}/*!@.container.warning.outline:hover::after*/.container.warning.outline.sc-ix-chip:hover::after{display:none}/*!@.container.warning.outline:hover*/.container.warning.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.warning.outline.active::after, .container.warning.outline:active::after*/.container.warning.outline.active.sc-ix-chip::after,.container.warning.outline.sc-ix-chip:active::after{display:none}/*!@.container.warning.outline.active, .container.warning.outline:active*/.container.warning.outline.active.sc-ix-chip,.container.warning.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.warning:focus-visible*/.container.warning.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.info*/.container.info.sc-ix-chip{color:var(--theme-color-info--contrast)}/*!@.container.info:hover::after*/.container.info.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.info.active::after, .container.info:active::after*/.container.info.active.sc-ix-chip::after,.container.info.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.info:not(.outline)*/.container.info.sc-ix-chip:not(.outline){background-color:var(--theme-color-info)}/*!@.container.info:not(.outline) .close-button*/.container.info.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-info--contrast);--ix-icon-button-color:var(--theme-color-info--contrast)}/*!@.container.info:not(.outline):hover::after*/.container.info.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.info:not(.outline).active::after, .container.info:not(.outline):active::after*/.container.info.sc-ix-chip:not(.outline).active::after,.container.info.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.info.outline*/.container.info.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-info)}/*!@.container.info.outline:hover::after*/.container.info.outline.sc-ix-chip:hover::after{display:none}/*!@.container.info.outline:hover*/.container.info.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.info.outline.active::after, .container.info.outline:active::after*/.container.info.outline.active.sc-ix-chip::after,.container.info.outline.sc-ix-chip:active::after{display:none}/*!@.container.info.outline.active, .container.info.outline:active*/.container.info.outline.active.sc-ix-chip,.container.info.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.info:focus-visible*/.container.info.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.neutral*/.container.neutral.sc-ix-chip{color:var(--theme-color-neutral--contrast)}/*!@.container.neutral:hover::after*/.container.neutral.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.neutral.active::after, .container.neutral:active::after*/.container.neutral.active.sc-ix-chip::after,.container.neutral.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.neutral:not(.outline)*/.container.neutral.sc-ix-chip:not(.outline){background-color:var(--theme-color-neutral)}/*!@.container.neutral:not(.outline) .close-button*/.container.neutral.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-neutral--contrast);--ix-icon-button-color:var(--theme-color-neutral--contrast)}/*!@.container.neutral:not(.outline):hover::after*/.container.neutral.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.neutral:not(.outline).active::after, .container.neutral:not(.outline):active::after*/.container.neutral.sc-ix-chip:not(.outline).active::after,.container.neutral.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.neutral.outline*/.container.neutral.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-neutral)}/*!@.container.neutral.outline:hover::after*/.container.neutral.outline.sc-ix-chip:hover::after{display:none}/*!@.container.neutral.outline:hover*/.container.neutral.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.neutral.outline.active::after, .container.neutral.outline:active::after*/.container.neutral.outline.active.sc-ix-chip::after,.container.neutral.outline.sc-ix-chip:active::after{display:none}/*!@.container.neutral.outline.active, .container.neutral.outline:active*/.container.neutral.outline.active.sc-ix-chip,.container.neutral.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.neutral:focus-visible*/.container.neutral.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}/*!@.container.success*/.container.success.sc-ix-chip{color:var(--theme-color-success--contrast)}/*!@.container.success:hover::after*/.container.success.sc-ix-chip:hover::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.05);left:0;border-radius:100px;pointer-events:none}/*!@.container.success.active::after, .container.success:active::after*/.container.success.active.sc-ix-chip::after,.container.success.sc-ix-chip:active::after{content:\"\";display:block;position:absolute;width:100%;height:100%;background-color:rgba(0, 0, 0, 0.1);left:0;border-radius:100px;pointer-events:none}/*!@.container.success:not(.outline)*/.container.success.sc-ix-chip:not(.outline){background-color:var(--theme-color-success)}/*!@.container.success:not(.outline) .close-button*/.container.success.sc-ix-chip:not(.outline) .close-button.sc-ix-chip{color:var(--theme-color-success--contrast);--ix-icon-button-color:var(--theme-color-success--contrast)}/*!@.container.success:not(.outline):hover::after*/.container.success.sc-ix-chip:not(.outline):hover::after{content:\"\";background-color:rgba(0, 0, 0, 0.05)}/*!@.container.success:not(.outline).active::after, .container.success:not(.outline):active::after*/.container.success.sc-ix-chip:not(.outline).active::after,.container.success.sc-ix-chip:not(.outline):active::after{background-color:rgba(0, 0, 0, 0.1)}/*!@.container.success.outline*/.container.success.outline.sc-ix-chip{color:var(--theme-chip-outline--color);border-color:var(--theme-color-success)}/*!@.container.success.outline:hover::after*/.container.success.outline.sc-ix-chip:hover::after{display:none}/*!@.container.success.outline:hover*/.container.success.outline.sc-ix-chip:hover{background-color:var(--theme-chip-outline--background--hover)}/*!@.container.success.outline.active::after, .container.success.outline:active::after*/.container.success.outline.active.sc-ix-chip::after,.container.success.outline.sc-ix-chip:active::after{display:none}/*!@.container.success.outline.active, .container.success.outline:active*/.container.success.outline.active.sc-ix-chip,.container.success.outline.sc-ix-chip:active{background-color:var(--theme-chip-outline--background--active)}/*!@.container.success:focus-visible*/.container.success.sc-ix-chip:focus-visible{outline:1px solid #199fff;outline-offset:var(--theme-btn--focus--outline-offset)}";
var IxChipStyle0 = chipCss;

class Chip {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.closeChip = createEvent(this, "closeChip", 7);
        this.variant = 'primary';
        this.active = true;
        this.closable = false;
        this.icon = undefined;
        this.background = undefined;
        this.color = undefined;
        this.chipColor = undefined;
        this.outline = false;
    }
    getCloseButton() {
        var _a;
        return (hAsync("div", { class: "close-button-container" }, hAsync("ix-icon-button", { type: "button", variant: "secondary", icon: 'close-small', class: "close-button", oval: true, size: "16", style: this.variant === 'custom'
                ? { color: (_a = this.chipColor) !== null && _a !== void 0 ? _a : this.color }
                : {}, ghost: true, onClick: (event) => {
                this.closeChip.emit(event);
                event.stopPropagation();
            } })));
    }
    render() {
        var _a, _b;
        const isInactive = this.active === false;
        let customStyle = {};
        if (this.variant === 'custom') {
            customStyle = {
                color: (_a = this.chipColor) !== null && _a !== void 0 ? _a : this.color,
                [this.outline ? 'borderColor' : 'backgroundColor']: this.background,
            };
        }
        return (hAsync(Host, { key: 'bd5ac95ed2866d7781a08a1e3c6292f2104b0a85', tabIndex: "-1", title: this.el.textContent, style: this.variant === 'custom'
                ? {
                    '--ix-icon-button-color': (_b = this.chipColor) !== null && _b !== void 0 ? _b : this.color,
                }
                : {} }, hAsync("div", { key: '3601eb2dd1f1f970ed2779bf33d7c38214e61295', style: Object.assign({}, customStyle), class: {
                container: true,
                outline: this.outline,
                inactive: isInactive,
                alarm: this.variant === 'alarm',
                critical: this.variant === 'critical',
                info: this.variant === 'info',
                neutral: this.variant === 'neutral',
                primary: this.variant === 'primary',
                success: this.variant === 'success',
                warning: this.variant === 'warning',
                custom: this.variant === 'custom',
                closable: this.closable,
                icon: !!this.icon,
            } }, hAsync("ix-icon", { key: '01fb4eb0cf4c057fa074f6edc043bf71c6cb8db0', class: {
                'with-icon': true,
                hidden: !this.icon,
            }, name: this.icon, size: '24' }), hAsync("span", { key: 'e6088fa930b598833fb2a22b9a83c9e964e99a1d', class: "slot-container" }, hAsync("slot", { key: 'ac89d7796e7c083dc1ccb3d74018925d07e07ff5' })), isInactive === false && this.closable ? this.getCloseButton() : null)));
    }
    get el() { return getElement(this); }
    static get style() { return IxChipStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-chip",
        "$members$": {
            "variant": [513],
            "active": [4],
            "closable": [4],
            "icon": [1],
            "background": [1],
            "color": [1],
            "chipColor": [1, "chip-color"],
            "outline": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["variant", "variant"]]
    }; }
}

const colCss = "/*!@:host*/.sc-ix-col-h{position:relative;flex-basis:0;flex-grow:1;width:100%;max-width:100%;min-height:1px;padding:calc(var(--ix-layout-grid-gutter) * 0.5)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-col-h *.sc-ix-col,.sc-ix-col-h *.sc-ix-col::after,.sc-ix-col-h *.sc-ix-col::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-col-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-col-h .sc-ix-col::-webkit-scrollbar-corner{display:none}";
var IxColStyle0 = colCss;

/**
 * @since 2.0.0
 */
class Col {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.size = undefined;
        this.sizeSm = undefined;
        this.sizeMd = undefined;
        this.sizeLg = undefined;
    }
    onResize() {
    }
    getSize(breakpoint) {
        if (breakpoint === '') {
            return this.size;
        }
        if (breakpoint === 'sm') {
            return this.sizeSm;
        }
        if (breakpoint === 'md') {
            return this.sizeMd;
        }
        if (breakpoint === 'lg') {
            return this.sizeLg;
        }
    }
    getColumnSize() {
        let size;
        Col.Breakpoints.forEach((breakpoint) => {
            const isMediaQueryActive = breakpoint !== '' ? matchBreakpoint(breakpoint) : true;
            if (!isMediaQueryActive) {
                return;
            }
            const currentSize = this.getSize(breakpoint);
            if (currentSize) {
                size = currentSize;
            }
        });
        return size;
    }
    getColumnSizeStyling() {
        const size = this.getColumnSize();
        if (!size) {
            return;
        }
        if (size === 'auto') {
            return {
                flex: '0 0 auto',
                width: 'auto',
                'max-width': 'auto',
            };
        }
        const colSize = `calc(calc(${size} / var(--ix-layout-grid-columns)) * 100%)`;
        return {
            flex: `0 0 ${colSize}`,
            width: `${colSize}`,
            'max-width': `${colSize}`,
        };
    }
    render() {
        return (hAsync(Host, { key: '7cbf750f0768a0a1db65aa2651605c89f82ce604', style: Object.assign({}, this.getColumnSizeStyling()) }, hAsync("slot", { key: 'd83749089de332574097a8299c265d45b1fd8da7' })));
    }
    static get style() { return IxColStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-col",
        "$members$": {
            "size": [1],
            "sizeSm": [1, "size-sm"],
            "sizeMd": [1, "size-md"],
            "sizeLg": [1, "size-lg"]
        },
        "$listeners$": [[9, "resize", "onResize"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}
Col.Breakpoints = ['', 'sm', 'md', 'lg'];

const contentCss = "/*!@:host*/.sc-ix-content-h{display:flex;flex-direction:column;position:relative;padding:1.5rem 0rem 0.25rem 2rem;width:100%;height:100%;overflow:hidden}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-content-h *.sc-ix-content,.sc-ix-content-h *.sc-ix-content::after,.sc-ix-content-h *.sc-ix-content::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-content-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-content-h .sc-ix-content::-webkit-scrollbar-corner{display:none}/*!@:host .content*/.sc-ix-content-h .content.sc-ix-content{flex-grow:1;overflow:auto;padding-right:1.5rem}/*!@:host .content-header.slotted*/.sc-ix-content-h .content-header.slotted.sc-ix-content{margin-bottom:1rem;padding-right:1.5rem}";
var IxContentStyle0 = contentCss;

/**
 * @since 2.1.0
 * @slot header - Display content at the top of the content page
 */
class Content {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.isContentHeaderSlotted = false;
    }
    get contentHeaderSlot() {
        return this.hostElement.shadowRoot.querySelector('.content-header slot');
    }
    render() {
        return (hAsync(Host, { key: 'ec9339c22e534968a08739345bc7a701c202812b' }, hAsync("div", { key: '9565bdaba5d1f18f258c7c018bbf2f9a362a3965', class: {
                'content-header': true,
                slotted: this.isContentHeaderSlotted,
            } }, hAsync("slot", { key: '5be52eb4c6f16cb28aff6439c46bea5f95a554ca', name: "header", onSlotchange: () => {
                this.isContentHeaderSlotted = hasSlottedElements(this.contentHeaderSlot);
            } })), hAsync("div", { key: '6e52c4bc96f9e4611bdb66f3f8e0c0bd1d02390f', class: "content" }, hAsync("slot", { key: '284e7f2777f7640ac48658b4980cc9d3a40a1300' }))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxContentStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-content",
        "$members$": {
            "isContentHeaderSlotted": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const contentHeaderCss = "/*!@:host*/.sc-ix-content-header-h{display:flex;flex-direction:row;align-items:flex-start;padding:0px}/*!@:host .titleGroup*/.sc-ix-content-header-h .titleGroup.sc-ix-content-header{display:flex;flex-direction:column;flex:1 1 0%}/*!@:host .subtitle*/.sc-ix-content-header-h .subtitle.sc-ix-content-header{margin-top:0.5rem}/*!@:host .backButton*/.sc-ix-content-header-h .backButton.sc-ix-content-header{margin-right:0.5rem}/*!@:host .buttons*/.sc-ix-content-header-h .buttons.sc-ix-content-header{flex:0 0 auto}";
var IxContentHeaderStyle0 = contentHeaderCss;

class ContentHeader {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.backButtonClick = createEvent(this, "backButtonClick", 7);
        this.variant = 'primary';
        this.headerTitle = undefined;
        this.headerSubtitle = undefined;
        this.hasBackButton = false;
    }
    render() {
        return (hAsync(Host, { key: 'eae27014039b16c023892b60cc904609e55b89ad' }, this.hasBackButton ? (hAsync("ix-icon-button", { class: 'backButton', variant: "primary", icon: 'arrow-left', ghost: true, onClick: () => this.backButtonClick.emit() })) : null, hAsync("div", { key: '397be2503715bb15d260bcfada2260a8eb72e33b', class: "titleGroup" }, hAsync("ix-typography", { key: '5d08e001eb5178aaf4b089a4faa15bc759a43b6b', variant: this.variant === 'secondary' ? 'large-single' : 'h2' }, this.headerTitle), this.headerSubtitle !== undefined ? (hAsync("ix-typography", { variant: 'caption', color: 'soft', class: "subtitle" }, this.headerSubtitle)) : null), hAsync("div", { key: '6c6cc165c96307a6ee2c2bec59a80d6cd62a02cf', class: "buttons" }, hAsync("slot", { key: '0ac3730bb5ec852b127554e8dbdd73970204e275' }))));
    }
    static get style() { return IxContentHeaderStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-content-header",
        "$members$": {
            "variant": [1],
            "headerTitle": [1, "header-title"],
            "headerSubtitle": [1, "header-subtitle"],
            "hasBackButton": [4, "has-back-button"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function templateBuilder(inputTemplate) {
    let templateString = '';
    inputTemplate.forEach((row) => {
        templateString += '"';
        templateString = row.reduce((pV, cV) => {
            return `${pV} ${cV}`;
        }, templateString);
        templateString += '"\n';
    });
    return templateString;
}

const cssGridCss = "/*!@:host*/.sc-ix-css-grid-h{display:grid;position:relative;row-gap:1.5rem;-moz-column-gap:1.5rem;column-gap:1.5rem}";
var IxCssGridStyle0 = cssGridCss;

const smQuery = 'only screen and (max-width: 576px)';
const mdQuery = 'only screen and (max-width: 768px)';
const lgQuery = 'only screen and (max-width: 992px)';
const mediaQueryCollection = [
    { name: 'sm', query: smQuery },
    { name: 'md', query: mdQuery },
    { name: 'lg', query: lgQuery },
];
/**
 * @internal
 */
class CssGrid {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.disposeMediaQueryListener = [];
        this.mediaQueries = [];
        this.templates = undefined;
        this.currentTemplate = undefined;
    }
    componentWillRender() {
        this.mediaQueries = mediaQueryCollection.map((query) => {
            const mediaQuery = window.matchMedia(query.query);
            const callback = () => {
                this.applyTemplate();
            };
            this.disposeMediaQueryListener.push(callback);
            mediaQuery.addEventListener('change', callback);
            return Object.assign(Object.assign({}, query), { mediaQuery });
        });
        this.applyTemplate();
    }
    disconnectedCallback() {
        this.mediaQueries.forEach((mq, index) => {
            mq.mediaQuery.removeEventListener('change', this.disposeMediaQueryListener[index]);
        });
    }
    findNextTemplate(type) {
        const typeIndex = this.mediaQueries.findIndex((mq) => mq.name === type);
        const nextTemplate = this.templates[this.mediaQueries[typeIndex + 1].name];
        if (!nextTemplate) {
            return this.findNextTemplate(this.mediaQueries[typeIndex + 1].name);
        }
        return nextTemplate;
    }
    applyTemplate() {
        let active = this.mediaQueries.find((mq) => mq.mediaQuery.matches);
        if (!active) {
            active = this.mediaQueries[this.mediaQueries.length - 1];
        }
        const template = this.templates[active.name];
        if (template) {
            this.currentTemplate = template;
        }
        else {
            this.currentTemplate = this.findNextTemplate(active.name);
        }
    }
    render() {
        var _a;
        const style = {};
        if (((_a = this.currentTemplate) === null || _a === void 0 ? void 0 : _a.length) !== 0) {
            style['grid-template-areas'] = templateBuilder(this.currentTemplate);
        }
        return (hAsync(Host, { key: '31dbf56817566809d11389e2ee8eae5184ca31f4', style: style }, hAsync("slot", { key: '4573979348fcaac389e59014eb566ad0b7e4c005' })));
    }
    static get style() { return IxCssGridStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-css-grid",
        "$members$": {
            "templates": [16],
            "currentTemplate": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const cssGridItemCss = "/*!@:host*/.sc-ix-css-grid-item-h{display:block;position:relative}/*!@:host ::slotted(*)*/.sc-ix-css-grid-item-h .sc-ix-css-grid-item-s>*{height:100%;width:100%}";
var IxCssGridItemStyle0 = cssGridItemCss;

/**
 * @internal
 */
class CssGridItem {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.itemName = undefined;
    }
    render() {
        const style = {};
        style['grid-area'] = this.itemName;
        return (hAsync(Host, { key: '37fe2b4f8e0cf56e7e38197098b2e608b4b54bce', style: style }, hAsync("slot", { key: 'e59e0f9db976f30235ccd2488a992292320ce19f' })));
    }
    static get style() { return IxCssGridItemStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-css-grid-item",
        "$members$": {
            "itemName": [1, "item-name"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function commonjsRequire (path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var luxon = {};

Object.defineProperty(luxon, '__esModule', { value: true });

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct.bind();
  } else {
    _construct = function _construct(Parent, args, Class) {
      var a = [null];
      a.push.apply(a, args);
      var Constructor = Function.bind.apply(Parent, a);
      var instance = new Constructor();
      if (Class) _setPrototypeOf(instance, Class.prototype);
      return instance;
    };
  }
  return _construct.apply(null, arguments);
}
function _isNativeFunction(fn) {
  return Function.toString.call(fn).indexOf("[native code]") !== -1;
}
function _wrapNativeSuper(Class) {
  var _cache = typeof Map === "function" ? new Map() : undefined;
  _wrapNativeSuper = function _wrapNativeSuper(Class) {
    if (Class === null || !_isNativeFunction(Class)) return Class;
    if (typeof Class !== "function") {
      throw new TypeError("Super expression must either be null or a function");
    }
    if (typeof _cache !== "undefined") {
      if (_cache.has(Class)) return _cache.get(Class);
      _cache.set(Class, Wrapper);
    }
    function Wrapper() {
      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
    }
    Wrapper.prototype = Object.create(Class.prototype, {
      constructor: {
        value: Wrapper,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    return _setPrototypeOf(Wrapper, Class);
  };
  return _wrapNativeSuper(Class);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
function _createForOfIteratorHelperLoose(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (it) return (it = it.call(o)).next.bind(it);
  if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
    if (it) o = it;
    var i = 0;
    return function () {
      if (i >= o.length) return {
        done: true
      };
      return {
        done: false,
        value: o[i++]
      };
    };
  }
  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}

// these aren't really private, but nor are they really useful to document
/**
 * @private
 */
var LuxonError = /*#__PURE__*/function (_Error) {
  _inheritsLoose(LuxonError, _Error);
  function LuxonError() {
    return _Error.apply(this, arguments) || this;
  }
  return LuxonError;
}( /*#__PURE__*/_wrapNativeSuper(Error));
/**
 * @private
 */
var InvalidDateTimeError = /*#__PURE__*/function (_LuxonError) {
  _inheritsLoose(InvalidDateTimeError, _LuxonError);
  function InvalidDateTimeError(reason) {
    return _LuxonError.call(this, "Invalid DateTime: " + reason.toMessage()) || this;
  }
  return InvalidDateTimeError;
}(LuxonError);

/**
 * @private
 */
var InvalidIntervalError = /*#__PURE__*/function (_LuxonError2) {
  _inheritsLoose(InvalidIntervalError, _LuxonError2);
  function InvalidIntervalError(reason) {
    return _LuxonError2.call(this, "Invalid Interval: " + reason.toMessage()) || this;
  }
  return InvalidIntervalError;
}(LuxonError);

/**
 * @private
 */
var InvalidDurationError = /*#__PURE__*/function (_LuxonError3) {
  _inheritsLoose(InvalidDurationError, _LuxonError3);
  function InvalidDurationError(reason) {
    return _LuxonError3.call(this, "Invalid Duration: " + reason.toMessage()) || this;
  }
  return InvalidDurationError;
}(LuxonError);

/**
 * @private
 */
var ConflictingSpecificationError = /*#__PURE__*/function (_LuxonError4) {
  _inheritsLoose(ConflictingSpecificationError, _LuxonError4);
  function ConflictingSpecificationError() {
    return _LuxonError4.apply(this, arguments) || this;
  }
  return ConflictingSpecificationError;
}(LuxonError);

/**
 * @private
 */
var InvalidUnitError = /*#__PURE__*/function (_LuxonError5) {
  _inheritsLoose(InvalidUnitError, _LuxonError5);
  function InvalidUnitError(unit) {
    return _LuxonError5.call(this, "Invalid unit " + unit) || this;
  }
  return InvalidUnitError;
}(LuxonError);

/**
 * @private
 */
var InvalidArgumentError = /*#__PURE__*/function (_LuxonError6) {
  _inheritsLoose(InvalidArgumentError, _LuxonError6);
  function InvalidArgumentError() {
    return _LuxonError6.apply(this, arguments) || this;
  }
  return InvalidArgumentError;
}(LuxonError);

/**
 * @private
 */
var ZoneIsAbstractError = /*#__PURE__*/function (_LuxonError7) {
  _inheritsLoose(ZoneIsAbstractError, _LuxonError7);
  function ZoneIsAbstractError() {
    return _LuxonError7.call(this, "Zone is an abstract class") || this;
  }
  return ZoneIsAbstractError;
}(LuxonError);

/**
 * @private
 */

var n = "numeric",
  s = "short",
  l = "long";
var DATE_SHORT = {
  year: n,
  month: n,
  day: n
};
var DATE_MED = {
  year: n,
  month: s,
  day: n
};
var DATE_MED_WITH_WEEKDAY = {
  year: n,
  month: s,
  day: n,
  weekday: s
};
var DATE_FULL = {
  year: n,
  month: l,
  day: n
};
var DATE_HUGE = {
  year: n,
  month: l,
  day: n,
  weekday: l
};
var TIME_SIMPLE = {
  hour: n,
  minute: n
};
var TIME_WITH_SECONDS = {
  hour: n,
  minute: n,
  second: n
};
var TIME_WITH_SHORT_OFFSET = {
  hour: n,
  minute: n,
  second: n,
  timeZoneName: s
};
var TIME_WITH_LONG_OFFSET = {
  hour: n,
  minute: n,
  second: n,
  timeZoneName: l
};
var TIME_24_SIMPLE = {
  hour: n,
  minute: n,
  hourCycle: "h23"
};
var TIME_24_WITH_SECONDS = {
  hour: n,
  minute: n,
  second: n,
  hourCycle: "h23"
};
var TIME_24_WITH_SHORT_OFFSET = {
  hour: n,
  minute: n,
  second: n,
  hourCycle: "h23",
  timeZoneName: s
};
var TIME_24_WITH_LONG_OFFSET = {
  hour: n,
  minute: n,
  second: n,
  hourCycle: "h23",
  timeZoneName: l
};
var DATETIME_SHORT = {
  year: n,
  month: n,
  day: n,
  hour: n,
  minute: n
};
var DATETIME_SHORT_WITH_SECONDS = {
  year: n,
  month: n,
  day: n,
  hour: n,
  minute: n,
  second: n
};
var DATETIME_MED = {
  year: n,
  month: s,
  day: n,
  hour: n,
  minute: n
};
var DATETIME_MED_WITH_SECONDS = {
  year: n,
  month: s,
  day: n,
  hour: n,
  minute: n,
  second: n
};
var DATETIME_MED_WITH_WEEKDAY = {
  year: n,
  month: s,
  day: n,
  weekday: s,
  hour: n,
  minute: n
};
var DATETIME_FULL = {
  year: n,
  month: l,
  day: n,
  hour: n,
  minute: n,
  timeZoneName: s
};
var DATETIME_FULL_WITH_SECONDS = {
  year: n,
  month: l,
  day: n,
  hour: n,
  minute: n,
  second: n,
  timeZoneName: s
};
var DATETIME_HUGE = {
  year: n,
  month: l,
  day: n,
  weekday: l,
  hour: n,
  minute: n,
  timeZoneName: l
};
var DATETIME_HUGE_WITH_SECONDS = {
  year: n,
  month: l,
  day: n,
  weekday: l,
  hour: n,
  minute: n,
  second: n,
  timeZoneName: l
};

/**
 * @interface
 */
var Zone = /*#__PURE__*/function () {
  function Zone() {}
  var _proto = Zone.prototype;
  /**
   * Returns the offset's common name (such as EST) at the specified timestamp
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to get the name
   * @param {Object} opts - Options to affect the format
   * @param {string} opts.format - What style of offset to return. Accepts 'long' or 'short'.
   * @param {string} opts.locale - What locale to return the offset name in.
   * @return {string}
   */
  _proto.offsetName = function offsetName(ts, opts) {
    throw new ZoneIsAbstractError();
  }

  /**
   * Returns the offset's value as a string
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to get the offset
   * @param {string} format - What style of offset to return.
   *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
   * @return {string}
   */;
  _proto.formatOffset = function formatOffset(ts, format) {
    throw new ZoneIsAbstractError();
  }

  /**
   * Return the offset in minutes for this zone at the specified timestamp.
   * @abstract
   * @param {number} ts - Epoch milliseconds for which to compute the offset
   * @return {number}
   */;
  _proto.offset = function offset(ts) {
    throw new ZoneIsAbstractError();
  }

  /**
   * Return whether this Zone is equal to another zone
   * @abstract
   * @param {Zone} otherZone - the zone to compare
   * @return {boolean}
   */;
  _proto.equals = function equals(otherZone) {
    throw new ZoneIsAbstractError();
  }

  /**
   * Return whether this Zone is valid.
   * @abstract
   * @type {boolean}
   */;
  _createClass(Zone, [{
    key: "type",
    get:
    /**
     * The type of zone
     * @abstract
     * @type {string}
     */
    function get() {
      throw new ZoneIsAbstractError();
    }

    /**
     * The name of this zone.
     * @abstract
     * @type {string}
     */
  }, {
    key: "name",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }, {
    key: "ianaName",
    get: function get() {
      return this.name;
    }

    /**
     * Returns whether the offset is known to be fixed for the whole year.
     * @abstract
     * @type {boolean}
     */
  }, {
    key: "isUniversal",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }, {
    key: "isValid",
    get: function get() {
      throw new ZoneIsAbstractError();
    }
  }]);
  return Zone;
}();

var singleton$1 = null;

/**
 * Represents the local zone for this JavaScript environment.
 * @implements {Zone}
 */
var SystemZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(SystemZone, _Zone);
  function SystemZone() {
    return _Zone.apply(this, arguments) || this;
  }
  var _proto = SystemZone.prototype;
  /** @override **/
  _proto.offsetName = function offsetName(ts, _ref) {
    var format = _ref.format,
      locale = _ref.locale;
    return parseZoneInfo(ts, format, locale);
  }

  /** @override **/;
  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.offset(ts), format);
  }

  /** @override **/;
  _proto.offset = function offset(ts) {
    return -new Date(ts).getTimezoneOffset();
  }

  /** @override **/;
  _proto.equals = function equals(otherZone) {
    return otherZone.type === "system";
  }

  /** @override **/;
  _createClass(SystemZone, [{
    key: "type",
    get: /** @override **/
    function get() {
      return "system";
    }

    /** @override **/
  }, {
    key: "name",
    get: function get() {
      return new Intl.DateTimeFormat().resolvedOptions().timeZone;
    }

    /** @override **/
  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return true;
    }
  }], [{
    key: "instance",
    get:
    /**
     * Get a singleton instance of the local zone
     * @return {SystemZone}
     */
    function get() {
      if (singleton$1 === null) {
        singleton$1 = new SystemZone();
      }
      return singleton$1;
    }
  }]);
  return SystemZone;
}(Zone);

var dtfCache = {};
function makeDTF(zone) {
  if (!dtfCache[zone]) {
    dtfCache[zone] = new Intl.DateTimeFormat("en-US", {
      hour12: false,
      timeZone: zone,
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      era: "short"
    });
  }
  return dtfCache[zone];
}
var typeToPos = {
  year: 0,
  month: 1,
  day: 2,
  era: 3,
  hour: 4,
  minute: 5,
  second: 6
};
function hackyOffset(dtf, date) {
  var formatted = dtf.format(date).replace(/\u200E/g, ""),
    parsed = /(\d+)\/(\d+)\/(\d+) (AD|BC),? (\d+):(\d+):(\d+)/.exec(formatted),
    fMonth = parsed[1],
    fDay = parsed[2],
    fYear = parsed[3],
    fadOrBc = parsed[4],
    fHour = parsed[5],
    fMinute = parsed[6],
    fSecond = parsed[7];
  return [fYear, fMonth, fDay, fadOrBc, fHour, fMinute, fSecond];
}
function partsOffset(dtf, date) {
  var formatted = dtf.formatToParts(date);
  var filled = [];
  for (var i = 0; i < formatted.length; i++) {
    var _formatted$i = formatted[i],
      type = _formatted$i.type,
      value = _formatted$i.value;
    var pos = typeToPos[type];
    if (type === "era") {
      filled[pos] = value;
    } else if (!isUndefined(pos)) {
      filled[pos] = parseInt(value, 10);
    }
  }
  return filled;
}
var ianaZoneCache = {};
/**
 * A zone identified by an IANA identifier, like America/New_York
 * @implements {Zone}
 */
var IANAZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(IANAZone, _Zone);
  /**
   * @param {string} name - Zone name
   * @return {IANAZone}
   */
  IANAZone.create = function create(name) {
    if (!ianaZoneCache[name]) {
      ianaZoneCache[name] = new IANAZone(name);
    }
    return ianaZoneCache[name];
  }

  /**
   * Reset local caches. Should only be necessary in testing scenarios.
   * @return {void}
   */;
  IANAZone.resetCache = function resetCache() {
    ianaZoneCache = {};
    dtfCache = {};
  }

  /**
   * Returns whether the provided string is a valid specifier. This only checks the string's format, not that the specifier identifies a known zone; see isValidZone for that.
   * @param {string} s - The string to check validity on
   * @example IANAZone.isValidSpecifier("America/New_York") //=> true
   * @example IANAZone.isValidSpecifier("Sport~~blorp") //=> false
   * @deprecated This method returns false for some valid IANA names. Use isValidZone instead.
   * @return {boolean}
   */;
  IANAZone.isValidSpecifier = function isValidSpecifier(s) {
    return this.isValidZone(s);
  }

  /**
   * Returns whether the provided string identifies a real zone
   * @param {string} zone - The string to check
   * @example IANAZone.isValidZone("America/New_York") //=> true
   * @example IANAZone.isValidZone("Fantasia/Castle") //=> false
   * @example IANAZone.isValidZone("Sport~~blorp") //=> false
   * @return {boolean}
   */;
  IANAZone.isValidZone = function isValidZone(zone) {
    if (!zone) {
      return false;
    }
    try {
      new Intl.DateTimeFormat("en-US", {
        timeZone: zone
      }).format();
      return true;
    } catch (e) {
      return false;
    }
  };
  function IANAZone(name) {
    var _this;
    _this = _Zone.call(this) || this;
    /** @private **/
    _this.zoneName = name;
    /** @private **/
    _this.valid = IANAZone.isValidZone(name);
    return _this;
  }

  /** @override **/
  var _proto = IANAZone.prototype;
  /** @override **/
  _proto.offsetName = function offsetName(ts, _ref) {
    var format = _ref.format,
      locale = _ref.locale;
    return parseZoneInfo(ts, format, locale, this.name);
  }

  /** @override **/;
  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.offset(ts), format);
  }

  /** @override **/;
  _proto.offset = function offset(ts) {
    var date = new Date(ts);
    if (isNaN(date)) return NaN;
    var dtf = makeDTF(this.name);
    var _ref2 = dtf.formatToParts ? partsOffset(dtf, date) : hackyOffset(dtf, date),
      year = _ref2[0],
      month = _ref2[1],
      day = _ref2[2],
      adOrBc = _ref2[3],
      hour = _ref2[4],
      minute = _ref2[5],
      second = _ref2[6];
    if (adOrBc === "BC") {
      year = -Math.abs(year) + 1;
    }

    // because we're using hour12 and https://bugs.chromium.org/p/chromium/issues/detail?id=1025564&can=2&q=%2224%3A00%22%20datetimeformat
    var adjustedHour = hour === 24 ? 0 : hour;
    var asUTC = objToLocalTS({
      year: year,
      month: month,
      day: day,
      hour: adjustedHour,
      minute: minute,
      second: second,
      millisecond: 0
    });
    var asTS = +date;
    var over = asTS % 1000;
    asTS -= over >= 0 ? over : 1000 + over;
    return (asUTC - asTS) / (60 * 1000);
  }

  /** @override **/;
  _proto.equals = function equals(otherZone) {
    return otherZone.type === "iana" && otherZone.name === this.name;
  }

  /** @override **/;
  _createClass(IANAZone, [{
    key: "type",
    get: function get() {
      return "iana";
    }

    /** @override **/
  }, {
    key: "name",
    get: function get() {
      return this.zoneName;
    }

    /** @override **/
  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return this.valid;
    }
  }]);
  return IANAZone;
}(Zone);

var _excluded = ["base"],
  _excluded2 = ["padTo", "floor"];

// todo - remap caching

var intlLFCache = {};
function getCachedLF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }
  var key = JSON.stringify([locString, opts]);
  var dtf = intlLFCache[key];
  if (!dtf) {
    dtf = new Intl.ListFormat(locString, opts);
    intlLFCache[key] = dtf;
  }
  return dtf;
}
var intlDTCache = {};
function getCachedDTF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }
  var key = JSON.stringify([locString, opts]);
  var dtf = intlDTCache[key];
  if (!dtf) {
    dtf = new Intl.DateTimeFormat(locString, opts);
    intlDTCache[key] = dtf;
  }
  return dtf;
}
var intlNumCache = {};
function getCachedINF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }
  var key = JSON.stringify([locString, opts]);
  var inf = intlNumCache[key];
  if (!inf) {
    inf = new Intl.NumberFormat(locString, opts);
    intlNumCache[key] = inf;
  }
  return inf;
}
var intlRelCache = {};
function getCachedRTF(locString, opts) {
  if (opts === void 0) {
    opts = {};
  }
  var _opts = opts;
    var cacheKeyOpts = _objectWithoutPropertiesLoose(_opts, _excluded); // exclude `base` from the options
  var key = JSON.stringify([locString, cacheKeyOpts]);
  var inf = intlRelCache[key];
  if (!inf) {
    inf = new Intl.RelativeTimeFormat(locString, opts);
    intlRelCache[key] = inf;
  }
  return inf;
}
var sysLocaleCache = null;
function systemLocale() {
  if (sysLocaleCache) {
    return sysLocaleCache;
  } else {
    sysLocaleCache = new Intl.DateTimeFormat().resolvedOptions().locale;
    return sysLocaleCache;
  }
}
var weekInfoCache = {};
function getCachedWeekInfo(locString) {
  var data = weekInfoCache[locString];
  if (!data) {
    var locale = new Intl.Locale(locString);
    // browsers currently implement this as a property, but spec says it should be a getter function
    data = "getWeekInfo" in locale ? locale.getWeekInfo() : locale.weekInfo;
    weekInfoCache[locString] = data;
  }
  return data;
}
function parseLocaleString(localeStr) {
  // I really want to avoid writing a BCP 47 parser
  // see, e.g. https://github.com/wooorm/bcp-47
  // Instead, we'll do this:

  // a) if the string has no -u extensions, just leave it alone
  // b) if it does, use Intl to resolve everything
  // c) if Intl fails, try again without the -u

  // private subtags and unicode subtags have ordering requirements,
  // and we're not properly parsing this, so just strip out the
  // private ones if they exist.
  var xIndex = localeStr.indexOf("-x-");
  if (xIndex !== -1) {
    localeStr = localeStr.substring(0, xIndex);
  }
  var uIndex = localeStr.indexOf("-u-");
  if (uIndex === -1) {
    return [localeStr];
  } else {
    var options;
    var selectedStr;
    try {
      options = getCachedDTF(localeStr).resolvedOptions();
      selectedStr = localeStr;
    } catch (e) {
      var smaller = localeStr.substring(0, uIndex);
      options = getCachedDTF(smaller).resolvedOptions();
      selectedStr = smaller;
    }
    var _options = options,
      numberingSystem = _options.numberingSystem,
      calendar = _options.calendar;
    return [selectedStr, numberingSystem, calendar];
  }
}
function intlConfigString(localeStr, numberingSystem, outputCalendar) {
  if (outputCalendar || numberingSystem) {
    if (!localeStr.includes("-u-")) {
      localeStr += "-u";
    }
    if (outputCalendar) {
      localeStr += "-ca-" + outputCalendar;
    }
    if (numberingSystem) {
      localeStr += "-nu-" + numberingSystem;
    }
    return localeStr;
  } else {
    return localeStr;
  }
}
function mapMonths(f) {
  var ms = [];
  for (var i = 1; i <= 12; i++) {
    var dt = DateTime.utc(2009, i, 1);
    ms.push(f(dt));
  }
  return ms;
}
function mapWeekdays(f) {
  var ms = [];
  for (var i = 1; i <= 7; i++) {
    var dt = DateTime.utc(2016, 11, 13 + i);
    ms.push(f(dt));
  }
  return ms;
}
function listStuff(loc, length, englishFn, intlFn) {
  var mode = loc.listingMode();
  if (mode === "error") {
    return null;
  } else if (mode === "en") {
    return englishFn(length);
  } else {
    return intlFn(length);
  }
}
function supportsFastNumbers(loc) {
  if (loc.numberingSystem && loc.numberingSystem !== "latn") {
    return false;
  } else {
    return loc.numberingSystem === "latn" || !loc.locale || loc.locale.startsWith("en") || new Intl.DateTimeFormat(loc.intl).resolvedOptions().numberingSystem === "latn";
  }
}

/**
 * @private
 */
var PolyNumberFormatter = /*#__PURE__*/function () {
  function PolyNumberFormatter(intl, forceSimple, opts) {
    this.padTo = opts.padTo || 0;
    this.floor = opts.floor || false;
      var otherOpts = _objectWithoutPropertiesLoose(opts, _excluded2);
    if (!forceSimple || Object.keys(otherOpts).length > 0) {
      var intlOpts = _extends({
        useGrouping: false
      }, opts);
      if (opts.padTo > 0) intlOpts.minimumIntegerDigits = opts.padTo;
      this.inf = getCachedINF(intl, intlOpts);
    }
  }
  var _proto = PolyNumberFormatter.prototype;
  _proto.format = function format(i) {
    if (this.inf) {
      var fixed = this.floor ? Math.floor(i) : i;
      return this.inf.format(fixed);
    } else {
      // to match the browser's numberformatter defaults
      var _fixed = this.floor ? Math.floor(i) : roundTo(i, 3);
      return padStart(_fixed, this.padTo);
    }
  };
  return PolyNumberFormatter;
}();
/**
 * @private
 */
var PolyDateFormatter = /*#__PURE__*/function () {
  function PolyDateFormatter(dt, intl, opts) {
    this.opts = opts;
    this.originalZone = undefined;
    var z = undefined;
    if (this.opts.timeZone) {
      // Don't apply any workarounds if a timeZone is explicitly provided in opts
      this.dt = dt;
    } else if (dt.zone.type === "fixed") {
      // UTC-8 or Etc/UTC-8 are not part of tzdata, only Etc/GMT+8 and the like.
      // That is why fixed-offset TZ is set to that unless it is:
      // 1. Representing offset 0 when UTC is used to maintain previous behavior and does not become GMT.
      // 2. Unsupported by the browser:
      //    - some do not support Etc/
      //    - < Etc/GMT-14, > Etc/GMT+12, and 30-minute or 45-minute offsets are not part of tzdata
      var gmtOffset = -1 * (dt.offset / 60);
      var offsetZ = gmtOffset >= 0 ? "Etc/GMT+" + gmtOffset : "Etc/GMT" + gmtOffset;
      if (dt.offset !== 0 && IANAZone.create(offsetZ).valid) {
        z = offsetZ;
        this.dt = dt;
      } else {
        // Not all fixed-offset zones like Etc/+4:30 are present in tzdata so
        // we manually apply the offset and substitute the zone as needed.
        z = "UTC";
        this.dt = dt.offset === 0 ? dt : dt.setZone("UTC").plus({
          minutes: dt.offset
        });
        this.originalZone = dt.zone;
      }
    } else if (dt.zone.type === "system") {
      this.dt = dt;
    } else if (dt.zone.type === "iana") {
      this.dt = dt;
      z = dt.zone.name;
    } else {
      // Custom zones can have any offset / offsetName so we just manually
      // apply the offset and substitute the zone as needed.
      z = "UTC";
      this.dt = dt.setZone("UTC").plus({
        minutes: dt.offset
      });
      this.originalZone = dt.zone;
    }
    var intlOpts = _extends({}, this.opts);
    intlOpts.timeZone = intlOpts.timeZone || z;
    this.dtf = getCachedDTF(intl, intlOpts);
  }
  var _proto2 = PolyDateFormatter.prototype;
  _proto2.format = function format() {
    if (this.originalZone) {
      // If we have to substitute in the actual zone name, we have to use
      // formatToParts so that the timezone can be replaced.
      return this.formatToParts().map(function (_ref) {
        var value = _ref.value;
        return value;
      }).join("");
    }
    return this.dtf.format(this.dt.toJSDate());
  };
  _proto2.formatToParts = function formatToParts() {
    var _this = this;
    var parts = this.dtf.formatToParts(this.dt.toJSDate());
    if (this.originalZone) {
      return parts.map(function (part) {
        if (part.type === "timeZoneName") {
          var offsetName = _this.originalZone.offsetName(_this.dt.ts, {
            locale: _this.dt.locale,
            format: _this.opts.timeZoneName
          });
          return _extends({}, part, {
            value: offsetName
          });
        } else {
          return part;
        }
      });
    }
    return parts;
  };
  _proto2.resolvedOptions = function resolvedOptions() {
    return this.dtf.resolvedOptions();
  };
  return PolyDateFormatter;
}();
/**
 * @private
 */
var PolyRelFormatter = /*#__PURE__*/function () {
  function PolyRelFormatter(intl, isEnglish, opts) {
    this.opts = _extends({
      style: "long"
    }, opts);
    if (!isEnglish && hasRelative()) {
      this.rtf = getCachedRTF(intl, opts);
    }
  }
  var _proto3 = PolyRelFormatter.prototype;
  _proto3.format = function format(count, unit) {
    if (this.rtf) {
      return this.rtf.format(count, unit);
    } else {
      return formatRelativeTime(unit, count, this.opts.numeric, this.opts.style !== "long");
    }
  };
  _proto3.formatToParts = function formatToParts(count, unit) {
    if (this.rtf) {
      return this.rtf.formatToParts(count, unit);
    } else {
      return [];
    }
  };
  return PolyRelFormatter;
}();
var fallbackWeekSettings = {
  firstDay: 1,
  minimalDays: 4,
  weekend: [6, 7]
};

/**
 * @private
 */
var Locale = /*#__PURE__*/function () {
  Locale.fromOpts = function fromOpts(opts) {
    return Locale.create(opts.locale, opts.numberingSystem, opts.outputCalendar, opts.weekSettings, opts.defaultToEN);
  };
  Locale.create = function create(locale, numberingSystem, outputCalendar, weekSettings, defaultToEN) {
    if (defaultToEN === void 0) {
      defaultToEN = false;
    }
    var specifiedLocale = locale || Settings.defaultLocale;
    // the system locale is useful for human readable strings but annoying for parsing/formatting known formats
    var localeR = specifiedLocale || (defaultToEN ? "en-US" : systemLocale());
    var numberingSystemR = numberingSystem || Settings.defaultNumberingSystem;
    var outputCalendarR = outputCalendar || Settings.defaultOutputCalendar;
    var weekSettingsR = validateWeekSettings(weekSettings) || Settings.defaultWeekSettings;
    return new Locale(localeR, numberingSystemR, outputCalendarR, weekSettingsR, specifiedLocale);
  };
  Locale.resetCache = function resetCache() {
    sysLocaleCache = null;
    intlDTCache = {};
    intlNumCache = {};
    intlRelCache = {};
  };
  Locale.fromObject = function fromObject(_temp) {
    var _ref2 = _temp === void 0 ? {} : _temp,
      locale = _ref2.locale,
      numberingSystem = _ref2.numberingSystem,
      outputCalendar = _ref2.outputCalendar,
      weekSettings = _ref2.weekSettings;
    return Locale.create(locale, numberingSystem, outputCalendar, weekSettings);
  };
  function Locale(locale, numbering, outputCalendar, weekSettings, specifiedLocale) {
    var _parseLocaleString = parseLocaleString(locale),
      parsedLocale = _parseLocaleString[0],
      parsedNumberingSystem = _parseLocaleString[1],
      parsedOutputCalendar = _parseLocaleString[2];
    this.locale = parsedLocale;
    this.numberingSystem = numbering || parsedNumberingSystem || null;
    this.outputCalendar = outputCalendar || parsedOutputCalendar || null;
    this.weekSettings = weekSettings;
    this.intl = intlConfigString(this.locale, this.numberingSystem, this.outputCalendar);
    this.weekdaysCache = {
      format: {},
      standalone: {}
    };
    this.monthsCache = {
      format: {},
      standalone: {}
    };
    this.meridiemCache = null;
    this.eraCache = {};
    this.specifiedLocale = specifiedLocale;
    this.fastNumbersCached = null;
  }
  var _proto4 = Locale.prototype;
  _proto4.listingMode = function listingMode() {
    var isActuallyEn = this.isEnglish();
    var hasNoWeirdness = (this.numberingSystem === null || this.numberingSystem === "latn") && (this.outputCalendar === null || this.outputCalendar === "gregory");
    return isActuallyEn && hasNoWeirdness ? "en" : "intl";
  };
  _proto4.clone = function clone(alts) {
    if (!alts || Object.getOwnPropertyNames(alts).length === 0) {
      return this;
    } else {
      return Locale.create(alts.locale || this.specifiedLocale, alts.numberingSystem || this.numberingSystem, alts.outputCalendar || this.outputCalendar, validateWeekSettings(alts.weekSettings) || this.weekSettings, alts.defaultToEN || false);
    }
  };
  _proto4.redefaultToEN = function redefaultToEN(alts) {
    if (alts === void 0) {
      alts = {};
    }
    return this.clone(_extends({}, alts, {
      defaultToEN: true
    }));
  };
  _proto4.redefaultToSystem = function redefaultToSystem(alts) {
    if (alts === void 0) {
      alts = {};
    }
    return this.clone(_extends({}, alts, {
      defaultToEN: false
    }));
  };
  _proto4.months = function months$1(length, format) {
    var _this2 = this;
    if (format === void 0) {
      format = false;
    }
    return listStuff(this, length, months, function () {
      var intl = format ? {
          month: length,
          day: "numeric"
        } : {
          month: length
        },
        formatStr = format ? "format" : "standalone";
      if (!_this2.monthsCache[formatStr][length]) {
        _this2.monthsCache[formatStr][length] = mapMonths(function (dt) {
          return _this2.extract(dt, intl, "month");
        });
      }
      return _this2.monthsCache[formatStr][length];
    });
  };
  _proto4.weekdays = function weekdays$1(length, format) {
    var _this3 = this;
    if (format === void 0) {
      format = false;
    }
    return listStuff(this, length, weekdays, function () {
      var intl = format ? {
          weekday: length,
          year: "numeric",
          month: "long",
          day: "numeric"
        } : {
          weekday: length
        },
        formatStr = format ? "format" : "standalone";
      if (!_this3.weekdaysCache[formatStr][length]) {
        _this3.weekdaysCache[formatStr][length] = mapWeekdays(function (dt) {
          return _this3.extract(dt, intl, "weekday");
        });
      }
      return _this3.weekdaysCache[formatStr][length];
    });
  };
  _proto4.meridiems = function meridiems$1() {
    var _this4 = this;
    return listStuff(this, undefined, function () {
      return meridiems;
    }, function () {
      // In theory there could be aribitrary day periods. We're gonna assume there are exactly two
      // for AM and PM. This is probably wrong, but it's makes parsing way easier.
      if (!_this4.meridiemCache) {
        var intl = {
          hour: "numeric",
          hourCycle: "h12"
        };
        _this4.meridiemCache = [DateTime.utc(2016, 11, 13, 9), DateTime.utc(2016, 11, 13, 19)].map(function (dt) {
          return _this4.extract(dt, intl, "dayperiod");
        });
      }
      return _this4.meridiemCache;
    });
  };
  _proto4.eras = function eras$1(length) {
    var _this5 = this;
    return listStuff(this, length, eras, function () {
      var intl = {
        era: length
      };

      // This is problematic. Different calendars are going to define eras totally differently. What I need is the minimum set of dates
      // to definitely enumerate them.
      if (!_this5.eraCache[length]) {
        _this5.eraCache[length] = [DateTime.utc(-40, 1, 1), DateTime.utc(2017, 1, 1)].map(function (dt) {
          return _this5.extract(dt, intl, "era");
        });
      }
      return _this5.eraCache[length];
    });
  };
  _proto4.extract = function extract(dt, intlOpts, field) {
    var df = this.dtFormatter(dt, intlOpts),
      results = df.formatToParts(),
      matching = results.find(function (m) {
        return m.type.toLowerCase() === field;
      });
    return matching ? matching.value : null;
  };
  _proto4.numberFormatter = function numberFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }
    // this forcesimple option is never used (the only caller short-circuits on it, but it seems safer to leave)
    // (in contrast, the rest of the condition is used heavily)
    return new PolyNumberFormatter(this.intl, opts.forceSimple || this.fastNumbers, opts);
  };
  _proto4.dtFormatter = function dtFormatter(dt, intlOpts) {
    if (intlOpts === void 0) {
      intlOpts = {};
    }
    return new PolyDateFormatter(dt, this.intl, intlOpts);
  };
  _proto4.relFormatter = function relFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }
    return new PolyRelFormatter(this.intl, this.isEnglish(), opts);
  };
  _proto4.listFormatter = function listFormatter(opts) {
    if (opts === void 0) {
      opts = {};
    }
    return getCachedLF(this.intl, opts);
  };
  _proto4.isEnglish = function isEnglish() {
    return this.locale === "en" || this.locale.toLowerCase() === "en-us" || new Intl.DateTimeFormat(this.intl).resolvedOptions().locale.startsWith("en-us");
  };
  _proto4.getWeekSettings = function getWeekSettings() {
    if (this.weekSettings) {
      return this.weekSettings;
    } else if (!hasLocaleWeekInfo()) {
      return fallbackWeekSettings;
    } else {
      return getCachedWeekInfo(this.locale);
    }
  };
  _proto4.getStartOfWeek = function getStartOfWeek() {
    return this.getWeekSettings().firstDay;
  };
  _proto4.getMinDaysInFirstWeek = function getMinDaysInFirstWeek() {
    return this.getWeekSettings().minimalDays;
  };
  _proto4.getWeekendDays = function getWeekendDays() {
    return this.getWeekSettings().weekend;
  };
  _proto4.equals = function equals(other) {
    return this.locale === other.locale && this.numberingSystem === other.numberingSystem && this.outputCalendar === other.outputCalendar;
  };
  _createClass(Locale, [{
    key: "fastNumbers",
    get: function get() {
      if (this.fastNumbersCached == null) {
        this.fastNumbersCached = supportsFastNumbers(this);
      }
      return this.fastNumbersCached;
    }
  }]);
  return Locale;
}();

var singleton = null;

/**
 * A zone with a fixed offset (meaning no DST)
 * @implements {Zone}
 */
var FixedOffsetZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(FixedOffsetZone, _Zone);
  /**
   * Get an instance with a specified offset
   * @param {number} offset - The offset in minutes
   * @return {FixedOffsetZone}
   */
  FixedOffsetZone.instance = function instance(offset) {
    return offset === 0 ? FixedOffsetZone.utcInstance : new FixedOffsetZone(offset);
  }

  /**
   * Get an instance of FixedOffsetZone from a UTC offset string, like "UTC+6"
   * @param {string} s - The offset string to parse
   * @example FixedOffsetZone.parseSpecifier("UTC+6")
   * @example FixedOffsetZone.parseSpecifier("UTC+06")
   * @example FixedOffsetZone.parseSpecifier("UTC-6:00")
   * @return {FixedOffsetZone}
   */;
  FixedOffsetZone.parseSpecifier = function parseSpecifier(s) {
    if (s) {
      var r = s.match(/^utc(?:([+-]\d{1,2})(?::(\d{2}))?)?$/i);
      if (r) {
        return new FixedOffsetZone(signedOffset(r[1], r[2]));
      }
    }
    return null;
  };
  function FixedOffsetZone(offset) {
    var _this;
    _this = _Zone.call(this) || this;
    /** @private **/
    _this.fixed = offset;
    return _this;
  }

  /** @override **/
  var _proto = FixedOffsetZone.prototype;
  /** @override **/
  _proto.offsetName = function offsetName() {
    return this.name;
  }

  /** @override **/;
  _proto.formatOffset = function formatOffset$1(ts, format) {
    return formatOffset(this.fixed, format);
  }

  /** @override **/;
  /** @override **/
  _proto.offset = function offset() {
    return this.fixed;
  }

  /** @override **/;
  _proto.equals = function equals(otherZone) {
    return otherZone.type === "fixed" && otherZone.fixed === this.fixed;
  }

  /** @override **/;
  _createClass(FixedOffsetZone, [{
    key: "type",
    get: function get() {
      return "fixed";
    }

    /** @override **/
  }, {
    key: "name",
    get: function get() {
      return this.fixed === 0 ? "UTC" : "UTC" + formatOffset(this.fixed, "narrow");
    }
  }, {
    key: "ianaName",
    get: function get() {
      if (this.fixed === 0) {
        return "Etc/UTC";
      } else {
        return "Etc/GMT" + formatOffset(-this.fixed, "narrow");
      }
    }
  }, {
    key: "isUniversal",
    get: function get() {
      return true;
    }
  }, {
    key: "isValid",
    get: function get() {
      return true;
    }
  }], [{
    key: "utcInstance",
    get:
    /**
     * Get a singleton instance of UTC
     * @return {FixedOffsetZone}
     */
    function get() {
      if (singleton === null) {
        singleton = new FixedOffsetZone(0);
      }
      return singleton;
    }
  }]);
  return FixedOffsetZone;
}(Zone);

/**
 * A zone that failed to parse. You should never need to instantiate this.
 * @implements {Zone}
 */
var InvalidZone = /*#__PURE__*/function (_Zone) {
  _inheritsLoose(InvalidZone, _Zone);
  function InvalidZone(zoneName) {
    var _this;
    _this = _Zone.call(this) || this;
    /**  @private */
    _this.zoneName = zoneName;
    return _this;
  }

  /** @override **/
  var _proto = InvalidZone.prototype;
  /** @override **/
  _proto.offsetName = function offsetName() {
    return null;
  }

  /** @override **/;
  _proto.formatOffset = function formatOffset() {
    return "";
  }

  /** @override **/;
  _proto.offset = function offset() {
    return NaN;
  }

  /** @override **/;
  _proto.equals = function equals() {
    return false;
  }

  /** @override **/;
  _createClass(InvalidZone, [{
    key: "type",
    get: function get() {
      return "invalid";
    }

    /** @override **/
  }, {
    key: "name",
    get: function get() {
      return this.zoneName;
    }

    /** @override **/
  }, {
    key: "isUniversal",
    get: function get() {
      return false;
    }
  }, {
    key: "isValid",
    get: function get() {
      return false;
    }
  }]);
  return InvalidZone;
}(Zone);

/**
 * @private
 */
function normalizeZone(input, defaultZone) {
  if (isUndefined(input) || input === null) {
    return defaultZone;
  } else if (input instanceof Zone) {
    return input;
  } else if (isString(input)) {
    var lowered = input.toLowerCase();
    if (lowered === "default") return defaultZone;else if (lowered === "local" || lowered === "system") return SystemZone.instance;else if (lowered === "utc" || lowered === "gmt") return FixedOffsetZone.utcInstance;else return FixedOffsetZone.parseSpecifier(lowered) || IANAZone.create(input);
  } else if (isNumber(input)) {
    return FixedOffsetZone.instance(input);
  } else if (typeof input === "object" && "offset" in input && typeof input.offset === "function") {
    // This is dumb, but the instanceof check above doesn't seem to really work
    // so we're duck checking it
    return input;
  } else {
    return new InvalidZone(input);
  }
}

var now = function now() {
    return Date.now();
  },
  defaultZone = "system",
  defaultLocale = null,
  defaultNumberingSystem = null,
  defaultOutputCalendar = null,
  twoDigitCutoffYear = 60,
  throwOnInvalid,
  defaultWeekSettings = null;

/**
 * Settings contains static getters and setters that control Luxon's overall behavior. Luxon is a simple library with few options, but the ones it does have live here.
 */
var Settings = /*#__PURE__*/function () {
  function Settings() {}
  /**
   * Reset Luxon's global caches. Should only be necessary in testing scenarios.
   * @return {void}
   */
  Settings.resetCaches = function resetCaches() {
    Locale.resetCache();
    IANAZone.resetCache();
  };
  _createClass(Settings, null, [{
    key: "now",
    get:
    /**
     * Get the callback for returning the current timestamp.
     * @type {function}
     */
    function get() {
      return now;
    }

    /**
     * Set the callback for returning the current timestamp.
     * The function should return a number, which will be interpreted as an Epoch millisecond count
     * @type {function}
     * @example Settings.now = () => Date.now() + 3000 // pretend it is 3 seconds in the future
     * @example Settings.now = () => 0 // always pretend it's Jan 1, 1970 at midnight in UTC time
     */,
    set: function set(n) {
      now = n;
    }

    /**
     * Set the default time zone to create DateTimes in. Does not affect existing instances.
     * Use the value "system" to reset this value to the system's time zone.
     * @type {string}
     */
  }, {
    key: "defaultZone",
    get:
    /**
     * Get the default time zone object currently used to create DateTimes. Does not affect existing instances.
     * The default value is the system's time zone (the one set on the machine that runs this code).
     * @type {Zone}
     */
    function get() {
      return normalizeZone(defaultZone, SystemZone.instance);
    }

    /**
     * Get the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */,
    set: function set(zone) {
      defaultZone = zone;
    }
  }, {
    key: "defaultLocale",
    get: function get() {
      return defaultLocale;
    }

    /**
     * Set the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */,
    set: function set(locale) {
      defaultLocale = locale;
    }

    /**
     * Get the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
  }, {
    key: "defaultNumberingSystem",
    get: function get() {
      return defaultNumberingSystem;
    }

    /**
     * Set the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */,
    set: function set(numberingSystem) {
      defaultNumberingSystem = numberingSystem;
    }

    /**
     * Get the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
  }, {
    key: "defaultOutputCalendar",
    get: function get() {
      return defaultOutputCalendar;
    }

    /**
     * Set the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */,
    set: function set(outputCalendar) {
      defaultOutputCalendar = outputCalendar;
    }

    /**
     * @typedef {Object} WeekSettings
     * @property {number} firstDay
     * @property {number} minimalDays
     * @property {number[]} weekend
     */

    /**
     * @return {WeekSettings|null}
     */
  }, {
    key: "defaultWeekSettings",
    get: function get() {
      return defaultWeekSettings;
    }

    /**
     * Allows overriding the default locale week settings, i.e. the start of the week, the weekend and
     * how many days are required in the first week of a year.
     * Does not affect existing instances.
     *
     * @param {WeekSettings|null} weekSettings
     */,
    set: function set(weekSettings) {
      defaultWeekSettings = validateWeekSettings(weekSettings);
    }

    /**
     * Get the cutoff year after which a string encoding a year as two digits is interpreted to occur in the current century.
     * @type {number}
     */
  }, {
    key: "twoDigitCutoffYear",
    get: function get() {
      return twoDigitCutoffYear;
    }

    /**
     * Set the cutoff year after which a string encoding a year as two digits is interpreted to occur in the current century.
     * @type {number}
     * @example Settings.twoDigitCutoffYear = 0 // cut-off year is 0, so all 'yy' are interpreted as current century
     * @example Settings.twoDigitCutoffYear = 50 // '49' -> 1949; '50' -> 2050
     * @example Settings.twoDigitCutoffYear = 1950 // interpreted as 50
     * @example Settings.twoDigitCutoffYear = 2050 // ALSO interpreted as 50
     */,
    set: function set(cutoffYear) {
      twoDigitCutoffYear = cutoffYear % 100;
    }

    /**
     * Get whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */
  }, {
    key: "throwOnInvalid",
    get: function get() {
      return throwOnInvalid;
    }

    /**
     * Set whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */,
    set: function set(t) {
      throwOnInvalid = t;
    }
  }]);
  return Settings;
}();

var Invalid = /*#__PURE__*/function () {
  function Invalid(reason, explanation) {
    this.reason = reason;
    this.explanation = explanation;
  }
  var _proto = Invalid.prototype;
  _proto.toMessage = function toMessage() {
    if (this.explanation) {
      return this.reason + ": " + this.explanation;
    } else {
      return this.reason;
    }
  };
  return Invalid;
}();

var nonLeapLadder = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334],
  leapLadder = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];
function unitOutOfRange(unit, value) {
  return new Invalid("unit out of range", "you specified " + value + " (of type " + typeof value + ") as a " + unit + ", which is invalid");
}
function dayOfWeek(year, month, day) {
  var d = new Date(Date.UTC(year, month - 1, day));
  if (year < 100 && year >= 0) {
    d.setUTCFullYear(d.getUTCFullYear() - 1900);
  }
  var js = d.getUTCDay();
  return js === 0 ? 7 : js;
}
function computeOrdinal(year, month, day) {
  return day + (isLeapYear(year) ? leapLadder : nonLeapLadder)[month - 1];
}
function uncomputeOrdinal(year, ordinal) {
  var table = isLeapYear(year) ? leapLadder : nonLeapLadder,
    month0 = table.findIndex(function (i) {
      return i < ordinal;
    }),
    day = ordinal - table[month0];
  return {
    month: month0 + 1,
    day: day
  };
}
function isoWeekdayToLocal(isoWeekday, startOfWeek) {
  return (isoWeekday - startOfWeek + 7) % 7 + 1;
}

/**
 * @private
 */

function gregorianToWeek(gregObj, minDaysInFirstWeek, startOfWeek) {
  if (minDaysInFirstWeek === void 0) {
    minDaysInFirstWeek = 4;
  }
  if (startOfWeek === void 0) {
    startOfWeek = 1;
  }
  var year = gregObj.year,
    month = gregObj.month,
    day = gregObj.day,
    ordinal = computeOrdinal(year, month, day),
    weekday = isoWeekdayToLocal(dayOfWeek(year, month, day), startOfWeek);
  var weekNumber = Math.floor((ordinal - weekday + 14 - minDaysInFirstWeek) / 7),
    weekYear;
  if (weekNumber < 1) {
    weekYear = year - 1;
    weekNumber = weeksInWeekYear(weekYear, minDaysInFirstWeek, startOfWeek);
  } else if (weekNumber > weeksInWeekYear(year, minDaysInFirstWeek, startOfWeek)) {
    weekYear = year + 1;
    weekNumber = 1;
  } else {
    weekYear = year;
  }
  return _extends({
    weekYear: weekYear,
    weekNumber: weekNumber,
    weekday: weekday
  }, timeObject(gregObj));
}
function weekToGregorian(weekData, minDaysInFirstWeek, startOfWeek) {
  if (minDaysInFirstWeek === void 0) {
    minDaysInFirstWeek = 4;
  }
  if (startOfWeek === void 0) {
    startOfWeek = 1;
  }
  var weekYear = weekData.weekYear,
    weekNumber = weekData.weekNumber,
    weekday = weekData.weekday,
    weekdayOfJan4 = isoWeekdayToLocal(dayOfWeek(weekYear, 1, minDaysInFirstWeek), startOfWeek),
    yearInDays = daysInYear(weekYear);
  var ordinal = weekNumber * 7 + weekday - weekdayOfJan4 - 7 + minDaysInFirstWeek,
    year;
  if (ordinal < 1) {
    year = weekYear - 1;
    ordinal += daysInYear(year);
  } else if (ordinal > yearInDays) {
    year = weekYear + 1;
    ordinal -= daysInYear(weekYear);
  } else {
    year = weekYear;
  }
  var _uncomputeOrdinal = uncomputeOrdinal(year, ordinal),
    month = _uncomputeOrdinal.month,
    day = _uncomputeOrdinal.day;
  return _extends({
    year: year,
    month: month,
    day: day
  }, timeObject(weekData));
}
function gregorianToOrdinal(gregData) {
  var year = gregData.year,
    month = gregData.month,
    day = gregData.day;
  var ordinal = computeOrdinal(year, month, day);
  return _extends({
    year: year,
    ordinal: ordinal
  }, timeObject(gregData));
}
function ordinalToGregorian(ordinalData) {
  var year = ordinalData.year,
    ordinal = ordinalData.ordinal;
  var _uncomputeOrdinal2 = uncomputeOrdinal(year, ordinal),
    month = _uncomputeOrdinal2.month,
    day = _uncomputeOrdinal2.day;
  return _extends({
    year: year,
    month: month,
    day: day
  }, timeObject(ordinalData));
}

/**
 * Check if local week units like localWeekday are used in obj.
 * If so, validates that they are not mixed with ISO week units and then copies them to the normal week unit properties.
 * Modifies obj in-place!
 * @param obj the object values
 */
function usesLocalWeekValues(obj, loc) {
  var hasLocaleWeekData = !isUndefined(obj.localWeekday) || !isUndefined(obj.localWeekNumber) || !isUndefined(obj.localWeekYear);
  if (hasLocaleWeekData) {
    var hasIsoWeekData = !isUndefined(obj.weekday) || !isUndefined(obj.weekNumber) || !isUndefined(obj.weekYear);
    if (hasIsoWeekData) {
      throw new ConflictingSpecificationError("Cannot mix locale-based week fields with ISO-based week fields");
    }
    if (!isUndefined(obj.localWeekday)) obj.weekday = obj.localWeekday;
    if (!isUndefined(obj.localWeekNumber)) obj.weekNumber = obj.localWeekNumber;
    if (!isUndefined(obj.localWeekYear)) obj.weekYear = obj.localWeekYear;
    delete obj.localWeekday;
    delete obj.localWeekNumber;
    delete obj.localWeekYear;
    return {
      minDaysInFirstWeek: loc.getMinDaysInFirstWeek(),
      startOfWeek: loc.getStartOfWeek()
    };
  } else {
    return {
      minDaysInFirstWeek: 4,
      startOfWeek: 1
    };
  }
}
function hasInvalidWeekData(obj, minDaysInFirstWeek, startOfWeek) {
  if (minDaysInFirstWeek === void 0) {
    minDaysInFirstWeek = 4;
  }
  if (startOfWeek === void 0) {
    startOfWeek = 1;
  }
  var validYear = isInteger(obj.weekYear),
    validWeek = integerBetween(obj.weekNumber, 1, weeksInWeekYear(obj.weekYear, minDaysInFirstWeek, startOfWeek)),
    validWeekday = integerBetween(obj.weekday, 1, 7);
  if (!validYear) {
    return unitOutOfRange("weekYear", obj.weekYear);
  } else if (!validWeek) {
    return unitOutOfRange("week", obj.weekNumber);
  } else if (!validWeekday) {
    return unitOutOfRange("weekday", obj.weekday);
  } else return false;
}
function hasInvalidOrdinalData(obj) {
  var validYear = isInteger(obj.year),
    validOrdinal = integerBetween(obj.ordinal, 1, daysInYear(obj.year));
  if (!validYear) {
    return unitOutOfRange("year", obj.year);
  } else if (!validOrdinal) {
    return unitOutOfRange("ordinal", obj.ordinal);
  } else return false;
}
function hasInvalidGregorianData(obj) {
  var validYear = isInteger(obj.year),
    validMonth = integerBetween(obj.month, 1, 12),
    validDay = integerBetween(obj.day, 1, daysInMonth(obj.year, obj.month));
  if (!validYear) {
    return unitOutOfRange("year", obj.year);
  } else if (!validMonth) {
    return unitOutOfRange("month", obj.month);
  } else if (!validDay) {
    return unitOutOfRange("day", obj.day);
  } else return false;
}
function hasInvalidTimeData(obj) {
  var hour = obj.hour,
    minute = obj.minute,
    second = obj.second,
    millisecond = obj.millisecond;
  var validHour = integerBetween(hour, 0, 23) || hour === 24 && minute === 0 && second === 0 && millisecond === 0,
    validMinute = integerBetween(minute, 0, 59),
    validSecond = integerBetween(second, 0, 59),
    validMillisecond = integerBetween(millisecond, 0, 999);
  if (!validHour) {
    return unitOutOfRange("hour", hour);
  } else if (!validMinute) {
    return unitOutOfRange("minute", minute);
  } else if (!validSecond) {
    return unitOutOfRange("second", second);
  } else if (!validMillisecond) {
    return unitOutOfRange("millisecond", millisecond);
  } else return false;
}

/**
 * @private
 */

// TYPES

function isUndefined(o) {
  return typeof o === "undefined";
}
function isNumber(o) {
  return typeof o === "number";
}
function isInteger(o) {
  return typeof o === "number" && o % 1 === 0;
}
function isString(o) {
  return typeof o === "string";
}
function isDate(o) {
  return Object.prototype.toString.call(o) === "[object Date]";
}

// CAPABILITIES

function hasRelative() {
  try {
    return typeof Intl !== "undefined" && !!Intl.RelativeTimeFormat;
  } catch (e) {
    return false;
  }
}
function hasLocaleWeekInfo() {
  try {
    return typeof Intl !== "undefined" && !!Intl.Locale && ("weekInfo" in Intl.Locale.prototype || "getWeekInfo" in Intl.Locale.prototype);
  } catch (e) {
    return false;
  }
}

// OBJECTS AND ARRAYS

function maybeArray(thing) {
  return Array.isArray(thing) ? thing : [thing];
}
function bestBy(arr, by, compare) {
  if (arr.length === 0) {
    return undefined;
  }
  return arr.reduce(function (best, next) {
    var pair = [by(next), next];
    if (!best) {
      return pair;
    } else if (compare(best[0], pair[0]) === best[0]) {
      return best;
    } else {
      return pair;
    }
  }, null)[1];
}
function pick(obj, keys) {
  return keys.reduce(function (a, k) {
    a[k] = obj[k];
    return a;
  }, {});
}
function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}
function validateWeekSettings(settings) {
  if (settings == null) {
    return null;
  } else if (typeof settings !== "object") {
    throw new InvalidArgumentError("Week settings must be an object");
  } else {
    if (!integerBetween(settings.firstDay, 1, 7) || !integerBetween(settings.minimalDays, 1, 7) || !Array.isArray(settings.weekend) || settings.weekend.some(function (v) {
      return !integerBetween(v, 1, 7);
    })) {
      throw new InvalidArgumentError("Invalid week settings");
    }
    return {
      firstDay: settings.firstDay,
      minimalDays: settings.minimalDays,
      weekend: Array.from(settings.weekend)
    };
  }
}

// NUMBERS AND STRINGS

function integerBetween(thing, bottom, top) {
  return isInteger(thing) && thing >= bottom && thing <= top;
}

// x % n but takes the sign of n instead of x
function floorMod(x, n) {
  return x - n * Math.floor(x / n);
}
function padStart(input, n) {
  if (n === void 0) {
    n = 2;
  }
  var isNeg = input < 0;
  var padded;
  if (isNeg) {
    padded = "-" + ("" + -input).padStart(n, "0");
  } else {
    padded = ("" + input).padStart(n, "0");
  }
  return padded;
}
function parseInteger(string) {
  if (isUndefined(string) || string === null || string === "") {
    return undefined;
  } else {
    return parseInt(string, 10);
  }
}
function parseFloating(string) {
  if (isUndefined(string) || string === null || string === "") {
    return undefined;
  } else {
    return parseFloat(string);
  }
}
function parseMillis(fraction) {
  // Return undefined (instead of 0) in these cases, where fraction is not set
  if (isUndefined(fraction) || fraction === null || fraction === "") {
    return undefined;
  } else {
    var f = parseFloat("0." + fraction) * 1000;
    return Math.floor(f);
  }
}
function roundTo(number, digits, towardZero) {
  if (towardZero === void 0) {
    towardZero = false;
  }
  var factor = Math.pow(10, digits),
    rounder = towardZero ? Math.trunc : Math.round;
  return rounder(number * factor) / factor;
}

// DATE BASICS

function isLeapYear(year) {
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
function daysInYear(year) {
  return isLeapYear(year) ? 366 : 365;
}
function daysInMonth(year, month) {
  var modMonth = floorMod(month - 1, 12) + 1,
    modYear = year + (month - modMonth) / 12;
  if (modMonth === 2) {
    return isLeapYear(modYear) ? 29 : 28;
  } else {
    return [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][modMonth - 1];
  }
}

// convert a calendar object to a local timestamp (epoch, but with the offset baked in)
function objToLocalTS(obj) {
  var d = Date.UTC(obj.year, obj.month - 1, obj.day, obj.hour, obj.minute, obj.second, obj.millisecond);

  // for legacy reasons, years between 0 and 99 are interpreted as 19XX; revert that
  if (obj.year < 100 && obj.year >= 0) {
    d = new Date(d);
    // set the month and day again, this is necessary because year 2000 is a leap year, but year 100 is not
    // so if obj.year is in 99, but obj.day makes it roll over into year 100,
    // the calculations done by Date.UTC are using year 2000 - which is incorrect
    d.setUTCFullYear(obj.year, obj.month - 1, obj.day);
  }
  return +d;
}

// adapted from moment.js: https://github.com/moment/moment/blob/000ac1800e620f770f4eb31b5ae908f6167b0ab2/src/lib/units/week-calendar-utils.js
function firstWeekOffset(year, minDaysInFirstWeek, startOfWeek) {
  var fwdlw = isoWeekdayToLocal(dayOfWeek(year, 1, minDaysInFirstWeek), startOfWeek);
  return -fwdlw + minDaysInFirstWeek - 1;
}
function weeksInWeekYear(weekYear, minDaysInFirstWeek, startOfWeek) {
  if (minDaysInFirstWeek === void 0) {
    minDaysInFirstWeek = 4;
  }
  if (startOfWeek === void 0) {
    startOfWeek = 1;
  }
  var weekOffset = firstWeekOffset(weekYear, minDaysInFirstWeek, startOfWeek);
  var weekOffsetNext = firstWeekOffset(weekYear + 1, minDaysInFirstWeek, startOfWeek);
  return (daysInYear(weekYear) - weekOffset + weekOffsetNext) / 7;
}
function untruncateYear(year) {
  if (year > 99) {
    return year;
  } else return year > Settings.twoDigitCutoffYear ? 1900 + year : 2000 + year;
}

// PARSING

function parseZoneInfo(ts, offsetFormat, locale, timeZone) {
  if (timeZone === void 0) {
    timeZone = null;
  }
  var date = new Date(ts),
    intlOpts = {
      hourCycle: "h23",
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit"
    };
  if (timeZone) {
    intlOpts.timeZone = timeZone;
  }
  var modified = _extends({
    timeZoneName: offsetFormat
  }, intlOpts);
  var parsed = new Intl.DateTimeFormat(locale, modified).formatToParts(date).find(function (m) {
    return m.type.toLowerCase() === "timezonename";
  });
  return parsed ? parsed.value : null;
}

// signedOffset('-5', '30') -> -330
function signedOffset(offHourStr, offMinuteStr) {
  var offHour = parseInt(offHourStr, 10);

  // don't || this because we want to preserve -0
  if (Number.isNaN(offHour)) {
    offHour = 0;
  }
  var offMin = parseInt(offMinuteStr, 10) || 0,
    offMinSigned = offHour < 0 || Object.is(offHour, -0) ? -offMin : offMin;
  return offHour * 60 + offMinSigned;
}

// COERCION

function asNumber(value) {
  var numericValue = Number(value);
  if (typeof value === "boolean" || value === "" || Number.isNaN(numericValue)) throw new InvalidArgumentError("Invalid unit value " + value);
  return numericValue;
}
function normalizeObject(obj, normalizer) {
  var normalized = {};
  for (var u in obj) {
    if (hasOwnProperty(obj, u)) {
      var v = obj[u];
      if (v === undefined || v === null) continue;
      normalized[normalizer(u)] = asNumber(v);
    }
  }
  return normalized;
}
function formatOffset(offset, format) {
  var hours = Math.trunc(Math.abs(offset / 60)),
    minutes = Math.trunc(Math.abs(offset % 60)),
    sign = offset >= 0 ? "+" : "-";
  switch (format) {
    case "short":
      return "" + sign + padStart(hours, 2) + ":" + padStart(minutes, 2);
    case "narrow":
      return "" + sign + hours + (minutes > 0 ? ":" + minutes : "");
    case "techie":
      return "" + sign + padStart(hours, 2) + padStart(minutes, 2);
    default:
      throw new RangeError("Value format " + format + " is out of range for property format");
  }
}
function timeObject(obj) {
  return pick(obj, ["hour", "minute", "second", "millisecond"]);
}

/**
 * @private
 */

var monthsLong = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
var monthsShort = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
var monthsNarrow = ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"];
function months(length) {
  switch (length) {
    case "narrow":
      return [].concat(monthsNarrow);
    case "short":
      return [].concat(monthsShort);
    case "long":
      return [].concat(monthsLong);
    case "numeric":
      return ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];
    case "2-digit":
      return ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];
    default:
      return null;
  }
}
var weekdaysLong = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"];
var weekdaysShort = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
var weekdaysNarrow = ["M", "T", "W", "T", "F", "S", "S"];
function weekdays(length) {
  switch (length) {
    case "narrow":
      return [].concat(weekdaysNarrow);
    case "short":
      return [].concat(weekdaysShort);
    case "long":
      return [].concat(weekdaysLong);
    case "numeric":
      return ["1", "2", "3", "4", "5", "6", "7"];
    default:
      return null;
  }
}
var meridiems = ["AM", "PM"];
var erasLong = ["Before Christ", "Anno Domini"];
var erasShort = ["BC", "AD"];
var erasNarrow = ["B", "A"];
function eras(length) {
  switch (length) {
    case "narrow":
      return [].concat(erasNarrow);
    case "short":
      return [].concat(erasShort);
    case "long":
      return [].concat(erasLong);
    default:
      return null;
  }
}
function meridiemForDateTime(dt) {
  return meridiems[dt.hour < 12 ? 0 : 1];
}
function weekdayForDateTime(dt, length) {
  return weekdays(length)[dt.weekday - 1];
}
function monthForDateTime(dt, length) {
  return months(length)[dt.month - 1];
}
function eraForDateTime(dt, length) {
  return eras(length)[dt.year < 0 ? 0 : 1];
}
function formatRelativeTime(unit, count, numeric, narrow) {
  if (numeric === void 0) {
    numeric = "always";
  }
  if (narrow === void 0) {
    narrow = false;
  }
  var units = {
    years: ["year", "yr."],
    quarters: ["quarter", "qtr."],
    months: ["month", "mo."],
    weeks: ["week", "wk."],
    days: ["day", "day", "days"],
    hours: ["hour", "hr."],
    minutes: ["minute", "min."],
    seconds: ["second", "sec."]
  };
  var lastable = ["hours", "minutes", "seconds"].indexOf(unit) === -1;
  if (numeric === "auto" && lastable) {
    var isDay = unit === "days";
    switch (count) {
      case 1:
        return isDay ? "tomorrow" : "next " + units[unit][0];
      case -1:
        return isDay ? "yesterday" : "last " + units[unit][0];
      case 0:
        return isDay ? "today" : "this " + units[unit][0];
    }
  }

  var isInPast = Object.is(count, -0) || count < 0,
    fmtValue = Math.abs(count),
    singular = fmtValue === 1,
    lilUnits = units[unit],
    fmtUnit = narrow ? singular ? lilUnits[1] : lilUnits[2] || lilUnits[1] : singular ? units[unit][0] : unit;
  return isInPast ? fmtValue + " " + fmtUnit + " ago" : "in " + fmtValue + " " + fmtUnit;
}

function stringifyTokens(splits, tokenToString) {
  var s = "";
  for (var _iterator = _createForOfIteratorHelperLoose(splits), _step; !(_step = _iterator()).done;) {
    var token = _step.value;
    if (token.literal) {
      s += token.val;
    } else {
      s += tokenToString(token.val);
    }
  }
  return s;
}
var _macroTokenToFormatOpts = {
  D: DATE_SHORT,
  DD: DATE_MED,
  DDD: DATE_FULL,
  DDDD: DATE_HUGE,
  t: TIME_SIMPLE,
  tt: TIME_WITH_SECONDS,
  ttt: TIME_WITH_SHORT_OFFSET,
  tttt: TIME_WITH_LONG_OFFSET,
  T: TIME_24_SIMPLE,
  TT: TIME_24_WITH_SECONDS,
  TTT: TIME_24_WITH_SHORT_OFFSET,
  TTTT: TIME_24_WITH_LONG_OFFSET,
  f: DATETIME_SHORT,
  ff: DATETIME_MED,
  fff: DATETIME_FULL,
  ffff: DATETIME_HUGE,
  F: DATETIME_SHORT_WITH_SECONDS,
  FF: DATETIME_MED_WITH_SECONDS,
  FFF: DATETIME_FULL_WITH_SECONDS,
  FFFF: DATETIME_HUGE_WITH_SECONDS
};

/**
 * @private
 */
var Formatter = /*#__PURE__*/function () {
  Formatter.create = function create(locale, opts) {
    if (opts === void 0) {
      opts = {};
    }
    return new Formatter(locale, opts);
  };
  Formatter.parseFormat = function parseFormat(fmt) {
    // white-space is always considered a literal in user-provided formats
    // the " " token has a special meaning (see unitForToken)

    var current = null,
      currentFull = "",
      bracketed = false;
    var splits = [];
    for (var i = 0; i < fmt.length; i++) {
      var c = fmt.charAt(i);
      if (c === "'") {
        if (currentFull.length > 0) {
          splits.push({
            literal: bracketed || /^\s+$/.test(currentFull),
            val: currentFull
          });
        }
        current = null;
        currentFull = "";
        bracketed = !bracketed;
      } else if (bracketed) {
        currentFull += c;
      } else if (c === current) {
        currentFull += c;
      } else {
        if (currentFull.length > 0) {
          splits.push({
            literal: /^\s+$/.test(currentFull),
            val: currentFull
          });
        }
        currentFull = c;
        current = c;
      }
    }
    if (currentFull.length > 0) {
      splits.push({
        literal: bracketed || /^\s+$/.test(currentFull),
        val: currentFull
      });
    }
    return splits;
  };
  Formatter.macroTokenToFormatOpts = function macroTokenToFormatOpts(token) {
    return _macroTokenToFormatOpts[token];
  };
  function Formatter(locale, formatOpts) {
    this.opts = formatOpts;
    this.loc = locale;
    this.systemLoc = null;
  }
  var _proto = Formatter.prototype;
  _proto.formatWithSystemDefault = function formatWithSystemDefault(dt, opts) {
    if (this.systemLoc === null) {
      this.systemLoc = this.loc.redefaultToSystem();
    }
    var df = this.systemLoc.dtFormatter(dt, _extends({}, this.opts, opts));
    return df.format();
  };
  _proto.dtFormatter = function dtFormatter(dt, opts) {
    if (opts === void 0) {
      opts = {};
    }
    return this.loc.dtFormatter(dt, _extends({}, this.opts, opts));
  };
  _proto.formatDateTime = function formatDateTime(dt, opts) {
    return this.dtFormatter(dt, opts).format();
  };
  _proto.formatDateTimeParts = function formatDateTimeParts(dt, opts) {
    return this.dtFormatter(dt, opts).formatToParts();
  };
  _proto.formatInterval = function formatInterval(interval, opts) {
    var df = this.dtFormatter(interval.start, opts);
    return df.dtf.formatRange(interval.start.toJSDate(), interval.end.toJSDate());
  };
  _proto.resolvedOptions = function resolvedOptions(dt, opts) {
    return this.dtFormatter(dt, opts).resolvedOptions();
  };
  _proto.num = function num(n, p) {
    if (p === void 0) {
      p = 0;
    }
    // we get some perf out of doing this here, annoyingly
    if (this.opts.forceSimple) {
      return padStart(n, p);
    }
    var opts = _extends({}, this.opts);
    if (p > 0) {
      opts.padTo = p;
    }
    return this.loc.numberFormatter(opts).format(n);
  };
  _proto.formatDateTimeFromString = function formatDateTimeFromString(dt, fmt) {
    var _this = this;
    var knownEnglish = this.loc.listingMode() === "en",
      useDateTimeFormatter = this.loc.outputCalendar && this.loc.outputCalendar !== "gregory",
      string = function string(opts, extract) {
        return _this.loc.extract(dt, opts, extract);
      },
      formatOffset = function formatOffset(opts) {
        if (dt.isOffsetFixed && dt.offset === 0 && opts.allowZ) {
          return "Z";
        }
        return dt.isValid ? dt.zone.formatOffset(dt.ts, opts.format) : "";
      },
      meridiem = function meridiem() {
        return knownEnglish ? meridiemForDateTime(dt) : string({
          hour: "numeric",
          hourCycle: "h12"
        }, "dayperiod");
      },
      month = function month(length, standalone) {
        return knownEnglish ? monthForDateTime(dt, length) : string(standalone ? {
          month: length
        } : {
          month: length,
          day: "numeric"
        }, "month");
      },
      weekday = function weekday(length, standalone) {
        return knownEnglish ? weekdayForDateTime(dt, length) : string(standalone ? {
          weekday: length
        } : {
          weekday: length,
          month: "long",
          day: "numeric"
        }, "weekday");
      },
      maybeMacro = function maybeMacro(token) {
        var formatOpts = Formatter.macroTokenToFormatOpts(token);
        if (formatOpts) {
          return _this.formatWithSystemDefault(dt, formatOpts);
        } else {
          return token;
        }
      },
      era = function era(length) {
        return knownEnglish ? eraForDateTime(dt, length) : string({
          era: length
        }, "era");
      },
      tokenToString = function tokenToString(token) {
        // Where possible: https://cldr.unicode.org/translation/date-time/date-time-symbols
        switch (token) {
          // ms
          case "S":
            return _this.num(dt.millisecond);
          case "u":
          // falls through
          case "SSS":
            return _this.num(dt.millisecond, 3);
          // seconds
          case "s":
            return _this.num(dt.second);
          case "ss":
            return _this.num(dt.second, 2);
          // fractional seconds
          case "uu":
            return _this.num(Math.floor(dt.millisecond / 10), 2);
          case "uuu":
            return _this.num(Math.floor(dt.millisecond / 100));
          // minutes
          case "m":
            return _this.num(dt.minute);
          case "mm":
            return _this.num(dt.minute, 2);
          // hours
          case "h":
            return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12);
          case "hh":
            return _this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12, 2);
          case "H":
            return _this.num(dt.hour);
          case "HH":
            return _this.num(dt.hour, 2);
          // offset
          case "Z":
            // like +6
            return formatOffset({
              format: "narrow",
              allowZ: _this.opts.allowZ
            });
          case "ZZ":
            // like +06:00
            return formatOffset({
              format: "short",
              allowZ: _this.opts.allowZ
            });
          case "ZZZ":
            // like +0600
            return formatOffset({
              format: "techie",
              allowZ: _this.opts.allowZ
            });
          case "ZZZZ":
            // like EST
            return dt.zone.offsetName(dt.ts, {
              format: "short",
              locale: _this.loc.locale
            });
          case "ZZZZZ":
            // like Eastern Standard Time
            return dt.zone.offsetName(dt.ts, {
              format: "long",
              locale: _this.loc.locale
            });
          // zone
          case "z":
            // like America/New_York
            return dt.zoneName;
          // meridiems
          case "a":
            return meridiem();
          // dates
          case "d":
            return useDateTimeFormatter ? string({
              day: "numeric"
            }, "day") : _this.num(dt.day);
          case "dd":
            return useDateTimeFormatter ? string({
              day: "2-digit"
            }, "day") : _this.num(dt.day, 2);
          // weekdays - standalone
          case "c":
            // like 1
            return _this.num(dt.weekday);
          case "ccc":
            // like 'Tues'
            return weekday("short", true);
          case "cccc":
            // like 'Tuesday'
            return weekday("long", true);
          case "ccccc":
            // like 'T'
            return weekday("narrow", true);
          // weekdays - format
          case "E":
            // like 1
            return _this.num(dt.weekday);
          case "EEE":
            // like 'Tues'
            return weekday("short", false);
          case "EEEE":
            // like 'Tuesday'
            return weekday("long", false);
          case "EEEEE":
            // like 'T'
            return weekday("narrow", false);
          // months - standalone
          case "L":
            // like 1
            return useDateTimeFormatter ? string({
              month: "numeric",
              day: "numeric"
            }, "month") : _this.num(dt.month);
          case "LL":
            // like 01, doesn't seem to work
            return useDateTimeFormatter ? string({
              month: "2-digit",
              day: "numeric"
            }, "month") : _this.num(dt.month, 2);
          case "LLL":
            // like Jan
            return month("short", true);
          case "LLLL":
            // like January
            return month("long", true);
          case "LLLLL":
            // like J
            return month("narrow", true);
          // months - format
          case "M":
            // like 1
            return useDateTimeFormatter ? string({
              month: "numeric"
            }, "month") : _this.num(dt.month);
          case "MM":
            // like 01
            return useDateTimeFormatter ? string({
              month: "2-digit"
            }, "month") : _this.num(dt.month, 2);
          case "MMM":
            // like Jan
            return month("short", false);
          case "MMMM":
            // like January
            return month("long", false);
          case "MMMMM":
            // like J
            return month("narrow", false);
          // years
          case "y":
            // like 2014
            return useDateTimeFormatter ? string({
              year: "numeric"
            }, "year") : _this.num(dt.year);
          case "yy":
            // like 14
            return useDateTimeFormatter ? string({
              year: "2-digit"
            }, "year") : _this.num(dt.year.toString().slice(-2), 2);
          case "yyyy":
            // like 0012
            return useDateTimeFormatter ? string({
              year: "numeric"
            }, "year") : _this.num(dt.year, 4);
          case "yyyyyy":
            // like 000012
            return useDateTimeFormatter ? string({
              year: "numeric"
            }, "year") : _this.num(dt.year, 6);
          // eras
          case "G":
            // like AD
            return era("short");
          case "GG":
            // like Anno Domini
            return era("long");
          case "GGGGG":
            return era("narrow");
          case "kk":
            return _this.num(dt.weekYear.toString().slice(-2), 2);
          case "kkkk":
            return _this.num(dt.weekYear, 4);
          case "W":
            return _this.num(dt.weekNumber);
          case "WW":
            return _this.num(dt.weekNumber, 2);
          case "n":
            return _this.num(dt.localWeekNumber);
          case "nn":
            return _this.num(dt.localWeekNumber, 2);
          case "ii":
            return _this.num(dt.localWeekYear.toString().slice(-2), 2);
          case "iiii":
            return _this.num(dt.localWeekYear, 4);
          case "o":
            return _this.num(dt.ordinal);
          case "ooo":
            return _this.num(dt.ordinal, 3);
          case "q":
            // like 1
            return _this.num(dt.quarter);
          case "qq":
            // like 01
            return _this.num(dt.quarter, 2);
          case "X":
            return _this.num(Math.floor(dt.ts / 1000));
          case "x":
            return _this.num(dt.ts);
          default:
            return maybeMacro(token);
        }
      };
    return stringifyTokens(Formatter.parseFormat(fmt), tokenToString);
  };
  _proto.formatDurationFromString = function formatDurationFromString(dur, fmt) {
    var _this2 = this;
    var tokenToField = function tokenToField(token) {
        switch (token[0]) {
          case "S":
            return "millisecond";
          case "s":
            return "second";
          case "m":
            return "minute";
          case "h":
            return "hour";
          case "d":
            return "day";
          case "w":
            return "week";
          case "M":
            return "month";
          case "y":
            return "year";
          default:
            return null;
        }
      },
      tokenToString = function tokenToString(lildur) {
        return function (token) {
          var mapped = tokenToField(token);
          if (mapped) {
            return _this2.num(lildur.get(mapped), token.length);
          } else {
            return token;
          }
        };
      },
      tokens = Formatter.parseFormat(fmt),
      realTokens = tokens.reduce(function (found, _ref) {
        var literal = _ref.literal,
          val = _ref.val;
        return literal ? found : found.concat(val);
      }, []),
      collapsed = dur.shiftTo.apply(dur, realTokens.map(tokenToField).filter(function (t) {
        return t;
      }));
    return stringifyTokens(tokens, tokenToString(collapsed));
  };
  return Formatter;
}();

/*
 * This file handles parsing for well-specified formats. Here's how it works:
 * Two things go into parsing: a regex to match with and an extractor to take apart the groups in the match.
 * An extractor is just a function that takes a regex match array and returns a { year: ..., month: ... } object
 * parse() does the work of executing the regex and applying the extractor. It takes multiple regex/extractor pairs to try in sequence.
 * Extractors can take a "cursor" representing the offset in the match to look at. This makes it easy to combine extractors.
 * combineExtractors() does the work of combining them, keeping track of the cursor through multiple extractions.
 * Some extractions are super dumb and simpleParse and fromStrings help DRY them.
 */

var ianaRegex = /[A-Za-z_+-]{1,256}(?::?\/[A-Za-z0-9_+-]{1,256}(?:\/[A-Za-z0-9_+-]{1,256})?)?/;
function combineRegexes() {
  for (var _len = arguments.length, regexes = new Array(_len), _key = 0; _key < _len; _key++) {
    regexes[_key] = arguments[_key];
  }
  var full = regexes.reduce(function (f, r) {
    return f + r.source;
  }, "");
  return RegExp("^" + full + "$");
}
function combineExtractors() {
  for (var _len2 = arguments.length, extractors = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    extractors[_key2] = arguments[_key2];
  }
  return function (m) {
    return extractors.reduce(function (_ref, ex) {
      var mergedVals = _ref[0],
        mergedZone = _ref[1],
        cursor = _ref[2];
      var _ex = ex(m, cursor),
        val = _ex[0],
        zone = _ex[1],
        next = _ex[2];
      return [_extends({}, mergedVals, val), zone || mergedZone, next];
    }, [{}, null, 1]).slice(0, 2);
  };
}
function parse(s) {
  if (s == null) {
    return [null, null];
  }
  for (var _len3 = arguments.length, patterns = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    patterns[_key3 - 1] = arguments[_key3];
  }
  for (var _i = 0, _patterns = patterns; _i < _patterns.length; _i++) {
    var _patterns$_i = _patterns[_i],
      regex = _patterns$_i[0],
      extractor = _patterns$_i[1];
    var m = regex.exec(s);
    if (m) {
      return extractor(m);
    }
  }
  return [null, null];
}
function simpleParse() {
  for (var _len4 = arguments.length, keys = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
    keys[_key4] = arguments[_key4];
  }
  return function (match, cursor) {
    var ret = {};
    var i;
    for (i = 0; i < keys.length; i++) {
      ret[keys[i]] = parseInteger(match[cursor + i]);
    }
    return [ret, null, cursor + i];
  };
}

// ISO and SQL parsing
var offsetRegex = /(?:(Z)|([+-]\d\d)(?::?(\d\d))?)/;
var isoExtendedZone = "(?:" + offsetRegex.source + "?(?:\\[(" + ianaRegex.source + ")\\])?)?";
var isoTimeBaseRegex = /(\d\d)(?::?(\d\d)(?::?(\d\d)(?:[.,](\d{1,30}))?)?)?/;
var isoTimeRegex = RegExp("" + isoTimeBaseRegex.source + isoExtendedZone);
var isoTimeExtensionRegex = RegExp("(?:T" + isoTimeRegex.source + ")?");
var isoYmdRegex = /([+-]\d{6}|\d{4})(?:-?(\d\d)(?:-?(\d\d))?)?/;
var isoWeekRegex = /(\d{4})-?W(\d\d)(?:-?(\d))?/;
var isoOrdinalRegex = /(\d{4})-?(\d{3})/;
var extractISOWeekData = simpleParse("weekYear", "weekNumber", "weekDay");
var extractISOOrdinalData = simpleParse("year", "ordinal");
var sqlYmdRegex = /(\d{4})-(\d\d)-(\d\d)/; // dumbed-down version of the ISO one
var sqlTimeRegex = RegExp(isoTimeBaseRegex.source + " ?(?:" + offsetRegex.source + "|(" + ianaRegex.source + "))?");
var sqlTimeExtensionRegex = RegExp("(?: " + sqlTimeRegex.source + ")?");
function int(match, pos, fallback) {
  var m = match[pos];
  return isUndefined(m) ? fallback : parseInteger(m);
}
function extractISOYmd(match, cursor) {
  var item = {
    year: int(match, cursor),
    month: int(match, cursor + 1, 1),
    day: int(match, cursor + 2, 1)
  };
  return [item, null, cursor + 3];
}
function extractISOTime(match, cursor) {
  var item = {
    hours: int(match, cursor, 0),
    minutes: int(match, cursor + 1, 0),
    seconds: int(match, cursor + 2, 0),
    milliseconds: parseMillis(match[cursor + 3])
  };
  return [item, null, cursor + 4];
}
function extractISOOffset(match, cursor) {
  var local = !match[cursor] && !match[cursor + 1],
    fullOffset = signedOffset(match[cursor + 1], match[cursor + 2]),
    zone = local ? null : FixedOffsetZone.instance(fullOffset);
  return [{}, zone, cursor + 3];
}
function extractIANAZone(match, cursor) {
  var zone = match[cursor] ? IANAZone.create(match[cursor]) : null;
  return [{}, zone, cursor + 1];
}

// ISO time parsing

var isoTimeOnly = RegExp("^T?" + isoTimeBaseRegex.source + "$");

// ISO duration parsing

var isoDuration = /^-?P(?:(?:(-?\d{1,20}(?:\.\d{1,20})?)Y)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20}(?:\.\d{1,20})?)W)?(?:(-?\d{1,20}(?:\.\d{1,20})?)D)?(?:T(?:(-?\d{1,20}(?:\.\d{1,20})?)H)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20})(?:[.,](-?\d{1,20}))?S)?)?)$/;
function extractISODuration(match) {
  var s = match[0],
    yearStr = match[1],
    monthStr = match[2],
    weekStr = match[3],
    dayStr = match[4],
    hourStr = match[5],
    minuteStr = match[6],
    secondStr = match[7],
    millisecondsStr = match[8];
  var hasNegativePrefix = s[0] === "-";
  var negativeSeconds = secondStr && secondStr[0] === "-";
  var maybeNegate = function maybeNegate(num, force) {
    if (force === void 0) {
      force = false;
    }
    return num !== undefined && (force || num && hasNegativePrefix) ? -num : num;
  };
  return [{
    years: maybeNegate(parseFloating(yearStr)),
    months: maybeNegate(parseFloating(monthStr)),
    weeks: maybeNegate(parseFloating(weekStr)),
    days: maybeNegate(parseFloating(dayStr)),
    hours: maybeNegate(parseFloating(hourStr)),
    minutes: maybeNegate(parseFloating(minuteStr)),
    seconds: maybeNegate(parseFloating(secondStr), secondStr === "-0"),
    milliseconds: maybeNegate(parseMillis(millisecondsStr), negativeSeconds)
  }];
}

// These are a little braindead. EDT *should* tell us that we're in, say, America/New_York
// and not just that we're in -240 *right now*. But since I don't think these are used that often
// I'm just going to ignore that
var obsOffsets = {
  GMT: 0,
  EDT: -4 * 60,
  EST: -5 * 60,
  CDT: -5 * 60,
  CST: -6 * 60,
  MDT: -6 * 60,
  MST: -7 * 60,
  PDT: -7 * 60,
  PST: -8 * 60
};
function fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
  var result = {
    year: yearStr.length === 2 ? untruncateYear(parseInteger(yearStr)) : parseInteger(yearStr),
    month: monthsShort.indexOf(monthStr) + 1,
    day: parseInteger(dayStr),
    hour: parseInteger(hourStr),
    minute: parseInteger(minuteStr)
  };
  if (secondStr) result.second = parseInteger(secondStr);
  if (weekdayStr) {
    result.weekday = weekdayStr.length > 3 ? weekdaysLong.indexOf(weekdayStr) + 1 : weekdaysShort.indexOf(weekdayStr) + 1;
  }
  return result;
}

// RFC 2822/5322
var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|(?:([+-]\d\d)(\d\d)))$/;
function extractRFC2822(match) {
  var weekdayStr = match[1],
    dayStr = match[2],
    monthStr = match[3],
    yearStr = match[4],
    hourStr = match[5],
    minuteStr = match[6],
    secondStr = match[7],
    obsOffset = match[8],
    milOffset = match[9],
    offHourStr = match[10],
    offMinuteStr = match[11],
    result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  var offset;
  if (obsOffset) {
    offset = obsOffsets[obsOffset];
  } else if (milOffset) {
    offset = 0;
  } else {
    offset = signedOffset(offHourStr, offMinuteStr);
  }
  return [result, new FixedOffsetZone(offset)];
}
function preprocessRFC2822(s) {
  // Remove comments and folding whitespace and replace multiple-spaces with a single space
  return s.replace(/\([^()]*\)|[\n\t]/g, " ").replace(/(\s\s+)/g, " ").trim();
}

// http date

var rfc1123 = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d\d) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d\d):(\d\d):(\d\d) GMT$/,
  rfc850 = /^(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\d\d)-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d\d) (\d\d):(\d\d):(\d\d) GMT$/,
  ascii = /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( \d|\d\d) (\d\d):(\d\d):(\d\d) (\d{4})$/;
function extractRFC1123Or850(match) {
  var weekdayStr = match[1],
    dayStr = match[2],
    monthStr = match[3],
    yearStr = match[4],
    hourStr = match[5],
    minuteStr = match[6],
    secondStr = match[7],
    result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  return [result, FixedOffsetZone.utcInstance];
}
function extractASCII(match) {
  var weekdayStr = match[1],
    monthStr = match[2],
    dayStr = match[3],
    hourStr = match[4],
    minuteStr = match[5],
    secondStr = match[6],
    yearStr = match[7],
    result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
  return [result, FixedOffsetZone.utcInstance];
}
var isoYmdWithTimeExtensionRegex = combineRegexes(isoYmdRegex, isoTimeExtensionRegex);
var isoWeekWithTimeExtensionRegex = combineRegexes(isoWeekRegex, isoTimeExtensionRegex);
var isoOrdinalWithTimeExtensionRegex = combineRegexes(isoOrdinalRegex, isoTimeExtensionRegex);
var isoTimeCombinedRegex = combineRegexes(isoTimeRegex);
var extractISOYmdTimeAndOffset = combineExtractors(extractISOYmd, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOWeekTimeAndOffset = combineExtractors(extractISOWeekData, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOOrdinalDateAndTime = combineExtractors(extractISOOrdinalData, extractISOTime, extractISOOffset, extractIANAZone);
var extractISOTimeAndOffset = combineExtractors(extractISOTime, extractISOOffset, extractIANAZone);

/*
 * @private
 */

function parseISODate(s) {
  return parse(s, [isoYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset], [isoWeekWithTimeExtensionRegex, extractISOWeekTimeAndOffset], [isoOrdinalWithTimeExtensionRegex, extractISOOrdinalDateAndTime], [isoTimeCombinedRegex, extractISOTimeAndOffset]);
}
function parseRFC2822Date(s) {
  return parse(preprocessRFC2822(s), [rfc2822, extractRFC2822]);
}
function parseHTTPDate(s) {
  return parse(s, [rfc1123, extractRFC1123Or850], [rfc850, extractRFC1123Or850], [ascii, extractASCII]);
}
function parseISODuration(s) {
  return parse(s, [isoDuration, extractISODuration]);
}
var extractISOTimeOnly = combineExtractors(extractISOTime);
function parseISOTimeOnly(s) {
  return parse(s, [isoTimeOnly, extractISOTimeOnly]);
}
var sqlYmdWithTimeExtensionRegex = combineRegexes(sqlYmdRegex, sqlTimeExtensionRegex);
var sqlTimeCombinedRegex = combineRegexes(sqlTimeRegex);
var extractISOTimeOffsetAndIANAZone = combineExtractors(extractISOTime, extractISOOffset, extractIANAZone);
function parseSQL(s) {
  return parse(s, [sqlYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset], [sqlTimeCombinedRegex, extractISOTimeOffsetAndIANAZone]);
}

var INVALID$2 = "Invalid Duration";

// unit conversion constants
var lowOrderMatrix = {
    weeks: {
      days: 7,
      hours: 7 * 24,
      minutes: 7 * 24 * 60,
      seconds: 7 * 24 * 60 * 60,
      milliseconds: 7 * 24 * 60 * 60 * 1000
    },
    days: {
      hours: 24,
      minutes: 24 * 60,
      seconds: 24 * 60 * 60,
      milliseconds: 24 * 60 * 60 * 1000
    },
    hours: {
      minutes: 60,
      seconds: 60 * 60,
      milliseconds: 60 * 60 * 1000
    },
    minutes: {
      seconds: 60,
      milliseconds: 60 * 1000
    },
    seconds: {
      milliseconds: 1000
    }
  },
  casualMatrix = _extends({
    years: {
      quarters: 4,
      months: 12,
      weeks: 52,
      days: 365,
      hours: 365 * 24,
      minutes: 365 * 24 * 60,
      seconds: 365 * 24 * 60 * 60,
      milliseconds: 365 * 24 * 60 * 60 * 1000
    },
    quarters: {
      months: 3,
      weeks: 13,
      days: 91,
      hours: 91 * 24,
      minutes: 91 * 24 * 60,
      seconds: 91 * 24 * 60 * 60,
      milliseconds: 91 * 24 * 60 * 60 * 1000
    },
    months: {
      weeks: 4,
      days: 30,
      hours: 30 * 24,
      minutes: 30 * 24 * 60,
      seconds: 30 * 24 * 60 * 60,
      milliseconds: 30 * 24 * 60 * 60 * 1000
    }
  }, lowOrderMatrix),
  daysInYearAccurate = 146097.0 / 400,
  daysInMonthAccurate = 146097.0 / 4800,
  accurateMatrix = _extends({
    years: {
      quarters: 4,
      months: 12,
      weeks: daysInYearAccurate / 7,
      days: daysInYearAccurate,
      hours: daysInYearAccurate * 24,
      minutes: daysInYearAccurate * 24 * 60,
      seconds: daysInYearAccurate * 24 * 60 * 60,
      milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000
    },
    quarters: {
      months: 3,
      weeks: daysInYearAccurate / 28,
      days: daysInYearAccurate / 4,
      hours: daysInYearAccurate * 24 / 4,
      minutes: daysInYearAccurate * 24 * 60 / 4,
      seconds: daysInYearAccurate * 24 * 60 * 60 / 4,
      milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000 / 4
    },
    months: {
      weeks: daysInMonthAccurate / 7,
      days: daysInMonthAccurate,
      hours: daysInMonthAccurate * 24,
      minutes: daysInMonthAccurate * 24 * 60,
      seconds: daysInMonthAccurate * 24 * 60 * 60,
      milliseconds: daysInMonthAccurate * 24 * 60 * 60 * 1000
    }
  }, lowOrderMatrix);

// units ordered by size
var orderedUnits$1 = ["years", "quarters", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds"];
var reverseUnits = orderedUnits$1.slice(0).reverse();

// clone really means "create another instance just like this one, but with these changes"
function clone$1(dur, alts, clear) {
  if (clear === void 0) {
    clear = false;
  }
  // deep merge for vals
  var conf = {
    values: clear ? alts.values : _extends({}, dur.values, alts.values || {}),
    loc: dur.loc.clone(alts.loc),
    conversionAccuracy: alts.conversionAccuracy || dur.conversionAccuracy,
    matrix: alts.matrix || dur.matrix
  };
  return new Duration(conf);
}
function durationToMillis(matrix, vals) {
  var _vals$milliseconds;
  var sum = (_vals$milliseconds = vals.milliseconds) != null ? _vals$milliseconds : 0;
  for (var _iterator = _createForOfIteratorHelperLoose(reverseUnits.slice(1)), _step; !(_step = _iterator()).done;) {
    var unit = _step.value;
    if (vals[unit]) {
      sum += vals[unit] * matrix[unit]["milliseconds"];
    }
  }
  return sum;
}

// NB: mutates parameters
function normalizeValues(matrix, vals) {
  // the logic below assumes the overall value of the duration is positive
  // if this is not the case, factor is used to make it so
  var factor = durationToMillis(matrix, vals) < 0 ? -1 : 1;
  orderedUnits$1.reduceRight(function (previous, current) {
    if (!isUndefined(vals[current])) {
      if (previous) {
        var previousVal = vals[previous] * factor;
        var conv = matrix[current][previous];

        // if (previousVal < 0):
        // lower order unit is negative (e.g. { years: 2, days: -2 })
        // normalize this by reducing the higher order unit by the appropriate amount
        // and increasing the lower order unit
        // this can never make the higher order unit negative, because this function only operates
        // on positive durations, so the amount of time represented by the lower order unit cannot
        // be larger than the higher order unit
        // else:
        // lower order unit is positive (e.g. { years: 2, days: 450 } or { years: -2, days: 450 })
        // in this case we attempt to convert as much as possible from the lower order unit into
        // the higher order one
        //
        // Math.floor takes care of both of these cases, rounding away from 0
        // if previousVal < 0 it makes the absolute value larger
        // if previousVal >= it makes the absolute value smaller
        var rollUp = Math.floor(previousVal / conv);
        vals[current] += rollUp * factor;
        vals[previous] -= rollUp * conv * factor;
      }
      return current;
    } else {
      return previous;
    }
  }, null);

  // try to convert any decimals into smaller units if possible
  // for example for { years: 2.5, days: 0, seconds: 0 } we want to get { years: 2, days: 182, hours: 12 }
  orderedUnits$1.reduce(function (previous, current) {
    if (!isUndefined(vals[current])) {
      if (previous) {
        var fraction = vals[previous] % 1;
        vals[previous] -= fraction;
        vals[current] += fraction * matrix[previous][current];
      }
      return current;
    } else {
      return previous;
    }
  }, null);
}

// Remove all properties with a value of 0 from an object
function removeZeroes(vals) {
  var newVals = {};
  for (var _i = 0, _Object$entries = Object.entries(vals); _i < _Object$entries.length; _i++) {
    var _Object$entries$_i = _Object$entries[_i],
      key = _Object$entries$_i[0],
      value = _Object$entries$_i[1];
    if (value !== 0) {
      newVals[key] = value;
    }
  }
  return newVals;
}

/**
 * A Duration object represents a period of time, like "2 months" or "1 day, 1 hour". Conceptually, it's just a map of units to their quantities, accompanied by some additional configuration and methods for creating, parsing, interrogating, transforming, and formatting them. They can be used on their own or in conjunction with other Luxon types; for example, you can use {@link DateTime#plus} to add a Duration object to a DateTime, producing another DateTime.
 *
 * Here is a brief overview of commonly used methods and getters in Duration:
 *
 * * **Creation** To create a Duration, use {@link Duration.fromMillis}, {@link Duration.fromObject}, or {@link Duration.fromISO}.
 * * **Unit values** See the {@link Duration#years}, {@link Duration#months}, {@link Duration#weeks}, {@link Duration#days}, {@link Duration#hours}, {@link Duration#minutes}, {@link Duration#seconds}, {@link Duration#milliseconds} accessors.
 * * **Configuration** See  {@link Duration#locale} and {@link Duration#numberingSystem} accessors.
 * * **Transformation** To create new Durations out of old ones use {@link Duration#plus}, {@link Duration#minus}, {@link Duration#normalize}, {@link Duration#set}, {@link Duration#reconfigure}, {@link Duration#shiftTo}, and {@link Duration#negate}.
 * * **Output** To convert the Duration into other representations, see {@link Duration#as}, {@link Duration#toISO}, {@link Duration#toFormat}, and {@link Duration#toJSON}
 *
 * There's are more methods documented below. In addition, for more information on subtler topics like internationalization and validity, see the external documentation.
 */
var Duration = /*#__PURE__*/function (_Symbol$for) {
  /**
   * @private
   */
  function Duration(config) {
    var accurate = config.conversionAccuracy === "longterm" || false;
    var matrix = accurate ? accurateMatrix : casualMatrix;
    if (config.matrix) {
      matrix = config.matrix;
    }

    /**
     * @access private
     */
    this.values = config.values;
    /**
     * @access private
     */
    this.loc = config.loc || Locale.create();
    /**
     * @access private
     */
    this.conversionAccuracy = accurate ? "longterm" : "casual";
    /**
     * @access private
     */
    this.invalid = config.invalid || null;
    /**
     * @access private
     */
    this.matrix = matrix;
    /**
     * @access private
     */
    this.isLuxonDuration = true;
  }

  /**
   * Create Duration from a number of milliseconds.
   * @param {number} count of milliseconds
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @return {Duration}
   */
  Duration.fromMillis = function fromMillis(count, opts) {
    return Duration.fromObject({
      milliseconds: count
    }, opts);
  }

  /**
   * Create a Duration from a JavaScript object with keys like 'years' and 'hours'.
   * If this object is empty then a zero milliseconds duration is returned.
   * @param {Object} obj - the object to create the DateTime from
   * @param {number} obj.years
   * @param {number} obj.quarters
   * @param {number} obj.months
   * @param {number} obj.weeks
   * @param {number} obj.days
   * @param {number} obj.hours
   * @param {number} obj.minutes
   * @param {number} obj.seconds
   * @param {number} obj.milliseconds
   * @param {Object} [opts=[]] - options for creating this Duration
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
   * @param {string} [opts.matrix=Object] - the custom conversion system to use
   * @return {Duration}
   */;
  Duration.fromObject = function fromObject(obj, opts) {
    if (opts === void 0) {
      opts = {};
    }
    if (obj == null || typeof obj !== "object") {
      throw new InvalidArgumentError("Duration.fromObject: argument expected to be an object, got " + (obj === null ? "null" : typeof obj));
    }
    return new Duration({
      values: normalizeObject(obj, Duration.normalizeUnit),
      loc: Locale.fromObject(opts),
      conversionAccuracy: opts.conversionAccuracy,
      matrix: opts.matrix
    });
  }

  /**
   * Create a Duration from DurationLike.
   *
   * @param {Object | number | Duration} durationLike
   * One of:
   * - object with keys like 'years' and 'hours'.
   * - number representing milliseconds
   * - Duration instance
   * @return {Duration}
   */;
  Duration.fromDurationLike = function fromDurationLike(durationLike) {
    if (isNumber(durationLike)) {
      return Duration.fromMillis(durationLike);
    } else if (Duration.isDuration(durationLike)) {
      return durationLike;
    } else if (typeof durationLike === "object") {
      return Duration.fromObject(durationLike);
    } else {
      throw new InvalidArgumentError("Unknown duration argument " + durationLike + " of type " + typeof durationLike);
    }
  }

  /**
   * Create a Duration from an ISO 8601 duration string.
   * @param {string} text - text to parse
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
   * @param {string} [opts.matrix=Object] - the preset conversion system to use
   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
   * @example Duration.fromISO('P3Y6M1W4DT12H30M5S').toObject() //=> { years: 3, months: 6, weeks: 1, days: 4, hours: 12, minutes: 30, seconds: 5 }
   * @example Duration.fromISO('PT23H').toObject() //=> { hours: 23 }
   * @example Duration.fromISO('P5Y3M').toObject() //=> { years: 5, months: 3 }
   * @return {Duration}
   */;
  Duration.fromISO = function fromISO(text, opts) {
    var _parseISODuration = parseISODuration(text),
      parsed = _parseISODuration[0];
    if (parsed) {
      return Duration.fromObject(parsed, opts);
    } else {
      return Duration.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
    }
  }

  /**
   * Create a Duration from an ISO 8601 time string.
   * @param {string} text - text to parse
   * @param {Object} opts - options for parsing
   * @param {string} [opts.locale='en-US'] - the locale to use
   * @param {string} opts.numberingSystem - the numbering system to use
   * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
   * @param {string} [opts.matrix=Object] - the conversion system to use
   * @see https://en.wikipedia.org/wiki/ISO_8601#Times
   * @example Duration.fromISOTime('11:22:33.444').toObject() //=> { hours: 11, minutes: 22, seconds: 33, milliseconds: 444 }
   * @example Duration.fromISOTime('11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('T11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @example Duration.fromISOTime('T1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
   * @return {Duration}
   */;
  Duration.fromISOTime = function fromISOTime(text, opts) {
    var _parseISOTimeOnly = parseISOTimeOnly(text),
      parsed = _parseISOTimeOnly[0];
    if (parsed) {
      return Duration.fromObject(parsed, opts);
    } else {
      return Duration.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
    }
  }

  /**
   * Create an invalid Duration.
   * @param {string} reason - simple string of why this datetime is invalid. Should not contain parameters or anything else data-dependent
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {Duration}
   */;
  Duration.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }
    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the Duration is invalid");
    }
    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);
    if (Settings.throwOnInvalid) {
      throw new InvalidDurationError(invalid);
    } else {
      return new Duration({
        invalid: invalid
      });
    }
  }

  /**
   * @private
   */;
  Duration.normalizeUnit = function normalizeUnit(unit) {
    var normalized = {
      year: "years",
      years: "years",
      quarter: "quarters",
      quarters: "quarters",
      month: "months",
      months: "months",
      week: "weeks",
      weeks: "weeks",
      day: "days",
      days: "days",
      hour: "hours",
      hours: "hours",
      minute: "minutes",
      minutes: "minutes",
      second: "seconds",
      seconds: "seconds",
      millisecond: "milliseconds",
      milliseconds: "milliseconds"
    }[unit ? unit.toLowerCase() : unit];
    if (!normalized) throw new InvalidUnitError(unit);
    return normalized;
  }

  /**
   * Check if an object is a Duration. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */;
  Duration.isDuration = function isDuration(o) {
    return o && o.isLuxonDuration || false;
  }

  /**
   * Get  the locale of a Duration, such 'en-GB'
   * @type {string}
   */;
  var _proto = Duration.prototype;
  /**
   * Returns a string representation of this Duration formatted according to the specified format string. You may use these tokens:
   * * `S` for milliseconds
   * * `s` for seconds
   * * `m` for minutes
   * * `h` for hours
   * * `d` for days
   * * `w` for weeks
   * * `M` for months
   * * `y` for years
   * Notes:
   * * Add padding by repeating the token, e.g. "yy" pads the years to two digits, "hhhh" pads the hours out to four digits
   * * Tokens can be escaped by wrapping with single quotes.
   * * The duration will be converted to the set of units in the format string using {@link Duration#shiftTo} and the Durations's conversion accuracy setting.
   * @param {string} fmt - the format string
   * @param {Object} opts - options
   * @param {boolean} [opts.floor=true] - floor numerical values
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("y d s") //=> "1 6 2"
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("yy dd sss") //=> "01 06 002"
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("M S") //=> "12 518402000"
   * @return {string}
   */
  _proto.toFormat = function toFormat(fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }
    // reverse-compat since 1.2; we always round down now, never up, and we do it by default
    var fmtOpts = _extends({}, opts, {
      floor: opts.round !== false && opts.floor !== false
    });
    return this.isValid ? Formatter.create(this.loc, fmtOpts).formatDurationFromString(this, fmt) : INVALID$2;
  }

  /**
   * Returns a string representation of a Duration with all units included.
   * To modify its behavior, use `listStyle` and any Intl.NumberFormat option, though `unitDisplay` is especially relevant.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat/NumberFormat#options
   * @param {Object} opts - Formatting options. Accepts the same keys as the options parameter of the native `Intl.NumberFormat` constructor, as well as `listStyle`.
   * @param {string} [opts.listStyle='narrow'] - How to format the merged list. Corresponds to the `style` property of the options parameter of the native `Intl.ListFormat` constructor.
   * @example
   * ```js
   * var dur = Duration.fromObject({ days: 1, hours: 5, minutes: 6 })
   * dur.toHuman() //=> '1 day, 5 hours, 6 minutes'
   * dur.toHuman({ listStyle: "long" }) //=> '1 day, 5 hours, and 6 minutes'
   * dur.toHuman({ unitDisplay: "short" }) //=> '1 day, 5 hr, 6 min'
   * ```
   */;
  _proto.toHuman = function toHuman(opts) {
    var _this = this;
    if (opts === void 0) {
      opts = {};
    }
    if (!this.isValid) return INVALID$2;
    var l = orderedUnits$1.map(function (unit) {
      var val = _this.values[unit];
      if (isUndefined(val)) {
        return null;
      }
      return _this.loc.numberFormatter(_extends({
        style: "unit",
        unitDisplay: "long"
      }, opts, {
        unit: unit.slice(0, -1)
      })).format(val);
    }).filter(function (n) {
      return n;
    });
    return this.loc.listFormatter(_extends({
      type: "conjunction",
      style: opts.listStyle || "narrow"
    }, opts)).format(l);
  }

  /**
   * Returns a JavaScript object with this Duration's values.
   * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toObject() //=> { years: 1, days: 6, seconds: 2 }
   * @return {Object}
   */;
  _proto.toObject = function toObject() {
    if (!this.isValid) return {};
    return _extends({}, this.values);
  }

  /**
   * Returns an ISO 8601-compliant string representation of this Duration.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
   * @example Duration.fromObject({ years: 3, seconds: 45 }).toISO() //=> 'P3YT45S'
   * @example Duration.fromObject({ months: 4, seconds: 45 }).toISO() //=> 'P4MT45S'
   * @example Duration.fromObject({ months: 5 }).toISO() //=> 'P5M'
   * @example Duration.fromObject({ minutes: 5 }).toISO() //=> 'PT5M'
   * @example Duration.fromObject({ milliseconds: 6 }).toISO() //=> 'PT0.006S'
   * @return {string}
   */;
  _proto.toISO = function toISO() {
    // we could use the formatter, but this is an easier way to get the minimum string
    if (!this.isValid) return null;
    var s = "P";
    if (this.years !== 0) s += this.years + "Y";
    if (this.months !== 0 || this.quarters !== 0) s += this.months + this.quarters * 3 + "M";
    if (this.weeks !== 0) s += this.weeks + "W";
    if (this.days !== 0) s += this.days + "D";
    if (this.hours !== 0 || this.minutes !== 0 || this.seconds !== 0 || this.milliseconds !== 0) s += "T";
    if (this.hours !== 0) s += this.hours + "H";
    if (this.minutes !== 0) s += this.minutes + "M";
    if (this.seconds !== 0 || this.milliseconds !== 0)
      // this will handle "floating point madness" by removing extra decimal places
      // https://stackoverflow.com/questions/588004/is-floating-point-math-broken
      s += roundTo(this.seconds + this.milliseconds / 1000, 3) + "S";
    if (s === "P") s += "T0S";
    return s;
  }

  /**
   * Returns an ISO 8601-compliant string representation of this Duration, formatted as a time of day.
   * Note that this will return null if the duration is invalid, negative, or equal to or greater than 24 hours.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Times
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example Duration.fromObject({ hours: 11 }).toISOTime() //=> '11:00:00.000'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressMilliseconds: true }) //=> '11:00:00'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressSeconds: true }) //=> '11:00'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ includePrefix: true }) //=> 'T11:00:00.000'
   * @example Duration.fromObject({ hours: 11 }).toISOTime({ format: 'basic' }) //=> '110000.000'
   * @return {string}
   */;
  _proto.toISOTime = function toISOTime(opts) {
    if (opts === void 0) {
      opts = {};
    }
    if (!this.isValid) return null;
    var millis = this.toMillis();
    if (millis < 0 || millis >= 86400000) return null;
    opts = _extends({
      suppressMilliseconds: false,
      suppressSeconds: false,
      includePrefix: false,
      format: "extended"
    }, opts, {
      includeOffset: false
    });
    var dateTime = DateTime.fromMillis(millis, {
      zone: "UTC"
    });
    return dateTime.toISOTime(opts);
  }

  /**
   * Returns an ISO 8601 representation of this Duration appropriate for use in JSON.
   * @return {string}
   */;
  _proto.toJSON = function toJSON() {
    return this.toISO();
  }

  /**
   * Returns an ISO 8601 representation of this Duration appropriate for use in debugging.
   * @return {string}
   */;
  _proto.toString = function toString() {
    return this.toISO();
  }

  /**
   * Returns a string representation of this Duration appropriate for the REPL.
   * @return {string}
   */;
  _proto[_Symbol$for] = function () {
    if (this.isValid) {
      return "Duration { values: " + JSON.stringify(this.values) + " }";
    } else {
      return "Duration { Invalid, reason: " + this.invalidReason + " }";
    }
  }

  /**
   * Returns an milliseconds value of this Duration.
   * @return {number}
   */;
  _proto.toMillis = function toMillis() {
    if (!this.isValid) return NaN;
    return durationToMillis(this.matrix, this.values);
  }

  /**
   * Returns an milliseconds value of this Duration. Alias of {@link toMillis}
   * @return {number}
   */;
  _proto.valueOf = function valueOf() {
    return this.toMillis();
  }

  /**
   * Make this Duration longer by the specified amount. Return a newly-constructed Duration.
   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @return {Duration}
   */;
  _proto.plus = function plus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration),
      result = {};
    for (var _i2 = 0, _orderedUnits = orderedUnits$1; _i2 < _orderedUnits.length; _i2++) {
      var k = _orderedUnits[_i2];
      if (hasOwnProperty(dur.values, k) || hasOwnProperty(this.values, k)) {
        result[k] = dur.get(k) + this.get(k);
      }
    }
    return clone$1(this, {
      values: result
    }, true);
  }

  /**
   * Make this Duration shorter by the specified amount. Return a newly-constructed Duration.
   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @return {Duration}
   */;
  _proto.minus = function minus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration);
    return this.plus(dur.negate());
  }

  /**
   * Scale this Duration by the specified amount. Return a newly-constructed Duration.
   * @param {function} fn - The function to apply to each unit. Arity is 1 or 2: the value of the unit and, optionally, the unit name. Must return a number.
   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits(x => x * 2) //=> { hours: 2, minutes: 60 }
   * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits((x, u) => u === "hours" ? x * 2 : x) //=> { hours: 2, minutes: 30 }
   * @return {Duration}
   */;
  _proto.mapUnits = function mapUnits(fn) {
    if (!this.isValid) return this;
    var result = {};
    for (var _i3 = 0, _Object$keys = Object.keys(this.values); _i3 < _Object$keys.length; _i3++) {
      var k = _Object$keys[_i3];
      result[k] = asNumber(fn(this.values[k], k));
    }
    return clone$1(this, {
      values: result
    }, true);
  }

  /**
   * Get the value of unit.
   * @param {string} unit - a unit such as 'minute' or 'day'
   * @example Duration.fromObject({years: 2, days: 3}).get('years') //=> 2
   * @example Duration.fromObject({years: 2, days: 3}).get('months') //=> 0
   * @example Duration.fromObject({years: 2, days: 3}).get('days') //=> 3
   * @return {number}
   */;
  _proto.get = function get(unit) {
    return this[Duration.normalizeUnit(unit)];
  }

  /**
   * "Set" the values of specified units. Return a newly-constructed Duration.
   * @param {Object} values - a mapping of units to numbers
   * @example dur.set({ years: 2017 })
   * @example dur.set({ hours: 8, minutes: 30 })
   * @return {Duration}
   */;
  _proto.set = function set(values) {
    if (!this.isValid) return this;
    var mixed = _extends({}, this.values, normalizeObject(values, Duration.normalizeUnit));
    return clone$1(this, {
      values: mixed
    });
  }

  /**
   * "Set" the locale and/or numberingSystem.  Returns a newly-constructed Duration.
   * @example dur.reconfigure({ locale: 'en-GB' })
   * @return {Duration}
   */;
  _proto.reconfigure = function reconfigure(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
      locale = _ref.locale,
      numberingSystem = _ref.numberingSystem,
      conversionAccuracy = _ref.conversionAccuracy,
      matrix = _ref.matrix;
    var loc = this.loc.clone({
      locale: locale,
      numberingSystem: numberingSystem
    });
    var opts = {
      loc: loc,
      matrix: matrix,
      conversionAccuracy: conversionAccuracy
    };
    return clone$1(this, opts);
  }

  /**
   * Return the length of the duration in the specified unit.
   * @param {string} unit - a unit such as 'minutes' or 'days'
   * @example Duration.fromObject({years: 1}).as('days') //=> 365
   * @example Duration.fromObject({years: 1}).as('months') //=> 12
   * @example Duration.fromObject({hours: 60}).as('days') //=> 2.5
   * @return {number}
   */;
  _proto.as = function as(unit) {
    return this.isValid ? this.shiftTo(unit).get(unit) : NaN;
  }

  /**
   * Reduce this Duration to its canonical representation in its current units.
   * Assuming the overall value of the Duration is positive, this means:
   * - excessive values for lower-order units are converted to higher-order units (if possible, see first and second example)
   * - negative lower-order units are converted to higher order units (there must be such a higher order unit, otherwise
   *   the overall value would be negative, see third example)
   * - fractional values for higher-order units are converted to lower-order units (if possible, see fourth example)
   *
   * If the overall value is negative, the result of this method is equivalent to `this.negate().normalize().negate()`.
   * @example Duration.fromObject({ years: 2, days: 5000 }).normalize().toObject() //=> { years: 15, days: 255 }
   * @example Duration.fromObject({ days: 5000 }).normalize().toObject() //=> { days: 5000 }
   * @example Duration.fromObject({ hours: 12, minutes: -45 }).normalize().toObject() //=> { hours: 11, minutes: 15 }
   * @example Duration.fromObject({ years: 2.5, days: 0, hours: 0 }).normalize().toObject() //=> { years: 2, days: 182, hours: 12 }
   * @return {Duration}
   */;
  _proto.normalize = function normalize() {
    if (!this.isValid) return this;
    var vals = this.toObject();
    normalizeValues(this.matrix, vals);
    return clone$1(this, {
      values: vals
    }, true);
  }

  /**
   * Rescale units to its largest representation
   * @example Duration.fromObject({ milliseconds: 90000 }).rescale().toObject() //=> { minutes: 1, seconds: 30 }
   * @return {Duration}
   */;
  _proto.rescale = function rescale() {
    if (!this.isValid) return this;
    var vals = removeZeroes(this.normalize().shiftToAll().toObject());
    return clone$1(this, {
      values: vals
    }, true);
  }

  /**
   * Convert this Duration into its representation in a different set of units.
   * @example Duration.fromObject({ hours: 1, seconds: 30 }).shiftTo('minutes', 'milliseconds').toObject() //=> { minutes: 60, milliseconds: 30000 }
   * @return {Duration}
   */;
  _proto.shiftTo = function shiftTo() {
    for (var _len = arguments.length, units = new Array(_len), _key = 0; _key < _len; _key++) {
      units[_key] = arguments[_key];
    }
    if (!this.isValid) return this;
    if (units.length === 0) {
      return this;
    }
    units = units.map(function (u) {
      return Duration.normalizeUnit(u);
    });
    var built = {},
      accumulated = {},
      vals = this.toObject();
    var lastUnit;
    for (var _i4 = 0, _orderedUnits2 = orderedUnits$1; _i4 < _orderedUnits2.length; _i4++) {
      var k = _orderedUnits2[_i4];
      if (units.indexOf(k) >= 0) {
        lastUnit = k;
        var own = 0;

        // anything we haven't boiled down yet should get boiled to this unit
        for (var ak in accumulated) {
          own += this.matrix[ak][k] * accumulated[ak];
          accumulated[ak] = 0;
        }

        // plus anything that's already in this unit
        if (isNumber(vals[k])) {
          own += vals[k];
        }

        // only keep the integer part for now in the hopes of putting any decimal part
        // into a smaller unit later
        var i = Math.trunc(own);
        built[k] = i;
        accumulated[k] = (own * 1000 - i * 1000) / 1000;

        // otherwise, keep it in the wings to boil it later
      } else if (isNumber(vals[k])) {
        accumulated[k] = vals[k];
      }
    }

    // anything leftover becomes the decimal for the last unit
    // lastUnit must be defined since units is not empty
    for (var key in accumulated) {
      if (accumulated[key] !== 0) {
        built[lastUnit] += key === lastUnit ? accumulated[key] : accumulated[key] / this.matrix[lastUnit][key];
      }
    }
    normalizeValues(this.matrix, built);
    return clone$1(this, {
      values: built
    }, true);
  }

  /**
   * Shift this Duration to all available units.
   * Same as shiftTo("years", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds")
   * @return {Duration}
   */;
  _proto.shiftToAll = function shiftToAll() {
    if (!this.isValid) return this;
    return this.shiftTo("years", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds");
  }

  /**
   * Return the negative of this Duration.
   * @example Duration.fromObject({ hours: 1, seconds: 30 }).negate().toObject() //=> { hours: -1, seconds: -30 }
   * @return {Duration}
   */;
  _proto.negate = function negate() {
    if (!this.isValid) return this;
    var negated = {};
    for (var _i5 = 0, _Object$keys2 = Object.keys(this.values); _i5 < _Object$keys2.length; _i5++) {
      var k = _Object$keys2[_i5];
      negated[k] = this.values[k] === 0 ? 0 : -this.values[k];
    }
    return clone$1(this, {
      values: negated
    }, true);
  }

  /**
   * Get the years.
   * @type {number}
   */;
  /**
   * Equality check
   * Two Durations are equal iff they have the same units and the same values for each unit.
   * @param {Duration} other
   * @return {boolean}
   */
  _proto.equals = function equals(other) {
    if (!this.isValid || !other.isValid) {
      return false;
    }
    if (!this.loc.equals(other.loc)) {
      return false;
    }
    function eq(v1, v2) {
      // Consider 0 and undefined as equal
      if (v1 === undefined || v1 === 0) return v2 === undefined || v2 === 0;
      return v1 === v2;
    }
    for (var _i6 = 0, _orderedUnits3 = orderedUnits$1; _i6 < _orderedUnits3.length; _i6++) {
      var u = _orderedUnits3[_i6];
      if (!eq(this.values[u], other.values[u])) {
        return false;
      }
    }
    return true;
  };
  _createClass(Duration, [{
    key: "locale",
    get: function get() {
      return this.isValid ? this.loc.locale : null;
    }

    /**
     * Get the numbering system of a Duration, such 'beng'. The numbering system is used when formatting the Duration
     *
     * @type {string}
     */
  }, {
    key: "numberingSystem",
    get: function get() {
      return this.isValid ? this.loc.numberingSystem : null;
    }
  }, {
    key: "years",
    get: function get() {
      return this.isValid ? this.values.years || 0 : NaN;
    }

    /**
     * Get the quarters.
     * @type {number}
     */
  }, {
    key: "quarters",
    get: function get() {
      return this.isValid ? this.values.quarters || 0 : NaN;
    }

    /**
     * Get the months.
     * @type {number}
     */
  }, {
    key: "months",
    get: function get() {
      return this.isValid ? this.values.months || 0 : NaN;
    }

    /**
     * Get the weeks
     * @type {number}
     */
  }, {
    key: "weeks",
    get: function get() {
      return this.isValid ? this.values.weeks || 0 : NaN;
    }

    /**
     * Get the days.
     * @type {number}
     */
  }, {
    key: "days",
    get: function get() {
      return this.isValid ? this.values.days || 0 : NaN;
    }

    /**
     * Get the hours.
     * @type {number}
     */
  }, {
    key: "hours",
    get: function get() {
      return this.isValid ? this.values.hours || 0 : NaN;
    }

    /**
     * Get the minutes.
     * @type {number}
     */
  }, {
    key: "minutes",
    get: function get() {
      return this.isValid ? this.values.minutes || 0 : NaN;
    }

    /**
     * Get the seconds.
     * @return {number}
     */
  }, {
    key: "seconds",
    get: function get() {
      return this.isValid ? this.values.seconds || 0 : NaN;
    }

    /**
     * Get the milliseconds.
     * @return {number}
     */
  }, {
    key: "milliseconds",
    get: function get() {
      return this.isValid ? this.values.milliseconds || 0 : NaN;
    }

    /**
     * Returns whether the Duration is invalid. Invalid durations are returned by diff operations
     * on invalid DateTimes or Intervals.
     * @return {boolean}
     */
  }, {
    key: "isValid",
    get: function get() {
      return this.invalid === null;
    }

    /**
     * Returns an error code if this Duration became invalid, or null if the Duration is valid
     * @return {string}
     */
  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this Duration became invalid, or null if the Duration is valid
     * @type {string}
     */
  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }
  }]);
  return Duration;
}(Symbol.for("nodejs.util.inspect.custom"));

var INVALID$1 = "Invalid Interval";

// checks if the start is equal to or before the end
function validateStartEnd(start, end) {
  if (!start || !start.isValid) {
    return Interval.invalid("missing or invalid start");
  } else if (!end || !end.isValid) {
    return Interval.invalid("missing or invalid end");
  } else if (end < start) {
    return Interval.invalid("end before start", "The end of an interval must be after its start, but you had start=" + start.toISO() + " and end=" + end.toISO());
  } else {
    return null;
  }
}

/**
 * An Interval object represents a half-open interval of time, where each endpoint is a {@link DateTime}. Conceptually, it's a container for those two endpoints, accompanied by methods for creating, parsing, interrogating, comparing, transforming, and formatting them.
 *
 * Here is a brief overview of the most commonly used methods and getters in Interval:
 *
 * * **Creation** To create an Interval, use {@link Interval.fromDateTimes}, {@link Interval.after}, {@link Interval.before}, or {@link Interval.fromISO}.
 * * **Accessors** Use {@link Interval#start} and {@link Interval#end} to get the start and end.
 * * **Interrogation** To analyze the Interval, use {@link Interval#count}, {@link Interval#length}, {@link Interval#hasSame}, {@link Interval#contains}, {@link Interval#isAfter}, or {@link Interval#isBefore}.
 * * **Transformation** To create other Intervals out of this one, use {@link Interval#set}, {@link Interval#splitAt}, {@link Interval#splitBy}, {@link Interval#divideEqually}, {@link Interval.merge}, {@link Interval.xor}, {@link Interval#union}, {@link Interval#intersection}, or {@link Interval#difference}.
 * * **Comparison** To compare this Interval to another one, use {@link Interval#equals}, {@link Interval#overlaps}, {@link Interval#abutsStart}, {@link Interval#abutsEnd}, {@link Interval#engulfs}
 * * **Output** To convert the Interval into other representations, see {@link Interval#toString}, {@link Interval#toLocaleString}, {@link Interval#toISO}, {@link Interval#toISODate}, {@link Interval#toISOTime}, {@link Interval#toFormat}, and {@link Interval#toDuration}.
 */
var Interval = /*#__PURE__*/function (_Symbol$for) {
  /**
   * @private
   */
  function Interval(config) {
    /**
     * @access private
     */
    this.s = config.start;
    /**
     * @access private
     */
    this.e = config.end;
    /**
     * @access private
     */
    this.invalid = config.invalid || null;
    /**
     * @access private
     */
    this.isLuxonInterval = true;
  }

  /**
   * Create an invalid Interval.
   * @param {string} reason - simple string of why this Interval is invalid. Should not contain parameters or anything else data-dependent
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {Interval}
   */
  Interval.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }
    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the Interval is invalid");
    }
    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);
    if (Settings.throwOnInvalid) {
      throw new InvalidIntervalError(invalid);
    } else {
      return new Interval({
        invalid: invalid
      });
    }
  }

  /**
   * Create an Interval from a start DateTime and an end DateTime. Inclusive of the start but not the end.
   * @param {DateTime|Date|Object} start
   * @param {DateTime|Date|Object} end
   * @return {Interval}
   */;
  Interval.fromDateTimes = function fromDateTimes(start, end) {
    var builtStart = friendlyDateTime(start),
      builtEnd = friendlyDateTime(end);
    var validateError = validateStartEnd(builtStart, builtEnd);
    if (validateError == null) {
      return new Interval({
        start: builtStart,
        end: builtEnd
      });
    } else {
      return validateError;
    }
  }

  /**
   * Create an Interval from a start DateTime and a Duration to extend to.
   * @param {DateTime|Date|Object} start
   * @param {Duration|Object|number} duration - the length of the Interval.
   * @return {Interval}
   */;
  Interval.after = function after(start, duration) {
    var dur = Duration.fromDurationLike(duration),
      dt = friendlyDateTime(start);
    return Interval.fromDateTimes(dt, dt.plus(dur));
  }

  /**
   * Create an Interval from an end DateTime and a Duration to extend backwards to.
   * @param {DateTime|Date|Object} end
   * @param {Duration|Object|number} duration - the length of the Interval.
   * @return {Interval}
   */;
  Interval.before = function before(end, duration) {
    var dur = Duration.fromDurationLike(duration),
      dt = friendlyDateTime(end);
    return Interval.fromDateTimes(dt.minus(dur), dt);
  }

  /**
   * Create an Interval from an ISO 8601 string.
   * Accepts `<start>/<end>`, `<start>/<duration>`, and `<duration>/<end>` formats.
   * @param {string} text - the ISO string to parse
   * @param {Object} [opts] - options to pass {@link DateTime#fromISO} and optionally {@link Duration#fromISO}
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @return {Interval}
   */;
  Interval.fromISO = function fromISO(text, opts) {
    var _split = (text || "").split("/", 2),
      s = _split[0],
      e = _split[1];
    if (s && e) {
      var start, startIsValid;
      try {
        start = DateTime.fromISO(s, opts);
        startIsValid = start.isValid;
      } catch (e) {
        startIsValid = false;
      }
      var end, endIsValid;
      try {
        end = DateTime.fromISO(e, opts);
        endIsValid = end.isValid;
      } catch (e) {
        endIsValid = false;
      }
      if (startIsValid && endIsValid) {
        return Interval.fromDateTimes(start, end);
      }
      if (startIsValid) {
        var dur = Duration.fromISO(e, opts);
        if (dur.isValid) {
          return Interval.after(start, dur);
        }
      } else if (endIsValid) {
        var _dur = Duration.fromISO(s, opts);
        if (_dur.isValid) {
          return Interval.before(end, _dur);
        }
      }
    }
    return Interval.invalid("unparsable", "the input \"" + text + "\" can't be parsed as ISO 8601");
  }

  /**
   * Check if an object is an Interval. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */;
  Interval.isInterval = function isInterval(o) {
    return o && o.isLuxonInterval || false;
  }

  /**
   * Returns the start of the Interval
   * @type {DateTime}
   */;
  var _proto = Interval.prototype;
  /**
   * Returns the length of the Interval in the specified unit.
   * @param {string} unit - the unit (such as 'hours' or 'days') to return the length in.
   * @return {number}
   */
  _proto.length = function length(unit) {
    if (unit === void 0) {
      unit = "milliseconds";
    }
    return this.isValid ? this.toDuration.apply(this, [unit]).get(unit) : NaN;
  }

  /**
   * Returns the count of minutes, hours, days, months, or years included in the Interval, even in part.
   * Unlike {@link Interval#length} this counts sections of the calendar, not periods of time, e.g. specifying 'day'
   * asks 'what dates are included in this interval?', not 'how many days long is this interval?'
   * @param {string} [unit='milliseconds'] - the unit of time to count.
   * @param {Object} opts - options
   * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week; this operation will always use the locale of the start DateTime
   * @return {number}
   */;
  _proto.count = function count(unit, opts) {
    if (unit === void 0) {
      unit = "milliseconds";
    }
    if (!this.isValid) return NaN;
    var start = this.start.startOf(unit, opts);
    var end;
    if (opts != null && opts.useLocaleWeeks) {
      end = this.end.reconfigure({
        locale: start.locale
      });
    } else {
      end = this.end;
    }
    end = end.startOf(unit, opts);
    return Math.floor(end.diff(start, unit).get(unit)) + (end.valueOf() !== this.end.valueOf());
  }

  /**
   * Returns whether this Interval's start and end are both in the same unit of time
   * @param {string} unit - the unit of time to check sameness on
   * @return {boolean}
   */;
  _proto.hasSame = function hasSame(unit) {
    return this.isValid ? this.isEmpty() || this.e.minus(1).hasSame(this.s, unit) : false;
  }

  /**
   * Return whether this Interval has the same start and end DateTimes.
   * @return {boolean}
   */;
  _proto.isEmpty = function isEmpty() {
    return this.s.valueOf() === this.e.valueOf();
  }

  /**
   * Return whether this Interval's start is after the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */;
  _proto.isAfter = function isAfter(dateTime) {
    if (!this.isValid) return false;
    return this.s > dateTime;
  }

  /**
   * Return whether this Interval's end is before the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */;
  _proto.isBefore = function isBefore(dateTime) {
    if (!this.isValid) return false;
    return this.e <= dateTime;
  }

  /**
   * Return whether this Interval contains the specified DateTime.
   * @param {DateTime} dateTime
   * @return {boolean}
   */;
  _proto.contains = function contains(dateTime) {
    if (!this.isValid) return false;
    return this.s <= dateTime && this.e > dateTime;
  }

  /**
   * "Sets" the start and/or end dates. Returns a newly-constructed Interval.
   * @param {Object} values - the values to set
   * @param {DateTime} values.start - the starting DateTime
   * @param {DateTime} values.end - the ending DateTime
   * @return {Interval}
   */;
  _proto.set = function set(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
      start = _ref.start,
      end = _ref.end;
    if (!this.isValid) return this;
    return Interval.fromDateTimes(start || this.s, end || this.e);
  }

  /**
   * Split this Interval at each of the specified DateTimes
   * @param {...DateTime} dateTimes - the unit of time to count.
   * @return {Array}
   */;
  _proto.splitAt = function splitAt() {
    var _this = this;
    if (!this.isValid) return [];
    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {
      dateTimes[_key] = arguments[_key];
    }
    var sorted = dateTimes.map(friendlyDateTime).filter(function (d) {
        return _this.contains(d);
      }).sort(function (a, b) {
        return a.toMillis() - b.toMillis();
      }),
      results = [];
    var s = this.s,
      i = 0;
    while (s < this.e) {
      var added = sorted[i] || this.e,
        next = +added > +this.e ? this.e : added;
      results.push(Interval.fromDateTimes(s, next));
      s = next;
      i += 1;
    }
    return results;
  }

  /**
   * Split this Interval into smaller Intervals, each of the specified length.
   * Left over time is grouped into a smaller interval
   * @param {Duration|Object|number} duration - The length of each resulting interval.
   * @return {Array}
   */;
  _proto.splitBy = function splitBy(duration) {
    var dur = Duration.fromDurationLike(duration);
    if (!this.isValid || !dur.isValid || dur.as("milliseconds") === 0) {
      return [];
    }
    var s = this.s,
      idx = 1,
      next;
    var results = [];
    while (s < this.e) {
      var added = this.start.plus(dur.mapUnits(function (x) {
        return x * idx;
      }));
      next = +added > +this.e ? this.e : added;
      results.push(Interval.fromDateTimes(s, next));
      s = next;
      idx += 1;
    }
    return results;
  }

  /**
   * Split this Interval into the specified number of smaller intervals.
   * @param {number} numberOfParts - The number of Intervals to divide the Interval into.
   * @return {Array}
   */;
  _proto.divideEqually = function divideEqually(numberOfParts) {
    if (!this.isValid) return [];
    return this.splitBy(this.length() / numberOfParts).slice(0, numberOfParts);
  }

  /**
   * Return whether this Interval overlaps with the specified Interval
   * @param {Interval} other
   * @return {boolean}
   */;
  _proto.overlaps = function overlaps(other) {
    return this.e > other.s && this.s < other.e;
  }

  /**
   * Return whether this Interval's end is adjacent to the specified Interval's start.
   * @param {Interval} other
   * @return {boolean}
   */;
  _proto.abutsStart = function abutsStart(other) {
    if (!this.isValid) return false;
    return +this.e === +other.s;
  }

  /**
   * Return whether this Interval's start is adjacent to the specified Interval's end.
   * @param {Interval} other
   * @return {boolean}
   */;
  _proto.abutsEnd = function abutsEnd(other) {
    if (!this.isValid) return false;
    return +other.e === +this.s;
  }

  /**
   * Return whether this Interval engulfs the start and end of the specified Interval.
   * @param {Interval} other
   * @return {boolean}
   */;
  _proto.engulfs = function engulfs(other) {
    if (!this.isValid) return false;
    return this.s <= other.s && this.e >= other.e;
  }

  /**
   * Return whether this Interval has the same start and end as the specified Interval.
   * @param {Interval} other
   * @return {boolean}
   */;
  _proto.equals = function equals(other) {
    if (!this.isValid || !other.isValid) {
      return false;
    }
    return this.s.equals(other.s) && this.e.equals(other.e);
  }

  /**
   * Return an Interval representing the intersection of this Interval and the specified Interval.
   * Specifically, the resulting Interval has the maximum start time and the minimum end time of the two Intervals.
   * Returns null if the intersection is empty, meaning, the intervals don't intersect.
   * @param {Interval} other
   * @return {Interval}
   */;
  _proto.intersection = function intersection(other) {
    if (!this.isValid) return this;
    var s = this.s > other.s ? this.s : other.s,
      e = this.e < other.e ? this.e : other.e;
    if (s >= e) {
      return null;
    } else {
      return Interval.fromDateTimes(s, e);
    }
  }

  /**
   * Return an Interval representing the union of this Interval and the specified Interval.
   * Specifically, the resulting Interval has the minimum start time and the maximum end time of the two Intervals.
   * @param {Interval} other
   * @return {Interval}
   */;
  _proto.union = function union(other) {
    if (!this.isValid) return this;
    var s = this.s < other.s ? this.s : other.s,
      e = this.e > other.e ? this.e : other.e;
    return Interval.fromDateTimes(s, e);
  }

  /**
   * Merge an array of Intervals into a equivalent minimal set of Intervals.
   * Combines overlapping and adjacent Intervals.
   * @param {Array} intervals
   * @return {Array}
   */;
  Interval.merge = function merge(intervals) {
    var _intervals$sort$reduc = intervals.sort(function (a, b) {
        return a.s - b.s;
      }).reduce(function (_ref2, item) {
        var sofar = _ref2[0],
          current = _ref2[1];
        if (!current) {
          return [sofar, item];
        } else if (current.overlaps(item) || current.abutsStart(item)) {
          return [sofar, current.union(item)];
        } else {
          return [sofar.concat([current]), item];
        }
      }, [[], null]),
      found = _intervals$sort$reduc[0],
      final = _intervals$sort$reduc[1];
    if (final) {
      found.push(final);
    }
    return found;
  }

  /**
   * Return an array of Intervals representing the spans of time that only appear in one of the specified Intervals.
   * @param {Array} intervals
   * @return {Array}
   */;
  Interval.xor = function xor(intervals) {
    var _Array$prototype;
    var start = null,
      currentCount = 0;
    var results = [],
      ends = intervals.map(function (i) {
        return [{
          time: i.s,
          type: "s"
        }, {
          time: i.e,
          type: "e"
        }];
      }),
      flattened = (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, ends),
      arr = flattened.sort(function (a, b) {
        return a.time - b.time;
      });
    for (var _iterator = _createForOfIteratorHelperLoose(arr), _step; !(_step = _iterator()).done;) {
      var i = _step.value;
      currentCount += i.type === "s" ? 1 : -1;
      if (currentCount === 1) {
        start = i.time;
      } else {
        if (start && +start !== +i.time) {
          results.push(Interval.fromDateTimes(start, i.time));
        }
        start = null;
      }
    }
    return Interval.merge(results);
  }

  /**
   * Return an Interval representing the span of time in this Interval that doesn't overlap with any of the specified Intervals.
   * @param {...Interval} intervals
   * @return {Array}
   */;
  _proto.difference = function difference() {
    var _this2 = this;
    for (var _len2 = arguments.length, intervals = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      intervals[_key2] = arguments[_key2];
    }
    return Interval.xor([this].concat(intervals)).map(function (i) {
      return _this2.intersection(i);
    }).filter(function (i) {
      return i && !i.isEmpty();
    });
  }

  /**
   * Returns a string representation of this Interval appropriate for debugging.
   * @return {string}
   */;
  _proto.toString = function toString() {
    if (!this.isValid) return INVALID$1;
    return "[" + this.s.toISO() + " \u2013 " + this.e.toISO() + ")";
  }

  /**
   * Returns a string representation of this Interval appropriate for the REPL.
   * @return {string}
   */;
  _proto[_Symbol$for] = function () {
    if (this.isValid) {
      return "Interval { start: " + this.s.toISO() + ", end: " + this.e.toISO() + " }";
    } else {
      return "Interval { Invalid, reason: " + this.invalidReason + " }";
    }
  }

  /**
   * Returns a localized string representing this Interval. Accepts the same options as the
   * Intl.DateTimeFormat constructor and any presets defined by Luxon, such as
   * {@link DateTime.DATE_FULL} or {@link DateTime.TIME_SIMPLE}. The exact behavior of this method
   * is browser-specific, but in general it will return an appropriate representation of the
   * Interval in the assigned locale. Defaults to the system's locale if no locale has been
   * specified.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param {Object} [formatOpts=DateTime.DATE_SHORT] - Either a DateTime preset or
   * Intl.DateTimeFormat constructor options.
   * @param {Object} opts - Options to override the configuration of the start DateTime.
   * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(); //=> 11/7/2022 – 11/8/2022
   * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(DateTime.DATE_FULL); //=> November 7 – 8, 2022
   * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(DateTime.DATE_FULL, { locale: 'fr-FR' }); //=> 7–8 novembre 2022
   * @example Interval.fromISO('2022-11-07T17:00Z/2022-11-07T19:00Z').toLocaleString(DateTime.TIME_SIMPLE); //=> 6:00 – 8:00 PM
   * @example Interval.fromISO('2022-11-07T17:00Z/2022-11-07T19:00Z').toLocaleString({ weekday: 'short', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' }); //=> Mon, Nov 07, 6:00 – 8:00 p
   * @return {string}
   */;
  _proto.toLocaleString = function toLocaleString(formatOpts, opts) {
    if (formatOpts === void 0) {
      formatOpts = DATE_SHORT;
    }
    if (opts === void 0) {
      opts = {};
    }
    return this.isValid ? Formatter.create(this.s.loc.clone(opts), formatOpts).formatInterval(this) : INVALID$1;
  }

  /**
   * Returns an ISO 8601-compliant string representation of this Interval.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @param {Object} opts - The same options as {@link DateTime#toISO}
   * @return {string}
   */;
  _proto.toISO = function toISO(opts) {
    if (!this.isValid) return INVALID$1;
    return this.s.toISO(opts) + "/" + this.e.toISO(opts);
  }

  /**
   * Returns an ISO 8601-compliant string representation of date of this Interval.
   * The time components are ignored.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @return {string}
   */;
  _proto.toISODate = function toISODate() {
    if (!this.isValid) return INVALID$1;
    return this.s.toISODate() + "/" + this.e.toISODate();
  }

  /**
   * Returns an ISO 8601-compliant string representation of time of this Interval.
   * The date components are ignored.
   * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
   * @param {Object} opts - The same options as {@link DateTime#toISO}
   * @return {string}
   */;
  _proto.toISOTime = function toISOTime(opts) {
    if (!this.isValid) return INVALID$1;
    return this.s.toISOTime(opts) + "/" + this.e.toISOTime(opts);
  }

  /**
   * Returns a string representation of this Interval formatted according to the specified format
   * string. **You may not want this.** See {@link Interval#toLocaleString} for a more flexible
   * formatting tool.
   * @param {string} dateFormat - The format string. This string formats the start and end time.
   * See {@link DateTime#toFormat} for details.
   * @param {Object} opts - Options.
   * @param {string} [opts.separator =  ' – '] - A separator to place between the start and end
   * representations.
   * @return {string}
   */;
  _proto.toFormat = function toFormat(dateFormat, _temp2) {
    var _ref3 = _temp2 === void 0 ? {} : _temp2,
      _ref3$separator = _ref3.separator,
      separator = _ref3$separator === void 0 ? " – " : _ref3$separator;
    if (!this.isValid) return INVALID$1;
    return "" + this.s.toFormat(dateFormat) + separator + this.e.toFormat(dateFormat);
  }

  /**
   * Return a Duration representing the time spanned by this interval.
   * @param {string|string[]} [unit=['milliseconds']] - the unit or units (such as 'hours' or 'days') to include in the duration.
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @example Interval.fromDateTimes(dt1, dt2).toDuration().toObject() //=> { milliseconds: 88489257 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration('days').toObject() //=> { days: 1.0241812152777778 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes']).toObject() //=> { hours: 24, minutes: 34.82095 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes', 'seconds']).toObject() //=> { hours: 24, minutes: 34, seconds: 49.257 }
   * @example Interval.fromDateTimes(dt1, dt2).toDuration('seconds').toObject() //=> { seconds: 88489.257 }
   * @return {Duration}
   */;
  _proto.toDuration = function toDuration(unit, opts) {
    if (!this.isValid) {
      return Duration.invalid(this.invalidReason);
    }
    return this.e.diff(this.s, unit, opts);
  }

  /**
   * Run mapFn on the interval start and end, returning a new Interval from the resulting DateTimes
   * @param {function} mapFn
   * @return {Interval}
   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.toUTC())
   * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.plus({ hours: 2 }))
   */;
  _proto.mapEndpoints = function mapEndpoints(mapFn) {
    return Interval.fromDateTimes(mapFn(this.s), mapFn(this.e));
  };
  _createClass(Interval, [{
    key: "start",
    get: function get() {
      return this.isValid ? this.s : null;
    }

    /**
     * Returns the end of the Interval
     * @type {DateTime}
     */
  }, {
    key: "end",
    get: function get() {
      return this.isValid ? this.e : null;
    }

    /**
     * Returns whether this Interval's end is at least its start, meaning that the Interval isn't 'backwards'.
     * @type {boolean}
     */
  }, {
    key: "isValid",
    get: function get() {
      return this.invalidReason === null;
    }

    /**
     * Returns an error code if this Interval is invalid, or null if the Interval is valid
     * @type {string}
     */
  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this Interval became invalid, or null if the Interval is valid
     * @type {string}
     */
  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }
  }]);
  return Interval;
}(Symbol.for("nodejs.util.inspect.custom"));

/**
 * The Info class contains static methods for retrieving general time and date related data. For example, it has methods for finding out if a time zone has a DST, for listing the months in any supported locale, and for discovering which of Luxon features are available in the current environment.
 */
var Info = /*#__PURE__*/function () {
  function Info() {}
  /**
   * Return whether the specified zone contains a DST.
   * @param {string|Zone} [zone='local'] - Zone to check. Defaults to the environment's local zone.
   * @return {boolean}
   */
  Info.hasDST = function hasDST(zone) {
    if (zone === void 0) {
      zone = Settings.defaultZone;
    }
    var proto = DateTime.now().setZone(zone).set({
      month: 12
    });
    return !zone.isUniversal && proto.offset !== proto.set({
      month: 6
    }).offset;
  }

  /**
   * Return whether the specified zone is a valid IANA specifier.
   * @param {string} zone - Zone to check
   * @return {boolean}
   */;
  Info.isValidIANAZone = function isValidIANAZone(zone) {
    return IANAZone.isValidZone(zone);
  }

  /**
   * Converts the input into a {@link Zone} instance.
   *
   * * If `input` is already a Zone instance, it is returned unchanged.
   * * If `input` is a string containing a valid time zone name, a Zone instance
   *   with that name is returned.
   * * If `input` is a string that doesn't refer to a known time zone, a Zone
   *   instance with {@link Zone#isValid} == false is returned.
   * * If `input is a number, a Zone instance with the specified fixed offset
   *   in minutes is returned.
   * * If `input` is `null` or `undefined`, the default zone is returned.
   * @param {string|Zone|number} [input] - the value to be converted
   * @return {Zone}
   */;
  Info.normalizeZone = function normalizeZone$1(input) {
    return normalizeZone(input, Settings.defaultZone);
  }

  /**
   * Get the weekday on which the week starts according to the given locale.
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @returns {number} the start of the week, 1 for Monday through 7 for Sunday
   */;
  Info.getStartOfWeek = function getStartOfWeek(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
      _ref$locale = _ref.locale,
      locale = _ref$locale === void 0 ? null : _ref$locale,
      _ref$locObj = _ref.locObj,
      locObj = _ref$locObj === void 0 ? null : _ref$locObj;
    return (locObj || Locale.create(locale)).getStartOfWeek();
  }

  /**
   * Get the minimum number of days necessary in a week before it is considered part of the next year according
   * to the given locale.
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @returns {number}
   */;
  Info.getMinimumDaysInFirstWeek = function getMinimumDaysInFirstWeek(_temp2) {
    var _ref2 = _temp2 === void 0 ? {} : _temp2,
      _ref2$locale = _ref2.locale,
      locale = _ref2$locale === void 0 ? null : _ref2$locale,
      _ref2$locObj = _ref2.locObj,
      locObj = _ref2$locObj === void 0 ? null : _ref2$locObj;
    return (locObj || Locale.create(locale)).getMinDaysInFirstWeek();
  }

  /**
   * Get the weekdays, which are considered the weekend according to the given locale
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @returns {number[]} an array of weekdays, 1 for Monday through 7 for Sunday
   */;
  Info.getWeekendWeekdays = function getWeekendWeekdays(_temp3) {
    var _ref3 = _temp3 === void 0 ? {} : _temp3,
      _ref3$locale = _ref3.locale,
      locale = _ref3$locale === void 0 ? null : _ref3$locale,
      _ref3$locObj = _ref3.locObj,
      locObj = _ref3$locObj === void 0 ? null : _ref3$locObj;
    // copy the array, because we cache it internally
    return (locObj || Locale.create(locale)).getWeekendDays().slice();
  }

  /**
   * Return an array of standalone month names.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @param {string} [opts.outputCalendar='gregory'] - the calendar
   * @example Info.months()[0] //=> 'January'
   * @example Info.months('short')[0] //=> 'Jan'
   * @example Info.months('numeric')[0] //=> '1'
   * @example Info.months('short', { locale: 'fr-CA' } )[0] //=> 'janv.'
   * @example Info.months('numeric', { locale: 'ar' })[0] //=> '١'
   * @example Info.months('long', { outputCalendar: 'islamic' })[0] //=> 'Rabiʻ I'
   * @return {Array}
   */;
  Info.months = function months(length, _temp4) {
    if (length === void 0) {
      length = "long";
    }
    var _ref4 = _temp4 === void 0 ? {} : _temp4,
      _ref4$locale = _ref4.locale,
      locale = _ref4$locale === void 0 ? null : _ref4$locale,
      _ref4$numberingSystem = _ref4.numberingSystem,
      numberingSystem = _ref4$numberingSystem === void 0 ? null : _ref4$numberingSystem,
      _ref4$locObj = _ref4.locObj,
      locObj = _ref4$locObj === void 0 ? null : _ref4$locObj,
      _ref4$outputCalendar = _ref4.outputCalendar,
      outputCalendar = _ref4$outputCalendar === void 0 ? "gregory" : _ref4$outputCalendar;
    return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length);
  }

  /**
   * Return an array of format month names.
   * Format months differ from standalone months in that they're meant to appear next to the day of the month. In some languages, that
   * changes the string.
   * See {@link Info#months}
   * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @param {string} [opts.outputCalendar='gregory'] - the calendar
   * @return {Array}
   */;
  Info.monthsFormat = function monthsFormat(length, _temp5) {
    if (length === void 0) {
      length = "long";
    }
    var _ref5 = _temp5 === void 0 ? {} : _temp5,
      _ref5$locale = _ref5.locale,
      locale = _ref5$locale === void 0 ? null : _ref5$locale,
      _ref5$numberingSystem = _ref5.numberingSystem,
      numberingSystem = _ref5$numberingSystem === void 0 ? null : _ref5$numberingSystem,
      _ref5$locObj = _ref5.locObj,
      locObj = _ref5$locObj === void 0 ? null : _ref5$locObj,
      _ref5$outputCalendar = _ref5.outputCalendar,
      outputCalendar = _ref5$outputCalendar === void 0 ? "gregory" : _ref5$outputCalendar;
    return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length, true);
  }

  /**
   * Return an array of standalone week names.
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param {string} [length='long'] - the length of the weekday representation, such as "narrow", "short", "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @example Info.weekdays()[0] //=> 'Monday'
   * @example Info.weekdays('short')[0] //=> 'Mon'
   * @example Info.weekdays('short', { locale: 'fr-CA' })[0] //=> 'lun.'
   * @example Info.weekdays('short', { locale: 'ar' })[0] //=> 'الاثنين'
   * @return {Array}
   */;
  Info.weekdays = function weekdays(length, _temp6) {
    if (length === void 0) {
      length = "long";
    }
    var _ref6 = _temp6 === void 0 ? {} : _temp6,
      _ref6$locale = _ref6.locale,
      locale = _ref6$locale === void 0 ? null : _ref6$locale,
      _ref6$numberingSystem = _ref6.numberingSystem,
      numberingSystem = _ref6$numberingSystem === void 0 ? null : _ref6$numberingSystem,
      _ref6$locObj = _ref6.locObj,
      locObj = _ref6$locObj === void 0 ? null : _ref6$locObj;
    return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length);
  }

  /**
   * Return an array of format week names.
   * Format weekdays differ from standalone weekdays in that they're meant to appear next to more date information. In some languages, that
   * changes the string.
   * See {@link Info#weekdays}
   * @param {string} [length='long'] - the length of the month representation, such as "narrow", "short", "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale=null] - the locale code
   * @param {string} [opts.numberingSystem=null] - the numbering system
   * @param {string} [opts.locObj=null] - an existing locale object to use
   * @return {Array}
   */;
  Info.weekdaysFormat = function weekdaysFormat(length, _temp7) {
    if (length === void 0) {
      length = "long";
    }
    var _ref7 = _temp7 === void 0 ? {} : _temp7,
      _ref7$locale = _ref7.locale,
      locale = _ref7$locale === void 0 ? null : _ref7$locale,
      _ref7$numberingSystem = _ref7.numberingSystem,
      numberingSystem = _ref7$numberingSystem === void 0 ? null : _ref7$numberingSystem,
      _ref7$locObj = _ref7.locObj,
      locObj = _ref7$locObj === void 0 ? null : _ref7$locObj;
    return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length, true);
  }

  /**
   * Return an array of meridiems.
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @example Info.meridiems() //=> [ 'AM', 'PM' ]
   * @example Info.meridiems({ locale: 'my' }) //=> [ 'နံနက်', 'ညနေ' ]
   * @return {Array}
   */;
  Info.meridiems = function meridiems(_temp8) {
    var _ref8 = _temp8 === void 0 ? {} : _temp8,
      _ref8$locale = _ref8.locale,
      locale = _ref8$locale === void 0 ? null : _ref8$locale;
    return Locale.create(locale).meridiems();
  }

  /**
   * Return an array of eras, such as ['BC', 'AD']. The locale can be specified, but the calendar system is always Gregorian.
   * @param {string} [length='short'] - the length of the era representation, such as "short" or "long".
   * @param {Object} opts - options
   * @param {string} [opts.locale] - the locale code
   * @example Info.eras() //=> [ 'BC', 'AD' ]
   * @example Info.eras('long') //=> [ 'Before Christ', 'Anno Domini' ]
   * @example Info.eras('long', { locale: 'fr' }) //=> [ 'avant Jésus-Christ', 'après Jésus-Christ' ]
   * @return {Array}
   */;
  Info.eras = function eras(length, _temp9) {
    if (length === void 0) {
      length = "short";
    }
    var _ref9 = _temp9 === void 0 ? {} : _temp9,
      _ref9$locale = _ref9.locale,
      locale = _ref9$locale === void 0 ? null : _ref9$locale;
    return Locale.create(locale, null, "gregory").eras(length);
  }

  /**
   * Return the set of available features in this environment.
   * Some features of Luxon are not available in all environments. For example, on older browsers, relative time formatting support is not available. Use this function to figure out if that's the case.
   * Keys:
   * * `relative`: whether this environment supports relative time formatting
   * * `localeWeek`: whether this environment supports different weekdays for the start of the week based on the locale
   * @example Info.features() //=> { relative: false, localeWeek: true }
   * @return {Object}
   */;
  Info.features = function features() {
    return {
      relative: hasRelative(),
      localeWeek: hasLocaleWeekInfo()
    };
  };
  return Info;
}();

function dayDiff(earlier, later) {
  var utcDayStart = function utcDayStart(dt) {
      return dt.toUTC(0, {
        keepLocalTime: true
      }).startOf("day").valueOf();
    },
    ms = utcDayStart(later) - utcDayStart(earlier);
  return Math.floor(Duration.fromMillis(ms).as("days"));
}
function highOrderDiffs(cursor, later, units) {
  var differs = [["years", function (a, b) {
    return b.year - a.year;
  }], ["quarters", function (a, b) {
    return b.quarter - a.quarter + (b.year - a.year) * 4;
  }], ["months", function (a, b) {
    return b.month - a.month + (b.year - a.year) * 12;
  }], ["weeks", function (a, b) {
    var days = dayDiff(a, b);
    return (days - days % 7) / 7;
  }], ["days", dayDiff]];
  var results = {};
  var earlier = cursor;
  var lowestOrder, highWater;

  /* This loop tries to diff using larger units first.
     If we overshoot, we backtrack and try the next smaller unit.
     "cursor" starts out at the earlier timestamp and moves closer and closer to "later"
     as we use smaller and smaller units.
     highWater keeps track of where we would be if we added one more of the smallest unit,
     this is used later to potentially convert any difference smaller than the smallest higher order unit
     into a fraction of that smallest higher order unit
  */
  for (var _i = 0, _differs = differs; _i < _differs.length; _i++) {
    var _differs$_i = _differs[_i],
      unit = _differs$_i[0],
      differ = _differs$_i[1];
    if (units.indexOf(unit) >= 0) {
      lowestOrder = unit;
      results[unit] = differ(cursor, later);
      highWater = earlier.plus(results);
      if (highWater > later) {
        // we overshot the end point, backtrack cursor by 1
        results[unit]--;
        cursor = earlier.plus(results);

        // if we are still overshooting now, we need to backtrack again
        // this happens in certain situations when diffing times in different zones,
        // because this calculation ignores time zones
        if (cursor > later) {
          // keep the "overshot by 1" around as highWater
          highWater = cursor;
          // backtrack cursor by 1
          results[unit]--;
          cursor = earlier.plus(results);
        }
      } else {
        cursor = highWater;
      }
    }
  }
  return [cursor, results, highWater, lowestOrder];
}
function _diff (earlier, later, units, opts) {
  var _highOrderDiffs = highOrderDiffs(earlier, later, units),
    cursor = _highOrderDiffs[0],
    results = _highOrderDiffs[1],
    highWater = _highOrderDiffs[2],
    lowestOrder = _highOrderDiffs[3];
  var remainingMillis = later - cursor;
  var lowerOrderUnits = units.filter(function (u) {
    return ["hours", "minutes", "seconds", "milliseconds"].indexOf(u) >= 0;
  });
  if (lowerOrderUnits.length === 0) {
    if (highWater < later) {
      var _cursor$plus;
      highWater = cursor.plus((_cursor$plus = {}, _cursor$plus[lowestOrder] = 1, _cursor$plus));
    }
    if (highWater !== cursor) {
      results[lowestOrder] = (results[lowestOrder] || 0) + remainingMillis / (highWater - cursor);
    }
  }
  var duration = Duration.fromObject(results, opts);
  if (lowerOrderUnits.length > 0) {
    var _Duration$fromMillis;
    return (_Duration$fromMillis = Duration.fromMillis(remainingMillis, opts)).shiftTo.apply(_Duration$fromMillis, lowerOrderUnits).plus(duration);
  } else {
    return duration;
  }
}

var numberingSystems = {
  arab: "[\u0660-\u0669]",
  arabext: "[\u06F0-\u06F9]",
  bali: "[\u1B50-\u1B59]",
  beng: "[\u09E6-\u09EF]",
  deva: "[\u0966-\u096F]",
  fullwide: "[\uFF10-\uFF19]",
  gujr: "[\u0AE6-\u0AEF]",
  hanidec: "[〇|一|二|三|四|五|六|七|八|九]",
  khmr: "[\u17E0-\u17E9]",
  knda: "[\u0CE6-\u0CEF]",
  laoo: "[\u0ED0-\u0ED9]",
  limb: "[\u1946-\u194F]",
  mlym: "[\u0D66-\u0D6F]",
  mong: "[\u1810-\u1819]",
  mymr: "[\u1040-\u1049]",
  orya: "[\u0B66-\u0B6F]",
  tamldec: "[\u0BE6-\u0BEF]",
  telu: "[\u0C66-\u0C6F]",
  thai: "[\u0E50-\u0E59]",
  tibt: "[\u0F20-\u0F29]",
  latn: "\\d"
};
var numberingSystemsUTF16 = {
  arab: [1632, 1641],
  arabext: [1776, 1785],
  bali: [6992, 7001],
  beng: [2534, 2543],
  deva: [2406, 2415],
  fullwide: [65296, 65303],
  gujr: [2790, 2799],
  khmr: [6112, 6121],
  knda: [3302, 3311],
  laoo: [3792, 3801],
  limb: [6470, 6479],
  mlym: [3430, 3439],
  mong: [6160, 6169],
  mymr: [4160, 4169],
  orya: [2918, 2927],
  tamldec: [3046, 3055],
  telu: [3174, 3183],
  thai: [3664, 3673],
  tibt: [3872, 3881]
};
var hanidecChars = numberingSystems.hanidec.replace(/[\[|\]]/g, "").split("");
function parseDigits(str) {
  var value = parseInt(str, 10);
  if (isNaN(value)) {
    value = "";
    for (var i = 0; i < str.length; i++) {
      var code = str.charCodeAt(i);
      if (str[i].search(numberingSystems.hanidec) !== -1) {
        value += hanidecChars.indexOf(str[i]);
      } else {
        for (var key in numberingSystemsUTF16) {
          var _numberingSystemsUTF = numberingSystemsUTF16[key],
            min = _numberingSystemsUTF[0],
            max = _numberingSystemsUTF[1];
          if (code >= min && code <= max) {
            value += code - min;
          }
        }
      }
    }
    return parseInt(value, 10);
  } else {
    return value;
  }
}
function digitRegex(_ref, append) {
  var numberingSystem = _ref.numberingSystem;
  if (append === void 0) {
    append = "";
  }
  return new RegExp("" + numberingSystems[numberingSystem || "latn"] + append);
}

var MISSING_FTP = "missing Intl.DateTimeFormat.formatToParts support";
function intUnit(regex, post) {
  if (post === void 0) {
    post = function post(i) {
      return i;
    };
  }
  return {
    regex: regex,
    deser: function deser(_ref) {
      var s = _ref[0];
      return post(parseDigits(s));
    }
  };
}
var NBSP = String.fromCharCode(160);
var spaceOrNBSP = "[ " + NBSP + "]";
var spaceOrNBSPRegExp = new RegExp(spaceOrNBSP, "g");
function fixListRegex(s) {
  // make dots optional and also make them literal
  // make space and non breakable space characters interchangeable
  return s.replace(/\./g, "\\.?").replace(spaceOrNBSPRegExp, spaceOrNBSP);
}
function stripInsensitivities(s) {
  return s.replace(/\./g, "") // ignore dots that were made optional
  .replace(spaceOrNBSPRegExp, " ") // interchange space and nbsp
  .toLowerCase();
}
function oneOf(strings, startIndex) {
  if (strings === null) {
    return null;
  } else {
    return {
      regex: RegExp(strings.map(fixListRegex).join("|")),
      deser: function deser(_ref2) {
        var s = _ref2[0];
        return strings.findIndex(function (i) {
          return stripInsensitivities(s) === stripInsensitivities(i);
        }) + startIndex;
      }
    };
  }
}
function offset$2(regex, groups) {
  return {
    regex: regex,
    deser: function deser(_ref3) {
      var h = _ref3[1],
        m = _ref3[2];
      return signedOffset(h, m);
    },
    groups: groups
  };
}
function simple(regex) {
  return {
    regex: regex,
    deser: function deser(_ref4) {
      var s = _ref4[0];
      return s;
    }
  };
}
function escapeToken(value) {
  return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
}

/**
 * @param token
 * @param {Locale} loc
 */
function unitForToken(token, loc) {
  var one = digitRegex(loc),
    two = digitRegex(loc, "{2}"),
    three = digitRegex(loc, "{3}"),
    four = digitRegex(loc, "{4}"),
    six = digitRegex(loc, "{6}"),
    oneOrTwo = digitRegex(loc, "{1,2}"),
    oneToThree = digitRegex(loc, "{1,3}"),
    oneToSix = digitRegex(loc, "{1,6}"),
    oneToNine = digitRegex(loc, "{1,9}"),
    twoToFour = digitRegex(loc, "{2,4}"),
    fourToSix = digitRegex(loc, "{4,6}"),
    literal = function literal(t) {
      return {
        regex: RegExp(escapeToken(t.val)),
        deser: function deser(_ref5) {
          var s = _ref5[0];
          return s;
        },
        literal: true
      };
    },
    unitate = function unitate(t) {
      if (token.literal) {
        return literal(t);
      }
      switch (t.val) {
        // era
        case "G":
          return oneOf(loc.eras("short"), 0);
        case "GG":
          return oneOf(loc.eras("long"), 0);
        // years
        case "y":
          return intUnit(oneToSix);
        case "yy":
          return intUnit(twoToFour, untruncateYear);
        case "yyyy":
          return intUnit(four);
        case "yyyyy":
          return intUnit(fourToSix);
        case "yyyyyy":
          return intUnit(six);
        // months
        case "M":
          return intUnit(oneOrTwo);
        case "MM":
          return intUnit(two);
        case "MMM":
          return oneOf(loc.months("short", true), 1);
        case "MMMM":
          return oneOf(loc.months("long", true), 1);
        case "L":
          return intUnit(oneOrTwo);
        case "LL":
          return intUnit(two);
        case "LLL":
          return oneOf(loc.months("short", false), 1);
        case "LLLL":
          return oneOf(loc.months("long", false), 1);
        // dates
        case "d":
          return intUnit(oneOrTwo);
        case "dd":
          return intUnit(two);
        // ordinals
        case "o":
          return intUnit(oneToThree);
        case "ooo":
          return intUnit(three);
        // time
        case "HH":
          return intUnit(two);
        case "H":
          return intUnit(oneOrTwo);
        case "hh":
          return intUnit(two);
        case "h":
          return intUnit(oneOrTwo);
        case "mm":
          return intUnit(two);
        case "m":
          return intUnit(oneOrTwo);
        case "q":
          return intUnit(oneOrTwo);
        case "qq":
          return intUnit(two);
        case "s":
          return intUnit(oneOrTwo);
        case "ss":
          return intUnit(two);
        case "S":
          return intUnit(oneToThree);
        case "SSS":
          return intUnit(three);
        case "u":
          return simple(oneToNine);
        case "uu":
          return simple(oneOrTwo);
        case "uuu":
          return intUnit(one);
        // meridiem
        case "a":
          return oneOf(loc.meridiems(), 0);
        // weekYear (k)
        case "kkkk":
          return intUnit(four);
        case "kk":
          return intUnit(twoToFour, untruncateYear);
        // weekNumber (W)
        case "W":
          return intUnit(oneOrTwo);
        case "WW":
          return intUnit(two);
        // weekdays
        case "E":
        case "c":
          return intUnit(one);
        case "EEE":
          return oneOf(loc.weekdays("short", false), 1);
        case "EEEE":
          return oneOf(loc.weekdays("long", false), 1);
        case "ccc":
          return oneOf(loc.weekdays("short", true), 1);
        case "cccc":
          return oneOf(loc.weekdays("long", true), 1);
        // offset/zone
        case "Z":
        case "ZZ":
          return offset$2(new RegExp("([+-]" + oneOrTwo.source + ")(?::(" + two.source + "))?"), 2);
        case "ZZZ":
          return offset$2(new RegExp("([+-]" + oneOrTwo.source + ")(" + two.source + ")?"), 2);
        // we don't support ZZZZ (PST) or ZZZZZ (Pacific Standard Time) in parsing
        // because we don't have any way to figure out what they are
        case "z":
          return simple(/[a-z_+-/]{1,256}?/i);
        // this special-case "token" represents a place where a macro-token expanded into a white-space literal
        // in this case we accept any non-newline white-space
        case " ":
          return simple(/[^\S\n\r]/);
        default:
          return literal(t);
      }
    };
  var unit = unitate(token) || {
    invalidReason: MISSING_FTP
  };
  unit.token = token;
  return unit;
}
var partTypeStyleToTokenVal = {
  year: {
    "2-digit": "yy",
    numeric: "yyyyy"
  },
  month: {
    numeric: "M",
    "2-digit": "MM",
    short: "MMM",
    long: "MMMM"
  },
  day: {
    numeric: "d",
    "2-digit": "dd"
  },
  weekday: {
    short: "EEE",
    long: "EEEE"
  },
  dayperiod: "a",
  dayPeriod: "a",
  hour12: {
    numeric: "h",
    "2-digit": "hh"
  },
  hour24: {
    numeric: "H",
    "2-digit": "HH"
  },
  minute: {
    numeric: "m",
    "2-digit": "mm"
  },
  second: {
    numeric: "s",
    "2-digit": "ss"
  },
  timeZoneName: {
    long: "ZZZZZ",
    short: "ZZZ"
  }
};
function tokenForPart(part, formatOpts, resolvedOpts) {
  var type = part.type,
    value = part.value;
  if (type === "literal") {
    var isSpace = /^\s+$/.test(value);
    return {
      literal: !isSpace,
      val: isSpace ? " " : value
    };
  }
  var style = formatOpts[type];

  // The user might have explicitly specified hour12 or hourCycle
  // if so, respect their decision
  // if not, refer back to the resolvedOpts, which are based on the locale
  var actualType = type;
  if (type === "hour") {
    if (formatOpts.hour12 != null) {
      actualType = formatOpts.hour12 ? "hour12" : "hour24";
    } else if (formatOpts.hourCycle != null) {
      if (formatOpts.hourCycle === "h11" || formatOpts.hourCycle === "h12") {
        actualType = "hour12";
      } else {
        actualType = "hour24";
      }
    } else {
      // tokens only differentiate between 24 hours or not,
      // so we do not need to check hourCycle here, which is less supported anyways
      actualType = resolvedOpts.hour12 ? "hour12" : "hour24";
    }
  }
  var val = partTypeStyleToTokenVal[actualType];
  if (typeof val === "object") {
    val = val[style];
  }
  if (val) {
    return {
      literal: false,
      val: val
    };
  }
  return undefined;
}
function buildRegex(units) {
  var re = units.map(function (u) {
    return u.regex;
  }).reduce(function (f, r) {
    return f + "(" + r.source + ")";
  }, "");
  return ["^" + re + "$", units];
}
function match(input, regex, handlers) {
  var matches = input.match(regex);
  if (matches) {
    var all = {};
    var matchIndex = 1;
    for (var i in handlers) {
      if (hasOwnProperty(handlers, i)) {
        var h = handlers[i],
          groups = h.groups ? h.groups + 1 : 1;
        if (!h.literal && h.token) {
          all[h.token.val[0]] = h.deser(matches.slice(matchIndex, matchIndex + groups));
        }
        matchIndex += groups;
      }
    }
    return [matches, all];
  } else {
    return [matches, {}];
  }
}
function dateTimeFromMatches(matches) {
  var toField = function toField(token) {
    switch (token) {
      case "S":
        return "millisecond";
      case "s":
        return "second";
      case "m":
        return "minute";
      case "h":
      case "H":
        return "hour";
      case "d":
        return "day";
      case "o":
        return "ordinal";
      case "L":
      case "M":
        return "month";
      case "y":
        return "year";
      case "E":
      case "c":
        return "weekday";
      case "W":
        return "weekNumber";
      case "k":
        return "weekYear";
      case "q":
        return "quarter";
      default:
        return null;
    }
  };
  var zone = null;
  var specificOffset;
  if (!isUndefined(matches.z)) {
    zone = IANAZone.create(matches.z);
  }
  if (!isUndefined(matches.Z)) {
    if (!zone) {
      zone = new FixedOffsetZone(matches.Z);
    }
    specificOffset = matches.Z;
  }
  if (!isUndefined(matches.q)) {
    matches.M = (matches.q - 1) * 3 + 1;
  }
  if (!isUndefined(matches.h)) {
    if (matches.h < 12 && matches.a === 1) {
      matches.h += 12;
    } else if (matches.h === 12 && matches.a === 0) {
      matches.h = 0;
    }
  }
  if (matches.G === 0 && matches.y) {
    matches.y = -matches.y;
  }
  if (!isUndefined(matches.u)) {
    matches.S = parseMillis(matches.u);
  }
  var vals = Object.keys(matches).reduce(function (r, k) {
    var f = toField(k);
    if (f) {
      r[f] = matches[k];
    }
    return r;
  }, {});
  return [vals, zone, specificOffset];
}
var dummyDateTimeCache = null;
function getDummyDateTime() {
  if (!dummyDateTimeCache) {
    dummyDateTimeCache = DateTime.fromMillis(1555555555555);
  }
  return dummyDateTimeCache;
}
function maybeExpandMacroToken(token, locale) {
  if (token.literal) {
    return token;
  }
  var formatOpts = Formatter.macroTokenToFormatOpts(token.val);
  var tokens = formatOptsToTokens(formatOpts, locale);
  if (tokens == null || tokens.includes(undefined)) {
    return token;
  }
  return tokens;
}
function expandMacroTokens(tokens, locale) {
  var _Array$prototype;
  return (_Array$prototype = Array.prototype).concat.apply(_Array$prototype, tokens.map(function (t) {
    return maybeExpandMacroToken(t, locale);
  }));
}

/**
 * @private
 */

function explainFromTokens(locale, input, format) {
  var tokens = expandMacroTokens(Formatter.parseFormat(format), locale),
    units = tokens.map(function (t) {
      return unitForToken(t, locale);
    }),
    disqualifyingUnit = units.find(function (t) {
      return t.invalidReason;
    });
  if (disqualifyingUnit) {
    return {
      input: input,
      tokens: tokens,
      invalidReason: disqualifyingUnit.invalidReason
    };
  } else {
    var _buildRegex = buildRegex(units),
      regexString = _buildRegex[0],
      handlers = _buildRegex[1],
      regex = RegExp(regexString, "i"),
      _match = match(input, regex, handlers),
      rawMatches = _match[0],
      matches = _match[1],
      _ref6 = matches ? dateTimeFromMatches(matches) : [null, null, undefined],
      result = _ref6[0],
      zone = _ref6[1],
      specificOffset = _ref6[2];
    if (hasOwnProperty(matches, "a") && hasOwnProperty(matches, "H")) {
      throw new ConflictingSpecificationError("Can't include meridiem when specifying 24-hour format");
    }
    return {
      input: input,
      tokens: tokens,
      regex: regex,
      rawMatches: rawMatches,
      matches: matches,
      result: result,
      zone: zone,
      specificOffset: specificOffset
    };
  }
}
function parseFromTokens(locale, input, format) {
  var _explainFromTokens = explainFromTokens(locale, input, format),
    result = _explainFromTokens.result,
    zone = _explainFromTokens.zone,
    specificOffset = _explainFromTokens.specificOffset,
    invalidReason = _explainFromTokens.invalidReason;
  return [result, zone, specificOffset, invalidReason];
}
function formatOptsToTokens(formatOpts, locale) {
  if (!formatOpts) {
    return null;
  }
  var formatter = Formatter.create(locale, formatOpts);
  var df = formatter.dtFormatter(getDummyDateTime());
  var parts = df.formatToParts();
  var resolvedOpts = df.resolvedOptions();
  return parts.map(function (p) {
    return tokenForPart(p, formatOpts, resolvedOpts);
  });
}

var INVALID = "Invalid DateTime";
var MAX_DATE = 8.64e15;
function unsupportedZone(zone) {
  return new Invalid("unsupported zone", "the zone \"" + zone.name + "\" is not supported");
}

// we cache week data on the DT object and this intermediates the cache
/**
 * @param {DateTime} dt
 */
function possiblyCachedWeekData(dt) {
  if (dt.weekData === null) {
    dt.weekData = gregorianToWeek(dt.c);
  }
  return dt.weekData;
}

/**
 * @param {DateTime} dt
 */
function possiblyCachedLocalWeekData(dt) {
  if (dt.localWeekData === null) {
    dt.localWeekData = gregorianToWeek(dt.c, dt.loc.getMinDaysInFirstWeek(), dt.loc.getStartOfWeek());
  }
  return dt.localWeekData;
}

// clone really means, "make a new object with these modifications". all "setters" really use this
// to create a new object while only changing some of the properties
function clone(inst, alts) {
  var current = {
    ts: inst.ts,
    zone: inst.zone,
    c: inst.c,
    o: inst.o,
    loc: inst.loc,
    invalid: inst.invalid
  };
  return new DateTime(_extends({}, current, alts, {
    old: current
  }));
}

// find the right offset a given local time. The o input is our guess, which determines which
// offset we'll pick in ambiguous cases (e.g. there are two 3 AMs b/c Fallback DST)
function fixOffset(localTS, o, tz) {
  // Our UTC time is just a guess because our offset is just a guess
  var utcGuess = localTS - o * 60 * 1000;

  // Test whether the zone matches the offset for this ts
  var o2 = tz.offset(utcGuess);

  // If so, offset didn't change and we're done
  if (o === o2) {
    return [utcGuess, o];
  }

  // If not, change the ts by the difference in the offset
  utcGuess -= (o2 - o) * 60 * 1000;

  // If that gives us the local time we want, we're done
  var o3 = tz.offset(utcGuess);
  if (o2 === o3) {
    return [utcGuess, o2];
  }

  // If it's different, we're in a hole time. The offset has changed, but the we don't adjust the time
  return [localTS - Math.min(o2, o3) * 60 * 1000, Math.max(o2, o3)];
}

// convert an epoch timestamp into a calendar object with the given offset
function tsToObj(ts, offset) {
  ts += offset * 60 * 1000;
  var d = new Date(ts);
  return {
    year: d.getUTCFullYear(),
    month: d.getUTCMonth() + 1,
    day: d.getUTCDate(),
    hour: d.getUTCHours(),
    minute: d.getUTCMinutes(),
    second: d.getUTCSeconds(),
    millisecond: d.getUTCMilliseconds()
  };
}

// convert a calendar object to a epoch timestamp
function objToTS(obj, offset, zone) {
  return fixOffset(objToLocalTS(obj), offset, zone);
}

// create a new DT instance by adding a duration, adjusting for DSTs
function adjustTime(inst, dur) {
  var oPre = inst.o,
    year = inst.c.year + Math.trunc(dur.years),
    month = inst.c.month + Math.trunc(dur.months) + Math.trunc(dur.quarters) * 3,
    c = _extends({}, inst.c, {
      year: year,
      month: month,
      day: Math.min(inst.c.day, daysInMonth(year, month)) + Math.trunc(dur.days) + Math.trunc(dur.weeks) * 7
    }),
    millisToAdd = Duration.fromObject({
      years: dur.years - Math.trunc(dur.years),
      quarters: dur.quarters - Math.trunc(dur.quarters),
      months: dur.months - Math.trunc(dur.months),
      weeks: dur.weeks - Math.trunc(dur.weeks),
      days: dur.days - Math.trunc(dur.days),
      hours: dur.hours,
      minutes: dur.minutes,
      seconds: dur.seconds,
      milliseconds: dur.milliseconds
    }).as("milliseconds"),
    localTS = objToLocalTS(c);
  var _fixOffset = fixOffset(localTS, oPre, inst.zone),
    ts = _fixOffset[0],
    o = _fixOffset[1];
  if (millisToAdd !== 0) {
    ts += millisToAdd;
    // that could have changed the offset by going over a DST, but we want to keep the ts the same
    o = inst.zone.offset(ts);
  }
  return {
    ts: ts,
    o: o
  };
}

// helper useful in turning the results of parsing into real dates
// by handling the zone options
function parseDataToDateTime(parsed, parsedZone, opts, format, text, specificOffset) {
  var setZone = opts.setZone,
    zone = opts.zone;
  if (parsed && Object.keys(parsed).length !== 0 || parsedZone) {
    var interpretationZone = parsedZone || zone,
      inst = DateTime.fromObject(parsed, _extends({}, opts, {
        zone: interpretationZone,
        specificOffset: specificOffset
      }));
    return setZone ? inst : inst.setZone(zone);
  } else {
    return DateTime.invalid(new Invalid("unparsable", "the input \"" + text + "\" can't be parsed as " + format));
  }
}

// if you want to output a technical format (e.g. RFC 2822), this helper
// helps handle the details
function toTechFormat(dt, format, allowZ) {
  if (allowZ === void 0) {
    allowZ = true;
  }
  return dt.isValid ? Formatter.create(Locale.create("en-US"), {
    allowZ: allowZ,
    forceSimple: true
  }).formatDateTimeFromString(dt, format) : null;
}
function _toISODate(o, extended) {
  var longFormat = o.c.year > 9999 || o.c.year < 0;
  var c = "";
  if (longFormat && o.c.year >= 0) c += "+";
  c += padStart(o.c.year, longFormat ? 6 : 4);
  if (extended) {
    c += "-";
    c += padStart(o.c.month);
    c += "-";
    c += padStart(o.c.day);
  } else {
    c += padStart(o.c.month);
    c += padStart(o.c.day);
  }
  return c;
}
function _toISOTime(o, extended, suppressSeconds, suppressMilliseconds, includeOffset, extendedZone) {
  var c = padStart(o.c.hour);
  if (extended) {
    c += ":";
    c += padStart(o.c.minute);
    if (o.c.millisecond !== 0 || o.c.second !== 0 || !suppressSeconds) {
      c += ":";
    }
  } else {
    c += padStart(o.c.minute);
  }
  if (o.c.millisecond !== 0 || o.c.second !== 0 || !suppressSeconds) {
    c += padStart(o.c.second);
    if (o.c.millisecond !== 0 || !suppressMilliseconds) {
      c += ".";
      c += padStart(o.c.millisecond, 3);
    }
  }
  if (includeOffset) {
    if (o.isOffsetFixed && o.offset === 0 && !extendedZone) {
      c += "Z";
    } else if (o.o < 0) {
      c += "-";
      c += padStart(Math.trunc(-o.o / 60));
      c += ":";
      c += padStart(Math.trunc(-o.o % 60));
    } else {
      c += "+";
      c += padStart(Math.trunc(o.o / 60));
      c += ":";
      c += padStart(Math.trunc(o.o % 60));
    }
  }
  if (extendedZone) {
    c += "[" + o.zone.ianaName + "]";
  }
  return c;
}

// defaults for unspecified units in the supported calendars
var defaultUnitValues = {
    month: 1,
    day: 1,
    hour: 0,
    minute: 0,
    second: 0,
    millisecond: 0
  },
  defaultWeekUnitValues = {
    weekNumber: 1,
    weekday: 1,
    hour: 0,
    minute: 0,
    second: 0,
    millisecond: 0
  },
  defaultOrdinalUnitValues = {
    ordinal: 1,
    hour: 0,
    minute: 0,
    second: 0,
    millisecond: 0
  };

// Units in the supported calendars, sorted by bigness
var orderedUnits = ["year", "month", "day", "hour", "minute", "second", "millisecond"],
  orderedWeekUnits = ["weekYear", "weekNumber", "weekday", "hour", "minute", "second", "millisecond"],
  orderedOrdinalUnits = ["year", "ordinal", "hour", "minute", "second", "millisecond"];

// standardize case and plurality in units
function normalizeUnit(unit) {
  var normalized = {
    year: "year",
    years: "year",
    month: "month",
    months: "month",
    day: "day",
    days: "day",
    hour: "hour",
    hours: "hour",
    minute: "minute",
    minutes: "minute",
    quarter: "quarter",
    quarters: "quarter",
    second: "second",
    seconds: "second",
    millisecond: "millisecond",
    milliseconds: "millisecond",
    weekday: "weekday",
    weekdays: "weekday",
    weeknumber: "weekNumber",
    weeksnumber: "weekNumber",
    weeknumbers: "weekNumber",
    weekyear: "weekYear",
    weekyears: "weekYear",
    ordinal: "ordinal"
  }[unit.toLowerCase()];
  if (!normalized) throw new InvalidUnitError(unit);
  return normalized;
}
function normalizeUnitWithLocalWeeks(unit) {
  switch (unit.toLowerCase()) {
    case "localweekday":
    case "localweekdays":
      return "localWeekday";
    case "localweeknumber":
    case "localweeknumbers":
      return "localWeekNumber";
    case "localweekyear":
    case "localweekyears":
      return "localWeekYear";
    default:
      return normalizeUnit(unit);
  }
}

// this is a dumbed down version of fromObject() that runs about 60% faster
// but doesn't do any validation, makes a bunch of assumptions about what units
// are present, and so on.
function quickDT(obj, opts) {
  var zone = normalizeZone(opts.zone, Settings.defaultZone),
    loc = Locale.fromObject(opts),
    tsNow = Settings.now();
  var ts, o;

  // assume we have the higher-order units
  if (!isUndefined(obj.year)) {
    for (var _i = 0, _orderedUnits = orderedUnits; _i < _orderedUnits.length; _i++) {
      var u = _orderedUnits[_i];
      if (isUndefined(obj[u])) {
        obj[u] = defaultUnitValues[u];
      }
    }
    var invalid = hasInvalidGregorianData(obj) || hasInvalidTimeData(obj);
    if (invalid) {
      return DateTime.invalid(invalid);
    }
    var offsetProvis = zone.offset(tsNow);
    var _objToTS = objToTS(obj, offsetProvis, zone);
    ts = _objToTS[0];
    o = _objToTS[1];
  } else {
    ts = tsNow;
  }
  return new DateTime({
    ts: ts,
    zone: zone,
    loc: loc,
    o: o
  });
}
function diffRelative(start, end, opts) {
  var round = isUndefined(opts.round) ? true : opts.round,
    format = function format(c, unit) {
      c = roundTo(c, round || opts.calendary ? 0 : 2, true);
      var formatter = end.loc.clone(opts).relFormatter(opts);
      return formatter.format(c, unit);
    },
    differ = function differ(unit) {
      if (opts.calendary) {
        if (!end.hasSame(start, unit)) {
          return end.startOf(unit).diff(start.startOf(unit), unit).get(unit);
        } else return 0;
      } else {
        return end.diff(start, unit).get(unit);
      }
    };
  if (opts.unit) {
    return format(differ(opts.unit), opts.unit);
  }
  for (var _iterator = _createForOfIteratorHelperLoose(opts.units), _step; !(_step = _iterator()).done;) {
    var unit = _step.value;
    var count = differ(unit);
    if (Math.abs(count) >= 1) {
      return format(count, unit);
    }
  }
  return format(start > end ? -0 : 0, opts.units[opts.units.length - 1]);
}
function lastOpts(argList) {
  var opts = {},
    args;
  if (argList.length > 0 && typeof argList[argList.length - 1] === "object") {
    opts = argList[argList.length - 1];
    args = Array.from(argList).slice(0, argList.length - 1);
  } else {
    args = Array.from(argList);
  }
  return [opts, args];
}

/**
 * A DateTime is an immutable data structure representing a specific date and time and accompanying methods. It contains class and instance methods for creating, parsing, interrogating, transforming, and formatting them.
 *
 * A DateTime comprises of:
 * * A timestamp. Each DateTime instance refers to a specific millisecond of the Unix epoch.
 * * A time zone. Each instance is considered in the context of a specific zone (by default the local system's zone).
 * * Configuration properties that effect how output strings are formatted, such as `locale`, `numberingSystem`, and `outputCalendar`.
 *
 * Here is a brief overview of the most commonly used functionality it provides:
 *
 * * **Creation**: To create a DateTime from its components, use one of its factory class methods: {@link DateTime.local}, {@link DateTime.utc}, and (most flexibly) {@link DateTime.fromObject}. To create one from a standard string format, use {@link DateTime.fromISO}, {@link DateTime.fromHTTP}, and {@link DateTime.fromRFC2822}. To create one from a custom string format, use {@link DateTime.fromFormat}. To create one from a native JS date, use {@link DateTime.fromJSDate}.
 * * **Gregorian calendar and time**: To examine the Gregorian properties of a DateTime individually (i.e as opposed to collectively through {@link DateTime#toObject}), use the {@link DateTime#year}, {@link DateTime#month},
 * {@link DateTime#day}, {@link DateTime#hour}, {@link DateTime#minute}, {@link DateTime#second}, {@link DateTime#millisecond} accessors.
 * * **Week calendar**: For ISO week calendar attributes, see the {@link DateTime#weekYear}, {@link DateTime#weekNumber}, and {@link DateTime#weekday} accessors.
 * * **Configuration** See the {@link DateTime#locale} and {@link DateTime#numberingSystem} accessors.
 * * **Transformation**: To transform the DateTime into other DateTimes, use {@link DateTime#set}, {@link DateTime#reconfigure}, {@link DateTime#setZone}, {@link DateTime#setLocale}, {@link DateTime.plus}, {@link DateTime#minus}, {@link DateTime#endOf}, {@link DateTime#startOf}, {@link DateTime#toUTC}, and {@link DateTime#toLocal}.
 * * **Output**: To convert the DateTime to other representations, use the {@link DateTime#toRelative}, {@link DateTime#toRelativeCalendar}, {@link DateTime#toJSON}, {@link DateTime#toISO}, {@link DateTime#toHTTP}, {@link DateTime#toObject}, {@link DateTime#toRFC2822}, {@link DateTime#toString}, {@link DateTime#toLocaleString}, {@link DateTime#toFormat}, {@link DateTime#toMillis} and {@link DateTime#toJSDate}.
 *
 * There's plenty others documented below. In addition, for more information on subtler topics like internationalization, time zones, alternative calendars, validity, and so on, see the external documentation.
 */
var DateTime = /*#__PURE__*/function (_Symbol$for) {
  /**
   * @access private
   */
  function DateTime(config) {
    var zone = config.zone || Settings.defaultZone;
    var invalid = config.invalid || (Number.isNaN(config.ts) ? new Invalid("invalid input") : null) || (!zone.isValid ? unsupportedZone(zone) : null);
    /**
     * @access private
     */
    this.ts = isUndefined(config.ts) ? Settings.now() : config.ts;
    var c = null,
      o = null;
    if (!invalid) {
      var unchanged = config.old && config.old.ts === this.ts && config.old.zone.equals(zone);
      if (unchanged) {
        var _ref = [config.old.c, config.old.o];
        c = _ref[0];
        o = _ref[1];
      } else {
        var ot = zone.offset(this.ts);
        c = tsToObj(this.ts, ot);
        invalid = Number.isNaN(c.year) ? new Invalid("invalid input") : null;
        c = invalid ? null : c;
        o = invalid ? null : ot;
      }
    }

    /**
     * @access private
     */
    this._zone = zone;
    /**
     * @access private
     */
    this.loc = config.loc || Locale.create();
    /**
     * @access private
     */
    this.invalid = invalid;
    /**
     * @access private
     */
    this.weekData = null;
    /**
     * @access private
     */
    this.localWeekData = null;
    /**
     * @access private
     */
    this.c = c;
    /**
     * @access private
     */
    this.o = o;
    /**
     * @access private
     */
    this.isLuxonDateTime = true;
  }

  // CONSTRUCT

  /**
   * Create a DateTime for the current instant, in the system's time zone.
   *
   * Use Settings to override these default values if needed.
   * @example DateTime.now().toISO() //~> now in the ISO format
   * @return {DateTime}
   */
  DateTime.now = function now() {
    return new DateTime({});
  }

  /**
   * Create a local DateTime
   * @param {number} [year] - The calendar year. If omitted (as in, call `local()` with no arguments), the current time will be used
   * @param {number} [month=1] - The month, 1-indexed
   * @param {number} [day=1] - The day of the month, 1-indexed
   * @param {number} [hour=0] - The hour of the day, in 24-hour time
   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
   * @example DateTime.local()                                  //~> now
   * @example DateTime.local({ zone: "America/New_York" })      //~> now, in US east coast time
   * @example DateTime.local(2017)                              //~> 2017-01-01T00:00:00
   * @example DateTime.local(2017, 3)                           //~> 2017-03-01T00:00:00
   * @example DateTime.local(2017, 3, 12, { locale: "fr" })     //~> 2017-03-12T00:00:00, with a French locale
   * @example DateTime.local(2017, 3, 12, 5)                    //~> 2017-03-12T05:00:00
   * @example DateTime.local(2017, 3, 12, 5, { zone: "utc" })   //~> 2017-03-12T05:00:00, in UTC
   * @example DateTime.local(2017, 3, 12, 5, 45)                //~> 2017-03-12T05:45:00
   * @example DateTime.local(2017, 3, 12, 5, 45, 10)            //~> 2017-03-12T05:45:10
   * @example DateTime.local(2017, 3, 12, 5, 45, 10, 765)       //~> 2017-03-12T05:45:10.765
   * @return {DateTime}
   */;
  DateTime.local = function local() {
    var _lastOpts = lastOpts(arguments),
      opts = _lastOpts[0],
      args = _lastOpts[1],
      year = args[0],
      month = args[1],
      day = args[2],
      hour = args[3],
      minute = args[4],
      second = args[5],
      millisecond = args[6];
    return quickDT({
      year: year,
      month: month,
      day: day,
      hour: hour,
      minute: minute,
      second: second,
      millisecond: millisecond
    }, opts);
  }

  /**
   * Create a DateTime in UTC
   * @param {number} [year] - The calendar year. If omitted (as in, call `utc()` with no arguments), the current time will be used
   * @param {number} [month=1] - The month, 1-indexed
   * @param {number} [day=1] - The day of the month
   * @param {number} [hour=0] - The hour of the day, in 24-hour time
   * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
   * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
   * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
   * @param {Object} options - configuration options for the DateTime
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} [options.outputCalendar] - the output calendar to set on the resulting DateTime instance
   * @param {string} [options.numberingSystem] - the numbering system to set on the resulting DateTime instance
   * @example DateTime.utc()                                              //~> now
   * @example DateTime.utc(2017)                                          //~> 2017-01-01T00:00:00Z
   * @example DateTime.utc(2017, 3)                                       //~> 2017-03-01T00:00:00Z
   * @example DateTime.utc(2017, 3, 12)                                   //~> 2017-03-12T00:00:00Z
   * @example DateTime.utc(2017, 3, 12, 5)                                //~> 2017-03-12T05:00:00Z
   * @example DateTime.utc(2017, 3, 12, 5, 45)                            //~> 2017-03-12T05:45:00Z
   * @example DateTime.utc(2017, 3, 12, 5, 45, { locale: "fr" })          //~> 2017-03-12T05:45:00Z with a French locale
   * @example DateTime.utc(2017, 3, 12, 5, 45, 10)                        //~> 2017-03-12T05:45:10Z
   * @example DateTime.utc(2017, 3, 12, 5, 45, 10, 765, { locale: "fr" }) //~> 2017-03-12T05:45:10.765Z with a French locale
   * @return {DateTime}
   */;
  DateTime.utc = function utc() {
    var _lastOpts2 = lastOpts(arguments),
      opts = _lastOpts2[0],
      args = _lastOpts2[1],
      year = args[0],
      month = args[1],
      day = args[2],
      hour = args[3],
      minute = args[4],
      second = args[5],
      millisecond = args[6];
    opts.zone = FixedOffsetZone.utcInstance;
    return quickDT({
      year: year,
      month: month,
      day: day,
      hour: hour,
      minute: minute,
      second: second,
      millisecond: millisecond
    }, opts);
  }

  /**
   * Create a DateTime from a JavaScript Date object. Uses the default zone.
   * @param {Date} date - a JavaScript Date object
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @return {DateTime}
   */;
  DateTime.fromJSDate = function fromJSDate(date, options) {
    if (options === void 0) {
      options = {};
    }
    var ts = isDate(date) ? date.valueOf() : NaN;
    if (Number.isNaN(ts)) {
      return DateTime.invalid("invalid input");
    }
    var zoneToUse = normalizeZone(options.zone, Settings.defaultZone);
    if (!zoneToUse.isValid) {
      return DateTime.invalid(unsupportedZone(zoneToUse));
    }
    return new DateTime({
      ts: ts,
      zone: zoneToUse,
      loc: Locale.fromObject(options)
    });
  }

  /**
   * Create a DateTime from a number of milliseconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
   * @param {number} milliseconds - a number of milliseconds since 1970 UTC
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @return {DateTime}
   */;
  DateTime.fromMillis = function fromMillis(milliseconds, options) {
    if (options === void 0) {
      options = {};
    }
    if (!isNumber(milliseconds)) {
      throw new InvalidArgumentError("fromMillis requires a numerical input, but received a " + typeof milliseconds + " with value " + milliseconds);
    } else if (milliseconds < -MAX_DATE || milliseconds > MAX_DATE) {
      // this isn't perfect because because we can still end up out of range because of additional shifting, but it's a start
      return DateTime.invalid("Timestamp out of range");
    } else {
      return new DateTime({
        ts: milliseconds,
        zone: normalizeZone(options.zone, Settings.defaultZone),
        loc: Locale.fromObject(options)
      });
    }
  }

  /**
   * Create a DateTime from a number of seconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
   * @param {number} seconds - a number of seconds since 1970 UTC
   * @param {Object} options - configuration options for the DateTime
   * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
   * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
   * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @return {DateTime}
   */;
  DateTime.fromSeconds = function fromSeconds(seconds, options) {
    if (options === void 0) {
      options = {};
    }
    if (!isNumber(seconds)) {
      throw new InvalidArgumentError("fromSeconds requires a numerical input");
    } else {
      return new DateTime({
        ts: seconds * 1000,
        zone: normalizeZone(options.zone, Settings.defaultZone),
        loc: Locale.fromObject(options)
      });
    }
  }

  /**
   * Create a DateTime from a JavaScript object with keys like 'year' and 'hour' with reasonable defaults.
   * @param {Object} obj - the object to create the DateTime from
   * @param {number} obj.year - a year, such as 1987
   * @param {number} obj.month - a month, 1-12
   * @param {number} obj.day - a day of the month, 1-31, depending on the month
   * @param {number} obj.ordinal - day of the year, 1-365 or 366
   * @param {number} obj.weekYear - an ISO week year
   * @param {number} obj.weekNumber - an ISO week number, between 1 and 52 or 53, depending on the year
   * @param {number} obj.weekday - an ISO weekday, 1-7, where 1 is Monday and 7 is Sunday
   * @param {number} obj.localWeekYear - a week year, according to the locale
   * @param {number} obj.localWeekNumber - a week number, between 1 and 52 or 53, depending on the year, according to the locale
   * @param {number} obj.localWeekday - a weekday, 1-7, where 1 is the first and 7 is the last day of the week, according to the locale
   * @param {number} obj.hour - hour of the day, 0-23
   * @param {number} obj.minute - minute of the hour, 0-59
   * @param {number} obj.second - second of the minute, 0-59
   * @param {number} obj.millisecond - millisecond of the second, 0-999
   * @param {Object} opts - options for creating this DateTime
   * @param {string|Zone} [opts.zone='local'] - interpret the numbers in the context of a particular zone. Can take any value taken as the first argument to setZone()
   * @param {string} [opts.locale='system\'s locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromObject({ year: 1982, month: 5, day: 25}).toISODate() //=> '1982-05-25'
   * @example DateTime.fromObject({ year: 1982 }).toISODate() //=> '1982-01-01'
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }) //~> today at 10:26:06
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'utc' }),
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'local' })
   * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'America/New_York' })
   * @example DateTime.fromObject({ weekYear: 2016, weekNumber: 2, weekday: 3 }).toISODate() //=> '2016-01-13'
   * @example DateTime.fromObject({ localWeekYear: 2022, localWeekNumber: 1, localWeekday: 1 }, { locale: "en-US" }).toISODate() //=> '2021-12-26'
   * @return {DateTime}
   */;
  DateTime.fromObject = function fromObject(obj, opts) {
    if (opts === void 0) {
      opts = {};
    }
    obj = obj || {};
    var zoneToUse = normalizeZone(opts.zone, Settings.defaultZone);
    if (!zoneToUse.isValid) {
      return DateTime.invalid(unsupportedZone(zoneToUse));
    }
    var loc = Locale.fromObject(opts);
    var normalized = normalizeObject(obj, normalizeUnitWithLocalWeeks);
    var _usesLocalWeekValues = usesLocalWeekValues(normalized, loc),
      minDaysInFirstWeek = _usesLocalWeekValues.minDaysInFirstWeek,
      startOfWeek = _usesLocalWeekValues.startOfWeek;
    var tsNow = Settings.now(),
      offsetProvis = !isUndefined(opts.specificOffset) ? opts.specificOffset : zoneToUse.offset(tsNow),
      containsOrdinal = !isUndefined(normalized.ordinal),
      containsGregorYear = !isUndefined(normalized.year),
      containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
      containsGregor = containsGregorYear || containsGregorMD,
      definiteWeekDef = normalized.weekYear || normalized.weekNumber;

    // cases:
    // just a weekday -> this week's instance of that weekday, no worries
    // (gregorian data or ordinal) + (weekYear or weekNumber) -> error
    // (gregorian month or day) + ordinal -> error
    // otherwise just use weeks or ordinals or gregorian, depending on what's specified

    if ((containsGregor || containsOrdinal) && definiteWeekDef) {
      throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");
    }
    if (containsGregorMD && containsOrdinal) {
      throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
    }
    var useWeekData = definiteWeekDef || normalized.weekday && !containsGregor;

    // configure ourselves to deal with gregorian dates or week stuff
    var units,
      defaultValues,
      objNow = tsToObj(tsNow, offsetProvis);
    if (useWeekData) {
      units = orderedWeekUnits;
      defaultValues = defaultWeekUnitValues;
      objNow = gregorianToWeek(objNow, minDaysInFirstWeek, startOfWeek);
    } else if (containsOrdinal) {
      units = orderedOrdinalUnits;
      defaultValues = defaultOrdinalUnitValues;
      objNow = gregorianToOrdinal(objNow);
    } else {
      units = orderedUnits;
      defaultValues = defaultUnitValues;
    }

    // set default values for missing stuff
    var foundFirst = false;
    for (var _iterator2 = _createForOfIteratorHelperLoose(units), _step2; !(_step2 = _iterator2()).done;) {
      var u = _step2.value;
      var v = normalized[u];
      if (!isUndefined(v)) {
        foundFirst = true;
      } else if (foundFirst) {
        normalized[u] = defaultValues[u];
      } else {
        normalized[u] = objNow[u];
      }
    }

    // make sure the values we have are in range
    var higherOrderInvalid = useWeekData ? hasInvalidWeekData(normalized, minDaysInFirstWeek, startOfWeek) : containsOrdinal ? hasInvalidOrdinalData(normalized) : hasInvalidGregorianData(normalized),
      invalid = higherOrderInvalid || hasInvalidTimeData(normalized);
    if (invalid) {
      return DateTime.invalid(invalid);
    }

    // compute the actual time
    var gregorian = useWeekData ? weekToGregorian(normalized, minDaysInFirstWeek, startOfWeek) : containsOrdinal ? ordinalToGregorian(normalized) : normalized,
      _objToTS2 = objToTS(gregorian, offsetProvis, zoneToUse),
      tsFinal = _objToTS2[0],
      offsetFinal = _objToTS2[1],
      inst = new DateTime({
        ts: tsFinal,
        zone: zoneToUse,
        o: offsetFinal,
        loc: loc
      });

    // gregorian data + weekday serves only to validate
    if (normalized.weekday && containsGregor && obj.weekday !== inst.weekday) {
      return DateTime.invalid("mismatched weekday", "you can't specify both a weekday of " + normalized.weekday + " and a date of " + inst.toISO());
    }
    return inst;
  }

  /**
   * Create a DateTime from an ISO 8601 string
   * @param {string} text - the ISO string
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the time to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} [opts.outputCalendar] - the output calendar to set on the resulting DateTime instance
   * @param {string} [opts.numberingSystem] - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromISO('2016-05-25T09:08:34.123')
   * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00')
   * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00', {setZone: true})
   * @example DateTime.fromISO('2016-05-25T09:08:34.123', {zone: 'utc'})
   * @example DateTime.fromISO('2016-W05-4')
   * @return {DateTime}
   */;
  DateTime.fromISO = function fromISO(text, opts) {
    if (opts === void 0) {
      opts = {};
    }
    var _parseISODate = parseISODate(text),
      vals = _parseISODate[0],
      parsedZone = _parseISODate[1];
    return parseDataToDateTime(vals, parsedZone, opts, "ISO 8601", text);
  }

  /**
   * Create a DateTime from an RFC 2822 string
   * @param {string} text - the RFC 2822 string
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since the offset is always specified in the string itself, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
   * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromRFC2822('25 Nov 2016 13:23:12 GMT')
   * @example DateTime.fromRFC2822('Fri, 25 Nov 2016 13:23:12 +0600')
   * @example DateTime.fromRFC2822('25 Nov 2016 13:23 Z')
   * @return {DateTime}
   */;
  DateTime.fromRFC2822 = function fromRFC2822(text, opts) {
    if (opts === void 0) {
      opts = {};
    }
    var _parseRFC2822Date = parseRFC2822Date(text),
      vals = _parseRFC2822Date[0],
      parsedZone = _parseRFC2822Date[1];
    return parseDataToDateTime(vals, parsedZone, opts, "RFC 2822", text);
  }

  /**
   * Create a DateTime from an HTTP header date
   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
   * @param {string} text - the HTTP header date
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since HTTP dates are always in UTC, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
   * @param {boolean} [opts.setZone=false] - override the zone with the fixed-offset zone specified in the string. For HTTP dates, this is always UTC, so this option is equivalent to setting the `zone` option to 'utc', but this option is included for consistency with similar methods.
   * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
   * @example DateTime.fromHTTP('Sun, 06 Nov 1994 08:49:37 GMT')
   * @example DateTime.fromHTTP('Sunday, 06-Nov-94 08:49:37 GMT')
   * @example DateTime.fromHTTP('Sun Nov  6 08:49:37 1994')
   * @return {DateTime}
   */;
  DateTime.fromHTTP = function fromHTTP(text, opts) {
    if (opts === void 0) {
      opts = {};
    }
    var _parseHTTPDate = parseHTTPDate(text),
      vals = _parseHTTPDate[0],
      parsedZone = _parseHTTPDate[1];
    return parseDataToDateTime(vals, parsedZone, opts, "HTTP", opts);
  }

  /**
   * Create a DateTime from an input string and format string.
   * Defaults to en-US if no locale has been specified, regardless of the system's locale. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/parsing?id=table-of-tokens).
   * @param {string} text - the string to parse
   * @param {string} fmt - the format the string is expected to be in (see the link below for the formats)
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @return {DateTime}
   */;
  DateTime.fromFormat = function fromFormat(text, fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }
    if (isUndefined(text) || isUndefined(fmt)) {
      throw new InvalidArgumentError("fromFormat requires an input string and a format");
    }
    var _opts = opts,
      _opts$locale = _opts.locale,
      locale = _opts$locale === void 0 ? null : _opts$locale,
      _opts$numberingSystem = _opts.numberingSystem,
      numberingSystem = _opts$numberingSystem === void 0 ? null : _opts$numberingSystem,
      localeToUse = Locale.fromOpts({
        locale: locale,
        numberingSystem: numberingSystem,
        defaultToEN: true
      }),
      _parseFromTokens = parseFromTokens(localeToUse, text, fmt),
      vals = _parseFromTokens[0],
      parsedZone = _parseFromTokens[1],
      specificOffset = _parseFromTokens[2],
      invalid = _parseFromTokens[3];
    if (invalid) {
      return DateTime.invalid(invalid);
    } else {
      return parseDataToDateTime(vals, parsedZone, opts, "format " + fmt, text, specificOffset);
    }
  }

  /**
   * @deprecated use fromFormat instead
   */;
  DateTime.fromString = function fromString(text, fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }
    return DateTime.fromFormat(text, fmt, opts);
  }

  /**
   * Create a DateTime from a SQL date, time, or datetime
   * Defaults to en-US if no locale has been specified, regardless of the system's locale
   * @param {string} text - the string to parse
   * @param {Object} opts - options to affect the creation
   * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
   * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
   * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
   * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
   * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
   * @example DateTime.fromSQL('2017-05-15')
   * @example DateTime.fromSQL('2017-05-15 09:12:34')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342+06:00')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles')
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles', { setZone: true })
   * @example DateTime.fromSQL('2017-05-15 09:12:34.342', { zone: 'America/Los_Angeles' })
   * @example DateTime.fromSQL('09:12:34.342')
   * @return {DateTime}
   */;
  DateTime.fromSQL = function fromSQL(text, opts) {
    if (opts === void 0) {
      opts = {};
    }
    var _parseSQL = parseSQL(text),
      vals = _parseSQL[0],
      parsedZone = _parseSQL[1];
    return parseDataToDateTime(vals, parsedZone, opts, "SQL", text);
  }

  /**
   * Create an invalid DateTime.
   * @param {string} reason - simple string of why this DateTime is invalid. Should not contain parameters or anything else data-dependent.
   * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
   * @return {DateTime}
   */;
  DateTime.invalid = function invalid(reason, explanation) {
    if (explanation === void 0) {
      explanation = null;
    }
    if (!reason) {
      throw new InvalidArgumentError("need to specify a reason the DateTime is invalid");
    }
    var invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);
    if (Settings.throwOnInvalid) {
      throw new InvalidDateTimeError(invalid);
    } else {
      return new DateTime({
        invalid: invalid
      });
    }
  }

  /**
   * Check if an object is an instance of DateTime. Works across context boundaries
   * @param {object} o
   * @return {boolean}
   */;
  DateTime.isDateTime = function isDateTime(o) {
    return o && o.isLuxonDateTime || false;
  }

  /**
   * Produce the format string for a set of options
   * @param formatOpts
   * @param localeOpts
   * @returns {string}
   */;
  DateTime.parseFormatForOpts = function parseFormatForOpts(formatOpts, localeOpts) {
    if (localeOpts === void 0) {
      localeOpts = {};
    }
    var tokenList = formatOptsToTokens(formatOpts, Locale.fromObject(localeOpts));
    return !tokenList ? null : tokenList.map(function (t) {
      return t ? t.val : null;
    }).join("");
  }

  /**
   * Produce the the fully expanded format token for the locale
   * Does NOT quote characters, so quoted tokens will not round trip correctly
   * @param fmt
   * @param localeOpts
   * @returns {string}
   */;
  DateTime.expandFormat = function expandFormat(fmt, localeOpts) {
    if (localeOpts === void 0) {
      localeOpts = {};
    }
    var expanded = expandMacroTokens(Formatter.parseFormat(fmt), Locale.fromObject(localeOpts));
    return expanded.map(function (t) {
      return t.val;
    }).join("");
  }

  // INFO

  /**
   * Get the value of unit.
   * @param {string} unit - a unit such as 'minute' or 'day'
   * @example DateTime.local(2017, 7, 4).get('month'); //=> 7
   * @example DateTime.local(2017, 7, 4).get('day'); //=> 4
   * @return {number}
   */;
  var _proto = DateTime.prototype;
  _proto.get = function get(unit) {
    return this[unit];
  }

  /**
   * Returns whether the DateTime is valid. Invalid DateTimes occur when:
   * * The DateTime was created from invalid calendar information, such as the 13th month or February 30
   * * The DateTime was created by an operation on another invalid date
   * @type {boolean}
   */;
  /**
   * Get those DateTimes which have the same local time as this DateTime, but a different offset from UTC
   * in this DateTime's zone. During DST changes local time can be ambiguous, for example
   * `2023-10-29T02:30:00` in `Europe/Berlin` can have offset `+01:00` or `+02:00`.
   * This method will return both possible DateTimes if this DateTime's local time is ambiguous.
   * @returns {DateTime[]}
   */
  _proto.getPossibleOffsets = function getPossibleOffsets() {
    if (!this.isValid || this.isOffsetFixed) {
      return [this];
    }
    var dayMs = 86400000;
    var minuteMs = 60000;
    var localTS = objToLocalTS(this.c);
    var oEarlier = this.zone.offset(localTS - dayMs);
    var oLater = this.zone.offset(localTS + dayMs);
    var o1 = this.zone.offset(localTS - oEarlier * minuteMs);
    var o2 = this.zone.offset(localTS - oLater * minuteMs);
    if (o1 === o2) {
      return [this];
    }
    var ts1 = localTS - o1 * minuteMs;
    var ts2 = localTS - o2 * minuteMs;
    var c1 = tsToObj(ts1, o1);
    var c2 = tsToObj(ts2, o2);
    if (c1.hour === c2.hour && c1.minute === c2.minute && c1.second === c2.second && c1.millisecond === c2.millisecond) {
      return [clone(this, {
        ts: ts1
      }), clone(this, {
        ts: ts2
      })];
    }
    return [this];
  }

  /**
   * Returns true if this DateTime is in a leap year, false otherwise
   * @example DateTime.local(2016).isInLeapYear //=> true
   * @example DateTime.local(2013).isInLeapYear //=> false
   * @type {boolean}
   */;
  /**
   * Returns the resolved Intl options for this DateTime.
   * This is useful in understanding the behavior of formatting methods
   * @param {Object} opts - the same options as toLocaleString
   * @return {Object}
   */
  _proto.resolvedLocaleOptions = function resolvedLocaleOptions(opts) {
    if (opts === void 0) {
      opts = {};
    }
    var _Formatter$create$res = Formatter.create(this.loc.clone(opts), opts).resolvedOptions(this),
      locale = _Formatter$create$res.locale,
      numberingSystem = _Formatter$create$res.numberingSystem,
      calendar = _Formatter$create$res.calendar;
    return {
      locale: locale,
      numberingSystem: numberingSystem,
      outputCalendar: calendar
    };
  }

  // TRANSFORM

  /**
   * "Set" the DateTime's zone to UTC. Returns a newly-constructed DateTime.
   *
   * Equivalent to {@link DateTime#setZone}('utc')
   * @param {number} [offset=0] - optionally, an offset from UTC in minutes
   * @param {Object} [opts={}] - options to pass to `setZone()`
   * @return {DateTime}
   */;
  _proto.toUTC = function toUTC(offset, opts) {
    if (offset === void 0) {
      offset = 0;
    }
    if (opts === void 0) {
      opts = {};
    }
    return this.setZone(FixedOffsetZone.instance(offset), opts);
  }

  /**
   * "Set" the DateTime's zone to the host's local zone. Returns a newly-constructed DateTime.
   *
   * Equivalent to `setZone('local')`
   * @return {DateTime}
   */;
  _proto.toLocal = function toLocal() {
    return this.setZone(Settings.defaultZone);
  }

  /**
   * "Set" the DateTime's zone to specified zone. Returns a newly-constructed DateTime.
   *
   * By default, the setter keeps the underlying time the same (as in, the same timestamp), but the new instance will report different local times and consider DSTs when making computations, as with {@link DateTime#plus}. You may wish to use {@link DateTime#toLocal} and {@link DateTime#toUTC} which provide simple convenience wrappers for commonly used zones.
   * @param {string|Zone} [zone='local'] - a zone identifier. As a string, that can be any IANA zone supported by the host environment, or a fixed-offset name of the form 'UTC+3', or the strings 'local' or 'utc'. You may also supply an instance of a {@link DateTime#Zone} class.
   * @param {Object} opts - options
   * @param {boolean} [opts.keepLocalTime=false] - If true, adjust the underlying time so that the local time stays the same, but in the target zone. You should rarely need this.
   * @return {DateTime}
   */;
  _proto.setZone = function setZone(zone, _temp) {
    var _ref2 = _temp === void 0 ? {} : _temp,
      _ref2$keepLocalTime = _ref2.keepLocalTime,
      keepLocalTime = _ref2$keepLocalTime === void 0 ? false : _ref2$keepLocalTime,
      _ref2$keepCalendarTim = _ref2.keepCalendarTime,
      keepCalendarTime = _ref2$keepCalendarTim === void 0 ? false : _ref2$keepCalendarTim;
    zone = normalizeZone(zone, Settings.defaultZone);
    if (zone.equals(this.zone)) {
      return this;
    } else if (!zone.isValid) {
      return DateTime.invalid(unsupportedZone(zone));
    } else {
      var newTS = this.ts;
      if (keepLocalTime || keepCalendarTime) {
        var offsetGuess = zone.offset(this.ts);
        var asObj = this.toObject();
        var _objToTS3 = objToTS(asObj, offsetGuess, zone);
        newTS = _objToTS3[0];
      }
      return clone(this, {
        ts: newTS,
        zone: zone
      });
    }
  }

  /**
   * "Set" the locale, numberingSystem, or outputCalendar. Returns a newly-constructed DateTime.
   * @param {Object} properties - the properties to set
   * @example DateTime.local(2017, 5, 25).reconfigure({ locale: 'en-GB' })
   * @return {DateTime}
   */;
  _proto.reconfigure = function reconfigure(_temp2) {
    var _ref3 = _temp2 === void 0 ? {} : _temp2,
      locale = _ref3.locale,
      numberingSystem = _ref3.numberingSystem,
      outputCalendar = _ref3.outputCalendar;
    var loc = this.loc.clone({
      locale: locale,
      numberingSystem: numberingSystem,
      outputCalendar: outputCalendar
    });
    return clone(this, {
      loc: loc
    });
  }

  /**
   * "Set" the locale. Returns a newly-constructed DateTime.
   * Just a convenient alias for reconfigure({ locale })
   * @example DateTime.local(2017, 5, 25).setLocale('en-GB')
   * @return {DateTime}
   */;
  _proto.setLocale = function setLocale(locale) {
    return this.reconfigure({
      locale: locale
    });
  }

  /**
   * "Set" the values of specified units. Returns a newly-constructed DateTime.
   * You can only set units with this method; for "setting" metadata, see {@link DateTime#reconfigure} and {@link DateTime#setZone}.
   *
   * This method also supports setting locale-based week units, i.e. `localWeekday`, `localWeekNumber` and `localWeekYear`.
   * They cannot be mixed with ISO-week units like `weekday`.
   * @param {Object} values - a mapping of units to numbers
   * @example dt.set({ year: 2017 })
   * @example dt.set({ hour: 8, minute: 30 })
   * @example dt.set({ weekday: 5 })
   * @example dt.set({ year: 2005, ordinal: 234 })
   * @return {DateTime}
   */;
  _proto.set = function set(values) {
    if (!this.isValid) return this;
    var normalized = normalizeObject(values, normalizeUnitWithLocalWeeks);
    var _usesLocalWeekValues2 = usesLocalWeekValues(normalized, this.loc),
      minDaysInFirstWeek = _usesLocalWeekValues2.minDaysInFirstWeek,
      startOfWeek = _usesLocalWeekValues2.startOfWeek;
    var settingWeekStuff = !isUndefined(normalized.weekYear) || !isUndefined(normalized.weekNumber) || !isUndefined(normalized.weekday),
      containsOrdinal = !isUndefined(normalized.ordinal),
      containsGregorYear = !isUndefined(normalized.year),
      containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
      containsGregor = containsGregorYear || containsGregorMD,
      definiteWeekDef = normalized.weekYear || normalized.weekNumber;
    if ((containsGregor || containsOrdinal) && definiteWeekDef) {
      throw new ConflictingSpecificationError("Can't mix weekYear/weekNumber units with year/month/day or ordinals");
    }
    if (containsGregorMD && containsOrdinal) {
      throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
    }
    var mixed;
    if (settingWeekStuff) {
      mixed = weekToGregorian(_extends({}, gregorianToWeek(this.c, minDaysInFirstWeek, startOfWeek), normalized), minDaysInFirstWeek, startOfWeek);
    } else if (!isUndefined(normalized.ordinal)) {
      mixed = ordinalToGregorian(_extends({}, gregorianToOrdinal(this.c), normalized));
    } else {
      mixed = _extends({}, this.toObject(), normalized);

      // if we didn't set the day but we ended up on an overflow date,
      // use the last day of the right month
      if (isUndefined(normalized.day)) {
        mixed.day = Math.min(daysInMonth(mixed.year, mixed.month), mixed.day);
      }
    }
    var _objToTS4 = objToTS(mixed, this.o, this.zone),
      ts = _objToTS4[0],
      o = _objToTS4[1];
    return clone(this, {
      ts: ts,
      o: o
    });
  }

  /**
   * Add a period of time to this DateTime and return the resulting DateTime
   *
   * Adding hours, minutes, seconds, or milliseconds increases the timestamp by the right number of milliseconds. Adding days, months, or years shifts the calendar, accounting for DSTs and leap years along the way. Thus, `dt.plus({ hours: 24 })` may result in a different time than `dt.plus({ days: 1 })` if there's a DST shift in between.
   * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   * @example DateTime.now().plus(123) //~> in 123 milliseconds
   * @example DateTime.now().plus({ minutes: 15 }) //~> in 15 minutes
   * @example DateTime.now().plus({ days: 1 }) //~> this time tomorrow
   * @example DateTime.now().plus({ days: -1 }) //~> this time yesterday
   * @example DateTime.now().plus({ hours: 3, minutes: 13 }) //~> in 3 hr, 13 min
   * @example DateTime.now().plus(Duration.fromObject({ hours: 3, minutes: 13 })) //~> in 3 hr, 13 min
   * @return {DateTime}
   */;
  _proto.plus = function plus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration);
    return clone(this, adjustTime(this, dur));
  }

  /**
   * Subtract a period of time to this DateTime and return the resulting DateTime
   * See {@link DateTime#plus}
   * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
   @return {DateTime}
   */;
  _proto.minus = function minus(duration) {
    if (!this.isValid) return this;
    var dur = Duration.fromDurationLike(duration).negate();
    return clone(this, adjustTime(this, dur));
  }

  /**
   * "Set" this DateTime to the beginning of a unit of time.
   * @param {string} unit - The unit to go to the beginning of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
   * @param {Object} opts - options
   * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week
   * @example DateTime.local(2014, 3, 3).startOf('month').toISODate(); //=> '2014-03-01'
   * @example DateTime.local(2014, 3, 3).startOf('year').toISODate(); //=> '2014-01-01'
   * @example DateTime.local(2014, 3, 3).startOf('week').toISODate(); //=> '2014-03-03', weeks always start on Mondays
   * @example DateTime.local(2014, 3, 3, 5, 30).startOf('day').toISOTime(); //=> '00:00.000-05:00'
   * @example DateTime.local(2014, 3, 3, 5, 30).startOf('hour').toISOTime(); //=> '05:00:00.000-05:00'
   * @return {DateTime}
   */;
  _proto.startOf = function startOf(unit, _temp3) {
    var _ref4 = _temp3 === void 0 ? {} : _temp3,
      _ref4$useLocaleWeeks = _ref4.useLocaleWeeks,
      useLocaleWeeks = _ref4$useLocaleWeeks === void 0 ? false : _ref4$useLocaleWeeks;
    if (!this.isValid) return this;
    var o = {},
      normalizedUnit = Duration.normalizeUnit(unit);
    switch (normalizedUnit) {
      case "years":
        o.month = 1;
      // falls through
      case "quarters":
      case "months":
        o.day = 1;
      // falls through
      case "weeks":
      case "days":
        o.hour = 0;
      // falls through
      case "hours":
        o.minute = 0;
      // falls through
      case "minutes":
        o.second = 0;
      // falls through
      case "seconds":
        o.millisecond = 0;
        break;
      // no default, invalid units throw in normalizeUnit()
    }

    if (normalizedUnit === "weeks") {
      if (useLocaleWeeks) {
        var startOfWeek = this.loc.getStartOfWeek();
        var weekday = this.weekday;
        if (weekday < startOfWeek) {
          o.weekNumber = this.weekNumber - 1;
        }
        o.weekday = startOfWeek;
      } else {
        o.weekday = 1;
      }
    }
    if (normalizedUnit === "quarters") {
      var q = Math.ceil(this.month / 3);
      o.month = (q - 1) * 3 + 1;
    }
    return this.set(o);
  }

  /**
   * "Set" this DateTime to the end (meaning the last millisecond) of a unit of time
   * @param {string} unit - The unit to go to the end of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
   * @param {Object} opts - options
   * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week
   * @example DateTime.local(2014, 3, 3).endOf('month').toISO(); //=> '2014-03-31T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3).endOf('year').toISO(); //=> '2014-12-31T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3).endOf('week').toISO(); // => '2014-03-09T23:59:59.999-05:00', weeks start on Mondays
   * @example DateTime.local(2014, 3, 3, 5, 30).endOf('day').toISO(); //=> '2014-03-03T23:59:59.999-05:00'
   * @example DateTime.local(2014, 3, 3, 5, 30).endOf('hour').toISO(); //=> '2014-03-03T05:59:59.999-05:00'
   * @return {DateTime}
   */;
  _proto.endOf = function endOf(unit, opts) {
    var _this$plus;
    return this.isValid ? this.plus((_this$plus = {}, _this$plus[unit] = 1, _this$plus)).startOf(unit, opts).minus(1) : this;
  }

  // OUTPUT

  /**
   * Returns a string representation of this DateTime formatted according to the specified format string.
   * **You may not want this.** See {@link DateTime#toLocaleString} for a more flexible formatting tool. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/formatting?id=table-of-tokens).
   * Defaults to en-US if no locale has been specified, regardless of the system's locale.
   * @param {string} fmt - the format string
   * @param {Object} opts - opts to override the configuration options on this DateTime
   * @example DateTime.now().toFormat('yyyy LLL dd') //=> '2017 Apr 22'
   * @example DateTime.now().setLocale('fr').toFormat('yyyy LLL dd') //=> '2017 avr. 22'
   * @example DateTime.now().toFormat('yyyy LLL dd', { locale: "fr" }) //=> '2017 avr. 22'
   * @example DateTime.now().toFormat("HH 'hours and' mm 'minutes'") //=> '20 hours and 55 minutes'
   * @return {string}
   */;
  _proto.toFormat = function toFormat(fmt, opts) {
    if (opts === void 0) {
      opts = {};
    }
    return this.isValid ? Formatter.create(this.loc.redefaultToEN(opts)).formatDateTimeFromString(this, fmt) : INVALID;
  }

  /**
   * Returns a localized string representing this date. Accepts the same options as the Intl.DateTimeFormat constructor and any presets defined by Luxon, such as `DateTime.DATE_FULL` or `DateTime.TIME_SIMPLE`.
   * The exact behavior of this method is browser-specific, but in general it will return an appropriate representation
   * of the DateTime in the assigned locale.
   * Defaults to the system's locale if no locale has been specified
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
   * @param formatOpts {Object} - Intl.DateTimeFormat constructor options and configuration options
   * @param {Object} opts - opts to override the configuration options on this DateTime
   * @example DateTime.now().toLocaleString(); //=> 4/20/2017
   * @example DateTime.now().setLocale('en-gb').toLocaleString(); //=> '20/04/2017'
   * @example DateTime.now().toLocaleString(DateTime.DATE_FULL); //=> 'April 20, 2017'
   * @example DateTime.now().toLocaleString(DateTime.DATE_FULL, { locale: 'fr' }); //=> '28 août 2022'
   * @example DateTime.now().toLocaleString(DateTime.TIME_SIMPLE); //=> '11:32 AM'
   * @example DateTime.now().toLocaleString(DateTime.DATETIME_SHORT); //=> '4/20/2017, 11:32 AM'
   * @example DateTime.now().toLocaleString({ weekday: 'long', month: 'long', day: '2-digit' }); //=> 'Thursday, April 20'
   * @example DateTime.now().toLocaleString({ weekday: 'short', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' }); //=> 'Thu, Apr 20, 11:27 AM'
   * @example DateTime.now().toLocaleString({ hour: '2-digit', minute: '2-digit', hourCycle: 'h23' }); //=> '11:32'
   * @return {string}
   */;
  _proto.toLocaleString = function toLocaleString(formatOpts, opts) {
    if (formatOpts === void 0) {
      formatOpts = DATE_SHORT;
    }
    if (opts === void 0) {
      opts = {};
    }
    return this.isValid ? Formatter.create(this.loc.clone(opts), formatOpts).formatDateTime(this) : INVALID;
  }

  /**
   * Returns an array of format "parts", meaning individual tokens along with metadata. This is allows callers to post-process individual sections of the formatted output.
   * Defaults to the system's locale if no locale has been specified
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat/formatToParts
   * @param opts {Object} - Intl.DateTimeFormat constructor options, same as `toLocaleString`.
   * @example DateTime.now().toLocaleParts(); //=> [
   *                                   //=>   { type: 'day', value: '25' },
   *                                   //=>   { type: 'literal', value: '/' },
   *                                   //=>   { type: 'month', value: '05' },
   *                                   //=>   { type: 'literal', value: '/' },
   *                                   //=>   { type: 'year', value: '1982' }
   *                                   //=> ]
   */;
  _proto.toLocaleParts = function toLocaleParts(opts) {
    if (opts === void 0) {
      opts = {};
    }
    return this.isValid ? Formatter.create(this.loc.clone(opts), opts).formatDateTimeParts(this) : [];
  }

  /**
   * Returns an ISO 8601-compliant string representation of this DateTime
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.extendedZone=false] - add the time zone format extension
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc(1983, 5, 25).toISO() //=> '1982-05-25T00:00:00.000Z'
   * @example DateTime.now().toISO() //=> '2017-04-22T20:47:05.335-04:00'
   * @example DateTime.now().toISO({ includeOffset: false }) //=> '2017-04-22T20:47:05.335'
   * @example DateTime.now().toISO({ format: 'basic' }) //=> '20170422T204705.335-0400'
   * @return {string}
   */;
  _proto.toISO = function toISO(_temp4) {
    var _ref5 = _temp4 === void 0 ? {} : _temp4,
      _ref5$format = _ref5.format,
      format = _ref5$format === void 0 ? "extended" : _ref5$format,
      _ref5$suppressSeconds = _ref5.suppressSeconds,
      suppressSeconds = _ref5$suppressSeconds === void 0 ? false : _ref5$suppressSeconds,
      _ref5$suppressMillise = _ref5.suppressMilliseconds,
      suppressMilliseconds = _ref5$suppressMillise === void 0 ? false : _ref5$suppressMillise,
      _ref5$includeOffset = _ref5.includeOffset,
      includeOffset = _ref5$includeOffset === void 0 ? true : _ref5$includeOffset,
      _ref5$extendedZone = _ref5.extendedZone,
      extendedZone = _ref5$extendedZone === void 0 ? false : _ref5$extendedZone;
    if (!this.isValid) {
      return null;
    }
    var ext = format === "extended";
    var c = _toISODate(this, ext);
    c += "T";
    c += _toISOTime(this, ext, suppressSeconds, suppressMilliseconds, includeOffset, extendedZone);
    return c;
  }

  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's date component
   * @param {Object} opts - options
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc(1982, 5, 25).toISODate() //=> '1982-05-25'
   * @example DateTime.utc(1982, 5, 25).toISODate({ format: 'basic' }) //=> '19820525'
   * @return {string}
   */;
  _proto.toISODate = function toISODate(_temp5) {
    var _ref6 = _temp5 === void 0 ? {} : _temp5,
      _ref6$format = _ref6.format,
      format = _ref6$format === void 0 ? "extended" : _ref6$format;
    if (!this.isValid) {
      return null;
    }
    return _toISODate(this, format === "extended");
  }

  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's week date
   * @example DateTime.utc(1982, 5, 25).toISOWeekDate() //=> '1982-W21-2'
   * @return {string}
   */;
  _proto.toISOWeekDate = function toISOWeekDate() {
    return toTechFormat(this, "kkkk-'W'WW-c");
  }

  /**
   * Returns an ISO 8601-compliant string representation of this DateTime's time component
   * @param {Object} opts - options
   * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
   * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.extendedZone=true] - add the time zone format extension
   * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
   * @param {string} [opts.format='extended'] - choose between the basic and extended format
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime() //=> '07:34:19.361Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34, seconds: 0, milliseconds: 0 }).toISOTime({ suppressSeconds: true }) //=> '07:34Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ format: 'basic' }) //=> '073419.361Z'
   * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ includePrefix: true }) //=> 'T07:34:19.361Z'
   * @return {string}
   */;
  _proto.toISOTime = function toISOTime(_temp6) {
    var _ref7 = _temp6 === void 0 ? {} : _temp6,
      _ref7$suppressMillise = _ref7.suppressMilliseconds,
      suppressMilliseconds = _ref7$suppressMillise === void 0 ? false : _ref7$suppressMillise,
      _ref7$suppressSeconds = _ref7.suppressSeconds,
      suppressSeconds = _ref7$suppressSeconds === void 0 ? false : _ref7$suppressSeconds,
      _ref7$includeOffset = _ref7.includeOffset,
      includeOffset = _ref7$includeOffset === void 0 ? true : _ref7$includeOffset,
      _ref7$includePrefix = _ref7.includePrefix,
      includePrefix = _ref7$includePrefix === void 0 ? false : _ref7$includePrefix,
      _ref7$extendedZone = _ref7.extendedZone,
      extendedZone = _ref7$extendedZone === void 0 ? false : _ref7$extendedZone,
      _ref7$format = _ref7.format,
      format = _ref7$format === void 0 ? "extended" : _ref7$format;
    if (!this.isValid) {
      return null;
    }
    var c = includePrefix ? "T" : "";
    return c + _toISOTime(this, format === "extended", suppressSeconds, suppressMilliseconds, includeOffset, extendedZone);
  }

  /**
   * Returns an RFC 2822-compatible string representation of this DateTime
   * @example DateTime.utc(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 +0000'
   * @example DateTime.local(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 -0400'
   * @return {string}
   */;
  _proto.toRFC2822 = function toRFC2822() {
    return toTechFormat(this, "EEE, dd LLL yyyy HH:mm:ss ZZZ", false);
  }

  /**
   * Returns a string representation of this DateTime appropriate for use in HTTP headers. The output is always expressed in GMT.
   * Specifically, the string conforms to RFC 1123.
   * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
   * @example DateTime.utc(2014, 7, 13).toHTTP() //=> 'Sun, 13 Jul 2014 00:00:00 GMT'
   * @example DateTime.utc(2014, 7, 13, 19).toHTTP() //=> 'Sun, 13 Jul 2014 19:00:00 GMT'
   * @return {string}
   */;
  _proto.toHTTP = function toHTTP() {
    return toTechFormat(this.toUTC(), "EEE, dd LLL yyyy HH:mm:ss 'GMT'");
  }

  /**
   * Returns a string representation of this DateTime appropriate for use in SQL Date
   * @example DateTime.utc(2014, 7, 13).toSQLDate() //=> '2014-07-13'
   * @return {string}
   */;
  _proto.toSQLDate = function toSQLDate() {
    if (!this.isValid) {
      return null;
    }
    return _toISODate(this, true);
  }

  /**
   * Returns a string representation of this DateTime appropriate for use in SQL Time
   * @param {Object} opts - options
   * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
   * @example DateTime.utc().toSQL() //=> '05:15:16.345'
   * @example DateTime.now().toSQL() //=> '05:15:16.345 -04:00'
   * @example DateTime.now().toSQL({ includeOffset: false }) //=> '05:15:16.345'
   * @example DateTime.now().toSQL({ includeZone: false }) //=> '05:15:16.345 America/New_York'
   * @return {string}
   */;
  _proto.toSQLTime = function toSQLTime(_temp7) {
    var _ref8 = _temp7 === void 0 ? {} : _temp7,
      _ref8$includeOffset = _ref8.includeOffset,
      includeOffset = _ref8$includeOffset === void 0 ? true : _ref8$includeOffset,
      _ref8$includeZone = _ref8.includeZone,
      includeZone = _ref8$includeZone === void 0 ? false : _ref8$includeZone,
      _ref8$includeOffsetSp = _ref8.includeOffsetSpace,
      includeOffsetSpace = _ref8$includeOffsetSp === void 0 ? true : _ref8$includeOffsetSp;
    var fmt = "HH:mm:ss.SSS";
    if (includeZone || includeOffset) {
      if (includeOffsetSpace) {
        fmt += " ";
      }
      if (includeZone) {
        fmt += "z";
      } else if (includeOffset) {
        fmt += "ZZ";
      }
    }
    return toTechFormat(this, fmt, true);
  }

  /**
   * Returns a string representation of this DateTime appropriate for use in SQL DateTime
   * @param {Object} opts - options
   * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
   * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
   * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
   * @example DateTime.utc(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 Z'
   * @example DateTime.local(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 -04:00'
   * @example DateTime.local(2014, 7, 13).toSQL({ includeOffset: false }) //=> '2014-07-13 00:00:00.000'
   * @example DateTime.local(2014, 7, 13).toSQL({ includeZone: true }) //=> '2014-07-13 00:00:00.000 America/New_York'
   * @return {string}
   */;
  _proto.toSQL = function toSQL(opts) {
    if (opts === void 0) {
      opts = {};
    }
    if (!this.isValid) {
      return null;
    }
    return this.toSQLDate() + " " + this.toSQLTime(opts);
  }

  /**
   * Returns a string representation of this DateTime appropriate for debugging
   * @return {string}
   */;
  _proto.toString = function toString() {
    return this.isValid ? this.toISO() : INVALID;
  }

  /**
   * Returns a string representation of this DateTime appropriate for the REPL.
   * @return {string}
   */;
  _proto[_Symbol$for] = function () {
    if (this.isValid) {
      return "DateTime { ts: " + this.toISO() + ", zone: " + this.zone.name + ", locale: " + this.locale + " }";
    } else {
      return "DateTime { Invalid, reason: " + this.invalidReason + " }";
    }
  }

  /**
   * Returns the epoch milliseconds of this DateTime. Alias of {@link DateTime#toMillis}
   * @return {number}
   */;
  _proto.valueOf = function valueOf() {
    return this.toMillis();
  }

  /**
   * Returns the epoch milliseconds of this DateTime.
   * @return {number}
   */;
  _proto.toMillis = function toMillis() {
    return this.isValid ? this.ts : NaN;
  }

  /**
   * Returns the epoch seconds of this DateTime.
   * @return {number}
   */;
  _proto.toSeconds = function toSeconds() {
    return this.isValid ? this.ts / 1000 : NaN;
  }

  /**
   * Returns the epoch seconds (as a whole number) of this DateTime.
   * @return {number}
   */;
  _proto.toUnixInteger = function toUnixInteger() {
    return this.isValid ? Math.floor(this.ts / 1000) : NaN;
  }

  /**
   * Returns an ISO 8601 representation of this DateTime appropriate for use in JSON.
   * @return {string}
   */;
  _proto.toJSON = function toJSON() {
    return this.toISO();
  }

  /**
   * Returns a BSON serializable equivalent to this DateTime.
   * @return {Date}
   */;
  _proto.toBSON = function toBSON() {
    return this.toJSDate();
  }

  /**
   * Returns a JavaScript object with this DateTime's year, month, day, and so on.
   * @param opts - options for generating the object
   * @param {boolean} [opts.includeConfig=false] - include configuration attributes in the output
   * @example DateTime.now().toObject() //=> { year: 2017, month: 4, day: 22, hour: 20, minute: 49, second: 42, millisecond: 268 }
   * @return {Object}
   */;
  _proto.toObject = function toObject(opts) {
    if (opts === void 0) {
      opts = {};
    }
    if (!this.isValid) return {};
    var base = _extends({}, this.c);
    if (opts.includeConfig) {
      base.outputCalendar = this.outputCalendar;
      base.numberingSystem = this.loc.numberingSystem;
      base.locale = this.loc.locale;
    }
    return base;
  }

  /**
   * Returns a JavaScript Date equivalent to this DateTime.
   * @return {Date}
   */;
  _proto.toJSDate = function toJSDate() {
    return new Date(this.isValid ? this.ts : NaN);
  }

  // COMPARE

  /**
   * Return the difference between two DateTimes as a Duration.
   * @param {DateTime} otherDateTime - the DateTime to compare this one to
   * @param {string|string[]} [unit=['milliseconds']] - the unit or array of units (such as 'hours' or 'days') to include in the duration.
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @example
   * var i1 = DateTime.fromISO('1982-05-25T09:45'),
   *     i2 = DateTime.fromISO('1983-10-14T10:30');
   * i2.diff(i1).toObject() //=> { milliseconds: 43807500000 }
   * i2.diff(i1, 'hours').toObject() //=> { hours: 12168.75 }
   * i2.diff(i1, ['months', 'days']).toObject() //=> { months: 16, days: 19.03125 }
   * i2.diff(i1, ['months', 'days', 'hours']).toObject() //=> { months: 16, days: 19, hours: 0.75 }
   * @return {Duration}
   */;
  _proto.diff = function diff(otherDateTime, unit, opts) {
    if (unit === void 0) {
      unit = "milliseconds";
    }
    if (opts === void 0) {
      opts = {};
    }
    if (!this.isValid || !otherDateTime.isValid) {
      return Duration.invalid("created by diffing an invalid DateTime");
    }
    var durOpts = _extends({
      locale: this.locale,
      numberingSystem: this.numberingSystem
    }, opts);
    var units = maybeArray(unit).map(Duration.normalizeUnit),
      otherIsLater = otherDateTime.valueOf() > this.valueOf(),
      earlier = otherIsLater ? this : otherDateTime,
      later = otherIsLater ? otherDateTime : this,
      diffed = _diff(earlier, later, units, durOpts);
    return otherIsLater ? diffed.negate() : diffed;
  }

  /**
   * Return the difference between this DateTime and right now.
   * See {@link DateTime#diff}
   * @param {string|string[]} [unit=['milliseconds']] - the unit or units units (such as 'hours' or 'days') to include in the duration
   * @param {Object} opts - options that affect the creation of the Duration
   * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
   * @return {Duration}
   */;
  _proto.diffNow = function diffNow(unit, opts) {
    if (unit === void 0) {
      unit = "milliseconds";
    }
    if (opts === void 0) {
      opts = {};
    }
    return this.diff(DateTime.now(), unit, opts);
  }

  /**
   * Return an Interval spanning between this DateTime and another DateTime
   * @param {DateTime} otherDateTime - the other end point of the Interval
   * @return {Interval}
   */;
  _proto.until = function until(otherDateTime) {
    return this.isValid ? Interval.fromDateTimes(this, otherDateTime) : this;
  }

  /**
   * Return whether this DateTime is in the same unit of time as another DateTime.
   * Higher-order units must also be identical for this function to return `true`.
   * Note that time zones are **ignored** in this comparison, which compares the **local** calendar time. Use {@link DateTime#setZone} to convert one of the dates if needed.
   * @param {DateTime} otherDateTime - the other DateTime
   * @param {string} unit - the unit of time to check sameness on
   * @param {Object} opts - options
   * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week; only the locale of this DateTime is used
   * @example DateTime.now().hasSame(otherDT, 'day'); //~> true if otherDT is in the same current calendar day
   * @return {boolean}
   */;
  _proto.hasSame = function hasSame(otherDateTime, unit, opts) {
    if (!this.isValid) return false;
    var inputMs = otherDateTime.valueOf();
    var adjustedToZone = this.setZone(otherDateTime.zone, {
      keepLocalTime: true
    });
    return adjustedToZone.startOf(unit, opts) <= inputMs && inputMs <= adjustedToZone.endOf(unit, opts);
  }

  /**
   * Equality check
   * Two DateTimes are equal if and only if they represent the same millisecond, have the same zone and location, and are both valid.
   * To compare just the millisecond values, use `+dt1 === +dt2`.
   * @param {DateTime} other - the other DateTime
   * @return {boolean}
   */;
  _proto.equals = function equals(other) {
    return this.isValid && other.isValid && this.valueOf() === other.valueOf() && this.zone.equals(other.zone) && this.loc.equals(other.loc);
  }

  /**
   * Returns a string representation of a this time relative to now, such as "in two days". Can only internationalize if your
   * platform supports Intl.RelativeTimeFormat. Rounds down by default.
   * @param {Object} options - options that affect the output
   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
   * @param {string} [options.style="long"] - the style of units, must be "long", "short", or "narrow"
   * @param {string|string[]} options.unit - use a specific unit or array of units; if omitted, or an array, the method will pick the best unit. Use an array or one of "years", "quarters", "months", "weeks", "days", "hours", "minutes", or "seconds"
   * @param {boolean} [options.round=true] - whether to round the numbers in the output.
   * @param {number} [options.padding=0] - padding in milliseconds. This allows you to round up the result if it fits inside the threshold. Don't use in combination with {round: false} because the decimal output will include the padding.
   * @param {string} options.locale - override the locale of this DateTime
   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
   * @example DateTime.now().plus({ days: 1 }).toRelative() //=> "in 1 day"
   * @example DateTime.now().setLocale("es").toRelative({ days: 1 }) //=> "dentro de 1 día"
   * @example DateTime.now().plus({ days: 1 }).toRelative({ locale: "fr" }) //=> "dans 23 heures"
   * @example DateTime.now().minus({ days: 2 }).toRelative() //=> "2 days ago"
   * @example DateTime.now().minus({ days: 2 }).toRelative({ unit: "hours" }) //=> "48 hours ago"
   * @example DateTime.now().minus({ hours: 36 }).toRelative({ round: false }) //=> "1.5 days ago"
   */;
  _proto.toRelative = function toRelative(options) {
    if (options === void 0) {
      options = {};
    }
    if (!this.isValid) return null;
    var base = options.base || DateTime.fromObject({}, {
        zone: this.zone
      }),
      padding = options.padding ? this < base ? -options.padding : options.padding : 0;
    var units = ["years", "months", "days", "hours", "minutes", "seconds"];
    var unit = options.unit;
    if (Array.isArray(options.unit)) {
      units = options.unit;
      unit = undefined;
    }
    return diffRelative(base, this.plus(padding), _extends({}, options, {
      numeric: "always",
      units: units,
      unit: unit
    }));
  }

  /**
   * Returns a string representation of this date relative to today, such as "yesterday" or "next month".
   * Only internationalizes on platforms that supports Intl.RelativeTimeFormat.
   * @param {Object} options - options that affect the output
   * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
   * @param {string} options.locale - override the locale of this DateTime
   * @param {string} options.unit - use a specific unit; if omitted, the method will pick the unit. Use one of "years", "quarters", "months", "weeks", or "days"
   * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar() //=> "tomorrow"
   * @example DateTime.now().setLocale("es").plus({ days: 1 }).toRelative() //=> ""mañana"
   * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar({ locale: "fr" }) //=> "demain"
   * @example DateTime.now().minus({ days: 2 }).toRelativeCalendar() //=> "2 days ago"
   */;
  _proto.toRelativeCalendar = function toRelativeCalendar(options) {
    if (options === void 0) {
      options = {};
    }
    if (!this.isValid) return null;
    return diffRelative(options.base || DateTime.fromObject({}, {
      zone: this.zone
    }), this, _extends({}, options, {
      numeric: "auto",
      units: ["years", "months", "days"],
      calendary: true
    }));
  }

  /**
   * Return the min of several date times
   * @param {...DateTime} dateTimes - the DateTimes from which to choose the minimum
   * @return {DateTime} the min DateTime, or undefined if called with no argument
   */;
  DateTime.min = function min() {
    for (var _len = arguments.length, dateTimes = new Array(_len), _key = 0; _key < _len; _key++) {
      dateTimes[_key] = arguments[_key];
    }
    if (!dateTimes.every(DateTime.isDateTime)) {
      throw new InvalidArgumentError("min requires all arguments be DateTimes");
    }
    return bestBy(dateTimes, function (i) {
      return i.valueOf();
    }, Math.min);
  }

  /**
   * Return the max of several date times
   * @param {...DateTime} dateTimes - the DateTimes from which to choose the maximum
   * @return {DateTime} the max DateTime, or undefined if called with no argument
   */;
  DateTime.max = function max() {
    for (var _len2 = arguments.length, dateTimes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      dateTimes[_key2] = arguments[_key2];
    }
    if (!dateTimes.every(DateTime.isDateTime)) {
      throw new InvalidArgumentError("max requires all arguments be DateTimes");
    }
    return bestBy(dateTimes, function (i) {
      return i.valueOf();
    }, Math.max);
  }

  // MISC

  /**
   * Explain how a string would be parsed by fromFormat()
   * @param {string} text - the string to parse
   * @param {string} fmt - the format the string is expected to be in (see description)
   * @param {Object} options - options taken by fromFormat()
   * @return {Object}
   */;
  DateTime.fromFormatExplain = function fromFormatExplain(text, fmt, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options,
      _options$locale = _options.locale,
      locale = _options$locale === void 0 ? null : _options$locale,
      _options$numberingSys = _options.numberingSystem,
      numberingSystem = _options$numberingSys === void 0 ? null : _options$numberingSys,
      localeToUse = Locale.fromOpts({
        locale: locale,
        numberingSystem: numberingSystem,
        defaultToEN: true
      });
    return explainFromTokens(localeToUse, text, fmt);
  }

  /**
   * @deprecated use fromFormatExplain instead
   */;
  DateTime.fromStringExplain = function fromStringExplain(text, fmt, options) {
    if (options === void 0) {
      options = {};
    }
    return DateTime.fromFormatExplain(text, fmt, options);
  }

  // FORMAT PRESETS

  /**
   * {@link DateTime#toLocaleString} format like 10/14/1983
   * @type {Object}
   */;
  _createClass(DateTime, [{
    key: "isValid",
    get: function get() {
      return this.invalid === null;
    }

    /**
     * Returns an error code if this DateTime is invalid, or null if the DateTime is valid
     * @type {string}
     */
  }, {
    key: "invalidReason",
    get: function get() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this DateTime became invalid, or null if the DateTime is valid
     * @type {string}
     */
  }, {
    key: "invalidExplanation",
    get: function get() {
      return this.invalid ? this.invalid.explanation : null;
    }

    /**
     * Get the locale of a DateTime, such 'en-GB'. The locale is used when formatting the DateTime
     *
     * @type {string}
     */
  }, {
    key: "locale",
    get: function get() {
      return this.isValid ? this.loc.locale : null;
    }

    /**
     * Get the numbering system of a DateTime, such 'beng'. The numbering system is used when formatting the DateTime
     *
     * @type {string}
     */
  }, {
    key: "numberingSystem",
    get: function get() {
      return this.isValid ? this.loc.numberingSystem : null;
    }

    /**
     * Get the output calendar of a DateTime, such 'islamic'. The output calendar is used when formatting the DateTime
     *
     * @type {string}
     */
  }, {
    key: "outputCalendar",
    get: function get() {
      return this.isValid ? this.loc.outputCalendar : null;
    }

    /**
     * Get the time zone associated with this DateTime.
     * @type {Zone}
     */
  }, {
    key: "zone",
    get: function get() {
      return this._zone;
    }

    /**
     * Get the name of the time zone.
     * @type {string}
     */
  }, {
    key: "zoneName",
    get: function get() {
      return this.isValid ? this.zone.name : null;
    }

    /**
     * Get the year
     * @example DateTime.local(2017, 5, 25).year //=> 2017
     * @type {number}
     */
  }, {
    key: "year",
    get: function get() {
      return this.isValid ? this.c.year : NaN;
    }

    /**
     * Get the quarter
     * @example DateTime.local(2017, 5, 25).quarter //=> 2
     * @type {number}
     */
  }, {
    key: "quarter",
    get: function get() {
      return this.isValid ? Math.ceil(this.c.month / 3) : NaN;
    }

    /**
     * Get the month (1-12).
     * @example DateTime.local(2017, 5, 25).month //=> 5
     * @type {number}
     */
  }, {
    key: "month",
    get: function get() {
      return this.isValid ? this.c.month : NaN;
    }

    /**
     * Get the day of the month (1-30ish).
     * @example DateTime.local(2017, 5, 25).day //=> 25
     * @type {number}
     */
  }, {
    key: "day",
    get: function get() {
      return this.isValid ? this.c.day : NaN;
    }

    /**
     * Get the hour of the day (0-23).
     * @example DateTime.local(2017, 5, 25, 9).hour //=> 9
     * @type {number}
     */
  }, {
    key: "hour",
    get: function get() {
      return this.isValid ? this.c.hour : NaN;
    }

    /**
     * Get the minute of the hour (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30).minute //=> 30
     * @type {number}
     */
  }, {
    key: "minute",
    get: function get() {
      return this.isValid ? this.c.minute : NaN;
    }

    /**
     * Get the second of the minute (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52).second //=> 52
     * @type {number}
     */
  }, {
    key: "second",
    get: function get() {
      return this.isValid ? this.c.second : NaN;
    }

    /**
     * Get the millisecond of the second (0-999).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52, 654).millisecond //=> 654
     * @type {number}
     */
  }, {
    key: "millisecond",
    get: function get() {
      return this.isValid ? this.c.millisecond : NaN;
    }

    /**
     * Get the week year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 12, 31).weekYear //=> 2015
     * @type {number}
     */
  }, {
    key: "weekYear",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekYear : NaN;
    }

    /**
     * Get the week number of the week year (1-52ish).
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2017, 5, 25).weekNumber //=> 21
     * @type {number}
     */
  }, {
    key: "weekNumber",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekNumber : NaN;
    }

    /**
     * Get the day of the week.
     * 1 is Monday and 7 is Sunday
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 11, 31).weekday //=> 4
     * @type {number}
     */
  }, {
    key: "weekday",
    get: function get() {
      return this.isValid ? possiblyCachedWeekData(this).weekday : NaN;
    }

    /**
     * Returns true if this date is on a weekend according to the locale, false otherwise
     * @returns {boolean}
     */
  }, {
    key: "isWeekend",
    get: function get() {
      return this.isValid && this.loc.getWeekendDays().includes(this.weekday);
    }

    /**
     * Get the day of the week according to the locale.
     * 1 is the first day of the week and 7 is the last day of the week.
     * If the locale assigns Sunday as the first day of the week, then a date which is a Sunday will return 1,
     * @returns {number}
     */
  }, {
    key: "localWeekday",
    get: function get() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekday : NaN;
    }

    /**
     * Get the week number of the week year according to the locale. Different locales assign week numbers differently,
     * because the week can start on different days of the week (see localWeekday) and because a different number of days
     * is required for a week to count as the first week of a year.
     * @returns {number}
     */
  }, {
    key: "localWeekNumber",
    get: function get() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekNumber : NaN;
    }

    /**
     * Get the week year according to the locale. Different locales assign week numbers (and therefor week years)
     * differently, see localWeekNumber.
     * @returns {number}
     */
  }, {
    key: "localWeekYear",
    get: function get() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekYear : NaN;
    }

    /**
     * Get the ordinal (meaning the day of the year)
     * @example DateTime.local(2017, 5, 25).ordinal //=> 145
     * @type {number|DateTime}
     */
  }, {
    key: "ordinal",
    get: function get() {
      return this.isValid ? gregorianToOrdinal(this.c).ordinal : NaN;
    }

    /**
     * Get the human readable short month name, such as 'Oct'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthShort //=> Oct
     * @type {string}
     */
  }, {
    key: "monthShort",
    get: function get() {
      return this.isValid ? Info.months("short", {
        locObj: this.loc
      })[this.month - 1] : null;
    }

    /**
     * Get the human readable long month name, such as 'October'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthLong //=> October
     * @type {string}
     */
  }, {
    key: "monthLong",
    get: function get() {
      return this.isValid ? Info.months("long", {
        locObj: this.loc
      })[this.month - 1] : null;
    }

    /**
     * Get the human readable short weekday, such as 'Mon'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayShort //=> Mon
     * @type {string}
     */
  }, {
    key: "weekdayShort",
    get: function get() {
      return this.isValid ? Info.weekdays("short", {
        locObj: this.loc
      })[this.weekday - 1] : null;
    }

    /**
     * Get the human readable long weekday, such as 'Monday'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayLong //=> Monday
     * @type {string}
     */
  }, {
    key: "weekdayLong",
    get: function get() {
      return this.isValid ? Info.weekdays("long", {
        locObj: this.loc
      })[this.weekday - 1] : null;
    }

    /**
     * Get the UTC offset of this DateTime in minutes
     * @example DateTime.now().offset //=> -240
     * @example DateTime.utc().offset //=> 0
     * @type {number}
     */
  }, {
    key: "offset",
    get: function get() {
      return this.isValid ? +this.o : NaN;
    }

    /**
     * Get the short human name for the zone's current offset, for example "EST" or "EDT".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */
  }, {
    key: "offsetNameShort",
    get: function get() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "short",
          locale: this.locale
        });
      } else {
        return null;
      }
    }

    /**
     * Get the long human name for the zone's current offset, for example "Eastern Standard Time" or "Eastern Daylight Time".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */
  }, {
    key: "offsetNameLong",
    get: function get() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "long",
          locale: this.locale
        });
      } else {
        return null;
      }
    }

    /**
     * Get whether this zone's offset ever changes, as in a DST.
     * @type {boolean}
     */
  }, {
    key: "isOffsetFixed",
    get: function get() {
      return this.isValid ? this.zone.isUniversal : null;
    }

    /**
     * Get whether the DateTime is in a DST.
     * @type {boolean}
     */
  }, {
    key: "isInDST",
    get: function get() {
      if (this.isOffsetFixed) {
        return false;
      } else {
        return this.offset > this.set({
          month: 1,
          day: 1
        }).offset || this.offset > this.set({
          month: 5
        }).offset;
      }
    }
  }, {
    key: "isInLeapYear",
    get: function get() {
      return isLeapYear(this.year);
    }

    /**
     * Returns the number of days in this DateTime's month
     * @example DateTime.local(2016, 2).daysInMonth //=> 29
     * @example DateTime.local(2016, 3).daysInMonth //=> 31
     * @type {number}
     */
  }, {
    key: "daysInMonth",
    get: function get() {
      return daysInMonth(this.year, this.month);
    }

    /**
     * Returns the number of days in this DateTime's year
     * @example DateTime.local(2016).daysInYear //=> 366
     * @example DateTime.local(2013).daysInYear //=> 365
     * @type {number}
     */
  }, {
    key: "daysInYear",
    get: function get() {
      return this.isValid ? daysInYear(this.year) : NaN;
    }

    /**
     * Returns the number of weeks in this DateTime's year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2004).weeksInWeekYear //=> 53
     * @example DateTime.local(2013).weeksInWeekYear //=> 52
     * @type {number}
     */
  }, {
    key: "weeksInWeekYear",
    get: function get() {
      return this.isValid ? weeksInWeekYear(this.weekYear) : NaN;
    }

    /**
     * Returns the number of weeks in this DateTime's local week year
     * @example DateTime.local(2020, 6, {locale: 'en-US'}).weeksInLocalWeekYear //=> 52
     * @example DateTime.local(2020, 6, {locale: 'de-DE'}).weeksInLocalWeekYear //=> 53
     * @type {number}
     */
  }, {
    key: "weeksInLocalWeekYear",
    get: function get() {
      return this.isValid ? weeksInWeekYear(this.localWeekYear, this.loc.getMinDaysInFirstWeek(), this.loc.getStartOfWeek()) : NaN;
    }
  }], [{
    key: "DATE_SHORT",
    get: function get() {
      return DATE_SHORT;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983'
     * @type {Object}
     */
  }, {
    key: "DATE_MED",
    get: function get() {
      return DATE_MED;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Fri, Oct 14, 1983'
     * @type {Object}
     */
  }, {
    key: "DATE_MED_WITH_WEEKDAY",
    get: function get() {
      return DATE_MED_WITH_WEEKDAY;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983'
     * @type {Object}
     */
  }, {
    key: "DATE_FULL",
    get: function get() {
      return DATE_FULL;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Tuesday, October 14, 1983'
     * @type {Object}
     */
  }, {
    key: "DATE_HUGE",
    get: function get() {
      return DATE_HUGE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "TIME_SIMPLE",
    get: function get() {
      return TIME_SIMPLE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "TIME_WITH_SECONDS",
    get: function get() {
      return TIME_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "TIME_WITH_SHORT_OFFSET",
    get: function get() {
      return TIME_WITH_SHORT_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "TIME_WITH_LONG_OFFSET",
    get: function get() {
      return TIME_WITH_LONG_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30', always 24-hour.
     * @type {Object}
     */
  }, {
    key: "TIME_24_SIMPLE",
    get: function get() {
      return TIME_24_SIMPLE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23', always 24-hour.
     * @type {Object}
     */
  }, {
    key: "TIME_24_WITH_SECONDS",
    get: function get() {
      return TIME_24_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 EDT', always 24-hour.
     * @type {Object}
     */
  }, {
    key: "TIME_24_WITH_SHORT_OFFSET",
    get: function get() {
      return TIME_24_WITH_SHORT_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 Eastern Daylight Time', always 24-hour.
     * @type {Object}
     */
  }, {
    key: "TIME_24_WITH_LONG_OFFSET",
    get: function get() {
      return TIME_24_WITH_LONG_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_SHORT",
    get: function get() {
      return DATETIME_SHORT;
    }

    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_SHORT_WITH_SECONDS",
    get: function get() {
      return DATETIME_SHORT_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_MED",
    get: function get() {
      return DATETIME_MED;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_MED_WITH_SECONDS",
    get: function get() {
      return DATETIME_MED_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Fri, 14 Oct 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_MED_WITH_WEEKDAY",
    get: function get() {
      return DATETIME_MED_WITH_WEEKDAY;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_FULL",
    get: function get() {
      return DATETIME_FULL;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30:33 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_FULL_WITH_SECONDS",
    get: function get() {
      return DATETIME_FULL_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_HUGE",
    get: function get() {
      return DATETIME_HUGE;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30:33 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
  }, {
    key: "DATETIME_HUGE_WITH_SECONDS",
    get: function get() {
      return DATETIME_HUGE_WITH_SECONDS;
    }
  }]);
  return DateTime;
}(Symbol.for("nodejs.util.inspect.custom"));
function friendlyDateTime(dateTimeish) {
  if (DateTime.isDateTime(dateTimeish)) {
    return dateTimeish;
  } else if (dateTimeish && dateTimeish.valueOf && isNumber(dateTimeish.valueOf())) {
    return DateTime.fromJSDate(dateTimeish);
  } else if (dateTimeish && typeof dateTimeish === "object") {
    return DateTime.fromObject(dateTimeish);
  } else {
    throw new InvalidArgumentError("Unknown datetime argument: " + dateTimeish + ", of type " + typeof dateTimeish);
  }
}

var VERSION = "3.4.4";

var DateTime_1 = luxon.DateTime = DateTime;
luxon.Duration = Duration;
luxon.FixedOffsetZone = FixedOffsetZone;
luxon.IANAZone = IANAZone;
var Info_1 = luxon.Info = Info;
luxon.Interval = Interval;
luxon.InvalidZone = InvalidZone;
luxon.Settings = Settings;
luxon.SystemZone = SystemZone;
luxon.VERSION = VERSION;
luxon.Zone = Zone;

const dateDropdownCss = "/*!@:host*/.sc-ix-date-dropdown-h{display:inline-block;position:relative}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-date-dropdown-h *.sc-ix-date-dropdown,.sc-ix-date-dropdown-h *.sc-ix-date-dropdown::after,.sc-ix-date-dropdown-h *.sc-ix-date-dropdown::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-date-dropdown-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-date-dropdown-h .sc-ix-date-dropdown::-webkit-scrollbar-corner{display:none}@media (max-width: 48em){/*!@:host .min-width*/.sc-ix-date-dropdown-h .min-width.sc-ix-date-dropdown{width:-moz-min-content;width:min-content}}@media (min-width: 48em){/*!@:host .border-right*/.sc-ix-date-dropdown-h .border-right.sc-ix-date-dropdown{border-right:var(--theme-x-weak-bdr-2)}}/*!@:host ix-button*/.sc-ix-date-dropdown-h ix-button.sc-ix-date-dropdown{width:100%}/*!@:host .max-height*/.sc-ix-date-dropdown-h .max-height.sc-ix-date-dropdown{max-height:-moz-max-content;max-height:max-content}/*!@:host .no-margin*/.sc-ix-date-dropdown-h .no-margin.sc-ix-date-dropdown{margin:0;padding:0}/*!@:host .pull-right*/.sc-ix-date-dropdown-h .pull-right.sc-ix-date-dropdown{float:right;padding:0.25rem 1rem}";
var IxDateDropdownStyle0 = dateDropdownCss;

/**
 * @since 2.1.0
 */
class DateDropdown {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.dateRangeChange = createEvent(this, "dateRangeChange", 7);
        this.datePickerTouched = false;
        this.disabled = false;
        this.format = 'yyyy/LL/dd';
        this.range = true;
        this.from = undefined;
        this.to = undefined;
        this.minDate = undefined;
        this.maxDate = undefined;
        this.dateRangeId = 'custom';
        this.customRangeAllowed = true;
        this.dateRangeOptions = [];
        this.i18nCustomItem = 'Custom...';
        this.i18nDone = 'Done';
        this.i18nNoRange = 'No range set';
        this.today = DateTime_1.now().toISO();
        this.selectedDateRangeId = undefined;
        this.currentRangeValue = undefined;
        this.triggerRef = undefined;
    }
    onDateRangeIdChange() {
        this.onRangeListSelect(this.dateRangeId);
        this.updateCurrentDate();
        this.setDateRangeSelection(this.dateRangeId);
        this.onDateSelect({
            from: this.currentRangeValue.from,
            to: this.currentRangeValue.to,
            id: this.currentRangeValue.id,
        });
    }
    onDateRangeOptionsChange() {
        this.initialize();
        this.onDateRangeIdChange();
    }
    onDisabledChange() {
        if (this.disabled) {
            this.closeDropdown();
        }
    }
    componentWillLoad() {
        this.initialize();
        this.setDateRangeSelection(this.dateRangeId);
    }
    /**
     * Retrieves the currently selected date range from the component.
     * This method returns the selected date range as a `DateChangeEvent` object.
     */
    async getDateRange() {
        return this.currentRangeValue;
    }
    initialize() {
        const isCustomRange = this.dateRangeId === 'custom' ||
            (!this.dateRangeId && !!this.from && !!this.to);
        if (isCustomRange && this.customRangeAllowed) {
            this.selectedDateRangeId = 'custom';
            this.updateCurrentDate();
            return;
        }
        const isValidConfiguration = !isCustomRange && !this.from;
        if (!isValidConfiguration) {
            console.warn('"from" and "range-date-id" is provided this is an invalid combination. Using "custom".');
            this.selectedDateRangeId = 'custom';
            this.updateCurrentDate();
            return;
        }
    }
    updateCurrentDate() {
        this.currentRangeValue = {
            id: this.selectedDateRangeId,
            from: this.from,
            to: this.to,
        };
    }
    onDateSelect(rangeValue, preserveDropdown = true) {
        this.dateRangeChange.emit(rangeValue);
        if (preserveDropdown) {
            this.closeDropdown();
        }
        this.datePickerTouched = false;
    }
    onRangeListSelect(id) {
        if (this.setDateRangeSelection(id)) {
            this.onDateSelect(this.currentRangeValue);
        }
    }
    setDateRangeSelection(id) {
        this.selectedDateRangeId = id;
        const option = this.dateRangeOptions.find((range) => range.id === id);
        if (option) {
            this.currentRangeValue = option;
        }
        return option;
    }
    closeDropdown() {
        this.hostElement.shadowRoot.querySelector('ix-dropdown').show = false;
    }
    getButtonLabel() {
        var _a, _b;
        if (this.selectedDateRangeId === 'custom' && ((_a = this.currentRangeValue) === null || _a === void 0 ? void 0 : _a.from)) {
            let range = this.currentRangeValue.from;
            if (this.currentRangeValue.to) {
                range += ` - ${this.currentRangeValue.to}`;
            }
            return range;
        }
        if (!this.selectedDateRangeId) {
            return this.i18nNoRange;
        }
        if (!this.dateRangeOptions || ((_b = this.dateRangeOptions) === null || _b === void 0 ? void 0 : _b.length) === 0) {
            return this.i18nNoRange;
        }
        const option = this.dateRangeOptions.find((option) => option.id === this.selectedDateRangeId);
        if (!option) {
            console.error(`Cannot find range option with id ${this.selectedDateRangeId}`);
            return this.i18nNoRange;
        }
        return option.label;
    }
    render() {
        var _a, _b, _c;
        return (hAsync(Host, { key: 'd66ef545b12f469b74a6693942a4fdbd7eb60382' }, hAsync("ix-button", { key: '8b6c5227aaf9d39fa6b8aa209170f10d9f4e46e8', "data-testid": "date-dropdown-trigger", "data-date-dropdown-trigger": true, variant: "primary", icon: "history", ref: (ref) => (this.triggerRef = ref), disabled: this.disabled }, this.getButtonLabel()), hAsync("ix-dropdown", { key: '909f713bc65e1371143ce50b438d5222319b794e', "data-testid": "date-dropdown", "data-date-dropdown": true, class: "min-width max-height", trigger: this.triggerRef, closeBehavior: "outside", placement: "bottom-start", onShowChanged: ({ detail: show }) => {
                if (!show &&
                    this.selectedDateRangeId === 'custom' &&
                    this.datePickerTouched) {
                    this.onDateSelect(this.currentRangeValue);
                }
            } }, hAsync("ix-layout-grid", { key: 'b8d09d4ddac4960ee2ea23ed9ec6bf5ecb59c5ae', "no-margin": "true" }, hAsync("ix-row", { key: 'fa9099679383056a268265eec7316ced4cd0085a' }, ((_a = this.dateRangeOptions) === null || _a === void 0 ? void 0 : _a.length) > 1 && (hAsync("ix-col", { key: '9107d5b1053c93d662568b0efa7bb89d60b80ed6', class: {
                'no-margin': true,
                'border-right': this.selectedDateRangeId === 'custom',
            } }, this.dateRangeOptions.map((dateRangeOption) => (hAsync("ix-dropdown-item", { label: dateRangeOption.label, onClick: () => this.onRangeListSelect(dateRangeOption.id), checked: this.selectedDateRangeId === dateRangeOption.id }))), hAsync("div", { key: '0a2993cbe4d995e4dd6345e8f1b4e32cb39997d8', hidden: !this.customRangeAllowed }, hAsync("ix-dropdown-item", { key: '7bddded3f580f85c9222e563df5ef80a6a5470ed', label: this.i18nCustomItem, checked: this.selectedDateRangeId === 'custom', onClick: () => this.onRangeListSelect('custom') })))), hAsync("ix-col", { key: 'fe530809dc0eff3d95e4305ef48d8f46ebaf2a20', class: "no-margin" }, this.selectedDateRangeId === 'custom' && (hAsync(Fragment, { key: '6fb55cd06c7467fa1277476177b8db788fc6e614' }, hAsync("ix-date-picker", { key: 'dac5bfab1baa592aaf0db6aaec80b44592c048f9', standaloneAppearance: false, onDateChange: (e) => {
                e.stopPropagation();
                this.currentRangeValue = Object.assign(Object.assign({}, e.detail), { id: 'custom' });
                this.datePickerTouched = true;
            }, onDateRangeChange: (e) => e.stopPropagation(), format: this.format, range: this.range, from: this.from || ((_b = this.currentRangeValue) === null || _b === void 0 ? void 0 : _b.from), to: this.to || ((_c = this.currentRangeValue) === null || _c === void 0 ? void 0 : _c.to), minDate: this.minDate, maxDate: this.maxDate, today: this.today }), hAsync("div", { key: '613a674664d2b55a8012fc2b869021e8dfeb10b3', class: "pull-right" }, hAsync("ix-button", { key: '9d5470cfb8ddb6e086bb821baaefb25723777337', onClick: () => {
                this.onDateSelect(this.currentRangeValue);
            } }, this.i18nDone))))))))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "dateRangeId": ["onDateRangeIdChange"],
        "to": ["onDateRangeIdChange"],
        "from": ["onDateRangeIdChange"],
        "dateRangeOptions": ["onDateRangeOptionsChange"],
        "disabled": ["onDisabledChange"]
    }; }
    static get style() { return IxDateDropdownStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-date-dropdown",
        "$members$": {
            "disabled": [4],
            "format": [1],
            "range": [4],
            "from": [1],
            "to": [1],
            "minDate": [1, "min-date"],
            "maxDate": [1, "max-date"],
            "dateRangeId": [1, "date-range-id"],
            "customRangeAllowed": [4, "custom-range-allowed"],
            "dateRangeOptions": [16],
            "i18nCustomItem": [1, "i18n-custom-item"],
            "i18nDone": [1, "i18n-done"],
            "i18nNoRange": [1, "i18n-no-range"],
            "today": [1],
            "selectedDateRangeId": [32],
            "currentRangeValue": [32],
            "triggerRef": [32],
            "getDateRange": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const defaultOptions = {
    target: 'window',
    defaultEnabled: true,
};
function createListener(event, options = {}) {
    const opts = Object.assign(Object.assign({}, defaultOptions), options);
    let callback;
    const onEvent = (event) => {
        callback(event);
    };
    const resultObject = {
        on: (onEventCallback) => {
            callback = onEventCallback;
        },
        isEnabled: opts.defaultEnabled,
        enable: (state) => {
            resultObject.isEnabled = state;
            if (state) {
                addEventListener(event, onEvent);
            }
            else {
                removeEventListener(event, onEvent);
            }
        },
        destroy: () => {
            resultObject.enable(false);
        },
    };
    resultObject.enable(opts.defaultEnabled);
    return resultObject;
}
function OnListener(event, fnExp) {
    return (proto, methodName) => {
        const { componentWillLoad, componentWillRender, disconnectedCallback } = proto;
        if (fnExp) {
            proto.componentWillRender = function () {
                var _a;
                const host = getElement(this);
                (_a = host[`__ix__${methodName}`]) === null || _a === void 0 ? void 0 : _a.enable(fnExp(this));
                return componentWillRender && componentWillRender.call(this);
            };
        }
        proto.componentWillLoad = function () {
            const listener = createListener(event);
            const host = getElement(this);
            const method = this[methodName];
            host[`__ix__${methodName}`] = listener;
            listener.on(method.bind(this));
            return componentWillLoad && componentWillLoad.call(this);
        };
        proto.disconnectedCallback = function () {
            var _a;
            const host = getElement(this);
            if (host && host[`__ix__${methodName}`]) {
                (_a = host[`__ix__${methodName}`]) === null || _a === void 0 ? void 0 : _a.destroy();
                host[`__ix__${methodName}`] = null;
            }
            return disconnectedCallback && disconnectedCallback.call(this);
        };
    };
}

const datePickerCss = "/*!@:host*/.sc-ix-date-picker-h{display:block;position:relative;width:22rem}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-date-picker-h *.sc-ix-date-picker,.sc-ix-date-picker-h *.sc-ix-date-picker::after,.sc-ix-date-picker-h *.sc-ix-date-picker::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-date-picker-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-date-picker-h .sc-ix-date-picker::-webkit-scrollbar-corner{display:none}/*!@:host .header*/.sc-ix-date-picker-h .header.sc-ix-date-picker{display:flex;align-items:center;justify-content:space-between}/*!@:host .disabled-item*/.sc-ix-date-picker-h .disabled-item.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--disabled);color:var(--theme-datepicker-day--color--disabled);cursor:default}/*!@:host .selector*/.sc-ix-date-picker-h .selector.sc-ix-date-picker{flex-basis:100%;display:flex;align-items:center;justify-content:center;padding:0.25rem 1rem}/*!@:host .selector .dropdown*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .dropdown.sc-ix-date-picker{color:var(--theme-menu-item--color);font-size:14px;line-height:20px}/*!@:host .selector .fontSize*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .fontSize.sc-ix-date-picker{font-size:16px}/*!@:host .selector .capitalize*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .capitalize.sc-ix-date-picker{text-transform:capitalize}/*!@:host .selector .month-dropdown-item*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .month-dropdown-item.sc-ix-date-picker{margin-left:4px;margin-right:4px}/*!@:host .selector .month-dropdown-item:focus-visible*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .month-dropdown-item.sc-ix-date-picker:focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .selector .arrowYear*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.sc-ix-date-picker{display:flex;position:relative;padding:0.75rem 2rem;align-items:center;cursor:pointer}/*!@:host .selector .arrowYear:hover*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.sc-ix-date-picker:hover{background-color:var(--theme-select-list-item--background--hover)}/*!@:host .selector .arrowYear.selected*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.selected.sc-ix-date-picker{background-color:var(--theme-select-list-item--background--selected)}/*!@:host .selector .arrowYear .arrowPosition*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.sc-ix-date-picker .arrowPosition.sc-ix-date-picker{position:absolute;left:calc(1rem - 6px);top:calc(50% - 6px)}/*!@:host .selector .arrowYear .checkPosition*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.sc-ix-date-picker .checkPosition.sc-ix-date-picker{position:absolute;left:calc(1rem - 6px);top:calc(50% - 8px)}/*!@:host .selector .arrowYear .monthMargin*/.sc-ix-date-picker-h .selector.sc-ix-date-picker .arrowYear.sc-ix-date-picker .monthMargin.sc-ix-date-picker{margin-left:10px}/*!@:host .wrapper*/.sc-ix-date-picker-h .wrapper.sc-ix-date-picker{display:flex}/*!@:host .wrapper .overflow*/.sc-ix-date-picker-h .wrapper.sc-ix-date-picker .overflow.sc-ix-date-picker{overflow-y:scroll;max-height:250px}/*!@:host .grid*/.sc-ix-date-picker-h .grid.sc-ix-date-picker{display:grid;grid-template-columns:repeat(8, 40px);grid-template-rows:repeat(7, 40px);align-items:center;justify-items:center;justify-content:center;color:var(--theme-datepicker-today--color)}/*!@:host .grid .calendar-item*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.sc-ix-date-picker{position:relative;display:flex;justify-content:center;align-items:center;background-color:var(--theme-datepicker-day--background);border:1px solid var(--theme-datepicker-day--background);width:40px;height:40px;cursor:pointer}/*!@:host .grid .calendar-item:focus-visible*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.sc-ix-date-picker:focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}/*!@:host .grid .calendar-item.today*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.sc-ix-date-picker{border:1px solid var(--theme-datepicker-today--border-color)}/*!@:host .grid .calendar-item.today:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--hover)}/*!@:host .grid .calendar-item.today:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--active)}/*!@:host .grid .calendar-item.today.selected*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.selected.sc-ix-date-picker{box-shadow:inset 0 0 0 1px white}/*!@:host .grid .calendar-item.today.selected:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.selected.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--selected-hover)}/*!@:host .grid .calendar-item.today.selected:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.selected.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--selected-active)}/*!@:host .grid .calendar-item.today.selected.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.selected.disabled.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--selected-disabled);border:1px solid var(--theme-datepicker-day--background--selected-disabled);color:var(--theme-datepicker-day--color--selected-disabled)}/*!@:host .grid .calendar-item.today.range*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.range.sc-ix-date-picker{background-color:var(--theme-datepicker-day--background--range);color:var(--theme-datepicker-day--color--range);border:1px solid var(--theme-datepicker-today--border-color--range);box-shadow:inset 0 0 0 1px white}/*!@:host .grid .calendar-item.today.range:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.range.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--range-hover);border:1px solid var(--theme-datepicker-today--border-color--range-hover)}/*!@:host .grid .calendar-item.today.range:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.range.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--range-active);border:1px solid var(--theme-datepicker-today--border-color--range-active)}/*!@:host .grid .calendar-item.today.range.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.range.disabled.sc-ix-date-picker{background-color:var(--theme-datepicker-day--background--range-disabled);color:var(--theme-datepicker-day--color--range-disabled);border:1px solid var(--theme-datepicker-today--border-color--range-disabled)}/*!@:host .grid .calendar-item.today.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.today.disabled.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--disabled);color:var(--theme-datepicker-day--color--disabled);cursor:default}/*!@:host .grid .calendar-item:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--hover)}/*!@:host .grid .calendar-item:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--active)}/*!@:host .grid .calendar-item.selected*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.selected.sc-ix-date-picker{background-color:var(--theme-datepicker-day--background--selected);color:var(--theme-datepicker-day--color--selected);border:1px solid var(--theme-datepicker-day--background--selected)}/*!@:host .grid .calendar-item.selected:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.selected.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--selected-hover)}/*!@:host .grid .calendar-item.selected:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.selected.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--selected-active)}/*!@:host .grid .calendar-item.selected.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.selected.disabled.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--selected-disabled);color:var(--theme-datepicker-day--color--selected-disabled)}/*!@:host .grid .calendar-item.range*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.range.sc-ix-date-picker{background-color:var(--theme-datepicker-day--background--range);color:var(--theme-datepicker-day--color--range)}/*!@:host .grid .calendar-item.range:hover*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.range.sc-ix-date-picker:hover{background-color:var(--theme-datepicker-day--background--range-hover)}/*!@:host .grid .calendar-item.range:active*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.range.sc-ix-date-picker:active{background-color:var(--theme-datepicker-day--background--range-active)}/*!@:host .grid .calendar-item.range.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.range.disabled.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--range-disabled);color:var(--theme-datepicker-day--color--range-disabled)}/*!@:host .grid .calendar-item.disabled*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.disabled.sc-ix-date-picker{pointer-events:none;background-color:var(--theme-datepicker-day--background--disabled);color:var(--theme-datepicker-day--color--disabled)}/*!@:host .grid .calendar-item.week-day*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.week-day.sc-ix-date-picker{color:var(--theme-datepicker-weekday--color);font-size:12px;line-height:20px;border:none;background:none;cursor:initial}/*!@:host .grid .calendar-item.empty-day*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.empty-day.sc-ix-date-picker{border:none;background:none;cursor:initial}/*!@:host .grid .calendar-item.week-number*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.week-number.sc-ix-date-picker{font-size:10px;line-height:14px;color:var(--theme-datepicker-weekday--color);border:none;background:none;cursor:initial}/*!@:host .grid .calendar-item:focus-visible*/.sc-ix-date-picker-h .grid.sc-ix-date-picker .calendar-item.sc-ix-date-picker:focus-visible{background-color:var(--theme-datepicker-day--background--selected);border:inset 1px solid var(--theme-datepicker-day--border-color--selected);color:var(--theme-datepicker-day--color--selected);font-size:14px;line-height:20px;letter-spacing:0}/*!@:host .button*/.sc-ix-date-picker-h .button.sc-ix-date-picker{display:flex;justify-content:flex-end}/*!@:host .hidden*/.sc-ix-date-picker-h .hidden.sc-ix-date-picker{display:none}";
var IxDatePickerStyle0 = datePickerCss;

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate$4 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
class DatePicker {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.dateChange = createEvent(this, "dateChange", 7);
        this.dateRangeChange = createEvent(this, "dateRangeChange", 7);
        this.dateSelect = createEvent(this, "dateSelect", 7);
        this.done = createEvent(this, "done", 7);
        this.DAYS_IN_WEEK = 7;
        this.format = 'yyyy/LL/dd';
        this.range = true;
        this.corners = 'rounded';
        this.from = undefined;
        this.to = undefined;
        this.minDate = undefined;
        this.maxDate = undefined;
        this.textSelectDate = undefined;
        this.i18nDone = 'Done';
        this.weekStartIndex = 0;
        this.locale = undefined;
        this.individual = true;
        this.eventDelimiter = ' - ';
        this.standaloneAppearance = true;
        this.today = DateTime_1.now().toISO();
        this.currFromDate = undefined;
        this.currToDate = undefined;
        this.selectedYear = undefined;
        this.tempYear = undefined;
        this.startYear = undefined;
        this.endYear = undefined;
        this.selectedMonth = undefined;
        this.tempMonth = undefined;
        this.dropdownButtonRef = undefined;
        this.yearContainerRef = undefined;
        this.dayNames = undefined;
        this.monthNames = undefined;
        this.firstMonthRef = undefined;
        this.focusedDay = 1;
        this.focusedDayElem = undefined;
    }
    watchFromPropHandler(newValue) {
        var _a;
        this.currFromDate = newValue
            ? DateTime_1.fromFormat(newValue, this.format)
            : undefined;
        if ((_a = this.currFromDate) === null || _a === void 0 ? void 0 : _a.isValid) {
            this.selectedYear = this.currFromDate.year;
            this.selectedMonth = this.currFromDate.month - 1;
        }
    }
    watchToPropHandler(newValue) {
        var _a;
        this.currToDate = newValue
            ? DateTime_1.fromFormat(newValue, this.format)
            : undefined;
        if ((_a = this.currToDate) === null || _a === void 0 ? void 0 : _a.isValid) {
            this.selectedYear = this.currToDate.year;
            this.selectedMonth = this.currToDate.month - 1;
        }
    }
    onLocaleChange() {
        this.setTranslations();
    }
    /**
     * Get the currently selected date-range.
     */
    async getCurrentDate() {
        var _a, _b, _c, _d;
        const _from = ((_a = this.currFromDate) === null || _a === void 0 ? void 0 : _a.isValid)
            ? (_b = this.currFromDate) === null || _b === void 0 ? void 0 : _b.toFormat(this.format)
            : undefined;
        const _to = ((_c = this.currToDate) === null || _c === void 0 ? void 0 : _c.isValid)
            ? (_d = this.currToDate) === null || _d === void 0 ? void 0 : _d.toFormat(this.format)
            : undefined;
        if (this.range) {
            return {
                from: _from,
                to: _to,
            };
        }
        return {
            from: _from,
            to: undefined,
        };
    }
    handleKeyUp(event) {
        if (!this.isDayFocus) {
            return;
        }
        let _focusedDay = this.focusedDay;
        switch (event.key) {
            case 'ArrowLeft':
                _focusedDay--;
                break;
            case 'ArrowRight':
                _focusedDay++;
                break;
            case 'ArrowUp':
                _focusedDay = _focusedDay - 7;
                break;
            case 'ArrowDown':
                _focusedDay = _focusedDay + 7;
                break;
            default:
                return;
        }
        if (_focusedDay > this.getDaysInCurrentMonth()) {
            _focusedDay = _focusedDay - this.getDaysInCurrentMonth();
            this.changeToAdjacentMonth(1);
            this.monthChangedFromFocus = true;
        }
        else if (_focusedDay < 1) {
            this.changeToAdjacentMonth(-1);
            _focusedDay = _focusedDay + this.getDaysInCurrentMonth();
            this.monthChangedFromFocus = true;
        }
        this.focusedDay = _focusedDay;
    }
    getDaysInCurrentMonth() {
        return DateTime_1.utc(this.selectedYear, this.selectedMonth + 1).daysInMonth;
    }
    getDateTimeNow() {
        return DateTime_1.fromISO(this.today);
    }
    onDayBlur() {
        this.isDayFocus = false;
    }
    onDayFocus() {
        this.isDayFocus = true;
    }
    componentWillLoad() {
        var _a, _b, _c, _d;
        this.setTranslations();
        this.currFromDate = this.from
            ? DateTime_1.fromFormat(this.from, this.format)
            : undefined;
        this.currToDate = this.to
            ? DateTime_1.fromFormat(this.to, this.format)
            : undefined;
        const year = (_b = (_a = this.currFromDate) === null || _a === void 0 ? void 0 : _a.year) !== null && _b !== void 0 ? _b : this.getDateTimeNow().year;
        this.startYear = year - 5;
        this.endYear = year + 5;
        this.selectedMonth =
            ((_d = (_c = this.currFromDate) === null || _c === void 0 ? void 0 : _c.month) !== null && _d !== void 0 ? _d : this.getDateTimeNow().month) - 1;
        this.selectedYear = year;
        this.tempMonth = this.selectedMonth;
        this.tempYear = this.selectedYear;
    }
    componentWillRender() {
        this.calculateCalendar();
    }
    componentDidRender() {
        if (!this.monthChangedFromFocus && !this.isDayFocus) {
            return;
        }
        const dayElem = this.hostElement.shadowRoot.querySelector(`[id=day-cell-${this.focusedDay}]`);
        dayElem.focus();
    }
    setTranslations() {
        this.dayNames = this.rotateWeekDayNames(Info_1.weekdays('long', {
            locale: this.locale,
        }), this.weekStartIndex);
        this.monthNames = Info_1.months('long', {
            locale: this.locale,
        });
    }
    /**
     * Rotate the WeekdayNames array.
     * Based on the position that should be the new 0-index.
     */
    rotateWeekDayNames(weekdays, index) {
        const clone = [...weekdays];
        if (index === 0) {
            return clone;
        }
        index = -index;
        const len = weekdays.length;
        clone.push(...clone.splice(0, ((-index % len) + len) % len));
        return clone;
    }
    async onDone() {
        const date = await this.getCurrentDate();
        this.dateSelect.emit(date);
    }
    calculateCalendar() {
        const calendar = [];
        const month = DateTime_1.utc(this.selectedYear, this.selectedMonth + 1);
        const monthStart = month.startOf('month');
        const monthEnd = month.endOf('month');
        let startWeek = monthStart.weekNumber;
        let endWeek = monthEnd.weekNumber;
        let monthStartWeekDayIndex = monthStart.weekday - 1;
        let monthEndWeekDayIndex = monthEnd.weekday - 1;
        if (this.weekStartIndex !== 0) {
            // Find the positions where to start/stop counting the day-numbers based on which day the week starts
            const weekdays = Info_1.weekdays();
            const monthStartWeekDayName = weekdays[monthStart.weekday];
            monthStartWeekDayIndex = this.dayNames.findIndex((d) => d === monthStartWeekDayName);
            const monthEndWeekDayName = weekdays[monthEnd.weekday];
            monthEndWeekDayIndex = this.dayNames.findIndex((d) => d === monthEndWeekDayName);
        }
        let correctLastWeek = false;
        if (endWeek === 1) {
            endWeek = monthEnd.weeksInWeekYear + 1;
            correctLastWeek = true;
        }
        let correctFirstWeek = false;
        if (startWeek === monthStart.weeksInWeekYear) {
            startWeek = 1;
            endWeek++;
            correctFirstWeek = true;
        }
        let currDayNumber = 1;
        for (let weekIndex = startWeek; weekIndex <= endWeek && currDayNumber <= 31; weekIndex++) {
            const daysArr = [];
            for (let j = 0; j < this.DAYS_IN_WEEK && currDayNumber <= 31; j++) {
                // Display empty cells until the calender starts/has ended
                if ((weekIndex === startWeek && j < monthStartWeekDayIndex) ||
                    (weekIndex === endWeek && j > monthEndWeekDayIndex)) {
                    daysArr.push(undefined);
                }
                else {
                    daysArr.push(currDayNumber++);
                }
            }
            if (correctFirstWeek || correctLastWeek) {
                if (weekIndex === 1) {
                    calendar.push({
                        weekNumber: monthStart.weeksInWeekYear,
                        dayNumbers: daysArr,
                    });
                }
                else if (weekIndex === monthEnd.weekNumber) {
                    calendar.push({
                        weekNumber: 1,
                        dayNumbers: daysArr,
                    });
                }
                else {
                    calendar.push({
                        weekNumber: weekIndex - 1,
                        dayNumbers: daysArr,
                    });
                }
                continue;
            }
            calendar.push({
                weekNumber: weekIndex,
                dayNumbers: daysArr,
            });
        }
        this.calendar = calendar;
    }
    selectTempYear(event, year) {
        event === null || event === void 0 ? void 0 : event.stopPropagation();
        this.tempYear = year;
    }
    focusMonth() {
        this.firstMonthRef.focus();
    }
    infiniteScrollYears() {
        const scroll = this.yearContainerRef.scrollTop;
        const maxScroll = this.yearContainerRef.scrollHeight;
        const atTop = scroll === 0;
        const atBottom = Math.round(scroll + this.yearContainerRef.offsetHeight) >= maxScroll;
        const limit = 200;
        if (this.endYear - this.startYear > limit)
            return;
        if (atTop) {
            const first = this.yearContainerRef.firstElementChild;
            this.startYear -= 5;
            this.yearContainerRef.scrollTo(0, first.offsetTop);
            return;
        }
        if (atBottom) {
            const last = this.yearContainerRef.lastElementChild;
            this.endYear += 5;
            this.yearContainerRef.scrollTo(0, last.offsetTop);
        }
    }
    selectMonth(month) {
        this.selectedMonth = month;
        this.selectedYear = this.tempYear;
        this.tempMonth = month;
        this.hostElement.shadowRoot.querySelector('ix-dropdown').show = false;
    }
    changeToAdjacentMonth(number) {
        if (this.selectedMonth + number < 0) {
            this.selectedYear--;
            this.selectedMonth = 11;
        }
        else if (this.selectedMonth + number > 11) {
            this.selectedYear++;
            this.selectedMonth = 0;
        }
        else {
            this.selectedMonth += number;
        }
    }
    selectDay(selectedDay) {
        const date = DateTime_1.fromJSDate(new Date(this.selectedYear, this.selectedMonth, selectedDay));
        if (!this.range || this.currFromDate === undefined) {
            this.currFromDate = date;
            this.onDateChange();
            return;
        }
        // Reset the range selection
        if (this.currToDate !== undefined) {
            this.currFromDate = date;
            this.currToDate = undefined;
            this.onDateChange();
            return;
        }
        // Swap from/to if the second date is before the current date
        if (date < this.currFromDate) {
            this.currToDate = this.currFromDate;
            this.currFromDate = date;
            this.onDateChange();
            return;
        }
        // Set the range normally
        this.currToDate = date;
        this.onDateChange();
    }
    onDateChange() {
        this.getCurrentDate().then((date) => {
            this.dateChange.emit(date);
            if (this.range) {
                this.dateRangeChange.emit(date);
            }
        });
    }
    getDayClasses(day) {
        var _a, _b, _c, _d;
        if (!day) {
            return;
        }
        const todayObj = this.getDateTimeNow();
        const selectedDayObj = DateTime_1.fromJSDate(new Date(this.selectedYear, this.selectedMonth, day));
        return {
            'calendar-item': true,
            'empty-day': day === undefined,
            today: todayObj.hasSame(selectedDayObj, 'day'),
            selected: ((_a = this.currFromDate) === null || _a === void 0 ? void 0 : _a.hasSame(selectedDayObj, 'day')) ||
                ((_b = this.currToDate) === null || _b === void 0 ? void 0 : _b.hasSame(selectedDayObj, 'day')),
            range: selectedDayObj.startOf('day') > ((_c = this.currFromDate) === null || _c === void 0 ? void 0 : _c.startOf('day')) &&
                this.currToDate !== undefined &&
                selectedDayObj.startOf('day') < ((_d = this.currToDate) === null || _d === void 0 ? void 0 : _d.startOf('day')),
            disabled: !this.isWithinMinMaxDate(selectedDayObj),
        };
    }
    isWithinMinMaxYear(year) {
        const minDateYear = this.minDate
            ? DateTime_1.fromFormat(this.minDate, this.format).year
            : undefined;
        const maxDateYear = this.maxDate
            ? DateTime_1.fromFormat(this.maxDate, this.format).year
            : undefined;
        const isBefore = minDateYear ? year < minDateYear : false;
        const isAfter = maxDateYear ? year > maxDateYear : false;
        return !isBefore && !isAfter;
    }
    isWithinMinMaxMonth(month) {
        const minDateObj = this.minDate
            ? DateTime_1.fromFormat(this.minDate, this.format)
            : undefined;
        const maxDateObj = this.maxDate
            ? DateTime_1.fromFormat(this.maxDate, this.format)
            : undefined;
        const minDateMonth = minDateObj === null || minDateObj === void 0 ? void 0 : minDateObj.month;
        const maxDateMonth = maxDateObj === null || maxDateObj === void 0 ? void 0 : maxDateObj.month;
        const isBefore = minDateMonth
            ? this.tempYear === minDateObj.year && month < minDateMonth
            : false;
        const isAfter = maxDateMonth
            ? this.tempYear === maxDateObj.year && month > maxDateMonth
            : false;
        return !isBefore && !isAfter;
    }
    isWithinMinMaxDate(date) {
        const _minDate = this.minDate
            ? DateTime_1.fromFormat(this.minDate, this.format)
            : undefined;
        const _maxDate = this.maxDate
            ? DateTime_1.fromFormat(this.maxDate, this.format)
            : undefined;
        const isBefore = _minDate
            ? date.startOf('day') < _minDate.startOf('day')
            : false;
        const isAfter = _maxDate
            ? date.startOf('day') > _maxDate.startOf('day')
            : false;
        return !isBefore && !isAfter;
    }
    renderYears() {
        const rows = [];
        for (let year = this.startYear; year <= this.endYear; year++) {
            rows.push(hAsync("div", { key: year, class: {
                    arrowYear: true,
                    'month-dropdown-item': true,
                    'disabled-item': !this.isWithinMinMaxYear(year),
                }, onClick: (event) => this.selectTempYear(event, year), onKeyUp: (event) => {
                    if (event.key === 'Enter') {
                        this.selectTempYear(null, year);
                        this.focusMonth();
                    }
                }, tabIndex: 0 }, hAsync("ix-icon", { class: {
                    hidden: this.tempYear !== year,
                    arrowPosition: true,
                }, name: "chevron-right", size: "12" }), hAsync("div", { style: { 'min-width': 'max-content' } }, `${year}`)));
        }
        return rows;
    }
    render() {
        return (hAsync(Host, { key: '559881c8673da97e842398f4bcfe67ef5ff27794' }, hAsync("ix-date-time-card", { key: '4550d5f5a242be0ff07110cc400ef12795475c5c', corners: this.corners, standaloneAppearance: this.standaloneAppearance }, hAsync("div", { key: 'f10ccab02142ae7461ac4b4ba4e8a8eb57123438', class: "header", slot: "header" }, hAsync("ix-icon-button", { key: '52b171c5e04a5bbcb0832f0e6033947735521601', onClick: () => this.changeToAdjacentMonth(-1), ghost: true, icon: "chevron-left", variant: "primary", class: "arrows" }), hAsync("div", { key: 'c48d51b3f22c9862c8006520530559ed44d16372', class: "selector" }, hAsync("ix-button", { key: '8c155fcbafb7c3f32dab3c9ebc912153813ce207', ghost: true, ref: (ref) => (this.dropdownButtonRef = ref), "data-testid": "year-month-button" }, hAsync("span", { key: '74c9634e13886d26238b4ee2262314914b1e8cf8', class: "fontSize capitalize" }, this.monthNames[this.selectedMonth], " ", this.selectedYear)), hAsync("ix-dropdown", { key: 'ba249019d78a59e65f3a479a3ea8315b5990bcac', "data-testid": "year-month-dropdown", class: "dropdown", trigger: this.dropdownButtonRef, ignoreRelatedSubmenu: true, placement: "bottom-start" }, hAsync("div", { key: '39365087bbb4c4dd4e0329828f61a90a1247b744', class: "wrapper" }, hAsync("div", { key: '017d16a032a473b0e791c8dc342b5e62481212e3', "data-testid": "year-container", class: "overflow", onScroll: () => this.infiniteScrollYears(), ref: (ref) => (this.yearContainerRef = ref) }, this.renderYears()), hAsync("div", { key: '1bef58292da8545924f53fdbeddbc864936a56ef', class: "overflow", "data-testid": "month-container" }, this.monthNames.map((month, index) => (hAsync("div", { key: month, ref: (ref) => {
                if (month === this.monthNames[0]) {
                    this.firstMonthRef = ref;
                }
            }, class: {
                arrowYear: true,
                'month-dropdown-item': true,
                selected: this.tempYear === this.selectedYear &&
                    this.tempMonth === index,
                'disabled-item': !this.isWithinMinMaxMonth(index),
            }, onClick: () => this.selectMonth(index), onKeyUp: (event) => event.key === 'Enter' && this.selectMonth(index), tabIndex: 0 }, hAsync("ix-icon", { class: {
                hidden: this.tempYear !== this.selectedYear ||
                    this.tempMonth !== index,
                checkPosition: true,
            }, name: "single-check", size: "16" }), hAsync("div", null, hAsync("span", { class: "capitalize monthMargin" }, `${month} ${this.tempYear}`))))))))), hAsync("ix-icon-button", { key: 'f414faea937a05dd2690e82d01daf1f444fbce25', onClick: () => this.changeToAdjacentMonth(1), ghost: true, icon: "chevron-right", variant: "primary", class: "arrows" })), hAsync("div", { key: 'b79a961fbfc8c8dd821a83ab172dd7146acc5ade', class: "grid" }, hAsync("div", { key: '7651643c6320b8598b52ffaa45dc70498854d1ad', class: "calendar-item week-day" }), this.dayNames.map((name) => (hAsync("div", { key: name, class: "calendar-item week-day" }, name.slice(0, 3)))), this.calendar.map((week) => {
            return (hAsync(Fragment, null, hAsync("div", { class: "calendar-item week-number" }, week.weekNumber), week.dayNumbers.map((day) => (hAsync("div", { key: day, id: `day-cell-${day}`, "date-calender-day": true, class: this.getDayClasses(day), onClick: () => this.selectDay(day), onKeyUp: (e) => e.key === 'Enter' && this.selectDay(day), tabIndex: day === this.focusedDay ? 0 : -1, onFocus: () => this.onDayFocus(), onBlur: () => this.onDayBlur() }, day)))));
        })), hAsync("div", { key: '0e6b9845bfdb760777cbd0f2f8419aeb5b667799', class: {
                button: true,
                hidden: !this.range || !this.standaloneAppearance,
            } }, hAsync("ix-button", { key: 'bb02236b3e41f3168aa2d5aad2c8e4aa9af90a49', onClick: () => this.onDone() }, this.textSelectDate || this.i18nDone)))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "from": ["watchFromPropHandler"],
        "to": ["watchToPropHandler"],
        "locale": ["onLocaleChange"]
    }; }
    static get style() { return IxDatePickerStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-date-picker",
        "$members$": {
            "format": [1],
            "range": [4],
            "corners": [1],
            "from": [1],
            "to": [1],
            "minDate": [1, "min-date"],
            "maxDate": [1, "max-date"],
            "textSelectDate": [1, "text-select-date"],
            "i18nDone": [1, "i18n-done"],
            "weekStartIndex": [2, "week-start-index"],
            "locale": [1],
            "individual": [4],
            "eventDelimiter": [1, "event-delimiter"],
            "standaloneAppearance": [4, "standalone-appearance"],
            "today": [1],
            "currFromDate": [32],
            "currToDate": [32],
            "selectedYear": [32],
            "tempYear": [32],
            "startYear": [32],
            "endYear": [32],
            "selectedMonth": [32],
            "tempMonth": [32],
            "dropdownButtonRef": [32],
            "yearContainerRef": [32],
            "dayNames": [32],
            "monthNames": [32],
            "firstMonthRef": [32],
            "focusedDay": [32],
            "focusedDayElem": [32],
            "getCurrentDate": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}
__decorate$4([
    OnListener('keydown')
], DatePicker.prototype, "handleKeyUp", null);

const dateTimeCardCss = "/*!@:host*//*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-date-time-card-h *.sc-ix-date-time-card,.sc-ix-date-time-card-h *.sc-ix-date-time-card::after,.sc-ix-date-time-card-h *.sc-ix-date-time-card::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-date-time-card-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-date-time-card-h .sc-ix-date-time-card::-webkit-scrollbar-corner{display:none}/*!@:host .card*/.sc-ix-date-time-card-h .card.sc-ix-date-time-card{background-color:var(--theme-menu--background);width:100%;box-shadow:none;border:none;border-radius:unset;display:flex;flex-direction:column}/*!@:host .card.standaloneAppearance*/.sc-ix-date-time-card-h .card.standaloneAppearance.sc-ix-date-time-card{box-shadow:0 0 2px 0 rgba(0, 0, 0, 0.1), 0 4px 8px 0 rgba(0, 0, 0, 0.1), 0 12px 18px 0 rgba(0, 0, 0, 0.1);border-radius:4px}/*!@:host .card.rounded*/.sc-ix-date-time-card-h .card.rounded.sc-ix-date-time-card{border-radius:4px}/*!@:host .card.left*/.sc-ix-date-time-card-h .card.left.sc-ix-date-time-card{border-radius:4px 0 0 4px;height:100%}/*!@:host .card.right*/.sc-ix-date-time-card-h .card.right.sc-ix-date-time-card{border-radius:0 4px 4px 0;height:100%}/*!@:host .card .header*/.sc-ix-date-time-card-h .card.sc-ix-date-time-card .header.sc-ix-date-time-card{padding:1rem;flex:0 1 auto}/*!@:host .card .separator*/.sc-ix-date-time-card-h .card.sc-ix-date-time-card .separator.sc-ix-date-time-card{border:1px solid var(--theme-datepicker-separator--background);width:100%;flex:0 1 auto}/*!@:host .card .content*/.sc-ix-date-time-card-h .card.sc-ix-date-time-card .content.sc-ix-date-time-card{padding:0 0.75rem 0.75rem 0.75rem;flex:1 1 auto;display:flex;flex-direction:column;justify-content:center}";
var IxDateTimeCardStyle0 = dateTimeCardCss;

/**
 * @internal
 */
class DateTimeCard {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.standaloneAppearance = undefined;
        this.individual = true;
        this.corners = 'rounded';
    }
    cardClasses() {
        return {
            card: true,
            standaloneAppearance: this.standaloneAppearance !== undefined
                ? this.standaloneAppearance
                : this.individual,
            rounded: this.corners === 'rounded',
            left: this.corners === 'left',
            right: this.corners === 'right',
        };
    }
    render() {
        return (hAsync(Host, { key: 'b699133fd52ef092307f90f515aa7046a99cd21f' }, hAsync("div", { key: '938a7c031dae445fee084ea8c1390627b1743bfb', class: this.cardClasses() }, hAsync("div", { key: '1d20df2d528d8219a7fcea504f63da8a07a4fe74', class: "header" }, hAsync("slot", { key: '0dadc7cb6813210aa9de4299f86a2e1b8ed01764', name: "header" })), hAsync("div", { key: '79a1560d676b4d7583edf9c2fc14be75d4a35514', class: "separator" }), hAsync("div", { key: 'e0f633c51c1167383fc9f75d153cfb20ee77bc39', class: "content" }, hAsync("slot", { key: 'eb8a5596284dd1a461d7f83abe3ec94ac0ebe76c' })))));
    }
    static get style() { return IxDateTimeCardStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-date-time-card",
        "$members$": {
            "standaloneAppearance": [8, "standalone-appearance"],
            "individual": [4],
            "corners": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const datetimePickerCss = "/*!@:host*/.sc-ix-datetime-picker-h{display:block;background-color:var(--theme-menu--background);border-radius:4px;position:relative;width:-moz-min-content;width:min-content}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-datetime-picker-h *.sc-ix-datetime-picker,.sc-ix-datetime-picker-h *.sc-ix-datetime-picker::after,.sc-ix-datetime-picker-h *.sc-ix-datetime-picker::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-datetime-picker-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-datetime-picker-h .sc-ix-datetime-picker::-webkit-scrollbar-corner{display:none}/*!@:host .min-width*/.sc-ix-datetime-picker-h .min-width.sc-ix-datetime-picker{width:-moz-min-content;width:min-content}/*!@:host .no-padding*/.sc-ix-datetime-picker-h .no-padding.sc-ix-datetime-picker{padding:0}/*!@:host .flex*/.sc-ix-datetime-picker-h .flex.sc-ix-datetime-picker{display:flex;justify-content:center;flex-direction:column}@media (min-width: 576px){/*!@:host*/.sc-ix-datetime-picker-h{min-width:-moz-max-content;min-width:max-content}/*!@:host .btn-select-date*/.sc-ix-datetime-picker-h .btn-select-date.sc-ix-datetime-picker{left:unset !important}}/*!@:host .individual*/.sc-ix-datetime-picker-h .individual.sc-ix-datetime-picker{box-shadow:none;border:none}/*!@:host .btn-select-date*/.sc-ix-datetime-picker-h .btn-select-date.sc-ix-datetime-picker{position:absolute;bottom:1rem;right:1rem;left:1rem}";
var IxDatetimePickerStyle0 = datetimePickerCss;

class DatetimePicker {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.done = createEvent(this, "done", 7);
        this.timeChange = createEvent(this, "timeChange", 7);
        this.dateChange = createEvent(this, "dateChange", 7);
        this.dateSelect = createEvent(this, "dateSelect", 7);
        this.range = true;
        this.showHour = true;
        this.showMinutes = true;
        this.showSeconds = true;
        this.minDate = undefined;
        this.maxDate = undefined;
        this.dateFormat = 'yyyy/LL/dd';
        this.timeFormat = 'HH:mm:ss';
        this.from = undefined;
        this.to = undefined;
        this.time = undefined;
        this.showTimeReference = undefined;
        this.timeReference = undefined;
        this.textSelectDate = undefined;
        this.i18nDone = 'Done';
        this.weekStartIndex = 0;
        this.locale = undefined;
        this.eventDelimiter = ' - ';
    }
    async onDone() {
        var _a;
        const date = await this.datePickerElement.getCurrentDate();
        const time = await this.timePickerElement.getCurrentTime();
        this.dateSelect.emit({
            from: date.from,
            to: date.to,
            time: time,
        });
        this.done.emit([date.from, (_a = date.to) !== null && _a !== void 0 ? _a : '', time].join(this.eventDelimiter));
    }
    async onDateChange(event) {
        event.preventDefault();
        event.stopPropagation();
        const { detail: date } = event;
        this.dateChange.emit(date);
    }
    async onTimeChange(event) {
        event.preventDefault();
        event.stopPropagation();
        const { detail: time } = event;
        this.timeChange.emit(time);
    }
    render() {
        return (hAsync(Host, { key: '245fa3202c8983bc8eff53d4078c2a6a8daa0810' }, hAsync("ix-layout-grid", { key: '1bc34611a653f3dea08ee0be6a336766da38b914', class: "no-padding" }, hAsync("ix-row", { key: '26eef283266f46fb5a19fcaf1d78f985119cec3a' }, hAsync("ix-col", { key: 'd4ac83db8977067d5c178fb48eac1acc1adca898', class: "no-padding" }, hAsync("ix-date-picker", { key: '967af43189787bc677ff273de023b43d9e3b0019', ref: (ref) => (this.datePickerElement = ref), corners: "left", range: this.range, onDateChange: (event) => this.onDateChange(event), from: this.from, to: this.to, format: this.dateFormat, minDate: this.minDate, maxDate: this.maxDate, weekStartIndex: this.weekStartIndex, standaloneAppearance: false, locale: this.locale })), hAsync("ix-col", { key: '53bbc9d021687f71f211b6d4091e421b7374ae56', class: "no-padding" }, hAsync("ix-time-picker", { key: 'da5a855b94d37b1424de7f10804e707e9d082139', class: "min-width", ref: (ref) => (this.timePickerElement = ref), corners: "right", standaloneAppearance: false, showHour: this.showHour, showMinutes: this.showMinutes, showSeconds: this.showSeconds, onTimeChange: (event) => this.onTimeChange(event), format: this.timeFormat, time: this.time }))), hAsync("ix-row", { key: 'aa564cb9741fda50e046a508cb9e2ad985ed11d7' }, hAsync("ix-col", { key: 'a13d931565a1165e262070e6e3d637fce6da38c6' }, hAsync("ix-button", { key: '6769327a6e405d2b2705c3a64b4b2031e8f80de4', class: "btn-select-date btn-md-width", onClick: () => this.onDone() }, this.textSelectDate || this.i18nDone))))));
    }
    static get style() { return IxDatetimePickerStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-datetime-picker",
        "$members$": {
            "range": [4],
            "showHour": [4, "show-hour"],
            "showMinutes": [4, "show-minutes"],
            "showSeconds": [4, "show-seconds"],
            "minDate": [1, "min-date"],
            "maxDate": [1, "max-date"],
            "dateFormat": [1, "date-format"],
            "timeFormat": [1, "time-format"],
            "from": [1],
            "to": [1],
            "time": [1],
            "showTimeReference": [8, "show-time-reference"],
            "timeReference": [1, "time-reference"],
            "textSelectDate": [1, "text-select-date"],
            "i18nDone": [1, "i18n-done"],
            "weekStartIndex": [2, "week-start-index"],
            "locale": [1],
            "eventDelimiter": [1, "event-delimiter"]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const dividerCss = "/*!@:host*/.sc-ix-divider-h{display:block;position:relative;width:100%;border-bottom:0.0625rem solid var(--theme-color-x-weak-bdr);margin:0.25rem 0px}";
var IxDividerStyle0 = dividerCss;

/**
 * @since 1.4.0
 */
class Divider {
    constructor(hostRef) {
        registerInstance(this, hostRef);
    }
    render() {
        return hAsync(Host, { key: 'c86675e3fc86e702df2e59447d57bfcd6a5f80ba' });
    }
    static get style() { return IxDividerStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-divider",
        "$members$": undefined,
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const drawerCss = "/*!@:host*/.sc-ix-drawer-h{top:0;right:0;box-shadow:var(--theme-box-shadow-level-3);visibility:hidden;display:flex;position:absolute;flex-flow:column nowrap;justify-content:flex-start;align-items:center;max-height:100vh;min-height:1.5rem;background-color:var(--theme-color-1);border-radius:0.25rem;transition:all var(--theme-medium-time) ease-out}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-drawer-h *.sc-ix-drawer,.sc-ix-drawer-h *.sc-ix-drawer::after,.sc-ix-drawer-h *.sc-ix-drawer::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-drawer-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-drawer-h .sc-ix-drawer::-webkit-scrollbar-corner{display:none}/*!@:host .toggle*/.sc-ix-drawer-h .toggle.sc-ix-drawer{z-index:100;visibility:visible}/*!@:host .drawer-container.full-height*/.sc-ix-drawer-h .drawer-container.full-height.sc-ix-drawer{min-height:100%}/*!@:host .header*/.sc-ix-drawer-h .header.sc-ix-drawer{display:flex;position:relative;align-items:center;justify-content:flex-end;padding:0.5rem;width:100%;order:1}/*!@:host .header .header-content*/.sc-ix-drawer-h .header.sc-ix-drawer .header-content.sc-ix-drawer{flex-grow:1;margin-right:1rem}/*!@:host .content*/.sc-ix-drawer-h .content.sc-ix-drawer{position:relative;flex:1;flex-grow:1;order:2;height:100%;width:100%;overflow-y:auto}/*!@:host(.toggle)*/.toggle.sc-ix-drawer-h{visibility:visible}";
var IxDrawerStyle0 = drawerCss;

class Drawer {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.open = createEvent(this, "open", 7);
        this.drawerClose = createEvent(this, "drawerClose", 7);
        this.callback = this.clickedOutside.bind(this);
        this.show = false;
        this.closeOnClickOutside = true;
        this.fullHeight = false;
        this.minWidth = 16;
        this.maxWidth = 28;
        this.width = this.minWidth;
    }
    onShowChanged(newValue) {
        this.show = newValue !== undefined ? newValue : !this.show;
        this.toggleDrawer(this.show);
    }
    /**
     * Toggle or define show state of drawer
     * @param show Overwrite toggle state with boolean
     */
    async toggleDrawer(show) {
        this.show = show !== undefined ? show : !this.show;
        if (show) {
            this.open.emit();
            this.slideInRight(this.divElement);
            setTimeout(() => {
                window.addEventListener('mousedown', this.callback);
            }, 300);
        }
        else {
            this.drawerClose.emit();
            this.slideOutRight(this.divElement);
            window.removeEventListener('mousedown', this.callback);
        }
        return Promise.resolve();
    }
    onCloseClicked() {
        this.show = false;
    }
    clickedOutside(evt) {
        if (!this.closeOnClickOutside) {
            return;
        }
        const target = evt.target;
        const closestElement = target.closest('#div-container');
        const btn = target.closest('#drawer-btn');
        if (evt.target.type !== 'button' &&
            closestElement !== this.divElement &&
            target !== btn) {
            this.show = false;
        }
    }
    slideOutRight(el) {
        anime({
            targets: el,
            duration: Drawer.duration,
            translateX: [0, '16rem'],
            opacity: [1, 0],
            easing: 'easeInSine',
            complete: () => {
                el.classList.add('d-none');
            },
        });
    }
    slideInRight(el) {
        anime({
            targets: el,
            duration: Drawer.duration,
            translateX: ['16rem', 0],
            opacity: [0, 1],
            easing: 'easeOutSine',
            begin: () => {
                el.classList.remove('d-none');
            },
        });
    }
    componentDidLoad() {
        this.onShowChanged(this.show);
    }
    render() {
        return (hAsync(Host, { key: '2a08d35b883881d7ce4fac52754f5ba6a6d87b67', class: {
                'drawer-container': true,
                toggle: this.show,
                'full-height': this.fullHeight,
                'd-none': true,
            }, style: {
                width: this.width === 'auto' ? this.width : `${this.width}rem`,
                'min-width': `${this.minWidth}rem`,
                'max-width': `${this.maxWidth}rem`,
            }, ref: (el) => (this.divElement = el), "data-testid": "container", id: "div-container" }, hAsync("div", { key: '516fb16c8d2a99d29e158193b6e69f62e6805d7a', class: "header" }, hAsync("div", { key: '24f3e13377044cc7b72fa3b0e01163afbf2b8bbd', class: "header-content" }, hAsync("slot", { key: 'a0b4aeb829de7152941816142193ca23f15475f4', name: "header" })), hAsync("ix-icon-button", { key: '3781d1a2bad00dd5c43b7514de103bfe9662e929', class: "close-button", icon: 'close', size: "24", ghost: true, onClick: () => this.onCloseClicked(), "data-testid": "close-button" })), hAsync("div", { key: '9e19c76af291d53298aad23a7e113ec76b84f5a5', class: "content" }, hAsync("slot", { key: '3b12eafb18a7fd75614a40c3f1e611e1556f4acd' }))));
    }
    static get watchers() { return {
        "show": ["onShowChanged"]
    }; }
    static get style() { return IxDrawerStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-drawer",
        "$members$": {
            "show": [1028],
            "closeOnClickOutside": [4, "close-on-click-outside"],
            "fullHeight": [4, "full-height"],
            "minWidth": [2, "min-width"],
            "maxWidth": [2, "max-width"],
            "width": [8],
            "toggleDrawer": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}
Drawer.duration = 300;

/**
 * Custom positioning reference element.
 * @see https://floating-ui.com/docs/virtual-elements
 */

const sides = ['top', 'right', 'bottom', 'left'];
const alignments = ['start', 'end'];
const placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
const min = Math.min;
const max = Math.max;
const round = Math.round;
const floor = Math.floor;
const createCoords = v => ({
  x: v,
  y: v
});
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function clamp(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getOppositeAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}
function getAxisLength(axis) {
  return axis === 'y' ? 'height' : 'width';
}
function getSideAxis(placement) {
  return ['top', 'bottom'].includes(getSide(placement)) ? 'y' : 'x';
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
function getSideList(side, isStart, rtl) {
  const lr = ['left', 'right'];
  const rl = ['right', 'left'];
  const tb = ['top', 'bottom'];
  const bt = ['bottom', 'top'];
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rl : lr;
      return isStart ? lr : rl;
    case 'left':
    case 'right':
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y,
    left: x,
    right: x + width,
    bottom: y + height,
    x,
    y
  };
}

function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = getSideAxis(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const alignLength = getAxisLength(alignmentAxis);
  const side = getSide(placement);
  const isVertical = sideAxis === 'y';
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case 'start':
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition$1 = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getPaddingObject(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    x,
    y,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow$1 = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements,
      middlewareData
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = evaluate(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = getPaddingObject(padding);
    const coords = {
      x,
      y
    };
    const axis = getAlignmentAxis(placement);
    const length = getAxisLength(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = min(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = min(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = clamp(min$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. To ensure `shift()` continues to take action,
    // a single reset is performed when this is true.
    const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset - alignmentOffset,
        ...(shouldAddOffset && {
          alignmentOffset
        })
      },
      reset: shouldAddOffset
    };
  }
});

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => getAlignment(placement) === alignment), ...allowedPlacements.filter(placement => getAlignment(placement) !== alignment)] : allowedPlacements.filter(placement => getSide(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = placements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);
      const placements$1 = alignment !== undefined || allowedPlacements === placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements$1[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const alignmentSides = getAlignmentSides(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements$1[0]
          }
        };
      }
      const currentOverflows = [overflow[getSide(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements$1[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = getAlignment(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      getAlignment(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);

      // If a reset by the arrow was caused due to an alignment offset being
      // added, we should skip any logic now since `flip()` has already done its
      // work.
      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = getSide(placement);
      const initialSideAxis = getSideAxis(initialPlacement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== 'none';
      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          // Try next placement and re-run the lifecycle.
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$filter2;
                const placement = (_overflowsData$filter2 = overflowsData.filter(d => {
                  if (hasFallbackAxisSideDirection) {
                    const currentSideAxis = getSideAxis(d.placement);
                    return currentSideAxis === initialSideAxis ||
                    // Create a bias to the `y` side axis due to horizontal
                    // reading directions favoring greater width.
                    currentSideAxis === 'y';
                  }
                  return true;
                }).map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = evaluate(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = min(...rects.map(rect => rect.left));
  const minY = min(...rects.map(rect => rect.top));
  const maxX = max(...rects.map(rect => rect.right));
  const maxY = max(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => rectToClientRect(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = evaluate(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
      const paddingObject = getPaddingObject(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if (getSideAxis(placement) === 'y') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = getSide(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = getSide(placement) === 'left';
          const maxRight = max(...clientRects.map(rect => rect.right));
          const minLeft = min(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

// For type backwards-compatibility, the `OffsetOptions` type was also
// Derivable.

async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getSideAxis(placement) === 'y';
  const mainAxisMulti = ['left', 'top'].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset$1 = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);

      // If the placement is the same and the arrow caused an alignment offset
      // then we don't need to change the positioning coordinates.
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = getSideAxis(getSide(placement));
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = clamp(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = clamp(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const crossAxis = getSideAxis(placement);
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = evaluate(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = ['top', 'left'].includes(getSide(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = evaluate(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = getSide(placement);
      const alignment = getAlignment(placement);
      const isYAxis = getSideAxis(placement) === 'y';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const maximumClippingHeight = height - overflow.top - overflow.bottom;
      const maximumClippingWidth = width - overflow.left - overflow.right;
      const overflowAvailableHeight = min(height - overflow[heightSide], maximumClippingHeight);
      const overflowAvailableWidth = min(width - overflow[widthSide], maximumClippingWidth);
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if (isYAxis) {
        availableWidth = alignment || noShift ? min(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
      } else {
        availableHeight = alignment || noShift ? min(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = max(overflow.left, 0);
        const xMax = max(overflow.right, 0);
        const yMin = max(overflow.top, 0);
        const yMax = max(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};

function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || '').toLowerCase();
  }
  // Mocked nodes in testing environments may not be instances of Node. By
  // returning `#document` an infinite loop won't occur.
  // https://github.com/floating-ui/floating-ui/issues/2317
  return '#document';
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  // Browsers without `ShadowRoot` support.
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !['inline', 'contents'].includes(display);
}
function isTableElement(element) {
  return ['table', 'td', 'th'].includes(getNodeName(element));
}
function isTopLayer(element) {
  return [':popover-open', ':modal'].some(selector => {
    try {
      return element.matches(selector);
    } catch (e) {
      return false;
    }
  });
}
function isContainingBlock(elementOrCss) {
  const webkit = isWebKit();
  const css = isElement(elementOrCss) ? getComputedStyle$1(elementOrCss) : elementOrCss;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  return css.transform !== 'none' || css.perspective !== 'none' || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || ['transform', 'perspective', 'filter'].some(value => (css.willChange || '').includes(value)) || ['paint', 'layout', 'strict', 'content'].some(value => (css.contain || '').includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else if (isTopLayer(currentNode)) {
      return null;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
function isLastTraversableNode(node) {
  return ['html', 'body', '#document'].includes(getNodeName(node));
}
function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    const frameElement = getFrameElement(win);
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}

function getCssDimensions(element) {
  const css = getComputedStyle$1(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}

function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}

function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return createCoords(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? round(rect.width) : rect.width) / width;
  let y = ($ ? round(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

const noOffsets = /*#__PURE__*/createCoords(0);
function getVisualOffsets(element) {
  const win = getWindow(element);
  if (!isWebKit() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow(element)) {
    return false;
  }
  return isFixed;
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = createCoords(1);
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = getFrameElement(currentWin);
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle$1(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = getWindow(currentIFrame);
      currentIFrame = getFrameElement(currentWin);
    }
  }
  return rectToClientRect({
    width,
    height,
    x,
    y
  });
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === 'fixed';
  const documentElement = getDocumentElement(offsetParent);
  const topLayer = elements ? isTopLayer(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = createCoords(1);
  const offsets = createCoords(0);
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}

function getClientRects(element) {
  return Array.from(element.getClientRects());
}

function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle$1(body).direction === 'rtl') {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isWebKit();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : createCoords(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      ...clippingAncestor,
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y
    };
  }
  return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle$1(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element, [], false).filter(el => isElement(el) && getNodeName(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle$1(element).position === 'fixed';
  let currentNode = elementIsFixed ? getParentNode(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle$1(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && ['absolute', 'fixed'].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? isTopLayer(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = createCoords(0);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  const x = rect.left + scroll.scrollLeft - offsets.x;
  const y = rect.top + scroll.scrollTop - offsets.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}

function isStaticPositioned(element) {
  return getComputedStyle$1(element).position === 'static';
}

function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const win = getWindow(element);
  if (isTopLayer(element)) {
    return win;
  }
  if (!isHTMLElement(element)) {
    let svgOffsetParent = getParentNode(element);
    while (svgOffsetParent && !isLastTraversableNode(svgOffsetParent)) {
      if (isElement(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = getParentNode(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && isLastTraversableNode(offsetParent) && isStaticPositioned(offsetParent) && !isContainingBlock(offsetParent)) {
    return win;
  }
  return offsetParent || getContainingBlock(element) || win;
}

const getElementRects = async function (data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};

function isRTL(element) {
  return getComputedStyle$1(element).direction === 'rtl';
}

const platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement,
  isRTL
};

// https://samthor.au/2021/observing-dom/
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = getDocumentElement(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const {
      left,
      top,
      width,
      height
    } = element.getBoundingClientRect();
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = floor(top);
    const insetRight = floor(root.clientWidth - (left + width));
    const insetBottom = floor(root.clientHeight - (top + height));
    const insetLeft = floor(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: max(0, min(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          // If the reference is clipped, the ratio is 0. Throttle the refresh
          // to prevent an infinite loop of updates.
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1000);
        } else {
          refresh(false, ratio);
        }
      }
      isFirstUpdate = false;
    }

    // Older browsers don't support a `document` as the root and will throw an
    // error.
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === 'function',
    layoutShift = typeof IntersectionObserver === 'function',
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...(referenceEl ? getOverflowAncestors(referenceEl) : []), ...getOverflowAncestors(floating)] : [];
  ancestors.forEach(ancestor => {
    ancestorScroll && ancestor.addEventListener('scroll', update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver(_ref => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        // Prevent update loops when using the `size` middleware.
        // https://github.com/floating-ui/floating-ui/issues/1740
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = offset$1;

/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
autoPlacement;

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = shift$1;

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = flip$1;

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
size;

/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = hide$1;

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = arrow$1;

/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = inline$1;

/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
limitShift;

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return computePosition$1(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class ArrowFocusController {
    constructor(items, container, callback) {
        this.wrap = false;
        this.keyListenerBind = this.keyListener.bind(this);
        this.items = items;
        this.container = container;
        this.callback = callback;
        this.container.addEventListener('keydown', this.keyListenerBind);
    }
    keyListener(e) {
        const activeIndex = this.items.indexOf(document.activeElement);
        if (activeIndex < 0) {
            return;
        }
        switch (e.key) {
            case 'ArrowDown':
                if (activeIndex < this.items.length - 1) {
                    e.preventDefault();
                    if (this.callback) {
                        this.callback(activeIndex + 1);
                    }
                }
                else if (this.wrap) {
                    e.preventDefault();
                    if (this.callback) {
                        this.callback(0);
                    }
                }
                break;
            case 'ArrowUp':
                {
                    if (activeIndex > 0) {
                        e.preventDefault();
                        if (this.callback) {
                            this.callback(activeIndex - 1);
                        }
                    }
                    else if (this.wrap && activeIndex === 0) {
                        e.preventDefault();
                        if (this.callback) {
                            this.callback(this.items.length - 1);
                        }
                    }
                }
                break;
        }
    }
    disconnect() {
        this.container.removeEventListener('keydown', this.keyListenerBind);
    }
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function hasDropdownItemWrapperImplemented(item) {
    return (item &&
        item.getDropdownItemElement !== undefined &&
        typeof item.getDropdownItemElement === 'function');
}
class DropdownController {
    constructor() {
        this.dropdowns = new Map();
        this.submenuIds = {};
        this.isWindowListenerActive = false;
    }
    connected(dropdown) {
        if (!this.isWindowListenerActive) {
            this.addOverlayListeners();
        }
        this.dropdowns.set(dropdown.getId(), dropdown);
        if (dropdown.discoverAllSubmenus) {
            this.discoverSubmenus();
        }
    }
    disconnected(dropdown) {
        this.dropdowns.delete(dropdown.getId());
    }
    discoverSubmenus() {
        this.dropdowns.forEach((dropdown) => {
            dropdown.discoverSubmenu();
        });
    }
    present(dropdown) {
        if (!dropdown.isPresent() && dropdown.willPresent()) {
            this.submenuIds[dropdown.getId()] = dropdown.getAssignedSubmenuIds();
            dropdown.present();
        }
    }
    dismissChildren(uid) {
        const childIds = this.submenuIds[uid] || [];
        for (const id of childIds) {
            this.dismiss(this.dropdowns.get(id));
        }
    }
    dismiss(dropdown) {
        if (dropdown.isPresent() && dropdown.willDismiss()) {
            this.dismissChildren(dropdown.getId());
            dropdown.dismiss();
            delete this.submenuIds[dropdown.getId()];
        }
    }
    dismissAll(ignoreBehaviorForIds = [], ignoreRelatedDropdowns = false) {
        this.dropdowns.forEach((dropdown) => {
            const preventClosing = dropdown.closeBehavior === 'inside' || dropdown.closeBehavior === false;
            const shouldIgnore = ignoreBehaviorForIds.includes(dropdown.getId());
            const path = this.buildComposedPath(dropdown.getId(), new Set());
            if (ignoreBehaviorForIds.length > 0 && ignoreRelatedDropdowns) {
                let skipRelatedDropdown = false;
                ignoreBehaviorForIds.forEach((id) => {
                    if (path.has(id)) {
                        skipRelatedDropdown = true;
                        return;
                    }
                });
                if (!skipRelatedDropdown) {
                    return;
                }
            }
            if (!shouldIgnore && preventClosing) {
                return;
            }
            this.dismiss(dropdown);
        });
    }
    dismissOthers(uid) {
        let path = this.buildComposedPath(uid, new Set());
        path.add(uid);
        this.dropdowns.forEach((dropdown) => {
            if (dropdown.closeBehavior !== 'inside' &&
                dropdown.closeBehavior !== false &&
                !path.has(dropdown.getId())) {
                this.dismiss(dropdown);
            }
        });
    }
    pathIncludesTrigger(eventTargets) {
        for (let eventTarget of eventTargets) {
            if (eventTarget instanceof HTMLElement) {
                if (eventTarget.hasAttribute('data-ix-dropdown-trigger')) {
                    return eventTarget;
                }
            }
        }
        return;
    }
    pathIncludesDropdown(eventTargets) {
        return !!eventTargets.find((element) => element.tagName === 'IX-DROPDOWN');
    }
    buildComposedPath(id, path) {
        if (this.submenuIds[id]) {
            path.add(id);
        }
        for (const ruleKey of Object.keys(this.submenuIds)) {
            if (this.submenuIds[ruleKey].includes(id)) {
                this.buildComposedPath(ruleKey, path).forEach((key) => path.add(key));
            }
        }
        return path;
    }
    addOverlayListeners() {
        this.isWindowListenerActive = true;
        window.addEventListener('click', (event) => {
            const hasTrigger = this.pathIncludesTrigger(event.composedPath());
            const hasDropdown = this.pathIncludesDropdown(event.composedPath());
            if (!hasTrigger && !hasDropdown) {
                this.dismissAll();
            }
        });
        window.addEventListener('keydown', (event) => {
            if (event.key === 'Escape') {
                this.dismissAll([...this.dropdowns.keys()]);
            }
        });
    }
}
const addDisposableEventListener = (element, eventType, callback) => {
    element.addEventListener(eventType, callback);
    return () => {
        element.removeEventListener(eventType, callback);
    };
};
const dropdownController = new DropdownController();

const dropdownCss = "/*!@:host*/.sc-ix-dropdown-h{background-color:var(--theme-color-2);border-radius:var(--theme-default-border-radius);min-width:0px;z-index:var(--theme-z-index-dropdown);box-shadow:var(--theme-shadow-4);padding:0.25rem 0px}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-dropdown-h *.sc-ix-dropdown,.sc-ix-dropdown-h *.sc-ix-dropdown::after,.sc-ix-dropdown-h *.sc-ix-dropdown::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-dropdown-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-dropdown-h .sc-ix-dropdown::-webkit-scrollbar-corner{display:none}/*!@:host .dropdown-header*/.sc-ix-dropdown-h .dropdown-header.sc-ix-dropdown{display:flex;align-items:center;height:2.5rem;color:var(--theme-menu-header--color);padding:0 1rem}/*!@:host(.overflow)*/.overflow.sc-ix-dropdown-h{max-height:50vh;overflow-y:auto}/*!@:host(:not(.show))*/.sc-ix-dropdown-h:not(.show){display:none}";
var IxDropdownStyle0 = dropdownCss;

let sequenceId = 0;
class Dropdown {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.showChanged = createEvent(this, "showChanged", 7);
        this.autoUpdateCleanup = null;
        this.localUId = `dropdown-${sequenceId++}`;
        this.assignedSubmenu = [];
        this.focusDropdownItemBind = this.focusDropdownItem.bind(this);
        this.itemObserver = new MutationObserver(() => {
            this.arrowFocusController.items = this.dropdownItems;
        });
        this.suppressAutomaticPlacement = false;
        this.show = false;
        this.trigger = undefined;
        this.anchor = undefined;
        this.closeBehavior = 'both';
        this.placement = 'bottom-start';
        this.positioningStrategy = 'fixed';
        this.header = undefined;
        this.offset = undefined;
        this.overwriteDropdownStyle = undefined;
        this.discoverAllSubmenus = false;
        this.ignoreRelatedSubmenu = false;
    }
    connectedCallback() {
        dropdownController.connected(this);
        if (this.trigger != undefined) {
            this.registerListener(this.trigger);
        }
    }
    cacheSubmenuId(event) {
        event.stopImmediatePropagation();
        event.preventDefault();
        const { detail } = event;
        if (this.assignedSubmenu.indexOf(detail) === -1) {
            this.assignedSubmenu.push(detail);
        }
    }
    disconnectedCallback() {
        dropdownController.dismiss(this);
        dropdownController.disconnected(this);
        if (this.disposeClickListener) {
            this.disposeClickListener();
        }
        if (this.disposeKeyListener) {
            this.disposeKeyListener();
        }
        if (this.autoUpdateCleanup) {
            this.autoUpdateCleanup();
        }
    }
    getAssignedSubmenuIds() {
        return this.assignedSubmenu;
    }
    isPresent() {
        return this.show;
    }
    present() {
        this.show = true;
    }
    dismiss() {
        this.show = false;
    }
    getId() {
        return this.localUId;
    }
    willDismiss() {
        const { defaultPrevented } = this.showChanged.emit(false);
        return !defaultPrevented;
    }
    willPresent() {
        const { defaultPrevented } = this.showChanged.emit(true);
        return !defaultPrevented;
    }
    get dropdownItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-dropdown-item'));
    }
    get slotElement() {
        return this.hostElement.shadowRoot.querySelector('slot');
    }
    addEventListenersFor() {
        var _a, _b, _c;
        (_a = this.disposeClickListener) === null || _a === void 0 ? void 0 : _a.call(this);
        (_b = this.disposeKeyListener) === null || _b === void 0 ? void 0 : _b.call(this);
        const toggleController = () => {
            if (!this.isPresent()) {
                dropdownController.present(this);
            }
            else {
                dropdownController.dismiss(this);
            }
            dropdownController.dismissOthers(this.getId());
        };
        this.disposeClickListener = addDisposableEventListener(this.triggerElement, 'click', (event) => {
            if (!event.defaultPrevented) {
                toggleController();
            }
        });
        (_c = this.triggerElement) === null || _c === void 0 ? void 0 : _c.setAttribute('data-ix-dropdown-trigger', this.localUId);
    }
    /** @internal */
    async discoverSubmenu() {
        var _a;
        (_a = this.triggerElement) === null || _a === void 0 ? void 0 : _a.dispatchEvent(new CustomEvent('ix-assign-sub-menu', {
            bubbles: true,
            composed: true,
            cancelable: true,
            detail: this.localUId,
        }));
    }
    registerKeyListener() {
        if (!this.triggerElement) {
            return;
        }
        this.disposeKeyListener = addDisposableEventListener(this.triggerElement, 'keydown', (event) => {
            if (event.key !== 'ArrowDown') {
                return;
            }
            if (document.activeElement !== this.triggerElement) {
                return;
            }
            dropdownController.present(this);
            setTimeout(() => {
                this.focusDropdownItem(0);
            });
        });
    }
    async registerListener(element) {
        this.triggerElement = await this.resolveElement(element);
        if (this.triggerElement) {
            this.addEventListenersFor();
            this.discoverSubmenu();
        }
    }
    async resolveElement(element) {
        const el = await this.findElement(element);
        return this.checkForSubmenuAnchor(el);
    }
    async checkForSubmenuAnchor(element) {
        if (!element) {
            return null;
        }
        if (hasDropdownItemWrapperImplemented(element)) {
            const dropdownItem = await element.getDropdownItemElement();
            dropdownItem.isSubMenu = true;
            this.hostElement.style.zIndex = `var(--theme-z-index-dropdown)`;
        }
        if (element.tagName === 'IX-DROPDOWN-ITEM') {
            element.isSubMenu = true;
            this.hostElement.style.zIndex = `var(--theme-z-index-dropdown)`;
        }
        return element;
    }
    findElement(element) {
        if (element instanceof Promise) {
            return element;
        }
        if (typeof element === 'object') {
            return Promise.resolve(element);
        }
        if (typeof element != 'string') {
            return;
        }
        const selector = `#${element}`;
        return new Promise((resolve) => {
            if (document.querySelector(selector)) {
                return resolve(document.querySelector(selector));
            }
            const observer = new MutationObserver(() => {
                if (document.querySelector(selector)) {
                    resolve(document.querySelector(selector));
                    observer.disconnect();
                }
            });
            observer.observe(document.body, {
                childList: true,
                subtree: true,
            });
        });
    }
    async changedShow(newShow) {
        var _a, _b;
        if (newShow) {
            this.anchorElement = await (this.anchor
                ? this.resolveElement(this.anchor)
                : this.resolveElement(this.trigger));
            if (this.anchorElement) {
                this.applyDropdownPosition();
            }
            this.arrowFocusController = new ArrowFocusController(this.dropdownItems, this.dropdownRef, this.focusDropdownItemBind);
            this.itemObserver.observe(this.dropdownRef, {
                childList: true,
                subtree: true,
            });
            this.registerKeyListener();
        }
        else {
            this.destroyAutoUpdate();
            (_a = this.arrowFocusController) === null || _a === void 0 ? void 0 : _a.disconnect();
            this.itemObserver.disconnect();
            (_b = this.disposeKeyListener) === null || _b === void 0 ? void 0 : _b.call(this);
        }
    }
    changedTrigger(newTriggerValue) {
        this.registerListener(newTriggerValue);
    }
    destroyAutoUpdate() {
        if (this.autoUpdateCleanup) {
            this.autoUpdateCleanup();
            this.autoUpdateCleanup = null;
        }
    }
    isAnchorSubmenu() {
        var _a;
        if (!hasDropdownItemWrapperImplemented(this.anchorElement)) {
            // Is no official dropdown-item, but check if any dropdown-item
            // is placed somewhere up the DOM
            return !!((_a = this.anchorElement) === null || _a === void 0 ? void 0 : _a.closest('ix-dropdown-item'));
        }
        return true;
    }
    async applyDropdownPosition() {
        if (!this.show) {
            return;
        }
        if (!this.anchorElement) {
            return;
        }
        if (!this.dropdownRef) {
            return;
        }
        const isSubmenu = this.isAnchorSubmenu();
        let positionConfig = {
            strategy: this.positioningStrategy,
            middleware: [],
        };
        if (!this.suppressAutomaticPlacement) {
            positionConfig.middleware.push(flip({ fallbackStrategy: 'initialPlacement' }));
        }
        positionConfig.placement = isSubmenu ? 'right-start' : this.placement;
        positionConfig.middleware = [
            ...positionConfig.middleware,
            inline(),
            shift(),
        ];
        if (this.offset) {
            positionConfig.middleware.push(offset(this.offset));
        }
        this.destroyAutoUpdate();
        this.autoUpdateCleanup = autoUpdate(this.anchorElement, this.dropdownRef, async () => {
            const computeResponse = await computePosition(this.anchorElement, this.dropdownRef, positionConfig);
            Object.assign(this.dropdownRef.style, {
                top: '0',
                left: '0',
                transform: `translate(${Math.round(computeResponse.x)}px,${Math.round(computeResponse.y)}px)`,
            });
            if (this.overwriteDropdownStyle) {
                const overwriteStyle = await this.overwriteDropdownStyle({
                    dropdownRef: this.dropdownRef,
                    triggerRef: this.triggerElement,
                });
                Object.assign(this.dropdownRef.style, overwriteStyle);
            }
        }, {
            ancestorResize: true,
            ancestorScroll: true,
            elementResize: true,
        });
    }
    focusDropdownItem(index) {
        requestAnimationFrame(() => {
            var _a;
            (_a = this.dropdownItems[index]) === null || _a === void 0 ? void 0 : _a.shadowRoot.querySelector('button').focus();
        });
    }
    async componentDidLoad() {
        this.changedTrigger(this.trigger);
    }
    async componentDidRender() {
        await this.applyDropdownPosition();
        this.anchorElement = await (this.anchor
            ? this.resolveElement(this.anchor)
            : this.resolveElement(this.trigger));
    }
    isTriggerElement(element) {
        const trigger = !!element.hasAttribute('data-ix-dropdown-trigger');
        return trigger;
    }
    onDropdownClick(event) {
        const target = dropdownController.pathIncludesTrigger(event.composedPath());
        if (target) {
            if (target !== this.triggerElement) {
                event.preventDefault();
            }
            if (this.isTriggerElement(target)) {
                if (this.closeBehavior === 'outside') {
                    event.preventDefault();
                }
                return;
            }
        }
        if (!event.defaultPrevented &&
            (this.closeBehavior === 'inside' || this.closeBehavior === 'both')) {
            dropdownController.dismissAll([this.getId()], this.ignoreRelatedSubmenu);
            return;
        }
        dropdownController.dismissOthers(this.getId());
    }
    /**
     * Update position of dropdown
     */
    async updatePosition() {
        this.applyDropdownPosition();
    }
    render() {
        return (hAsync(Host, { key: 'a0822930491de50066f777003b05892d9fc9587b', "data-ix-dropdown": this.localUId, ref: (ref) => (this.dropdownRef = ref), class: {
                'dropdown-menu': true,
                show: this.show,
                overflow: true,
            }, style: {
                margin: '0',
                minWidth: '0px',
                position: this.positioningStrategy,
            }, role: "list", onClick: (event) => this.onDropdownClick(event) }, hAsync("div", { key: '00f8905edd2cfac83a21fbeee7001a4987fc018e', style: { display: 'contents' } }, this.header && hAsync("div", { key: '4ae378c15f844f67c4894bf8ab4c18e502cddceb', class: "dropdown-header" }, this.header), this.show && hAsync("slot", { key: 'bca1aac38def6df5d322b42415236daf61f67865' }))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "show": ["changedShow"],
        "trigger": ["changedTrigger"]
    }; }
    static get style() { return IxDropdownStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-dropdown",
        "$members$": {
            "suppressAutomaticPlacement": [4, "suppress-automatic-placement"],
            "show": [1540],
            "trigger": [1],
            "anchor": [1],
            "closeBehavior": [8, "close-behavior"],
            "placement": [1],
            "positioningStrategy": [1, "positioning-strategy"],
            "header": [1],
            "offset": [16],
            "overwriteDropdownStyle": [16],
            "discoverAllSubmenus": [4, "discover-all-submenus"],
            "ignoreRelatedSubmenu": [4, "ignore-related-submenu"],
            "discoverSubmenu": [64],
            "updatePosition": [64]
        },
        "$listeners$": [[0, "ix-assign-sub-menu", "cacheSubmenuId"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": [["show", "show"]]
    }; }
}

const dropdownButtonCss = "/*!@:host*/.sc-ix-dropdown-button-h{display:inline-block;position:relative;height:2rem;width:auto}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-dropdown-button-h *.sc-ix-dropdown-button,.sc-ix-dropdown-button-h *.sc-ix-dropdown-button::after,.sc-ix-dropdown-button-h *.sc-ix-dropdown-button::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-dropdown-button-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-dropdown-button-h .sc-ix-dropdown-button::-webkit-scrollbar-corner{display:none}/*!@:host .hide*/.sc-ix-dropdown-button-h .hide.sc-ix-dropdown-button{display:none}/*!@:host .dropdown-button*/.sc-ix-dropdown-button-h .dropdown-button.sc-ix-dropdown-button{display:block;position:relative;width:100%;height:100%}/*!@:host .dropdown-button > ix-button*/.sc-ix-dropdown-button-h .dropdown-button.sc-ix-dropdown-button>ix-button.sc-ix-dropdown-button{width:100%;height:100%}/*!@:host .dropdown-button .button-label*/.sc-ix-dropdown-button-h .dropdown-button.sc-ix-dropdown-button .button-label.sc-ix-dropdown-button{margin-right:auto;min-width:0px;overflow:hidden;white-space:nowrap;text-overflow:ellipsis}/*!@:host .dropdown-button .dropdown-icon*/.sc-ix-dropdown-button-h .dropdown-button.sc-ix-dropdown-button .dropdown-icon.sc-ix-dropdown-button{margin-right:0.25rem}/*!@:host .triangle*/.sc-ix-dropdown-button-h .triangle.sc-ix-dropdown-button{position:absolute;margin-inline-start:1.5625rem;margin-block-start:-0.4375rem;border-right:0 solid transparent;border-left:4px solid transparent;border-top:0 solid transparent;border-bottom:4px solid;color:var(--theme-btn-primary--color)}/*!@:host .triangle.primary.ghost*/.sc-ix-dropdown-button-h .triangle.primary.ghost.sc-ix-dropdown-button{color:var(--theme-btn-invisible-primary--color)}/*!@:host .triangle.primary.outline*/.sc-ix-dropdown-button-h .triangle.primary.outline.sc-ix-dropdown-button{color:var(--theme-btn-outline-primary--color)}/*!@:host .triangle.primary.ghost.disabled*/.sc-ix-dropdown-button-h .triangle.primary.ghost.disabled.sc-ix-dropdown-button{color:var(--theme-btn-invisible-primary--color--disabled)}/*!@:host .triangle.primary.outline.disabled*/.sc-ix-dropdown-button-h .triangle.primary.outline.disabled.sc-ix-dropdown-button{color:var(--theme-btn-outline-primary--color--disabled)}/*!@:host .triangle.primary.disabled*/.sc-ix-dropdown-button-h .triangle.primary.disabled.sc-ix-dropdown-button{color:var(--theme-btn-primary--color--disabled)}/*!@:host .triangle.secondary.ghost*/.sc-ix-dropdown-button-h .triangle.secondary.ghost.sc-ix-dropdown-button{color:var(--theme-btn-invisible-secondary--color)}/*!@:host .triangle.secondary.outline*/.sc-ix-dropdown-button-h .triangle.secondary.outline.sc-ix-dropdown-button{color:var(--theme-btn-outline-secondary--color)}/*!@:host .triangle.secondary.ghost.disabled*/.sc-ix-dropdown-button-h .triangle.secondary.ghost.disabled.sc-ix-dropdown-button{color:var(--theme-btn-invisible-secondary--color--disabled)}/*!@:host .triangle.secondary.outline.disabled*/.sc-ix-dropdown-button-h .triangle.secondary.outline.disabled.sc-ix-dropdown-button{color:var(--theme-btn-outline-secondary--color--disabled)}/*!@:host .triangle.secondary.disabled*/.sc-ix-dropdown-button-h .triangle.secondary.disabled.sc-ix-dropdown-button{color:var(--theme-btn-secondary--color--disabled)}/*!@:host .content*/.sc-ix-dropdown-button-h .content.sc-ix-dropdown-button{display:flex;align-items:center}/*!@:host(.disabled)*/.disabled.sc-ix-dropdown-button-h{pointer-events:none}";
var IxDropdownButtonStyle0 = dropdownButtonCss;

/**
 * @since 1.3.0
 */
class DropdownButton {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.variant = 'primary';
        this.outline = false;
        this.ghost = false;
        this.disabled = false;
        this.label = undefined;
        this.icon = undefined;
        this.closeBehavior = 'both';
        this.placement = undefined;
        this.dropdownAnchor = undefined;
    }
    getTriangle() {
        return (hAsync("div", { class: {
                triangle: true,
                hide: this.label !== '',
                primary: this.variant === 'primary',
                secondary: this.variant === 'secondary',
                ghost: this.ghost,
                outline: this.outline,
                disabled: this.disabled,
            } }));
    }
    render() {
        return (hAsync(Host, { key: '8669f7d302b6009aa9ab9cadb3c86e4bbcc6330f', class: {
                disabled: this.disabled,
            }, ref: (ref) => {
                this.dropdownAnchor = ref;
            } }, hAsync("div", { key: '5561196cfa6584097b0395ca1d4bf61db522b5a8', class: "dropdown-button" }, this.label ? (hAsync("ix-button", { variant: this.variant, outline: this.outline, ghost: this.ghost, disabled: this.disabled, alignment: "start" }, hAsync("div", { class: 'content' }, this.icon ? (hAsync("ix-icon", { name: this.icon, size: "24", class: 'dropdown-icon' })) : null, hAsync("div", { class: 'button-label' }, this.label), hAsync("ix-icon", { name: 'chevron-down-small', size: "24" })))) : (hAsync("div", null, hAsync("ix-icon-button", { icon: this.icon, variant: this.variant, outline: this.outline, ghost: this.ghost, disabled: this.disabled }), this.getTriangle()))), hAsync("ix-dropdown", { key: '4b738dfff8c84360e1d561560c3b29ba21684de6', class: "dropdown", trigger: this.dropdownAnchor, placement: this.placement, closeBehavior: this.closeBehavior }, hAsync("slot", { key: 'ad15df81aad664b12a3183b45e443b110d2b4393' }))));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxDropdownButtonStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-dropdown-button",
        "$members$": {
            "variant": [1],
            "outline": [4],
            "ghost": [4],
            "disabled": [4],
            "label": [1],
            "icon": [1],
            "closeBehavior": [8, "close-behavior"],
            "placement": [1],
            "dropdownAnchor": [32]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const dropdownHeaderCss = "/*!@:host*/.sc-ix-dropdown-header-h{display:flex;align-items:center;position:relative;height:2.5rem;width:auto;padding:0.25rem 1rem;overflow:hidden;cursor:default;color:var(--theme-color-soft-text)}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-dropdown-header-h *.sc-ix-dropdown-header,.sc-ix-dropdown-header-h *.sc-ix-dropdown-header::after,.sc-ix-dropdown-header-h *.sc-ix-dropdown-header::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-dropdown-header-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-dropdown-header-h .sc-ix-dropdown-header::-webkit-scrollbar-corner{display:none}";
var IxDropdownHeaderStyle0 = dropdownHeaderCss;

/**
 * @since 2.0.0
 */
class DropdownHeader {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.label = undefined;
    }
    render() {
        return (hAsync(Host, { key: 'efbc6ba551cef0f5c641cd8282484eea4e2b87aa' }, hAsync("ix-typography", { key: 'f57e88574cb2cfa62667a026469aebd306648014', class: 'category-text', variant: 'default-title' }, this.label)));
    }
    static get style() { return IxDropdownHeaderStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-dropdown-header",
        "$members$": {
            "label": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const dropdownItemCss = "/*!@:host*/.sc-ix-dropdown-item-h{--ix-dropdown-item-checked-color:var(--theme-color-primary);display:flex;flex-direction:row;position:relative;height:2.5rem;width:auto;overflow:hidden;cursor:pointer}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-dropdown-item-h *.sc-ix-dropdown-item,.sc-ix-dropdown-item-h *.sc-ix-dropdown-item::after,.sc-ix-dropdown-item-h *.sc-ix-dropdown-item::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-dropdown-item-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-dropdown-item-h .sc-ix-dropdown-item::-webkit-scrollbar-corner{display:none}/*!@:host .dropdown-item*/.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item{all:unset;display:flex;flex-direction:row;align-items:center;position:relative;height:calc(100% - 2px);width:calc(100% - 0.5rem - 1.5rem);padding:0 0.5rem;padding-right:1.5rem;border:0.0625rem solid transparent;white-space:nowrap}/*!@:host .dropdown-item.no-checked-field*/.sc-ix-dropdown-item-h .dropdown-item.no-checked-field.sc-ix-dropdown-item{width:calc(100% - 1rem - 1.5rem);padding:0 1rem;padding-right:1.5rem}/*!@:host .dropdown-item:focus-visible*/.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item:focus-visible{border-color:var(--theme-color-focus-bdr)}/*!@:host .dropdown-item-checked*/.sc-ix-dropdown-item-h .dropdown-item-checked.sc-ix-dropdown-item{display:flex;align-items:center;justify-content:center;position:relative;height:100%;width:1rem;min-width:1rem;margin-right:0.5rem;color:var(--ix-dropdown-item-checked-color)}/*!@:host .dropdown-item-icon*/.sc-ix-dropdown-item-h .dropdown-item-icon.sc-ix-dropdown-item{margin-right:0.5rem;color:var(--theme-color-std-text)}/*!@:host .dropdown-item-text*/.sc-ix-dropdown-item-h .dropdown-item-text.sc-ix-dropdown-item{display:block;position:relative;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}/*!@:host .dropdown-item:focus-visible*/.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item:focus-visible{outline:1px solid yellow}/*!@:host .submenu-icon*/.sc-ix-dropdown-item-h .submenu-icon.sc-ix-dropdown-item{margin-left:auto}/*!@:host(.icon-only) .dropdown-item-icon*/.icon-only.sc-ix-dropdown-item-h .dropdown-item-icon.sc-ix-dropdown-item{margin-right:0px}/*!@:host(.icon-only) .dropdown-item-checked*/.icon-only.sc-ix-dropdown-item-h .dropdown-item-checked.sc-ix-dropdown-item{display:none}/*!@:host(.icon-only) .dropdown-item*/.icon-only.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item{width:calc(100% - 0.5rem - 0.5rem);padding:0 0.5rem;padding-right:0.5rem}/*!@:host(.submenu) .dropdown-item*/.submenu.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item{width:calc(100% - 0.5rem - 0.5rem);padding:0 0.5rem;padding-right:0.5rem}/*!@:host(:not(.disabled):not(:disabled).hover),\n:host(:not(.disabled):not(:disabled):hover)*/.sc-ix-dropdown-item-h:not(.disabled):not(:disabled).hover,.sc-ix-dropdown-item-h:not(.disabled):not(:disabled):hover{background-color:var(--theme-ghost--background--hover)}/*!@:host(:not(.disabled):not(:disabled).active),\n:host(:not(.disabled):not(:disabled):active)*/.sc-ix-dropdown-item-h:not(.disabled):not(:disabled).active,.sc-ix-dropdown-item-h:not(.disabled):not(:disabled):active{background-color:var(--theme-ghost--background--active)}/*!@:host(.disabled)*/.disabled.sc-ix-dropdown-item-h{pointer-events:none;color:var(--theme-color-weak-text) !important}/*!@:host(.disabled) .dropdown-item-icon*/.disabled.sc-ix-dropdown-item-h .dropdown-item-icon.sc-ix-dropdown-item{color:var(--theme-color-weak-text) !important}";
var IxDropdownItemStyle0 = dropdownItemCss;

class DropdownItem {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.itemClick = createEvent(this, "itemClick", 7);
        this.label = undefined;
        this.icon = undefined;
        this.hover = false;
        this.disabled = false;
        this.checked = false;
        this.isSubMenu = false;
        this.suppressChecked = false;
    }
    /**
     * Internal usage only
     */
    async emitItemClick() {
        this.itemClick.emit(this.hostElement);
    }
    /** @internal */
    async getDropdownItemElement() {
        return this.hostElement;
    }
    isIconOnly() {
        return (this.label === undefined &&
            this.hostElement.innerText === '' &&
            this.icon !== undefined);
    }
    render() {
        return (hAsync(Host, { key: '2cfd2c1c15e44dd78403e0809382bf07141c73ba', class: {
                hover: this.hover,
                'icon-only': this.isIconOnly(),
                disabled: this.disabled,
                submenu: this.isSubMenu,
            }, role: "listitem" }, hAsync("button", { key: 'e60fba707a53859c785ddf20bcda4928d1c80695', type: "button", tabIndex: 0, class: {
                'dropdown-item': true,
                'no-checked-field': this.suppressChecked,
            }, onClick: () => this.emitItemClick() }, !this.suppressChecked ? (hAsync("div", { class: "dropdown-item-checked" }, this.checked ? (hAsync("ix-icon", { class: "checkmark", name: 'single-check', size: "16" })) : null)) : null, this.icon ? (hAsync("ix-icon", { class: "dropdown-item-icon", name: this.icon })) : null, hAsync("div", { key: '66c35f150fb79f2ad92703c3cb3f6ec6205ff0e0', class: "dropdown-item-text" }, this.label, hAsync("slot", { key: '403f144a8b3d8def9592091445355303f39d2a8f' })), this.isSubMenu ? (hAsync("ix-icon", { name: 'chevron-right-small', class: 'submenu-icon' })) : null)));
    }
    get hostElement() { return getElement(this); }
    static get style() { return IxDropdownItemStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-dropdown-item",
        "$members$": {
            "label": [1],
            "icon": [1],
            "hover": [4],
            "disabled": [4],
            "checked": [4],
            "isSubMenu": [4, "is-sub-menu"],
            "suppressChecked": [4, "suppress-checked"],
            "emitItemClick": [64],
            "getDropdownItemElement": [64]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const dropdownQuickActionsCss = "/*!@:host*/.sc-ix-dropdown-quick-actions-h{display:flex;justify-content:center;align-items:center;margin-inline-start:1.5rem;margin-inline-end:1.5rem;margin-block-end:0.25rem}/*!@:host slot::slotted(*)*/.sc-ix-dropdown-quick-actions-h slot.sc-ix-dropdown-quick-actions-s>*{display:flex;margin-inline-end:0.625rem}";
var IxDropdownQuickActionsStyle0 = dropdownQuickActionsCss;

/**
 * @since 1.4.0
 */
class DropdownQuickActions {
    constructor(hostRef) {
        registerInstance(this, hostRef);
    }
    render() {
        return (hAsync(Host, { key: 'f8336e321ecbdf72f5ed73218cdb257ad9cfa6fb' }, hAsync("slot", { key: 'a91fe26669fdd27a72fecc5f4aeca92d4a8258fa' })));
    }
    static get style() { return IxDropdownQuickActionsStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-dropdown-quick-actions",
        "$members$": undefined,
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const emptyStateCss = "/*!@:host*//*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-empty-state-h *.sc-ix-empty-state,.sc-ix-empty-state-h *.sc-ix-empty-state::after,.sc-ix-empty-state-h *.sc-ix-empty-state::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-empty-state-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-empty-state-h .sc-ix-empty-state::-webkit-scrollbar-corner{display:none}/*!@:host .label__subHeader*/.sc-ix-empty-state-h .label__subHeader.sc-ix-empty-state{color:var(--theme-color-soft-text)}/*!@:host(.emptyState.emptyState--large)*/.emptyState.emptyState--large.sc-ix-empty-state-h{display:flex;flex-direction:column;justify-content:center;align-items:center;gap:1rem}/*!@:host(.emptyState.emptyState--large) .emptyState__icon*/.emptyState.emptyState--large.sc-ix-empty-state-h .emptyState__icon.sc-ix-empty-state{width:3.5rem;height:3.5rem;display:flex;justify-content:center;align-items:center}/*!@:host(.emptyState.emptyState--large) .emptyState__icon ix-icon*/.emptyState.emptyState--large.sc-ix-empty-state-h .emptyState__icon.sc-ix-empty-state ix-icon.sc-ix-empty-state{transform:scale(1.75)}/*!@:host(.emptyState.emptyState--large) .emptyState__content*/.emptyState.emptyState--large.sc-ix-empty-state-h .emptyState__content.sc-ix-empty-state{display:flex;flex-direction:column;justify-content:center;align-items:center;gap:1.5rem}/*!@:host(.emptyState.emptyState--large) .emptyState__content .content__label*/.emptyState.emptyState--large.sc-ix-empty-state-h .emptyState__content.sc-ix-empty-state .content__label.sc-ix-empty-state{display:flex;flex-direction:column;justify-content:center;align-items:center;gap:0.5rem}/*!@:host(.emptyState.emptyState--large) .label__subHeader,\n:host(.emptyState.emptyState--large) ix-typography*/.emptyState.emptyState--large.sc-ix-empty-state-h .label__subHeader.sc-ix-empty-state,.emptyState.emptyState--large.sc-ix-empty-state-h ix-typography.sc-ix-empty-state{text-align:center}/*!@:host(.emptyState.emptyState--compact)*/.emptyState.emptyState--compact.sc-ix-empty-state-h{display:flex;flex-direction:row;justify-content:center;align-items:center;gap:1rem}/*!@:host(.emptyState.emptyState--compact) .emptyState__icon*/.emptyState.emptyState--compact.sc-ix-empty-state-h .emptyState__icon.sc-ix-empty-state{display:flex;flex-direction:row;align-items:center;height:2.5rem}/*!@:host(.emptyState.emptyState--compact) .emptyState__content*/.emptyState.emptyState--compact.sc-ix-empty-state-h .emptyState__content.sc-ix-empty-state{display:flex;flex-direction:row;justify-content:center;align-items:center;gap:1rem}/*!@:host(.emptyState.emptyState--compactBreak)*/.emptyState.emptyState--compactBreak.sc-ix-empty-state-h{display:flex;flex-direction:row;align-items:flex-start;gap:1rem}/*!@:host(.emptyState.emptyState--compactBreak) .emptyState__icon*/.emptyState.emptyState--compactBreak.sc-ix-empty-state-h .emptyState__icon.sc-ix-empty-state{display:flex;flex-direction:row;align-items:center;height:2.5rem}/*!@:host(.emptyState.emptyState--compactBreak) .emptyState__content*/.emptyState.emptyState--compactBreak.sc-ix-empty-state-h .emptyState__content.sc-ix-empty-state{display:flex;flex-direction:column;align-items:flex-start;gap:0.5rem}";
var IxEmptyStateStyle0 = emptyStateCss;

/**
 * @since 1.6.0
 */
class EmptyState {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.actionClick = createEvent(this, "actionClick", 7);
        this.layout = 'large';
        this.icon = undefined;
        this.header = undefined;
        this.subHeader = undefined;
        this.action = undefined;
    }
    render() {
        return (hAsync(Host, { key: '6a35699c05f5c71ac06952275054124e827f11d1', class: `emptyState emptyState--${this.layout}` }, this.icon && (hAsync("div", { key: 'd5461a77a1e97b201bc93735b9984071f5bbb8eb', class: "emptyState__icon" }, hAsync("ix-icon", { key: '540eb6f4f0413685dc4b5dec247e79b1ab7c984f', name: this.icon, size: this.layout === 'large' ? '32' : '32', color: "color-soft-text" }))), hAsync("div", { key: '30d14aa2ca5f1b6597ee1e7aefa930f6592f1b7b', class: "emptyState__content" }, hAsync("div", { key: 'c3f75186476392f25251701003bba78d23f7a2bb', class: "content__label" }, hAsync("ix-typography", { key: '357899084359203cc8b06f508658462ed04f9241', variant: this.layout === 'large' ? 'display-large' : 'default' }, this.header), this.subHeader && (hAsync("div", { key: 'a0ce178dc2ab263ec5e1a6627aeb740fce0539fd', class: "label__subHeader" }, this.subHeader))), this.action && (hAsync("div", { key: 'ce163e65fb307b5c5b32fd63e1750caa7456ff41', class: "content__action" }, hAsync("ix-button", { key: '3e32f02186912b49a2b7e9e314531e2a26b79a3b', onClick: () => this.actionClick.emit() }, this.action))))));
    }
    static get style() { return IxEmptyStateStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-empty-state",
        "$members$": {
            "layout": [1],
            "icon": [1],
            "header": [1],
            "subHeader": [1, "sub-header"],
            "action": [1]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const convertToRemString = (value) => {
    const valueRem = value / 16;
    return `${valueRem}rem`;
};

const eventListCss = "/*!@:host*/.sc-ix-event-list-h{display:block;position:relative}/*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-event-list-h *.sc-ix-event-list,.sc-ix-event-list-h *.sc-ix-event-list::after,.sc-ix-event-list-h *.sc-ix-event-list::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-event-list-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-event-list-h .sc-ix-event-list::-webkit-scrollbar-corner{display:none}/*!@:host ul*/.sc-ix-event-list-h ul.sc-ix-event-list{list-style:none;padding:0;margin-top:0;margin-bottom:0}/*!@:host(.item-size-l)*/.item-size-l.sc-ix-event-list-h{--event-list-item-height:6.5rem;--event-list-item-content-white-space:normal}/*!@:host(.compact)*/.compact.sc-ix-event-list-h{--event-list-item-border-radius:0;--event-list-item-margin-bottom:0}";
var IxEventListStyle0 = eventListCss;

class EventList {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.mutationObserver = createMutationObserver(this.onMutation.bind(this));
        this.itemHeight = 'S';
        this.compact = false;
        this.animated = true;
        this.chevron = undefined;
    }
    watchChevron(chevron) {
        this.handleChevron(chevron);
    }
    componentDidLoad() {
        if (this.animated) {
            this.triggerFadeIn();
        }
        if (!Number.isNaN(Number(this.itemHeight))) {
            const height = convertToRemString(this.itemHeight);
            this.hostElement
                .querySelectorAll('ix-event-list-item')
                .forEach((item) => {
                this.setCustomHeight(item, height);
            });
        }
        this.handleChevron(this.chevron);
        this.mutationObserver.observe(this.hostElement, {
            childList: true,
            subtree: true,
        });
    }
    onMutation(mutationRecords) {
        this.triggerFadeOut().then(() => {
            if (typeof this.itemHeight === 'number') {
                const height = convertToRemString(this.itemHeight);
                mutationRecords
                    .filter((mutation) => mutation.type === 'childList')
                    .forEach((mutation) => mutation.addedNodes.forEach((item) => {
                    const itemHtml = item;
                    this.setCustomHeight(itemHtml, height);
                }));
            }
            this.handleChevron(this.chevron);
            this.triggerFadeIn();
        });
    }
    setCustomHeight(item, height) {
        item.style.setProperty('--event-list-item-height', height);
    }
    triggerFadeOut() {
        return new Promise((resolve) => {
            if (!this.animated) {
                resolve();
            }
            const keyframes = [{ opacity: 1, easing: 'easeInSine' }, { opacity: 0 }];
            const listElement = this.hostElement.shadowRoot.querySelector('ul');
            anime({
                targets: listElement,
                opacity: keyframes,
                duration: EventList.fadeOutDuration,
                complete: () => {
                    resolve();
                },
            });
        });
    }
    triggerFadeIn() {
        if (!this.animated) {
            return;
        }
        const listItems = this.hostElement.querySelectorAll('ix-event-list-item');
        listItems.forEach((e, i) => {
            const delay = i * 80;
            const offset = delay / (delay + EventList.fadeInDuration);
            anime({
                targets: e,
                offset: offset,
                duration: EventList.fadeInDuration + delay,
                opacity: [0, 1],
                easing: 'easeInOutSine',
                delay: delay,
                autoplay: true,
            });
        });
    }
    handleChevron(chevron) {
        const listItems = this.hostElement.querySelectorAll('ix-event-list-item');
        listItems.forEach((e) => {
            if (chevron) {
                e.setAttribute('chevron', 'true');
            }
            else if (chevron !== undefined) {
                e.removeAttribute('chevron');
            }
        });
    }
    render() {
        return (hAsync(Host, { key: '089a281bac15abcd507401131c2be9408acd5845', class: {
                'item-size-s': this.itemHeight === 'S',
                'item-size-l': this.itemHeight === 'L',
                compact: this.compact,
            } }, hAsync("ul", { key: 'a142c907713c0817db7a3c056e4c7498f456963c' }, hAsync("slot", { key: '1b3a8a7f56f4e2e52d29acbf325ab29e663f4337' }))));
    }
    get hostElement() { return getElement(this); }
    static get watchers() { return {
        "chevron": ["watchChevron"]
    }; }
    static get style() { return IxEventListStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-event-list",
        "$members$": {
            "itemHeight": [8, "item-height"],
            "compact": [4],
            "animated": [4],
            "chevron": [4]
        },
        "$listeners$": undefined,
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}
EventList.fadeOutDuration = 50;
EventList.fadeInDuration = 150;

const eventListItemCss = "/*!@:host*//*!@:host *,\n:host *::after,\n:host *::before*/.sc-ix-event-list-item-h *.sc-ix-event-list-item,.sc-ix-event-list-item-h *.sc-ix-event-list-item::after,.sc-ix-event-list-item-h *.sc-ix-event-list-item::before{box-sizing:border-box}/*!@:host ::-webkit-scrollbar-button*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){.sc-ix-event-list-item-h *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}/*!@:host ::-webkit-scrollbar*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar{width:0.5rem;height:0.5rem}/*!@:host ::-webkit-scrollbar-track*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}/*!@:host ::-webkit-scrollbar-track:hover*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}/*!@:host ::-webkit-scrollbar-thumb*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}/*!@:host ::-webkit-scrollbar-thumb:hover*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}/*!@:host ::-webkit-scrollbar-corner*/.sc-ix-event-list-item-h .sc-ix-event-list-item::-webkit-scrollbar-corner{display:none}/*!@:host .event-list-item*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item{display:flex;align-items:center;position:relative;height:var(--event-list-item-height, 2.5rem);max-height:var(--event-list-item-height, 2.5rem);border-radius:var(--event-list-item-border-radius, 0.25rem);background-color:var(--theme-event-item--background);overflow:hidden;transition:var(--theme-default-time);cursor:pointer;margin-bottom:var(--event-list-item-margin-bottom, 0.5rem)}/*!@:host .event-list-item .indicator*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item .indicator.sc-ix-event-list-item{height:100%;width:0.5rem;max-width:0.5rem;min-width:0.5rem;border-top-left-radius:var(--event-list-item-border-radius, 0.25rem);border-bottom-left-radius:var(--event-list-item-border-radius, 0.25rem)}/*!@:host .event-list-item .indicator-empty*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item .indicator-empty.sc-ix-event-list-item{border:var(--theme-weak-bdr-1);border-right:none}/*!@:host .event-list-item .event-list-item-container*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item .event-list-item-container.sc-ix-event-list-item{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;flex-grow:1;width:calc(100% - (1rem + 0.5rem));height:100%;border:0.062rem solid;border-color:var(--theme-event-item--border);border-top-left-radius:0;border-top-right-radius:var(--event-list-item-border-radius, 0.25rem);border-bottom-left-radius:0;border-bottom-right-radius:var(--event-list-item-border-radius, 0.25rem);border-left:none;padding-left:1rem}/*!@:host .event-list-item .event-content*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item .event-content.sc-ix-event-list-item{display:flex;align-items:center;width:100%;height:var(--event-list-item-height, 100%);max-height:var(--event-list-item-height, 100%);white-space:var(--event-list-item-content-white-space, inherit);overflow:hidden;padding-inline-end:0.5rem}/*!@:host .event-list-item .chevron-icon*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item .chevron-icon.sc-ix-event-list-item{margin-left:auto;margin-right:0.5rem;opacity:0.6;align-self:center}/*!@:host .event-list-item:not(.selected):not(.disabled):not(:disabled)*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected):not(.disabled):not(:disabled){cursor:pointer}/*!@:host .event-list-item:not(.selected):not(.disabled):not(:disabled):hover, :host .event-list-item:not(.selected):not(.disabled):not(:disabled):hover*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected):not(.disabled):not(:disabled):hover{background-color:var(--theme-event-item--background--hover)}/*!@:host .event-list-item:not(.selected):not(.disabled):not(:disabled)*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected):not(.disabled):not(:disabled){cursor:pointer}/*!@:host .event-list-item:not(.selected):not(.disabled):not(:disabled):active, :host .event-list-item:not(.selected):not(.disabled):not(:disabled).active*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected):not(.disabled):not(:disabled):active,.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected):not(.disabled):not(:disabled).active{background-color:var(--theme-event-item--background--active)}/*!@:host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled)*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected) .event-list-item-container.sc-ix-event-list-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled):hover, :host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled):hover*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected) .event-list-item-container.sc-ix-event-list-item:not(.disabled):not(:disabled):hover{border-color:var(--theme-event-item--border--hover)}/*!@:host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled)*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected) .event-list-item-container.sc-ix-event-list-item:not(.disabled):not(:disabled){cursor:pointer}/*!@:host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled):active, :host .event-list-item:not(.selected) .event-list-item-container:not(.disabled):not(:disabled).active*/.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected) .event-list-item-container.sc-ix-event-list-item:not(.disabled):not(:disabled):active,.sc-ix-event-list-item-h .event-list-item.sc-ix-event-list-item:not(.selected) .event-list-item-container.sc-ix-event-list-item:not(.disabled):not(:disabled).active{border-color:var(--theme-event-item--border--active)}/*!@:host .event-list-item.selected .event-list-item-container*/.sc-ix-event-list-item-h .event-list-item.selected.sc-ix-event-list-item .event-list-item-container.sc-ix-event-list-item{background-color:var(--theme-event-item--background--selected);border-color:var(--theme-event-item--border--selected)}/*!@:host .event-list-item[disabled], :host .event-list-item.disabled*/.sc-ix-event-list-item-h .event-list-item[disabled].sc-ix-event-list-item,.sc-ix-event-list-item-h .event-list-item.disabled.sc-ix-event-list-item{pointer-events:none}/*!@:host .event-list-item[disabled] .event-list-item-container, :host .event-list-item.disabled .event-list-item-container*/.sc-ix-event-list-item-h .event-list-item[disabled].sc-ix-event-list-item .event-list-item-container.sc-ix-event-list-item,.sc-ix-event-list-item-h .event-list-item.disabled.sc-ix-event-list-item .event-list-item-container.sc-ix-event-list-item{background-color:var(--theme-event-item--background--disabled);border-color:var(--theme-event-item--border--disabled)}/*!@:host(.disabled)*/.disabled.sc-ix-event-list-item-h{pointer-events:none}";
var IxEventListItemStyle0 = eventListItemCss;

class EventListItem {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.itemClick = createEvent(this, "itemClick", 7);
        this.color = undefined;
        this.itemColor = undefined;
        this.selected = undefined;
        this.disabled = undefined;
        this.chevron = undefined;
    }
    handleItemClick() {
        this.itemClick.emit();
    }
    render() {
        var _a, _b, _c, _d;
        let color = ((_a = this.itemColor) === null || _a === void 0 ? void 0 : _a.startsWith('--theme'))
            ? `var(${this.itemColor})`
            : `var(--theme-${this.itemColor})`;
        if (this.color) {
            color = ((_b = this.color) === null || _b === void 0 ? void 0 : _b.startsWith('--theme'))
                ? `var(${this.color})`
                : `var(--theme-${this.color})`;
        }
        return (hAsync(Host, { key: '115c40df6986d283ac53ecc1ef7d5cfbe751864e', class: {
                disabled: this.disabled,
            } }, hAsync("li", { key: '431cc4b56030d9f5db39923380067fdb98e77b88', "aria-disabled": a11yBoolean(this.disabled), class: {
                'event-list-item': true,
                selected: this.selected,
                disabled: this.disabled,
            } }, hAsync("div", { key: '44cc672e3416136a20c4f256c6c6ffd9f82097d5', class: `indicator ${!((_c = this.itemColor) !== null && _c !== void 0 ? _c : this.color) ? 'indicator-empty' : ''}`, style: {
                'background-color': ((_d = this.itemColor) !== null && _d !== void 0 ? _d : this.color) ? color : 'inherit',
                opacity: `${this.disabled ? 0.4 : 1}`,
            } }), hAsync("div", { key: 'd894014deacd0fd725c0e88e57e5d40a4d329113', class: "event-list-item-container" }, hAsync("div", { key: '3a016426709b4abc7853bc67aeca4a3e11e5d6c1', class: "event-content" }, hAsync("slot", { key: 'c5cdf2b4a04834d540af8d8df19a8889ee6e0ffb' })), this.chevron && (hAsync("ix-icon", { key: '9646e270e1496247c2ab8223452eb76d2f9f902e', name: 'chevron-right', size: "16", class: "chevron-icon" }))))));
    }
    static get style() { return IxEventListItemStyle0; }
    static get cmpMeta() { return {
        "$flags$": 9,
        "$tagName$": "ix-event-list-item",
        "$members$": {
            "color": [1],
            "itemColor": [1, "item-color"],
            "selected": [4],
            "disabled": [4],
            "chevron": [4]
        },
        "$listeners$": [[1, "click", "handleItemClick"]],
        "$lazyBundleId$": "-",
        "$attrsToReflect$": []
    }; }
}

const expandingSearchCss = "/*!@.form-control,\n.form-control-plaintext*/.form-control.sc-ix-expanding-search,.form-control-plaintext.sc-ix-expanding-search{-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:0.875rem;font-weight:400;line-height:1.429em;color:var(--theme-color-std-text);color:var(--theme-input--color);overflow:hidden;text-overflow:ellipsis;white-space:nowrap;border-radius:var(--theme-input--border-radius);height:2rem;min-height:2rem;min-width:2rem;background-color:var(--theme-input--background);border:solid 1px var(--theme-input--border-color);box-shadow:var(--theme-input--box-shadow);padding-inline-start:0.5rem;padding-inline-end:0.5rem}/*!@.form-control::-moz-placeholder, .form-control-plaintext::-moz-placeholder*/.form-control.sc-ix-expanding-search::-moz-placeholder,.form-control-plaintext.sc-ix-expanding-search::-moz-placeholder{color:var(--theme-input-hint--color)}/*!@.form-control::placeholder,\n.form-control-plaintext::placeholder*/.form-control.sc-ix-expanding-search::placeholder,.form-control-plaintext.sc-ix-expanding-search::placeholder{color:var(--theme-input-hint--color)}/*!@.form-control:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled), .form-control-plaintext:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled)*/.form-control.sc-ix-expanding-search:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled),.form-control-plaintext.sc-ix-expanding-search:not(:-moz-read-only):not([readonly]):not([readOnly]):not(.readonly):not(.disabled):not(:disabled){cursor:pointer}/*!@.form-control:not(:read-only):not([readonly]):not([readOnl