import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { b as a11yHostAttributes } from './a11y.js';
import { m as makeRef } from './make-ref.js';
import { d as defineCustomElement$1 } from './typography.js';
import { c as createClassMutationObserver } from './validation.js';

function isIxInputFieldComponent(obj) {
    return (obj &&
        'getAssociatedFormElement' in obj &&
        typeof obj.getAssociatedFormElement === 'function' &&
        'getNativeInputElement' in obj &&
        typeof obj.getNativeInputElement === 'function');
}

const fieldLabelCss = ":host{display:inline-block;position:relative;margin-top:0.5rem;margin-bottom:0.25rem}";
const IxFieldLabelStyle0 = fieldLabelCss;

const FormFieldLabel = /*@__PURE__*/ proxyCustomElement(class FormFieldLabel extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.htmlForObserver = new MutationObserver(() => this.checkForInternalState());
        this.a11yAttributes = {};
        this.labelRef = makeRef();
        this.required = undefined;
        this.htmlFor = undefined;
        this.controlRef = undefined;
        this.isInvalid = false;
    }
    connectedCallback() {
        this.registerHtmlForObserver();
        this.registerControlRefObserver();
    }
    disconnectedCallback() {
        if (this.htmlForObserver) {
            this.htmlForObserver.disconnect();
        }
        if (this.htmlForClassObserver) {
            this.htmlForClassObserver.destroy();
        }
        if (this.controlRefClassObserver) {
            this.controlRefClassObserver.destroy();
        }
    }
    componentWillRender() {
        this.checkForInternalState();
    }
    componentWillLoad() {
        this.a11yAttributes = a11yHostAttributes(this.hostElement);
    }
    registerHtmlForObserver() {
        if (typeof window === 'undefined') {
            return;
        }
        if (this.htmlForObserver) {
            this.htmlForObserver.disconnect();
        }
        if (this.htmlFor) {
            this.htmlForObserver.observe(window.document, {
                childList: true,
                subtree: true,
            });
        }
    }
    async registerControlRefObserver() {
        if (typeof window === 'undefined') {
            return;
        }
        if (this.controlRefClassObserver) {
            this.controlRefClassObserver.destroy();
        }
        if (this.controlRef) {
            const input = await this.controlRef.waitForCurrent();
            this.controlRefClassObserver = createClassMutationObserver(input, () => this.checkForInvalidState(input));
        }
    }
    registerHtmlForClassObserver(forElement) {
        if (this.htmlForClassObserver) {
            this.htmlForClassObserver.destroy();
        }
        this.htmlForClassObserver = createClassMutationObserver(forElement, () => this.checkForInvalidState(forElement));
    }
    checkForInvalidState(elementToCheck) {
        this.isInvalid =
            elementToCheck.classList.contains('is-invalid') ||
                elementToCheck.classList.contains('ix-invalid');
    }
    async checkForInternalState() {
        if (this.htmlFor) {
            const forElement = document.getElementById(this.htmlFor);
            if (forElement) {
                if (typeof forElement.required === 'boolean') {
                    this.required = forElement.required;
                }
                this.registerHtmlForClassObserver(forElement);
                this.checkForInvalidState(forElement);
            }
        }
        if (this.controlRef) {
            const input = await this.controlRef.waitForCurrent();
            this.required = input.required;
        }
    }
    async focusOnClick() {
        if (this.htmlFor) {
            const target = document.getElementById(this.htmlFor);
            if (target) {
                let input = null;
                if (isIxInputFieldComponent(target)) {
                    input = await target.getNativeInputElement();
                }
                else {
                    input = target;
                }
                if (typeof input.focus === 'function') {
                    input.focus();
                }
            }
        }
        if (this.controlRef) {
            (await this.controlRef.waitForCurrent()).focus();
        }
    }
    render() {
        return (h(Host, { key: '3a62067a0af7847c578459a35bcbd56c54f59bf1', onClick: () => this.focusOnClick() }, h("label", Object.assign({ key: '05aea8c0c5783f8cffb9d3968f1621564203c2ac', htmlFor: this.htmlFor }, this.a11yAttributes, { ref: this.labelRef }), h("ix-typography", { key: '6285d1624065c691d9beb3a1c4c31268e0a6bde9', color: this.isInvalid ? 'alarm' : 'soft', format: "label" }, h("slot", { key: 'cc8185cb40bf055c6f2e29ee09265acc10719657' }), this.required && h("span", { key: 'b8c6191b6a0fd1314afd21d555268417292b1201' }, "\u00A0*")))));
    }
    get hostElement() { return this; }
    static get watchers() { return {
        "htmlFor": ["registerHtmlForObserver"],
        "controlRef": ["registerControlRefObserver"]
    }; }
    static get style() { return IxFieldLabelStyle0; }
}, [1, "ix-field-label", {
        "required": [1540],
        "htmlFor": [513, "html-for"],
        "controlRef": [16],
        "isInvalid": [1028, "is-invalid"]
    }, undefined, {
        "htmlFor": ["registerHtmlForObserver"],
        "controlRef": ["registerControlRefObserver"]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-field-label", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-field-label":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, FormFieldLabel);
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { FormFieldLabel as F, defineCustomElement as d };

//# sourceMappingURL=field-label.js.map