import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { m as makeRef } from './make-ref.js';
import { r as renderHelperText, h as hasAnyText } from './helper-text-util.js';
import { d as defineCustomElement$3 } from './field-label.js';
import { d as defineCustomElement$2 } from './tooltip.js';
import { d as defineCustomElement$1 } from './typography.js';

const fieldWrapperCss = ":host{display:flex;position:relative;flex-direction:column}:host .slot-wrapper{display:flex;position:relative;align-items:center;justify-content:flex-start;gap:0.25rem}:host .field-bottom,:host .field-top{display:flex;flex-direction:row;position:relative;justify-content:space-between;gap:1rem;width:-moz-min-content;width:min-content;min-width:100%}:host .field-bottom .bottom-right{margin-left:auto;margin-right:0px}:host .bottom-text{display:flex;position:relative;align-items:flex-start;justify-content:flex-start;gap:0.25rem;margin-right:0.25rem}:host .text-icon{margin:0.125rem}:host .text-icon.invalid{color:var(--theme-helper-icon--color--invalid)}:host .text-icon.info{color:var(--theme-helper-icon--color--info)}:host .text-icon.warning{color:var(--theme-helper-icon--color--warning)}:host .text-icon.valid{color:var(--theme-helper-icon--color--valid)}:host .bottom-text{margin-top:0.25rem;margin-bottom:0.25rem}";
const IxFieldWrapperStyle0 = fieldWrapperCss;

const FieldWrapper = /*@__PURE__*/ proxyCustomElement(class FieldWrapper extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.slotRef = makeRef();
        this.helperText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.showTextAsTooltip = false;
        this.required = false;
        this.htmlForLabel = undefined;
        this.controlRef = undefined;
    }
    render() {
        const textOptions = {
            invalidText: this.invalidText,
            isInvalid: this.isInvalid,
            isValid: this.isValid,
            validText: this.validText,
            isWarning: this.isWarning,
            warningText: this.warningText,
            isInfo: this.isInfo,
            infoText: this.infoText,
            helperText: this.helperText,
        };
        return (h(Host, { key: '3a1885ca13c1de17fdbb33eb6cde695cbdb3469e' }, this.label && (h("div", { key: '9e8c0a96fe7014feb6ac76473137183ba92e2ad1', class: "field-top" }, h("ix-field-label", { key: '923dec87ac02cf550400aba0bf929b95d8a271ed', required: this.required, htmlFor: this.htmlForLabel, controlRef: this.controlRef, isInvalid: this.isInvalid }, this.label))), h("div", { key: 'a6694ebd1d18d2411565960ff5f1e6ee900491e8', class: {
                'slot-wrapper': true,
            }, ref: this.slotRef }, h("slot", { key: '302fcd87bd9cba38a3057b9a6542dbaed9d16bbc' })), h("div", { key: '8f5c9836963e0df796388b8dac20db7289ea067e', class: 'field-bottom' }, !this.showTextAsTooltip && renderHelperText(textOptions), h("div", { key: '620bf3f6730971ee840744fce7b8a7de2d2f12a9', class: "bottom-right" }, h("slot", { key: '7cff3c8d8f550a88e4bccacf6b71547edb89b0a7', name: "bottom-right" }))), this.showTextAsTooltip === true && hasAnyText(textOptions) && (h("ix-tooltip", { key: '9041af539fd29c6fd2e8e3e4a00daa8e2c15ed22', for: this.slotRef.waitForCurrent(), showDelay: 500, placement: "bottom" }, renderHelperText(textOptions)))));
    }
    get hostElement() { return this; }
    static get style() { return IxFieldWrapperStyle0; }
}, [1, "ix-field-wrapper", {
        "helperText": [1, "helper-text"],
        "label": [1],
        "invalidText": [1, "invalid-text"],
        "validText": [1, "valid-text"],
        "infoText": [1, "info-text"],
        "warningText": [1, "warning-text"],
        "isInvalid": [4, "is-invalid"],
        "isValid": [4, "is-valid"],
        "isInfo": [4, "is-info"],
        "isWarning": [4, "is-warning"],
        "showTextAsTooltip": [4, "show-text-as-tooltip"],
        "required": [4],
        "htmlForLabel": [1, "html-for-label"],
        "controlRef": [16]
    }]);
function defineCustomElement() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-field-wrapper", "ix-field-label", "ix-tooltip", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-field-wrapper":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, FieldWrapper);
            }
            break;
        case "ix-field-label":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$1();
            }
            break;
    } });
}

export { FieldWrapper as F, defineCustomElement as d };

//# sourceMappingURL=field-wrapper.js.map