import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { H as HookValidationLifecycle } from './validation.js';
import { d as defineCustomElement$5 } from './field-label.js';
import { d as defineCustomElement$4 } from './field-wrapper.js';
import { d as defineCustomElement$3 } from './tooltip.js';
import { d as defineCustomElement$2 } from './typography.js';

const checkboxGroupCss = ":host{display:inline-block;position:relative}:host .checkbox-container{display:flex;flex-direction:column;gap:1rem;margin:0.375rem 0;flex-wrap:wrap}:host .checkbox-container.row-layout{flex-direction:row}";
const IxCheckboxGroupStyle0 = checkboxGroupCss;

var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
const CheckboxGroup = /*@__PURE__*/ proxyCustomElement(class CheckboxGroup extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.helperText = undefined;
        this.label = undefined;
        this.direction = 'column';
        this.invalidText = undefined;
        this.infoText = undefined;
        this.validText = undefined;
        this.warningText = undefined;
        this.showTextAsTooltip = false;
        this.isInvalid = false;
        this.isInfo = false;
        this.isValid = false;
        this.isWarning = false;
    }
    onClassFieldUpdate({ isInvalid, isInvalidByRequired, isInfo, isValid, isWarning, }) {
        this.isInvalid = isInvalid || isInvalidByRequired;
        this.isInfo = isInfo;
        this.isValid = isValid;
        this.isWarning = isWarning;
    }
    render() {
        return (h(Host, { key: '3b3403b167dbcd69cce94ece70070d6d4a633fd5' }, h("ix-field-wrapper", { key: '47692f7cadd2bf1798302f4854d0c16efca49dd4', label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, validText: this.validText, warningText: this.warningText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isInfo: this.isInfo, isValid: this.isValid, isWarning: this.isWarning }, h("div", { key: '82181467dda161e570576dd4644c5cc45584ac3a', class: {
                'checkbox-container': true,
                'row-layout': this.direction === 'row',
            } }, h("slot", { key: 'a1fe76fc0d07422227cddc9d8e2b51ef1894311a' })))));
    }
    get hostElement() { return this; }
    static get style() { return IxCheckboxGroupStyle0; }
}, [1, "ix-checkbox-group", {
        "helperText": [1, "helper-text"],
        "label": [1],
        "direction": [1],
        "invalidText": [1, "invalid-text"],
        "infoText": [1, "info-text"],
        "validText": [1, "valid-text"],
        "warningText": [1, "warning-text"],
        "showTextAsTooltip": [4, "show-text-as-tooltip"],
        "isInvalid": [32],
        "isInfo": [32],
        "isValid": [32],
        "isWarning": [32]
    }]);
__decorate([
    HookValidationLifecycle({
        includeChildren: true,
    })
], CheckboxGroup.prototype, "onClassFieldUpdate", null);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-checkbox-group", "ix-field-label", "ix-field-wrapper", "ix-tooltip", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-checkbox-group":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, CheckboxGroup);
            }
            break;
        case "ix-field-label":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-field-wrapper":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxCheckboxGroup = CheckboxGroup;
const defineCustomElement = defineCustomElement$1;

export { IxCheckboxGroup, defineCustomElement };

//# sourceMappingURL=ix-checkbox-group.js.map