import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$4 } from './icon-button.js';
import { d as defineCustomElement$3 } from './spinner.js';
import { d as defineCustomElement$2 } from './typography.js';

const contentHeaderCss = ":host{display:flex;flex-direction:row;align-items:flex-start;padding:0}:host .titleGroup{display:flex;flex-direction:column;flex:1 1 0}:host .titleGroup .secondary{padding:0.25rem 0}:host .subtitle{margin-top:-0.125rem}:host .backButton{margin-right:0.5rem}:host .buttons{flex:0 0 auto}";
const IxContentHeaderStyle0 = contentHeaderCss;

const ContentHeader = /*@__PURE__*/ proxyCustomElement(class ContentHeader extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.backButtonClick = createEvent(this, "backButtonClick", 7);
        this.variant = 'primary';
        this.headerTitle = undefined;
        this.headerSubtitle = undefined;
        this.hasBackButton = false;
    }
    render() {
        return (h(Host, { key: '05d59f8a62e29a886537cd2249a91cbaca560a42' }, this.hasBackButton ? (h("ix-icon-button", { class: 'backButton', variant: "primary", icon: 'arrow-left', ghost: true, onClick: () => this.backButtonClick.emit() })) : null, h("div", { key: 'eb02e3fc080a29379290e77b5db2049f77c990cb', class: "titleGroup" }, h("ix-typography", { key: 'de9edd86198e18414247d584f7cdb0f1e98243a3', format: this.variant === 'secondary' ? 'h4' : 'h3', class: this.variant === 'secondary' ? 'secondary' : '' }, this.headerTitle), !!this.headerSubtitle && (h("ix-typography", { key: 'debacfac59173251d1a53dda88cba8d96021e78e', format: 'h6', color: 'soft', class: this.variant === 'secondary' ? 'subtitle' : '' }, this.headerSubtitle))), h("div", { key: '1726ad1632965b087a49052c698ddea09dd38017', class: "buttons" }, h("slot", { key: 'bc275ead0f7e070a60dfb5c94fbc786fdda36fc3' }))));
    }
    static get style() { return IxContentHeaderStyle0; }
}, [1, "ix-content-header", {
        "variant": [1],
        "headerTitle": [1, "header-title"],
        "headerSubtitle": [1, "header-subtitle"],
        "hasBackButton": [4, "has-back-button"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-content-header", "ix-icon-button", "ix-spinner", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-content-header":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, ContentHeader);
            }
            break;
        case "ix-icon-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-spinner":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxContentHeader = ContentHeader;
const defineCustomElement = defineCustomElement$1;

export { IxContentHeader, defineCustomElement };

//# sourceMappingURL=ix-content-header.js.map