import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { H as HookValidationLifecycle } from './validation.js';
import { d as defineCustomElement$5 } from './field-label.js';
import { d as defineCustomElement$4 } from './field-wrapper.js';
import { d as defineCustomElement$3 } from './tooltip.js';
import { d as defineCustomElement$2 } from './typography.js';

const customFieldCss = ":host{display:block;width:-moz-fit-content;width:fit-content;height:-moz-fit-content;height:fit-content}";
const IxCustomFieldStyle0 = customFieldCss;

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
const CustomField = /*@__PURE__*/ proxyCustomElement(class CustomField extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.required = false;
        this.label = undefined;
        this.helperText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.showTextAsTooltip = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
    }
    updateValidationState({ isInvalid, isValid, isInfo, isWarning, }) {
        this.isInvalid = isInvalid;
        this.isValid = isValid;
        this.isInfo = isInfo;
        this.isWarning = isWarning;
    }
    render() {
        return (h(Host, { key: 'ee9ed8e36ffa3f55295e0e4fda3d2b1acb90c2e3' }, h("ix-field-wrapper", { key: '19cfaca80d58b6aa2b9d8a29e33777f4be9b238a', label: this.label, helperText: this.helperText, infoText: this.infoText, warningText: this.warningText, invalidText: this.invalidText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, required: this.required }, h("slot", { key: 'b3e5d6efbfa3279de1e0ffe2d9322ac14c985911' }))));
    }
    get hostElement() { return this; }
    static get style() { return IxCustomFieldStyle0; }
}, [1, "ix-custom-field", {
        "required": [4],
        "label": [1],
        "helperText": [1, "helper-text"],
        "infoText": [1, "info-text"],
        "warningText": [1, "warning-text"],
        "invalidText": [1, "invalid-text"],
        "validText": [1, "valid-text"],
        "showTextAsTooltip": [4, "show-text-as-tooltip"],
        "isInvalid": [32],
        "isValid": [32],
        "isInfo": [32],
        "isWarning": [32]
    }]);
__decorate([
    HookValidationLifecycle({
        includeChildren: true,
    })
], CustomField.prototype, "updateValidationState", null);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-custom-field", "ix-field-label", "ix-field-wrapper", "ix-tooltip", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-custom-field":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, CustomField);
            }
            break;
        case "ix-field-label":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-field-wrapper":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-tooltip":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxCustomField = CustomField;
const defineCustomElement = defineCustomElement$1;

export { IxCustomField, defineCustomElement };

//# sourceMappingURL=ix-custom-field.js.map