import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { c as createMutationObserver } from './mutation-observer.js';
import { h as hasSlottedElements } from './shadow-dom.js';
import { d as defineCustomElement$5 } from './group-context-menu.js';
import { d as defineCustomElement$4 } from './group-item.js';
import { d as defineCustomElement$3 } from './icon-button.js';
import { d as defineCustomElement$2 } from './spinner.js';

const groupCss = ":host{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;flex-direction:column;position:relative;width:19.75rem;min-width:12rem;border-color:var(--theme-group-item--border-color)}:host .group-header{height:4rem;min-height:4rem;max-height:4rem;border-radius:var(--theme-group--border-radius) var(--theme-group--border-radius) 0 0;display:flex;background-color:var(--theme-group-item--background);color:var(--theme-group-header--color);cursor:pointer}:host .group-header:not(.disabled):not(:disabled){cursor:pointer}:host .group-header:not(.disabled):not(:disabled):hover{background-color:var(--theme-group-item--background--hover)}:host .group-header:not(.disabled):not(:disabled):hover.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header:not(.disabled):not(:disabled){cursor:pointer}:host .group-header:not(.disabled):not(:disabled):active,:host .group-header:not(.disabled):not(:disabled).active{background-color:var(--theme-group-item--background--active)}:host .group-header:not(.disabled):not(:disabled):active.selected,:host .group-header:not(.disabled):not(:disabled).active.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header:not(.disabled):not(:disabled):focus-visible{border:1px solid var(--theme-color-focus-bdr);border-radius:var(--theme-default-border-radius) var(--theme-default-border-radius) 0px 0px;outline:none}:host .group-header.selected{background-color:var(--theme-group-item--background--selected)}:host .group-header.selected .group-header-selection-indicator{background-color:var(--theme-group-item-indicator--background--selected)}:host .group-header .group-header-selection-indicator{background-color:var(--theme-color-input--focus)}:host .group-header .group-header-selection-indicator.group-header-selection-indicator-item-selected{background-color:var(--theme-group-item-indicator--background--selected)}:host .group-header-clickable{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;width:100%;min-width:0}:host .group-header-selection-indicator{width:0.25rem;border-top-left-radius:var(--theme-group--border-radius)}:host .group-header-content{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;display:flex;flex-direction:row;justify-content:space-between;min-width:0;flex-grow:1;flex-basis:0;padding:0.5rem;padding-left:0}:host .group-header-content .group-header-props-container{width:100%}:host .group-header-content .group-header-title{display:flex;align-items:center;font-size:1rem;font-weight:700;height:1.5rem}:host .group-header-content .group-header-title>*{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;min-width:0;padding-right:0}:host .group-header-content .group-subheader{overflow:hidden;text-overflow:ellipsis;white-space:nowrap;height:1.25rem;font-size:0.875rem;color:var(--theme-group-subheader--color)}:host .expand-icon{padding:0.125rem 0.437rem;color:var(--theme-color-std-text)}:host .btn-expand-header{margin:0.5rem;margin-inline-end:0.25rem;min-width:1.5rem}:host .group-content{display:flex;flex-direction:column;gap:1px;margin-top:1px}:host .footer{visibility:collapse;height:auto;min-height:0}:host .footer-visible{visibility:visible}:host .hidden{display:none}";
const IxGroupStyle0 = groupCss;

const Group = /*@__PURE__*/ proxyCustomElement(class Group extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.selectGroup = createEvent(this, "selectGroup", 7);
        this.selectItem = createEvent(this, "selectItem", 7);
        this.collapsedChanged = createEvent(this, "collapsedChanged", 7);
        this.observer = null;
        this.suppressHeaderSelection = false;
        this.header = undefined;
        this.subHeader = undefined;
        this.collapsed = true;
        this.selected = false;
        this.index = undefined;
        this.expandOnHeaderClick = false;
        this.itemSelected = false;
        this.slotSize = this.groupItems.length;
        this.footerVisible = false;
        this.showExpandCollapsedIcon = false;
    }
    selectedChanged(newSelected) {
        if (newSelected === false) {
            this.changeItemIndex();
        }
    }
    get dropdownItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-group-dropdown-item'));
    }
    get groupItems() {
        return Array.from(this.hostElement.querySelectorAll('ix-group-item:not(.footer)'));
    }
    get groupContent() {
        var _a;
        return (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('.group-content');
    }
    onExpandClick(event) {
        const oldCollapsed = this.collapsed;
        this.collapsed = !this.collapsed;
        const { defaultPrevented } = this.collapsedChanged.emit(this.collapsed);
        event.stopPropagation();
        if (defaultPrevented) {
            this.collapsed = oldCollapsed;
        }
    }
    onHeaderClick(event) {
        if (this.suppressHeaderSelection) {
            this.onExpandClick(event);
            return;
        }
        this.changeHeaderSelection(!this.selected);
        this.changeItemIndex();
    }
    changeHeaderSelection(newSelection) {
        const oldIsHeaderSelected = this.selected;
        const newIsHeaderSelected = newSelection;
        this.selected = newIsHeaderSelected;
        const { defaultPrevented } = this.selectGroup.emit(newIsHeaderSelected);
        if (defaultPrevented) {
            this.selected = oldIsHeaderSelected;
            return;
        }
    }
    changeItemIndex(index) {
        const oldIndex = this.index;
        const newIndex = index === this.index ? undefined : index;
        if (this.index === newIndex) {
            return;
        }
        this.index = newIndex;
        const { defaultPrevented } = this.selectItem.emit(newIndex);
        if (defaultPrevented) {
            this.index = oldIndex;
            return;
        }
        const items = this.groupItems;
        items.forEach((item, i) => {
            item.selected = i === this.index;
        });
        this.itemSelected = items.some((item) => item.selected);
    }
    onSlotChange() {
        var _a;
        const slot = (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('slot[name="footer"]');
        if (slot) {
            this.footerVisible = hasSlottedElements(slot);
        }
    }
    componentWillRender() {
        this.groupItems.forEach((item, index) => {
            item.selected = index === this.index;
            item.index = index;
        });
    }
    componentDidLoad() {
        this.observer = createMutationObserver(() => {
            this.slotSize = this.groupItems.length;
        });
        if (!this.groupContent) {
            return;
        }
        this.observer.observe(this.groupContent, {
            childList: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    onItemClicked(event) {
        if (event.target instanceof HTMLElement) {
            const item = event.target;
            const index = this.groupItems.indexOf(item);
            this.changeItemIndex(index);
        }
    }
    render() {
        return (h(Host, { key: 'e3dc08bdd081992f3e104d2694289cffdd00e2d5' }, h("div", { key: 'dd9ae49a4772bca8c59b7dd30ae51bbfcf28e67a', class: {
                'group-header': true,
                expand: !this.collapsed,
                selected: this.selected,
            }, tabindex: "0" }, h("div", { key: 'bdd3e57474c382203ac92130db6aac7e5a091088', class: "group-header-clickable", onClick: (e) => this.onHeaderClick(e) }, h("div", { key: 'c53eeccfc402a6376b6ecd1130355428850af59b', class: {
                'group-header-selection-indicator': true,
                'group-header-selection-indicator-item-selected': this.itemSelected,
            } }), h("div", { key: 'f45b5cb472ac2842093e117eddebaa9f31cf4105', class: "btn-expand-header" }, h("ix-icon", { key: '50132cef721b918beacb9c94d6eb3536d8a35f56', "data-testid": "expand-collapsed-icon", class: {
                hidden: !this.showExpandCollapsedIcon,
            }, name: this.collapsed ? 'chevron-right-small' : 'chevron-down-small', onClick: (e) => this.onExpandClick(e) })), h("div", { key: '274809a5b36d4a53aac997179490e61611b615e7', class: "group-header-content" }, this.header ? (h("div", { class: "group-header-props-container" }, h("div", { class: "group-header-title" }, h("span", { title: this.header }, this.header)), h("div", { class: "group-subheader", title: this.subHeader }, this.subHeader))) : null, h("slot", { key: '3d0437fc04c0153e5df963cd90372f18e2b26446', name: "header" }))), h("ix-group-context-menu", { key: '2de378c24367eeca11a58946021fad53f5b8dc81' }, h("slot", { key: '4a46b76d48333986d6ee3b76278fc7b4bb1c3242', name: "dropdown" }))), h("div", { key: '5fc1aa340e95af877901c53c2546fe094017da89', class: {
                'group-content': true,
            } }, h("div", { key: '7ba0a9e6189940dc954ce8d2a2727b1afcf73b92', style: {
                display: this.collapsed ? 'none' : 'contents',
            } }, h("slot", { key: '980f2fd4380a6921e1ce6a5a601b255bd816ef7c', onSlotchange: () => {
                var _a;
                const slot = (_a = this.hostElement.shadowRoot) === null || _a === void 0 ? void 0 : _a.querySelector('slot:not([name])');
                this.showExpandCollapsedIcon = hasSlottedElements(slot);
            } }), h("ix-group-item", { key: '0d9ecd669ba5f14d219578289853b91133c4dc43', suppressSelection: true, focusable: false, class: {
                footer: true,
                'footer-visible': this.footerVisible,
            } }, h("slot", { key: '29d5b1440855ad87320fa79c60657f2b4c6e6a0c', name: "footer", onSlotchange: () => this.onSlotChange() }))))));
    }
    get hostElement() { return this; }
    static get watchers() { return {
        "selected": ["selectedChanged"]
    }; }
    static get style() { return IxGroupStyle0; }
}, [1, "ix-group", {
        "suppressHeaderSelection": [4, "suppress-header-selection"],
        "header": [1],
        "subHeader": [1, "sub-header"],
        "collapsed": [1540],
        "selected": [1540],
        "index": [1538],
        "expandOnHeaderClick": [4, "expand-on-header-click"],
        "itemSelected": [32],
        "slotSize": [32],
        "footerVisible": [32],
        "showExpandCollapsedIcon": [32]
    }, [[0, "selectedChanged", "onItemClicked"]], {
        "selected": ["selectedChanged"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-group", "ix-group-context-menu", "ix-group-item", "ix-icon-button", "ix-spinner"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-group":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Group);
            }
            break;
        case "ix-group-context-menu":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-group-item":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-icon-button":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-spinner":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxGroup = Group;
const defineCustomElement = defineCustomElement$1;

export { IxGroup, defineCustomElement };

//# sourceMappingURL=ix-group.js.map