import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { c as createClassMutationObserver, a as checkFieldClasses } from './validation.js';
import { r as renderHelperText } from './helper-text-util.js';
import { d as defineCustomElement$2 } from './typography.js';

const helperTextCss = ":host{display:block}:host .bottom-text{display:flex;position:relative;align-items:flex-start;justify-content:flex-start;gap:0.25rem;margin-right:0.25rem}:host .text-icon{margin:0.125rem}:host .text-icon.invalid{color:var(--theme-helper-icon--color--invalid)}:host .text-icon.info{color:var(--theme-helper-icon--color--info)}:host .text-icon.warning{color:var(--theme-helper-icon--color--warning)}:host .text-icon.valid{color:var(--theme-helper-icon--color--valid)}";
const IxHelperTextStyle0 = helperTextCss;

const HelperText = /*@__PURE__*/ proxyCustomElement(class HelperText extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.observer = new MutationObserver(() => this.checkForRequired());
        this.htmlFor = undefined;
        this.helperText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.validationResults = {
            isInfo: false,
            isInvalid: false,
            isValid: false,
            isWarning: false,
            isInvalidByRequired: false,
        };
    }
    connectedCallback() {
        this.observer.observe(window.document, {
            childList: true,
            subtree: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    componentWillRender() {
        this.checkForRequired();
    }
    async checkForRequired() {
        if (!this.htmlFor) {
            return;
        }
        const forElement = document.getElementById(this.htmlFor);
        if (!forElement) {
            return;
        }
        if (this.classObserver) {
            this.classObserver.destroy();
        }
        this.classObserver = createClassMutationObserver(forElement, () => {
            this.validationResults = checkFieldClasses(forElement);
        });
        this.validationResults = checkFieldClasses(forElement);
    }
    render() {
        return (h(Host, { key: 'a15c6af1db5a3723e8f2facd899a513c56f034af' }, renderHelperText(Object.assign({ helperText: this.helperText, invalidText: this.invalidText, validText: this.validText, infoText: this.infoText, warningText: this.warningText }, this.validationResults))));
    }
    get hostElement() { return this; }
    static get style() { return IxHelperTextStyle0; }
}, [1, "ix-helper-text", {
        "htmlFor": [1, "html-for"],
        "helperText": [1, "helper-text"],
        "invalidText": [1, "invalid-text"],
        "validText": [1, "valid-text"],
        "infoText": [1, "info-text"],
        "warningText": [1, "warning-text"],
        "validationResults": [32]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-helper-text", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-helper-text":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, HelperText);
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxHelperText = HelperText;
const defineCustomElement = defineCustomElement$1;

export { IxHelperText, defineCustomElement };

//# sourceMappingURL=ix-helper-text.js.map