import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const layoutAutoCss = ":host{display:block;position:relative;margin:0 0.75rem;--ix-layout-grid-gap:1.5rem}:host .container{display:flex;align-items:stretch;flex-wrap:wrap;gap:var(--ix-layout-grid-gap)}:host ::slotted(*){flex-grow:0;flex-shrink:0}";
const IxLayoutAutoStyle0 = layoutAutoCss;

const LayoutForm = /*@__PURE__*/ proxyCustomElement(class LayoutForm extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.mediaQueryList = [];
        this.observer = new MutationObserver(() => this.calculateGridTemplateColumns());
        this.resizeObserver = new ResizeObserver(() => {
            this.calculateGridTemplateColumns();
        });
        this.layout = [
            { minWidth: '0', columns: 1 },
            { minWidth: '48em', columns: 2 },
        ];
    }
    connectedCallback() {
        this.observer.observe(this.hostElement, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['data-colspan'],
        });
        this.resizeObserver.observe(this.hostElement);
        this.calculateGridTemplateColumns();
    }
    componentWillLoad() {
        this.calculateGridTemplateColumns();
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
        if (this.resizeObserver) {
            this.resizeObserver.disconnect();
        }
    }
    updateMediaQueryList() {
        this.mediaQueryList = [];
        this.layout.forEach((layout) => {
            const mediaQuery = window.matchMedia(`(min-width: ${layout.minWidth})`);
            this.mediaQueryList.push({
                mediaQuery,
                layout,
            });
        });
    }
    parseNumber(number) {
        if (!number) {
            return 1;
        }
        const result = parseInt(number);
        if (isNaN(result)) {
            return 1;
        }
        return result;
    }
    calculateGridTemplateColumns() {
        this.updateMediaQueryList();
        let layoutColumns = 1;
        let columnSpacing = 'var(--ix-layout-grid-gap)';
        this.mediaQueryList.forEach((mediaQuery) => {
            if (mediaQuery.mediaQuery.matches) {
                layoutColumns = mediaQuery.layout.columns;
            }
        });
        Array.from(this.hostElement.children).forEach((child) => {
            let colspan = this.parseNumber(child.getAttribute('data-colspan'));
            colspan = Math.min(colspan, layoutColumns);
            const childRatio = colspan / layoutColumns;
            child.style.width = `calc(${childRatio * 99.9}% - ${1 - childRatio} * ${columnSpacing})`;
        });
    }
    render() {
        return (h(Host, { key: '0dd50d7088ab95ce631e5d3888055691b0499e81' }, h("div", { key: '4fd6fb7902a4fbe3232178bf260dd7fe2babdf4b', class: "container" }, h("slot", { key: '4548597f8071865d8203100a0ecbdc5fcab91293' }))));
    }
    get hostElement() { return this; }
    static get watchers() { return {
        "layout": ["updateMediaQueryList"]
    }; }
    static get style() { return IxLayoutAutoStyle0; }
}, [1, "ix-layout-auto", {
        "layout": [16]
    }, undefined, {
        "layout": ["updateMediaQueryList"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-layout-auto"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-layout-auto":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, LayoutForm);
            }
            break;
    } });
}

const IxLayoutAuto = LayoutForm;
const defineCustomElement = defineCustomElement$1;

export { IxLayoutAuto, defineCustomElement };

//# sourceMappingURL=ix-layout-auto.js.map