import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$6 } from './card.js';
import { d as defineCustomElement$5 } from './card-accordion.js';
import { d as defineCustomElement$4 } from './card-content.js';
import { d as defineCustomElement$3 } from './card-title.js';
import { d as defineCustomElement$2 } from './typography.js';

const pushCardCss = ":host{display:block;position:relative}:host .icon{transform:scale(1.25)}:host .notification{font-size:40px}:host ix-card-content{height:11rem}";
const IxPushCardStyle0 = pushCardCss;

const PushCard = /*@__PURE__*/ proxyCustomElement(class PushCard extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.icon = undefined;
        this.notification = undefined;
        this.heading = undefined;
        this.subheading = undefined;
        this.variant = 'insight';
        this.collapse = true;
    }
    render() {
        var _a;
        const color = this.variant === 'insight' || this.variant === 'notification'
            ? 'std'
            : undefined;
        return (h(Host, { key: '4927262c7896d5db2eb939fa8337ebadb6774229' }, h("ix-card", { key: '03336f0cc37dde84b0a00ac7fd3eab26258e2ac5', variant: this.variant }, h("ix-card-content", { key: '362537f589ab27e6a2a2ac4e732e384b2f08bb52' }, h("ix-card-title", { key: 'df79854b0f6b160938c5cb8111cb68e049dc2a21' }, this.icon ? (h("ix-icon", { class: 'icon', name: this.icon, size: "32" })) : null, h("span", { key: '96a30b27bd3479dccc86974a0c356cc20db07952', class: 'notification' }, (_a = this.notification) !== null && _a !== void 0 ? _a : 0), h("slot", { key: '8c5a4c60df7d7b8785bbb71ea121d9966b531b6f', name: "title-action" })), h("ix-typography", { key: '193883ef7009f3f5b28505333ad4457f9a76bf24', color: color, format: "h4" }, this.heading), h("ix-typography", { key: '1695ab207b51d282b96311b08fd0f1dc01daac36', color: color }, this.subheading)), h("ix-card-accordion", { key: 'ae91fcfe96e7d56e47d6f4579c11e959ceb84f5f', collapse: this.collapse }, h("slot", { key: 'f51b6187302421c78a9a81085609b5f96f6017d4' })))));
    }
    static get style() { return IxPushCardStyle0; }
}, [1, "ix-push-card", {
        "icon": [1],
        "notification": [1],
        "heading": [1],
        "subheading": [1],
        "variant": [1],
        "collapse": [4]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-push-card", "ix-card", "ix-card-accordion", "ix-card-content", "ix-card-title", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-push-card":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, PushCard);
            }
            break;
        case "ix-card":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ix-card-accordion":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-card-content":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-card-title":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxPushCard = PushCard;
const defineCustomElement = defineCustomElement$1;

export { IxPushCard, defineCustomElement };

//# sourceMappingURL=ix-push-card.js.map