import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const tileCss = ":host{min-width:11.937rem;max-width:11.937rem;width:11.937rem;display:flex;flex-direction:column;border:1px solid var(--theme-tile--border);border-radius:var(--theme-tile--border-radius);background-color:var(--theme-color-2);color:var(--theme-color-std-text);box-shadow:var(--theme-tile--box-shadow)}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .tile-header{display:flex;align-items:center;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:1rem;font-weight:700;line-height:1.5em;color:var(--theme-color-std-text)}:host .tile-header,:host .tile-subheader,:host .tile-content,:host .tile-footer{padding:0 1rem}:host .tile-header,:host .tile-content{flex-grow:1}:host .tile-header.has-content{display:flex;height:2.5rem;max-height:2.5rem;padding-inline-end:0.5rem}:host .tile-subheader{color:var(--theme-btn-invisible-secondary--color);flex-grow:0}:host .tile-footer.has-content{border-block-start:1px solid var(--theme-color-1);height:2.5rem}:host(.tile-small){height:2.5rem;min-height:2.5rem;max-height:2.5rem}:host(.tile-medium){height:5rem;min-height:5rem;max-height:5rem}:host(.tile-big){height:10rem;min-height:10rem;max-height:10rem}:host(:active),:host(:focus-visible),:host(:visited){outline:none}";
const IxTileStyle0 = tileCss;

const Tile = /*@__PURE__*/ proxyCustomElement(class Tile extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.size = 'medium';
        this.hasHeaderSlot = false;
        this.hasFooterSlot = false;
    }
    handleHeaderSlotChange() {
        this.hasHeaderSlot = !!this.hostElement.querySelector('[slot="header"]');
    }
    handleFooterSlotChange() {
        this.hasFooterSlot = !!this.hostElement.querySelector('[slot="footer"]');
    }
    render() {
        return (h(Host, { key: 'cfc8d6668c5811b204b3e29c007a91f1212ef898', class: {
                'tile-small': this.size === 'small',
                'tile-medium': this.size === 'medium',
                'tile-big': this.size === 'big',
            } }, h("div", { key: 'babc111307d12495e85df1082ba80bc4220141c1', class: {
                'tile-header': true,
                'has-content': this.hasHeaderSlot,
            } }, h("slot", { key: 'e5b3867c6f6b84c2c79cde4e6fa172c9b8f9aece', name: "header", onSlotchange: () => this.handleHeaderSlotChange() })), h("div", { key: '34c3a63614c9dd0197fb8887c7225bd52d8f782b', class: "tile-subheader" }, h("slot", { key: 'f45955002e2cc973b0f71c3ce23152d4bb1ed6f2', name: "subheader" })), h("div", { key: '1bb7411eb62e7f43718b7912efc951ab49795f0d', class: "tile-content" }, h("slot", { key: '84961331ba612b39b157bb455a99187a57fa941d' })), h("div", { key: '55154883296f5d07df9fc45e554980c6bb40d8a0', class: {
                'tile-footer': true,
                'has-content': this.hasFooterSlot,
            } }, h("slot", { key: '22449cad3f6068f16555c82bb20d6cf87e76f143', name: "footer", onSlotchange: () => this.handleFooterSlotChange() }))));
    }
    get hostElement() { return this; }
    static get style() { return IxTileStyle0; }
}, [1, "ix-tile", {
        "size": [1],
        "hasHeaderSlot": [32],
        "hasFooterSlot": [32]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-tile"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-tile":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Tile);
            }
            break;
    } });
}

const IxTile = Tile;
const defineCustomElement = defineCustomElement$1;

export { IxTile, defineCustomElement };

//# sourceMappingURL=ix-tile.js.map