import { proxyCustomElement, HTMLElement, createEvent, h, Host, Fragment } from '@stencil/core/internal/client';
import { a as a11yBoolean } from './a11y.js';

const toggleCss = ":host{display:inline-flex;position:relative;height:2rem;justify-content:flex-start;align-items:center;margin-right:0.25rem;cursor:pointer}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .switch{position:relative;display:inline-block;width:3rem;min-width:3rem;max-width:3rem;height:1.5rem;margin-right:0.25rem}:host .switch input{opacity:0;width:0;height:0}:host .slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background-color:var(--theme-switch-off--background);transition:var(--theme-default-time);border-radius:1.5rem;border:1px solid transparent}:host .slider:before{position:absolute;content:\"\";height:1.125rem;width:1.125rem;left:4px;bottom:2px;background-color:var(--theme-switch-thumb-off--background);transition:var(--theme-default-time);border-radius:50%}:host input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}:host input:focus-visible+.switch>.slider{outline:1px solid var(--theme-color-focus-bdr);outline-offset:1px}:host input:checked+.switch>.slider::before{background-color:var(--theme-switch-thumb-on--background);transform:translateX(1.35rem)}:host input+.switch>.slider{border-color:var(--theme-switch-off--border-color)}:host input+.switch:hover>.slider{background-color:var(--theme-switch-off--background--hover);border-color:var(--theme-switch-off--border-color--hover)}:host input+.switch:hover>.slider:before{background-color:var(--theme-switch-thumb-off--background--hover)}:host input+.switch:active>.slider{background-color:var(--theme-switch-off--background--active);border-color:var(--theme-switch-off--border-color--active)}:host input+.switch:active>.slider:before{background-color:var(--theme-switch-thumb-off--background--active)}:host input:checked+.switch>.slider{background-color:var(--theme-switch-on--background);border-color:var(--theme-switch-on--border-color)}:host input:checked+.switch:hover>.slider{background-color:var(--theme-switch-on--background--hover);border-color:var(--theme-switch-on--border-color--hover)}:host input:checked+.switch:hover>.slider:before{background-color:var(--theme-switch-thumb-on--background--hover)}:host input:checked+.switch:active>.slider{background-color:var(--theme-switch-on--background--active);border-color:var(--theme-switch-on--border-color--active)}:host input:checked+.switch:active>.slider:before{background-color:var(--theme-switch-thumb-on--background--active)}:host input:indeterminate+.switch>.slider::before{transform:translateX(0.7rem)}:host .toggle-text{overflow:hidden;white-space:nowrap;text-overflow:ellipsis}:host(.disabled){pointer-events:none}:host(.disabled) input+.switch{opacity:0.5}:host(.disabled) input+.switch>.slider{background-color:var(--theme-switch-off--background--disabled)}:host(.disabled) input+.switch>.slider:before{background-color:var(--theme-switch-thumb-off--background--disabled)}:host(.disabled) input:checked+.switch>.slider{background-color:var(--theme-switch-on--background--disabled)}:host(.disabled) input:checked+.switch>.slider:before{background-color:var(--theme-switch-thumb-on--background--disabled)}:host(.disabled) .toggle-text{color:var(--theme-color-weak-text)}:host(.ix-info:not(.disabled)) .slider{--theme-switch-off--background:var(--theme-switch-off--background--info);--theme-switch-off--background--hover:var(--theme-switch-off--background--info--hover);--theme-switch-off--background--active:var(--theme-switch-off--background--info--active);--theme-switch-thumb-off--background:var(--theme-switch-thumb-off--background--info);--theme-switch-thumb-off--background--hover:var(--theme-switch-thumb-off--background--info--hover);--theme-switch-thumb-off--background--active:var(--theme-switch-thumb-off--background--info--active);--theme-switch-off--border-color:var(--theme-switch-off--border-color--info);--theme-switch-off--border-color--hover:var(--theme-switch-off--border-color--info--hover);--theme-switch-off--border-color--active:var(--theme-switch-off--border-color--info--active);--theme-switch-on--background:var(--theme-switch-on--background--info);--theme-switch-on--background--hover:var(--theme-switch-on--background--info--hover);--theme-switch-on--background--active:var(--theme-switch-on--background--info--active);--theme-switch-thumb-on--background:var(--theme-switch-thumb-on--background--info);--theme-switch-thumb-on--background--hover:var(--theme-switch-thumb-on--background--info--hover);--theme-switch-thumb-on--background--active:var(--theme-switch-thumb-on--background--info--active);--theme-switch-on--border-color:var(--theme-switch-on--border-color--info);--theme-switch-on--border-color--hover:var(--theme-switch-on--border-color--info--hover);--theme-switch-on--border-color--active:var(--theme-switch-on--border-color--info--active);--theme-switch-mixed--background:var(--theme-switch-mixed--background--info);--theme-switch-mixed--background--hover:var(--theme-switch-mixed--background--info--hover);--theme-switch-mixed--background--active:var(--theme-switch-mixed--background--info--active);--theme-switch-thumb-mixed--background:var(--theme-switch-thumb-mixed--background--info);--theme-switch-thumb-mixed--background--hover:var(--theme-switch-thumb-mixed--background--info--hover);--theme-switch-thumb-mixed--background--active:var(--theme-switch-thumb-mixed--background--info--active);--theme-switch-mixed--border-color:var(--theme-switch-mixed--border-color--info);--theme-switch-mixed--border-color--hover:var(--theme-switch-mixed--border-color--info--hover);--theme-switch-mixed--border-color--active:var(--theme-switch-mixed--border-color--info--active)}:host(.ix-warning:not(.disabled)) .slider{--theme-switch-off--background:var(--theme-switch-off--background--warning);--theme-switch-off--background--hover:var(--theme-switch-off--background--warning--hover);--theme-switch-off--background--active:var(--theme-switch-off--background--warning--active);--theme-switch-thumb-off--background:var(--theme-switch-thumb-off--background--warning);--theme-switch-thumb-off--background--hover:var(--theme-switch-thumb-off--background--warning--hover);--theme-switch-thumb-off--background--active:var(--theme-switch-thumb-off--background--warning--active);--theme-switch-off--border-color:var(--theme-switch-off--border-color--warning);--theme-switch-off--border-color--hover:var(--theme-switch-off--border-color--warning--hover);--theme-switch-off--border-color--active:var(--theme-switch-off--border-color--warning--active);--theme-switch-on--background:var(--theme-switch-on--background--warning);--theme-switch-on--background--hover:var(--theme-switch-on--background--warning--hover);--theme-switch-on--background--active:var(--theme-switch-on--background--warning--active);--theme-switch-thumb-on--background:var(--theme-switch-thumb-on--background--warning);--theme-switch-thumb-on--background--hover:var(--theme-switch-thumb-on--background--warning--hover);--theme-switch-thumb-on--background--active:var(--theme-switch-thumb-on--background--warning--active);--theme-switch-on--border-color:var(--theme-switch-on--border-color--warning);--theme-switch-on--border-color--hover:var(--theme-switch-on--border-color--warning--hover);--theme-switch-on--border-color--active:var(--theme-switch-on--border-color--warning--active);--theme-switch-mixed--background:var(--theme-switch-mixed--background--warning);--theme-switch-mixed--background--hover:var(--theme-switch-mixed--background--warning--hover);--theme-switch-mixed--background--active:var(--theme-switch-mixed--background--warning--active);--theme-switch-thumb-mixed--background:var(--theme-switch-thumb-mixed--background--warning);--theme-switch-thumb-mixed--background--hover:var(--theme-switch-thumb-mixed--background--warning--hover);--theme-switch-thumb-mixed--background--active:var(--theme-switch-thumb-mixed--background--warning--active);--theme-switch-mixed--border-color:var(--theme-switch-mixed--border-color--warning);--theme-switch-mixed--border-color--hover:var(--theme-switch-mixed--border-color--warning--hover);--theme-switch-mixed--border-color--active:var(--theme-switch-mixed--border-color--warning--active)}:host(.ix-invalid--required:not(.disabled)) .slider{--theme-switch-off--background:var(--theme-switch-off--background--invalid);--theme-switch-off--background--hover:var(--theme-switch-off--background--invalid--hover);--theme-switch-off--background--active:var(--theme-switch-off--background--invalid--active);--theme-switch-thumb-off--background:var(--theme-switch-thumb-off--background--invalid);--theme-switch-thumb-off--background--hover:var(--theme-switch-thumb-off--background--invalid--hover);--theme-switch-thumb-off--background--active:var(--theme-switch-thumb-off--background--invalid--active);--theme-switch-off--border-color:var(--theme-switch-off--border-color--invalid);--theme-switch-off--border-color--hover:var(--theme-switch-off--border-color--invalid--hover);--theme-switch-off--border-color--active:var(--theme-switch-off--border-color--invalid--active);--theme-switch-on--background:var(--theme-switch-on--background--invalid);--theme-switch-on--background--hover:var(--theme-switch-on--background--invalid--hover);--theme-switch-on--background--active:var(--theme-switch-on--background--invalid--active);--theme-switch-thumb-on--background:var(--theme-switch-thumb-on--background--invalid);--theme-switch-thumb-on--background--hover:var(--theme-switch-thumb-on--background--invalid--hover);--theme-switch-thumb-on--background--active:var(--theme-switch-thumb-on--background--invalid--active);--theme-switch-on--border-color:var(--theme-switch-on--border-color--invalid);--theme-switch-on--border-color--hover:var(--theme-switch-on--border-color--invalid--hover);--theme-switch-on--border-color--active:var(--theme-switch-on--border-color--invalid--active);--theme-switch-mixed--background:var(--theme-switch-mixed--background--invalid);--theme-switch-mixed--background--hover:var(--theme-switch-mixed--background--invalid--hover);--theme-switch-mixed--background--active:var(--theme-switch-mixed--background--invalid--active);--theme-switch-thumb-mixed--background:var(--theme-switch-thumb-mixed--background--invalid);--theme-switch-thumb-mixed--background--hover:var(--theme-switch-thumb-mixed--background--invalid--hover);--theme-switch-thumb-mixed--background--active:var(--theme-switch-thumb-mixed--background--invalid--active);--theme-switch-mixed--border-color:var(--theme-switch-mixed--border-color--invalid);--theme-switch-mixed--border-color--hover:var(--theme-switch-mixed--border-color--invalid--hover);--theme-switch-mixed--border-color--active:var(--theme-switch-mixed--border-color--invalid--active)}:host(.ix-invalid:not(.disabled)) .slider{--theme-switch-off--background:var(--theme-switch-off--background--invalid);--theme-switch-off--background--hover:var(--theme-switch-off--background--invalid--hover);--theme-switch-off--background--active:var(--theme-switch-off--background--invalid--active);--theme-switch-thumb-off--background:var(--theme-switch-thumb-off--background--invalid);--theme-switch-thumb-off--background--hover:var(--theme-switch-thumb-off--background--invalid--hover);--theme-switch-thumb-off--background--active:var(--theme-switch-thumb-off--background--invalid--active);--theme-switch-off--border-color:var(--theme-switch-off--border-color--invalid);--theme-switch-off--border-color--hover:var(--theme-switch-off--border-color--invalid--hover);--theme-switch-off--border-color--active:var(--theme-switch-off--border-color--invalid--active);--theme-switch-on--background:var(--theme-switch-on--background--invalid);--theme-switch-on--background--hover:var(--theme-switch-on--background--invalid--hover);--theme-switch-on--background--active:var(--theme-switch-on--background--invalid--active);--theme-switch-thumb-on--background:var(--theme-switch-thumb-on--background--invalid);--theme-switch-thumb-on--background--hover:var(--theme-switch-thumb-on--background--invalid--hover);--theme-switch-thumb-on--background--active:var(--theme-switch-thumb-on--background--invalid--active);--theme-switch-on--border-color:var(--theme-switch-on--border-color--invalid);--theme-switch-on--border-color--hover:var(--theme-switch-on--border-color--invalid--hover);--theme-switch-on--border-color--active:var(--theme-switch-on--border-color--invalid--active);--theme-switch-mixed--background:var(--theme-switch-mixed--background--invalid);--theme-switch-mixed--background--hover:var(--theme-switch-mixed--background--invalid--hover);--theme-switch-mixed--background--active:var(--theme-switch-mixed--background--invalid--active);--theme-switch-thumb-mixed--background:var(--theme-switch-thumb-mixed--background--invalid);--theme-switch-thumb-mixed--background--hover:var(--theme-switch-thumb-mixed--background--invalid--hover);--theme-switch-thumb-mixed--background--active:var(--theme-switch-thumb-mixed--background--invalid--active);--theme-switch-mixed--border-color:var(--theme-switch-mixed--border-color--invalid);--theme-switch-mixed--border-color--hover:var(--theme-switch-mixed--border-color--invalid--hover);--theme-switch-mixed--border-color--active:var(--theme-switch-mixed--border-color--invalid--active)}";
const IxToggleStyle0 = toggleCss;

const Toggle = /*@__PURE__*/ proxyCustomElement(class Toggle extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.checkedChange = createEvent(this, "checkedChange", 7);
        this.valueChange = createEvent(this, "valueChange", 7);
        this.formInternals = this.attachInternals();
        this.name = undefined;
        this.value = 'on';
        this.checked = false;
        this.disabled = false;
        this.indeterminate = false;
        this.textOn = 'On';
        this.textOff = 'Off';
        this.textIndeterminate = 'Mixed';
        this.hideText = false;
        this.required = false;
    }
    onCheckedChange(newChecked) {
        if (this.indeterminate) {
            this.indeterminate = false;
        }
        this.checked = newChecked;
        this.checkedChange.emit(this.checked);
    }
    componentWillLoad() {
        this.updateFormInternalValue();
    }
    updateFormInternalValue() {
        if (this.checked) {
            this.formInternals.setFormValue(this.value);
        }
        else {
            this.formInternals.setFormValue(null);
        }
    }
    watchCheckedChange() {
        this.updateFormInternalValue();
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(this.checked);
    }
    /** @internal */
    getAssociatedFormElement() {
        return Promise.resolve(this.formInternals.form);
    }
    render() {
        return (h(Host, { key: '2aafe9718c088e425a93a520063a55690dfa2f4e', class: {
                disabled: this.disabled,
            }, onClick: () => this.onCheckedChange(!this.checked) }, h("input", { key: 'eba13dd0d816d4f93113b7bc3eff1bd9bb304eb2', disabled: this.disabled, indeterminate: this.indeterminate, checked: this.checked, role: "switch", tabindex: 0, type: "checkbox", "aria-checked": a11yBoolean(this.checked), onChange: (event) => this.onCheckedChange(event.target.checked) }), h("label", { key: '587d507fb9e5208d4dfad4be72ca6a1483a3b96a', class: "switch", tabIndex: -1 }, h("span", { key: '6e3d43c84b83d15d1196aa4df1ab1944be820c25', class: "slider" })), !this.hideText ? (h(Fragment, null, !this.indeterminate ? (h("span", { class: 'toggle-text', "aria-hidden": a11yBoolean(true) }, this.checked ? this.textOn : this.textOff)) : (h("span", { class: 'toggle-text', "aria-hidden": a11yBoolean(true) }, this.textIndeterminate)))) : null));
    }
    static get formAssociated() { return true; }
    get hostElement() { return this; }
    static get watchers() { return {
        "checked": ["watchCheckedChange"]
    }; }
    static get style() { return IxToggleStyle0; }
}, [65, "ix-toggle", {
        "name": [513],
        "value": [513],
        "checked": [1540],
        "disabled": [4],
        "indeterminate": [1540],
        "textOn": [1, "text-on"],
        "textOff": [1, "text-off"],
        "textIndeterminate": [1, "text-indeterminate"],
        "hideText": [4, "hide-text"],
        "required": [516],
        "hasValidValue": [64],
        "getAssociatedFormElement": [64]
    }, undefined, {
        "checked": ["watchCheckedChange"]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-toggle"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-toggle":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Toggle);
            }
            break;
    } });
}

const IxToggle = Toggle;
const defineCustomElement = defineCustomElement$1;

export { IxToggle, defineCustomElement };

//# sourceMappingURL=ix-toggle.js.map