'use strict';

const index = require('./index-757233c7.js');
const index$1 = require('./index-d2117dc0.js');

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function hasAnyText({ invalidText, warningText, infoText, validText, helperText, }) {
    return invalidText || warningText || infoText || validText || helperText;
}
function renderHelperText({ isInvalid, invalidText, isWarning, warningText, isInfo, infoText, isValid, validText, helperText, }) {
    if (isInvalid && invalidText !== undefined) {
        return (index.h("ix-typography", { color: "alarm", class: "bottom-text" },
            index.h("ix-icon", { class: "text-icon invalid", name: index$1.iconError, size: "16" }),
            invalidText));
    }
    if (isWarning && warningText !== undefined) {
        return (index.h("ix-typography", { color: "std", class: "bottom-text" },
            index.h("ix-icon", { class: "text-icon warning", name: index$1.iconWarning, size: "16" }),
            warningText));
    }
    if (isInfo && infoText !== undefined) {
        return (index.h("ix-typography", { color: "std", class: "bottom-text" },
            index.h("ix-icon", { class: "text-icon info", name: index$1.iconInfo, size: "16" }),
            infoText));
    }
    if (isValid && validText !== undefined) {
        return (index.h("ix-typography", { color: "std", class: "bottom-text" },
            index.h("ix-icon", { class: "text-icon valid", name: index$1.iconSuccess, size: "16" }),
            validText));
    }
    return (helperText && (index.h("ix-typography", { class: "bottom-text", color: "soft" }, helperText)));
}

exports.hasAnyText = hasAnyText;
exports.renderHelperText = renderHelperText;

//# sourceMappingURL=helper-text-util-3192e78f.js.map