'use strict';

const index = require('./index-757233c7.js');
const a11y = require('./a11y-ae470f01.js');
const validation = require('./validation-1e3dd5ee.js');
const rwd_util = require('./rwd.util-ee53cbd1.js');
const anime_es = require('./anime.es-e2814360.js');

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function TextareaElement(props) {
    return (index.h("textarea", Object.assign({ readOnly: props.readonly, disabled: props.disabled, maxLength: props.maxLength, minLength: props.minLength, cols: props.textareaCols, rows: props.textareaRows, ref: props.textAreaRef, class: {
            'is-invalid': props.isInvalid,
        }, required: props.required, value: props.value, placeholder: props.placeholder, onChange: (changeEvent) => {
            const target = changeEvent.target;
            props.valueChange(target.value);
        }, onInput: (inputEvent) => {
            const target = inputEvent.target;
            props.updateFormInternalValue(target.value);
        }, onBlur: () => props.onBlur(), style: {
            resize: props.resizeBehavior,
            height: props.textareaHeight,
            width: props.textareaWidth,
        } }, props.ariaAttributes)));
}
function InputElement(props) {
    return (index.h("input", Object.assign({ id: props.id, autoComplete: "off", readOnly: props.readonly, disabled: props.disabled, min: props.min, max: props.max, maxLength: props.maxLength ? Number(props.maxLength) : undefined, minLength: props.maxLength ? Number(props.minLength) : undefined, ref: props.inputRef, pattern: props.pattern, type: props.type, class: {
            'is-invalid': props.isInvalid,
        }, required: props.required, value: props.value, placeholder: props.placeholder, onKeyPress: (event) => props.onKeyPress(event), onChange: (changeEvent) => {
            const target = changeEvent.target;
            props.valueChange(target.value);
        }, onInput: (inputEvent) => {
            const target = inputEvent.target;
            props.updateFormInternalValue(target.value);
        }, onBlur: () => props.onBlur() }, props.ariaAttributes)));
}
const SlotEnd = (props, children) => {
    return (index.h("div", { class: "end-container", ref: props.slotEndRef },
        index.h("slot", { name: "end", onSlotchange: props.onSlotChange }),
        children));
};
const SlotStart = (props) => {
    return (index.h("div", { class: "start-container", ref: props.slotStartRef },
        index.h("slot", { name: "start", onSlotchange: props.onSlotChange })));
};

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function shakeInput(input) {
    const xMax = 5;
    anime_es.anime({
        targets: input,
        duration: 200,
        easing: 'easeInOutSine',
        loop: 2,
        translateX: [
            {
                value: xMax * -1,
            },
            {
                value: xMax,
            },
            {
                value: xMax / -2,
            },
            {
                value: xMax / 2,
            },
            {
                value: 0,
            },
        ],
    });
}

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function mapValidationResult(ref, result) {
    ref.isInvalid = result.isInvalid || result.isInvalidByRequired;
    ref.isValid = result.isValid;
    ref.isInfo = result.isInfo;
    ref.isWarning = result.isWarning;
}
function checkAllowedKeys(comp, event) {
    if (comp.allowedCharactersPattern) {
        const regex = new RegExp(comp.allowedCharactersPattern);
        if (!regex.test(event.key)) {
            event.preventDefault();
            shakeInput(comp.inputRef.current);
        }
    }
}
async function checkInternalValidity(comp, input) {
    const validityState = input.validity;
    const eventResult = comp.validityStateChange.emit(validityState);
    if (eventResult.defaultPrevented) {
        return;
    }
    if (!comp.value) {
        return;
    }
    const skipValidation = await validation.shouldSuppressInternalValidation(comp);
    if (skipValidation) {
        return;
    }
    const { valid } = validityState;
    comp.hostElement.classList.toggle('ix-invalid', !valid);
}
function onInputBlur(comp, input) {
    comp.ixBlur.emit();
    if (!input) {
        throw new Error('Input element is not available');
    }
    checkInternalValidity(comp, input);
}
function applyPaddingEnd(inputElement, width, options) {
    var _a;
    if (!inputElement) {
        return;
    }
    const remInPixels = 16;
    const padding = rwd_util.convertToRemString(width + remInPixels / 2);
    if (options.slotEnd) {
        inputElement.style.paddingRight = `calc(${padding} + ${(_a = options.additionalPaddingRight) !== null && _a !== void 0 ? _a : '0rem'})`;
    }
    else {
        inputElement.style.paddingLeft = padding;
    }
}
function adjustPaddingForStartAndEnd(startElement, endElement, inputElement) {
    requestAnimationFrame(() => {
        requestAnimationFrame(() => {
            if (startElement) {
                const startBoundingRect = startElement.getBoundingClientRect();
                if (startBoundingRect) {
                    applyPaddingEnd(inputElement, startBoundingRect.width, {
                        slotEnd: false,
                    });
                }
            }
            if (endElement) {
                const endBoundingRect = endElement.getBoundingClientRect();
                if (endBoundingRect) {
                    applyPaddingEnd(inputElement, endBoundingRect.width, {
                        slotEnd: true,
                    });
                }
            }
        });
    });
}
function getAriaAttributesForInput(component) {
    const inputAria = {
        'aria-invalid': `${a11y.a11yBoolean(component.isInvalid)}`,
        'aria-required': `${a11y.a11yBoolean(component.required)}`,
    };
    if (component.isInvalid && component.invalidText) {
        inputAria['aria-errormessage'] = component.invalidText;
    }
    return inputAria;
}

exports.InputElement = InputElement;
exports.SlotEnd = SlotEnd;
exports.SlotStart = SlotStart;
exports.TextareaElement = TextareaElement;
exports.adjustPaddingForStartAndEnd = adjustPaddingForStartAndEnd;
exports.checkAllowedKeys = checkAllowedKeys;
exports.checkInternalValidity = checkInternalValidity;
exports.getAriaAttributesForInput = getAriaAttributesForInput;
exports.mapValidationResult = mapValidationResult;
exports.onInputBlur = onInputBlur;

//# sourceMappingURL=input.util-1c2fa43d.js.map