'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-757233c7.js');
const index$1 = require('./index-74904d8b.js');
const service = require('./service-39a8e5fe.js');
const context = require('./context-6644f454.js');
const menuService = require('./menu-service-9936f670.js');
const shadowDom = require('./shadow-dom-454acc38.js');
require('./animation-99234008.js');
require('./modal-a49409aa.js');
require('./typed-event-8032c0c0.js');
require('./breakpoints-5d1583fb.js');

const applicationHeaderCss = ":host{display:flex;align-items:flex-end;flex-wrap:nowrap;position:relative;width:100%;height:calc(2.75rem + var(--ix-safe-area-inset-top, 0rem));min-height:calc(2.75rem + var(--ix-safe-area-inset-top, 0rem));padding-top:0;padding-right:calc(1rem + var(--ix-safe-area-inset-right, 0rem));padding-bottom:0.3rem;padding-left:calc(0.625rem + var(--ix-safe-area-inset-left, 0rem));color:var(--theme-app-header--color);background-color:var(--theme-app-header--background);border-bottom:var(--theme-app-header--border-width) solid var(--theme-app-header--border-color);z-index:var(--theme-z-index-fixed)}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .app-switch{margin-right:1rem}:host .name{overflow:hidden;overflow-wrap:anywhere;text-overflow:ellipsis;text-wrap:nowrap;max-width:50%;margin-left:1.5rem;margin-right:2.5rem;margin-bottom:0.25rem;color:var(--theme-app-header--color)}:host .logo{display:inline-flex;align-items:center;position:relative;height:32px;overflow:hidden;line-height:0rem;color:var(--theme-app-header-logo--color);margin-left:0.375rem}:host .content{display:flex;position:relative;flex-direction:row;margin-left:auto;margin-right:0px}:host .dropdown{overflow:visible}:host .dropdown-content{padding:1rem}:host .context-menu{display:none}:host .context-menu.context-menu-visible{display:block}@media only screen and (max-width: 48em){:host .logo{display:none}}:host ::slotted(ix-avatar){margin-left:1rem}:host(.breakpoint-sm) .logo{margin-left:0.5rem}";
const IxApplicationHeaderStyle0 = applicationHeaderCss;

const ApplicationHeader = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.menuToggle = index.createEvent(this, "menuToggle", 7);
        this.name = undefined;
        this.showMenu = false;
        this.breakpoint = 'lg';
        this.menuExpanded = false;
        this.suppressResponsive = false;
        this.hasSlottedElements = false;
        this.applicationLayoutContext = undefined;
    }
    get contentBackground() {
        return this.hostElement.shadowRoot.querySelector('.dropdown-content');
    }
    componentWillLoad() {
        context.useContextConsumer(this.hostElement, context.ApplicationLayoutContext, (ctx) => {
            if ((ctx === null || ctx === void 0 ? void 0 : ctx.host) === 'map-navigation') {
                this.suppressResponsive = true;
                this.breakpoint = 'md';
                return;
            }
            this.breakpoint = service.applicationLayoutService.breakpoint;
            this.applicationLayoutContext = ctx;
            this.tryUpdateAppSwitch();
        }, true);
        this.menuDisposable = menuService.menuController.expandChange.on((show) => {
            this.menuExpanded = show;
        });
        this.modeDisposable = service.applicationLayoutService.onChange.on((mode) => {
            if (this.suppressResponsive) {
                return;
            }
            this.breakpoint = mode;
        });
        this.updateIsSlottedContent();
    }
    componentDidLoad() {
        this.attachSiemensLogoIfLoaded();
    }
    disconnectedCallback() {
        var _a, _b;
        (_a = this.menuDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
        (_b = this.modeDisposable) === null || _b === void 0 ? void 0 : _b.dispose();
    }
    watchApplicationLayoutContext() {
        if (this.applicationLayoutContext) {
            this.showMenu = false;
        }
    }
    watchSuppressResponsive() {
        this.breakpoint = 'md';
    }
    isLogoSlotted() {
        const slotElement = this.hostElement.shadowRoot.querySelector('slot[name="logo"]');
        const nodes = slotElement.assignedNodes({
            flatten: true,
        });
        return nodes.length !== 0;
    }
    async attachSiemensLogoIfLoaded() {
        await window.customElements.whenDefined('ix-siemens-logo');
        const logoElement = document.createElement('ix-siemens-logo');
        if (!this.isLogoSlotted()) {
            this.hostElement.shadowRoot
                .querySelector('.logo')
                .appendChild(logoElement);
        }
    }
    async onMenuClick() {
        if (this.applicationLayoutContext) {
            menuService.menuController.toggle();
        }
        else {
            this.menuExpanded = !this.menuExpanded;
        }
        this.menuToggle.emit(this.menuExpanded);
    }
    resolveContextMenuButton() {
        return new Promise((resolve) => index.readTask(() => resolve(this.hostElement.shadowRoot.querySelector('[data-context-menu]'))));
    }
    tryUpdateAppSwitch() {
        var _a;
        if (!this.callbackUpdateAppSwitchModal) {
            return;
        }
        this.callbackUpdateAppSwitchModal((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig);
    }
    async showAppSwitch() {
        var _a;
        this.callbackUpdateAppSwitchModal = await index$1.showAppSwitch((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig);
    }
    updateIsSlottedContent() {
        const slotElement = this.hostElement.shadowRoot.querySelector('.content slot');
        this.hasSlottedElements = shadowDom.hasSlottedElements(slotElement);
    }
    onContentBgClick(e) {
        if (e.target === this.contentBackground) {
            e.preventDefault();
        }
    }
    render() {
        var _a;
        const hasApplicationContextAvailable = !!this.applicationLayoutContext;
        const showMenuByApplicationFrame = this.breakpoint === 'sm' &&
            this.suppressResponsive === false &&
            hasApplicationContextAvailable;
        const showApplicationSwitch = ((_a = this.applicationLayoutContext) === null || _a === void 0 ? void 0 : _a.appSwitchConfig) &&
            this.breakpoint !== 'sm' &&
            this.suppressResponsive === false;
        return (index.h(index.Host, { key: '1f987dd8ac407207a23ac0821945ba9ad3d47e87', class: {
                [`breakpoint-${this.breakpoint}`]: true,
            }, slot: "application-header" }, (this.showMenu || showMenuByApplicationFrame) && (index.h("ix-menu-expand-icon", { key: '60c7aa44d2b294fff9cb51ecaf291d70a33bafbd', onClick: () => this.onMenuClick(), expanded: this.menuExpanded })), showApplicationSwitch && (index.h("ix-icon-button", { key: 'e500c3a98790345840633b8dd0f056fac198f802', onClick: () => this.showAppSwitch(), icon: "apps", ghost: true, class: "app-switch" })), index.h("div", { key: 'adba1c9a08be32a07f31a60d42159f996d26a87b', class: { logo: true } }, index.h("slot", { key: '3848321805f42653d8a9c066c8f237c8ec3497bb', name: "logo" })), index.h("ix-typography", { key: '9c312426ee3c2554a9a66aff6b158d36969cefea', format: "body-lg", class: "name" }, this.name), index.h("div", { key: '319969ceeb812f9b18b5ad3f374e16f454c6daf2', class: "content" }, this.breakpoint === 'sm' ? (index.h(index.Fragment, null, index.h("ix-icon-button", { class: {
                ['context-menu']: true,
                ['context-menu-visible']: this.hasSlottedElements,
            }, "data-context-menu": true, icon: "more-menu", ghost: true }), index.h("ix-dropdown", { "data-overflow-dropdown": true, class: "dropdown", discoverAllSubmenus: true, trigger: this.resolveContextMenuButton() }, index.h("div", { class: "dropdown-content", onClick: (e) => this.onContentBgClick(e) }, index.h("slot", { onSlotchange: () => this.updateIsSlottedContent() }))))) : (index.h("slot", { onSlotchange: () => this.updateIsSlottedContent() })), index.h("slot", { key: 'dd03dd49866605c06d6daf09d2ee72692666ee68', name: "ix-application-header-avatar" }))));
    }
    get hostElement() { return index.getElement(this); }
    static get watchers() { return {
        "applicationLayoutContext": ["watchApplicationLayoutContext"],
        "suppressResponsive": ["watchSuppressResponsive"]
    }; }
};
ApplicationHeader.style = IxApplicationHeaderStyle0;

exports.ix_application_header = ApplicationHeader;

//# sourceMappingURL=ix-application-header.cjs.entry.js.map