'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-757233c7.js');
const validation = require('./validation-1e3dd5ee.js');
const helperTextUtil = require('./helper-text-util-3192e78f.js');
require('./index-d2117dc0.js');

const helperTextCss = ":host{display:block}:host .bottom-text{display:flex;position:relative;align-items:flex-start;justify-content:flex-start;gap:0.25rem;margin-right:0.25rem}:host .text-icon{margin:0.125rem}:host .text-icon.invalid{color:var(--theme-helper-icon--color--invalid)}:host .text-icon.info{color:var(--theme-helper-icon--color--info)}:host .text-icon.warning{color:var(--theme-helper-icon--color--warning)}:host .text-icon.valid{color:var(--theme-helper-icon--color--valid)}";
const IxHelperTextStyle0 = helperTextCss;

const HelperText = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.observer = new MutationObserver(() => this.checkForRequired());
        this.htmlFor = undefined;
        this.helperText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.validationResults = {
            isInfo: false,
            isInvalid: false,
            isValid: false,
            isWarning: false,
            isInvalidByRequired: false,
        };
    }
    connectedCallback() {
        this.observer.observe(window.document, {
            childList: true,
            subtree: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    componentWillRender() {
        this.checkForRequired();
    }
    async checkForRequired() {
        if (!this.htmlFor) {
            return;
        }
        const forElement = document.getElementById(this.htmlFor);
        if (!forElement) {
            return;
        }
        if (this.classObserver) {
            this.classObserver.destroy();
        }
        this.classObserver = validation.createClassMutationObserver(forElement, () => {
            this.validationResults = validation.checkFieldClasses(forElement);
        });
        this.validationResults = validation.checkFieldClasses(forElement);
    }
    render() {
        return (index.h(index.Host, { key: 'a15c6af1db5a3723e8f2facd899a513c56f034af' }, helperTextUtil.renderHelperText(Object.assign({ helperText: this.helperText, invalidText: this.invalidText, validText: this.validText, infoText: this.infoText, warningText: this.warningText }, this.validationResults))));
    }
    get hostElement() { return index.getElement(this); }
};
HelperText.style = IxHelperTextStyle0;

exports.ix_helper_text = HelperText;

//# sourceMappingURL=ix-helper-text.cjs.entry.js.map