'use strict';

const index = require('./index-757233c7.js');

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
async function setupIcons() {
    if (typeof window === 'undefined') {
        return;
    }
    const iconComponent = window.customElements.get('ix-icon');
    if (iconComponent) {
        return;
    }
    console.warn('ix-icon web component not loaded. Using local fallback version');
    const ixIcons = await Promise.resolve().then(function () { return require('./index.es2017-0c2b80b6.js'); }).then(function (n) { return n.index_es2017; });
    await ixIcons.defineCustomElements();
}
function handlePlatformHelpers(config) {
    const platformHelpers = {};
    if (config.ael) {
        platformHelpers.ael = config.ael;
    }
    if (config.rel) {
        platformHelpers.rel = config.rel;
    }
    if (config.ce) {
        platformHelpers.ce = config.ce;
    }
    index.setPlatformHelpers(platformHelpers);
}
async function appGlobalScript (config) {
    await setupIcons();
    handlePlatformHelpers(config || {});
}

exports.appGlobalScript = appGlobalScript;
exports.handlePlatformHelpers = handlePlatformHelpers;

//# sourceMappingURL=setup-86b7d543.js.map