import { h, Host, } from "@stencil/core";
let accordionControlId = 0;
const getAriaControlsId = (prefix = 'expand-content') => {
    return [prefix, accordionControlId++].join('-');
};
/**
 * @since 1.6.0
 */
export class CardAccordion {
    constructor() {
        this.collapse = false;
        this.expandContent = false;
    }
    onInitialExpandChange() {
        this.expandContent = !this.collapse;
    }
    get expandedContent() {
        return this.hostElement.shadowRoot.querySelector('.expand-content');
    }
    onExpandActionClick(event) {
        event.preventDefault();
        event.stopPropagation();
        this.expandContent = !this.expandContent;
        this.accordionExpand.emit({
            expand: this.expandContent,
            nativeEvent: event,
        });
        if (this.expandContent) {
            this.scrollExpandedContentIntoView();
        }
    }
    scrollExpandedContentIntoView() {
        setTimeout(() => {
            const rect = this.expandedContent.getBoundingClientRect();
            if (rect.bottom > window.innerHeight) {
                this.hostElement
                    .shadowRoot.querySelector('.expand-content')
                    .scrollIntoView(false);
            }
        }, 150);
    }
    componentWillLoad() {
        this.onInitialExpandChange();
    }
    render() {
        return (h(Host, { key: '73d3ca21554724bf051ca8fe44365815cd2faf64', slot: "card-accordion" }, h("button", { key: 'a3a71b2ebdd46c3e64fcc6b4df96e134701a9662', tabIndex: 0, class: { 'expand-action': true, show: this.expandContent }, onClick: (event) => this.onExpandActionClick(event), role: "button", type: "button", "aria-expanded": this.expandContent, "aria-controls": getAriaControlsId() }, h("ix-icon", { key: '3713fc76176dc2b8ee99188a87c3de29851d567b', name: 'chevron-right-small', class: {
                'expand-icon': true,
                show: this.expandContent,
            } })), h("div", { key: '3081275d7694a98b35604cc9b5dd73c203b10426', class: {
                'expand-content': true,
                show: this.expandContent,
            } }, h("div", { key: 'ebad33d68b17070c4a3c133763279233d8984d1a', class: "expand-content-inner" }, h("div", { key: '32b3e459056717e3653f46e1b08e6f66f87a3143', class: "expand-content-body" }, h("slot", { key: 'dbd2b6a198ca95727f34ae9160ee74dc313296d9' })), h("div", { key: '3d17c4534cf5bcf6366576e33c68292ed2765e06', class: "expand-content-footer" })))));
    }
    static get is() { return "ix-card-accordion"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["card-accordion.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["card-accordion.css"]
        };
    }
    static get properties() {
        return {
            "collapse": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.1.0"
                        }],
                    "text": "Collapse the card"
                },
                "attribute": "collapse",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "expandContent": {}
        };
    }
    static get events() {
        return [{
                "method": "accordionExpand",
                "name": "accordionExpand",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "CardAccordionExpandChangeEvent",
                    "resolved": "{ expand: boolean; nativeEvent: Event; }",
                    "references": {
                        "CardAccordionExpandChangeEvent": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/card-accordion/card-accordion.tsx",
                            "id": "src/components/card-accordion/card-accordion.tsx::CardAccordionExpandChangeEvent"
                        }
                    }
                }
            }];
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "collapse",
                "methodName": "onInitialExpandChange"
            }];
    }
}
//# sourceMappingURL=card-accordion.js.map
