import { h, Host } from "@stencil/core";
/**
 * @since 1.6.0
 */
export class Card {
    constructor() {
        this.variant = 'insight';
        this.selected = false;
    }
    render() {
        return (h(Host, { key: '47a06ae7be967b6077ec9851b22724f39f08bdb5', class: {
                selected: this.selected,
                [`card-${this.variant}`]: true,
            } }, h("div", { key: '3bd791183108512f4f150e4223c6b3487104d9f6', class: "card-content" }, h("slot", { key: '7b500f330a7c751385deadaabf9f0a4fbaff7444' })), h("div", { key: '700082bfb35c5ecb56d70502500112e1232f2afb', class: "card-footer" }, h("slot", { key: 'bd156f9ac6728f9cf5a92bb8a454083a50a40cce', name: "card-accordion" }))));
    }
    static get is() { return "ix-card"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["card.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["card.css"]
        };
    }
    static get properties() {
        return {
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "CardVariant",
                    "resolved": "\"alarm\" | \"critical\" | \"filled\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"outline\" | \"primary\" | \"success\" | \"warning\"",
                    "references": {
                        "CardVariant": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/card/card.tsx",
                            "id": "src/components/card/card.tsx::CardVariant"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "deprecated",
                            "text": "variant insight and notification will be removed in 3.0. Use 'outline' or 'filled' instead."
                        }],
                    "text": "Card variant"
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "'insight'"
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.1.0"
                        }],
                    "text": ""
                },
                "attribute": "selected",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=card.js.map
