/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { test } from "../../../tests/utils/test/index";
import { expect } from "@playwright/test";
test('renders', async ({ mount, page }) => {
    await mount(`<ix-category-filter></ix-category-filter>`);
    const categoryFilter = page.locator('ix-category-filter');
    await expect(categoryFilter).toHaveClass(/hydrated/);
});
test.describe('category-preview test', () => {
    test.beforeEach(async ({ mount, page }) => {
        await mount(`
      <ix-category-filter></ix-category-filter>
      `);
        const categoryFilter = page.locator('ix-category-filter');
        await categoryFilter.evaluate((el) => {
            el.categories = {
                ID_1: {
                    label: 'Vendor',
                    options: ['Apple', 'MS', 'Siemens'],
                },
                ID_2: {
                    label: 'Product',
                    options: ['iPhone X', 'Windows', 'APS'],
                },
            };
        });
    });
    test('add token', async ({ page }) => {
        const token = 'Test';
        await page.waitForSelector('ix-category-filter');
        const input = await page.locator('input').first();
        await input.click();
        await input.fill(token);
        await page.keyboard.press('Enter');
        const chip = await page.locator('ix-filter-chip').first();
        await expect(chip).toContainText(token);
    });
    test('clear category-preview', async ({ page }) => {
        const categoryFilter = page.locator('ix-category-filter');
        await categoryFilter.locator('input').first().click();
        await categoryFilter.locator('.category-item').first().click();
        const categoryPreviewPromise = categoryFilter.evaluate((element) => {
            return new Promise((resolve) => {
                function onCategoryChanged(event) {
                    resolve(event.detail);
                }
                element.addEventListener('categoryChanged', onCategoryChanged);
            });
        });
        await page.locator('ix-icon-button').first().click();
        const categoryPreview = await categoryPreviewPromise;
        expect(categoryPreview).toEqual(null);
    });
});
//# sourceMappingURL=category-filter.ct.js.map
