var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Host, h } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class CheckboxGroup {
    constructor() {
        this.helperText = undefined;
        this.label = undefined;
        this.direction = 'column';
        this.invalidText = undefined;
        this.infoText = undefined;
        this.validText = undefined;
        this.warningText = undefined;
        this.showTextAsTooltip = false;
        this.isInvalid = false;
        this.isInfo = false;
        this.isValid = false;
        this.isWarning = false;
    }
    onClassFieldUpdate({ isInvalid, isInvalidByRequired, isInfo, isValid, isWarning, }) {
        this.isInvalid = isInvalid || isInvalidByRequired;
        this.isInfo = isInfo;
        this.isValid = isValid;
        this.isWarning = isWarning;
    }
    render() {
        return (h(Host, { key: '3b3403b167dbcd69cce94ece70070d6d4a633fd5' }, h("ix-field-wrapper", { key: '47692f7cadd2bf1798302f4854d0c16efca49dd4', label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, validText: this.validText, warningText: this.warningText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isInfo: this.isInfo, isValid: this.isValid, isWarning: this.isWarning }, h("div", { key: '82181467dda161e570576dd4644c5cc45584ac3a', class: {
                'checkbox-container': true,
                'row-layout': this.direction === 'row',
            } }, h("slot", { key: 'a1fe76fc0d07422227cddc9d8e2b51ef1894311a' })))));
    }
    static get is() { return "ix-checkbox-group"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["checkbox-group.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["checkbox-group.css"]
        };
    }
    static get properties() {
        return {
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Optional helper text displayed below the checkbox group"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the checkbox group"
                },
                "attribute": "label",
                "reflect": false
            },
            "direction": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'row' | 'column'",
                    "resolved": "\"column\" | \"row\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Alignment of the checkboxes in the group"
                },
                "attribute": "direction",
                "reflect": false,
                "defaultValue": "'column'"
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Error text for the checkbox group"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Info text for the checkbox group"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Valid text for the checkbox group"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Warning text for the checkbox group"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show helper, info, warning, error and valid text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isInfo": {},
            "isValid": {},
            "isWarning": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
__decorate([
    HookValidationLifecycle({
        includeChildren: true,
    })
], CheckboxGroup.prototype, "onClassFieldUpdate", null);
//# sourceMappingURL=checkbox-group.js.map
