/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Host, h, } from "@stencil/core";
import { HookValidationLifecycle } from "../utils/input";
import { makeRef } from "../utils/make-ref";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class Checkbox {
    constructor() {
        this.inputRef = makeRef((checkboxRef) => {
            checkboxRef.checked = this.checked;
        });
        this.name = undefined;
        this.value = 'on';
        this.label = undefined;
        this.checked = false;
        this.disabled = false;
        this.indeterminate = false;
        this.required = false;
    }
    setCheckedState(newChecked) {
        this.checked = newChecked;
        this.checkedChange.emit(this.checked);
    }
    onCheckedChange() {
        this.updateFormInternalValue();
    }
    onValueChange() {
        this.valueChange.emit(this.value);
    }
    componentWillLoad() {
        this.updateFormInternalValue();
    }
    updateFormInternalValue() {
        var _a;
        if (this.checked) {
            this.formInternals.setFormValue((_a = this.value) !== null && _a !== void 0 ? _a : 'on');
        }
        else {
            this.formInternals.setFormValue(null);
        }
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(this.checked);
    }
    /** @internal */
    getAssociatedFormElement() {
        return Promise.resolve(this.formInternals.form);
    }
    updateClassMappings() {
        /** This function is intentionally empty */
    }
    renderCheckmark() {
        if (this.checked) {
            return (h("svg", { width: "18", height: "18", viewBox: "0 0 18 18", fill: "none", xmlns: "http://www.w3.org/2000/svg" }, h("path", { d: "M3.65625 8.15625L8.4375 12.9375L14.625 3.9375", stroke: "var(--ix-checkbox-check-color)", "stroke-width": "2" })));
        }
        if (this.indeterminate) {
            return (h("svg", { width: "18", height: "18", viewBox: "0 0 18 18", fill: "none", xmlns: "http://www.w3.org/2000/svg" }, h("rect", { width: "18", height: "18", fill: "transparent" }), h("rect", { x: "3", y: "8", width: "12", height: "2", fill: "var(--ix-checkbox-check-color)" })));
        }
    }
    render() {
        return (h(Host, { key: '2b7e1abca080e177d16c5b4a38e6a6da3d43a934', "aria-checked": `${this.checked}`, "aria-disabled": `${this.disabled}`, role: "checkbox", class: {
                disabled: this.disabled,
                checked: this.checked,
                indeterminate: this.indeterminate,
            } }, h("label", { key: '22875af8489648471425485045e0d4833c942a2e' }, h("input", { key: 'd3a8ea36c89114bec173f48d777c0cc9b7b4beea', "aria-checked": `${this.checked}`, disabled: this.disabled, checked: this.checked, ref: this.inputRef, type: "checkbox", onChange: () => this.setCheckedState(!this.checked) }), h("button", { key: 'a013746af7808d088de26dfad03bdb38ed47b879', disabled: this.disabled, class: {
                checked: this.checked,
            }, onClick: () => this.setCheckedState(!this.checked) }, this.renderCheckmark()), h("ix-typography", { key: '57871c7f84a4bdf917e3f833063bac1881412b64', format: "label", textColor: this.disabled ? 'weak' : 'std' }, this.label, h("slot", { key: '7273efd58eaf8fcadd8d30184ef817659e23f476' })))));
    }
    static get is() { return "ix-checkbox"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["checkbox.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["checkbox.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Name of the checkbox component"
                },
                "attribute": "name",
                "reflect": true
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Value of the checkbox component"
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "'on'"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the checkbox component"
                },
                "attribute": "label",
                "reflect": false
            },
            "checked": {
                "type": "boolean",
                "mutable": true,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Checked state of the checkbox component"
                },
                "attribute": "checked",
                "reflect": true,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disabled state of the checkbox component"
                },
                "attribute": "disabled",
                "reflect": true,
                "defaultValue": "false"
            },
            "indeterminate": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Indeterminate state of the checkbox component"
                },
                "attribute": "indeterminate",
                "reflect": true,
                "defaultValue": "false"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Required state of the checkbox component.\n\nIf true, checkbox needs to be checked to be valid"
                },
                "attribute": "required",
                "reflect": true,
                "defaultValue": "false"
            }
        };
    }
    static get events() {
        return [{
                "method": "checkedChange",
                "name": "checkedChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the checked state of the checkbox changes"
                },
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                }
            }, {
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the checkbox changes"
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "checked",
                "methodName": "onCheckedChange"
            }, {
                "propName": "value",
                "methodName": "onValueChange"
            }];
    }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    HookValidationLifecycle()
], Checkbox.prototype, "updateClassMappings", null);
//# sourceMappingURL=checkbox.js.map
