/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
export class ContentHeader {
    constructor() {
        this.variant = 'primary';
        this.headerTitle = undefined;
        this.headerSubtitle = undefined;
        this.hasBackButton = false;
    }
    render() {
        return (h(Host, { key: '05d59f8a62e29a886537cd2249a91cbaca560a42' }, this.hasBackButton ? (h("ix-icon-button", { class: 'backButton', variant: "primary", icon: 'arrow-left', ghost: true, onClick: () => this.backButtonClick.emit() })) : null, h("div", { key: 'eb02e3fc080a29379290e77b5db2049f77c990cb', class: "titleGroup" }, h("ix-typography", { key: 'de9edd86198e18414247d584f7cdb0f1e98243a3', format: this.variant === 'secondary' ? 'h4' : 'h3', class: this.variant === 'secondary' ? 'secondary' : '' }, this.headerTitle), !!this.headerSubtitle && (h("ix-typography", { key: 'debacfac59173251d1a53dda88cba8d96021e78e', format: 'h6', color: 'soft', class: this.variant === 'secondary' ? 'subtitle' : '' }, this.headerSubtitle))), h("div", { key: '1726ad1632965b087a49052c698ddea09dd38017', class: "buttons" }, h("slot", { key: 'bc275ead0f7e070a60dfb5c94fbc786fdda36fc3' }))));
    }
    static get is() { return "ix-content-header"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["content-header.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["content-header.css"]
        };
    }
    static get properties() {
        return {
            "variant": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "ContentHeaderVariant",
                    "resolved": "\"primary\" | \"secondary\"",
                    "references": {
                        "ContentHeaderVariant": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/content-header/content-header.tsx",
                            "id": "src/components/content-header/content-header.tsx::ContentHeaderVariant"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Variant of content header"
                },
                "attribute": "variant",
                "reflect": false,
                "defaultValue": "'primary'"
            },
            "headerTitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Title of Header"
                },
                "attribute": "header-title",
                "reflect": false
            },
            "headerSubtitle": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string | undefined",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Subtitle of Header"
                },
                "attribute": "header-subtitle",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "hasBackButton": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Display a back button"
                },
                "attribute": "has-back-button",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get events() {
        return [{
                "method": "backButtonClick",
                "name": "backButtonClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Triggered when back button is clicked"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=content-header.js.map
