/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { templateBuilder } from "./builder";
const smQuery = 'only screen and (max-width: 576px)';
const mdQuery = 'only screen and (max-width: 768px)';
const lgQuery = 'only screen and (max-width: 992px)';
const mediaQueryCollection = [
    { name: 'sm', query: smQuery },
    { name: 'md', query: mdQuery },
    { name: 'lg', query: lgQuery },
];
/**
 * @internal
 */
export class CssGrid {
    constructor() {
        this.disposeMediaQueryListener = [];
        this.mediaQueries = [];
        this.templates = undefined;
        this.currentTemplate = undefined;
    }
    componentWillRender() {
        this.mediaQueries = mediaQueryCollection.map((query) => {
            const mediaQuery = window.matchMedia(query.query);
            const callback = () => {
                this.applyTemplate();
            };
            this.disposeMediaQueryListener.push(callback);
            mediaQuery.addEventListener('change', callback);
            return Object.assign(Object.assign({}, query), { mediaQuery });
        });
        this.applyTemplate();
    }
    disconnectedCallback() {
        this.mediaQueries.forEach((mq, index) => {
            mq.mediaQuery.removeEventListener('change', this.disposeMediaQueryListener[index]);
        });
    }
    findNextTemplate(type) {
        if (!this.templates) {
            return [];
        }
        const typeIndex = this.mediaQueries.findIndex((mq) => mq.name === type);
        const nextTemplate = this.templates[this.mediaQueries[typeIndex + 1].name];
        if (!nextTemplate) {
            return this.findNextTemplate(this.mediaQueries[typeIndex + 1].name);
        }
        return nextTemplate;
    }
    applyTemplate() {
        if (!this.templates) {
            return;
        }
        let active = this.mediaQueries.find((mq) => mq.mediaQuery.matches);
        if (!active) {
            active = this.mediaQueries[this.mediaQueries.length - 1];
        }
        const template = this.templates[active.name];
        if (template) {
            this.currentTemplate = template;
        }
        else {
            this.currentTemplate = this.findNextTemplate(active.name);
        }
    }
    render() {
        const style = {};
        if (this.currentTemplate && this.currentTemplate.length !== 0) {
            style['grid-template-areas'] = templateBuilder(this.currentTemplate);
        }
        return (h(Host, { key: 'f95fcef32a0f61b09e7b65141db9c2009dd5b073', style: style }, h("slot", { key: '96ab47d528edb1195098233ae4563487ab41385b' })));
    }
    static get is() { return "ix-css-grid"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["css-grid.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["css-grid.css"]
        };
    }
    static get properties() {
        return {
            "templates": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "Partial<Record<CssGridTemplateType, string[][]>>",
                    "resolved": "{ sm?: string[][]; md?: string[][]; lg?: string[][]; }",
                    "references": {
                        "Partial": {
                            "location": "global",
                            "id": "global::Partial"
                        },
                        "Record": {
                            "location": "global",
                            "id": "global::Record"
                        },
                        "CssGridTemplateType": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/css-grid/css-grid.tsx",
                            "id": "src/components/css-grid/css-grid.tsx::CssGridTemplateType"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Define css grid template"
                }
            }
        };
    }
    static get states() {
        return {
            "currentTemplate": {}
        };
    }
}
//# sourceMappingURL=css-grid.js.map
