/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Host, h } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
/**
 * @since 2.6.0
 */
export class CustomField {
    constructor() {
        this.required = false;
        this.label = undefined;
        this.helperText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.showTextAsTooltip = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
    }
    updateValidationState({ isInvalid, isValid, isInfo, isWarning, }) {
        this.isInvalid = isInvalid;
        this.isValid = isValid;
        this.isInfo = isInfo;
        this.isWarning = isWarning;
    }
    render() {
        return (h(Host, { key: 'ee9ed8e36ffa3f55295e0e4fda3d2b1acb90c2e3' }, h("ix-field-wrapper", { key: '19cfaca80d58b6aa2b9d8a29e33777f4be9b238a', label: this.label, helperText: this.helperText, infoText: this.infoText, warningText: this.warningText, invalidText: this.invalidText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, required: this.required }, h("slot", { key: 'b3e5d6efbfa3279de1e0ffe2d9322ac14c985911' }))));
    }
    static get is() { return "ix-custom-field"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["custom-field.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["custom-field.css"]
        };
    }
    static get properties() {
        return {
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "A value is required or must be checked for the form to be submittable"
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the field component"
                },
                "attribute": "label",
                "reflect": false
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show text below the field component which show additional information"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Info text for the field component"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Warning text for the field component"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Error text for the field component"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Valid text for the field component"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show helper, info, warning, error and valid text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
__decorate([
    HookValidationLifecycle({
        includeChildren: true,
    })
], CustomField.prototype, "updateValidationState", null);
//# sourceMappingURL=custom-field.js.map
