/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Host, h, } from "@stencil/core";
import { DateTime } from "luxon";
import { dropdownController } from "../dropdown/dropdown-controller";
import { makeRef } from "../utils/make-ref";
import { HookValidationLifecycle, createClassMutationObserver, } from "../utils/input";
import { SlotEnd, SlotStart } from "../input/input.fc";
import { adjustPaddingForStartAndEnd } from "../input/input.util";
import { iconCalendar } from "@siemens/ix-icons/icons";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class DateInput {
    constructor() {
        this.slotStartRef = makeRef();
        this.slotEndRef = makeRef();
        this.datepickerRef = makeRef();
        this.inputElementRef = makeRef();
        this.dropdownElementRef = makeRef();
        this.name = undefined;
        this.placeholder = undefined;
        this.value = '';
        this.locale = undefined;
        this.format = 'yyyy/LL/dd';
        this.required = undefined;
        this.helperText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.readonly = false;
        this.disabled = false;
        this.infoText = undefined;
        this.warningText = undefined;
        this.validText = undefined;
        this.showTextAsTooltip = undefined;
        this.i18nErrorDateUnparsable = 'Date is not valid';
        this.show = false;
        this.from = null;
        this.isInputInvalid = false;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.focus = false;
    }
    updateFormInternalValue(value) {
        this.formInternals.setFormValue(value);
        this.value = value;
    }
    connectedCallback() {
        this.classObserver = createClassMutationObserver(this.hostElement, () => this.checkClassList());
    }
    componentWillLoad() {
        this.onInput(this.value);
        if (this.isInputInvalid) {
            this.from = null;
        }
        else {
            this.watchValue();
        }
        this.checkClassList();
        this.updateFormInternalValue(this.value);
    }
    componentDidRender() {
        this.updatePaddings();
    }
    updatePaddings() {
        adjustPaddingForStartAndEnd(this.slotStartRef.current, this.slotEndRef.current, this.inputElementRef.current);
    }
    disconnectedCallback() {
        if (this.classObserver) {
            this.classObserver.destroy();
        }
    }
    watchValue() {
        this.from = this.value;
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(!!this.value);
    }
    /** @internal */
    getAssociatedFormElement() {
        return Promise.resolve(this.formInternals.form);
    }
    async onInput(value) {
        this.value = value;
        if (!value) {
            this.valueChange.emit(value);
            return;
        }
        if (!this.format) {
            return;
        }
        const date = DateTime.fromFormat(value, this.format);
        if (date.isValid) {
            this.isInputInvalid = false;
            this.updateFormInternalValue(value);
            this.closeDropdown();
        }
        else {
            this.isInputInvalid = true;
            this.invalidReason = date.invalidReason;
        }
        this.valueChange.emit(value);
    }
    onCalenderClick(event) {
        if (!this.show) {
            event.stopPropagation();
            event.preventDefault();
            this.openDropdown();
        }
        if (this.inputElementRef.current) {
            this.inputElementRef.current.focus();
        }
    }
    async openDropdown() {
        const dropdownElement = await this.dropdownElementRef.waitForCurrent();
        const id = dropdownElement.getAttribute('data-ix-dropdown');
        dropdownController.dismissAll();
        if (!id) {
            return;
        }
        const dropdown = dropdownController.getDropdownById(id);
        if (!dropdown) {
            return;
        }
        dropdownController.present(dropdown);
    }
    async closeDropdown() {
        const dropdownElement = await this.dropdownElementRef.waitForCurrent();
        const id = dropdownElement.getAttribute('data-ix-dropdown');
        if (!id) {
            return;
        }
        const dropdown = dropdownController.getDropdownById(id);
        if (!dropdown) {
            return;
        }
        dropdownController.dismiss(dropdown);
    }
    checkClassList() {
        this.isInvalid = this.hostElement.classList.contains('ix-invalid');
    }
    renderInput() {
        return (h("div", { class: "input-wrapper" }, h(SlotStart, { slotStartRef: this.slotStartRef, onSlotChange: () => this.updatePaddings() }), h("input", { autoComplete: "off", class: {
                'is-invalid': this.isInputInvalid,
            }, disabled: this.disabled, readOnly: this.readonly, readonly: this.readonly, required: this.required, ref: this.inputElementRef, type: "text", value: this.value, onInput: (event) => {
                const target = event.target;
                this.onInput(target.value);
            }, onClick: (event) => {
                if (this.show) {
                    event.stopPropagation();
                    event.preventDefault();
                }
            }, onFocus: async () => {
                this.openDropdown();
                this.ixFocus.emit();
            }, onBlur: () => this.ixBlur.emit() }), h(SlotEnd, { slotEndRef: this.slotEndRef, onSlotChange: () => this.updatePaddings() }, h("ix-icon-button", { "data-testid": "open-calendar", class: { 'calendar-hidden': this.disabled || this.readonly }, ghost: true, icon: iconCalendar, onClick: (event) => this.onCalenderClick(event) }))));
    }
    hookValidationLifecycle({ isInfo, isInvalid, isInvalidByRequired, isValid, isWarning, }) {
        this.isInvalid = isInvalid || isInvalidByRequired || this.isInputInvalid;
        this.isInfo = isInfo;
        this.isValid = isValid;
        this.isWarning = isWarning;
    }
    async onInputValidationChange() {
        const state = await this.getValidityState();
        this.validityStateChange.emit({
            patternMismatch: state.patternMismatch,
            invalidReason: this.invalidReason,
        });
    }
    /** @internal */
    getValidityState() {
        return Promise.resolve({
            badInput: false,
            customError: false,
            patternMismatch: this.isInputInvalid,
            rangeOverflow: false,
            rangeUnderflow: false,
            stepMismatch: false,
            tooLong: false,
            tooShort: false,
            typeMismatch: false,
            valid: !this.isInputInvalid,
            valueMissing: !!this.required && !this.value,
        });
    }
    /**
     * Get the native input element
     */
    getNativeInputElement() {
        return this.inputElementRef.waitForCurrent();
    }
    /**
     * Focuses the input field
     */
    async focusInput() {
        return (await this.getNativeInputElement()).focus();
    }
    render() {
        var _a;
        const invalidText = this.isInputInvalid
            ? this.i18nErrorDateUnparsable
            : this.invalidText;
        return (h(Host, { key: 'f8e90dff95d76faed16b0bbb67f7ae014d170c8f', class: {
                disabled: this.disabled,
                readonly: this.readonly,
            } }, h("ix-field-wrapper", { key: 'b101c12280803e5316d03ca8ac00179dea52f3ce', label: this.label, helperText: this.helperText, isInvalid: this.isInvalid, invalidText: invalidText, infoText: this.infoText, isInfo: this.isInfo, isWarning: this.isWarning, warningText: this.warningText, isValid: this.isValid, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, required: this.required, controlRef: this.inputElementRef }, this.renderInput()), h("ix-dropdown", { key: 'de9f9c3775cd061d5098a2b9ed2242f509ea4be0', "data-testid": "date-dropdown", trigger: this.inputElementRef.waitForCurrent(), ref: this.dropdownElementRef, closeBehavior: "outside", suppressOverflowBehavior: true, show: this.show, onShowChanged: (event) => {
                this.show = event.detail;
            } }, h("ix-date-picker", { key: '3c1ee7eeeb71f458fdce19e32d517d32ada48e74', ref: this.datepickerRef, format: this.format, locale: this.locale, range: false, from: (_a = this.from) !== null && _a !== void 0 ? _a : '', onDateChange: (event) => {
                const { from } = event.detail;
                this.onInput(from);
            } }))));
    }
    static get is() { return "ix-date-input"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["date-input.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["date-input.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "name of the input element"
                },
                "attribute": "name",
                "reflect": true
            },
            "placeholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "placeholder of the input element"
                },
                "attribute": "placeholder",
                "reflect": true
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "value of the input element"
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "''"
            },
            "locale": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "2.6.0"
                        }],
                    "text": "Locale identifier (e.g. 'en' or 'de')."
                },
                "attribute": "locale",
                "reflect": false
            },
            "format": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Date format string.\nSee {@link \"https://moment.github.io/luxon/#/formatting?id=table-of-tokens\"} for all available tokens."
                },
                "attribute": "format",
                "reflect": false,
                "defaultValue": "'yyyy/LL/dd'"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "required attribute"
                },
                "attribute": "required",
                "reflect": false
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "helper text below the input field"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "label of the input field"
                },
                "attribute": "label",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "error text below the input field"
                },
                "attribute": "invalid-text",
                "reflect": true
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "readonly attribute"
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "disabled attribute"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "info text below the input field"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "warning text below the input field"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "valid text below the input field"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "show text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "i18nErrorDateUnparsable": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "i18n string for the error message when the date is not parsable"
                },
                "attribute": "i18n-error-date-unparsable",
                "reflect": false,
                "defaultValue": "'Date is not valid'"
            }
        };
    }
    static get states() {
        return {
            "show": {},
            "from": {},
            "isInputInvalid": {},
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {},
            "focus": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": false,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Input change event."
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }, {
                "method": "validityStateChange",
                "name": "validityStateChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Validation state change event."
                },
                "complexType": {
                    "original": "DateInputValidityState",
                    "resolved": "{ patternMismatch: boolean; invalidReason?: string; }",
                    "references": {
                        "DateInputValidityState": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/date-input/date-input.tsx",
                            "id": "src/components/date-input/date-input.tsx::DateInputValidityState"
                        }
                    }
                }
            }, {
                "method": "ixFocus",
                "name": "ixFocus",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }, {
                "method": "ixBlur",
                "name": "ixBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getValidityState": {
                "complexType": {
                    "signature": "() => Promise<ValidityState>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "ValidityState": {
                            "location": "global",
                            "id": "global::ValidityState"
                        }
                    },
                    "return": "Promise<ValidityState>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getNativeInputElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLInputElement>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLInputElement": {
                            "location": "global",
                            "id": "global::HTMLInputElement"
                        }
                    },
                    "return": "Promise<HTMLInputElement>"
                },
                "docs": {
                    "text": "Get the native input element",
                    "tags": []
                }
            },
            "focusInput": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Focuses the input field",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "value",
                "methodName": "watchValue"
            }, {
                "propName": "isInputInvalid",
                "methodName": "onInputValidationChange"
            }];
    }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    HookValidationLifecycle()
], DateInput.prototype, "hookValidationLifecycle", null);
//# sourceMappingURL=date-input.js.map
