/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 1.6.0
 */
export class EmptyState {
    constructor() {
        this.layout = 'large';
        this.icon = undefined;
        this.header = undefined;
        this.subHeader = undefined;
        this.action = undefined;
    }
    render() {
        return (h(Host, { key: '724769e68ca03e809c7c1b520fd27ddf0f851e00', class: `emptyState emptyState--${this.layout}` }, this.icon && (h("div", { key: '30038117755c9f30e0a90a6c4e2ab03fb559fa2d', class: "emptyState__icon" }, h("ix-icon", { key: '96c477d16bec8a73843981731ff6cb8830c27d39', name: this.icon, size: this.layout === 'large' ? '32' : '32', color: "color-soft-text" }))), h("div", { key: 'eac1e4371be1427d7126f134bee2f74550f09fe9', class: "emptyState__content" }, h("div", { key: '462298153f1e35f9fcc43fe7d42e15fe6efa2351', class: "content__label" }, h("ix-typography", { key: 'd52a79a4e27938d59231a3e39cc38b53a5799a5f', format: this.layout === 'large' ? 'h3' : 'body' }, this.header), this.subHeader && (h("div", { key: '9667dc6eaba88a1ce663e66deda0d447f91db7f0', class: "label__subHeader" }, this.subHeader))), this.action && (h("div", { key: '6b435724ffb7e2cc758b43cd76e452b241aab028', class: "content__action" }, h("ix-button", { key: 'a6257e01ae753fee88b61de3b9ffccdc68596485', onClick: () => this.actionClick.emit() }, this.action))))));
    }
    static get is() { return "ix-empty-state"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["empty-state.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["empty-state.css"]
        };
    }
    static get properties() {
        return {
            "layout": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "EmptyStateLayout",
                    "resolved": "\"compact\" | \"compactBreak\" | \"large\"",
                    "references": {
                        "EmptyStateLayout": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/empty-state/empty-state.tsx",
                            "id": "src/components/empty-state/empty-state.tsx::EmptyStateLayout"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state layout - one of 'large', 'compact' or 'compactBreak'"
                },
                "attribute": "layout",
                "reflect": false,
                "defaultValue": "'large'"
            },
            "icon": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state icon"
                },
                "attribute": "icon",
                "reflect": false
            },
            "header": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Empty state header"
                },
                "attribute": "header",
                "reflect": false
            },
            "subHeader": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state sub header"
                },
                "attribute": "sub-header",
                "reflect": false
            },
            "action": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional empty state action"
                },
                "attribute": "action",
                "reflect": false
            }
        };
    }
    static get events() {
        return [{
                "method": "actionClick",
                "name": "actionClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Empty state action click event"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
}
//# sourceMappingURL=empty-state.js.map
