/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host, } from "@stencil/core";
import { a11yBoolean } from "../utils/a11y";
export class EventListItem {
    constructor() {
        this.color = undefined;
        this.itemColor = undefined;
        this.selected = false;
        this.disabled = false;
        this.chevron = false;
    }
    handleItemClick() {
        this.itemClick.emit();
    }
    render() {
        var _a, _b, _c, _d;
        let color = ((_a = this.itemColor) === null || _a === void 0 ? void 0 : _a.startsWith('--theme'))
            ? `var(${this.itemColor})`
            : `var(--theme-${this.itemColor})`;
        if (this.color) {
            color = ((_b = this.color) === null || _b === void 0 ? void 0 : _b.startsWith('--theme'))
                ? `var(${this.color})`
                : `var(--theme-${this.color})`;
        }
        return (h(Host, { key: 'ccae724ec628564a8efc0c4afb57b174c145d29f', class: {
                disabled: this.disabled,
            } }, h("div", { key: 'd3f47109cda6e26444f2f68db37d4d6548691c3a', role: "listitem", "aria-disabled": a11yBoolean(this.disabled), class: {
                'event-list-item': true,
                selected: this.selected,
                disabled: this.disabled,
            } }, h("div", { key: 'd4ad4478255f1f6b7d32d5791c0af2b7fffdb85a', class: `indicator ${!((_c = this.itemColor) !== null && _c !== void 0 ? _c : this.color) ? 'indicator-empty' : ''}`, style: {
                'background-color': ((_d = this.itemColor) !== null && _d !== void 0 ? _d : this.color) ? color : 'inherit',
                opacity: `${this.disabled ? 0.4 : 1}`,
            } }), h("div", { key: '4d8551ff9c4630506cd30dbdaf87b13d7b89d21b', class: "event-list-item-container" }, h("div", { key: '6df7f1111a621be7d8f7b1bb176c81d94427d59f', class: "event-content" }, h("slot", { key: '83c7f28de4ec57e39695e0e7f62c01fa56845dc5' })), this.chevron && (h("ix-icon", { key: '0b63dc539e42f2bd16088466168a60ae10909303', name: 'chevron-right', size: "16", class: "chevron-icon" }))))));
    }
    static get is() { return "ix-event-list-item"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["event-list-item.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["event-list-item.css"]
        };
    }
    static get properties() {
        return {
            "color": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/theming/colors/"
                        }, {
                            "name": "deprecated",
                            "text": "since 2.1.0 use `item-color`"
                        }],
                    "text": "Color of the status indicator.\nYou can find a list of all available colors in our documentation.\nExample values are `--theme-color-alarm` or `color-alarm`"
                },
                "attribute": "color",
                "reflect": false
            },
            "itemColor": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [{
                            "name": "link",
                            "text": "https://ix.siemens.io/docs/theming/colors/"
                        }],
                    "text": "Color of the status indicator.\nYou can find a list of all available colors in our documentation.\nExample values are `--theme-color-alarm` or `color-alarm`"
                },
                "attribute": "item-color",
                "reflect": false
            },
            "selected": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show event list item as selected"
                },
                "attribute": "selected",
                "reflect": false,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disable event list item"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "chevron": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show chevron on right side of the event list item"
                },
                "attribute": "chevron",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
    static get events() {
        return [{
                "method": "itemClick",
                "name": "itemClick",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event list item click"
                },
                "complexType": {
                    "original": "any",
                    "resolved": "any",
                    "references": {}
                }
            }];
    }
    static get listeners() {
        return [{
                "name": "click",
                "method": "handleItemClick",
                "target": undefined,
                "capture": false,
                "passive": true
            }];
    }
}
//# sourceMappingURL=event-list-item.js.map
