/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Host, h } from "@stencil/core";
import { makeRef } from "../utils/make-ref";
import { hasAnyText, renderHelperText } from "./helper-text-util";
/** @internal */
export class FieldWrapper {
    constructor() {
        this.slotRef = makeRef();
        this.helperText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.showTextAsTooltip = false;
        this.required = false;
        this.htmlForLabel = undefined;
        this.controlRef = undefined;
    }
    render() {
        const textOptions = {
            invalidText: this.invalidText,
            isInvalid: this.isInvalid,
            isValid: this.isValid,
            validText: this.validText,
            isWarning: this.isWarning,
            warningText: this.warningText,
            isInfo: this.isInfo,
            infoText: this.infoText,
            helperText: this.helperText,
        };
        return (h(Host, { key: '3a1885ca13c1de17fdbb33eb6cde695cbdb3469e' }, this.label && (h("div", { key: '9e8c0a96fe7014feb6ac76473137183ba92e2ad1', class: "field-top" }, h("ix-field-label", { key: '923dec87ac02cf550400aba0bf929b95d8a271ed', required: this.required, htmlFor: this.htmlForLabel, controlRef: this.controlRef, isInvalid: this.isInvalid }, this.label))), h("div", { key: 'a6694ebd1d18d2411565960ff5f1e6ee900491e8', class: {
                'slot-wrapper': true,
            }, ref: this.slotRef }, h("slot", { key: '302fcd87bd9cba38a3057b9a6542dbaed9d16bbc' })), h("div", { key: '8f5c9836963e0df796388b8dac20db7289ea067e', class: 'field-bottom' }, !this.showTextAsTooltip && renderHelperText(textOptions), h("div", { key: '620bf3f6730971ee840744fce7b8a7de2d2f12a9', class: "bottom-right" }, h("slot", { key: '7cff3c8d8f550a88e4bccacf6b71547edb89b0a7', name: "bottom-right" }))), this.showTextAsTooltip === true && hasAnyText(textOptions) && (h("ix-tooltip", { key: '9041af539fd29c6fd2e8e3e4a00daa8e2c15ed22', for: this.slotRef.waitForCurrent(), showDelay: 500, placement: "bottom" }, renderHelperText(textOptions)))));
    }
    static get is() { return "ix-field-wrapper"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["field-wrapper.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["field-wrapper.css"]
        };
    }
    static get properties() {
        return {
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show text below the field component"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Label for the field component"
                },
                "attribute": "label",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Error text for the field component"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Valid text for the field component"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Info text for the field component"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Warning text for the field component"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "isInvalid": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Is the field component invalid"
                },
                "attribute": "is-invalid",
                "reflect": false,
                "defaultValue": "false"
            },
            "isValid": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Is the field component valid"
                },
                "attribute": "is-valid",
                "reflect": false,
                "defaultValue": "false"
            },
            "isInfo": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Is the field component info"
                },
                "attribute": "is-info",
                "reflect": false,
                "defaultValue": "false"
            },
            "isWarning": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Is the field component warning"
                },
                "attribute": "is-warning",
                "reflect": false,
                "defaultValue": "false"
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show helper, error, info, warning text as tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false,
                "defaultValue": "false"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Show label as required"
                },
                "attribute": "required",
                "reflect": false,
                "defaultValue": "false"
            },
            "htmlForLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The id of the form element that the label is associated with"
                },
                "attribute": "html-for-label",
                "reflect": false
            },
            "controlRef": {
                "type": "unknown",
                "mutable": false,
                "complexType": {
                    "original": "MakeRef<HTMLElement>",
                    "resolved": "{ (ref: HTMLElement): void; current: HTMLElement; waitForCurrent(): Promise<HTMLElement>; }",
                    "references": {
                        "MakeRef": {
                            "location": "import",
                            "path": "../utils/make-ref",
                            "id": "src/components/utils/make-ref.ts::MakeRef"
                        },
                        "HTMLElement": {
                            "location": "global",
                            "id": "global::HTMLElement"
                        }
                    }
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The control element that the label is associated with"
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=field-wrapper.js.map
