import { Host, h } from "@stencil/core";
import { checkFieldClasses, createClassMutationObserver, } from "../utils/input";
import { renderHelperText } from "../field-wrapper/helper-text-util";
export class HelperText {
    constructor() {
        this.observer = new MutationObserver(() => this.checkForRequired());
        this.htmlFor = undefined;
        this.helperText = undefined;
        this.invalidText = undefined;
        this.validText = undefined;
        this.infoText = undefined;
        this.warningText = undefined;
        this.validationResults = {
            isInfo: false,
            isInvalid: false,
            isValid: false,
            isWarning: false,
            isInvalidByRequired: false,
        };
    }
    connectedCallback() {
        this.observer.observe(window.document, {
            childList: true,
            subtree: true,
        });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    componentWillRender() {
        this.checkForRequired();
    }
    async checkForRequired() {
        if (!this.htmlFor) {
            return;
        }
        const forElement = document.getElementById(this.htmlFor);
        if (!forElement) {
            return;
        }
        if (this.classObserver) {
            this.classObserver.destroy();
        }
        this.classObserver = createClassMutationObserver(forElement, () => {
            this.validationResults = checkFieldClasses(forElement);
        });
        this.validationResults = checkFieldClasses(forElement);
    }
    render() {
        return (h(Host, { key: 'a15c6af1db5a3723e8f2facd899a513c56f034af' }, renderHelperText(Object.assign({ helperText: this.helperText, invalidText: this.invalidText, validText: this.validText, infoText: this.infoText, warningText: this.warningText }, this.validationResults))));
    }
    static get is() { return "ix-helper-text"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["helper-text.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["helper-text.css"]
        };
    }
    static get properties() {
        return {
            "htmlFor": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The id of the form element that the label is associated with"
                },
                "attribute": "html-for",
                "reflect": false
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Show text below the field component"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Error text for the field component"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Valid text for the field component"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Info text for the field component"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Warning text for the field component"
                },
                "attribute": "warning-text",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "validationResults": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=helper-text.js.map
