/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h } from "@stencil/core";
export function TextareaElement(props) {
    return (h("textarea", Object.assign({ readOnly: props.readonly, disabled: props.disabled, maxLength: props.maxLength, minLength: props.minLength, cols: props.textareaCols, rows: props.textareaRows, ref: props.textAreaRef, class: {
            'is-invalid': props.isInvalid,
        }, required: props.required, value: props.value, placeholder: props.placeholder, onChange: (changeEvent) => {
            const target = changeEvent.target;
            props.valueChange(target.value);
        }, onInput: (inputEvent) => {
            const target = inputEvent.target;
            props.updateFormInternalValue(target.value);
        }, onBlur: () => props.onBlur(), style: {
            resize: props.resizeBehavior,
            height: props.textareaHeight,
            width: props.textareaWidth,
        } }, props.ariaAttributes)));
}
export function InputElement(props) {
    return (h("input", Object.assign({ id: props.id, autoComplete: "off", readOnly: props.readonly, disabled: props.disabled, min: props.min, max: props.max, maxLength: props.maxLength ? Number(props.maxLength) : undefined, minLength: props.maxLength ? Number(props.minLength) : undefined, ref: props.inputRef, pattern: props.pattern, type: props.type, class: {
            'is-invalid': props.isInvalid,
        }, required: props.required, value: props.value, placeholder: props.placeholder, onKeyPress: (event) => props.onKeyPress(event), onChange: (changeEvent) => {
            const target = changeEvent.target;
            props.valueChange(target.value);
        }, onInput: (inputEvent) => {
            const target = inputEvent.target;
            props.updateFormInternalValue(target.value);
        }, onBlur: () => props.onBlur() }, props.ariaAttributes)));
}
export const SlotEnd = (props, children) => {
    return (h("div", { class: "end-container", ref: props.slotEndRef }, h("slot", { name: "end", onSlotchange: props.onSlotChange }), children));
};
export const SlotStart = (props) => {
    return (h("div", { class: "start-container", ref: props.slotStartRef }, h("slot", { name: "start", onSlotchange: props.onSlotChange })));
};
//# sourceMappingURL=input.fc.js.map
