/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { iconEye, iconEyeCancelled } from "@siemens/ix-icons/icons";
import { Host, h, } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
import { makeRef } from "../utils/make-ref";
import { InputElement, SlotEnd, SlotStart } from "./input.fc";
import { adjustPaddingForStartAndEnd, checkAllowedKeys, getAriaAttributesForInput, mapValidationResult, onInputBlur, } from "./input.util";
let inputIds = 0;
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class Input {
    constructor() {
        this.inputRef = makeRef();
        this.slotEndRef = makeRef();
        this.slotStartRef = makeRef();
        this.inputId = `input-${inputIds++}`;
        this.type = 'text';
        this.name = undefined;
        this.placeholder = undefined;
        this.value = '';
        this.required = false;
        this.disabled = false;
        this.readonly = false;
        this.helperText = undefined;
        this.infoText = undefined;
        this.showTextAsTooltip = undefined;
        this.validText = undefined;
        this.warningText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.pattern = undefined;
        this.maxLength = undefined;
        this.minLength = undefined;
        this.allowedCharactersPattern = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.isInvalidByRequired = false;
        this.inputType = 'text';
    }
    updateClassMappings(result) {
        mapValidationResult(this, result);
    }
    updateInputType() {
        this.inputType = this.type;
    }
    componentWillLoad() {
        this.updateFormInternalValue(this.value);
        this.inputType = this.type;
    }
    componentDidRender() {
        this.updatePaddings();
    }
    updatePaddings() {
        adjustPaddingForStartAndEnd(this.slotStartRef.current, this.slotEndRef.current, this.inputRef.current);
    }
    updateFormInternalValue(value) {
        this.formInternals.setFormValue(value);
        this.value = value;
    }
    /** @internal */
    async getAssociatedFormElement() {
        return this.formInternals.form;
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(!!this.value);
    }
    /**
     * Returns the native input element used in the text field.
     */
    getNativeInputElement() {
        return this.inputRef.waitForCurrent();
    }
    /**
     * Focuses the input field
     */
    async focusInput() {
        return (await this.getNativeInputElement()).focus();
    }
    render() {
        var _a;
        const inputAria = getAriaAttributesForInput(this);
        return (h(Host, { key: '842ff9fc4e182372da40d4bcb4f89653fc1c90fd', class: {
                disabled: this.disabled,
                readonly: this.readonly,
            } }, h("ix-field-wrapper", { key: '3614d6006a3c55191f6fce25c70c1383b46fec0b', htmlForLabel: this.inputId, required: this.required, label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, warningText: this.warningText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, controlRef: this.inputRef }, h("div", { key: '71ba199ce76ca1ac0135a403827e47aec4c88977', class: "input-wrapper" }, h(SlotStart, { key: 'f6a8ea82539d59e475e6e62d498ea7150de90506', slotStartRef: this.slotStartRef, onSlotChange: () => this.updatePaddings() }), h(InputElement, { key: '4c4ff361edcf9d5b780825142ba64bee79531153', id: this.inputId, readonly: this.readonly, disabled: this.disabled, maxLength: this.maxLength, minLength: this.minLength, pattern: this.pattern, type: this.inputType, isInvalid: this.isInvalid, required: this.required, value: this.value, placeholder: this.placeholder, inputRef: this.inputRef, onKeyPress: (event) => checkAllowedKeys(this, event), valueChange: (value) => this.valueChange.emit(value), updateFormInternalValue: (value) => this.updateFormInternalValue(value), onBlur: () => onInputBlur(this, this.inputRef.current), ariaAttributes: inputAria }), h(SlotEnd, { key: '9b0dab754362fbe7abf36c505209da7063490a52', slotEndRef: this.slotEndRef, onSlotChange: () => this.updatePaddings() }, h("ix-icon-button", { key: '6003d03e3d8efd967c932fc05e2270f83a102ae4', color: "color-weak-text", class: {
                'password-eye': true,
                'eye-hidden': this.type !== 'password',
            }, ghost: true, icon: this.inputType === 'password' ? iconEye : iconEyeCancelled, onClick: () => {
                if (this.inputType === 'password') {
                    this.inputType = 'text';
                    return;
                }
                this.inputType = 'password';
            } }))), !!this.maxLength && this.maxLength > 0 && (h("ix-typography", { key: 'ecb767e15d688a8f93237a2572fcdf2343c087c6', class: "bottom-text", slot: "bottom-right", color: "soft" }, (_a = this.value) === null || _a === void 0 ? void 0 :
            _a.length, "/", this.maxLength)))));
    }
    static get is() { return "ix-input"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["input.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["input.css"]
        };
    }
    static get properties() {
        return {
            "type": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'text' | 'email' | 'password' | 'tel' | 'url'",
                    "resolved": "\"email\" | \"password\" | \"tel\" | \"text\" | \"url\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The type of the text field. Possible values are 'text', 'email', or 'password'."
                },
                "attribute": "type",
                "reflect": false,
                "defaultValue": "'text'"
            },
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The name of the text field."
                },
                "attribute": "name",
                "reflect": true
            },
            "placeholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The placeholder text for the text field."
                },
                "attribute": "placeholder",
                "reflect": true
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the text field."
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "''"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specifies whether the text field is required."
                },
                "attribute": "required",
                "reflect": true,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specifies whether the text field is disabled."
                },
                "attribute": "disabled",
                "reflect": true,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specifies whether the text field is readonly."
                },
                "attribute": "readonly",
                "reflect": true,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The helper text for the text field."
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The info text for the text field."
                },
                "attribute": "info-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Specifies whether to show the text as a tooltip."
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The valid text for the text field."
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The warning text for the text field."
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label for the text field."
                },
                "attribute": "label",
                "reflect": true
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The error text for the text field."
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "pattern": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The pattern for the text field."
                },
                "attribute": "pattern",
                "reflect": false
            },
            "maxLength": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The maximum length of the text field."
                },
                "attribute": "max-length",
                "reflect": false
            },
            "minLength": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The minimum length of the text field."
                },
                "attribute": "min-length",
                "reflect": false
            },
            "allowedCharactersPattern": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The allowed characters pattern for the text field."
                },
                "attribute": "allowed-characters-pattern",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {},
            "isInvalidByRequired": {},
            "inputType": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the text field changes."
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }, {
                "method": "validityStateChange",
                "name": "validityStateChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the validity state of the text field changes."
                },
                "complexType": {
                    "original": "ValidityState",
                    "resolved": "ValidityState",
                    "references": {
                        "ValidityState": {
                            "location": "global",
                            "id": "global::ValidityState"
                        }
                    }
                }
            }, {
                "method": "ixBlur",
                "name": "ixBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the text field loses focus."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getNativeInputElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLInputElement>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLInputElement": {
                            "location": "global",
                            "id": "global::HTMLInputElement"
                        }
                    },
                    "return": "Promise<HTMLInputElement>"
                },
                "docs": {
                    "text": "Returns the native input element used in the text field.",
                    "tags": []
                }
            },
            "focusInput": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Focuses the input field",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get watchers() {
        return [{
                "propName": "type",
                "methodName": "updateInputType"
            }];
    }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    HookValidationLifecycle()
], Input.prototype, "updateClassMappings", null);
//# sourceMappingURL=input.js.map
