/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { iconMinus, iconPlus } from "@siemens/ix-icons/icons";
import { Host, h, } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
import { makeRef } from "../utils/make-ref";
import { InputElement, SlotEnd, SlotStart } from "./input.fc";
import { adjustPaddingForStartAndEnd, checkAllowedKeys, checkInternalValidity, mapValidationResult, onInputBlur, } from "./input.util";
let numberInputIds = 0;
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class NumberInput {
    constructor() {
        this.inputRef = makeRef();
        this.slotEndRef = makeRef();
        this.slotStartRef = makeRef();
        this.numberInputId = `number-input-${numberInputIds++}`;
        this.name = undefined;
        this.placeholder = undefined;
        this.value = 0;
        this.required = false;
        this.disabled = false;
        this.readonly = false;
        this.helperText = undefined;
        this.infoText = undefined;
        this.showTextAsTooltip = undefined;
        this.validText = undefined;
        this.warningText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.pattern = undefined;
        this.min = undefined;
        this.max = undefined;
        this.allowedCharactersPattern = undefined;
        this.showStepperButtons = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.isInvalidByRequired = false;
    }
    updateClassMappings(result) {
        mapValidationResult(this, result);
    }
    componentWillLoad() {
        this.updateFormInternalValue(this.value);
    }
    componentDidRender() {
        this.updatePaddings();
    }
    updatePaddings() {
        adjustPaddingForStartAndEnd(this.slotStartRef.current, this.slotEndRef.current, this.inputRef.current);
    }
    updateFormInternalValue(value) {
        this.formInternals.setFormValue(value.toString());
        this.value = value;
    }
    /** @internal */
    async getAssociatedFormElement() {
        return this.formInternals.form;
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(!!this.value);
    }
    /**
     * Returns the native input element used under the hood
     */
    getNativeInputElement() {
        return this.inputRef.waitForCurrent();
    }
    /**
     * Focuses the input field
     */
    async focusInput() {
        return (await this.getNativeInputElement()).focus();
    }
    render() {
        const showStepperButtons = this.showStepperButtons && (this.disabled || this.readonly) === false;
        return (h(Host, { key: '257156c1c5ec77ef4426b3a8818941f0b28062c6', class: {
                disabled: this.disabled,
                readonly: this.readonly,
            } }, h("ix-field-wrapper", { key: 'ab953fa1af86d3f0415b709fff3871e17f00453a', id: this.numberInputId, required: this.required, label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, warningText: this.warningText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, controlRef: this.inputRef }, h("div", { key: '82ab33e39746a47d1c387f953b3862bd47547a4b', class: {
                'input-wrapper': true,
                'show-stepper-buttons': !!this.showStepperButtons,
            } }, h(SlotStart, { key: '252e87d3380c33806b2a1af84b98d672e2f0980f', slotStartRef: this.slotStartRef, onSlotChange: () => this.updatePaddings() }), h(InputElement, { key: 'd2cbab2e83934c970e9b8fce0390d5ad01234646', id: this.numberInputId, readonly: this.readonly, disabled: this.disabled, min: this.min, max: this.max, pattern: this.pattern, type: 'number', isInvalid: this.isInvalid, required: this.required, value: this.value, placeholder: this.placeholder, inputRef: this.inputRef, onKeyPress: (event) => checkAllowedKeys(this, event), valueChange: (value) => this.valueChange.emit(Number(value)), updateFormInternalValue: (value) => this.updateFormInternalValue(Number(value)), onBlur: () => onInputBlur(this, this.inputRef.current) }), h(SlotEnd, { key: '9a9a6de11186692b3707d85315a124256124ad2f', slotEndRef: this.slotEndRef, onSlotChange: () => this.updatePaddings() }, h("div", { key: '97a24bdb25e6a6818038f662eb14a94e4e79d7a0', class: {
                'number-stepper-container': true,
                'container-hidden': !showStepperButtons,
            } }, h("ix-icon-button", { key: '89d6c0aea01ea12ad5342cf825f9f43748e5f47a', ghost: true, icon: iconMinus, size: "16", class: "number-stepper-button step-minus", onClick: () => {
                if (!this.inputRef.current) {
                    return;
                }
                this.inputRef.current.stepDown();
                checkInternalValidity(this, this.inputRef.current);
                this.updateFormInternalValue(Number(this.inputRef.current.value));
                this.valueChange.emit(this.value);
            } }), h("ix-icon-button", { key: '7a913f64e5abf65be33268df93eae3635452b51b', ghost: true, icon: iconPlus, size: "16", class: "number-stepper-button step-plus", onClick: () => {
                if (!this.inputRef.current) {
                    return;
                }
                this.inputRef.current.stepUp();
                checkInternalValidity(this, this.inputRef.current);
                this.updateFormInternalValue(Number(this.inputRef.current.value));
                this.valueChange.emit(this.value);
            } })))))));
    }
    static get is() { return "ix-number-input"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["number-input.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["number-input.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "name of the input element"
                },
                "attribute": "name",
                "reflect": true
            },
            "placeholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "placeholder of the input element"
                },
                "attribute": "placeholder",
                "reflect": true
            },
            "value": {
                "type": "number",
                "mutable": true,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the input field"
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "0"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Indicates if the field is required"
                },
                "attribute": "required",
                "reflect": true,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disables the input field"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Indicates if the field is read-only"
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The helper text for the input field"
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The info text for the input field"
                },
                "attribute": "info-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Indicates if the text should be shown as a tooltip"
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The valid text for the input field"
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The warning text for the input field"
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label for the input field"
                },
                "attribute": "label",
                "reflect": true
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The error text for the input field"
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "pattern": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The pattern for the input field"
                },
                "attribute": "pattern",
                "reflect": false
            },
            "min": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | number",
                    "resolved": "number | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The minimum value for the input field"
                },
                "attribute": "min",
                "reflect": false
            },
            "max": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "string | number",
                    "resolved": "number | string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The maximum value for the input field"
                },
                "attribute": "max",
                "reflect": false
            },
            "allowedCharactersPattern": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The allowed characters pattern for the input field"
                },
                "attribute": "allowed-characters-pattern",
                "reflect": false
            },
            "showStepperButtons": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Indicates if the stepper buttons should be shown"
                },
                "attribute": "show-stepper-buttons",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {},
            "isInvalidByRequired": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the input field changes"
                },
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                }
            }, {
                "method": "validityStateChange",
                "name": "validityStateChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the validity state of the input field changes"
                },
                "complexType": {
                    "original": "ValidityState",
                    "resolved": "ValidityState",
                    "references": {
                        "ValidityState": {
                            "location": "global",
                            "id": "global::ValidityState"
                        }
                    }
                }
            }, {
                "method": "ixBlur",
                "name": "ixBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the input field loses focus"
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getNativeInputElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLInputElement>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLInputElement": {
                            "location": "global",
                            "id": "global::HTMLInputElement"
                        }
                    },
                    "return": "Promise<HTMLInputElement>"
                },
                "docs": {
                    "text": "Returns the native input element used under the hood",
                    "tags": []
                }
            },
            "focusInput": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Focuses the input field",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    HookValidationLifecycle()
], NumberInput.prototype, "updateClassMappings", null);
//# sourceMappingURL=number-input.js.map
