/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Host, h, } from "@stencil/core";
import { HookValidationLifecycle, } from "../utils/input";
import { makeRef } from "../utils/make-ref";
import { TextareaElement } from "./input.fc";
import { mapValidationResult, onInputBlur } from "./input.util";
/**
 * @since 2.6.0
 * @form-ready 2.6.0
 */
export class Textarea {
    constructor() {
        this.textAreaRef = makeRef();
        this.name = undefined;
        this.placeholder = undefined;
        this.value = '';
        this.required = false;
        this.disabled = false;
        this.readonly = false;
        this.helperText = undefined;
        this.infoText = undefined;
        this.showTextAsTooltip = undefined;
        this.validText = undefined;
        this.warningText = undefined;
        this.label = undefined;
        this.invalidText = undefined;
        this.textareaHeight = undefined;
        this.textareaWidth = undefined;
        this.textareaRows = undefined;
        this.textareaCols = undefined;
        this.resizeBehavior = 'both';
        this.maxLength = undefined;
        this.minLength = undefined;
        this.isInvalid = false;
        this.isValid = false;
        this.isInfo = false;
        this.isWarning = false;
        this.isInvalidByRequired = false;
    }
    updateClassMappings(result) {
        mapValidationResult(this, result);
    }
    componentWillLoad() {
        this.updateFormInternalValue(this.value);
    }
    updateFormInternalValue(value) {
        this.formInternals.setFormValue(value);
        this.value = value;
    }
    /** @internal */
    async getAssociatedFormElement() {
        return this.formInternals.form;
    }
    /** @internal */
    hasValidValue() {
        return Promise.resolve(!!this.value);
    }
    /**
     * Get the native textarea element.
     */
    getNativeInputElement() {
        return this.textAreaRef.waitForCurrent();
    }
    /**
     * Focuses the input field
     */
    async focusInput() {
        return (await this.getNativeInputElement()).focus();
    }
    render() {
        return (h(Host, { key: '55f9acbe1f37fd80ce6d6104c06c057b2014dc47', class: {
                disabled: this.disabled,
                readonly: this.readonly,
            } }, h("ix-field-wrapper", { key: 'd38e875d3de15093496a1ae8e3d0e06272e3f4fc', required: this.required, label: this.label, helperText: this.helperText, invalidText: this.invalidText, infoText: this.infoText, warningText: this.warningText, validText: this.validText, showTextAsTooltip: this.showTextAsTooltip, isInvalid: this.isInvalid, isValid: this.isValid, isInfo: this.isInfo, isWarning: this.isWarning, controlRef: this.textAreaRef }, !!this.maxLength && this.maxLength > 0 && (h("ix-typography", { key: 'c85143e3e8866490d3673d0183741e1f914692ce', class: "bottom-text", slot: "bottom-right", color: "soft" }, this.value.length, "/", this.maxLength)), h("div", { key: '790d620ea6157129ee00798edd4076b73769c705', class: "input-wrapper" }, h(TextareaElement, { key: '3242925ed8673d49974da380b7c2e8833170511e', minLength: this.minLength, maxLength: this.maxLength, textareaCols: this.textareaCols, textareaRows: this.textareaRows, textareaHeight: this.textareaHeight, textareaWidth: this.textareaWidth, resizeBehavior: this.resizeBehavior, readonly: this.readonly, disabled: this.disabled, isInvalid: this.isInvalid, required: this.required, value: this.value, placeholder: this.placeholder, textAreaRef: this.textAreaRef, valueChange: (value) => this.valueChange.emit(value), updateFormInternalValue: (value) => this.updateFormInternalValue(value), onBlur: () => onInputBlur(this, this.textAreaRef.current) })))));
    }
    static get is() { return "ix-textarea"; }
    static get encapsulation() { return "shadow"; }
    static get formAssociated() { return true; }
    static get originalStyleUrls() {
        return {
            "$": ["textarea.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["textarea.css"]
        };
    }
    static get properties() {
        return {
            "name": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The name of the textarea field."
                },
                "attribute": "name",
                "reflect": true
            },
            "placeholder": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The placeholder text for the textarea field."
                },
                "attribute": "placeholder",
                "reflect": true
            },
            "value": {
                "type": "string",
                "mutable": true,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "The value of the textarea field."
                },
                "attribute": "value",
                "reflect": true,
                "defaultValue": "''"
            },
            "required": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Determines if the textarea field is required."
                },
                "attribute": "required",
                "reflect": true,
                "defaultValue": "false"
            },
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Determines if the textarea field is disabled."
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "readonly": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Determines if the textarea field is readonly."
                },
                "attribute": "readonly",
                "reflect": false,
                "defaultValue": "false"
            },
            "helperText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The helper text for the textarea field."
                },
                "attribute": "helper-text",
                "reflect": false
            },
            "infoText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The info text for the textarea field."
                },
                "attribute": "info-text",
                "reflect": false
            },
            "showTextAsTooltip": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "Determines if the text should be displayed as a tooltip."
                },
                "attribute": "show-text-as-tooltip",
                "reflect": false
            },
            "validText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The valid text for the textarea field."
                },
                "attribute": "valid-text",
                "reflect": false
            },
            "warningText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The warning text for the textarea field."
                },
                "attribute": "warning-text",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The label for the textarea field."
                },
                "attribute": "label",
                "reflect": true
            },
            "invalidText": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The error text for the textarea field."
                },
                "attribute": "invalid-text",
                "reflect": false
            },
            "textareaHeight": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The height of the textarea field (e.g. \"52px\")."
                },
                "attribute": "textarea-height",
                "reflect": false
            },
            "textareaWidth": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The width of the textarea field (e.g. \"200px\")."
                },
                "attribute": "textarea-width",
                "reflect": false
            },
            "textareaRows": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The height of the textarea specified by number of rows."
                },
                "attribute": "textarea-rows",
                "reflect": false
            },
            "textareaCols": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The width of the textarea specified by number of characters."
                },
                "attribute": "textarea-cols",
                "reflect": false
            },
            "resizeBehavior": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "TextareaResizeBehavior",
                    "resolved": "\"both\" | \"horizontal\" | \"none\" | \"vertical\"",
                    "references": {
                        "TextareaResizeBehavior": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/input/textarea.tsx",
                            "id": "src/components/input/textarea.tsx::TextareaResizeBehavior"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Determines the resize behavior of the textarea field.\nResizing can be enabled in one direction, both directions or completely disabled."
                },
                "attribute": "resize-behavior",
                "reflect": false,
                "defaultValue": "'both'"
            },
            "maxLength": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The maximum length of the textarea field."
                },
                "attribute": "max-length",
                "reflect": false
            },
            "minLength": {
                "type": "number",
                "mutable": false,
                "complexType": {
                    "original": "number",
                    "resolved": "number",
                    "references": {}
                },
                "required": false,
                "optional": true,
                "docs": {
                    "tags": [],
                    "text": "The minimum length of the textarea field."
                },
                "attribute": "min-length",
                "reflect": false
            }
        };
    }
    static get states() {
        return {
            "isInvalid": {},
            "isValid": {},
            "isInfo": {},
            "isWarning": {},
            "isInvalidByRequired": {}
        };
    }
    static get events() {
        return [{
                "method": "valueChange",
                "name": "valueChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the value of the textarea field changes."
                },
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                }
            }, {
                "method": "validityStateChange",
                "name": "validityStateChange",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the validity state of the textarea field changes."
                },
                "complexType": {
                    "original": "ValidityState",
                    "resolved": "ValidityState",
                    "references": {
                        "ValidityState": {
                            "location": "global",
                            "id": "global::ValidityState"
                        }
                    }
                }
            }, {
                "method": "ixBlur",
                "name": "ixBlur",
                "bubbles": true,
                "cancelable": true,
                "composed": true,
                "docs": {
                    "tags": [],
                    "text": "Event emitted when the textarea field loses focus."
                },
                "complexType": {
                    "original": "void",
                    "resolved": "void",
                    "references": {}
                }
            }];
    }
    static get methods() {
        return {
            "getAssociatedFormElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLFormElement | null>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLFormElement": {
                            "location": "global",
                            "id": "global::HTMLFormElement"
                        }
                    },
                    "return": "Promise<HTMLFormElement>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "hasValidValue": {
                "complexType": {
                    "signature": "() => Promise<boolean>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<boolean>"
                },
                "docs": {
                    "text": "",
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }]
                }
            },
            "getNativeInputElement": {
                "complexType": {
                    "signature": "() => Promise<HTMLTextAreaElement>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        },
                        "HTMLTextAreaElement": {
                            "location": "global",
                            "id": "global::HTMLTextAreaElement"
                        }
                    },
                    "return": "Promise<HTMLTextAreaElement>"
                },
                "docs": {
                    "text": "Get the native textarea element.",
                    "tags": []
                }
            },
            "focusInput": {
                "complexType": {
                    "signature": "() => Promise<void>",
                    "parameters": [],
                    "references": {
                        "Promise": {
                            "location": "global",
                            "id": "global::Promise"
                        }
                    },
                    "return": "Promise<void>"
                },
                "docs": {
                    "text": "Focuses the input field",
                    "tags": []
                }
            }
        };
    }
    static get elementRef() { return "hostElement"; }
    static get attachInternalsMemberName() { return "formInternals"; }
}
__decorate([
    HookValidationLifecycle()
], Textarea.prototype, "updateClassMappings", null);
//# sourceMappingURL=textarea.js.map
