/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @slot custom-value - Optional custom value at key value instead of text value
 *
 * @since 1.6.0
 */
export class KeyValue {
    constructor() {
        this.icon = undefined;
        this.label = undefined;
        this.labelPosition = 'top';
        this.value = undefined;
    }
    render() {
        return (h(Host, { key: '44e8dc174bc1098bbb777be9e35a09a5d4590c0a', class: `keyValue keyValue--${this.labelPosition === 'top' ? 'column' : 'row'}` }, this.icon && (h("ix-icon", { key: 'f1aa9eddfeeb2abca0865660bfa86fbf57fa9e45', name: this.icon, size: "24", class: "keyValue__icon" })), h("div", { key: '09373c9da3a2554872e7c4de98f622c12ae29d2d', class: "keyValue__content" }, h("div", { key: 'ac0959a100949b8cc4c277ff94597f334a980437', class: "content__label" }, this.label), h("div", { key: 'e9ae9c4098d307801376b4e341ba9c42d806e106', class: {
                content__value: true,
                'has-customValue': this.value === undefined,
            } }, this.value !== undefined ? (this.value) : (h("slot", { name: "custom-value" }))))));
    }
    static get is() { return "ix-key-value"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["key-value.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["key-value.css"]
        };
    }
    static get properties() {
        return {
            "icon": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value icon"
                },
                "attribute": "icon",
                "reflect": false
            },
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": true,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Key value label"
                },
                "attribute": "label",
                "reflect": false
            },
            "labelPosition": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "KeyValueLabelPosition",
                    "resolved": "\"left\" | \"top\"",
                    "references": {
                        "KeyValueLabelPosition": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/key-value/key-value.tsx",
                            "id": "src/components/key-value/key-value.tsx::KeyValueLabelPosition"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value label position - 'top' or 'left'"
                },
                "attribute": "label-position",
                "reflect": false,
                "defaultValue": "'top'"
            },
            "value": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Optional key value text value"
                },
                "attribute": "value",
                "reflect": false
            }
        };
    }
}
//# sourceMappingURL=key-value.js.map
