/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 2.0.0
 */
export class LinkButton {
    constructor() {
        this.disabled = false;
        this.url = undefined;
        this.target = '_self';
    }
    render() {
        return (h(Host, { key: '599582323c6ca9cfdbc9079e94ccac90dc42f87e' }, h("a", { key: '26a781d9d710fa6d3e16a00c9319d7007e4751ef', title: this.url, tabindex: "0", class: {
                'link-button': true,
                disabled: this.disabled,
            }, href: this.disabled ? undefined : this.url, target: this.target }, h("ix-icon", { key: '58de8c25f49ff1d186e9c9b6329bbb3f8ca1c09f', class: "icon", name: 'chevron-right-small', size: "16" }), h("div", { key: 'd07d29e4a52ff43c71cf521c1db445a53e98de8f', class: {
                link: true,
                disabled: this.disabled,
            } }, h("slot", { key: 'ab9c2a95cf9f71c3227e9bca068d49124bd5dd8b' })))));
    }
    static get is() { return "ix-link-button"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["link-button.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["link-button.css"]
        };
    }
    static get properties() {
        return {
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disable the link button"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "url": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Url for the link button"
                },
                "attribute": "url",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'_self' | '_blank' | '_parent' | '_top'",
                    "resolved": "\"_blank\" | \"_parent\" | \"_self\" | \"_top\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specifies where to open the link\n\nhttps://www.w3schools.com/html/html_links.asp"
                },
                "attribute": "target",
                "reflect": false,
                "defaultValue": "'_self'"
            }
        };
    }
}
//# sourceMappingURL=link-button.js.map
